<?php
/**
 * Prepayment
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  Xero2\Accounting
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Accounting API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.8.0
 * Contact: api@xero.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Xero2\Accounting\Model;

use \ArrayAccess;
use \Xero2\Accounting\ObjectSerializer;

/**
 * Prepayment Class Doc Comment
 *
 * @category Class
 * @package  Xero2\Accounting
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class Prepayment implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Prepayment';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'type' => 'string',
        'contact' => '\Xero2\Accounting\Model\Contact',
        'date' => 'string',
        'status' => 'string',
        'line_amount_types' => '\Xero2\Accounting\Model\LineAmountTypes',
        'line_items' => '\Xero2\Accounting\Model\LineItem[]',
        'sub_total' => 'double',
        'total_tax' => 'double',
        'total' => 'double',
        'reference' => 'string',
        'updated_date_utc' => 'string',
        'currency_code' => '\Xero2\Accounting\Model\CurrencyCode',
        'prepayment_id' => 'string',
        'currency_rate' => 'double',
        'remaining_credit' => 'double',
        'allocations' => '\Xero2\Accounting\Model\Allocation[]',
        'applied_amount' => 'double',
        'has_attachments' => 'bool',
        'attachments' => '\Xero2\Accounting\Model\Attachment[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'type' => null,
        'contact' => null,
        'date' => null,
        'status' => null,
        'line_amount_types' => null,
        'line_items' => null,
        'sub_total' => 'double',
        'total_tax' => 'double',
        'total' => 'double',
        'reference' => null,
        'updated_date_utc' => null,
        'currency_code' => null,
        'prepayment_id' => 'uuid',
        'currency_rate' => 'double',
        'remaining_credit' => 'double',
        'allocations' => null,
        'applied_amount' => 'double',
        'has_attachments' => null,
        'attachments' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'type' => 'Type',
        'contact' => 'Contact',
        'date' => 'Date',
        'status' => 'Status',
        'line_amount_types' => 'LineAmountTypes',
        'line_items' => 'LineItems',
        'sub_total' => 'SubTotal',
        'total_tax' => 'TotalTax',
        'total' => 'Total',
        'reference' => 'Reference',
        'updated_date_utc' => 'UpdatedDateUTC',
        'currency_code' => 'CurrencyCode',
        'prepayment_id' => 'PrepaymentID',
        'currency_rate' => 'CurrencyRate',
        'remaining_credit' => 'RemainingCredit',
        'allocations' => 'Allocations',
        'applied_amount' => 'AppliedAmount',
        'has_attachments' => 'HasAttachments',
        'attachments' => 'Attachments'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'type' => 'setType',
        'contact' => 'setContact',
        'date' => 'setDate',
        'status' => 'setStatus',
        'line_amount_types' => 'setLineAmountTypes',
        'line_items' => 'setLineItems',
        'sub_total' => 'setSubTotal',
        'total_tax' => 'setTotalTax',
        'total' => 'setTotal',
        'reference' => 'setReference',
        'updated_date_utc' => 'setUpdatedDateUtc',
        'currency_code' => 'setCurrencyCode',
        'prepayment_id' => 'setPrepaymentId',
        'currency_rate' => 'setCurrencyRate',
        'remaining_credit' => 'setRemainingCredit',
        'allocations' => 'setAllocations',
        'applied_amount' => 'setAppliedAmount',
        'has_attachments' => 'setHasAttachments',
        'attachments' => 'setAttachments'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'type' => 'getType',
        'contact' => 'getContact',
        'date' => 'getDate',
        'status' => 'getStatus',
        'line_amount_types' => 'getLineAmountTypes',
        'line_items' => 'getLineItems',
        'sub_total' => 'getSubTotal',
        'total_tax' => 'getTotalTax',
        'total' => 'getTotal',
        'reference' => 'getReference',
        'updated_date_utc' => 'getUpdatedDateUtc',
        'currency_code' => 'getCurrencyCode',
        'prepayment_id' => 'getPrepaymentId',
        'currency_rate' => 'getCurrencyRate',
        'remaining_credit' => 'getRemainingCredit',
        'allocations' => 'getAllocations',
        'applied_amount' => 'getAppliedAmount',
        'has_attachments' => 'getHasAttachments',
        'attachments' => 'getAttachments'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    const TYPE_RECEIVE_PREPAYMENT = 'RECEIVE-PREPAYMENT';
    const TYPE_SPEND_PREPAYMENT = 'SPEND-PREPAYMENT';
    const TYPE_ARPREPAYMENT = 'ARPREPAYMENT';
    const TYPE_APPREPAYMENT = 'APPREPAYMENT';
    const STATUS_AUTHORISED = 'AUTHORISED';
    const STATUS_PAID = 'PAID';
    const STATUS_VOIDED = 'VOIDED';
    

    
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_RECEIVE_PREPAYMENT,
            self::TYPE_SPEND_PREPAYMENT,
            self::TYPE_ARPREPAYMENT,
            self::TYPE_APPREPAYMENT,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_AUTHORISED,
            self::STATUS_PAID,
            self::STATUS_VOIDED,
        ];
    }
    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['type'] = $data['type'] ?? null;
        $this->container['contact'] = $data['contact'] ?? null;
        $this->container['date'] = $data['date'] ?? null;
        $this->container['status'] = $data['status'] ?? null;
        $this->container['line_amount_types'] = $data['line_amount_types'] ?? null;
        $this->container['line_items'] = $data['line_items'] ?? null;
        $this->container['sub_total'] = $data['sub_total'] ?? null;
        $this->container['total_tax'] = $data['total_tax'] ?? null;
        $this->container['total'] = $data['total'] ?? null;
        $this->container['reference'] = $data['reference'] ?? null;
        $this->container['updated_date_utc'] = $data['updated_date_utc'] ?? null;
        $this->container['currency_code'] = $data['currency_code'] ?? null;
        $this->container['prepayment_id'] = $data['prepayment_id'] ?? null;
        $this->container['currency_rate'] = $data['currency_rate'] ?? null;
        $this->container['remaining_credit'] = $data['remaining_credit'] ?? null;
        $this->container['allocations'] = $data['allocations'] ?? null;
        $this->container['applied_amount'] = $data['applied_amount'] ?? null;
        $this->container['has_attachments'] = $data['has_attachments'] ?? false;
        $this->container['attachments'] = $data['attachments'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getTypeAllowableValues();
        if (!is_null($this->container['type']) && !in_array($this->container['type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'type', must be one of '%s'",
                $this->container['type'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getStatusAllowableValues();
        if (!is_null($this->container['status']) && !in_array($this->container['status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'status', must be one of '%s'",
                $this->container['status'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type See Prepayment Types
     *
     * @return self
     */
    public function setType($type)
    {
        $allowedValues = $this->getTypeAllowableValues();
        if (!is_null($type) && !in_array($type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'type', must be one of '%s'",
                    $type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets contact
     *
     * @return \Xero2\Accounting\Model\Contact|null
     */
    public function getContact()
    {
        return $this->container['contact'];
    }

    /**
     * Sets contact
     *
     * @param \Xero2\Accounting\Model\Contact|null $contact contact
     *
     * @return self
     */
    public function setContact($contact)
    {
        $this->container['contact'] = $contact;

        return $this;
    }

    /**
     * Gets date
     *
     * @return string|null
     */
    public function getDate()
    {
        return $this->container['date'];
    }

    /**
     * Sets date
     *
     * @param string|null $date The date the prepayment is created YYYY-MM-DD
     *
     * @return self
     */
    public function setDate($date)
    {
        $this->container['date'] = $date;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status See Prepayment Status Codes
     *
     * @return self
     */
    public function setStatus($status)
    {
        $allowedValues = $this->getStatusAllowableValues();
        if (!is_null($status) && !in_array($status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'status', must be one of '%s'",
                    $status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets line_amount_types
     *
     * @return \Xero2\Accounting\Model\LineAmountTypes|null
     */
    public function getLineAmountTypes()
    {
        return $this->container['line_amount_types'];
    }

    /**
     * Sets line_amount_types
     *
     * @param \Xero2\Accounting\Model\LineAmountTypes|null $line_amount_types line_amount_types
     *
     * @return self
     */
    public function setLineAmountTypes($line_amount_types)
    {
        $this->container['line_amount_types'] = $line_amount_types;

        return $this;
    }

    /**
     * Gets line_items
     *
     * @return \Xero2\Accounting\Model\LineItem[]|null
     */
    public function getLineItems()
    {
        return $this->container['line_items'];
    }

    /**
     * Sets line_items
     *
     * @param \Xero2\Accounting\Model\LineItem[]|null $line_items See Prepayment Line Items
     *
     * @return self
     */
    public function setLineItems($line_items)
    {
        $this->container['line_items'] = $line_items;

        return $this;
    }

    /**
     * Gets sub_total
     *
     * @return double|null
     */
    public function getSubTotal()
    {
        return $this->container['sub_total'];
    }

    /**
     * Sets sub_total
     *
     * @param double|null $sub_total The subtotal of the prepayment excluding taxes
     *
     * @return self
     */
    public function setSubTotal($sub_total)
    {
        $this->container['sub_total'] = $sub_total;

        return $this;
    }

    /**
     * Gets total_tax
     *
     * @return double|null
     */
    public function getTotalTax()
    {
        return $this->container['total_tax'];
    }

    /**
     * Sets total_tax
     *
     * @param double|null $total_tax The total tax on the prepayment
     *
     * @return self
     */
    public function setTotalTax($total_tax)
    {
        $this->container['total_tax'] = $total_tax;

        return $this;
    }

    /**
     * Gets total
     *
     * @return double|null
     */
    public function getTotal()
    {
        return $this->container['total'];
    }

    /**
     * Sets total
     *
     * @param double|null $total The total of the prepayment(subtotal + total tax)
     *
     * @return self
     */
    public function setTotal($total)
    {
        $this->container['total'] = $total;

        return $this;
    }

    /**
     * Gets reference
     *
     * @return string|null
     */
    public function getReference()
    {
        return $this->container['reference'];
    }

    /**
     * Sets reference
     *
     * @param string|null $reference Returns Invoice number field. Reference field isn't available.
     *
     * @return self
     */
    public function setReference($reference)
    {
        $this->container['reference'] = $reference;

        return $this;
    }

    /**
     * Gets updated_date_utc
     *
     * @return string|null
     */
    public function getUpdatedDateUtc()
    {
        return $this->container['updated_date_utc'];
    }

    /**
     * Sets updated_date_utc
     *
     * @param string|null $updated_date_utc UTC timestamp of last update to the prepayment
     *
     * @return self
     */
    public function setUpdatedDateUtc($updated_date_utc)
    {
        $this->container['updated_date_utc'] = $updated_date_utc;

        return $this;
    }

    /**
     * Gets currency_code
     *
     * @return \Xero2\Accounting\Model\CurrencyCode|null
     */
    public function getCurrencyCode()
    {
        return $this->container['currency_code'];
    }

    /**
     * Sets currency_code
     *
     * @param \Xero2\Accounting\Model\CurrencyCode|null $currency_code currency_code
     *
     * @return self
     */
    public function setCurrencyCode($currency_code)
    {
        $this->container['currency_code'] = $currency_code;

        return $this;
    }

    /**
     * Gets prepayment_id
     *
     * @return string|null
     */
    public function getPrepaymentId()
    {
        return $this->container['prepayment_id'];
    }

    /**
     * Sets prepayment_id
     *
     * @param string|null $prepayment_id Xero generated unique identifier
     *
     * @return self
     */
    public function setPrepaymentId($prepayment_id)
    {
        $this->container['prepayment_id'] = $prepayment_id;

        return $this;
    }

    /**
     * Gets currency_rate
     *
     * @return double|null
     */
    public function getCurrencyRate()
    {
        return $this->container['currency_rate'];
    }

    /**
     * Sets currency_rate
     *
     * @param double|null $currency_rate The currency rate for a multicurrency prepayment. If no rate is specified, the XE.com day rate is used
     *
     * @return self
     */
    public function setCurrencyRate($currency_rate)
    {
        $this->container['currency_rate'] = $currency_rate;

        return $this;
    }

    /**
     * Gets remaining_credit
     *
     * @return double|null
     */
    public function getRemainingCredit()
    {
        return $this->container['remaining_credit'];
    }

    /**
     * Sets remaining_credit
     *
     * @param double|null $remaining_credit The remaining credit balance on the prepayment
     *
     * @return self
     */
    public function setRemainingCredit($remaining_credit)
    {
        $this->container['remaining_credit'] = $remaining_credit;

        return $this;
    }

    /**
     * Gets allocations
     *
     * @return \Xero2\Accounting\Model\Allocation[]|null
     */
    public function getAllocations()
    {
        return $this->container['allocations'];
    }

    /**
     * Sets allocations
     *
     * @param \Xero2\Accounting\Model\Allocation[]|null $allocations See Allocations
     *
     * @return self
     */
    public function setAllocations($allocations)
    {
        $this->container['allocations'] = $allocations;

        return $this;
    }

    /**
     * Gets applied_amount
     *
     * @return double|null
     */
    public function getAppliedAmount()
    {
        return $this->container['applied_amount'];
    }

    /**
     * Sets applied_amount
     *
     * @param double|null $applied_amount The amount of applied to an invoice
     *
     * @return self
     */
    public function setAppliedAmount($applied_amount)
    {
        $this->container['applied_amount'] = $applied_amount;

        return $this;
    }

    /**
     * Gets has_attachments
     *
     * @return bool|null
     */
    public function getHasAttachments()
    {
        return $this->container['has_attachments'];
    }

    /**
     * Sets has_attachments
     *
     * @param bool|null $has_attachments boolean to indicate if a prepayment has an attachment
     *
     * @return self
     */
    public function setHasAttachments($has_attachments)
    {
        $this->container['has_attachments'] = $has_attachments;

        return $this;
    }

    /**
     * Gets attachments
     *
     * @return \Xero2\Accounting\Model\Attachment[]|null
     */
    public function getAttachments()
    {
        return $this->container['attachments'];
    }

    /**
     * Sets attachments
     *
     * @param \Xero2\Accounting\Model\Attachment[]|null $attachments See Attachments
     *
     * @return self
     */
    public function setAttachments($attachments)
    {
        $this->container['attachments'] = $attachments;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


