<?php
/**
 * Journal
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  Xero2\Accounting
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Accounting API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.8.0
 * Contact: api@xero.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Xero2\Accounting\Model;

use \ArrayAccess;
use \Xero2\Accounting\ObjectSerializer;

/**
 * Journal Class Doc Comment
 *
 * @category Class
 * @package  Xero2\Accounting
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class Journal implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Journal';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'journal_id' => 'string',
        'journal_date' => 'string',
        'journal_number' => 'int',
        'created_date_utc' => 'string',
        'reference' => 'string',
        'source_id' => 'string',
        'source_type' => 'string',
        'journal_lines' => '\Xero2\Accounting\Model\JournalLine[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'journal_id' => 'uuid',
        'journal_date' => null,
        'journal_number' => null,
        'created_date_utc' => null,
        'reference' => null,
        'source_id' => 'uuid',
        'source_type' => null,
        'journal_lines' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'journal_id' => 'JournalID',
        'journal_date' => 'JournalDate',
        'journal_number' => 'JournalNumber',
        'created_date_utc' => 'CreatedDateUTC',
        'reference' => 'Reference',
        'source_id' => 'SourceID',
        'source_type' => 'SourceType',
        'journal_lines' => 'JournalLines'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'journal_id' => 'setJournalId',
        'journal_date' => 'setJournalDate',
        'journal_number' => 'setJournalNumber',
        'created_date_utc' => 'setCreatedDateUtc',
        'reference' => 'setReference',
        'source_id' => 'setSourceId',
        'source_type' => 'setSourceType',
        'journal_lines' => 'setJournalLines'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'journal_id' => 'getJournalId',
        'journal_date' => 'getJournalDate',
        'journal_number' => 'getJournalNumber',
        'created_date_utc' => 'getCreatedDateUtc',
        'reference' => 'getReference',
        'source_id' => 'getSourceId',
        'source_type' => 'getSourceType',
        'journal_lines' => 'getJournalLines'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    const SOURCE_TYPE_ACCREC = 'ACCREC';
    const SOURCE_TYPE_ACCPAY = 'ACCPAY';
    const SOURCE_TYPE_ACCRECCREDIT = 'ACCRECCREDIT';
    const SOURCE_TYPE_ACCPAYCREDIT = 'ACCPAYCREDIT';
    const SOURCE_TYPE_ACCRECPAYMENT = 'ACCRECPAYMENT';
    const SOURCE_TYPE_ACCPAYPAYMENT = 'ACCPAYPAYMENT';
    const SOURCE_TYPE_ARCREDITPAYMENT = 'ARCREDITPAYMENT';
    const SOURCE_TYPE_APCREDITPAYMENT = 'APCREDITPAYMENT';
    const SOURCE_TYPE_CASHREC = 'CASHREC';
    const SOURCE_TYPE_CASHPAID = 'CASHPAID';
    const SOURCE_TYPE_TRANSFER = 'TRANSFER';
    const SOURCE_TYPE_ARPREPAYMENT = 'ARPREPAYMENT';
    const SOURCE_TYPE_APPREPAYMENT = 'APPREPAYMENT';
    const SOURCE_TYPE_AROVERPAYMENT = 'AROVERPAYMENT';
    const SOURCE_TYPE_APOVERPAYMENT = 'APOVERPAYMENT';
    const SOURCE_TYPE_EXPCLAIM = 'EXPCLAIM';
    const SOURCE_TYPE_EXPPAYMENT = 'EXPPAYMENT';
    const SOURCE_TYPE_MANJOURNAL = 'MANJOURNAL';
    const SOURCE_TYPE_PAYSLIP = 'PAYSLIP';
    const SOURCE_TYPE_WAGEPAYABLE = 'WAGEPAYABLE';
    const SOURCE_TYPE_INTEGRATEDPAYROLLPE = 'INTEGRATEDPAYROLLPE';
    const SOURCE_TYPE_INTEGRATEDPAYROLLPT = 'INTEGRATEDPAYROLLPT';
    const SOURCE_TYPE_EXTERNALSPENDMONEY = 'EXTERNALSPENDMONEY';
    const SOURCE_TYPE_INTEGRATEDPAYROLLPTPAYMENT = 'INTEGRATEDPAYROLLPTPAYMENT';
    const SOURCE_TYPE_INTEGRATEDPAYROLLCN = 'INTEGRATEDPAYROLLCN';
    

    
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getSourceTypeAllowableValues()
    {
        return [
            self::SOURCE_TYPE_ACCREC,
            self::SOURCE_TYPE_ACCPAY,
            self::SOURCE_TYPE_ACCRECCREDIT,
            self::SOURCE_TYPE_ACCPAYCREDIT,
            self::SOURCE_TYPE_ACCRECPAYMENT,
            self::SOURCE_TYPE_ACCPAYPAYMENT,
            self::SOURCE_TYPE_ARCREDITPAYMENT,
            self::SOURCE_TYPE_APCREDITPAYMENT,
            self::SOURCE_TYPE_CASHREC,
            self::SOURCE_TYPE_CASHPAID,
            self::SOURCE_TYPE_TRANSFER,
            self::SOURCE_TYPE_ARPREPAYMENT,
            self::SOURCE_TYPE_APPREPAYMENT,
            self::SOURCE_TYPE_AROVERPAYMENT,
            self::SOURCE_TYPE_APOVERPAYMENT,
            self::SOURCE_TYPE_EXPCLAIM,
            self::SOURCE_TYPE_EXPPAYMENT,
            self::SOURCE_TYPE_MANJOURNAL,
            self::SOURCE_TYPE_PAYSLIP,
            self::SOURCE_TYPE_WAGEPAYABLE,
            self::SOURCE_TYPE_INTEGRATEDPAYROLLPE,
            self::SOURCE_TYPE_INTEGRATEDPAYROLLPT,
            self::SOURCE_TYPE_EXTERNALSPENDMONEY,
            self::SOURCE_TYPE_INTEGRATEDPAYROLLPTPAYMENT,
            self::SOURCE_TYPE_INTEGRATEDPAYROLLCN,
        ];
    }
    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['journal_id'] = $data['journal_id'] ?? null;
        $this->container['journal_date'] = $data['journal_date'] ?? null;
        $this->container['journal_number'] = $data['journal_number'] ?? null;
        $this->container['created_date_utc'] = $data['created_date_utc'] ?? null;
        $this->container['reference'] = $data['reference'] ?? null;
        $this->container['source_id'] = $data['source_id'] ?? null;
        $this->container['source_type'] = $data['source_type'] ?? null;
        $this->container['journal_lines'] = $data['journal_lines'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getSourceTypeAllowableValues();
        if (!is_null($this->container['source_type']) && !in_array($this->container['source_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'source_type', must be one of '%s'",
                $this->container['source_type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets journal_id
     *
     * @return string|null
     */
    public function getJournalId()
    {
        return $this->container['journal_id'];
    }

    /**
     * Sets journal_id
     *
     * @param string|null $journal_id Xero identifier
     *
     * @return self
     */
    public function setJournalId($journal_id)
    {
        $this->container['journal_id'] = $journal_id;

        return $this;
    }

    /**
     * Gets journal_date
     *
     * @return string|null
     */
    public function getJournalDate()
    {
        return $this->container['journal_date'];
    }

    /**
     * Sets journal_date
     *
     * @param string|null $journal_date Date the journal was posted
     *
     * @return self
     */
    public function setJournalDate($journal_date)
    {
        $this->container['journal_date'] = $journal_date;

        return $this;
    }

    /**
     * Gets journal_number
     *
     * @return int|null
     */
    public function getJournalNumber()
    {
        return $this->container['journal_number'];
    }

    /**
     * Sets journal_number
     *
     * @param int|null $journal_number Xero generated journal number
     *
     * @return self
     */
    public function setJournalNumber($journal_number)
    {
        $this->container['journal_number'] = $journal_number;

        return $this;
    }

    /**
     * Gets created_date_utc
     *
     * @return string|null
     */
    public function getCreatedDateUtc()
    {
        return $this->container['created_date_utc'];
    }

    /**
     * Sets created_date_utc
     *
     * @param string|null $created_date_utc Created date UTC format
     *
     * @return self
     */
    public function setCreatedDateUtc($created_date_utc)
    {
        $this->container['created_date_utc'] = $created_date_utc;

        return $this;
    }

    /**
     * Gets reference
     *
     * @return string|null
     */
    public function getReference()
    {
        return $this->container['reference'];
    }

    /**
     * Sets reference
     *
     * @param string|null $reference reference field for additional indetifying information
     *
     * @return self
     */
    public function setReference($reference)
    {
        $this->container['reference'] = $reference;

        return $this;
    }

    /**
     * Gets source_id
     *
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->container['source_id'];
    }

    /**
     * Sets source_id
     *
     * @param string|null $source_id The identifier for the source transaction (e.g. InvoiceID)
     *
     * @return self
     */
    public function setSourceId($source_id)
    {
        $this->container['source_id'] = $source_id;

        return $this;
    }

    /**
     * Gets source_type
     *
     * @return string|null
     */
    public function getSourceType()
    {
        return $this->container['source_type'];
    }

    /**
     * Sets source_type
     *
     * @param string|null $source_type The journal source type. The type of transaction that created the journal
     *
     * @return self
     */
    public function setSourceType($source_type)
    {
        $allowedValues = $this->getSourceTypeAllowableValues();
        if (!is_null($source_type) && !in_array($source_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'source_type', must be one of '%s'",
                    $source_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['source_type'] = $source_type;

        return $this;
    }

    /**
     * Gets journal_lines
     *
     * @return \Xero2\Accounting\Model\JournalLine[]|null
     */
    public function getJournalLines()
    {
        return $this->container['journal_lines'];
    }

    /**
     * Sets journal_lines
     *
     * @param \Xero2\Accounting\Model\JournalLine[]|null $journal_lines See JournalLines
     *
     * @return self
     */
    public function setJournalLines($journal_lines)
    {
        $this->container['journal_lines'] = $journal_lines;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


