<?php
/**
 * ExpenseClaim
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  Xero2\Accounting
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Accounting API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.8.0
 * Contact: api@xero.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Xero2\Accounting\Model;

use \ArrayAccess;
use \Xero2\Accounting\ObjectSerializer;

/**
 * ExpenseClaim Class Doc Comment
 *
 * @category Class
 * @package  Xero2\Accounting
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class ExpenseClaim implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ExpenseClaim';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'expense_claim_id' => 'string',
        'status' => 'string',
        'payments' => '\Xero2\Accounting\Model\Payment[]',
        'user' => '\Xero2\Accounting\Model\User',
        'receipts' => '\Xero2\Accounting\Model\Receipt[]',
        'updated_date_utc' => 'string',
        'total' => 'double',
        'amount_due' => 'double',
        'amount_paid' => 'double',
        'payment_due_date' => 'string',
        'reporting_date' => 'string',
        'receipt_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'expense_claim_id' => 'uuid',
        'status' => null,
        'payments' => null,
        'user' => null,
        'receipts' => null,
        'updated_date_utc' => null,
        'total' => 'double',
        'amount_due' => 'double',
        'amount_paid' => 'double',
        'payment_due_date' => null,
        'reporting_date' => null,
        'receipt_id' => 'uuid'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'expense_claim_id' => 'ExpenseClaimID',
        'status' => 'Status',
        'payments' => 'Payments',
        'user' => 'User',
        'receipts' => 'Receipts',
        'updated_date_utc' => 'UpdatedDateUTC',
        'total' => 'Total',
        'amount_due' => 'AmountDue',
        'amount_paid' => 'AmountPaid',
        'payment_due_date' => 'PaymentDueDate',
        'reporting_date' => 'ReportingDate',
        'receipt_id' => 'ReceiptID'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'expense_claim_id' => 'setExpenseClaimId',
        'status' => 'setStatus',
        'payments' => 'setPayments',
        'user' => 'setUser',
        'receipts' => 'setReceipts',
        'updated_date_utc' => 'setUpdatedDateUtc',
        'total' => 'setTotal',
        'amount_due' => 'setAmountDue',
        'amount_paid' => 'setAmountPaid',
        'payment_due_date' => 'setPaymentDueDate',
        'reporting_date' => 'setReportingDate',
        'receipt_id' => 'setReceiptId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'expense_claim_id' => 'getExpenseClaimId',
        'status' => 'getStatus',
        'payments' => 'getPayments',
        'user' => 'getUser',
        'receipts' => 'getReceipts',
        'updated_date_utc' => 'getUpdatedDateUtc',
        'total' => 'getTotal',
        'amount_due' => 'getAmountDue',
        'amount_paid' => 'getAmountPaid',
        'payment_due_date' => 'getPaymentDueDate',
        'reporting_date' => 'getReportingDate',
        'receipt_id' => 'getReceiptId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    const STATUS_SUBMITTED = 'SUBMITTED';
    const STATUS_AUTHORISED = 'AUTHORISED';
    const STATUS_PAID = 'PAID';
    const STATUS_VOIDED = 'VOIDED';
    const STATUS_DELETED = 'DELETED';
    

    
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_SUBMITTED,
            self::STATUS_AUTHORISED,
            self::STATUS_PAID,
            self::STATUS_VOIDED,
            self::STATUS_DELETED,
        ];
    }
    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['expense_claim_id'] = $data['expense_claim_id'] ?? null;
        $this->container['status'] = $data['status'] ?? null;
        $this->container['payments'] = $data['payments'] ?? null;
        $this->container['user'] = $data['user'] ?? null;
        $this->container['receipts'] = $data['receipts'] ?? null;
        $this->container['updated_date_utc'] = $data['updated_date_utc'] ?? null;
        $this->container['total'] = $data['total'] ?? null;
        $this->container['amount_due'] = $data['amount_due'] ?? null;
        $this->container['amount_paid'] = $data['amount_paid'] ?? null;
        $this->container['payment_due_date'] = $data['payment_due_date'] ?? null;
        $this->container['reporting_date'] = $data['reporting_date'] ?? null;
        $this->container['receipt_id'] = $data['receipt_id'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getStatusAllowableValues();
        if (!is_null($this->container['status']) && !in_array($this->container['status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'status', must be one of '%s'",
                $this->container['status'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets expense_claim_id
     *
     * @return string|null
     */
    public function getExpenseClaimId()
    {
        return $this->container['expense_claim_id'];
    }

    /**
     * Sets expense_claim_id
     *
     * @param string|null $expense_claim_id Xero generated unique identifier for an expense claim
     *
     * @return self
     */
    public function setExpenseClaimId($expense_claim_id)
    {
        $this->container['expense_claim_id'] = $expense_claim_id;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status Current status of an expense claim – see status types
     *
     * @return self
     */
    public function setStatus($status)
    {
        $allowedValues = $this->getStatusAllowableValues();
        if (!is_null($status) && !in_array($status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'status', must be one of '%s'",
                    $status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets payments
     *
     * @return \Xero2\Accounting\Model\Payment[]|null
     */
    public function getPayments()
    {
        return $this->container['payments'];
    }

    /**
     * Sets payments
     *
     * @param \Xero2\Accounting\Model\Payment[]|null $payments See Payments
     *
     * @return self
     */
    public function setPayments($payments)
    {
        $this->container['payments'] = $payments;

        return $this;
    }

    /**
     * Gets user
     *
     * @return \Xero2\Accounting\Model\User|null
     */
    public function getUser()
    {
        return $this->container['user'];
    }

    /**
     * Sets user
     *
     * @param \Xero2\Accounting\Model\User|null $user user
     *
     * @return self
     */
    public function setUser($user)
    {
        $this->container['user'] = $user;

        return $this;
    }

    /**
     * Gets receipts
     *
     * @return \Xero2\Accounting\Model\Receipt[]|null
     */
    public function getReceipts()
    {
        return $this->container['receipts'];
    }

    /**
     * Sets receipts
     *
     * @param \Xero2\Accounting\Model\Receipt[]|null $receipts receipts
     *
     * @return self
     */
    public function setReceipts($receipts)
    {
        $this->container['receipts'] = $receipts;

        return $this;
    }

    /**
     * Gets updated_date_utc
     *
     * @return string|null
     */
    public function getUpdatedDateUtc()
    {
        return $this->container['updated_date_utc'];
    }

    /**
     * Sets updated_date_utc
     *
     * @param string|null $updated_date_utc Last modified date UTC format
     *
     * @return self
     */
    public function setUpdatedDateUtc($updated_date_utc)
    {
        $this->container['updated_date_utc'] = $updated_date_utc;

        return $this;
    }

    /**
     * Gets total
     *
     * @return double|null
     */
    public function getTotal()
    {
        return $this->container['total'];
    }

    /**
     * Sets total
     *
     * @param double|null $total The total of an expense claim being paid
     *
     * @return self
     */
    public function setTotal($total)
    {
        $this->container['total'] = $total;

        return $this;
    }

    /**
     * Gets amount_due
     *
     * @return double|null
     */
    public function getAmountDue()
    {
        return $this->container['amount_due'];
    }

    /**
     * Sets amount_due
     *
     * @param double|null $amount_due The amount due to be paid for an expense claim
     *
     * @return self
     */
    public function setAmountDue($amount_due)
    {
        $this->container['amount_due'] = $amount_due;

        return $this;
    }

    /**
     * Gets amount_paid
     *
     * @return double|null
     */
    public function getAmountPaid()
    {
        return $this->container['amount_paid'];
    }

    /**
     * Sets amount_paid
     *
     * @param double|null $amount_paid The amount still to pay for an expense claim
     *
     * @return self
     */
    public function setAmountPaid($amount_paid)
    {
        $this->container['amount_paid'] = $amount_paid;

        return $this;
    }

    /**
     * Gets payment_due_date
     *
     * @return string|null
     */
    public function getPaymentDueDate()
    {
        return $this->container['payment_due_date'];
    }

    /**
     * Sets payment_due_date
     *
     * @param string|null $payment_due_date The date when the expense claim is due to be paid YYYY-MM-DD
     *
     * @return self
     */
    public function setPaymentDueDate($payment_due_date)
    {
        $this->container['payment_due_date'] = $payment_due_date;

        return $this;
    }

    /**
     * Gets reporting_date
     *
     * @return string|null
     */
    public function getReportingDate()
    {
        return $this->container['reporting_date'];
    }

    /**
     * Sets reporting_date
     *
     * @param string|null $reporting_date The date the expense claim will be reported in Xero YYYY-MM-DD
     *
     * @return self
     */
    public function setReportingDate($reporting_date)
    {
        $this->container['reporting_date'] = $reporting_date;

        return $this;
    }

    /**
     * Gets receipt_id
     *
     * @return string|null
     */
    public function getReceiptId()
    {
        return $this->container['receipt_id'];
    }

    /**
     * Sets receipt_id
     *
     * @param string|null $receipt_id The Xero identifier for the Receipt e.g. e59a2c7f-1306-4078-a0f3-73537afcbba9
     *
     * @return self
     */
    public function setReceiptId($receipt_id)
    {
        $this->container['receipt_id'] = $receipt_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


