<?php

namespace Xero2;

use League\OAuth2\Client\OptionProvider\HttpBasicAuthOptionProvider;
use League\OAuth2\Client\Provider\AbstractProvider;
use League\OAuth2\Client\Provider\Exception\IdentityProviderException;
use League\OAuth2\Client\Token\AccessToken;
use League\OAuth2\Client\Tool\BearerAuthorizationTrait;
use Psr\Http\Message\ResponseInterface;

/**
 * Copyright Talisman Innovations Ltd. (2019). All rights reserved.
 */

class XeroProvider extends AbstractProvider
{
    use BearerAuthorizationTrait;

    public function __construct(array $options = [], array $collaborators = [])
    {
        if (empty($collaborators['optionProvider'])) {
            $collaborators['optionProvider'] = new HttpBasicAuthOptionProvider();
        }
        parent::__construct($options, $collaborators);
    }

    /**
     * @inheritDoc
     */
    public function getBaseAuthorizationUrl()
    {
        return 'https://login.xero.com/identity/connect/authorize';
    }

    /**
     * @inheritDoc
     */
    public function getBaseAccessTokenUrl(array $params)
    {
        return 'https://identity.xero.com/connect/token';
    }

    /**
     * @inheritDoc
     */
    public function getResourceOwnerDetailsUrl(AccessToken $token)
    {
        return 'https://api.xero.com/api.xro/2.0/Organisation';
    }

    /**
     * @inheritDoc
     */
    public function getDefaultScopes()
    {
        return [
            'offline_access',
            'accounting.transactions',
            'accounting.settings.read'
        ];
    }

    /**
     * @inheritDoc
     */
    protected function getScopeSeparator()
    {
        return ' ';
    }


    /**
     * @inheritDoc
     */
    protected function checkResponse(ResponseInterface $response, $data)
    {
        if (!empty($data['error'])) {
            throw new IdentityProviderException($data['error'], 0, $data);
        }

        if ($this->state && !empty($data['state']) && $data['state'] !== $this->state) {
            throw new IdentityProviderException('State does not match', 0, $data);
        }
    }

    /**
     * @inheritDoc
     */
    protected function createResourceOwner(array $response, AccessToken $token)
    {
    }
}