# # Quote

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**quote_id** | **string** | QuoteID GUID is automatically generated and is returned after create or GET. | [optional] 
**quote_number** | **string** | Unique alpha numeric code identifying a quote (Max Length &#x3D; 255) | [optional] 
**reference** | **string** | Additional reference number | [optional] 
**terms** | **string** | Terms of the quote | [optional] 
**contact** | [**\Xero2\Accounting\Model\Contact**](Contact.md) |  | [optional] 
**line_items** | [**\Xero2\Accounting\Model\LineItem[]**](LineItem.md) | See LineItems | [optional] 
**date** | [**\DateTime**](\DateTime.md) | Date quote was issued – YYYY-MM-DD. If the Date element is not specified it will default to the current date based on the timezone setting of the organisation | [optional] 
**date_string** | **string** | Date the quote was issued (YYYY-MM-DD) | [optional] 
**expiry_date** | [**\DateTime**](\DateTime.md) | Date the quote expires – YYYY-MM-DD. | [optional] 
**expiry_date_string** | **string** | Date the quote expires – YYYY-MM-DD. | [optional] 
**status** | [**\Xero2\Accounting\Model\QuoteStatusCodes**](QuoteStatusCodes.md) |  | [optional] 
**currency_code** | [**\Xero2\Accounting\Model\CurrencyCode**](CurrencyCode.md) |  | [optional] 
**currency_rate** | **double** | The currency rate for a multicurrency quote | [optional] 
**sub_total** | **double** | Total of quote excluding taxes. | [optional] [readonly] 
**total_tax** | **double** | Total tax on quote | [optional] [readonly] 
**total** | **double** | Total of Quote tax inclusive (i.e. SubTotal + TotalTax). This will be ignored if it doesn’t equal the sum of the LineAmounts | [optional] [readonly] 
**total_discount** | **double** | Total of discounts applied on the quote line items | [optional] [readonly] 
**title** | **string** | Title text for the quote | [optional] 
**summary** | **string** | Summary text for the quote | [optional] 
**branding_theme_id** | **string** | See BrandingThemes | [optional] 
**updated_date_utc** | [**\DateTime**](\DateTime.md) | Last modified date UTC format | [optional] [readonly] 
**line_amount_types** | [**\Xero2\Accounting\Model\QuoteLineAmountTypes**](QuoteLineAmountTypes.md) |  | [optional] 

[[Back to Model list]](../../README.md#documentation-for-models) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to README]](../../README.md)


