# OpenAPIClient-php

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.1.6
- Package version: 2.0.0
- Build package: org.openapitools.codegen.languages.PhpClientCodegen
For more information, please visit [https://developer.xero.com](https://developer.xero.com)

## Requirements

PHP 5.5 and later

## Installation & Usage

### Composer

To install the bindings via [Composer](http://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/xero2.git"
    }
  ],
  "require": {
    "talisman/xero2": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
    require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Tests

To run the unit tests:

```bash
composer install
./vendor/bin/phpunit
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure OAuth2 access token for authorization: OAuth2
$config = Xero2\Accounting\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Xero2\Accounting\Api\AccountingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$xero_tenant_id = YOUR_XERO_TENANT_ID; // string | Xero identifier for Tenant
$account = { code: "123456", name: "Foobar", type: AccountType.EXPENSE, description: "Hello World" }; // \Xero2\Accounting\Model\Account | Account object in body of request

try {
    $result = $apiInstance->createAccount($xero_tenant_id, $account);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AccountingApi->createAccount: ', $e->getMessage(), PHP_EOL;
}

?>
```

## Documentation for API Endpoints

All URIs are relative to *https://api.xero.com/api.xro/2.0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountingApi* | [**createAccount**](docs/Api/AccountingApi.md#createaccount) | **PUT** /Accounts | Allows you to create a new chart of accounts
*AccountingApi* | [**createAccountAttachmentByFileName**](docs/Api/AccountingApi.md#createaccountattachmentbyfilename) | **PUT** /Accounts/{AccountID}/Attachments/{FileName} | Allows you to create Attachment on Account
*AccountingApi* | [**createBankTransactionAttachmentByFileName**](docs/Api/AccountingApi.md#createbanktransactionattachmentbyfilename) | **PUT** /BankTransactions/{BankTransactionID}/Attachments/{FileName} | Allows you to createa an Attachment on BankTransaction by Filename
*AccountingApi* | [**createBankTransactionHistoryRecord**](docs/Api/AccountingApi.md#createbanktransactionhistoryrecord) | **PUT** /BankTransactions/{BankTransactionID}/History | Allows you to create history record for a bank transactions
*AccountingApi* | [**createBankTransactions**](docs/Api/AccountingApi.md#createbanktransactions) | **PUT** /BankTransactions | Allows you to create one or more spend or receive money transaction
*AccountingApi* | [**createBankTransfer**](docs/Api/AccountingApi.md#createbanktransfer) | **PUT** /BankTransfers | Allows you to create a bank transfers
*AccountingApi* | [**createBankTransferAttachmentByFileName**](docs/Api/AccountingApi.md#createbanktransferattachmentbyfilename) | **PUT** /BankTransfers/{BankTransferID}/Attachments/{FileName} | 
*AccountingApi* | [**createBankTransferHistoryRecord**](docs/Api/AccountingApi.md#createbanktransferhistoryrecord) | **PUT** /BankTransfers/{BankTransferID}/History | 
*AccountingApi* | [**createBatchPayment**](docs/Api/AccountingApi.md#createbatchpayment) | **PUT** /BatchPayments | Create one or many BatchPayments for invoices
*AccountingApi* | [**createBatchPaymentHistoryRecord**](docs/Api/AccountingApi.md#createbatchpaymenthistoryrecord) | **PUT** /BatchPayments/{BatchPaymentID}/History | Allows you to create a history record for a Batch Payment
*AccountingApi* | [**createBrandingThemePaymentServices**](docs/Api/AccountingApi.md#createbrandingthemepaymentservices) | **POST** /BrandingThemes/{BrandingThemeID}/PaymentServices | Allow for the creation of new custom payment service for specified Branding Theme
*AccountingApi* | [**createContactAttachmentByFileName**](docs/Api/AccountingApi.md#createcontactattachmentbyfilename) | **PUT** /Contacts/{ContactID}/Attachments/{FileName} | 
*AccountingApi* | [**createContactGroup**](docs/Api/AccountingApi.md#createcontactgroup) | **PUT** /ContactGroups | Allows you to create a contact group
*AccountingApi* | [**createContactGroupContacts**](docs/Api/AccountingApi.md#createcontactgroupcontacts) | **PUT** /ContactGroups/{ContactGroupID}/Contacts | Allows you to add Contacts to a Contact Group
*AccountingApi* | [**createContactHistory**](docs/Api/AccountingApi.md#createcontacthistory) | **PUT** /Contacts/{ContactID}/History | Allows you to retrieve a history records of an Contact
*AccountingApi* | [**createContacts**](docs/Api/AccountingApi.md#createcontacts) | **PUT** /Contacts | Allows you to create a multiple contacts (bulk) in a Xero organisation
*AccountingApi* | [**createCreditNoteAllocation**](docs/Api/AccountingApi.md#createcreditnoteallocation) | **PUT** /CreditNotes/{CreditNoteID}/Allocations | Allows you to create Allocation on CreditNote
*AccountingApi* | [**createCreditNoteAttachmentByFileName**](docs/Api/AccountingApi.md#createcreditnoteattachmentbyfilename) | **PUT** /CreditNotes/{CreditNoteID}/Attachments/{FileName} | Allows you to create Attachments on CreditNote by file name
*AccountingApi* | [**createCreditNoteHistory**](docs/Api/AccountingApi.md#createcreditnotehistory) | **PUT** /CreditNotes/{CreditNoteID}/History | Allows you to retrieve a history records of an CreditNote
*AccountingApi* | [**createCreditNotes**](docs/Api/AccountingApi.md#createcreditnotes) | **PUT** /CreditNotes | Allows you to create a credit note
*AccountingApi* | [**createCurrency**](docs/Api/AccountingApi.md#createcurrency) | **PUT** /Currencies | 
*AccountingApi* | [**createEmployees**](docs/Api/AccountingApi.md#createemployees) | **PUT** /Employees | Allows you to create new employees used in Xero payrun
*AccountingApi* | [**createExpenseClaimHistory**](docs/Api/AccountingApi.md#createexpenseclaimhistory) | **PUT** /ExpenseClaims/{ExpenseClaimID}/History | Allows you to create a history records of an ExpenseClaim
*AccountingApi* | [**createExpenseClaims**](docs/Api/AccountingApi.md#createexpenseclaims) | **PUT** /ExpenseClaims | Allows you to retrieve expense claims
*AccountingApi* | [**createInvoiceAttachmentByFileName**](docs/Api/AccountingApi.md#createinvoiceattachmentbyfilename) | **PUT** /Invoices/{InvoiceID}/Attachments/{FileName} | Allows you to create an Attachment on invoices or purchase bills by it&#39;s filename
*AccountingApi* | [**createInvoiceHistory**](docs/Api/AccountingApi.md#createinvoicehistory) | **PUT** /Invoices/{InvoiceID}/History | Allows you to retrieve a history records of an invoice
*AccountingApi* | [**createInvoices**](docs/Api/AccountingApi.md#createinvoices) | **PUT** /Invoices | Allows you to create one or more sales invoices or purchase bills
*AccountingApi* | [**createItemHistory**](docs/Api/AccountingApi.md#createitemhistory) | **PUT** /Items/{ItemID}/History | Allows you to create a history record for items
*AccountingApi* | [**createItems**](docs/Api/AccountingApi.md#createitems) | **PUT** /Items | Allows you to create one or more items
*AccountingApi* | [**createLinkedTransaction**](docs/Api/AccountingApi.md#createlinkedtransaction) | **PUT** /LinkedTransactions | Allows you to create linked transactions (billable expenses)
*AccountingApi* | [**createManualJournalAttachmentByFileName**](docs/Api/AccountingApi.md#createmanualjournalattachmentbyfilename) | **PUT** /ManualJournals/{ManualJournalID}/Attachments/{FileName} | Allows you to create a specified Attachment on ManualJournal by file name
*AccountingApi* | [**createManualJournals**](docs/Api/AccountingApi.md#createmanualjournals) | **PUT** /ManualJournals | Allows you to create one or more manual journals
*AccountingApi* | [**createOverpaymentAllocations**](docs/Api/AccountingApi.md#createoverpaymentallocations) | **PUT** /Overpayments/{OverpaymentID}/Allocations | Allows you to create a single allocation for an overpayment
*AccountingApi* | [**createOverpaymentHistory**](docs/Api/AccountingApi.md#createoverpaymenthistory) | **PUT** /Overpayments/{OverpaymentID}/History | Allows you to create history records of an Overpayment
*AccountingApi* | [**createPayment**](docs/Api/AccountingApi.md#createpayment) | **POST** /Payments | Allows you to create a single payment for invoices or credit notes
*AccountingApi* | [**createPaymentHistory**](docs/Api/AccountingApi.md#createpaymenthistory) | **PUT** /Payments/{PaymentID}/History | Allows you to create a history record for a payment
*AccountingApi* | [**createPaymentService**](docs/Api/AccountingApi.md#createpaymentservice) | **PUT** /PaymentServices | Allows you to create payment services
*AccountingApi* | [**createPayments**](docs/Api/AccountingApi.md#createpayments) | **PUT** /Payments | Allows you to create multiple payments for invoices or credit notes
*AccountingApi* | [**createPrepaymentAllocations**](docs/Api/AccountingApi.md#createprepaymentallocations) | **PUT** /Prepayments/{PrepaymentID}/Allocations | Allows you to create an Allocation for prepayments
*AccountingApi* | [**createPrepaymentHistory**](docs/Api/AccountingApi.md#createprepaymenthistory) | **PUT** /Prepayments/{PrepaymentID}/History | Allows you to create a history record for an Prepayment
*AccountingApi* | [**createPurchaseOrderHistory**](docs/Api/AccountingApi.md#createpurchaseorderhistory) | **PUT** /PurchaseOrders/{PurchaseOrderID}/History | Allows you to create HistoryRecord for purchase orders
*AccountingApi* | [**createPurchaseOrders**](docs/Api/AccountingApi.md#createpurchaseorders) | **PUT** /PurchaseOrders | Allows you to create one or more purchase orders
*AccountingApi* | [**createQuoteAttachmentByFileName**](docs/Api/AccountingApi.md#createquoteattachmentbyfilename) | **PUT** /Quotes/{QuoteID}/Attachments/{FileName} | Allows you to create Attachment on Quote
*AccountingApi* | [**createQuoteHistory**](docs/Api/AccountingApi.md#createquotehistory) | **PUT** /Quotes/{QuoteID}/History | Allows you to retrieve a history records of an quote
*AccountingApi* | [**createQuotes**](docs/Api/AccountingApi.md#createquotes) | **PUT** /Quotes | Allows you to create one or more quotes
*AccountingApi* | [**createReceipt**](docs/Api/AccountingApi.md#createreceipt) | **PUT** /Receipts | Allows you to create draft expense claim receipts for any user
*AccountingApi* | [**createReceiptAttachmentByFileName**](docs/Api/AccountingApi.md#createreceiptattachmentbyfilename) | **PUT** /Receipts/{ReceiptID}/Attachments/{FileName} | Allows you to create Attachment on expense claim receipts by file name
*AccountingApi* | [**createReceiptHistory**](docs/Api/AccountingApi.md#createreceipthistory) | **PUT** /Receipts/{ReceiptID}/History | Allows you to retrieve a history records of an Receipt
*AccountingApi* | [**createRepeatingInvoiceAttachmentByFileName**](docs/Api/AccountingApi.md#createrepeatinginvoiceattachmentbyfilename) | **PUT** /RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{FileName} | Allows you to create attachment on repeating invoices by file name
*AccountingApi* | [**createRepeatingInvoiceHistory**](docs/Api/AccountingApi.md#createrepeatinginvoicehistory) | **PUT** /RepeatingInvoices/{RepeatingInvoiceID}/History | Allows you to create history for a repeating invoice
*AccountingApi* | [**createTaxRates**](docs/Api/AccountingApi.md#createtaxrates) | **PUT** /TaxRates | Allows you to create one or more Tax Rates
*AccountingApi* | [**createTrackingCategory**](docs/Api/AccountingApi.md#createtrackingcategory) | **PUT** /TrackingCategories | Allows you to create tracking categories
*AccountingApi* | [**createTrackingOptions**](docs/Api/AccountingApi.md#createtrackingoptions) | **PUT** /TrackingCategories/{TrackingCategoryID}/Options | Allows you to create options for a specified tracking category
*AccountingApi* | [**deleteAccount**](docs/Api/AccountingApi.md#deleteaccount) | **DELETE** /Accounts/{AccountID} | Allows you to delete a chart of accounts
*AccountingApi* | [**deleteContactGroupContact**](docs/Api/AccountingApi.md#deletecontactgroupcontact) | **DELETE** /ContactGroups/{ContactGroupID}/Contacts/{ContactID} | Allows you to delete a specific Contact from a Contact Group
*AccountingApi* | [**deleteContactGroupContacts**](docs/Api/AccountingApi.md#deletecontactgroupcontacts) | **DELETE** /ContactGroups/{ContactGroupID}/Contacts | Allows you to delete  all Contacts from a Contact Group
*AccountingApi* | [**deleteItem**](docs/Api/AccountingApi.md#deleteitem) | **DELETE** /Items/{ItemID} | Allows you to delete a specified item
*AccountingApi* | [**deleteLinkedTransaction**](docs/Api/AccountingApi.md#deletelinkedtransaction) | **DELETE** /LinkedTransactions/{LinkedTransactionID} | Allows you to delete a specified linked transactions (billable expenses)
*AccountingApi* | [**deletePayment**](docs/Api/AccountingApi.md#deletepayment) | **POST** /Payments/{PaymentID} | Allows you to update a specified payment for invoices and credit notes
*AccountingApi* | [**deleteTrackingCategory**](docs/Api/AccountingApi.md#deletetrackingcategory) | **DELETE** /TrackingCategories/{TrackingCategoryID} | Allows you to delete tracking categories
*AccountingApi* | [**deleteTrackingOptions**](docs/Api/AccountingApi.md#deletetrackingoptions) | **DELETE** /TrackingCategories/{TrackingCategoryID}/Options/{TrackingOptionID} | Allows you to delete a specified option for a specified tracking category
*AccountingApi* | [**emailInvoice**](docs/Api/AccountingApi.md#emailinvoice) | **POST** /Invoices/{InvoiceID}/Email | Allows you to email a copy of invoice to related Contact
*AccountingApi* | [**getAccount**](docs/Api/AccountingApi.md#getaccount) | **GET** /Accounts/{AccountID} | Allows you to retrieve a single chart of accounts
*AccountingApi* | [**getAccountAttachmentByFileName**](docs/Api/AccountingApi.md#getaccountattachmentbyfilename) | **GET** /Accounts/{AccountID}/Attachments/{FileName} | Allows you to retrieve Attachment on Account by Filename
*AccountingApi* | [**getAccountAttachmentById**](docs/Api/AccountingApi.md#getaccountattachmentbyid) | **GET** /Accounts/{AccountID}/Attachments/{AttachmentID} | Allows you to retrieve specific Attachment on Account
*AccountingApi* | [**getAccountAttachments**](docs/Api/AccountingApi.md#getaccountattachments) | **GET** /Accounts/{AccountID}/Attachments | Allows you to retrieve Attachments for accounts
*AccountingApi* | [**getAccounts**](docs/Api/AccountingApi.md#getaccounts) | **GET** /Accounts | Allows you to retrieve the full chart of accounts
*AccountingApi* | [**getBankTransaction**](docs/Api/AccountingApi.md#getbanktransaction) | **GET** /BankTransactions/{BankTransactionID} | Allows you to retrieve a single spend or receive money transaction
*AccountingApi* | [**getBankTransactionAttachmentByFileName**](docs/Api/AccountingApi.md#getbanktransactionattachmentbyfilename) | **GET** /BankTransactions/{BankTransactionID}/Attachments/{FileName} | Allows you to retrieve Attachments on BankTransaction by Filename
*AccountingApi* | [**getBankTransactionAttachmentById**](docs/Api/AccountingApi.md#getbanktransactionattachmentbyid) | **GET** /BankTransactions/{BankTransactionID}/Attachments/{AttachmentID} | Allows you to retrieve Attachments on a specific BankTransaction
*AccountingApi* | [**getBankTransactionAttachments**](docs/Api/AccountingApi.md#getbanktransactionattachments) | **GET** /BankTransactions/{BankTransactionID}/Attachments | Allows you to retrieve any attachments to bank transactions
*AccountingApi* | [**getBankTransactions**](docs/Api/AccountingApi.md#getbanktransactions) | **GET** /BankTransactions | Allows you to retrieve any spend or receive money transactions
*AccountingApi* | [**getBankTransactionsHistory**](docs/Api/AccountingApi.md#getbanktransactionshistory) | **GET** /BankTransactions/{BankTransactionID}/History | Allows you to retrieve history from a bank transactions
*AccountingApi* | [**getBankTransfer**](docs/Api/AccountingApi.md#getbanktransfer) | **GET** /BankTransfers/{BankTransferID} | Allows you to retrieve any bank transfers
*AccountingApi* | [**getBankTransferAttachmentByFileName**](docs/Api/AccountingApi.md#getbanktransferattachmentbyfilename) | **GET** /BankTransfers/{BankTransferID}/Attachments/{FileName} | Allows you to retrieve Attachments on BankTransfer by file name
*AccountingApi* | [**getBankTransferAttachmentById**](docs/Api/AccountingApi.md#getbanktransferattachmentbyid) | **GET** /BankTransfers/{BankTransferID}/Attachments/{AttachmentID} | Allows you to retrieve Attachments on BankTransfer
*AccountingApi* | [**getBankTransferAttachments**](docs/Api/AccountingApi.md#getbanktransferattachments) | **GET** /BankTransfers/{BankTransferID}/Attachments | Allows you to retrieve Attachments from  bank transfers
*AccountingApi* | [**getBankTransferHistory**](docs/Api/AccountingApi.md#getbanktransferhistory) | **GET** /BankTransfers/{BankTransferID}/History | Allows you to retrieve history from a bank transfers
*AccountingApi* | [**getBankTransfers**](docs/Api/AccountingApi.md#getbanktransfers) | **GET** /BankTransfers | Allows you to retrieve all bank transfers
*AccountingApi* | [**getBatchPaymentHistory**](docs/Api/AccountingApi.md#getbatchpaymenthistory) | **GET** /BatchPayments/{BatchPaymentID}/History | Allows you to retrieve history from a Batch Payment
*AccountingApi* | [**getBatchPayments**](docs/Api/AccountingApi.md#getbatchpayments) | **GET** /BatchPayments | Retrieve either one or many BatchPayments for invoices
*AccountingApi* | [**getBrandingTheme**](docs/Api/AccountingApi.md#getbrandingtheme) | **GET** /BrandingThemes/{BrandingThemeID} | Allows you to retrieve a specific BrandingThemes
*AccountingApi* | [**getBrandingThemePaymentServices**](docs/Api/AccountingApi.md#getbrandingthemepaymentservices) | **GET** /BrandingThemes/{BrandingThemeID}/PaymentServices | Allows you to retrieve the Payment services for a Branding Theme
*AccountingApi* | [**getBrandingThemes**](docs/Api/AccountingApi.md#getbrandingthemes) | **GET** /BrandingThemes | Allows you to retrieve all the BrandingThemes
*AccountingApi* | [**getContact**](docs/Api/AccountingApi.md#getcontact) | **GET** /Contacts/{ContactID} | Allows you to retrieve a single contacts in a Xero organisation
*AccountingApi* | [**getContactAttachmentByFileName**](docs/Api/AccountingApi.md#getcontactattachmentbyfilename) | **GET** /Contacts/{ContactID}/Attachments/{FileName} | Allows you to retrieve Attachments on Contacts by file name
*AccountingApi* | [**getContactAttachmentById**](docs/Api/AccountingApi.md#getcontactattachmentbyid) | **GET** /Contacts/{ContactID}/Attachments/{AttachmentID} | Allows you to retrieve Attachments on Contacts
*AccountingApi* | [**getContactAttachments**](docs/Api/AccountingApi.md#getcontactattachments) | **GET** /Contacts/{ContactID}/Attachments | Allows you to retrieve, add and update contacts in a Xero organisation
*AccountingApi* | [**getContactByContactNumber**](docs/Api/AccountingApi.md#getcontactbycontactnumber) | **GET** /Contacts/{ContactNumber} | Allows you to retrieve a single contact by Contact Number in a Xero organisation
*AccountingApi* | [**getContactCISSettings**](docs/Api/AccountingApi.md#getcontactcissettings) | **GET** /Contacts/{ContactID}/CISSettings | Allows you to retrieve CISSettings for a contact in a Xero organisation
*AccountingApi* | [**getContactGroup**](docs/Api/AccountingApi.md#getcontactgroup) | **GET** /ContactGroups/{ContactGroupID} | Allows you to retrieve a unique Contact Group by ID
*AccountingApi* | [**getContactGroups**](docs/Api/AccountingApi.md#getcontactgroups) | **GET** /ContactGroups | Allows you to retrieve the ContactID and Name of all the contacts in a contact group
*AccountingApi* | [**getContactHistory**](docs/Api/AccountingApi.md#getcontacthistory) | **GET** /Contacts/{ContactID}/History | Allows you to retrieve a history records of an Contact
*AccountingApi* | [**getContacts**](docs/Api/AccountingApi.md#getcontacts) | **GET** /Contacts | Allows you to retrieve all contacts in a Xero organisation
*AccountingApi* | [**getCreditNote**](docs/Api/AccountingApi.md#getcreditnote) | **GET** /CreditNotes/{CreditNoteID} | Allows you to retrieve a specific credit note
*AccountingApi* | [**getCreditNoteAsPdf**](docs/Api/AccountingApi.md#getcreditnoteaspdf) | **GET** /CreditNotes/{CreditNoteID}/pdf | Allows you to retrieve Credit Note as PDF files
*AccountingApi* | [**getCreditNoteAttachmentByFileName**](docs/Api/AccountingApi.md#getcreditnoteattachmentbyfilename) | **GET** /CreditNotes/{CreditNoteID}/Attachments/{FileName} | Allows you to retrieve Attachments on CreditNote by file name
*AccountingApi* | [**getCreditNoteAttachmentById**](docs/Api/AccountingApi.md#getcreditnoteattachmentbyid) | **GET** /CreditNotes/{CreditNoteID}/Attachments/{AttachmentID} | Allows you to retrieve Attachments on CreditNote
*AccountingApi* | [**getCreditNoteAttachments**](docs/Api/AccountingApi.md#getcreditnoteattachments) | **GET** /CreditNotes/{CreditNoteID}/Attachments | Allows you to retrieve Attachments for credit notes
*AccountingApi* | [**getCreditNoteHistory**](docs/Api/AccountingApi.md#getcreditnotehistory) | **GET** /CreditNotes/{CreditNoteID}/History | Allows you to retrieve a history records of an CreditNote
*AccountingApi* | [**getCreditNotes**](docs/Api/AccountingApi.md#getcreditnotes) | **GET** /CreditNotes | Allows you to retrieve any credit notes
*AccountingApi* | [**getCurrencies**](docs/Api/AccountingApi.md#getcurrencies) | **GET** /Currencies | Allows you to retrieve currencies for your organisation
*AccountingApi* | [**getEmployee**](docs/Api/AccountingApi.md#getemployee) | **GET** /Employees/{EmployeeID} | Allows you to retrieve a specific employee used in Xero payrun
*AccountingApi* | [**getEmployees**](docs/Api/AccountingApi.md#getemployees) | **GET** /Employees | Allows you to retrieve employees used in Xero payrun
*AccountingApi* | [**getExpenseClaim**](docs/Api/AccountingApi.md#getexpenseclaim) | **GET** /ExpenseClaims/{ExpenseClaimID} | Allows you to retrieve a specified expense claim
*AccountingApi* | [**getExpenseClaimHistory**](docs/Api/AccountingApi.md#getexpenseclaimhistory) | **GET** /ExpenseClaims/{ExpenseClaimID}/History | Allows you to retrieve a history records of an ExpenseClaim
*AccountingApi* | [**getExpenseClaims**](docs/Api/AccountingApi.md#getexpenseclaims) | **GET** /ExpenseClaims | Allows you to retrieve expense claims
*AccountingApi* | [**getInvoice**](docs/Api/AccountingApi.md#getinvoice) | **GET** /Invoices/{InvoiceID} | Allows you to retrieve a specified sales invoice or purchase bill
*AccountingApi* | [**getInvoiceAsPdf**](docs/Api/AccountingApi.md#getinvoiceaspdf) | **GET** /Invoices/{InvoiceID}/pdf | Allows you to retrieve invoices or purchase bills as PDF files
*AccountingApi* | [**getInvoiceAttachmentByFileName**](docs/Api/AccountingApi.md#getinvoiceattachmentbyfilename) | **GET** /Invoices/{InvoiceID}/Attachments/{FileName} | Allows you to retrieve Attachment on invoices or purchase bills by it&#39;s filename
*AccountingApi* | [**getInvoiceAttachmentById**](docs/Api/AccountingApi.md#getinvoiceattachmentbyid) | **GET** /Invoices/{InvoiceID}/Attachments/{AttachmentID} | Allows you to retrieve a specified Attachment on invoices or purchase bills by it&#39;s ID
*AccountingApi* | [**getInvoiceAttachments**](docs/Api/AccountingApi.md#getinvoiceattachments) | **GET** /Invoices/{InvoiceID}/Attachments | Allows you to retrieve Attachments on invoices or purchase bills
*AccountingApi* | [**getInvoiceHistory**](docs/Api/AccountingApi.md#getinvoicehistory) | **GET** /Invoices/{InvoiceID}/History | Allows you to retrieve a history records of an invoice
*AccountingApi* | [**getInvoiceReminders**](docs/Api/AccountingApi.md#getinvoicereminders) | **GET** /InvoiceReminders/Settings | Allows you to retrieve invoice reminder settings
*AccountingApi* | [**getInvoices**](docs/Api/AccountingApi.md#getinvoices) | **GET** /Invoices | Allows you to retrieve any sales invoices or purchase bills
*AccountingApi* | [**getItem**](docs/Api/AccountingApi.md#getitem) | **GET** /Items/{ItemID} | Allows you to retrieve a specified item
*AccountingApi* | [**getItemHistory**](docs/Api/AccountingApi.md#getitemhistory) | **GET** /Items/{ItemID}/History | Allows you to retrieve history for items
*AccountingApi* | [**getItems**](docs/Api/AccountingApi.md#getitems) | **GET** /Items | Allows you to retrieve any items
*AccountingApi* | [**getJournal**](docs/Api/AccountingApi.md#getjournal) | **GET** /Journals/{JournalID} | Allows you to retrieve a specified journals.
*AccountingApi* | [**getJournals**](docs/Api/AccountingApi.md#getjournals) | **GET** /Journals | Allows you to retrieve any journals.
*AccountingApi* | [**getLinkedTransaction**](docs/Api/AccountingApi.md#getlinkedtransaction) | **GET** /LinkedTransactions/{LinkedTransactionID} | Allows you to retrieve a specified linked transactions (billable expenses)
*AccountingApi* | [**getLinkedTransactions**](docs/Api/AccountingApi.md#getlinkedtransactions) | **GET** /LinkedTransactions | Retrieve linked transactions (billable expenses)
*AccountingApi* | [**getManualJournal**](docs/Api/AccountingApi.md#getmanualjournal) | **GET** /ManualJournals/{ManualJournalID} | Allows you to retrieve a specified manual journals
*AccountingApi* | [**getManualJournalAttachmentByFileName**](docs/Api/AccountingApi.md#getmanualjournalattachmentbyfilename) | **GET** /ManualJournals/{ManualJournalID}/Attachments/{FileName} | Allows you to retrieve specified Attachment on ManualJournal by file name
*AccountingApi* | [**getManualJournalAttachmentById**](docs/Api/AccountingApi.md#getmanualjournalattachmentbyid) | **GET** /ManualJournals/{ManualJournalID}/Attachments/{AttachmentID} | Allows you to retrieve specified Attachment on ManualJournals
*AccountingApi* | [**getManualJournalAttachments**](docs/Api/AccountingApi.md#getmanualjournalattachments) | **GET** /ManualJournals/{ManualJournalID}/Attachments | Allows you to retrieve Attachment for manual journals
*AccountingApi* | [**getManualJournals**](docs/Api/AccountingApi.md#getmanualjournals) | **GET** /ManualJournals | Allows you to retrieve any manual journals
*AccountingApi* | [**getOnlineInvoice**](docs/Api/AccountingApi.md#getonlineinvoice) | **GET** /Invoices/{InvoiceID}/OnlineInvoice | Allows you to retrieve a URL to an online invoice
*AccountingApi* | [**getOrganisationCISSettings**](docs/Api/AccountingApi.md#getorganisationcissettings) | **GET** /Organisation/{OrganisationID}/CISSettings | Allows you To verify if an organisation is using contruction industry scheme, you can retrieve the CIS settings for the organistaion.
*AccountingApi* | [**getOrganisations**](docs/Api/AccountingApi.md#getorganisations) | **GET** /Organisation | Allows you to retrieve Organisation details
*AccountingApi* | [**getOverpayment**](docs/Api/AccountingApi.md#getoverpayment) | **GET** /Overpayments/{OverpaymentID} | Allows you to retrieve a specified overpayments
*AccountingApi* | [**getOverpaymentHistory**](docs/Api/AccountingApi.md#getoverpaymenthistory) | **GET** /Overpayments/{OverpaymentID}/History | Allows you to retrieve a history records of an Overpayment
*AccountingApi* | [**getOverpayments**](docs/Api/AccountingApi.md#getoverpayments) | **GET** /Overpayments | Allows you to retrieve overpayments
*AccountingApi* | [**getPayment**](docs/Api/AccountingApi.md#getpayment) | **GET** /Payments/{PaymentID} | Allows you to retrieve a specified payment for invoices and credit notes
*AccountingApi* | [**getPaymentHistory**](docs/Api/AccountingApi.md#getpaymenthistory) | **GET** /Payments/{PaymentID}/History | Allows you to retrieve history records of a payment
*AccountingApi* | [**getPaymentServices**](docs/Api/AccountingApi.md#getpaymentservices) | **GET** /PaymentServices | Allows you to retrieve payment services
*AccountingApi* | [**getPayments**](docs/Api/AccountingApi.md#getpayments) | **GET** /Payments | Allows you to retrieve payments for invoices and credit notes
*AccountingApi* | [**getPrepayment**](docs/Api/AccountingApi.md#getprepayment) | **GET** /Prepayments/{PrepaymentID} | Allows you to retrieve a specified prepayments
*AccountingApi* | [**getPrepaymentHistory**](docs/Api/AccountingApi.md#getprepaymenthistory) | **GET** /Prepayments/{PrepaymentID}/History | Allows you to retrieve a history records of an Prepayment
*AccountingApi* | [**getPrepayments**](docs/Api/AccountingApi.md#getprepayments) | **GET** /Prepayments | Allows you to retrieve prepayments
*AccountingApi* | [**getPurchaseOrder**](docs/Api/AccountingApi.md#getpurchaseorder) | **GET** /PurchaseOrders/{PurchaseOrderID} | Allows you to retrieve a specified purchase orders
*AccountingApi* | [**getPurchaseOrderAsPdf**](docs/Api/AccountingApi.md#getpurchaseorderaspdf) | **GET** /PurchaseOrders/{PurchaseOrderID}/pdf | Allows you to retrieve purchase orders as PDF files
*AccountingApi* | [**getPurchaseOrderByNumber**](docs/Api/AccountingApi.md#getpurchaseorderbynumber) | **GET** /PurchaseOrders/{PurchaseOrderNumber} | Allows you to retrieve a specified purchase orders
*AccountingApi* | [**getPurchaseOrderHistory**](docs/Api/AccountingApi.md#getpurchaseorderhistory) | **GET** /PurchaseOrders/{PurchaseOrderID}/History | Allows you to retrieve history for PurchaseOrder
*AccountingApi* | [**getPurchaseOrders**](docs/Api/AccountingApi.md#getpurchaseorders) | **GET** /PurchaseOrders | Allows you to retrieve purchase orders
*AccountingApi* | [**getQuote**](docs/Api/AccountingApi.md#getquote) | **GET** /Quotes/{QuoteID} | Allows you to retrieve a specified quote
*AccountingApi* | [**getQuoteAsPdf**](docs/Api/AccountingApi.md#getquoteaspdf) | **GET** /Quotes/{QuotesID}/pdf | Allows you to retrieve quotes as PDF files
*AccountingApi* | [**getQuoteAttachmentByFileName**](docs/Api/AccountingApi.md#getquoteattachmentbyfilename) | **GET** /Quotes/{QuoteID}/Attachments/{FileName} | Allows you to retrieve Attachment on Quote by Filename
*AccountingApi* | [**getQuoteAttachmentById**](docs/Api/AccountingApi.md#getquoteattachmentbyid) | **GET** /Quotes/{QuoteID}/Attachments/{AttachmentID} | Allows you to retrieve specific Attachment on Quote
*AccountingApi* | [**getQuoteAttachments**](docs/Api/AccountingApi.md#getquoteattachments) | **GET** /Quotes/{QuoteID}/Attachments | Allows you to retrieve Attachments for Quotes
*AccountingApi* | [**getQuoteHistory**](docs/Api/AccountingApi.md#getquotehistory) | **GET** /Quotes/{QuoteID}/History | Allows you to retrieve a history records of an quote
*AccountingApi* | [**getQuotes**](docs/Api/AccountingApi.md#getquotes) | **GET** /Quotes | Allows you to retrieve any sales quotes
*AccountingApi* | [**getReceipt**](docs/Api/AccountingApi.md#getreceipt) | **GET** /Receipts/{ReceiptID} | Allows you to retrieve a specified draft expense claim receipts
*AccountingApi* | [**getReceiptAttachmentByFileName**](docs/Api/AccountingApi.md#getreceiptattachmentbyfilename) | **GET** /Receipts/{ReceiptID}/Attachments/{FileName} | Allows you to retrieve Attachments on expense claim receipts by file name
*AccountingApi* | [**getReceiptAttachmentById**](docs/Api/AccountingApi.md#getreceiptattachmentbyid) | **GET** /Receipts/{ReceiptID}/Attachments/{AttachmentID} | Allows you to retrieve Attachments on expense claim receipts by ID
*AccountingApi* | [**getReceiptAttachments**](docs/Api/AccountingApi.md#getreceiptattachments) | **GET** /Receipts/{ReceiptID}/Attachments | Allows you to retrieve Attachments for expense claim receipts
*AccountingApi* | [**getReceiptHistory**](docs/Api/AccountingApi.md#getreceipthistory) | **GET** /Receipts/{ReceiptID}/History | Allows you to retrieve a history records of an Receipt
*AccountingApi* | [**getReceipts**](docs/Api/AccountingApi.md#getreceipts) | **GET** /Receipts | Allows you to retrieve draft expense claim receipts for any user
*AccountingApi* | [**getRepeatingInvoice**](docs/Api/AccountingApi.md#getrepeatinginvoice) | **GET** /RepeatingInvoices/{RepeatingInvoiceID} | Allows you to retrieve a specified repeating invoice
*AccountingApi* | [**getRepeatingInvoiceAttachmentByFileName**](docs/Api/AccountingApi.md#getrepeatinginvoiceattachmentbyfilename) | **GET** /RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{FileName} | Allows you to retrieve specified attachment on repeating invoices by file name
*AccountingApi* | [**getRepeatingInvoiceAttachmentById**](docs/Api/AccountingApi.md#getrepeatinginvoiceattachmentbyid) | **GET** /RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{AttachmentID} | Allows you to retrieve a specified Attachments on repeating invoices
*AccountingApi* | [**getRepeatingInvoiceAttachments**](docs/Api/AccountingApi.md#getrepeatinginvoiceattachments) | **GET** /RepeatingInvoices/{RepeatingInvoiceID}/Attachments | Allows you to retrieve Attachments on repeating invoice
*AccountingApi* | [**getRepeatingInvoiceHistory**](docs/Api/AccountingApi.md#getrepeatinginvoicehistory) | **GET** /RepeatingInvoices/{RepeatingInvoiceID}/History | Allows you to retrieve history for a repeating invoice
*AccountingApi* | [**getRepeatingInvoices**](docs/Api/AccountingApi.md#getrepeatinginvoices) | **GET** /RepeatingInvoices | Allows you to retrieve any repeating invoices
*AccountingApi* | [**getReportAgedPayablesByContact**](docs/Api/AccountingApi.md#getreportagedpayablesbycontact) | **GET** /Reports/AgedPayablesByContact | Allows you to retrieve report for AgedPayablesByContact
*AccountingApi* | [**getReportAgedReceivablesByContact**](docs/Api/AccountingApi.md#getreportagedreceivablesbycontact) | **GET** /Reports/AgedReceivablesByContact | Allows you to retrieve report for AgedReceivablesByContact
*AccountingApi* | [**getReportBASorGST**](docs/Api/AccountingApi.md#getreportbasorgst) | **GET** /Reports/{ReportID} | Allows you to retrieve report for BAS only valid for AU orgs
*AccountingApi* | [**getReportBASorGSTList**](docs/Api/AccountingApi.md#getreportbasorgstlist) | **GET** /Reports | Allows you to retrieve report for BAS only valid for AU orgs
*AccountingApi* | [**getReportBalanceSheet**](docs/Api/AccountingApi.md#getreportbalancesheet) | **GET** /Reports/BalanceSheet | Allows you to retrieve report for BalanceSheet
*AccountingApi* | [**getReportBankSummary**](docs/Api/AccountingApi.md#getreportbanksummary) | **GET** /Reports/BankSummary | Allows you to retrieve report for BankSummary
*AccountingApi* | [**getReportBudgetSummary**](docs/Api/AccountingApi.md#getreportbudgetsummary) | **GET** /Reports/BudgetSummary | Allows you to retrieve report for Budget Summary
*AccountingApi* | [**getReportExecutiveSummary**](docs/Api/AccountingApi.md#getreportexecutivesummary) | **GET** /Reports/ExecutiveSummary | Allows you to retrieve report for ExecutiveSummary
*AccountingApi* | [**getReportProfitAndLoss**](docs/Api/AccountingApi.md#getreportprofitandloss) | **GET** /Reports/ProfitAndLoss | Allows you to retrieve report for ProfitAndLoss
*AccountingApi* | [**getReportTenNinetyNine**](docs/Api/AccountingApi.md#getreporttenninetynine) | **GET** /Reports/TenNinetyNine | Allows you to retrieve report for TenNinetyNine
*AccountingApi* | [**getReportTrialBalance**](docs/Api/AccountingApi.md#getreporttrialbalance) | **GET** /Reports/TrialBalance | Allows you to retrieve report for TrialBalance
*AccountingApi* | [**getTaxRates**](docs/Api/AccountingApi.md#gettaxrates) | **GET** /TaxRates | Allows you to retrieve Tax Rates
*AccountingApi* | [**getTrackingCategories**](docs/Api/AccountingApi.md#gettrackingcategories) | **GET** /TrackingCategories | Allows you to retrieve tracking categories and options
*AccountingApi* | [**getTrackingCategory**](docs/Api/AccountingApi.md#gettrackingcategory) | **GET** /TrackingCategories/{TrackingCategoryID} | Allows you to retrieve tracking categories and options for specified category
*AccountingApi* | [**getUser**](docs/Api/AccountingApi.md#getuser) | **GET** /Users/{UserID} | Allows you to retrieve a specified user
*AccountingApi* | [**getUsers**](docs/Api/AccountingApi.md#getusers) | **GET** /Users | Allows you to retrieve users
*AccountingApi* | [**updateAccount**](docs/Api/AccountingApi.md#updateaccount) | **POST** /Accounts/{AccountID} | Allows you to update a chart of accounts
*AccountingApi* | [**updateAccountAttachmentByFileName**](docs/Api/AccountingApi.md#updateaccountattachmentbyfilename) | **POST** /Accounts/{AccountID}/Attachments/{FileName} | Allows you to update Attachment on Account by Filename
*AccountingApi* | [**updateBankTransaction**](docs/Api/AccountingApi.md#updatebanktransaction) | **POST** /BankTransactions/{BankTransactionID} | Allows you to update a single spend or receive money transaction
*AccountingApi* | [**updateBankTransactionAttachmentByFileName**](docs/Api/AccountingApi.md#updatebanktransactionattachmentbyfilename) | **POST** /BankTransactions/{BankTransactionID}/Attachments/{FileName} | Allows you to update an Attachment on BankTransaction by Filename
*AccountingApi* | [**updateBankTransferAttachmentByFileName**](docs/Api/AccountingApi.md#updatebanktransferattachmentbyfilename) | **POST** /BankTransfers/{BankTransferID}/Attachments/{FileName} | 
*AccountingApi* | [**updateContact**](docs/Api/AccountingApi.md#updatecontact) | **POST** /Contacts/{ContactID} | 
*AccountingApi* | [**updateContactAttachmentByFileName**](docs/Api/AccountingApi.md#updatecontactattachmentbyfilename) | **POST** /Contacts/{ContactID}/Attachments/{FileName} | 
*AccountingApi* | [**updateContactGroup**](docs/Api/AccountingApi.md#updatecontactgroup) | **POST** /ContactGroups/{ContactGroupID} | Allows you to update a Contact Group
*AccountingApi* | [**updateCreditNote**](docs/Api/AccountingApi.md#updatecreditnote) | **POST** /CreditNotes/{CreditNoteID} | Allows you to update a specific credit note
*AccountingApi* | [**updateCreditNoteAttachmentByFileName**](docs/Api/AccountingApi.md#updatecreditnoteattachmentbyfilename) | **POST** /CreditNotes/{CreditNoteID}/Attachments/{FileName} | Allows you to update Attachments on CreditNote by file name
*AccountingApi* | [**updateExpenseClaim**](docs/Api/AccountingApi.md#updateexpenseclaim) | **POST** /ExpenseClaims/{ExpenseClaimID} | Allows you to update specified expense claims
*AccountingApi* | [**updateInvoice**](docs/Api/AccountingApi.md#updateinvoice) | **POST** /Invoices/{InvoiceID} | Allows you to update a specified sales invoices or purchase bills
*AccountingApi* | [**updateInvoiceAttachmentByFileName**](docs/Api/AccountingApi.md#updateinvoiceattachmentbyfilename) | **POST** /Invoices/{InvoiceID}/Attachments/{FileName} | Allows you to update Attachment on invoices or purchase bills by it&#39;s filename
*AccountingApi* | [**updateItem**](docs/Api/AccountingApi.md#updateitem) | **POST** /Items/{ItemID} | Allows you to update a specified item
*AccountingApi* | [**updateLinkedTransaction**](docs/Api/AccountingApi.md#updatelinkedtransaction) | **POST** /LinkedTransactions/{LinkedTransactionID} | Allows you to update a specified linked transactions (billable expenses)
*AccountingApi* | [**updateManualJournal**](docs/Api/AccountingApi.md#updatemanualjournal) | **POST** /ManualJournals/{ManualJournalID} | Allows you to update a specified manual journal
*AccountingApi* | [**updateManualJournalAttachmentByFileName**](docs/Api/AccountingApi.md#updatemanualjournalattachmentbyfilename) | **POST** /ManualJournals/{ManualJournalID}/Attachments/{FileName} | Allows you to update a specified Attachment on ManualJournal by file name
*AccountingApi* | [**updateOrCreateBankTransactions**](docs/Api/AccountingApi.md#updateorcreatebanktransactions) | **POST** /BankTransactions | Allows you to update or create one or more spend or receive money transaction
*AccountingApi* | [**updateOrCreateContacts**](docs/Api/AccountingApi.md#updateorcreatecontacts) | **POST** /Contacts | Allows you to update OR create one or more contacts in a Xero organisation
*AccountingApi* | [**updateOrCreateCreditNotes**](docs/Api/AccountingApi.md#updateorcreatecreditnotes) | **POST** /CreditNotes | Allows you to update OR create one or more credit notes
*AccountingApi* | [**updateOrCreateEmployees**](docs/Api/AccountingApi.md#updateorcreateemployees) | **POST** /Employees | Allows you to create a single new employees used in Xero payrun
*AccountingApi* | [**updateOrCreateInvoices**](docs/Api/AccountingApi.md#updateorcreateinvoices) | **POST** /Invoices | Allows you to update OR create one or more sales invoices or purchase bills
*AccountingApi* | [**updateOrCreateItems**](docs/Api/AccountingApi.md#updateorcreateitems) | **POST** /Items | Allows you to update or create one or more items
*AccountingApi* | [**updateOrCreateManualJournals**](docs/Api/AccountingApi.md#updateorcreatemanualjournals) | **POST** /ManualJournals | Allows you to create a single manual journal
*AccountingApi* | [**updateOrCreatePurchaseOrders**](docs/Api/AccountingApi.md#updateorcreatepurchaseorders) | **POST** /PurchaseOrders | Allows you to update or create one or more purchase orders
*AccountingApi* | [**updateOrCreateQuotes**](docs/Api/AccountingApi.md#updateorcreatequotes) | **POST** /Quotes | Allows you to update OR create one or more quotes
*AccountingApi* | [**updatePurchaseOrder**](docs/Api/AccountingApi.md#updatepurchaseorder) | **POST** /PurchaseOrders/{PurchaseOrderID} | Allows you to update a specified purchase order
*AccountingApi* | [**updateQuote**](docs/Api/AccountingApi.md#updatequote) | **POST** /Quotes/{QuoteID} | Allows you to update a specified quote
*AccountingApi* | [**updateQuoteAttachmentByFileName**](docs/Api/AccountingApi.md#updatequoteattachmentbyfilename) | **POST** /Quotes/{QuoteID}/Attachments/{FileName} | Allows you to update Attachment on Quote by Filename
*AccountingApi* | [**updateReceipt**](docs/Api/AccountingApi.md#updatereceipt) | **POST** /Receipts/{ReceiptID} | Allows you to retrieve a specified draft expense claim receipts
*AccountingApi* | [**updateReceiptAttachmentByFileName**](docs/Api/AccountingApi.md#updatereceiptattachmentbyfilename) | **POST** /Receipts/{ReceiptID}/Attachments/{FileName} | Allows you to update Attachment on expense claim receipts by file name
*AccountingApi* | [**updateRepeatingInvoiceAttachmentByFileName**](docs/Api/AccountingApi.md#updaterepeatinginvoiceattachmentbyfilename) | **POST** /RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{FileName} | Allows you to update specified attachment on repeating invoices by file name
*AccountingApi* | [**updateTaxRate**](docs/Api/AccountingApi.md#updatetaxrate) | **POST** /TaxRates | Allows you to update Tax Rates
*AccountingApi* | [**updateTrackingCategory**](docs/Api/AccountingApi.md#updatetrackingcategory) | **POST** /TrackingCategories/{TrackingCategoryID} | Allows you to update tracking categories
*AccountingApi* | [**updateTrackingOptions**](docs/Api/AccountingApi.md#updatetrackingoptions) | **POST** /TrackingCategories/{TrackingCategoryID}/Options/{TrackingOptionID} | Allows you to update options for a specified tracking category


## Documentation For Models

 - [Account](docs/Model/Account.md)
 - [AccountType](docs/Model/AccountType.md)
 - [Accounts](docs/Model/Accounts.md)
 - [AccountsPayable](docs/Model/AccountsPayable.md)
 - [AccountsReceivable](docs/Model/AccountsReceivable.md)
 - [Address](docs/Model/Address.md)
 - [Allocation](docs/Model/Allocation.md)
 - [Allocations](docs/Model/Allocations.md)
 - [Attachment](docs/Model/Attachment.md)
 - [Attachments](docs/Model/Attachments.md)
 - [Balances](docs/Model/Balances.md)
 - [BankTransaction](docs/Model/BankTransaction.md)
 - [BankTransactions](docs/Model/BankTransactions.md)
 - [BankTransfer](docs/Model/BankTransfer.md)
 - [BankTransfers](docs/Model/BankTransfers.md)
 - [BatchPayment](docs/Model/BatchPayment.md)
 - [BatchPaymentDetails](docs/Model/BatchPaymentDetails.md)
 - [BatchPayments](docs/Model/BatchPayments.md)
 - [Bill](docs/Model/Bill.md)
 - [BrandingTheme](docs/Model/BrandingTheme.md)
 - [BrandingThemes](docs/Model/BrandingThemes.md)
 - [CISOrgSetting](docs/Model/CISOrgSetting.md)
 - [CISSetting](docs/Model/CISSetting.md)
 - [CISSettings](docs/Model/CISSettings.md)
 - [Contact](docs/Model/Contact.md)
 - [ContactGroup](docs/Model/ContactGroup.md)
 - [ContactGroups](docs/Model/ContactGroups.md)
 - [ContactPerson](docs/Model/ContactPerson.md)
 - [Contacts](docs/Model/Contacts.md)
 - [CountryCode](docs/Model/CountryCode.md)
 - [CreditNote](docs/Model/CreditNote.md)
 - [CreditNotes](docs/Model/CreditNotes.md)
 - [Currencies](docs/Model/Currencies.md)
 - [Currency](docs/Model/Currency.md)
 - [CurrencyCode](docs/Model/CurrencyCode.md)
 - [Element](docs/Model/Element.md)
 - [Employee](docs/Model/Employee.md)
 - [Employees](docs/Model/Employees.md)
 - [Error](docs/Model/Error.md)
 - [ExpenseClaim](docs/Model/ExpenseClaim.md)
 - [ExpenseClaims](docs/Model/ExpenseClaims.md)
 - [ExternalLink](docs/Model/ExternalLink.md)
 - [HistoryRecord](docs/Model/HistoryRecord.md)
 - [HistoryRecords](docs/Model/HistoryRecords.md)
 - [Invoice](docs/Model/Invoice.md)
 - [InvoiceReminder](docs/Model/InvoiceReminder.md)
 - [InvoiceReminders](docs/Model/InvoiceReminders.md)
 - [Invoices](docs/Model/Invoices.md)
 - [Item](docs/Model/Item.md)
 - [Items](docs/Model/Items.md)
 - [Journal](docs/Model/Journal.md)
 - [JournalLine](docs/Model/JournalLine.md)
 - [Journals](docs/Model/Journals.md)
 - [LineAmountTypes](docs/Model/LineAmountTypes.md)
 - [LineItem](docs/Model/LineItem.md)
 - [LineItemTracking](docs/Model/LineItemTracking.md)
 - [LinkedTransaction](docs/Model/LinkedTransaction.md)
 - [LinkedTransactions](docs/Model/LinkedTransactions.md)
 - [ManualJournal](docs/Model/ManualJournal.md)
 - [ManualJournalLine](docs/Model/ManualJournalLine.md)
 - [ManualJournals](docs/Model/ManualJournals.md)
 - [OnlineInvoice](docs/Model/OnlineInvoice.md)
 - [OnlineInvoices](docs/Model/OnlineInvoices.md)
 - [Organisation](docs/Model/Organisation.md)
 - [Organisations](docs/Model/Organisations.md)
 - [Overpayment](docs/Model/Overpayment.md)
 - [Overpayments](docs/Model/Overpayments.md)
 - [Payment](docs/Model/Payment.md)
 - [PaymentDelete](docs/Model/PaymentDelete.md)
 - [PaymentService](docs/Model/PaymentService.md)
 - [PaymentServices](docs/Model/PaymentServices.md)
 - [PaymentTerm](docs/Model/PaymentTerm.md)
 - [PaymentTermType](docs/Model/PaymentTermType.md)
 - [Payments](docs/Model/Payments.md)
 - [Phone](docs/Model/Phone.md)
 - [Prepayment](docs/Model/Prepayment.md)
 - [Prepayments](docs/Model/Prepayments.md)
 - [Purchase](docs/Model/Purchase.md)
 - [PurchaseOrder](docs/Model/PurchaseOrder.md)
 - [PurchaseOrders](docs/Model/PurchaseOrders.md)
 - [Quote](docs/Model/Quote.md)
 - [QuoteLineAmountTypes](docs/Model/QuoteLineAmountTypes.md)
 - [QuoteStatusCodes](docs/Model/QuoteStatusCodes.md)
 - [Quotes](docs/Model/Quotes.md)
 - [Receipt](docs/Model/Receipt.md)
 - [Receipts](docs/Model/Receipts.md)
 - [RepeatingInvoice](docs/Model/RepeatingInvoice.md)
 - [RepeatingInvoices](docs/Model/RepeatingInvoices.md)
 - [Report](docs/Model/Report.md)
 - [ReportAttribute](docs/Model/ReportAttribute.md)
 - [ReportCell](docs/Model/ReportCell.md)
 - [ReportFields](docs/Model/ReportFields.md)
 - [ReportRow](docs/Model/ReportRow.md)
 - [ReportRows](docs/Model/ReportRows.md)
 - [ReportWithRow](docs/Model/ReportWithRow.md)
 - [ReportWithRows](docs/Model/ReportWithRows.md)
 - [Reports](docs/Model/Reports.md)
 - [RequestEmpty](docs/Model/RequestEmpty.md)
 - [RowType](docs/Model/RowType.md)
 - [SalesTrackingCategory](docs/Model/SalesTrackingCategory.md)
 - [Schedule](docs/Model/Schedule.md)
 - [TaxComponent](docs/Model/TaxComponent.md)
 - [TaxRate](docs/Model/TaxRate.md)
 - [TaxRates](docs/Model/TaxRates.md)
 - [TaxType](docs/Model/TaxType.md)
 - [TenNinteyNineContact](docs/Model/TenNinteyNineContact.md)
 - [TimeZone](docs/Model/TimeZone.md)
 - [TrackingCategories](docs/Model/TrackingCategories.md)
 - [TrackingCategory](docs/Model/TrackingCategory.md)
 - [TrackingOption](docs/Model/TrackingOption.md)
 - [TrackingOptions](docs/Model/TrackingOptions.md)
 - [User](docs/Model/User.md)
 - [Users](docs/Model/Users.md)
 - [ValidationError](docs/Model/ValidationError.md)


## Documentation For Authorization



## OAuth2


- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: https://login.xero.com/identity/connect/authorize
- **Scopes**: 
- **email**: Grant read-only access to your email
- **openid**: Grant read-only access to your open id
- **profile**: your profile information
- **accounting.transactions**: Grant read-write access to bank transactions, credit notes, invoices, repeating invoices
- **accounting.transactions.read**: Grant read-only access to invoices
- **accounting.reports.read**: Grant read-only access to accounting reports
- **accounting.journals.read**: Grant read-only access to journals
- **accounting.settings**: Grant read-write access to organisation and account settings
- **accounting.settings.read**: Grant read-only access to organisation and account settings
- **accounting.contacts**: Grant read-write access to contacts and contact groups
- **accounting.contacts.read**: Grant read-only access to contacts and contact groups
- **accounting.attachments**: Grant read-write access to attachments
- **accounting.attachments.read**: Grant read-only access to attachments
- **assets**: Grant read-write access to assets
- **assets.read**: Grant read-only access to fixed assets
- **bankfeeds**: Grant read-write access to bankfeeds
- **files**: Grant read-write access to files and folders
- **files.read**: Grant read-only access to files and folders
- **payroll**: Grant read-write access to payroll
- **payroll.read**: Grant read-only access to payroll
- **payroll.employees**: Grant read-write access to payroll employees
- **payroll.employees.read**: Grant read-only access to payroll employees
- **payroll.leaveapplications**: Grant read-write access to payroll leaveapplications
- **payroll.leaveapplications.read**: Grant read-only access to payroll leaveapplications
- **payroll.payitems**: Grant read-write access to payroll payitems
- **payroll.payitems.read**: Grant read-only access to payroll payitems
- **payroll.payrollcalendars**: Grant read-write access to payroll calendars
- **payroll.payrollcalendars.read**: Grant read-only access to payroll calendars
- **payroll.payruns**: Grant read-write access to payroll payruns
- **payroll.payruns.read**: Grant read-only access to payroll payruns
- **payroll.payslip**: Grant read-write access to payroll payslips
- **payroll.payslip.read**: Grant read-only access to payroll payslips
- **payroll.settings.read**: Grant read-only access to payroll settings
- **payroll.superfunds**: Grant read-write access to payroll superfunds
- **payroll.superfunds.read**: Grant read-only access to payroll superfunds
- **payroll.superfundproducts.read**: Grant read-only access to payroll superfundproducts
- **payroll.timesheets**: Grant read-write access to payroll timesheets
- **payroll.timesheets.read**: Grant read-only access to payroll timesheets
- **paymentservices**: Grant read-write access to payment services
- **projects**: Grant read-write access to projects
- **projects.read**: Grant read-only access to projects


## Author

api@xero.com

