<?php
/**
 * Receipt
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Xero2\Accounting
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Xero Accounting API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.10.0
 * Contact: api@xero.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Xero2\Accounting\Model;

use \ArrayAccess;
use \Xero2\Accounting\ObjectSerializer;

/**
 * Receipt Class Doc Comment
 *
 * @category Class
 * @package  Xero2\Accounting
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Receipt implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Receipt';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'date' => 'string',
        'contact' => '\Xero2\Accounting\Model\Contact',
        'line_items' => '\Xero2\Accounting\Model\LineItem[]',
        'user' => '\Xero2\Accounting\Model\User',
        'reference' => 'string',
        'line_amount_types' => '\Xero2\Accounting\Model\LineAmountTypes',
        'sub_total' => 'double',
        'total_tax' => 'double',
        'total' => 'double',
        'receipt_id' => 'string',
        'status' => 'string',
        'receipt_number' => 'string',
        'updated_date_utc' => 'string',
        'has_attachments' => 'bool',
        'url' => 'string',
        'validation_errors' => '\Xero2\Accounting\Model\ValidationError[]',
        'warnings' => '\Xero2\Accounting\Model\ValidationError[]',
        'attachments' => '\Xero2\Accounting\Model\Attachment[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'date' => null,
        'contact' => null,
        'line_items' => null,
        'user' => null,
        'reference' => null,
        'line_amount_types' => null,
        'sub_total' => 'double',
        'total_tax' => 'double',
        'total' => 'double',
        'receipt_id' => 'uuid',
        'status' => null,
        'receipt_number' => null,
        'updated_date_utc' => null,
        'has_attachments' => null,
        'url' => null,
        'validation_errors' => null,
        'warnings' => null,
        'attachments' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'date' => 'Date',
        'contact' => 'Contact',
        'line_items' => 'LineItems',
        'user' => 'User',
        'reference' => 'Reference',
        'line_amount_types' => 'LineAmountTypes',
        'sub_total' => 'SubTotal',
        'total_tax' => 'TotalTax',
        'total' => 'Total',
        'receipt_id' => 'ReceiptID',
        'status' => 'Status',
        'receipt_number' => 'ReceiptNumber',
        'updated_date_utc' => 'UpdatedDateUTC',
        'has_attachments' => 'HasAttachments',
        'url' => 'Url',
        'validation_errors' => 'ValidationErrors',
        'warnings' => 'Warnings',
        'attachments' => 'Attachments'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'date' => 'setDate',
        'contact' => 'setContact',
        'line_items' => 'setLineItems',
        'user' => 'setUser',
        'reference' => 'setReference',
        'line_amount_types' => 'setLineAmountTypes',
        'sub_total' => 'setSubTotal',
        'total_tax' => 'setTotalTax',
        'total' => 'setTotal',
        'receipt_id' => 'setReceiptId',
        'status' => 'setStatus',
        'receipt_number' => 'setReceiptNumber',
        'updated_date_utc' => 'setUpdatedDateUtc',
        'has_attachments' => 'setHasAttachments',
        'url' => 'setUrl',
        'validation_errors' => 'setValidationErrors',
        'warnings' => 'setWarnings',
        'attachments' => 'setAttachments'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'date' => 'getDate',
        'contact' => 'getContact',
        'line_items' => 'getLineItems',
        'user' => 'getUser',
        'reference' => 'getReference',
        'line_amount_types' => 'getLineAmountTypes',
        'sub_total' => 'getSubTotal',
        'total_tax' => 'getTotalTax',
        'total' => 'getTotal',
        'receipt_id' => 'getReceiptId',
        'status' => 'getStatus',
        'receipt_number' => 'getReceiptNumber',
        'updated_date_utc' => 'getUpdatedDateUtc',
        'has_attachments' => 'getHasAttachments',
        'url' => 'getUrl',
        'validation_errors' => 'getValidationErrors',
        'warnings' => 'getWarnings',
        'attachments' => 'getAttachments'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const STATUS_DRAFT = 'DRAFT';
    public const STATUS_SUBMITTED = 'SUBMITTED';
    public const STATUS_AUTHORISED = 'AUTHORISED';
    public const STATUS_DECLINED = 'DECLINED';
    public const STATUS_VOIDED = 'VOIDED';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_DRAFT,
            self::STATUS_SUBMITTED,
            self::STATUS_AUTHORISED,
            self::STATUS_DECLINED,
            self::STATUS_VOIDED,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['date'] = $data['date'] ?? null;
        $this->container['contact'] = $data['contact'] ?? null;
        $this->container['line_items'] = $data['line_items'] ?? null;
        $this->container['user'] = $data['user'] ?? null;
        $this->container['reference'] = $data['reference'] ?? null;
        $this->container['line_amount_types'] = $data['line_amount_types'] ?? null;
        $this->container['sub_total'] = $data['sub_total'] ?? null;
        $this->container['total_tax'] = $data['total_tax'] ?? null;
        $this->container['total'] = $data['total'] ?? null;
        $this->container['receipt_id'] = $data['receipt_id'] ?? null;
        $this->container['status'] = $data['status'] ?? null;
        $this->container['receipt_number'] = $data['receipt_number'] ?? null;
        $this->container['updated_date_utc'] = $data['updated_date_utc'] ?? null;
        $this->container['has_attachments'] = $data['has_attachments'] ?? false;
        $this->container['url'] = $data['url'] ?? null;
        $this->container['validation_errors'] = $data['validation_errors'] ?? null;
        $this->container['warnings'] = $data['warnings'] ?? null;
        $this->container['attachments'] = $data['attachments'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getStatusAllowableValues();
        if (!is_null($this->container['status']) && !in_array($this->container['status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'status', must be one of '%s'",
                $this->container['status'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets date
     *
     * @return string|null
     */
    public function getDate()
    {
        return $this->container['date'];
    }

    /**
     * Sets date
     *
     * @param string|null $date Date of receipt – YYYY-MM-DD
     *
     * @return self
     */
    public function setDate($date)
    {
        $this->container['date'] = $date;

        return $this;
    }

    /**
     * Gets contact
     *
     * @return \Xero2\Accounting\Model\Contact|null
     */
    public function getContact()
    {
        return $this->container['contact'];
    }

    /**
     * Sets contact
     *
     * @param \Xero2\Accounting\Model\Contact|null $contact contact
     *
     * @return self
     */
    public function setContact($contact)
    {
        $this->container['contact'] = $contact;

        return $this;
    }

    /**
     * Gets line_items
     *
     * @return \Xero2\Accounting\Model\LineItem[]|null
     */
    public function getLineItems()
    {
        return $this->container['line_items'];
    }

    /**
     * Sets line_items
     *
     * @param \Xero2\Accounting\Model\LineItem[]|null $line_items line_items
     *
     * @return self
     */
    public function setLineItems($line_items)
    {
        $this->container['line_items'] = $line_items;

        return $this;
    }

    /**
     * Gets user
     *
     * @return \Xero2\Accounting\Model\User|null
     */
    public function getUser()
    {
        return $this->container['user'];
    }

    /**
     * Sets user
     *
     * @param \Xero2\Accounting\Model\User|null $user user
     *
     * @return self
     */
    public function setUser($user)
    {
        $this->container['user'] = $user;

        return $this;
    }

    /**
     * Gets reference
     *
     * @return string|null
     */
    public function getReference()
    {
        return $this->container['reference'];
    }

    /**
     * Sets reference
     *
     * @param string|null $reference Additional reference number
     *
     * @return self
     */
    public function setReference($reference)
    {
        $this->container['reference'] = $reference;

        return $this;
    }

    /**
     * Gets line_amount_types
     *
     * @return \Xero2\Accounting\Model\LineAmountTypes|null
     */
    public function getLineAmountTypes()
    {
        return $this->container['line_amount_types'];
    }

    /**
     * Sets line_amount_types
     *
     * @param \Xero2\Accounting\Model\LineAmountTypes|null $line_amount_types line_amount_types
     *
     * @return self
     */
    public function setLineAmountTypes($line_amount_types)
    {
        $this->container['line_amount_types'] = $line_amount_types;

        return $this;
    }

    /**
     * Gets sub_total
     *
     * @return double|null
     */
    public function getSubTotal()
    {
        return $this->container['sub_total'];
    }

    /**
     * Sets sub_total
     *
     * @param double|null $sub_total Total of receipt excluding taxes
     *
     * @return self
     */
    public function setSubTotal($sub_total)
    {
        $this->container['sub_total'] = $sub_total;

        return $this;
    }

    /**
     * Gets total_tax
     *
     * @return double|null
     */
    public function getTotalTax()
    {
        return $this->container['total_tax'];
    }

    /**
     * Sets total_tax
     *
     * @param double|null $total_tax Total tax on receipt
     *
     * @return self
     */
    public function setTotalTax($total_tax)
    {
        $this->container['total_tax'] = $total_tax;

        return $this;
    }

    /**
     * Gets total
     *
     * @return double|null
     */
    public function getTotal()
    {
        return $this->container['total'];
    }

    /**
     * Sets total
     *
     * @param double|null $total Total of receipt tax inclusive (i.e. SubTotal + TotalTax)
     *
     * @return self
     */
    public function setTotal($total)
    {
        $this->container['total'] = $total;

        return $this;
    }

    /**
     * Gets receipt_id
     *
     * @return string|null
     */
    public function getReceiptId()
    {
        return $this->container['receipt_id'];
    }

    /**
     * Sets receipt_id
     *
     * @param string|null $receipt_id Xero generated unique identifier for receipt
     *
     * @return self
     */
    public function setReceiptId($receipt_id)
    {
        $this->container['receipt_id'] = $receipt_id;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status Current status of receipt – see status types
     *
     * @return self
     */
    public function setStatus($status)
    {
        $allowedValues = $this->getStatusAllowableValues();
        if (!is_null($status) && !in_array($status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'status', must be one of '%s'",
                    $status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets receipt_number
     *
     * @return string|null
     */
    public function getReceiptNumber()
    {
        return $this->container['receipt_number'];
    }

    /**
     * Sets receipt_number
     *
     * @param string|null $receipt_number Xero generated sequence number for receipt in current claim for a given user
     *
     * @return self
     */
    public function setReceiptNumber($receipt_number)
    {
        $this->container['receipt_number'] = $receipt_number;

        return $this;
    }

    /**
     * Gets updated_date_utc
     *
     * @return string|null
     */
    public function getUpdatedDateUtc()
    {
        return $this->container['updated_date_utc'];
    }

    /**
     * Sets updated_date_utc
     *
     * @param string|null $updated_date_utc Last modified date UTC format
     *
     * @return self
     */
    public function setUpdatedDateUtc($updated_date_utc)
    {
        $this->container['updated_date_utc'] = $updated_date_utc;

        return $this;
    }

    /**
     * Gets has_attachments
     *
     * @return bool|null
     */
    public function getHasAttachments()
    {
        return $this->container['has_attachments'];
    }

    /**
     * Sets has_attachments
     *
     * @param bool|null $has_attachments boolean to indicate if a receipt has an attachment
     *
     * @return self
     */
    public function setHasAttachments($has_attachments)
    {
        $this->container['has_attachments'] = $has_attachments;

        return $this;
    }

    /**
     * Gets url
     *
     * @return string|null
     */
    public function getUrl()
    {
        return $this->container['url'];
    }

    /**
     * Sets url
     *
     * @param string|null $url URL link to a source document – shown as “Go to [appName]” in the Xero app
     *
     * @return self
     */
    public function setUrl($url)
    {
        $this->container['url'] = $url;

        return $this;
    }

    /**
     * Gets validation_errors
     *
     * @return \Xero2\Accounting\Model\ValidationError[]|null
     */
    public function getValidationErrors()
    {
        return $this->container['validation_errors'];
    }

    /**
     * Sets validation_errors
     *
     * @param \Xero2\Accounting\Model\ValidationError[]|null $validation_errors Displays array of validation error messages from the API
     *
     * @return self
     */
    public function setValidationErrors($validation_errors)
    {
        $this->container['validation_errors'] = $validation_errors;

        return $this;
    }

    /**
     * Gets warnings
     *
     * @return \Xero2\Accounting\Model\ValidationError[]|null
     */
    public function getWarnings()
    {
        return $this->container['warnings'];
    }

    /**
     * Sets warnings
     *
     * @param \Xero2\Accounting\Model\ValidationError[]|null $warnings Displays array of warning messages from the API
     *
     * @return self
     */
    public function setWarnings($warnings)
    {
        $this->container['warnings'] = $warnings;

        return $this;
    }

    /**
     * Gets attachments
     *
     * @return \Xero2\Accounting\Model\Attachment[]|null
     */
    public function getAttachments()
    {
        return $this->container['attachments'];
    }

    /**
     * Sets attachments
     *
     * @param \Xero2\Accounting\Model\Attachment[]|null $attachments Displays array of attachments from the API
     *
     * @return self
     */
    public function setAttachments($attachments)
    {
        $this->container['attachments'] = $attachments;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


