<?php
/**
 * Payment
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Xero2\Accounting
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Xero Accounting API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.10.0
 * Contact: api@xero.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Xero2\Accounting\Model;

use \ArrayAccess;
use \Xero2\Accounting\ObjectSerializer;

/**
 * Payment Class Doc Comment
 *
 * @category Class
 * @package  Xero2\Accounting
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Payment implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Payment';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'invoice' => '\Xero2\Accounting\Model\Invoice',
        'credit_note' => '\Xero2\Accounting\Model\CreditNote',
        'prepayment' => '\Xero2\Accounting\Model\Prepayment',
        'overpayment' => '\Xero2\Accounting\Model\Overpayment',
        'invoice_number' => 'string',
        'credit_note_number' => 'string',
        'account' => '\Xero2\Accounting\Model\Account',
        'code' => 'string',
        'date' => 'string',
        'currency_rate' => 'double',
        'amount' => 'double',
        'reference' => 'string',
        'is_reconciled' => 'bool',
        'status' => 'string',
        'payment_type' => 'string',
        'updated_date_utc' => 'string',
        'payment_id' => 'string',
        'batch_payment_id' => 'string',
        'bank_account_number' => 'string',
        'particulars' => 'string',
        'details' => 'string',
        'has_account' => 'bool',
        'has_validation_errors' => 'bool',
        'status_attribute_string' => 'string',
        'validation_errors' => '\Xero2\Accounting\Model\ValidationError[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'invoice' => null,
        'credit_note' => null,
        'prepayment' => null,
        'overpayment' => null,
        'invoice_number' => null,
        'credit_note_number' => null,
        'account' => null,
        'code' => null,
        'date' => null,
        'currency_rate' => 'double',
        'amount' => 'double',
        'reference' => null,
        'is_reconciled' => null,
        'status' => null,
        'payment_type' => null,
        'updated_date_utc' => null,
        'payment_id' => 'uuid',
        'batch_payment_id' => 'uuid',
        'bank_account_number' => null,
        'particulars' => null,
        'details' => null,
        'has_account' => null,
        'has_validation_errors' => null,
        'status_attribute_string' => null,
        'validation_errors' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'invoice' => 'Invoice',
        'credit_note' => 'CreditNote',
        'prepayment' => 'Prepayment',
        'overpayment' => 'Overpayment',
        'invoice_number' => 'InvoiceNumber',
        'credit_note_number' => 'CreditNoteNumber',
        'account' => 'Account',
        'code' => 'Code',
        'date' => 'Date',
        'currency_rate' => 'CurrencyRate',
        'amount' => 'Amount',
        'reference' => 'Reference',
        'is_reconciled' => 'IsReconciled',
        'status' => 'Status',
        'payment_type' => 'PaymentType',
        'updated_date_utc' => 'UpdatedDateUTC',
        'payment_id' => 'PaymentID',
        'batch_payment_id' => 'BatchPaymentID',
        'bank_account_number' => 'BankAccountNumber',
        'particulars' => 'Particulars',
        'details' => 'Details',
        'has_account' => 'HasAccount',
        'has_validation_errors' => 'HasValidationErrors',
        'status_attribute_string' => 'StatusAttributeString',
        'validation_errors' => 'ValidationErrors'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'invoice' => 'setInvoice',
        'credit_note' => 'setCreditNote',
        'prepayment' => 'setPrepayment',
        'overpayment' => 'setOverpayment',
        'invoice_number' => 'setInvoiceNumber',
        'credit_note_number' => 'setCreditNoteNumber',
        'account' => 'setAccount',
        'code' => 'setCode',
        'date' => 'setDate',
        'currency_rate' => 'setCurrencyRate',
        'amount' => 'setAmount',
        'reference' => 'setReference',
        'is_reconciled' => 'setIsReconciled',
        'status' => 'setStatus',
        'payment_type' => 'setPaymentType',
        'updated_date_utc' => 'setUpdatedDateUtc',
        'payment_id' => 'setPaymentId',
        'batch_payment_id' => 'setBatchPaymentId',
        'bank_account_number' => 'setBankAccountNumber',
        'particulars' => 'setParticulars',
        'details' => 'setDetails',
        'has_account' => 'setHasAccount',
        'has_validation_errors' => 'setHasValidationErrors',
        'status_attribute_string' => 'setStatusAttributeString',
        'validation_errors' => 'setValidationErrors'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'invoice' => 'getInvoice',
        'credit_note' => 'getCreditNote',
        'prepayment' => 'getPrepayment',
        'overpayment' => 'getOverpayment',
        'invoice_number' => 'getInvoiceNumber',
        'credit_note_number' => 'getCreditNoteNumber',
        'account' => 'getAccount',
        'code' => 'getCode',
        'date' => 'getDate',
        'currency_rate' => 'getCurrencyRate',
        'amount' => 'getAmount',
        'reference' => 'getReference',
        'is_reconciled' => 'getIsReconciled',
        'status' => 'getStatus',
        'payment_type' => 'getPaymentType',
        'updated_date_utc' => 'getUpdatedDateUtc',
        'payment_id' => 'getPaymentId',
        'batch_payment_id' => 'getBatchPaymentId',
        'bank_account_number' => 'getBankAccountNumber',
        'particulars' => 'getParticulars',
        'details' => 'getDetails',
        'has_account' => 'getHasAccount',
        'has_validation_errors' => 'getHasValidationErrors',
        'status_attribute_string' => 'getStatusAttributeString',
        'validation_errors' => 'getValidationErrors'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const STATUS_AUTHORISED = 'AUTHORISED';
    public const STATUS_DELETED = 'DELETED';
    public const PAYMENT_TYPE_ACCRECPAYMENT = 'ACCRECPAYMENT';
    public const PAYMENT_TYPE_ACCPAYPAYMENT = 'ACCPAYPAYMENT';
    public const PAYMENT_TYPE_ARCREDITPAYMENT = 'ARCREDITPAYMENT';
    public const PAYMENT_TYPE_APCREDITPAYMENT = 'APCREDITPAYMENT';
    public const PAYMENT_TYPE_AROVERPAYMENTPAYMENT = 'AROVERPAYMENTPAYMENT';
    public const PAYMENT_TYPE_ARPREPAYMENTPAYMENT = 'ARPREPAYMENTPAYMENT';
    public const PAYMENT_TYPE_APPREPAYMENTPAYMENT = 'APPREPAYMENTPAYMENT';
    public const PAYMENT_TYPE_APOVERPAYMENTPAYMENT = 'APOVERPAYMENTPAYMENT';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_AUTHORISED,
            self::STATUS_DELETED,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getPaymentTypeAllowableValues()
    {
        return [
            self::PAYMENT_TYPE_ACCRECPAYMENT,
            self::PAYMENT_TYPE_ACCPAYPAYMENT,
            self::PAYMENT_TYPE_ARCREDITPAYMENT,
            self::PAYMENT_TYPE_APCREDITPAYMENT,
            self::PAYMENT_TYPE_AROVERPAYMENTPAYMENT,
            self::PAYMENT_TYPE_ARPREPAYMENTPAYMENT,
            self::PAYMENT_TYPE_APPREPAYMENTPAYMENT,
            self::PAYMENT_TYPE_APOVERPAYMENTPAYMENT,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['invoice'] = $data['invoice'] ?? null;
        $this->container['credit_note'] = $data['credit_note'] ?? null;
        $this->container['prepayment'] = $data['prepayment'] ?? null;
        $this->container['overpayment'] = $data['overpayment'] ?? null;
        $this->container['invoice_number'] = $data['invoice_number'] ?? null;
        $this->container['credit_note_number'] = $data['credit_note_number'] ?? null;
        $this->container['account'] = $data['account'] ?? null;
        $this->container['code'] = $data['code'] ?? null;
        $this->container['date'] = $data['date'] ?? null;
        $this->container['currency_rate'] = $data['currency_rate'] ?? null;
        $this->container['amount'] = $data['amount'] ?? null;
        $this->container['reference'] = $data['reference'] ?? null;
        $this->container['is_reconciled'] = $data['is_reconciled'] ?? null;
        $this->container['status'] = $data['status'] ?? null;
        $this->container['payment_type'] = $data['payment_type'] ?? null;
        $this->container['updated_date_utc'] = $data['updated_date_utc'] ?? null;
        $this->container['payment_id'] = $data['payment_id'] ?? null;
        $this->container['batch_payment_id'] = $data['batch_payment_id'] ?? null;
        $this->container['bank_account_number'] = $data['bank_account_number'] ?? null;
        $this->container['particulars'] = $data['particulars'] ?? null;
        $this->container['details'] = $data['details'] ?? null;
        $this->container['has_account'] = $data['has_account'] ?? false;
        $this->container['has_validation_errors'] = $data['has_validation_errors'] ?? false;
        $this->container['status_attribute_string'] = $data['status_attribute_string'] ?? null;
        $this->container['validation_errors'] = $data['validation_errors'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getStatusAllowableValues();
        if (!is_null($this->container['status']) && !in_array($this->container['status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'status', must be one of '%s'",
                $this->container['status'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getPaymentTypeAllowableValues();
        if (!is_null($this->container['payment_type']) && !in_array($this->container['payment_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'payment_type', must be one of '%s'",
                $this->container['payment_type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets invoice
     *
     * @return \Xero2\Accounting\Model\Invoice|null
     */
    public function getInvoice()
    {
        return $this->container['invoice'];
    }

    /**
     * Sets invoice
     *
     * @param \Xero2\Accounting\Model\Invoice|null $invoice invoice
     *
     * @return self
     */
    public function setInvoice($invoice)
    {
        $this->container['invoice'] = $invoice;

        return $this;
    }

    /**
     * Gets credit_note
     *
     * @return \Xero2\Accounting\Model\CreditNote|null
     */
    public function getCreditNote()
    {
        return $this->container['credit_note'];
    }

    /**
     * Sets credit_note
     *
     * @param \Xero2\Accounting\Model\CreditNote|null $credit_note credit_note
     *
     * @return self
     */
    public function setCreditNote($credit_note)
    {
        $this->container['credit_note'] = $credit_note;

        return $this;
    }

    /**
     * Gets prepayment
     *
     * @return \Xero2\Accounting\Model\Prepayment|null
     */
    public function getPrepayment()
    {
        return $this->container['prepayment'];
    }

    /**
     * Sets prepayment
     *
     * @param \Xero2\Accounting\Model\Prepayment|null $prepayment prepayment
     *
     * @return self
     */
    public function setPrepayment($prepayment)
    {
        $this->container['prepayment'] = $prepayment;

        return $this;
    }

    /**
     * Gets overpayment
     *
     * @return \Xero2\Accounting\Model\Overpayment|null
     */
    public function getOverpayment()
    {
        return $this->container['overpayment'];
    }

    /**
     * Sets overpayment
     *
     * @param \Xero2\Accounting\Model\Overpayment|null $overpayment overpayment
     *
     * @return self
     */
    public function setOverpayment($overpayment)
    {
        $this->container['overpayment'] = $overpayment;

        return $this;
    }

    /**
     * Gets invoice_number
     *
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->container['invoice_number'];
    }

    /**
     * Sets invoice_number
     *
     * @param string|null $invoice_number Number of invoice or credit note you are applying payment to e.g.INV-4003
     *
     * @return self
     */
    public function setInvoiceNumber($invoice_number)
    {
        $this->container['invoice_number'] = $invoice_number;

        return $this;
    }

    /**
     * Gets credit_note_number
     *
     * @return string|null
     */
    public function getCreditNoteNumber()
    {
        return $this->container['credit_note_number'];
    }

    /**
     * Sets credit_note_number
     *
     * @param string|null $credit_note_number Number of invoice or credit note you are applying payment to e.g. INV-4003
     *
     * @return self
     */
    public function setCreditNoteNumber($credit_note_number)
    {
        $this->container['credit_note_number'] = $credit_note_number;

        return $this;
    }

    /**
     * Gets account
     *
     * @return \Xero2\Accounting\Model\Account|null
     */
    public function getAccount()
    {
        return $this->container['account'];
    }

    /**
     * Sets account
     *
     * @param \Xero2\Accounting\Model\Account|null $account account
     *
     * @return self
     */
    public function setAccount($account)
    {
        $this->container['account'] = $account;

        return $this;
    }

    /**
     * Gets code
     *
     * @return string|null
     */
    public function getCode()
    {
        return $this->container['code'];
    }

    /**
     * Sets code
     *
     * @param string|null $code Code of account you are using to make the payment e.g. 001 (note- not all accounts have a code value)
     *
     * @return self
     */
    public function setCode($code)
    {
        $this->container['code'] = $code;

        return $this;
    }

    /**
     * Gets date
     *
     * @return string|null
     */
    public function getDate()
    {
        return $this->container['date'];
    }

    /**
     * Sets date
     *
     * @param string|null $date Date the payment is being made (YYYY-MM-DD) e.g. 2009-09-06
     *
     * @return self
     */
    public function setDate($date)
    {
        $this->container['date'] = $date;

        return $this;
    }

    /**
     * Gets currency_rate
     *
     * @return double|null
     */
    public function getCurrencyRate()
    {
        return $this->container['currency_rate'];
    }

    /**
     * Sets currency_rate
     *
     * @param double|null $currency_rate Exchange rate when payment is received. Only used for non base currency invoices and credit notes e.g. 0.7500
     *
     * @return self
     */
    public function setCurrencyRate($currency_rate)
    {
        $this->container['currency_rate'] = $currency_rate;

        return $this;
    }

    /**
     * Gets amount
     *
     * @return double|null
     */
    public function getAmount()
    {
        return $this->container['amount'];
    }

    /**
     * Sets amount
     *
     * @param double|null $amount The amount of the payment. Must be less than or equal to the outstanding amount owing on the invoice e.g. 200.00
     *
     * @return self
     */
    public function setAmount($amount)
    {
        $this->container['amount'] = $amount;

        return $this;
    }

    /**
     * Gets reference
     *
     * @return string|null
     */
    public function getReference()
    {
        return $this->container['reference'];
    }

    /**
     * Sets reference
     *
     * @param string|null $reference An optional description for the payment e.g. Direct Debit
     *
     * @return self
     */
    public function setReference($reference)
    {
        $this->container['reference'] = $reference;

        return $this;
    }

    /**
     * Gets is_reconciled
     *
     * @return bool|null
     */
    public function getIsReconciled()
    {
        return $this->container['is_reconciled'];
    }

    /**
     * Sets is_reconciled
     *
     * @param bool|null $is_reconciled An optional parameter for the payment. A boolean indicating whether you would like the payment to be created as reconciled when using PUT, or whether a payment has been reconciled when using GET
     *
     * @return self
     */
    public function setIsReconciled($is_reconciled)
    {
        $this->container['is_reconciled'] = $is_reconciled;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status The status of the payment.
     *
     * @return self
     */
    public function setStatus($status)
    {
        $allowedValues = $this->getStatusAllowableValues();
        if (!is_null($status) && !in_array($status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'status', must be one of '%s'",
                    $status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets payment_type
     *
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->container['payment_type'];
    }

    /**
     * Sets payment_type
     *
     * @param string|null $payment_type See Payment Types.
     *
     * @return self
     */
    public function setPaymentType($payment_type)
    {
        $allowedValues = $this->getPaymentTypeAllowableValues();
        if (!is_null($payment_type) && !in_array($payment_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'payment_type', must be one of '%s'",
                    $payment_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['payment_type'] = $payment_type;

        return $this;
    }

    /**
     * Gets updated_date_utc
     *
     * @return string|null
     */
    public function getUpdatedDateUtc()
    {
        return $this->container['updated_date_utc'];
    }

    /**
     * Sets updated_date_utc
     *
     * @param string|null $updated_date_utc UTC timestamp of last update to the payment
     *
     * @return self
     */
    public function setUpdatedDateUtc($updated_date_utc)
    {
        $this->container['updated_date_utc'] = $updated_date_utc;

        return $this;
    }

    /**
     * Gets payment_id
     *
     * @return string|null
     */
    public function getPaymentId()
    {
        return $this->container['payment_id'];
    }

    /**
     * Sets payment_id
     *
     * @param string|null $payment_id The Xero identifier for an Payment e.g. 297c2dc5-cc47-4afd-8ec8-74990b8761e9
     *
     * @return self
     */
    public function setPaymentId($payment_id)
    {
        $this->container['payment_id'] = $payment_id;

        return $this;
    }

    /**
     * Gets batch_payment_id
     *
     * @return string|null
     */
    public function getBatchPaymentId()
    {
        return $this->container['batch_payment_id'];
    }

    /**
     * Sets batch_payment_id
     *
     * @param string|null $batch_payment_id Present if the payment was created as part of a batch.
     *
     * @return self
     */
    public function setBatchPaymentId($batch_payment_id)
    {
        $this->container['batch_payment_id'] = $batch_payment_id;

        return $this;
    }

    /**
     * Gets bank_account_number
     *
     * @return string|null
     */
    public function getBankAccountNumber()
    {
        return $this->container['bank_account_number'];
    }

    /**
     * Sets bank_account_number
     *
     * @param string|null $bank_account_number The suppliers bank account number the payment is being made to
     *
     * @return self
     */
    public function setBankAccountNumber($bank_account_number)
    {
        $this->container['bank_account_number'] = $bank_account_number;

        return $this;
    }

    /**
     * Gets particulars
     *
     * @return string|null
     */
    public function getParticulars()
    {
        return $this->container['particulars'];
    }

    /**
     * Sets particulars
     *
     * @param string|null $particulars The suppliers bank account number the payment is being made to
     *
     * @return self
     */
    public function setParticulars($particulars)
    {
        $this->container['particulars'] = $particulars;

        return $this;
    }

    /**
     * Gets details
     *
     * @return string|null
     */
    public function getDetails()
    {
        return $this->container['details'];
    }

    /**
     * Sets details
     *
     * @param string|null $details The information to appear on the supplier's bank account
     *
     * @return self
     */
    public function setDetails($details)
    {
        $this->container['details'] = $details;

        return $this;
    }

    /**
     * Gets has_account
     *
     * @return bool|null
     */
    public function getHasAccount()
    {
        return $this->container['has_account'];
    }

    /**
     * Sets has_account
     *
     * @param bool|null $has_account A boolean to indicate if a contact has an validation errors
     *
     * @return self
     */
    public function setHasAccount($has_account)
    {
        $this->container['has_account'] = $has_account;

        return $this;
    }

    /**
     * Gets has_validation_errors
     *
     * @return bool|null
     */
    public function getHasValidationErrors()
    {
        return $this->container['has_validation_errors'];
    }

    /**
     * Sets has_validation_errors
     *
     * @param bool|null $has_validation_errors A boolean to indicate if a contact has an validation errors
     *
     * @return self
     */
    public function setHasValidationErrors($has_validation_errors)
    {
        $this->container['has_validation_errors'] = $has_validation_errors;

        return $this;
    }

    /**
     * Gets status_attribute_string
     *
     * @return string|null
     */
    public function getStatusAttributeString()
    {
        return $this->container['status_attribute_string'];
    }

    /**
     * Sets status_attribute_string
     *
     * @param string|null $status_attribute_string A string to indicate if a invoice status
     *
     * @return self
     */
    public function setStatusAttributeString($status_attribute_string)
    {
        $this->container['status_attribute_string'] = $status_attribute_string;

        return $this;
    }

    /**
     * Gets validation_errors
     *
     * @return \Xero2\Accounting\Model\ValidationError[]|null
     */
    public function getValidationErrors()
    {
        return $this->container['validation_errors'];
    }

    /**
     * Sets validation_errors
     *
     * @param \Xero2\Accounting\Model\ValidationError[]|null $validation_errors Displays array of validation error messages from the API
     *
     * @return self
     */
    public function setValidationErrors($validation_errors)
    {
        $this->container['validation_errors'] = $validation_errors;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


