<?php
/**
 * Organisation
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Xero2\Accounting
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Xero Accounting API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.10.0
 * Contact: api@xero.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Xero2\Accounting\Model;

use \ArrayAccess;
use \Xero2\Accounting\ObjectSerializer;

/**
 * Organisation Class Doc Comment
 *
 * @category Class
 * @package  Xero2\Accounting
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Organisation implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Organisation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'organisation_id' => 'string',
        'api_key' => 'string',
        'name' => 'string',
        'legal_name' => 'string',
        'pays_tax' => 'bool',
        'version' => 'string',
        'organisation_type' => 'string',
        'base_currency' => '\Xero2\Accounting\Model\CurrencyCode',
        'country_code' => '\Xero2\Accounting\Model\CountryCode',
        'is_demo_company' => 'bool',
        'organisation_status' => 'string',
        'registration_number' => 'string',
        'employer_identification_number' => 'string',
        'tax_number' => 'string',
        'financial_year_end_day' => 'int',
        'financial_year_end_month' => 'int',
        'sales_tax_basis' => 'string',
        'sales_tax_period' => 'string',
        'default_sales_tax' => 'string',
        'default_purchases_tax' => 'string',
        'period_lock_date' => 'string',
        'end_of_year_lock_date' => 'string',
        'created_date_utc' => 'string',
        'timezone' => '\Xero2\Accounting\Model\TimeZone',
        'organisation_entity_type' => 'string',
        'short_code' => 'string',
        'class' => 'string',
        'edition' => 'string',
        'line_of_business' => 'string',
        'addresses' => '\Xero2\Accounting\Model\AddressForOrganisation[]',
        'phones' => '\Xero2\Accounting\Model\Phone[]',
        'external_links' => '\Xero2\Accounting\Model\ExternalLink[]',
        'payment_terms' => '\Xero2\Accounting\Model\PaymentTerm'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'organisation_id' => 'uuid',
        'api_key' => null,
        'name' => null,
        'legal_name' => null,
        'pays_tax' => null,
        'version' => null,
        'organisation_type' => null,
        'base_currency' => null,
        'country_code' => null,
        'is_demo_company' => null,
        'organisation_status' => null,
        'registration_number' => null,
        'employer_identification_number' => null,
        'tax_number' => null,
        'financial_year_end_day' => null,
        'financial_year_end_month' => null,
        'sales_tax_basis' => null,
        'sales_tax_period' => null,
        'default_sales_tax' => null,
        'default_purchases_tax' => null,
        'period_lock_date' => null,
        'end_of_year_lock_date' => null,
        'created_date_utc' => null,
        'timezone' => null,
        'organisation_entity_type' => null,
        'short_code' => null,
        'class' => null,
        'edition' => null,
        'line_of_business' => null,
        'addresses' => null,
        'phones' => null,
        'external_links' => null,
        'payment_terms' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'organisation_id' => 'OrganisationID',
        'api_key' => 'APIKey',
        'name' => 'Name',
        'legal_name' => 'LegalName',
        'pays_tax' => 'PaysTax',
        'version' => 'Version',
        'organisation_type' => 'OrganisationType',
        'base_currency' => 'BaseCurrency',
        'country_code' => 'CountryCode',
        'is_demo_company' => 'IsDemoCompany',
        'organisation_status' => 'OrganisationStatus',
        'registration_number' => 'RegistrationNumber',
        'employer_identification_number' => 'EmployerIdentificationNumber',
        'tax_number' => 'TaxNumber',
        'financial_year_end_day' => 'FinancialYearEndDay',
        'financial_year_end_month' => 'FinancialYearEndMonth',
        'sales_tax_basis' => 'SalesTaxBasis',
        'sales_tax_period' => 'SalesTaxPeriod',
        'default_sales_tax' => 'DefaultSalesTax',
        'default_purchases_tax' => 'DefaultPurchasesTax',
        'period_lock_date' => 'PeriodLockDate',
        'end_of_year_lock_date' => 'EndOfYearLockDate',
        'created_date_utc' => 'CreatedDateUTC',
        'timezone' => 'Timezone',
        'organisation_entity_type' => 'OrganisationEntityType',
        'short_code' => 'ShortCode',
        'class' => 'Class',
        'edition' => 'Edition',
        'line_of_business' => 'LineOfBusiness',
        'addresses' => 'Addresses',
        'phones' => 'Phones',
        'external_links' => 'ExternalLinks',
        'payment_terms' => 'PaymentTerms'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'organisation_id' => 'setOrganisationId',
        'api_key' => 'setApiKey',
        'name' => 'setName',
        'legal_name' => 'setLegalName',
        'pays_tax' => 'setPaysTax',
        'version' => 'setVersion',
        'organisation_type' => 'setOrganisationType',
        'base_currency' => 'setBaseCurrency',
        'country_code' => 'setCountryCode',
        'is_demo_company' => 'setIsDemoCompany',
        'organisation_status' => 'setOrganisationStatus',
        'registration_number' => 'setRegistrationNumber',
        'employer_identification_number' => 'setEmployerIdentificationNumber',
        'tax_number' => 'setTaxNumber',
        'financial_year_end_day' => 'setFinancialYearEndDay',
        'financial_year_end_month' => 'setFinancialYearEndMonth',
        'sales_tax_basis' => 'setSalesTaxBasis',
        'sales_tax_period' => 'setSalesTaxPeriod',
        'default_sales_tax' => 'setDefaultSalesTax',
        'default_purchases_tax' => 'setDefaultPurchasesTax',
        'period_lock_date' => 'setPeriodLockDate',
        'end_of_year_lock_date' => 'setEndOfYearLockDate',
        'created_date_utc' => 'setCreatedDateUtc',
        'timezone' => 'setTimezone',
        'organisation_entity_type' => 'setOrganisationEntityType',
        'short_code' => 'setShortCode',
        'class' => 'setClass',
        'edition' => 'setEdition',
        'line_of_business' => 'setLineOfBusiness',
        'addresses' => 'setAddresses',
        'phones' => 'setPhones',
        'external_links' => 'setExternalLinks',
        'payment_terms' => 'setPaymentTerms'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'organisation_id' => 'getOrganisationId',
        'api_key' => 'getApiKey',
        'name' => 'getName',
        'legal_name' => 'getLegalName',
        'pays_tax' => 'getPaysTax',
        'version' => 'getVersion',
        'organisation_type' => 'getOrganisationType',
        'base_currency' => 'getBaseCurrency',
        'country_code' => 'getCountryCode',
        'is_demo_company' => 'getIsDemoCompany',
        'organisation_status' => 'getOrganisationStatus',
        'registration_number' => 'getRegistrationNumber',
        'employer_identification_number' => 'getEmployerIdentificationNumber',
        'tax_number' => 'getTaxNumber',
        'financial_year_end_day' => 'getFinancialYearEndDay',
        'financial_year_end_month' => 'getFinancialYearEndMonth',
        'sales_tax_basis' => 'getSalesTaxBasis',
        'sales_tax_period' => 'getSalesTaxPeriod',
        'default_sales_tax' => 'getDefaultSalesTax',
        'default_purchases_tax' => 'getDefaultPurchasesTax',
        'period_lock_date' => 'getPeriodLockDate',
        'end_of_year_lock_date' => 'getEndOfYearLockDate',
        'created_date_utc' => 'getCreatedDateUtc',
        'timezone' => 'getTimezone',
        'organisation_entity_type' => 'getOrganisationEntityType',
        'short_code' => 'getShortCode',
        'class' => 'getClass',
        'edition' => 'getEdition',
        'line_of_business' => 'getLineOfBusiness',
        'addresses' => 'getAddresses',
        'phones' => 'getPhones',
        'external_links' => 'getExternalLinks',
        'payment_terms' => 'getPaymentTerms'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const VERSION_AU = 'AU';
    public const VERSION_NZ = 'NZ';
    public const VERSION__GLOBAL = 'GLOBAL';
    public const VERSION_UK = 'UK';
    public const VERSION_US = 'US';
    public const VERSION_AUONRAMP = 'AUONRAMP';
    public const VERSION_NZONRAMP = 'NZONRAMP';
    public const VERSION_GLOBALONRAMP = 'GLOBALONRAMP';
    public const VERSION_UKONRAMP = 'UKONRAMP';
    public const VERSION_USONRAMP = 'USONRAMP';
    public const ORGANISATION_TYPE_ACCOUNTING_PRACTICE = 'ACCOUNTING_PRACTICE';
    public const ORGANISATION_TYPE_COMPANY = 'COMPANY';
    public const ORGANISATION_TYPE_CHARITY = 'CHARITY';
    public const ORGANISATION_TYPE_CLUB_OR_SOCIETY = 'CLUB_OR_SOCIETY';
    public const ORGANISATION_TYPE_LOOK_THROUGH_COMPANY = 'LOOK_THROUGH_COMPANY';
    public const ORGANISATION_TYPE_NOT_FOR_PROFIT = 'NOT_FOR_PROFIT';
    public const ORGANISATION_TYPE_PARTNERSHIP = 'PARTNERSHIP';
    public const ORGANISATION_TYPE_S_CORPORATION = 'S_CORPORATION';
    public const ORGANISATION_TYPE_SELF_MANAGED_SUPERANNUATION_FUND = 'SELF_MANAGED_SUPERANNUATION_FUND';
    public const ORGANISATION_TYPE_SOLE_TRADER = 'SOLE_TRADER';
    public const ORGANISATION_TYPE_SUPERANNUATION_FUND = 'SUPERANNUATION_FUND';
    public const ORGANISATION_TYPE_TRUST = 'TRUST';
    public const SALES_TAX_BASIS_PAYMENTS = 'PAYMENTS';
    public const SALES_TAX_BASIS_INVOICE = 'INVOICE';
    public const SALES_TAX_BASIS_NONE = 'NONE';
    public const SALES_TAX_BASIS_CASH = 'CASH';
    public const SALES_TAX_BASIS_ACCRUAL = 'ACCRUAL';
    public const SALES_TAX_BASIS_FLATRATECASH = 'FLATRATECASH';
    public const SALES_TAX_BASIS_FLATRATEACCRUAL = 'FLATRATEACCRUAL';
    public const SALES_TAX_BASIS_ACCRUALS = 'ACCRUALS';
    public const SALES_TAX_PERIOD_MONTHLY = 'MONTHLY';
    public const SALES_TAX_PERIOD_QUARTERLY1 = 'QUARTERLY1';
    public const SALES_TAX_PERIOD_QUARTERLY2 = 'QUARTERLY2';
    public const SALES_TAX_PERIOD_QUARTERLY3 = 'QUARTERLY3';
    public const SALES_TAX_PERIOD_ANNUALLY = 'ANNUALLY';
    public const SALES_TAX_PERIOD_ONEMONTHS = 'ONEMONTHS';
    public const SALES_TAX_PERIOD_TWOMONTHS = 'TWOMONTHS';
    public const SALES_TAX_PERIOD_SIXMONTHS = 'SIXMONTHS';
    public const SALES_TAX_PERIOD__1_MONTHLY = '1MONTHLY';
    public const SALES_TAX_PERIOD__2_MONTHLY = '2MONTHLY';
    public const SALES_TAX_PERIOD__3_MONTHLY = '3MONTHLY';
    public const SALES_TAX_PERIOD__6_MONTHLY = '6MONTHLY';
    public const SALES_TAX_PERIOD_QUARTERLY = 'QUARTERLY';
    public const SALES_TAX_PERIOD_YEARLY = 'YEARLY';
    public const SALES_TAX_PERIOD_NONE = 'NONE';
    public const ORGANISATION_ENTITY_TYPE_ACCOUNTING_PRACTICE = 'ACCOUNTING_PRACTICE';
    public const ORGANISATION_ENTITY_TYPE_COMPANY = 'COMPANY';
    public const ORGANISATION_ENTITY_TYPE_CHARITY = 'CHARITY';
    public const ORGANISATION_ENTITY_TYPE_CLUB_OR_SOCIETY = 'CLUB_OR_SOCIETY';
    public const ORGANISATION_ENTITY_TYPE_LOOK_THROUGH_COMPANY = 'LOOK_THROUGH_COMPANY';
    public const ORGANISATION_ENTITY_TYPE_NOT_FOR_PROFIT = 'NOT_FOR_PROFIT';
    public const ORGANISATION_ENTITY_TYPE_PARTNERSHIP = 'PARTNERSHIP';
    public const ORGANISATION_ENTITY_TYPE_S_CORPORATION = 'S_CORPORATION';
    public const ORGANISATION_ENTITY_TYPE_SELF_MANAGED_SUPERANNUATION_FUND = 'SELF_MANAGED_SUPERANNUATION_FUND';
    public const ORGANISATION_ENTITY_TYPE_SOLE_TRADER = 'SOLE_TRADER';
    public const ORGANISATION_ENTITY_TYPE_SUPERANNUATION_FUND = 'SUPERANNUATION_FUND';
    public const ORGANISATION_ENTITY_TYPE_TRUST = 'TRUST';
    public const MODEL_CLASS_DEMO = 'DEMO';
    public const MODEL_CLASS_TRIAL = 'TRIAL';
    public const MODEL_CLASS_STARTER = 'STARTER';
    public const MODEL_CLASS_STANDARD = 'STANDARD';
    public const MODEL_CLASS_PREMIUM = 'PREMIUM';
    public const MODEL_CLASS_PREMIUM_20 = 'PREMIUM_20';
    public const MODEL_CLASS_PREMIUM_50 = 'PREMIUM_50';
    public const MODEL_CLASS_PREMIUM_100 = 'PREMIUM_100';
    public const MODEL_CLASS_LEDGER = 'LEDGER';
    public const MODEL_CLASS_GST_CASHBOOK = 'GST_CASHBOOK';
    public const MODEL_CLASS_NON_GST_CASHBOOK = 'NON_GST_CASHBOOK';
    public const EDITION_BUSINESS = 'BUSINESS';
    public const EDITION_PARTNER = 'PARTNER';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getVersionAllowableValues()
    {
        return [
            self::VERSION_AU,
            self::VERSION_NZ,
            self::VERSION__GLOBAL,
            self::VERSION_UK,
            self::VERSION_US,
            self::VERSION_AUONRAMP,
            self::VERSION_NZONRAMP,
            self::VERSION_GLOBALONRAMP,
            self::VERSION_UKONRAMP,
            self::VERSION_USONRAMP,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getOrganisationTypeAllowableValues()
    {
        return [
            self::ORGANISATION_TYPE_ACCOUNTING_PRACTICE,
            self::ORGANISATION_TYPE_COMPANY,
            self::ORGANISATION_TYPE_CHARITY,
            self::ORGANISATION_TYPE_CLUB_OR_SOCIETY,
            self::ORGANISATION_TYPE_LOOK_THROUGH_COMPANY,
            self::ORGANISATION_TYPE_NOT_FOR_PROFIT,
            self::ORGANISATION_TYPE_PARTNERSHIP,
            self::ORGANISATION_TYPE_S_CORPORATION,
            self::ORGANISATION_TYPE_SELF_MANAGED_SUPERANNUATION_FUND,
            self::ORGANISATION_TYPE_SOLE_TRADER,
            self::ORGANISATION_TYPE_SUPERANNUATION_FUND,
            self::ORGANISATION_TYPE_TRUST,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getSalesTaxBasisAllowableValues()
    {
        return [
            self::SALES_TAX_BASIS_PAYMENTS,
            self::SALES_TAX_BASIS_INVOICE,
            self::SALES_TAX_BASIS_NONE,
            self::SALES_TAX_BASIS_CASH,
            self::SALES_TAX_BASIS_ACCRUAL,
            self::SALES_TAX_BASIS_FLATRATECASH,
            self::SALES_TAX_BASIS_FLATRATEACCRUAL,
            self::SALES_TAX_BASIS_ACCRUALS,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getSalesTaxPeriodAllowableValues()
    {
        return [
            self::SALES_TAX_PERIOD_MONTHLY,
            self::SALES_TAX_PERIOD_QUARTERLY1,
            self::SALES_TAX_PERIOD_QUARTERLY2,
            self::SALES_TAX_PERIOD_QUARTERLY3,
            self::SALES_TAX_PERIOD_ANNUALLY,
            self::SALES_TAX_PERIOD_ONEMONTHS,
            self::SALES_TAX_PERIOD_TWOMONTHS,
            self::SALES_TAX_PERIOD_SIXMONTHS,
            self::SALES_TAX_PERIOD__1_MONTHLY,
            self::SALES_TAX_PERIOD__2_MONTHLY,
            self::SALES_TAX_PERIOD__3_MONTHLY,
            self::SALES_TAX_PERIOD__6_MONTHLY,
            self::SALES_TAX_PERIOD_QUARTERLY,
            self::SALES_TAX_PERIOD_YEARLY,
            self::SALES_TAX_PERIOD_NONE,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getOrganisationEntityTypeAllowableValues()
    {
        return [
            self::ORGANISATION_ENTITY_TYPE_ACCOUNTING_PRACTICE,
            self::ORGANISATION_ENTITY_TYPE_COMPANY,
            self::ORGANISATION_ENTITY_TYPE_CHARITY,
            self::ORGANISATION_ENTITY_TYPE_CLUB_OR_SOCIETY,
            self::ORGANISATION_ENTITY_TYPE_LOOK_THROUGH_COMPANY,
            self::ORGANISATION_ENTITY_TYPE_NOT_FOR_PROFIT,
            self::ORGANISATION_ENTITY_TYPE_PARTNERSHIP,
            self::ORGANISATION_ENTITY_TYPE_S_CORPORATION,
            self::ORGANISATION_ENTITY_TYPE_SELF_MANAGED_SUPERANNUATION_FUND,
            self::ORGANISATION_ENTITY_TYPE_SOLE_TRADER,
            self::ORGANISATION_ENTITY_TYPE_SUPERANNUATION_FUND,
            self::ORGANISATION_ENTITY_TYPE_TRUST,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getClassAllowableValues()
    {
        return [
            self::MODEL_CLASS_DEMO,
            self::MODEL_CLASS_TRIAL,
            self::MODEL_CLASS_STARTER,
            self::MODEL_CLASS_STANDARD,
            self::MODEL_CLASS_PREMIUM,
            self::MODEL_CLASS_PREMIUM_20,
            self::MODEL_CLASS_PREMIUM_50,
            self::MODEL_CLASS_PREMIUM_100,
            self::MODEL_CLASS_LEDGER,
            self::MODEL_CLASS_GST_CASHBOOK,
            self::MODEL_CLASS_NON_GST_CASHBOOK,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getEditionAllowableValues()
    {
        return [
            self::EDITION_BUSINESS,
            self::EDITION_PARTNER,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['organisation_id'] = $data['organisation_id'] ?? null;
        $this->container['api_key'] = $data['api_key'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['legal_name'] = $data['legal_name'] ?? null;
        $this->container['pays_tax'] = $data['pays_tax'] ?? null;
        $this->container['version'] = $data['version'] ?? null;
        $this->container['organisation_type'] = $data['organisation_type'] ?? null;
        $this->container['base_currency'] = $data['base_currency'] ?? null;
        $this->container['country_code'] = $data['country_code'] ?? null;
        $this->container['is_demo_company'] = $data['is_demo_company'] ?? null;
        $this->container['organisation_status'] = $data['organisation_status'] ?? null;
        $this->container['registration_number'] = $data['registration_number'] ?? null;
        $this->container['employer_identification_number'] = $data['employer_identification_number'] ?? null;
        $this->container['tax_number'] = $data['tax_number'] ?? null;
        $this->container['financial_year_end_day'] = $data['financial_year_end_day'] ?? null;
        $this->container['financial_year_end_month'] = $data['financial_year_end_month'] ?? null;
        $this->container['sales_tax_basis'] = $data['sales_tax_basis'] ?? null;
        $this->container['sales_tax_period'] = $data['sales_tax_period'] ?? null;
        $this->container['default_sales_tax'] = $data['default_sales_tax'] ?? null;
        $this->container['default_purchases_tax'] = $data['default_purchases_tax'] ?? null;
        $this->container['period_lock_date'] = $data['period_lock_date'] ?? null;
        $this->container['end_of_year_lock_date'] = $data['end_of_year_lock_date'] ?? null;
        $this->container['created_date_utc'] = $data['created_date_utc'] ?? null;
        $this->container['timezone'] = $data['timezone'] ?? null;
        $this->container['organisation_entity_type'] = $data['organisation_entity_type'] ?? null;
        $this->container['short_code'] = $data['short_code'] ?? null;
        $this->container['class'] = $data['class'] ?? null;
        $this->container['edition'] = $data['edition'] ?? null;
        $this->container['line_of_business'] = $data['line_of_business'] ?? null;
        $this->container['addresses'] = $data['addresses'] ?? null;
        $this->container['phones'] = $data['phones'] ?? null;
        $this->container['external_links'] = $data['external_links'] ?? null;
        $this->container['payment_terms'] = $data['payment_terms'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getVersionAllowableValues();
        if (!is_null($this->container['version']) && !in_array($this->container['version'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'version', must be one of '%s'",
                $this->container['version'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getOrganisationTypeAllowableValues();
        if (!is_null($this->container['organisation_type']) && !in_array($this->container['organisation_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'organisation_type', must be one of '%s'",
                $this->container['organisation_type'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getSalesTaxBasisAllowableValues();
        if (!is_null($this->container['sales_tax_basis']) && !in_array($this->container['sales_tax_basis'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'sales_tax_basis', must be one of '%s'",
                $this->container['sales_tax_basis'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getSalesTaxPeriodAllowableValues();
        if (!is_null($this->container['sales_tax_period']) && !in_array($this->container['sales_tax_period'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'sales_tax_period', must be one of '%s'",
                $this->container['sales_tax_period'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getOrganisationEntityTypeAllowableValues();
        if (!is_null($this->container['organisation_entity_type']) && !in_array($this->container['organisation_entity_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'organisation_entity_type', must be one of '%s'",
                $this->container['organisation_entity_type'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getClassAllowableValues();
        if (!is_null($this->container['class']) && !in_array($this->container['class'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'class', must be one of '%s'",
                $this->container['class'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getEditionAllowableValues();
        if (!is_null($this->container['edition']) && !in_array($this->container['edition'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'edition', must be one of '%s'",
                $this->container['edition'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets organisation_id
     *
     * @return string|null
     */
    public function getOrganisationId()
    {
        return $this->container['organisation_id'];
    }

    /**
     * Sets organisation_id
     *
     * @param string|null $organisation_id Unique Xero identifier
     *
     * @return self
     */
    public function setOrganisationId($organisation_id)
    {
        $this->container['organisation_id'] = $organisation_id;

        return $this;
    }

    /**
     * Gets api_key
     *
     * @return string|null
     */
    public function getApiKey()
    {
        return $this->container['api_key'];
    }

    /**
     * Sets api_key
     *
     * @param string|null $api_key Display a unique key used for Xero-to-Xero transactions
     *
     * @return self
     */
    public function setApiKey($api_key)
    {
        $this->container['api_key'] = $api_key;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name Display name of organisation shown in Xero
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets legal_name
     *
     * @return string|null
     */
    public function getLegalName()
    {
        return $this->container['legal_name'];
    }

    /**
     * Sets legal_name
     *
     * @param string|null $legal_name Organisation name shown on Reports
     *
     * @return self
     */
    public function setLegalName($legal_name)
    {
        $this->container['legal_name'] = $legal_name;

        return $this;
    }

    /**
     * Gets pays_tax
     *
     * @return bool|null
     */
    public function getPaysTax()
    {
        return $this->container['pays_tax'];
    }

    /**
     * Sets pays_tax
     *
     * @param bool|null $pays_tax Boolean to describe if organisation is registered with a local tax authority i.e. true, false
     *
     * @return self
     */
    public function setPaysTax($pays_tax)
    {
        $this->container['pays_tax'] = $pays_tax;

        return $this;
    }

    /**
     * Gets version
     *
     * @return string|null
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     *
     * @param string|null $version See Version Types
     *
     * @return self
     */
    public function setVersion($version)
    {
        $allowedValues = $this->getVersionAllowableValues();
        if (!is_null($version) && !in_array($version, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'version', must be one of '%s'",
                    $version,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets organisation_type
     *
     * @return string|null
     */
    public function getOrganisationType()
    {
        return $this->container['organisation_type'];
    }

    /**
     * Sets organisation_type
     *
     * @param string|null $organisation_type Organisation Type
     *
     * @return self
     */
    public function setOrganisationType($organisation_type)
    {
        $allowedValues = $this->getOrganisationTypeAllowableValues();
        if (!is_null($organisation_type) && !in_array($organisation_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'organisation_type', must be one of '%s'",
                    $organisation_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['organisation_type'] = $organisation_type;

        return $this;
    }

    /**
     * Gets base_currency
     *
     * @return \Xero2\Accounting\Model\CurrencyCode|null
     */
    public function getBaseCurrency()
    {
        return $this->container['base_currency'];
    }

    /**
     * Sets base_currency
     *
     * @param \Xero2\Accounting\Model\CurrencyCode|null $base_currency base_currency
     *
     * @return self
     */
    public function setBaseCurrency($base_currency)
    {
        $this->container['base_currency'] = $base_currency;

        return $this;
    }

    /**
     * Gets country_code
     *
     * @return \Xero2\Accounting\Model\CountryCode|null
     */
    public function getCountryCode()
    {
        return $this->container['country_code'];
    }

    /**
     * Sets country_code
     *
     * @param \Xero2\Accounting\Model\CountryCode|null $country_code country_code
     *
     * @return self
     */
    public function setCountryCode($country_code)
    {
        $this->container['country_code'] = $country_code;

        return $this;
    }

    /**
     * Gets is_demo_company
     *
     * @return bool|null
     */
    public function getIsDemoCompany()
    {
        return $this->container['is_demo_company'];
    }

    /**
     * Sets is_demo_company
     *
     * @param bool|null $is_demo_company Boolean to describe if organisation is a demo company.
     *
     * @return self
     */
    public function setIsDemoCompany($is_demo_company)
    {
        $this->container['is_demo_company'] = $is_demo_company;

        return $this;
    }

    /**
     * Gets organisation_status
     *
     * @return string|null
     */
    public function getOrganisationStatus()
    {
        return $this->container['organisation_status'];
    }

    /**
     * Sets organisation_status
     *
     * @param string|null $organisation_status Will be set to ACTIVE if you can connect to organisation via the Xero API
     *
     * @return self
     */
    public function setOrganisationStatus($organisation_status)
    {
        $this->container['organisation_status'] = $organisation_status;

        return $this;
    }

    /**
     * Gets registration_number
     *
     * @return string|null
     */
    public function getRegistrationNumber()
    {
        return $this->container['registration_number'];
    }

    /**
     * Sets registration_number
     *
     * @param string|null $registration_number Shows for New Zealand, Australian and UK organisations
     *
     * @return self
     */
    public function setRegistrationNumber($registration_number)
    {
        $this->container['registration_number'] = $registration_number;

        return $this;
    }

    /**
     * Gets employer_identification_number
     *
     * @return string|null
     */
    public function getEmployerIdentificationNumber()
    {
        return $this->container['employer_identification_number'];
    }

    /**
     * Sets employer_identification_number
     *
     * @param string|null $employer_identification_number Shown if set. US Only.
     *
     * @return self
     */
    public function setEmployerIdentificationNumber($employer_identification_number)
    {
        $this->container['employer_identification_number'] = $employer_identification_number;

        return $this;
    }

    /**
     * Gets tax_number
     *
     * @return string|null
     */
    public function getTaxNumber()
    {
        return $this->container['tax_number'];
    }

    /**
     * Sets tax_number
     *
     * @param string|null $tax_number Shown if set. Displays in the Xero UI as Tax File Number (AU), GST Number (NZ), VAT Number (UK) and Tax ID Number (US & Global).
     *
     * @return self
     */
    public function setTaxNumber($tax_number)
    {
        $this->container['tax_number'] = $tax_number;

        return $this;
    }

    /**
     * Gets financial_year_end_day
     *
     * @return int|null
     */
    public function getFinancialYearEndDay()
    {
        return $this->container['financial_year_end_day'];
    }

    /**
     * Sets financial_year_end_day
     *
     * @param int|null $financial_year_end_day Calendar day e.g. 0-31
     *
     * @return self
     */
    public function setFinancialYearEndDay($financial_year_end_day)
    {
        $this->container['financial_year_end_day'] = $financial_year_end_day;

        return $this;
    }

    /**
     * Gets financial_year_end_month
     *
     * @return int|null
     */
    public function getFinancialYearEndMonth()
    {
        return $this->container['financial_year_end_month'];
    }

    /**
     * Sets financial_year_end_month
     *
     * @param int|null $financial_year_end_month Calendar Month e.g. 1-12
     *
     * @return self
     */
    public function setFinancialYearEndMonth($financial_year_end_month)
    {
        $this->container['financial_year_end_month'] = $financial_year_end_month;

        return $this;
    }

    /**
     * Gets sales_tax_basis
     *
     * @return string|null
     */
    public function getSalesTaxBasis()
    {
        return $this->container['sales_tax_basis'];
    }

    /**
     * Sets sales_tax_basis
     *
     * @param string|null $sales_tax_basis The accounting basis used for tax returns. See Sales Tax Basis
     *
     * @return self
     */
    public function setSalesTaxBasis($sales_tax_basis)
    {
        $allowedValues = $this->getSalesTaxBasisAllowableValues();
        if (!is_null($sales_tax_basis) && !in_array($sales_tax_basis, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'sales_tax_basis', must be one of '%s'",
                    $sales_tax_basis,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['sales_tax_basis'] = $sales_tax_basis;

        return $this;
    }

    /**
     * Gets sales_tax_period
     *
     * @return string|null
     */
    public function getSalesTaxPeriod()
    {
        return $this->container['sales_tax_period'];
    }

    /**
     * Sets sales_tax_period
     *
     * @param string|null $sales_tax_period The frequency with which tax returns are processed. See Sales Tax Period
     *
     * @return self
     */
    public function setSalesTaxPeriod($sales_tax_period)
    {
        $allowedValues = $this->getSalesTaxPeriodAllowableValues();
        if (!is_null($sales_tax_period) && !in_array($sales_tax_period, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'sales_tax_period', must be one of '%s'",
                    $sales_tax_period,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['sales_tax_period'] = $sales_tax_period;

        return $this;
    }

    /**
     * Gets default_sales_tax
     *
     * @return string|null
     */
    public function getDefaultSalesTax()
    {
        return $this->container['default_sales_tax'];
    }

    /**
     * Sets default_sales_tax
     *
     * @param string|null $default_sales_tax The default for LineAmountTypes on sales transactions
     *
     * @return self
     */
    public function setDefaultSalesTax($default_sales_tax)
    {
        $this->container['default_sales_tax'] = $default_sales_tax;

        return $this;
    }

    /**
     * Gets default_purchases_tax
     *
     * @return string|null
     */
    public function getDefaultPurchasesTax()
    {
        return $this->container['default_purchases_tax'];
    }

    /**
     * Sets default_purchases_tax
     *
     * @param string|null $default_purchases_tax The default for LineAmountTypes on purchase transactions
     *
     * @return self
     */
    public function setDefaultPurchasesTax($default_purchases_tax)
    {
        $this->container['default_purchases_tax'] = $default_purchases_tax;

        return $this;
    }

    /**
     * Gets period_lock_date
     *
     * @return string|null
     */
    public function getPeriodLockDate()
    {
        return $this->container['period_lock_date'];
    }

    /**
     * Sets period_lock_date
     *
     * @param string|null $period_lock_date Shown if set. See lock dates
     *
     * @return self
     */
    public function setPeriodLockDate($period_lock_date)
    {
        $this->container['period_lock_date'] = $period_lock_date;

        return $this;
    }

    /**
     * Gets end_of_year_lock_date
     *
     * @return string|null
     */
    public function getEndOfYearLockDate()
    {
        return $this->container['end_of_year_lock_date'];
    }

    /**
     * Sets end_of_year_lock_date
     *
     * @param string|null $end_of_year_lock_date Shown if set. See lock dates
     *
     * @return self
     */
    public function setEndOfYearLockDate($end_of_year_lock_date)
    {
        $this->container['end_of_year_lock_date'] = $end_of_year_lock_date;

        return $this;
    }

    /**
     * Gets created_date_utc
     *
     * @return string|null
     */
    public function getCreatedDateUtc()
    {
        return $this->container['created_date_utc'];
    }

    /**
     * Sets created_date_utc
     *
     * @param string|null $created_date_utc Timestamp when the organisation was created in Xero
     *
     * @return self
     */
    public function setCreatedDateUtc($created_date_utc)
    {
        $this->container['created_date_utc'] = $created_date_utc;

        return $this;
    }

    /**
     * Gets timezone
     *
     * @return \Xero2\Accounting\Model\TimeZone|null
     */
    public function getTimezone()
    {
        return $this->container['timezone'];
    }

    /**
     * Sets timezone
     *
     * @param \Xero2\Accounting\Model\TimeZone|null $timezone timezone
     *
     * @return self
     */
    public function setTimezone($timezone)
    {
        $this->container['timezone'] = $timezone;

        return $this;
    }

    /**
     * Gets organisation_entity_type
     *
     * @return string|null
     */
    public function getOrganisationEntityType()
    {
        return $this->container['organisation_entity_type'];
    }

    /**
     * Sets organisation_entity_type
     *
     * @param string|null $organisation_entity_type Organisation Entity Type
     *
     * @return self
     */
    public function setOrganisationEntityType($organisation_entity_type)
    {
        $allowedValues = $this->getOrganisationEntityTypeAllowableValues();
        if (!is_null($organisation_entity_type) && !in_array($organisation_entity_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'organisation_entity_type', must be one of '%s'",
                    $organisation_entity_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['organisation_entity_type'] = $organisation_entity_type;

        return $this;
    }

    /**
     * Gets short_code
     *
     * @return string|null
     */
    public function getShortCode()
    {
        return $this->container['short_code'];
    }

    /**
     * Sets short_code
     *
     * @param string|null $short_code A unique identifier for the organisation. Potential uses.
     *
     * @return self
     */
    public function setShortCode($short_code)
    {
        $this->container['short_code'] = $short_code;

        return $this;
    }

    /**
     * Gets class
     *
     * @return string|null
     */
    public function getClass()
    {
        return $this->container['class'];
    }

    /**
     * Sets class
     *
     * @param string|null $class Organisation Classes describe which plan the Xero organisation is on (e.g. DEMO, TRIAL, PREMIUM)
     *
     * @return self
     */
    public function setClass($class)
    {
        $allowedValues = $this->getClassAllowableValues();
        if (!is_null($class) && !in_array($class, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'class', must be one of '%s'",
                    $class,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['class'] = $class;

        return $this;
    }

    /**
     * Gets edition
     *
     * @return string|null
     */
    public function getEdition()
    {
        return $this->container['edition'];
    }

    /**
     * Sets edition
     *
     * @param string|null $edition BUSINESS or PARTNER. Partner edition organisations are sold exclusively through accounting partners and have restricted functionality (e.g. no access to invoicing)
     *
     * @return self
     */
    public function setEdition($edition)
    {
        $allowedValues = $this->getEditionAllowableValues();
        if (!is_null($edition) && !in_array($edition, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'edition', must be one of '%s'",
                    $edition,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['edition'] = $edition;

        return $this;
    }

    /**
     * Gets line_of_business
     *
     * @return string|null
     */
    public function getLineOfBusiness()
    {
        return $this->container['line_of_business'];
    }

    /**
     * Sets line_of_business
     *
     * @param string|null $line_of_business Description of business type as defined in Organisation settings
     *
     * @return self
     */
    public function setLineOfBusiness($line_of_business)
    {
        $this->container['line_of_business'] = $line_of_business;

        return $this;
    }

    /**
     * Gets addresses
     *
     * @return \Xero2\Accounting\Model\AddressForOrganisation[]|null
     */
    public function getAddresses()
    {
        return $this->container['addresses'];
    }

    /**
     * Sets addresses
     *
     * @param \Xero2\Accounting\Model\AddressForOrganisation[]|null $addresses Address details for organisation – see Addresses
     *
     * @return self
     */
    public function setAddresses($addresses)
    {
        $this->container['addresses'] = $addresses;

        return $this;
    }

    /**
     * Gets phones
     *
     * @return \Xero2\Accounting\Model\Phone[]|null
     */
    public function getPhones()
    {
        return $this->container['phones'];
    }

    /**
     * Sets phones
     *
     * @param \Xero2\Accounting\Model\Phone[]|null $phones Phones details for organisation – see Phones
     *
     * @return self
     */
    public function setPhones($phones)
    {
        $this->container['phones'] = $phones;

        return $this;
    }

    /**
     * Gets external_links
     *
     * @return \Xero2\Accounting\Model\ExternalLink[]|null
     */
    public function getExternalLinks()
    {
        return $this->container['external_links'];
    }

    /**
     * Sets external_links
     *
     * @param \Xero2\Accounting\Model\ExternalLink[]|null $external_links Organisation profile links for popular services such as Facebook,Twitter, GooglePlus and LinkedIn. You can also add link to your website here. Shown if Organisation settings  is updated in Xero. See ExternalLinks below
     *
     * @return self
     */
    public function setExternalLinks($external_links)
    {
        $this->container['external_links'] = $external_links;

        return $this;
    }

    /**
     * Gets payment_terms
     *
     * @return \Xero2\Accounting\Model\PaymentTerm|null
     */
    public function getPaymentTerms()
    {
        return $this->container['payment_terms'];
    }

    /**
     * Sets payment_terms
     *
     * @param \Xero2\Accounting\Model\PaymentTerm|null $payment_terms payment_terms
     *
     * @return self
     */
    public function setPaymentTerms($payment_terms)
    {
        $this->container['payment_terms'] = $payment_terms;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


