<?php
/**
 * AccountingApi
 * PHP version 7.4
 *
 * @category Class
 * @package  Xero2\Accounting
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Xero Accounting API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.10.0
 * Contact: api@xero.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Xero2\Accounting\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Xero2\Accounting\ApiException;
use Xero2\Accounting\Configuration;
use Xero2\Accounting\HeaderSelector;
use Xero2\Accounting\ObjectSerializer;

/**
 * AccountingApi Class Doc Comment
 *
 * @category Class
 * @package  Xero2\Accounting
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class AccountingApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createAccount
     *
     * Creates a new chart of accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Account $account Account object in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Accounts|\Xero2\Accounting\Model\Error
     */
    public function createAccount($xero_tenant_id, $account)
    {
        list($response) = $this->createAccountWithHttpInfo($xero_tenant_id, $account);
        return $response;
    }

    /**
     * Operation createAccountWithHttpInfo
     *
     * Creates a new chart of accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Account $account Account object in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Accounts|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createAccountWithHttpInfo($xero_tenant_id, $account)
    {
        $request = $this->createAccountRequest($xero_tenant_id, $account);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Accounts' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Accounts' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Accounts', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Accounts';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Accounts',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createAccountAsync
     *
     * Creates a new chart of accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Account $account Account object in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAccountAsync($xero_tenant_id, $account)
    {
        return $this->createAccountAsyncWithHttpInfo($xero_tenant_id, $account)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createAccountAsyncWithHttpInfo
     *
     * Creates a new chart of accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Account $account Account object in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAccountAsyncWithHttpInfo($xero_tenant_id, $account)
    {
        $returnType = '\Xero2\Accounting\Model\Accounts';
        $request = $this->createAccountRequest($xero_tenant_id, $account);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createAccount'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Account $account Account object in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createAccountRequest($xero_tenant_id, $account)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createAccount'
            );
        }
        // verify the required parameter 'account' is set
        if ($account === null || (is_array($account) && count($account) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $account when calling createAccount'
            );
        }

        $resourcePath = '/Accounts';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }



        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($account)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($account));
            } else {
                $httpBody = $account;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createAccountAttachmentByFileName
     *
     * Creates an attachment on a specific account
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error
     */
    public function createAccountAttachmentByFileName($xero_tenant_id, $account_id, $file_name, $body)
    {
        list($response) = $this->createAccountAttachmentByFileNameWithHttpInfo($xero_tenant_id, $account_id, $file_name, $body);
        return $response;
    }

    /**
     * Operation createAccountAttachmentByFileNameWithHttpInfo
     *
     * Creates an attachment on a specific account
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createAccountAttachmentByFileNameWithHttpInfo($xero_tenant_id, $account_id, $file_name, $body)
    {
        $request = $this->createAccountAttachmentByFileNameRequest($xero_tenant_id, $account_id, $file_name, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Attachments' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Attachments' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Attachments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Attachments';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Attachments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createAccountAttachmentByFileNameAsync
     *
     * Creates an attachment on a specific account
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAccountAttachmentByFileNameAsync($xero_tenant_id, $account_id, $file_name, $body)
    {
        return $this->createAccountAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $account_id, $file_name, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createAccountAttachmentByFileNameAsyncWithHttpInfo
     *
     * Creates an attachment on a specific account
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAccountAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $account_id, $file_name, $body)
    {
        $returnType = '\Xero2\Accounting\Model\Attachments';
        $request = $this->createAccountAttachmentByFileNameRequest($xero_tenant_id, $account_id, $file_name, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createAccountAttachmentByFileName'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createAccountAttachmentByFileNameRequest($xero_tenant_id, $account_id, $file_name, $body)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createAccountAttachmentByFileName'
            );
        }
        // verify the required parameter 'account_id' is set
        if ($account_id === null || (is_array($account_id) && count($account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $account_id when calling createAccountAttachmentByFileName'
            );
        }
        // verify the required parameter 'file_name' is set
        if ($file_name === null || (is_array($file_name) && count($file_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_name when calling createAccountAttachmentByFileName'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createAccountAttachmentByFileName'
            );
        }

        $resourcePath = '/Accounts/{AccountID}/Attachments/{FileName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                '{' . 'AccountID' . '}',
                ObjectSerializer::toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($file_name !== null) {
            $resourcePath = str_replace(
                '{' . 'FileName' . '}',
                ObjectSerializer::toPathValue($file_name),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/octet-stream']
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createBankTransactionAttachmentByFileName
     *
     * Creates an attachment for a specific bank transaction by filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $file_name The name of the file being attached (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error
     */
    public function createBankTransactionAttachmentByFileName($xero_tenant_id, $bank_transaction_id, $file_name, $body)
    {
        list($response) = $this->createBankTransactionAttachmentByFileNameWithHttpInfo($xero_tenant_id, $bank_transaction_id, $file_name, $body);
        return $response;
    }

    /**
     * Operation createBankTransactionAttachmentByFileNameWithHttpInfo
     *
     * Creates an attachment for a specific bank transaction by filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $file_name The name of the file being attached (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBankTransactionAttachmentByFileNameWithHttpInfo($xero_tenant_id, $bank_transaction_id, $file_name, $body)
    {
        $request = $this->createBankTransactionAttachmentByFileNameRequest($xero_tenant_id, $bank_transaction_id, $file_name, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Attachments' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Attachments' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Attachments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Attachments';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Attachments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createBankTransactionAttachmentByFileNameAsync
     *
     * Creates an attachment for a specific bank transaction by filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $file_name The name of the file being attached (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBankTransactionAttachmentByFileNameAsync($xero_tenant_id, $bank_transaction_id, $file_name, $body)
    {
        return $this->createBankTransactionAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $bank_transaction_id, $file_name, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createBankTransactionAttachmentByFileNameAsyncWithHttpInfo
     *
     * Creates an attachment for a specific bank transaction by filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $file_name The name of the file being attached (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBankTransactionAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $bank_transaction_id, $file_name, $body)
    {
        $returnType = '\Xero2\Accounting\Model\Attachments';
        $request = $this->createBankTransactionAttachmentByFileNameRequest($xero_tenant_id, $bank_transaction_id, $file_name, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createBankTransactionAttachmentByFileName'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $file_name The name of the file being attached (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createBankTransactionAttachmentByFileNameRequest($xero_tenant_id, $bank_transaction_id, $file_name, $body)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createBankTransactionAttachmentByFileName'
            );
        }
        // verify the required parameter 'bank_transaction_id' is set
        if ($bank_transaction_id === null || (is_array($bank_transaction_id) && count($bank_transaction_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bank_transaction_id when calling createBankTransactionAttachmentByFileName'
            );
        }
        // verify the required parameter 'file_name' is set
        if ($file_name === null || (is_array($file_name) && count($file_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_name when calling createBankTransactionAttachmentByFileName'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createBankTransactionAttachmentByFileName'
            );
        }

        $resourcePath = '/BankTransactions/{BankTransactionID}/Attachments/{FileName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($bank_transaction_id !== null) {
            $resourcePath = str_replace(
                '{' . 'BankTransactionID' . '}',
                ObjectSerializer::toPathValue($bank_transaction_id),
                $resourcePath
            );
        }
        // path params
        if ($file_name !== null) {
            $resourcePath = str_replace(
                '{' . 'FileName' . '}',
                ObjectSerializer::toPathValue($file_name),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/octet-stream']
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createBankTransactionHistoryRecord
     *
     * Creates a history record for a specific bank transactions
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error
     */
    public function createBankTransactionHistoryRecord($xero_tenant_id, $bank_transaction_id, $history_records)
    {
        list($response) = $this->createBankTransactionHistoryRecordWithHttpInfo($xero_tenant_id, $bank_transaction_id, $history_records);
        return $response;
    }

    /**
     * Operation createBankTransactionHistoryRecordWithHttpInfo
     *
     * Creates a history record for a specific bank transactions
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBankTransactionHistoryRecordWithHttpInfo($xero_tenant_id, $bank_transaction_id, $history_records)
    {
        $request = $this->createBankTransactionHistoryRecordRequest($xero_tenant_id, $bank_transaction_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\HistoryRecords' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createBankTransactionHistoryRecordAsync
     *
     * Creates a history record for a specific bank transactions
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBankTransactionHistoryRecordAsync($xero_tenant_id, $bank_transaction_id, $history_records)
    {
        return $this->createBankTransactionHistoryRecordAsyncWithHttpInfo($xero_tenant_id, $bank_transaction_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createBankTransactionHistoryRecordAsyncWithHttpInfo
     *
     * Creates a history record for a specific bank transactions
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBankTransactionHistoryRecordAsyncWithHttpInfo($xero_tenant_id, $bank_transaction_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createBankTransactionHistoryRecordRequest($xero_tenant_id, $bank_transaction_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createBankTransactionHistoryRecord'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createBankTransactionHistoryRecordRequest($xero_tenant_id, $bank_transaction_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createBankTransactionHistoryRecord'
            );
        }
        // verify the required parameter 'bank_transaction_id' is set
        if ($bank_transaction_id === null || (is_array($bank_transaction_id) && count($bank_transaction_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bank_transaction_id when calling createBankTransactionHistoryRecord'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createBankTransactionHistoryRecord'
            );
        }

        $resourcePath = '/BankTransactions/{BankTransactionID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($bank_transaction_id !== null) {
            $resourcePath = str_replace(
                '{' . 'BankTransactionID' . '}',
                ObjectSerializer::toPathValue($bank_transaction_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($history_records)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($history_records));
            } else {
                $httpBody = $history_records;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createBankTransactions
     *
     * Creates one or more spent or received money transaction
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BankTransactions $bank_transactions BankTransactions with an array of BankTransaction objects in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\BankTransactions|\Xero2\Accounting\Model\Error
     */
    public function createBankTransactions($xero_tenant_id, $bank_transactions, $summarize_errors = false, $unitdp = null)
    {
        list($response) = $this->createBankTransactionsWithHttpInfo($xero_tenant_id, $bank_transactions, $summarize_errors, $unitdp);
        return $response;
    }

    /**
     * Operation createBankTransactionsWithHttpInfo
     *
     * Creates one or more spent or received money transaction
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BankTransactions $bank_transactions BankTransactions with an array of BankTransaction objects in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\BankTransactions|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBankTransactionsWithHttpInfo($xero_tenant_id, $bank_transactions, $summarize_errors = false, $unitdp = null)
    {
        $request = $this->createBankTransactionsRequest($xero_tenant_id, $bank_transactions, $summarize_errors, $unitdp);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\BankTransactions' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\BankTransactions' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\BankTransactions', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\BankTransactions';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\BankTransactions',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createBankTransactionsAsync
     *
     * Creates one or more spent or received money transaction
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BankTransactions $bank_transactions BankTransactions with an array of BankTransaction objects in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBankTransactionsAsync($xero_tenant_id, $bank_transactions, $summarize_errors = false, $unitdp = null)
    {
        return $this->createBankTransactionsAsyncWithHttpInfo($xero_tenant_id, $bank_transactions, $summarize_errors, $unitdp)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createBankTransactionsAsyncWithHttpInfo
     *
     * Creates one or more spent or received money transaction
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BankTransactions $bank_transactions BankTransactions with an array of BankTransaction objects in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBankTransactionsAsyncWithHttpInfo($xero_tenant_id, $bank_transactions, $summarize_errors = false, $unitdp = null)
    {
        $returnType = '\Xero2\Accounting\Model\BankTransactions';
        $request = $this->createBankTransactionsRequest($xero_tenant_id, $bank_transactions, $summarize_errors, $unitdp);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createBankTransactions'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BankTransactions $bank_transactions BankTransactions with an array of BankTransaction objects in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createBankTransactionsRequest($xero_tenant_id, $bank_transactions, $summarize_errors = false, $unitdp = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createBankTransactions'
            );
        }
        // verify the required parameter 'bank_transactions' is set
        if ($bank_transactions === null || (is_array($bank_transactions) && count($bank_transactions) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bank_transactions when calling createBankTransactions'
            );
        }

        $resourcePath = '/BankTransactions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $summarize_errors,
            'summarizeErrors', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $unitdp,
            'unitdp', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }



        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($bank_transactions)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($bank_transactions));
            } else {
                $httpBody = $bank_transactions;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createBankTransfer
     *
     * Creates a bank transfer
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BankTransfers $bank_transfers BankTransfers with array of BankTransfer objects in request body (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\BankTransfers|\Xero2\Accounting\Model\Error
     */
    public function createBankTransfer($xero_tenant_id, $bank_transfers)
    {
        list($response) = $this->createBankTransferWithHttpInfo($xero_tenant_id, $bank_transfers);
        return $response;
    }

    /**
     * Operation createBankTransferWithHttpInfo
     *
     * Creates a bank transfer
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BankTransfers $bank_transfers BankTransfers with array of BankTransfer objects in request body (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\BankTransfers|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBankTransferWithHttpInfo($xero_tenant_id, $bank_transfers)
    {
        $request = $this->createBankTransferRequest($xero_tenant_id, $bank_transfers);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\BankTransfers' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\BankTransfers' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\BankTransfers', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\BankTransfers';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\BankTransfers',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createBankTransferAsync
     *
     * Creates a bank transfer
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BankTransfers $bank_transfers BankTransfers with array of BankTransfer objects in request body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBankTransferAsync($xero_tenant_id, $bank_transfers)
    {
        return $this->createBankTransferAsyncWithHttpInfo($xero_tenant_id, $bank_transfers)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createBankTransferAsyncWithHttpInfo
     *
     * Creates a bank transfer
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BankTransfers $bank_transfers BankTransfers with array of BankTransfer objects in request body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBankTransferAsyncWithHttpInfo($xero_tenant_id, $bank_transfers)
    {
        $returnType = '\Xero2\Accounting\Model\BankTransfers';
        $request = $this->createBankTransferRequest($xero_tenant_id, $bank_transfers);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createBankTransfer'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BankTransfers $bank_transfers BankTransfers with array of BankTransfer objects in request body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createBankTransferRequest($xero_tenant_id, $bank_transfers)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createBankTransfer'
            );
        }
        // verify the required parameter 'bank_transfers' is set
        if ($bank_transfers === null || (is_array($bank_transfers) && count($bank_transfers) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bank_transfers when calling createBankTransfer'
            );
        }

        $resourcePath = '/BankTransfers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }



        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($bank_transfers)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($bank_transfers));
            } else {
                $httpBody = $bank_transfers;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createBankTransferAttachmentByFileName
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  string $file_name The name of the file being attached to a Bank Transfer (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error
     */
    public function createBankTransferAttachmentByFileName($xero_tenant_id, $bank_transfer_id, $file_name, $body)
    {
        list($response) = $this->createBankTransferAttachmentByFileNameWithHttpInfo($xero_tenant_id, $bank_transfer_id, $file_name, $body);
        return $response;
    }

    /**
     * Operation createBankTransferAttachmentByFileNameWithHttpInfo
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  string $file_name The name of the file being attached to a Bank Transfer (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBankTransferAttachmentByFileNameWithHttpInfo($xero_tenant_id, $bank_transfer_id, $file_name, $body)
    {
        $request = $this->createBankTransferAttachmentByFileNameRequest($xero_tenant_id, $bank_transfer_id, $file_name, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Attachments' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Attachments' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Attachments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Attachments';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Attachments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createBankTransferAttachmentByFileNameAsync
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  string $file_name The name of the file being attached to a Bank Transfer (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBankTransferAttachmentByFileNameAsync($xero_tenant_id, $bank_transfer_id, $file_name, $body)
    {
        return $this->createBankTransferAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $bank_transfer_id, $file_name, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createBankTransferAttachmentByFileNameAsyncWithHttpInfo
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  string $file_name The name of the file being attached to a Bank Transfer (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBankTransferAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $bank_transfer_id, $file_name, $body)
    {
        $returnType = '\Xero2\Accounting\Model\Attachments';
        $request = $this->createBankTransferAttachmentByFileNameRequest($xero_tenant_id, $bank_transfer_id, $file_name, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createBankTransferAttachmentByFileName'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  string $file_name The name of the file being attached to a Bank Transfer (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createBankTransferAttachmentByFileNameRequest($xero_tenant_id, $bank_transfer_id, $file_name, $body)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createBankTransferAttachmentByFileName'
            );
        }
        // verify the required parameter 'bank_transfer_id' is set
        if ($bank_transfer_id === null || (is_array($bank_transfer_id) && count($bank_transfer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bank_transfer_id when calling createBankTransferAttachmentByFileName'
            );
        }
        // verify the required parameter 'file_name' is set
        if ($file_name === null || (is_array($file_name) && count($file_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_name when calling createBankTransferAttachmentByFileName'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createBankTransferAttachmentByFileName'
            );
        }

        $resourcePath = '/BankTransfers/{BankTransferID}/Attachments/{FileName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($bank_transfer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'BankTransferID' . '}',
                ObjectSerializer::toPathValue($bank_transfer_id),
                $resourcePath
            );
        }
        // path params
        if ($file_name !== null) {
            $resourcePath = str_replace(
                '{' . 'FileName' . '}',
                ObjectSerializer::toPathValue($file_name),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/octet-stream']
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createBankTransferHistoryRecord
     *
     * Creates a history record for a specific bank transfer
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error
     */
    public function createBankTransferHistoryRecord($xero_tenant_id, $bank_transfer_id, $history_records)
    {
        list($response) = $this->createBankTransferHistoryRecordWithHttpInfo($xero_tenant_id, $bank_transfer_id, $history_records);
        return $response;
    }

    /**
     * Operation createBankTransferHistoryRecordWithHttpInfo
     *
     * Creates a history record for a specific bank transfer
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBankTransferHistoryRecordWithHttpInfo($xero_tenant_id, $bank_transfer_id, $history_records)
    {
        $request = $this->createBankTransferHistoryRecordRequest($xero_tenant_id, $bank_transfer_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\HistoryRecords' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createBankTransferHistoryRecordAsync
     *
     * Creates a history record for a specific bank transfer
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBankTransferHistoryRecordAsync($xero_tenant_id, $bank_transfer_id, $history_records)
    {
        return $this->createBankTransferHistoryRecordAsyncWithHttpInfo($xero_tenant_id, $bank_transfer_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createBankTransferHistoryRecordAsyncWithHttpInfo
     *
     * Creates a history record for a specific bank transfer
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBankTransferHistoryRecordAsyncWithHttpInfo($xero_tenant_id, $bank_transfer_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createBankTransferHistoryRecordRequest($xero_tenant_id, $bank_transfer_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createBankTransferHistoryRecord'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createBankTransferHistoryRecordRequest($xero_tenant_id, $bank_transfer_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createBankTransferHistoryRecord'
            );
        }
        // verify the required parameter 'bank_transfer_id' is set
        if ($bank_transfer_id === null || (is_array($bank_transfer_id) && count($bank_transfer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bank_transfer_id when calling createBankTransferHistoryRecord'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createBankTransferHistoryRecord'
            );
        }

        $resourcePath = '/BankTransfers/{BankTransferID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($bank_transfer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'BankTransferID' . '}',
                ObjectSerializer::toPathValue($bank_transfer_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($history_records)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($history_records));
            } else {
                $httpBody = $history_records;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createBatchPayment
     *
     * Creates one or many batch payments for invoices
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BatchPayments $batch_payments BatchPayments with an array of Payments in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\BatchPayments|\Xero2\Accounting\Model\Error
     */
    public function createBatchPayment($xero_tenant_id, $batch_payments, $summarize_errors = false)
    {
        list($response) = $this->createBatchPaymentWithHttpInfo($xero_tenant_id, $batch_payments, $summarize_errors);
        return $response;
    }

    /**
     * Operation createBatchPaymentWithHttpInfo
     *
     * Creates one or many batch payments for invoices
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BatchPayments $batch_payments BatchPayments with an array of Payments in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\BatchPayments|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBatchPaymentWithHttpInfo($xero_tenant_id, $batch_payments, $summarize_errors = false)
    {
        $request = $this->createBatchPaymentRequest($xero_tenant_id, $batch_payments, $summarize_errors);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\BatchPayments' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\BatchPayments' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\BatchPayments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\BatchPayments';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\BatchPayments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createBatchPaymentAsync
     *
     * Creates one or many batch payments for invoices
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BatchPayments $batch_payments BatchPayments with an array of Payments in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBatchPaymentAsync($xero_tenant_id, $batch_payments, $summarize_errors = false)
    {
        return $this->createBatchPaymentAsyncWithHttpInfo($xero_tenant_id, $batch_payments, $summarize_errors)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createBatchPaymentAsyncWithHttpInfo
     *
     * Creates one or many batch payments for invoices
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BatchPayments $batch_payments BatchPayments with an array of Payments in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBatchPaymentAsyncWithHttpInfo($xero_tenant_id, $batch_payments, $summarize_errors = false)
    {
        $returnType = '\Xero2\Accounting\Model\BatchPayments';
        $request = $this->createBatchPaymentRequest($xero_tenant_id, $batch_payments, $summarize_errors);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createBatchPayment'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BatchPayments $batch_payments BatchPayments with an array of Payments in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createBatchPaymentRequest($xero_tenant_id, $batch_payments, $summarize_errors = false)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createBatchPayment'
            );
        }
        // verify the required parameter 'batch_payments' is set
        if ($batch_payments === null || (is_array($batch_payments) && count($batch_payments) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_payments when calling createBatchPayment'
            );
        }

        $resourcePath = '/BatchPayments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $summarize_errors,
            'summarizeErrors', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }



        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($batch_payments)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($batch_payments));
            } else {
                $httpBody = $batch_payments;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createBatchPaymentHistoryRecord
     *
     * Creates a history record for a specific batch payment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $batch_payment_id Unique identifier for BatchPayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error
     */
    public function createBatchPaymentHistoryRecord($xero_tenant_id, $batch_payment_id, $history_records)
    {
        list($response) = $this->createBatchPaymentHistoryRecordWithHttpInfo($xero_tenant_id, $batch_payment_id, $history_records);
        return $response;
    }

    /**
     * Operation createBatchPaymentHistoryRecordWithHttpInfo
     *
     * Creates a history record for a specific batch payment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $batch_payment_id Unique identifier for BatchPayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBatchPaymentHistoryRecordWithHttpInfo($xero_tenant_id, $batch_payment_id, $history_records)
    {
        $request = $this->createBatchPaymentHistoryRecordRequest($xero_tenant_id, $batch_payment_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\HistoryRecords' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createBatchPaymentHistoryRecordAsync
     *
     * Creates a history record for a specific batch payment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $batch_payment_id Unique identifier for BatchPayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBatchPaymentHistoryRecordAsync($xero_tenant_id, $batch_payment_id, $history_records)
    {
        return $this->createBatchPaymentHistoryRecordAsyncWithHttpInfo($xero_tenant_id, $batch_payment_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createBatchPaymentHistoryRecordAsyncWithHttpInfo
     *
     * Creates a history record for a specific batch payment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $batch_payment_id Unique identifier for BatchPayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBatchPaymentHistoryRecordAsyncWithHttpInfo($xero_tenant_id, $batch_payment_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createBatchPaymentHistoryRecordRequest($xero_tenant_id, $batch_payment_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createBatchPaymentHistoryRecord'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $batch_payment_id Unique identifier for BatchPayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createBatchPaymentHistoryRecordRequest($xero_tenant_id, $batch_payment_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createBatchPaymentHistoryRecord'
            );
        }
        // verify the required parameter 'batch_payment_id' is set
        if ($batch_payment_id === null || (is_array($batch_payment_id) && count($batch_payment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_payment_id when calling createBatchPaymentHistoryRecord'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createBatchPaymentHistoryRecord'
            );
        }

        $resourcePath = '/BatchPayments/{BatchPaymentID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($batch_payment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'BatchPaymentID' . '}',
                ObjectSerializer::toPathValue($batch_payment_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($history_records)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($history_records));
            } else {
                $httpBody = $history_records;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createBrandingThemePaymentServices
     *
     * Creates a new custom payment service for a specific branding theme
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $branding_theme_id Unique identifier for a Branding Theme (required)
     * @param  \Xero2\Accounting\Model\PaymentService $payment_service PaymentService object in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\PaymentServices|\Xero2\Accounting\Model\Error
     */
    public function createBrandingThemePaymentServices($xero_tenant_id, $branding_theme_id, $payment_service)
    {
        list($response) = $this->createBrandingThemePaymentServicesWithHttpInfo($xero_tenant_id, $branding_theme_id, $payment_service);
        return $response;
    }

    /**
     * Operation createBrandingThemePaymentServicesWithHttpInfo
     *
     * Creates a new custom payment service for a specific branding theme
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $branding_theme_id Unique identifier for a Branding Theme (required)
     * @param  \Xero2\Accounting\Model\PaymentService $payment_service PaymentService object in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\PaymentServices|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBrandingThemePaymentServicesWithHttpInfo($xero_tenant_id, $branding_theme_id, $payment_service)
    {
        $request = $this->createBrandingThemePaymentServicesRequest($xero_tenant_id, $branding_theme_id, $payment_service);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\PaymentServices' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\PaymentServices' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\PaymentServices', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\PaymentServices';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\PaymentServices',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createBrandingThemePaymentServicesAsync
     *
     * Creates a new custom payment service for a specific branding theme
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $branding_theme_id Unique identifier for a Branding Theme (required)
     * @param  \Xero2\Accounting\Model\PaymentService $payment_service PaymentService object in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBrandingThemePaymentServicesAsync($xero_tenant_id, $branding_theme_id, $payment_service)
    {
        return $this->createBrandingThemePaymentServicesAsyncWithHttpInfo($xero_tenant_id, $branding_theme_id, $payment_service)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createBrandingThemePaymentServicesAsyncWithHttpInfo
     *
     * Creates a new custom payment service for a specific branding theme
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $branding_theme_id Unique identifier for a Branding Theme (required)
     * @param  \Xero2\Accounting\Model\PaymentService $payment_service PaymentService object in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBrandingThemePaymentServicesAsyncWithHttpInfo($xero_tenant_id, $branding_theme_id, $payment_service)
    {
        $returnType = '\Xero2\Accounting\Model\PaymentServices';
        $request = $this->createBrandingThemePaymentServicesRequest($xero_tenant_id, $branding_theme_id, $payment_service);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createBrandingThemePaymentServices'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $branding_theme_id Unique identifier for a Branding Theme (required)
     * @param  \Xero2\Accounting\Model\PaymentService $payment_service PaymentService object in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createBrandingThemePaymentServicesRequest($xero_tenant_id, $branding_theme_id, $payment_service)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createBrandingThemePaymentServices'
            );
        }
        // verify the required parameter 'branding_theme_id' is set
        if ($branding_theme_id === null || (is_array($branding_theme_id) && count($branding_theme_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $branding_theme_id when calling createBrandingThemePaymentServices'
            );
        }
        // verify the required parameter 'payment_service' is set
        if ($payment_service === null || (is_array($payment_service) && count($payment_service) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payment_service when calling createBrandingThemePaymentServices'
            );
        }

        $resourcePath = '/BrandingThemes/{BrandingThemeID}/PaymentServices';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($branding_theme_id !== null) {
            $resourcePath = str_replace(
                '{' . 'BrandingThemeID' . '}',
                ObjectSerializer::toPathValue($branding_theme_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($payment_service)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($payment_service));
            } else {
                $httpBody = $payment_service;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createContactAttachmentByFileName
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     * @param  string $file_name Name for the file you are attaching (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error
     */
    public function createContactAttachmentByFileName($xero_tenant_id, $contact_id, $file_name, $body)
    {
        list($response) = $this->createContactAttachmentByFileNameWithHttpInfo($xero_tenant_id, $contact_id, $file_name, $body);
        return $response;
    }

    /**
     * Operation createContactAttachmentByFileNameWithHttpInfo
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     * @param  string $file_name Name for the file you are attaching (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createContactAttachmentByFileNameWithHttpInfo($xero_tenant_id, $contact_id, $file_name, $body)
    {
        $request = $this->createContactAttachmentByFileNameRequest($xero_tenant_id, $contact_id, $file_name, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Attachments' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Attachments' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Attachments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Attachments';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Attachments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createContactAttachmentByFileNameAsync
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     * @param  string $file_name Name for the file you are attaching (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createContactAttachmentByFileNameAsync($xero_tenant_id, $contact_id, $file_name, $body)
    {
        return $this->createContactAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $contact_id, $file_name, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createContactAttachmentByFileNameAsyncWithHttpInfo
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     * @param  string $file_name Name for the file you are attaching (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createContactAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $contact_id, $file_name, $body)
    {
        $returnType = '\Xero2\Accounting\Model\Attachments';
        $request = $this->createContactAttachmentByFileNameRequest($xero_tenant_id, $contact_id, $file_name, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createContactAttachmentByFileName'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     * @param  string $file_name Name for the file you are attaching (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createContactAttachmentByFileNameRequest($xero_tenant_id, $contact_id, $file_name, $body)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createContactAttachmentByFileName'
            );
        }
        // verify the required parameter 'contact_id' is set
        if ($contact_id === null || (is_array($contact_id) && count($contact_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $contact_id when calling createContactAttachmentByFileName'
            );
        }
        // verify the required parameter 'file_name' is set
        if ($file_name === null || (is_array($file_name) && count($file_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_name when calling createContactAttachmentByFileName'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createContactAttachmentByFileName'
            );
        }

        $resourcePath = '/Contacts/{ContactID}/Attachments/{FileName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($contact_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ContactID' . '}',
                ObjectSerializer::toPathValue($contact_id),
                $resourcePath
            );
        }
        // path params
        if ($file_name !== null) {
            $resourcePath = str_replace(
                '{' . 'FileName' . '}',
                ObjectSerializer::toPathValue($file_name),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/octet-stream']
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createContactGroup
     *
     * Creates a contact group
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ContactGroups $contact_groups ContactGroups with an array of names in request body (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\ContactGroups|\Xero2\Accounting\Model\Error
     */
    public function createContactGroup($xero_tenant_id, $contact_groups)
    {
        list($response) = $this->createContactGroupWithHttpInfo($xero_tenant_id, $contact_groups);
        return $response;
    }

    /**
     * Operation createContactGroupWithHttpInfo
     *
     * Creates a contact group
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ContactGroups $contact_groups ContactGroups with an array of names in request body (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\ContactGroups|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createContactGroupWithHttpInfo($xero_tenant_id, $contact_groups)
    {
        $request = $this->createContactGroupRequest($xero_tenant_id, $contact_groups);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\ContactGroups' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\ContactGroups' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\ContactGroups', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\ContactGroups';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\ContactGroups',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createContactGroupAsync
     *
     * Creates a contact group
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ContactGroups $contact_groups ContactGroups with an array of names in request body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createContactGroupAsync($xero_tenant_id, $contact_groups)
    {
        return $this->createContactGroupAsyncWithHttpInfo($xero_tenant_id, $contact_groups)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createContactGroupAsyncWithHttpInfo
     *
     * Creates a contact group
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ContactGroups $contact_groups ContactGroups with an array of names in request body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createContactGroupAsyncWithHttpInfo($xero_tenant_id, $contact_groups)
    {
        $returnType = '\Xero2\Accounting\Model\ContactGroups';
        $request = $this->createContactGroupRequest($xero_tenant_id, $contact_groups);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createContactGroup'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ContactGroups $contact_groups ContactGroups with an array of names in request body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createContactGroupRequest($xero_tenant_id, $contact_groups)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createContactGroup'
            );
        }
        // verify the required parameter 'contact_groups' is set
        if ($contact_groups === null || (is_array($contact_groups) && count($contact_groups) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $contact_groups when calling createContactGroup'
            );
        }

        $resourcePath = '/ContactGroups';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }



        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($contact_groups)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($contact_groups));
            } else {
                $httpBody = $contact_groups;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createContactGroupContacts
     *
     * Creates contacts to a specific contact group
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     * @param  \Xero2\Accounting\Model\Contacts $contacts Contacts with array of contacts specifying the ContactID to be added to ContactGroup in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Contacts|\Xero2\Accounting\Model\Error
     */
    public function createContactGroupContacts($xero_tenant_id, $contact_group_id, $contacts)
    {
        list($response) = $this->createContactGroupContactsWithHttpInfo($xero_tenant_id, $contact_group_id, $contacts);
        return $response;
    }

    /**
     * Operation createContactGroupContactsWithHttpInfo
     *
     * Creates contacts to a specific contact group
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     * @param  \Xero2\Accounting\Model\Contacts $contacts Contacts with array of contacts specifying the ContactID to be added to ContactGroup in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Contacts|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createContactGroupContactsWithHttpInfo($xero_tenant_id, $contact_group_id, $contacts)
    {
        $request = $this->createContactGroupContactsRequest($xero_tenant_id, $contact_group_id, $contacts);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Contacts' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Contacts' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Contacts', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Contacts';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Contacts',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createContactGroupContactsAsync
     *
     * Creates contacts to a specific contact group
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     * @param  \Xero2\Accounting\Model\Contacts $contacts Contacts with array of contacts specifying the ContactID to be added to ContactGroup in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createContactGroupContactsAsync($xero_tenant_id, $contact_group_id, $contacts)
    {
        return $this->createContactGroupContactsAsyncWithHttpInfo($xero_tenant_id, $contact_group_id, $contacts)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createContactGroupContactsAsyncWithHttpInfo
     *
     * Creates contacts to a specific contact group
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     * @param  \Xero2\Accounting\Model\Contacts $contacts Contacts with array of contacts specifying the ContactID to be added to ContactGroup in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createContactGroupContactsAsyncWithHttpInfo($xero_tenant_id, $contact_group_id, $contacts)
    {
        $returnType = '\Xero2\Accounting\Model\Contacts';
        $request = $this->createContactGroupContactsRequest($xero_tenant_id, $contact_group_id, $contacts);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createContactGroupContacts'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     * @param  \Xero2\Accounting\Model\Contacts $contacts Contacts with array of contacts specifying the ContactID to be added to ContactGroup in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createContactGroupContactsRequest($xero_tenant_id, $contact_group_id, $contacts)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createContactGroupContacts'
            );
        }
        // verify the required parameter 'contact_group_id' is set
        if ($contact_group_id === null || (is_array($contact_group_id) && count($contact_group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $contact_group_id when calling createContactGroupContacts'
            );
        }
        // verify the required parameter 'contacts' is set
        if ($contacts === null || (is_array($contacts) && count($contacts) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $contacts when calling createContactGroupContacts'
            );
        }

        $resourcePath = '/ContactGroups/{ContactGroupID}/Contacts';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($contact_group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ContactGroupID' . '}',
                ObjectSerializer::toPathValue($contact_group_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($contacts)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($contacts));
            } else {
                $httpBody = $contacts;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createContactHistory
     *
     * Creates a new history record for a specific contact
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error
     */
    public function createContactHistory($xero_tenant_id, $contact_id, $history_records)
    {
        list($response) = $this->createContactHistoryWithHttpInfo($xero_tenant_id, $contact_id, $history_records);
        return $response;
    }

    /**
     * Operation createContactHistoryWithHttpInfo
     *
     * Creates a new history record for a specific contact
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createContactHistoryWithHttpInfo($xero_tenant_id, $contact_id, $history_records)
    {
        $request = $this->createContactHistoryRequest($xero_tenant_id, $contact_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\HistoryRecords' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createContactHistoryAsync
     *
     * Creates a new history record for a specific contact
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createContactHistoryAsync($xero_tenant_id, $contact_id, $history_records)
    {
        return $this->createContactHistoryAsyncWithHttpInfo($xero_tenant_id, $contact_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createContactHistoryAsyncWithHttpInfo
     *
     * Creates a new history record for a specific contact
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createContactHistoryAsyncWithHttpInfo($xero_tenant_id, $contact_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createContactHistoryRequest($xero_tenant_id, $contact_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createContactHistory'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createContactHistoryRequest($xero_tenant_id, $contact_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createContactHistory'
            );
        }
        // verify the required parameter 'contact_id' is set
        if ($contact_id === null || (is_array($contact_id) && count($contact_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $contact_id when calling createContactHistory'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createContactHistory'
            );
        }

        $resourcePath = '/Contacts/{ContactID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($contact_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ContactID' . '}',
                ObjectSerializer::toPathValue($contact_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($history_records)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($history_records));
            } else {
                $httpBody = $history_records;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createContacts
     *
     * Creates multiple contacts (bulk) in a Xero organisation
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Contacts $contacts Contacts with an array of Contact objects to create in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Contacts|\Xero2\Accounting\Model\Error
     */
    public function createContacts($xero_tenant_id, $contacts, $summarize_errors = false)
    {
        list($response) = $this->createContactsWithHttpInfo($xero_tenant_id, $contacts, $summarize_errors);
        return $response;
    }

    /**
     * Operation createContactsWithHttpInfo
     *
     * Creates multiple contacts (bulk) in a Xero organisation
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Contacts $contacts Contacts with an array of Contact objects to create in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Contacts|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createContactsWithHttpInfo($xero_tenant_id, $contacts, $summarize_errors = false)
    {
        $request = $this->createContactsRequest($xero_tenant_id, $contacts, $summarize_errors);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Contacts' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Contacts' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Contacts', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Contacts';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Contacts',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createContactsAsync
     *
     * Creates multiple contacts (bulk) in a Xero organisation
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Contacts $contacts Contacts with an array of Contact objects to create in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createContactsAsync($xero_tenant_id, $contacts, $summarize_errors = false)
    {
        return $this->createContactsAsyncWithHttpInfo($xero_tenant_id, $contacts, $summarize_errors)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createContactsAsyncWithHttpInfo
     *
     * Creates multiple contacts (bulk) in a Xero organisation
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Contacts $contacts Contacts with an array of Contact objects to create in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createContactsAsyncWithHttpInfo($xero_tenant_id, $contacts, $summarize_errors = false)
    {
        $returnType = '\Xero2\Accounting\Model\Contacts';
        $request = $this->createContactsRequest($xero_tenant_id, $contacts, $summarize_errors);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createContacts'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Contacts $contacts Contacts with an array of Contact objects to create in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createContactsRequest($xero_tenant_id, $contacts, $summarize_errors = false)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createContacts'
            );
        }
        // verify the required parameter 'contacts' is set
        if ($contacts === null || (is_array($contacts) && count($contacts) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $contacts when calling createContacts'
            );
        }

        $resourcePath = '/Contacts';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $summarize_errors,
            'summarizeErrors', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }



        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($contacts)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($contacts));
            } else {
                $httpBody = $contacts;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createCreditNoteAllocation
     *
     * Creates allocation for a specific credit note
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations Allocations with array of Allocation object in body of request. (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Allocations|\Xero2\Accounting\Model\Error
     */
    public function createCreditNoteAllocation($xero_tenant_id, $credit_note_id, $allocations, $summarize_errors = false)
    {
        list($response) = $this->createCreditNoteAllocationWithHttpInfo($xero_tenant_id, $credit_note_id, $allocations, $summarize_errors);
        return $response;
    }

    /**
     * Operation createCreditNoteAllocationWithHttpInfo
     *
     * Creates allocation for a specific credit note
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations Allocations with array of Allocation object in body of request. (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Allocations|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCreditNoteAllocationWithHttpInfo($xero_tenant_id, $credit_note_id, $allocations, $summarize_errors = false)
    {
        $request = $this->createCreditNoteAllocationRequest($xero_tenant_id, $credit_note_id, $allocations, $summarize_errors);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Allocations' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Allocations' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Allocations', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Allocations';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Allocations',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createCreditNoteAllocationAsync
     *
     * Creates allocation for a specific credit note
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations Allocations with array of Allocation object in body of request. (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCreditNoteAllocationAsync($xero_tenant_id, $credit_note_id, $allocations, $summarize_errors = false)
    {
        return $this->createCreditNoteAllocationAsyncWithHttpInfo($xero_tenant_id, $credit_note_id, $allocations, $summarize_errors)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createCreditNoteAllocationAsyncWithHttpInfo
     *
     * Creates allocation for a specific credit note
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations Allocations with array of Allocation object in body of request. (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCreditNoteAllocationAsyncWithHttpInfo($xero_tenant_id, $credit_note_id, $allocations, $summarize_errors = false)
    {
        $returnType = '\Xero2\Accounting\Model\Allocations';
        $request = $this->createCreditNoteAllocationRequest($xero_tenant_id, $credit_note_id, $allocations, $summarize_errors);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createCreditNoteAllocation'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations Allocations with array of Allocation object in body of request. (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createCreditNoteAllocationRequest($xero_tenant_id, $credit_note_id, $allocations, $summarize_errors = false)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createCreditNoteAllocation'
            );
        }
        // verify the required parameter 'credit_note_id' is set
        if ($credit_note_id === null || (is_array($credit_note_id) && count($credit_note_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $credit_note_id when calling createCreditNoteAllocation'
            );
        }
        // verify the required parameter 'allocations' is set
        if ($allocations === null || (is_array($allocations) && count($allocations) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $allocations when calling createCreditNoteAllocation'
            );
        }

        $resourcePath = '/CreditNotes/{CreditNoteID}/Allocations';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $summarize_errors,
            'summarizeErrors', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($credit_note_id !== null) {
            $resourcePath = str_replace(
                '{' . 'CreditNoteID' . '}',
                ObjectSerializer::toPathValue($credit_note_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($allocations)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($allocations));
            } else {
                $httpBody = $allocations;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createCreditNoteAttachmentByFileName
     *
     * Creates an attachment for a specific credit note
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  string $file_name Name of the file you are attaching to Credit Note (required)
     * @param  string $body Byte array of file in body of request (required)
     * @param  bool $include_online Allows an attachment to be seen by the end customer within their online invoice (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error
     */
    public function createCreditNoteAttachmentByFileName($xero_tenant_id, $credit_note_id, $file_name, $body, $include_online = false)
    {
        list($response) = $this->createCreditNoteAttachmentByFileNameWithHttpInfo($xero_tenant_id, $credit_note_id, $file_name, $body, $include_online);
        return $response;
    }

    /**
     * Operation createCreditNoteAttachmentByFileNameWithHttpInfo
     *
     * Creates an attachment for a specific credit note
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  string $file_name Name of the file you are attaching to Credit Note (required)
     * @param  string $body Byte array of file in body of request (required)
     * @param  bool $include_online Allows an attachment to be seen by the end customer within their online invoice (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCreditNoteAttachmentByFileNameWithHttpInfo($xero_tenant_id, $credit_note_id, $file_name, $body, $include_online = false)
    {
        $request = $this->createCreditNoteAttachmentByFileNameRequest($xero_tenant_id, $credit_note_id, $file_name, $body, $include_online);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Attachments' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Attachments' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Attachments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Attachments';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Attachments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createCreditNoteAttachmentByFileNameAsync
     *
     * Creates an attachment for a specific credit note
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  string $file_name Name of the file you are attaching to Credit Note (required)
     * @param  string $body Byte array of file in body of request (required)
     * @param  bool $include_online Allows an attachment to be seen by the end customer within their online invoice (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCreditNoteAttachmentByFileNameAsync($xero_tenant_id, $credit_note_id, $file_name, $body, $include_online = false)
    {
        return $this->createCreditNoteAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $credit_note_id, $file_name, $body, $include_online)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createCreditNoteAttachmentByFileNameAsyncWithHttpInfo
     *
     * Creates an attachment for a specific credit note
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  string $file_name Name of the file you are attaching to Credit Note (required)
     * @param  string $body Byte array of file in body of request (required)
     * @param  bool $include_online Allows an attachment to be seen by the end customer within their online invoice (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCreditNoteAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $credit_note_id, $file_name, $body, $include_online = false)
    {
        $returnType = '\Xero2\Accounting\Model\Attachments';
        $request = $this->createCreditNoteAttachmentByFileNameRequest($xero_tenant_id, $credit_note_id, $file_name, $body, $include_online);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createCreditNoteAttachmentByFileName'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  string $file_name Name of the file you are attaching to Credit Note (required)
     * @param  string $body Byte array of file in body of request (required)
     * @param  bool $include_online Allows an attachment to be seen by the end customer within their online invoice (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createCreditNoteAttachmentByFileNameRequest($xero_tenant_id, $credit_note_id, $file_name, $body, $include_online = false)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createCreditNoteAttachmentByFileName'
            );
        }
        // verify the required parameter 'credit_note_id' is set
        if ($credit_note_id === null || (is_array($credit_note_id) && count($credit_note_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $credit_note_id when calling createCreditNoteAttachmentByFileName'
            );
        }
        // verify the required parameter 'file_name' is set
        if ($file_name === null || (is_array($file_name) && count($file_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_name when calling createCreditNoteAttachmentByFileName'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createCreditNoteAttachmentByFileName'
            );
        }

        $resourcePath = '/CreditNotes/{CreditNoteID}/Attachments/{FileName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_online,
            'IncludeOnline', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($credit_note_id !== null) {
            $resourcePath = str_replace(
                '{' . 'CreditNoteID' . '}',
                ObjectSerializer::toPathValue($credit_note_id),
                $resourcePath
            );
        }
        // path params
        if ($file_name !== null) {
            $resourcePath = str_replace(
                '{' . 'FileName' . '}',
                ObjectSerializer::toPathValue($file_name),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/octet-stream']
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createCreditNoteHistory
     *
     * Retrieves history records of a specific credit note
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error
     */
    public function createCreditNoteHistory($xero_tenant_id, $credit_note_id, $history_records)
    {
        list($response) = $this->createCreditNoteHistoryWithHttpInfo($xero_tenant_id, $credit_note_id, $history_records);
        return $response;
    }

    /**
     * Operation createCreditNoteHistoryWithHttpInfo
     *
     * Retrieves history records of a specific credit note
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCreditNoteHistoryWithHttpInfo($xero_tenant_id, $credit_note_id, $history_records)
    {
        $request = $this->createCreditNoteHistoryRequest($xero_tenant_id, $credit_note_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\HistoryRecords' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createCreditNoteHistoryAsync
     *
     * Retrieves history records of a specific credit note
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCreditNoteHistoryAsync($xero_tenant_id, $credit_note_id, $history_records)
    {
        return $this->createCreditNoteHistoryAsyncWithHttpInfo($xero_tenant_id, $credit_note_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createCreditNoteHistoryAsyncWithHttpInfo
     *
     * Retrieves history records of a specific credit note
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCreditNoteHistoryAsyncWithHttpInfo($xero_tenant_id, $credit_note_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createCreditNoteHistoryRequest($xero_tenant_id, $credit_note_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createCreditNoteHistory'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createCreditNoteHistoryRequest($xero_tenant_id, $credit_note_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createCreditNoteHistory'
            );
        }
        // verify the required parameter 'credit_note_id' is set
        if ($credit_note_id === null || (is_array($credit_note_id) && count($credit_note_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $credit_note_id when calling createCreditNoteHistory'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createCreditNoteHistory'
            );
        }

        $resourcePath = '/CreditNotes/{CreditNoteID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($credit_note_id !== null) {
            $resourcePath = str_replace(
                '{' . 'CreditNoteID' . '}',
                ObjectSerializer::toPathValue($credit_note_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($history_records)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($history_records));
            } else {
                $httpBody = $history_records;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createCreditNotes
     *
     * Creates a new credit note
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\CreditNotes $credit_notes Credit Notes with array of CreditNote object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\CreditNotes|\Xero2\Accounting\Model\Error
     */
    public function createCreditNotes($xero_tenant_id, $credit_notes, $summarize_errors = false, $unitdp = null)
    {
        list($response) = $this->createCreditNotesWithHttpInfo($xero_tenant_id, $credit_notes, $summarize_errors, $unitdp);
        return $response;
    }

    /**
     * Operation createCreditNotesWithHttpInfo
     *
     * Creates a new credit note
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\CreditNotes $credit_notes Credit Notes with array of CreditNote object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\CreditNotes|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCreditNotesWithHttpInfo($xero_tenant_id, $credit_notes, $summarize_errors = false, $unitdp = null)
    {
        $request = $this->createCreditNotesRequest($xero_tenant_id, $credit_notes, $summarize_errors, $unitdp);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\CreditNotes' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\CreditNotes' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\CreditNotes', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\CreditNotes';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\CreditNotes',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createCreditNotesAsync
     *
     * Creates a new credit note
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\CreditNotes $credit_notes Credit Notes with array of CreditNote object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCreditNotesAsync($xero_tenant_id, $credit_notes, $summarize_errors = false, $unitdp = null)
    {
        return $this->createCreditNotesAsyncWithHttpInfo($xero_tenant_id, $credit_notes, $summarize_errors, $unitdp)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createCreditNotesAsyncWithHttpInfo
     *
     * Creates a new credit note
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\CreditNotes $credit_notes Credit Notes with array of CreditNote object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCreditNotesAsyncWithHttpInfo($xero_tenant_id, $credit_notes, $summarize_errors = false, $unitdp = null)
    {
        $returnType = '\Xero2\Accounting\Model\CreditNotes';
        $request = $this->createCreditNotesRequest($xero_tenant_id, $credit_notes, $summarize_errors, $unitdp);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createCreditNotes'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\CreditNotes $credit_notes Credit Notes with array of CreditNote object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createCreditNotesRequest($xero_tenant_id, $credit_notes, $summarize_errors = false, $unitdp = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createCreditNotes'
            );
        }
        // verify the required parameter 'credit_notes' is set
        if ($credit_notes === null || (is_array($credit_notes) && count($credit_notes) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $credit_notes when calling createCreditNotes'
            );
        }

        $resourcePath = '/CreditNotes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $summarize_errors,
            'summarizeErrors', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $unitdp,
            'unitdp', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }



        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($credit_notes)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($credit_notes));
            } else {
                $httpBody = $credit_notes;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createCurrency
     *
     * Create a new currency for a Xero organisation
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Currency $currency Currency object in the body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Currencies
     */
    public function createCurrency($xero_tenant_id, $currency)
    {
        list($response) = $this->createCurrencyWithHttpInfo($xero_tenant_id, $currency);
        return $response;
    }

    /**
     * Operation createCurrencyWithHttpInfo
     *
     * Create a new currency for a Xero organisation
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Currency $currency Currency object in the body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Currencies, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCurrencyWithHttpInfo($xero_tenant_id, $currency)
    {
        $request = $this->createCurrencyRequest($xero_tenant_id, $currency);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Currencies' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Currencies' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Currencies', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Currencies';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Currencies',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createCurrencyAsync
     *
     * Create a new currency for a Xero organisation
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Currency $currency Currency object in the body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCurrencyAsync($xero_tenant_id, $currency)
    {
        return $this->createCurrencyAsyncWithHttpInfo($xero_tenant_id, $currency)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createCurrencyAsyncWithHttpInfo
     *
     * Create a new currency for a Xero organisation
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Currency $currency Currency object in the body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCurrencyAsyncWithHttpInfo($xero_tenant_id, $currency)
    {
        $returnType = '\Xero2\Accounting\Model\Currencies';
        $request = $this->createCurrencyRequest($xero_tenant_id, $currency);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createCurrency'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Currency $currency Currency object in the body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createCurrencyRequest($xero_tenant_id, $currency)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createCurrency'
            );
        }
        // verify the required parameter 'currency' is set
        if ($currency === null || (is_array($currency) && count($currency) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $currency when calling createCurrency'
            );
        }

        $resourcePath = '/Currencies';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }



        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($currency)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($currency));
            } else {
                $httpBody = $currency;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createEmployees
     *
     * Creates new employees used in Xero payrun
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Employees $employees Employees with array of Employee object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Employees|\Xero2\Accounting\Model\Error
     */
    public function createEmployees($xero_tenant_id, $employees, $summarize_errors = false)
    {
        list($response) = $this->createEmployeesWithHttpInfo($xero_tenant_id, $employees, $summarize_errors);
        return $response;
    }

    /**
     * Operation createEmployeesWithHttpInfo
     *
     * Creates new employees used in Xero payrun
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Employees $employees Employees with array of Employee object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Employees|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEmployeesWithHttpInfo($xero_tenant_id, $employees, $summarize_errors = false)
    {
        $request = $this->createEmployeesRequest($xero_tenant_id, $employees, $summarize_errors);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Employees' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Employees' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Employees', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Employees';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Employees',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createEmployeesAsync
     *
     * Creates new employees used in Xero payrun
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Employees $employees Employees with array of Employee object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEmployeesAsync($xero_tenant_id, $employees, $summarize_errors = false)
    {
        return $this->createEmployeesAsyncWithHttpInfo($xero_tenant_id, $employees, $summarize_errors)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createEmployeesAsyncWithHttpInfo
     *
     * Creates new employees used in Xero payrun
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Employees $employees Employees with array of Employee object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEmployeesAsyncWithHttpInfo($xero_tenant_id, $employees, $summarize_errors = false)
    {
        $returnType = '\Xero2\Accounting\Model\Employees';
        $request = $this->createEmployeesRequest($xero_tenant_id, $employees, $summarize_errors);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createEmployees'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Employees $employees Employees with array of Employee object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createEmployeesRequest($xero_tenant_id, $employees, $summarize_errors = false)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createEmployees'
            );
        }
        // verify the required parameter 'employees' is set
        if ($employees === null || (is_array($employees) && count($employees) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employees when calling createEmployees'
            );
        }

        $resourcePath = '/Employees';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $summarize_errors,
            'summarizeErrors', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }



        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($employees)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($employees));
            } else {
                $httpBody = $employees;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createExpenseClaimHistory
     *
     * Creates a history record for a specific expense claim
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $expense_claim_id Unique identifier for a ExpenseClaim (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords
     */
    public function createExpenseClaimHistory($xero_tenant_id, $expense_claim_id, $history_records)
    {
        list($response) = $this->createExpenseClaimHistoryWithHttpInfo($xero_tenant_id, $expense_claim_id, $history_records);
        return $response;
    }

    /**
     * Operation createExpenseClaimHistoryWithHttpInfo
     *
     * Creates a history record for a specific expense claim
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $expense_claim_id Unique identifier for a ExpenseClaim (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords, HTTP status code, HTTP response headers (array of strings)
     */
    public function createExpenseClaimHistoryWithHttpInfo($xero_tenant_id, $expense_claim_id, $history_records)
    {
        $request = $this->createExpenseClaimHistoryRequest($xero_tenant_id, $expense_claim_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\HistoryRecords' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createExpenseClaimHistoryAsync
     *
     * Creates a history record for a specific expense claim
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $expense_claim_id Unique identifier for a ExpenseClaim (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createExpenseClaimHistoryAsync($xero_tenant_id, $expense_claim_id, $history_records)
    {
        return $this->createExpenseClaimHistoryAsyncWithHttpInfo($xero_tenant_id, $expense_claim_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createExpenseClaimHistoryAsyncWithHttpInfo
     *
     * Creates a history record for a specific expense claim
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $expense_claim_id Unique identifier for a ExpenseClaim (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createExpenseClaimHistoryAsyncWithHttpInfo($xero_tenant_id, $expense_claim_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createExpenseClaimHistoryRequest($xero_tenant_id, $expense_claim_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createExpenseClaimHistory'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $expense_claim_id Unique identifier for a ExpenseClaim (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createExpenseClaimHistoryRequest($xero_tenant_id, $expense_claim_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createExpenseClaimHistory'
            );
        }
        // verify the required parameter 'expense_claim_id' is set
        if ($expense_claim_id === null || (is_array($expense_claim_id) && count($expense_claim_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $expense_claim_id when calling createExpenseClaimHistory'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createExpenseClaimHistory'
            );
        }

        $resourcePath = '/ExpenseClaims/{ExpenseClaimID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($expense_claim_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ExpenseClaimID' . '}',
                ObjectSerializer::toPathValue($expense_claim_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($history_records)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($history_records));
            } else {
                $httpBody = $history_records;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createExpenseClaims
     *
     * Creates expense claims
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ExpenseClaims $expense_claims ExpenseClaims with array of ExpenseClaim object in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\ExpenseClaims|\Xero2\Accounting\Model\Error
     */
    public function createExpenseClaims($xero_tenant_id, $expense_claims)
    {
        list($response) = $this->createExpenseClaimsWithHttpInfo($xero_tenant_id, $expense_claims);
        return $response;
    }

    /**
     * Operation createExpenseClaimsWithHttpInfo
     *
     * Creates expense claims
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ExpenseClaims $expense_claims ExpenseClaims with array of ExpenseClaim object in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\ExpenseClaims|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createExpenseClaimsWithHttpInfo($xero_tenant_id, $expense_claims)
    {
        $request = $this->createExpenseClaimsRequest($xero_tenant_id, $expense_claims);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\ExpenseClaims' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\ExpenseClaims' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\ExpenseClaims', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\ExpenseClaims';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\ExpenseClaims',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createExpenseClaimsAsync
     *
     * Creates expense claims
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ExpenseClaims $expense_claims ExpenseClaims with array of ExpenseClaim object in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createExpenseClaimsAsync($xero_tenant_id, $expense_claims)
    {
        return $this->createExpenseClaimsAsyncWithHttpInfo($xero_tenant_id, $expense_claims)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createExpenseClaimsAsyncWithHttpInfo
     *
     * Creates expense claims
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ExpenseClaims $expense_claims ExpenseClaims with array of ExpenseClaim object in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createExpenseClaimsAsyncWithHttpInfo($xero_tenant_id, $expense_claims)
    {
        $returnType = '\Xero2\Accounting\Model\ExpenseClaims';
        $request = $this->createExpenseClaimsRequest($xero_tenant_id, $expense_claims);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createExpenseClaims'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ExpenseClaims $expense_claims ExpenseClaims with array of ExpenseClaim object in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createExpenseClaimsRequest($xero_tenant_id, $expense_claims)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createExpenseClaims'
            );
        }
        // verify the required parameter 'expense_claims' is set
        if ($expense_claims === null || (is_array($expense_claims) && count($expense_claims) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $expense_claims when calling createExpenseClaims'
            );
        }

        $resourcePath = '/ExpenseClaims';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }



        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($expense_claims)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($expense_claims));
            } else {
                $httpBody = $expense_claims;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createInvoiceAttachmentByFileName
     *
     * Creates an attachment for a specific invoice or purchase bill by filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  string $file_name Name of the file you are attaching (required)
     * @param  string $body Byte array of file in body of request (required)
     * @param  bool $include_online Allows an attachment to be seen by the end customer within their online invoice (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error
     */
    public function createInvoiceAttachmentByFileName($xero_tenant_id, $invoice_id, $file_name, $body, $include_online = false)
    {
        list($response) = $this->createInvoiceAttachmentByFileNameWithHttpInfo($xero_tenant_id, $invoice_id, $file_name, $body, $include_online);
        return $response;
    }

    /**
     * Operation createInvoiceAttachmentByFileNameWithHttpInfo
     *
     * Creates an attachment for a specific invoice or purchase bill by filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  string $file_name Name of the file you are attaching (required)
     * @param  string $body Byte array of file in body of request (required)
     * @param  bool $include_online Allows an attachment to be seen by the end customer within their online invoice (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createInvoiceAttachmentByFileNameWithHttpInfo($xero_tenant_id, $invoice_id, $file_name, $body, $include_online = false)
    {
        $request = $this->createInvoiceAttachmentByFileNameRequest($xero_tenant_id, $invoice_id, $file_name, $body, $include_online);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Attachments' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Attachments' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Attachments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Attachments';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Attachments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createInvoiceAttachmentByFileNameAsync
     *
     * Creates an attachment for a specific invoice or purchase bill by filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  string $file_name Name of the file you are attaching (required)
     * @param  string $body Byte array of file in body of request (required)
     * @param  bool $include_online Allows an attachment to be seen by the end customer within their online invoice (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInvoiceAttachmentByFileNameAsync($xero_tenant_id, $invoice_id, $file_name, $body, $include_online = false)
    {
        return $this->createInvoiceAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $invoice_id, $file_name, $body, $include_online)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createInvoiceAttachmentByFileNameAsyncWithHttpInfo
     *
     * Creates an attachment for a specific invoice or purchase bill by filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  string $file_name Name of the file you are attaching (required)
     * @param  string $body Byte array of file in body of request (required)
     * @param  bool $include_online Allows an attachment to be seen by the end customer within their online invoice (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInvoiceAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $invoice_id, $file_name, $body, $include_online = false)
    {
        $returnType = '\Xero2\Accounting\Model\Attachments';
        $request = $this->createInvoiceAttachmentByFileNameRequest($xero_tenant_id, $invoice_id, $file_name, $body, $include_online);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createInvoiceAttachmentByFileName'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  string $file_name Name of the file you are attaching (required)
     * @param  string $body Byte array of file in body of request (required)
     * @param  bool $include_online Allows an attachment to be seen by the end customer within their online invoice (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createInvoiceAttachmentByFileNameRequest($xero_tenant_id, $invoice_id, $file_name, $body, $include_online = false)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createInvoiceAttachmentByFileName'
            );
        }
        // verify the required parameter 'invoice_id' is set
        if ($invoice_id === null || (is_array($invoice_id) && count($invoice_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $invoice_id when calling createInvoiceAttachmentByFileName'
            );
        }
        // verify the required parameter 'file_name' is set
        if ($file_name === null || (is_array($file_name) && count($file_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_name when calling createInvoiceAttachmentByFileName'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createInvoiceAttachmentByFileName'
            );
        }

        $resourcePath = '/Invoices/{InvoiceID}/Attachments/{FileName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_online,
            'IncludeOnline', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($invoice_id !== null) {
            $resourcePath = str_replace(
                '{' . 'InvoiceID' . '}',
                ObjectSerializer::toPathValue($invoice_id),
                $resourcePath
            );
        }
        // path params
        if ($file_name !== null) {
            $resourcePath = str_replace(
                '{' . 'FileName' . '}',
                ObjectSerializer::toPathValue($file_name),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/octet-stream']
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createInvoiceHistory
     *
     * Creates a history record for a specific invoice
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error
     */
    public function createInvoiceHistory($xero_tenant_id, $invoice_id, $history_records)
    {
        list($response) = $this->createInvoiceHistoryWithHttpInfo($xero_tenant_id, $invoice_id, $history_records);
        return $response;
    }

    /**
     * Operation createInvoiceHistoryWithHttpInfo
     *
     * Creates a history record for a specific invoice
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createInvoiceHistoryWithHttpInfo($xero_tenant_id, $invoice_id, $history_records)
    {
        $request = $this->createInvoiceHistoryRequest($xero_tenant_id, $invoice_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\HistoryRecords' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createInvoiceHistoryAsync
     *
     * Creates a history record for a specific invoice
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInvoiceHistoryAsync($xero_tenant_id, $invoice_id, $history_records)
    {
        return $this->createInvoiceHistoryAsyncWithHttpInfo($xero_tenant_id, $invoice_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createInvoiceHistoryAsyncWithHttpInfo
     *
     * Creates a history record for a specific invoice
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInvoiceHistoryAsyncWithHttpInfo($xero_tenant_id, $invoice_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createInvoiceHistoryRequest($xero_tenant_id, $invoice_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createInvoiceHistory'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createInvoiceHistoryRequest($xero_tenant_id, $invoice_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createInvoiceHistory'
            );
        }
        // verify the required parameter 'invoice_id' is set
        if ($invoice_id === null || (is_array($invoice_id) && count($invoice_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $invoice_id when calling createInvoiceHistory'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createInvoiceHistory'
            );
        }

        $resourcePath = '/Invoices/{InvoiceID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($invoice_id !== null) {
            $resourcePath = str_replace(
                '{' . 'InvoiceID' . '}',
                ObjectSerializer::toPathValue($invoice_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($history_records)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($history_records));
            } else {
                $httpBody = $history_records;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createInvoices
     *
     * Creates one or more sales invoices or purchase bills
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Invoices $invoices Invoices with an array of invoice objects in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Invoices|\Xero2\Accounting\Model\Error
     */
    public function createInvoices($xero_tenant_id, $invoices, $summarize_errors = false, $unitdp = null)
    {
        list($response) = $this->createInvoicesWithHttpInfo($xero_tenant_id, $invoices, $summarize_errors, $unitdp);
        return $response;
    }

    /**
     * Operation createInvoicesWithHttpInfo
     *
     * Creates one or more sales invoices or purchase bills
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Invoices $invoices Invoices with an array of invoice objects in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Invoices|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createInvoicesWithHttpInfo($xero_tenant_id, $invoices, $summarize_errors = false, $unitdp = null)
    {
        $request = $this->createInvoicesRequest($xero_tenant_id, $invoices, $summarize_errors, $unitdp);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Invoices' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Invoices' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Invoices', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Invoices';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Invoices',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createInvoicesAsync
     *
     * Creates one or more sales invoices or purchase bills
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Invoices $invoices Invoices with an array of invoice objects in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInvoicesAsync($xero_tenant_id, $invoices, $summarize_errors = false, $unitdp = null)
    {
        return $this->createInvoicesAsyncWithHttpInfo($xero_tenant_id, $invoices, $summarize_errors, $unitdp)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createInvoicesAsyncWithHttpInfo
     *
     * Creates one or more sales invoices or purchase bills
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Invoices $invoices Invoices with an array of invoice objects in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInvoicesAsyncWithHttpInfo($xero_tenant_id, $invoices, $summarize_errors = false, $unitdp = null)
    {
        $returnType = '\Xero2\Accounting\Model\Invoices';
        $request = $this->createInvoicesRequest($xero_tenant_id, $invoices, $summarize_errors, $unitdp);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createInvoices'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Invoices $invoices Invoices with an array of invoice objects in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createInvoicesRequest($xero_tenant_id, $invoices, $summarize_errors = false, $unitdp = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createInvoices'
            );
        }
        // verify the required parameter 'invoices' is set
        if ($invoices === null || (is_array($invoices) && count($invoices) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $invoices when calling createInvoices'
            );
        }

        $resourcePath = '/Invoices';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $summarize_errors,
            'summarizeErrors', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $unitdp,
            'unitdp', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }



        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($invoices)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($invoices));
            } else {
                $httpBody = $invoices;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createItemHistory
     *
     * Creates a history record for a specific item
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $item_id Unique identifier for an Item (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords
     */
    public function createItemHistory($xero_tenant_id, $item_id, $history_records)
    {
        list($response) = $this->createItemHistoryWithHttpInfo($xero_tenant_id, $item_id, $history_records);
        return $response;
    }

    /**
     * Operation createItemHistoryWithHttpInfo
     *
     * Creates a history record for a specific item
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $item_id Unique identifier for an Item (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords, HTTP status code, HTTP response headers (array of strings)
     */
    public function createItemHistoryWithHttpInfo($xero_tenant_id, $item_id, $history_records)
    {
        $request = $this->createItemHistoryRequest($xero_tenant_id, $item_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\HistoryRecords' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createItemHistoryAsync
     *
     * Creates a history record for a specific item
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $item_id Unique identifier for an Item (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createItemHistoryAsync($xero_tenant_id, $item_id, $history_records)
    {
        return $this->createItemHistoryAsyncWithHttpInfo($xero_tenant_id, $item_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createItemHistoryAsyncWithHttpInfo
     *
     * Creates a history record for a specific item
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $item_id Unique identifier for an Item (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createItemHistoryAsyncWithHttpInfo($xero_tenant_id, $item_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createItemHistoryRequest($xero_tenant_id, $item_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createItemHistory'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $item_id Unique identifier for an Item (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createItemHistoryRequest($xero_tenant_id, $item_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createItemHistory'
            );
        }
        // verify the required parameter 'item_id' is set
        if ($item_id === null || (is_array($item_id) && count($item_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $item_id when calling createItemHistory'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createItemHistory'
            );
        }

        $resourcePath = '/Items/{ItemID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($item_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ItemID' . '}',
                ObjectSerializer::toPathValue($item_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($history_records)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($history_records));
            } else {
                $httpBody = $history_records;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createItems
     *
     * Creates one or more items
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Items $items Items with an array of Item objects in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Items|\Xero2\Accounting\Model\Error
     */
    public function createItems($xero_tenant_id, $items, $summarize_errors = false, $unitdp = null)
    {
        list($response) = $this->createItemsWithHttpInfo($xero_tenant_id, $items, $summarize_errors, $unitdp);
        return $response;
    }

    /**
     * Operation createItemsWithHttpInfo
     *
     * Creates one or more items
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Items $items Items with an array of Item objects in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Items|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createItemsWithHttpInfo($xero_tenant_id, $items, $summarize_errors = false, $unitdp = null)
    {
        $request = $this->createItemsRequest($xero_tenant_id, $items, $summarize_errors, $unitdp);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Items' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Items' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Items', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Items';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Items',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createItemsAsync
     *
     * Creates one or more items
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Items $items Items with an array of Item objects in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createItemsAsync($xero_tenant_id, $items, $summarize_errors = false, $unitdp = null)
    {
        return $this->createItemsAsyncWithHttpInfo($xero_tenant_id, $items, $summarize_errors, $unitdp)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createItemsAsyncWithHttpInfo
     *
     * Creates one or more items
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Items $items Items with an array of Item objects in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createItemsAsyncWithHttpInfo($xero_tenant_id, $items, $summarize_errors = false, $unitdp = null)
    {
        $returnType = '\Xero2\Accounting\Model\Items';
        $request = $this->createItemsRequest($xero_tenant_id, $items, $summarize_errors, $unitdp);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createItems'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Items $items Items with an array of Item objects in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createItemsRequest($xero_tenant_id, $items, $summarize_errors = false, $unitdp = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createItems'
            );
        }
        // verify the required parameter 'items' is set
        if ($items === null || (is_array($items) && count($items) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $items when calling createItems'
            );
        }

        $resourcePath = '/Items';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $summarize_errors,
            'summarizeErrors', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $unitdp,
            'unitdp', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }



        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($items)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($items));
            } else {
                $httpBody = $items;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createLinkedTransaction
     *
     * Creates linked transactions (billable expenses)
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\LinkedTransaction $linked_transaction LinkedTransaction object in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\LinkedTransactions|\Xero2\Accounting\Model\Error
     */
    public function createLinkedTransaction($xero_tenant_id, $linked_transaction)
    {
        list($response) = $this->createLinkedTransactionWithHttpInfo($xero_tenant_id, $linked_transaction);
        return $response;
    }

    /**
     * Operation createLinkedTransactionWithHttpInfo
     *
     * Creates linked transactions (billable expenses)
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\LinkedTransaction $linked_transaction LinkedTransaction object in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\LinkedTransactions|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createLinkedTransactionWithHttpInfo($xero_tenant_id, $linked_transaction)
    {
        $request = $this->createLinkedTransactionRequest($xero_tenant_id, $linked_transaction);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\LinkedTransactions' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\LinkedTransactions' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\LinkedTransactions', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\LinkedTransactions';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\LinkedTransactions',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createLinkedTransactionAsync
     *
     * Creates linked transactions (billable expenses)
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\LinkedTransaction $linked_transaction LinkedTransaction object in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createLinkedTransactionAsync($xero_tenant_id, $linked_transaction)
    {
        return $this->createLinkedTransactionAsyncWithHttpInfo($xero_tenant_id, $linked_transaction)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createLinkedTransactionAsyncWithHttpInfo
     *
     * Creates linked transactions (billable expenses)
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\LinkedTransaction $linked_transaction LinkedTransaction object in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createLinkedTransactionAsyncWithHttpInfo($xero_tenant_id, $linked_transaction)
    {
        $returnType = '\Xero2\Accounting\Model\LinkedTransactions';
        $request = $this->createLinkedTransactionRequest($xero_tenant_id, $linked_transaction);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createLinkedTransaction'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\LinkedTransaction $linked_transaction LinkedTransaction object in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createLinkedTransactionRequest($xero_tenant_id, $linked_transaction)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createLinkedTransaction'
            );
        }
        // verify the required parameter 'linked_transaction' is set
        if ($linked_transaction === null || (is_array($linked_transaction) && count($linked_transaction) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $linked_transaction when calling createLinkedTransaction'
            );
        }

        $resourcePath = '/LinkedTransactions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }



        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($linked_transaction)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($linked_transaction));
            } else {
                $httpBody = $linked_transaction;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createManualJournalAttachmentByFileName
     *
     * Creates a specific attachment for a specific manual journal by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $manual_journal_id Unique identifier for a ManualJournal (required)
     * @param  string $file_name The name of the file being attached to a ManualJournal (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error
     */
    public function createManualJournalAttachmentByFileName($xero_tenant_id, $manual_journal_id, $file_name, $body)
    {
        list($response) = $this->createManualJournalAttachmentByFileNameWithHttpInfo($xero_tenant_id, $manual_journal_id, $file_name, $body);
        return $response;
    }

    /**
     * Operation createManualJournalAttachmentByFileNameWithHttpInfo
     *
     * Creates a specific attachment for a specific manual journal by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $manual_journal_id Unique identifier for a ManualJournal (required)
     * @param  string $file_name The name of the file being attached to a ManualJournal (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createManualJournalAttachmentByFileNameWithHttpInfo($xero_tenant_id, $manual_journal_id, $file_name, $body)
    {
        $request = $this->createManualJournalAttachmentByFileNameRequest($xero_tenant_id, $manual_journal_id, $file_name, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Attachments' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Attachments' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Attachments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Attachments';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Attachments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createManualJournalAttachmentByFileNameAsync
     *
     * Creates a specific attachment for a specific manual journal by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $manual_journal_id Unique identifier for a ManualJournal (required)
     * @param  string $file_name The name of the file being attached to a ManualJournal (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createManualJournalAttachmentByFileNameAsync($xero_tenant_id, $manual_journal_id, $file_name, $body)
    {
        return $this->createManualJournalAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $manual_journal_id, $file_name, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createManualJournalAttachmentByFileNameAsyncWithHttpInfo
     *
     * Creates a specific attachment for a specific manual journal by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $manual_journal_id Unique identifier for a ManualJournal (required)
     * @param  string $file_name The name of the file being attached to a ManualJournal (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createManualJournalAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $manual_journal_id, $file_name, $body)
    {
        $returnType = '\Xero2\Accounting\Model\Attachments';
        $request = $this->createManualJournalAttachmentByFileNameRequest($xero_tenant_id, $manual_journal_id, $file_name, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createManualJournalAttachmentByFileName'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $manual_journal_id Unique identifier for a ManualJournal (required)
     * @param  string $file_name The name of the file being attached to a ManualJournal (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createManualJournalAttachmentByFileNameRequest($xero_tenant_id, $manual_journal_id, $file_name, $body)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createManualJournalAttachmentByFileName'
            );
        }
        // verify the required parameter 'manual_journal_id' is set
        if ($manual_journal_id === null || (is_array($manual_journal_id) && count($manual_journal_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $manual_journal_id when calling createManualJournalAttachmentByFileName'
            );
        }
        // verify the required parameter 'file_name' is set
        if ($file_name === null || (is_array($file_name) && count($file_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_name when calling createManualJournalAttachmentByFileName'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createManualJournalAttachmentByFileName'
            );
        }

        $resourcePath = '/ManualJournals/{ManualJournalID}/Attachments/{FileName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($manual_journal_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ManualJournalID' . '}',
                ObjectSerializer::toPathValue($manual_journal_id),
                $resourcePath
            );
        }
        // path params
        if ($file_name !== null) {
            $resourcePath = str_replace(
                '{' . 'FileName' . '}',
                ObjectSerializer::toPathValue($file_name),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/octet-stream']
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createManualJournalHistoryRecord
     *
     * Creates a history record for a specific manual journal
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $manual_journal_id Xero generated unique identifier for a manual journal (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error
     */
    public function createManualJournalHistoryRecord($xero_tenant_id, $manual_journal_id, $history_records)
    {
        list($response) = $this->createManualJournalHistoryRecordWithHttpInfo($xero_tenant_id, $manual_journal_id, $history_records);
        return $response;
    }

    /**
     * Operation createManualJournalHistoryRecordWithHttpInfo
     *
     * Creates a history record for a specific manual journal
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $manual_journal_id Xero generated unique identifier for a manual journal (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createManualJournalHistoryRecordWithHttpInfo($xero_tenant_id, $manual_journal_id, $history_records)
    {
        $request = $this->createManualJournalHistoryRecordRequest($xero_tenant_id, $manual_journal_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\HistoryRecords' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createManualJournalHistoryRecordAsync
     *
     * Creates a history record for a specific manual journal
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $manual_journal_id Xero generated unique identifier for a manual journal (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createManualJournalHistoryRecordAsync($xero_tenant_id, $manual_journal_id, $history_records)
    {
        return $this->createManualJournalHistoryRecordAsyncWithHttpInfo($xero_tenant_id, $manual_journal_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createManualJournalHistoryRecordAsyncWithHttpInfo
     *
     * Creates a history record for a specific manual journal
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $manual_journal_id Xero generated unique identifier for a manual journal (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createManualJournalHistoryRecordAsyncWithHttpInfo($xero_tenant_id, $manual_journal_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createManualJournalHistoryRecordRequest($xero_tenant_id, $manual_journal_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createManualJournalHistoryRecord'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $manual_journal_id Xero generated unique identifier for a manual journal (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createManualJournalHistoryRecordRequest($xero_tenant_id, $manual_journal_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createManualJournalHistoryRecord'
            );
        }
        // verify the required parameter 'manual_journal_id' is set
        if ($manual_journal_id === null || (is_array($manual_journal_id) && count($manual_journal_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $manual_journal_id when calling createManualJournalHistoryRecord'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createManualJournalHistoryRecord'
            );
        }

        $resourcePath = '/ManualJournals/{ManualJournalID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($manual_journal_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ManualJournalID' . '}',
                ObjectSerializer::toPathValue($manual_journal_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($history_records)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($history_records));
            } else {
                $httpBody = $history_records;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createManualJournals
     *
     * Creates one or more manual journals
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ManualJournals $manual_journals ManualJournals array with ManualJournal object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\ManualJournals|\Xero2\Accounting\Model\Error
     */
    public function createManualJournals($xero_tenant_id, $manual_journals, $summarize_errors = false)
    {
        list($response) = $this->createManualJournalsWithHttpInfo($xero_tenant_id, $manual_journals, $summarize_errors);
        return $response;
    }

    /**
     * Operation createManualJournalsWithHttpInfo
     *
     * Creates one or more manual journals
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ManualJournals $manual_journals ManualJournals array with ManualJournal object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\ManualJournals|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createManualJournalsWithHttpInfo($xero_tenant_id, $manual_journals, $summarize_errors = false)
    {
        $request = $this->createManualJournalsRequest($xero_tenant_id, $manual_journals, $summarize_errors);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\ManualJournals' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\ManualJournals' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\ManualJournals', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\ManualJournals';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\ManualJournals',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createManualJournalsAsync
     *
     * Creates one or more manual journals
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ManualJournals $manual_journals ManualJournals array with ManualJournal object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createManualJournalsAsync($xero_tenant_id, $manual_journals, $summarize_errors = false)
    {
        return $this->createManualJournalsAsyncWithHttpInfo($xero_tenant_id, $manual_journals, $summarize_errors)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createManualJournalsAsyncWithHttpInfo
     *
     * Creates one or more manual journals
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ManualJournals $manual_journals ManualJournals array with ManualJournal object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createManualJournalsAsyncWithHttpInfo($xero_tenant_id, $manual_journals, $summarize_errors = false)
    {
        $returnType = '\Xero2\Accounting\Model\ManualJournals';
        $request = $this->createManualJournalsRequest($xero_tenant_id, $manual_journals, $summarize_errors);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createManualJournals'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ManualJournals $manual_journals ManualJournals array with ManualJournal object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createManualJournalsRequest($xero_tenant_id, $manual_journals, $summarize_errors = false)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createManualJournals'
            );
        }
        // verify the required parameter 'manual_journals' is set
        if ($manual_journals === null || (is_array($manual_journals) && count($manual_journals) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $manual_journals when calling createManualJournals'
            );
        }

        $resourcePath = '/ManualJournals';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $summarize_errors,
            'summarizeErrors', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }



        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($manual_journals)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($manual_journals));
            } else {
                $httpBody = $manual_journals;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createOverpaymentAllocations
     *
     * Creates a single allocation for a specific overpayment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $overpayment_id Unique identifier for a Overpayment (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations Allocations array with Allocation object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Allocations|\Xero2\Accounting\Model\Error
     */
    public function createOverpaymentAllocations($xero_tenant_id, $overpayment_id, $allocations, $summarize_errors = false)
    {
        list($response) = $this->createOverpaymentAllocationsWithHttpInfo($xero_tenant_id, $overpayment_id, $allocations, $summarize_errors);
        return $response;
    }

    /**
     * Operation createOverpaymentAllocationsWithHttpInfo
     *
     * Creates a single allocation for a specific overpayment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $overpayment_id Unique identifier for a Overpayment (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations Allocations array with Allocation object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Allocations|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createOverpaymentAllocationsWithHttpInfo($xero_tenant_id, $overpayment_id, $allocations, $summarize_errors = false)
    {
        $request = $this->createOverpaymentAllocationsRequest($xero_tenant_id, $overpayment_id, $allocations, $summarize_errors);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Allocations' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Allocations' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Allocations', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Allocations';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Allocations',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createOverpaymentAllocationsAsync
     *
     * Creates a single allocation for a specific overpayment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $overpayment_id Unique identifier for a Overpayment (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations Allocations array with Allocation object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOverpaymentAllocationsAsync($xero_tenant_id, $overpayment_id, $allocations, $summarize_errors = false)
    {
        return $this->createOverpaymentAllocationsAsyncWithHttpInfo($xero_tenant_id, $overpayment_id, $allocations, $summarize_errors)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createOverpaymentAllocationsAsyncWithHttpInfo
     *
     * Creates a single allocation for a specific overpayment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $overpayment_id Unique identifier for a Overpayment (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations Allocations array with Allocation object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOverpaymentAllocationsAsyncWithHttpInfo($xero_tenant_id, $overpayment_id, $allocations, $summarize_errors = false)
    {
        $returnType = '\Xero2\Accounting\Model\Allocations';
        $request = $this->createOverpaymentAllocationsRequest($xero_tenant_id, $overpayment_id, $allocations, $summarize_errors);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createOverpaymentAllocations'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $overpayment_id Unique identifier for a Overpayment (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations Allocations array with Allocation object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createOverpaymentAllocationsRequest($xero_tenant_id, $overpayment_id, $allocations, $summarize_errors = false)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createOverpaymentAllocations'
            );
        }
        // verify the required parameter 'overpayment_id' is set
        if ($overpayment_id === null || (is_array($overpayment_id) && count($overpayment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $overpayment_id when calling createOverpaymentAllocations'
            );
        }
        // verify the required parameter 'allocations' is set
        if ($allocations === null || (is_array($allocations) && count($allocations) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $allocations when calling createOverpaymentAllocations'
            );
        }

        $resourcePath = '/Overpayments/{OverpaymentID}/Allocations';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $summarize_errors,
            'summarizeErrors', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($overpayment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'OverpaymentID' . '}',
                ObjectSerializer::toPathValue($overpayment_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($allocations)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($allocations));
            } else {
                $httpBody = $allocations;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createOverpaymentHistory
     *
     * Creates a history record for a specific overpayment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $overpayment_id Unique identifier for a Overpayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error
     */
    public function createOverpaymentHistory($xero_tenant_id, $overpayment_id, $history_records)
    {
        list($response) = $this->createOverpaymentHistoryWithHttpInfo($xero_tenant_id, $overpayment_id, $history_records);
        return $response;
    }

    /**
     * Operation createOverpaymentHistoryWithHttpInfo
     *
     * Creates a history record for a specific overpayment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $overpayment_id Unique identifier for a Overpayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createOverpaymentHistoryWithHttpInfo($xero_tenant_id, $overpayment_id, $history_records)
    {
        $request = $this->createOverpaymentHistoryRequest($xero_tenant_id, $overpayment_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\HistoryRecords' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createOverpaymentHistoryAsync
     *
     * Creates a history record for a specific overpayment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $overpayment_id Unique identifier for a Overpayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOverpaymentHistoryAsync($xero_tenant_id, $overpayment_id, $history_records)
    {
        return $this->createOverpaymentHistoryAsyncWithHttpInfo($xero_tenant_id, $overpayment_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createOverpaymentHistoryAsyncWithHttpInfo
     *
     * Creates a history record for a specific overpayment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $overpayment_id Unique identifier for a Overpayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOverpaymentHistoryAsyncWithHttpInfo($xero_tenant_id, $overpayment_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createOverpaymentHistoryRequest($xero_tenant_id, $overpayment_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createOverpaymentHistory'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $overpayment_id Unique identifier for a Overpayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createOverpaymentHistoryRequest($xero_tenant_id, $overpayment_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createOverpaymentHistory'
            );
        }
        // verify the required parameter 'overpayment_id' is set
        if ($overpayment_id === null || (is_array($overpayment_id) && count($overpayment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $overpayment_id when calling createOverpaymentHistory'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createOverpaymentHistory'
            );
        }

        $resourcePath = '/Overpayments/{OverpaymentID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($overpayment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'OverpaymentID' . '}',
                ObjectSerializer::toPathValue($overpayment_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($history_records)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($history_records));
            } else {
                $httpBody = $history_records;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPayment
     *
     * Creates a single payment for invoice or credit notes
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Payment $payment Request body with a single Payment object (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Payments|\Xero2\Accounting\Model\Error
     */
    public function createPayment($xero_tenant_id, $payment)
    {
        list($response) = $this->createPaymentWithHttpInfo($xero_tenant_id, $payment);
        return $response;
    }

    /**
     * Operation createPaymentWithHttpInfo
     *
     * Creates a single payment for invoice or credit notes
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Payment $payment Request body with a single Payment object (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Payments|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPaymentWithHttpInfo($xero_tenant_id, $payment)
    {
        $request = $this->createPaymentRequest($xero_tenant_id, $payment);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Payments' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Payments' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Payments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Payments';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Payments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createPaymentAsync
     *
     * Creates a single payment for invoice or credit notes
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Payment $payment Request body with a single Payment object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPaymentAsync($xero_tenant_id, $payment)
    {
        return $this->createPaymentAsyncWithHttpInfo($xero_tenant_id, $payment)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPaymentAsyncWithHttpInfo
     *
     * Creates a single payment for invoice or credit notes
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Payment $payment Request body with a single Payment object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPaymentAsyncWithHttpInfo($xero_tenant_id, $payment)
    {
        $returnType = '\Xero2\Accounting\Model\Payments';
        $request = $this->createPaymentRequest($xero_tenant_id, $payment);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPayment'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Payment $payment Request body with a single Payment object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createPaymentRequest($xero_tenant_id, $payment)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createPayment'
            );
        }
        // verify the required parameter 'payment' is set
        if ($payment === null || (is_array($payment) && count($payment) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payment when calling createPayment'
            );
        }

        $resourcePath = '/Payments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }



        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($payment)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($payment));
            } else {
                $httpBody = $payment;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPaymentHistory
     *
     * Creates a history record for a specific payment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payment_id Unique identifier for a Payment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error
     */
    public function createPaymentHistory($xero_tenant_id, $payment_id, $history_records)
    {
        list($response) = $this->createPaymentHistoryWithHttpInfo($xero_tenant_id, $payment_id, $history_records);
        return $response;
    }

    /**
     * Operation createPaymentHistoryWithHttpInfo
     *
     * Creates a history record for a specific payment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payment_id Unique identifier for a Payment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPaymentHistoryWithHttpInfo($xero_tenant_id, $payment_id, $history_records)
    {
        $request = $this->createPaymentHistoryRequest($xero_tenant_id, $payment_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\HistoryRecords' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createPaymentHistoryAsync
     *
     * Creates a history record for a specific payment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payment_id Unique identifier for a Payment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPaymentHistoryAsync($xero_tenant_id, $payment_id, $history_records)
    {
        return $this->createPaymentHistoryAsyncWithHttpInfo($xero_tenant_id, $payment_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPaymentHistoryAsyncWithHttpInfo
     *
     * Creates a history record for a specific payment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payment_id Unique identifier for a Payment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPaymentHistoryAsyncWithHttpInfo($xero_tenant_id, $payment_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createPaymentHistoryRequest($xero_tenant_id, $payment_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPaymentHistory'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payment_id Unique identifier for a Payment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createPaymentHistoryRequest($xero_tenant_id, $payment_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createPaymentHistory'
            );
        }
        // verify the required parameter 'payment_id' is set
        if ($payment_id === null || (is_array($payment_id) && count($payment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payment_id when calling createPaymentHistory'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createPaymentHistory'
            );
        }

        $resourcePath = '/Payments/{PaymentID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($payment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PaymentID' . '}',
                ObjectSerializer::toPathValue($payment_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($history_records)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($history_records));
            } else {
                $httpBody = $history_records;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPaymentService
     *
     * Creates a payment service
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\PaymentServices $payment_services PaymentServices array with PaymentService object in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\PaymentServices|\Xero2\Accounting\Model\Error
     */
    public function createPaymentService($xero_tenant_id, $payment_services)
    {
        list($response) = $this->createPaymentServiceWithHttpInfo($xero_tenant_id, $payment_services);
        return $response;
    }

    /**
     * Operation createPaymentServiceWithHttpInfo
     *
     * Creates a payment service
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\PaymentServices $payment_services PaymentServices array with PaymentService object in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\PaymentServices|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPaymentServiceWithHttpInfo($xero_tenant_id, $payment_services)
    {
        $request = $this->createPaymentServiceRequest($xero_tenant_id, $payment_services);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\PaymentServices' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\PaymentServices' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\PaymentServices', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\PaymentServices';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\PaymentServices',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createPaymentServiceAsync
     *
     * Creates a payment service
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\PaymentServices $payment_services PaymentServices array with PaymentService object in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPaymentServiceAsync($xero_tenant_id, $payment_services)
    {
        return $this->createPaymentServiceAsyncWithHttpInfo($xero_tenant_id, $payment_services)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPaymentServiceAsyncWithHttpInfo
     *
     * Creates a payment service
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\PaymentServices $payment_services PaymentServices array with PaymentService object in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPaymentServiceAsyncWithHttpInfo($xero_tenant_id, $payment_services)
    {
        $returnType = '\Xero2\Accounting\Model\PaymentServices';
        $request = $this->createPaymentServiceRequest($xero_tenant_id, $payment_services);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPaymentService'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\PaymentServices $payment_services PaymentServices array with PaymentService object in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createPaymentServiceRequest($xero_tenant_id, $payment_services)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createPaymentService'
            );
        }
        // verify the required parameter 'payment_services' is set
        if ($payment_services === null || (is_array($payment_services) && count($payment_services) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payment_services when calling createPaymentService'
            );
        }

        $resourcePath = '/PaymentServices';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }



        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($payment_services)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($payment_services));
            } else {
                $httpBody = $payment_services;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPayments
     *
     * Creates multiple payments for invoices or credit notes
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Payments $payments Payments array with Payment object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Payments|\Xero2\Accounting\Model\Error
     */
    public function createPayments($xero_tenant_id, $payments, $summarize_errors = false)
    {
        list($response) = $this->createPaymentsWithHttpInfo($xero_tenant_id, $payments, $summarize_errors);
        return $response;
    }

    /**
     * Operation createPaymentsWithHttpInfo
     *
     * Creates multiple payments for invoices or credit notes
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Payments $payments Payments array with Payment object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Payments|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPaymentsWithHttpInfo($xero_tenant_id, $payments, $summarize_errors = false)
    {
        $request = $this->createPaymentsRequest($xero_tenant_id, $payments, $summarize_errors);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Payments' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Payments' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Payments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Payments';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Payments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createPaymentsAsync
     *
     * Creates multiple payments for invoices or credit notes
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Payments $payments Payments array with Payment object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPaymentsAsync($xero_tenant_id, $payments, $summarize_errors = false)
    {
        return $this->createPaymentsAsyncWithHttpInfo($xero_tenant_id, $payments, $summarize_errors)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPaymentsAsyncWithHttpInfo
     *
     * Creates multiple payments for invoices or credit notes
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Payments $payments Payments array with Payment object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPaymentsAsyncWithHttpInfo($xero_tenant_id, $payments, $summarize_errors = false)
    {
        $returnType = '\Xero2\Accounting\Model\Payments';
        $request = $this->createPaymentsRequest($xero_tenant_id, $payments, $summarize_errors);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPayments'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Payments $payments Payments array with Payment object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createPaymentsRequest($xero_tenant_id, $payments, $summarize_errors = false)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createPayments'
            );
        }
        // verify the required parameter 'payments' is set
        if ($payments === null || (is_array($payments) && count($payments) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payments when calling createPayments'
            );
        }

        $resourcePath = '/Payments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $summarize_errors,
            'summarizeErrors', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }



        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($payments)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($payments));
            } else {
                $httpBody = $payments;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPrepaymentAllocations
     *
     * Allows you to create an Allocation for prepayments
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $prepayment_id Unique identifier for Prepayment (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations Allocations with an array of Allocation object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Allocations|\Xero2\Accounting\Model\Error
     */
    public function createPrepaymentAllocations($xero_tenant_id, $prepayment_id, $allocations, $summarize_errors = false)
    {
        list($response) = $this->createPrepaymentAllocationsWithHttpInfo($xero_tenant_id, $prepayment_id, $allocations, $summarize_errors);
        return $response;
    }

    /**
     * Operation createPrepaymentAllocationsWithHttpInfo
     *
     * Allows you to create an Allocation for prepayments
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $prepayment_id Unique identifier for Prepayment (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations Allocations with an array of Allocation object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Allocations|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPrepaymentAllocationsWithHttpInfo($xero_tenant_id, $prepayment_id, $allocations, $summarize_errors = false)
    {
        $request = $this->createPrepaymentAllocationsRequest($xero_tenant_id, $prepayment_id, $allocations, $summarize_errors);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Allocations' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Allocations' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Allocations', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Allocations';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Allocations',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createPrepaymentAllocationsAsync
     *
     * Allows you to create an Allocation for prepayments
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $prepayment_id Unique identifier for Prepayment (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations Allocations with an array of Allocation object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPrepaymentAllocationsAsync($xero_tenant_id, $prepayment_id, $allocations, $summarize_errors = false)
    {
        return $this->createPrepaymentAllocationsAsyncWithHttpInfo($xero_tenant_id, $prepayment_id, $allocations, $summarize_errors)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPrepaymentAllocationsAsyncWithHttpInfo
     *
     * Allows you to create an Allocation for prepayments
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $prepayment_id Unique identifier for Prepayment (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations Allocations with an array of Allocation object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPrepaymentAllocationsAsyncWithHttpInfo($xero_tenant_id, $prepayment_id, $allocations, $summarize_errors = false)
    {
        $returnType = '\Xero2\Accounting\Model\Allocations';
        $request = $this->createPrepaymentAllocationsRequest($xero_tenant_id, $prepayment_id, $allocations, $summarize_errors);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPrepaymentAllocations'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $prepayment_id Unique identifier for Prepayment (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations Allocations with an array of Allocation object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createPrepaymentAllocationsRequest($xero_tenant_id, $prepayment_id, $allocations, $summarize_errors = false)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createPrepaymentAllocations'
            );
        }
        // verify the required parameter 'prepayment_id' is set
        if ($prepayment_id === null || (is_array($prepayment_id) && count($prepayment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $prepayment_id when calling createPrepaymentAllocations'
            );
        }
        // verify the required parameter 'allocations' is set
        if ($allocations === null || (is_array($allocations) && count($allocations) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $allocations when calling createPrepaymentAllocations'
            );
        }

        $resourcePath = '/Prepayments/{PrepaymentID}/Allocations';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $summarize_errors,
            'summarizeErrors', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($prepayment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PrepaymentID' . '}',
                ObjectSerializer::toPathValue($prepayment_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($allocations)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($allocations));
            } else {
                $httpBody = $allocations;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPrepaymentHistory
     *
     * Creates a history record for a specific prepayment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $prepayment_id Unique identifier for a PrePayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error
     */
    public function createPrepaymentHistory($xero_tenant_id, $prepayment_id, $history_records)
    {
        list($response) = $this->createPrepaymentHistoryWithHttpInfo($xero_tenant_id, $prepayment_id, $history_records);
        return $response;
    }

    /**
     * Operation createPrepaymentHistoryWithHttpInfo
     *
     * Creates a history record for a specific prepayment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $prepayment_id Unique identifier for a PrePayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPrepaymentHistoryWithHttpInfo($xero_tenant_id, $prepayment_id, $history_records)
    {
        $request = $this->createPrepaymentHistoryRequest($xero_tenant_id, $prepayment_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\HistoryRecords' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createPrepaymentHistoryAsync
     *
     * Creates a history record for a specific prepayment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $prepayment_id Unique identifier for a PrePayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPrepaymentHistoryAsync($xero_tenant_id, $prepayment_id, $history_records)
    {
        return $this->createPrepaymentHistoryAsyncWithHttpInfo($xero_tenant_id, $prepayment_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPrepaymentHistoryAsyncWithHttpInfo
     *
     * Creates a history record for a specific prepayment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $prepayment_id Unique identifier for a PrePayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPrepaymentHistoryAsyncWithHttpInfo($xero_tenant_id, $prepayment_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createPrepaymentHistoryRequest($xero_tenant_id, $prepayment_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPrepaymentHistory'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $prepayment_id Unique identifier for a PrePayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createPrepaymentHistoryRequest($xero_tenant_id, $prepayment_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createPrepaymentHistory'
            );
        }
        // verify the required parameter 'prepayment_id' is set
        if ($prepayment_id === null || (is_array($prepayment_id) && count($prepayment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $prepayment_id when calling createPrepaymentHistory'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createPrepaymentHistory'
            );
        }

        $resourcePath = '/Prepayments/{PrepaymentID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($prepayment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PrepaymentID' . '}',
                ObjectSerializer::toPathValue($prepayment_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($history_records)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($history_records));
            } else {
                $httpBody = $history_records;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPurchaseOrderAttachmentByFileName
     *
     * Creates attachment for a specific purchase order
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $purchase_order_id Unique identifier for Purchase Order object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error
     */
    public function createPurchaseOrderAttachmentByFileName($xero_tenant_id, $purchase_order_id, $file_name, $body)
    {
        list($response) = $this->createPurchaseOrderAttachmentByFileNameWithHttpInfo($xero_tenant_id, $purchase_order_id, $file_name, $body);
        return $response;
    }

    /**
     * Operation createPurchaseOrderAttachmentByFileNameWithHttpInfo
     *
     * Creates attachment for a specific purchase order
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $purchase_order_id Unique identifier for Purchase Order object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPurchaseOrderAttachmentByFileNameWithHttpInfo($xero_tenant_id, $purchase_order_id, $file_name, $body)
    {
        $request = $this->createPurchaseOrderAttachmentByFileNameRequest($xero_tenant_id, $purchase_order_id, $file_name, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Attachments' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Attachments' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Attachments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Attachments';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Attachments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createPurchaseOrderAttachmentByFileNameAsync
     *
     * Creates attachment for a specific purchase order
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $purchase_order_id Unique identifier for Purchase Order object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPurchaseOrderAttachmentByFileNameAsync($xero_tenant_id, $purchase_order_id, $file_name, $body)
    {
        return $this->createPurchaseOrderAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $purchase_order_id, $file_name, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPurchaseOrderAttachmentByFileNameAsyncWithHttpInfo
     *
     * Creates attachment for a specific purchase order
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $purchase_order_id Unique identifier for Purchase Order object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPurchaseOrderAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $purchase_order_id, $file_name, $body)
    {
        $returnType = '\Xero2\Accounting\Model\Attachments';
        $request = $this->createPurchaseOrderAttachmentByFileNameRequest($xero_tenant_id, $purchase_order_id, $file_name, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPurchaseOrderAttachmentByFileName'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $purchase_order_id Unique identifier for Purchase Order object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createPurchaseOrderAttachmentByFileNameRequest($xero_tenant_id, $purchase_order_id, $file_name, $body)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createPurchaseOrderAttachmentByFileName'
            );
        }
        // verify the required parameter 'purchase_order_id' is set
        if ($purchase_order_id === null || (is_array($purchase_order_id) && count($purchase_order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $purchase_order_id when calling createPurchaseOrderAttachmentByFileName'
            );
        }
        // verify the required parameter 'file_name' is set
        if ($file_name === null || (is_array($file_name) && count($file_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_name when calling createPurchaseOrderAttachmentByFileName'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createPurchaseOrderAttachmentByFileName'
            );
        }

        $resourcePath = '/PurchaseOrders/{PurchaseOrderID}/Attachments/{FileName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($purchase_order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PurchaseOrderID' . '}',
                ObjectSerializer::toPathValue($purchase_order_id),
                $resourcePath
            );
        }
        // path params
        if ($file_name !== null) {
            $resourcePath = str_replace(
                '{' . 'FileName' . '}',
                ObjectSerializer::toPathValue($file_name),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/octet-stream']
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPurchaseOrderHistory
     *
     * Creates a history record for a specific purchase orders
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $purchase_order_id Unique identifier for a PurchaseOrder (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error
     */
    public function createPurchaseOrderHistory($xero_tenant_id, $purchase_order_id, $history_records)
    {
        list($response) = $this->createPurchaseOrderHistoryWithHttpInfo($xero_tenant_id, $purchase_order_id, $history_records);
        return $response;
    }

    /**
     * Operation createPurchaseOrderHistoryWithHttpInfo
     *
     * Creates a history record for a specific purchase orders
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $purchase_order_id Unique identifier for a PurchaseOrder (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPurchaseOrderHistoryWithHttpInfo($xero_tenant_id, $purchase_order_id, $history_records)
    {
        $request = $this->createPurchaseOrderHistoryRequest($xero_tenant_id, $purchase_order_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\HistoryRecords' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createPurchaseOrderHistoryAsync
     *
     * Creates a history record for a specific purchase orders
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $purchase_order_id Unique identifier for a PurchaseOrder (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPurchaseOrderHistoryAsync($xero_tenant_id, $purchase_order_id, $history_records)
    {
        return $this->createPurchaseOrderHistoryAsyncWithHttpInfo($xero_tenant_id, $purchase_order_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPurchaseOrderHistoryAsyncWithHttpInfo
     *
     * Creates a history record for a specific purchase orders
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $purchase_order_id Unique identifier for a PurchaseOrder (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPurchaseOrderHistoryAsyncWithHttpInfo($xero_tenant_id, $purchase_order_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createPurchaseOrderHistoryRequest($xero_tenant_id, $purchase_order_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPurchaseOrderHistory'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $purchase_order_id Unique identifier for a PurchaseOrder (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createPurchaseOrderHistoryRequest($xero_tenant_id, $purchase_order_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createPurchaseOrderHistory'
            );
        }
        // verify the required parameter 'purchase_order_id' is set
        if ($purchase_order_id === null || (is_array($purchase_order_id) && count($purchase_order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $purchase_order_id when calling createPurchaseOrderHistory'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createPurchaseOrderHistory'
            );
        }

        $resourcePath = '/PurchaseOrders/{PurchaseOrderID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($purchase_order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PurchaseOrderID' . '}',
                ObjectSerializer::toPathValue($purchase_order_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($history_records)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($history_records));
            } else {
                $httpBody = $history_records;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPurchaseOrders
     *
     * Creates one or more purchase orders
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\PurchaseOrders $purchase_orders PurchaseOrders with an array of PurchaseOrder object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\PurchaseOrders|\Xero2\Accounting\Model\Error
     */
    public function createPurchaseOrders($xero_tenant_id, $purchase_orders, $summarize_errors = false)
    {
        list($response) = $this->createPurchaseOrdersWithHttpInfo($xero_tenant_id, $purchase_orders, $summarize_errors);
        return $response;
    }

    /**
     * Operation createPurchaseOrdersWithHttpInfo
     *
     * Creates one or more purchase orders
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\PurchaseOrders $purchase_orders PurchaseOrders with an array of PurchaseOrder object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\PurchaseOrders|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPurchaseOrdersWithHttpInfo($xero_tenant_id, $purchase_orders, $summarize_errors = false)
    {
        $request = $this->createPurchaseOrdersRequest($xero_tenant_id, $purchase_orders, $summarize_errors);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\PurchaseOrders' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\PurchaseOrders' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\PurchaseOrders', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\PurchaseOrders';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\PurchaseOrders',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createPurchaseOrdersAsync
     *
     * Creates one or more purchase orders
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\PurchaseOrders $purchase_orders PurchaseOrders with an array of PurchaseOrder object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPurchaseOrdersAsync($xero_tenant_id, $purchase_orders, $summarize_errors = false)
    {
        return $this->createPurchaseOrdersAsyncWithHttpInfo($xero_tenant_id, $purchase_orders, $summarize_errors)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPurchaseOrdersAsyncWithHttpInfo
     *
     * Creates one or more purchase orders
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\PurchaseOrders $purchase_orders PurchaseOrders with an array of PurchaseOrder object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPurchaseOrdersAsyncWithHttpInfo($xero_tenant_id, $purchase_orders, $summarize_errors = false)
    {
        $returnType = '\Xero2\Accounting\Model\PurchaseOrders';
        $request = $this->createPurchaseOrdersRequest($xero_tenant_id, $purchase_orders, $summarize_errors);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPurchaseOrders'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\PurchaseOrders $purchase_orders PurchaseOrders with an array of PurchaseOrder object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createPurchaseOrdersRequest($xero_tenant_id, $purchase_orders, $summarize_errors = false)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createPurchaseOrders'
            );
        }
        // verify the required parameter 'purchase_orders' is set
        if ($purchase_orders === null || (is_array($purchase_orders) && count($purchase_orders) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $purchase_orders when calling createPurchaseOrders'
            );
        }

        $resourcePath = '/PurchaseOrders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $summarize_errors,
            'summarizeErrors', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }



        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($purchase_orders)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($purchase_orders));
            } else {
                $httpBody = $purchase_orders;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createQuoteAttachmentByFileName
     *
     * Creates attachment for a specific quote
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $quote_id Unique identifier for Quote object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error
     */
    public function createQuoteAttachmentByFileName($xero_tenant_id, $quote_id, $file_name, $body)
    {
        list($response) = $this->createQuoteAttachmentByFileNameWithHttpInfo($xero_tenant_id, $quote_id, $file_name, $body);
        return $response;
    }

    /**
     * Operation createQuoteAttachmentByFileNameWithHttpInfo
     *
     * Creates attachment for a specific quote
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $quote_id Unique identifier for Quote object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createQuoteAttachmentByFileNameWithHttpInfo($xero_tenant_id, $quote_id, $file_name, $body)
    {
        $request = $this->createQuoteAttachmentByFileNameRequest($xero_tenant_id, $quote_id, $file_name, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Attachments' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Attachments' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Attachments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Attachments';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Attachments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createQuoteAttachmentByFileNameAsync
     *
     * Creates attachment for a specific quote
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $quote_id Unique identifier for Quote object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createQuoteAttachmentByFileNameAsync($xero_tenant_id, $quote_id, $file_name, $body)
    {
        return $this->createQuoteAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $quote_id, $file_name, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createQuoteAttachmentByFileNameAsyncWithHttpInfo
     *
     * Creates attachment for a specific quote
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $quote_id Unique identifier for Quote object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createQuoteAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $quote_id, $file_name, $body)
    {
        $returnType = '\Xero2\Accounting\Model\Attachments';
        $request = $this->createQuoteAttachmentByFileNameRequest($xero_tenant_id, $quote_id, $file_name, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createQuoteAttachmentByFileName'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $quote_id Unique identifier for Quote object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createQuoteAttachmentByFileNameRequest($xero_tenant_id, $quote_id, $file_name, $body)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createQuoteAttachmentByFileName'
            );
        }
        // verify the required parameter 'quote_id' is set
        if ($quote_id === null || (is_array($quote_id) && count($quote_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $quote_id when calling createQuoteAttachmentByFileName'
            );
        }
        // verify the required parameter 'file_name' is set
        if ($file_name === null || (is_array($file_name) && count($file_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_name when calling createQuoteAttachmentByFileName'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createQuoteAttachmentByFileName'
            );
        }

        $resourcePath = '/Quotes/{QuoteID}/Attachments/{FileName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($quote_id !== null) {
            $resourcePath = str_replace(
                '{' . 'QuoteID' . '}',
                ObjectSerializer::toPathValue($quote_id),
                $resourcePath
            );
        }
        // path params
        if ($file_name !== null) {
            $resourcePath = str_replace(
                '{' . 'FileName' . '}',
                ObjectSerializer::toPathValue($file_name),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/octet-stream']
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createQuoteHistory
     *
     * Creates a history record for a specific quote
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $quote_id Unique identifier for an Quote (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error
     */
    public function createQuoteHistory($xero_tenant_id, $quote_id, $history_records)
    {
        list($response) = $this->createQuoteHistoryWithHttpInfo($xero_tenant_id, $quote_id, $history_records);
        return $response;
    }

    /**
     * Operation createQuoteHistoryWithHttpInfo
     *
     * Creates a history record for a specific quote
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $quote_id Unique identifier for an Quote (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createQuoteHistoryWithHttpInfo($xero_tenant_id, $quote_id, $history_records)
    {
        $request = $this->createQuoteHistoryRequest($xero_tenant_id, $quote_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\HistoryRecords' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createQuoteHistoryAsync
     *
     * Creates a history record for a specific quote
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $quote_id Unique identifier for an Quote (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createQuoteHistoryAsync($xero_tenant_id, $quote_id, $history_records)
    {
        return $this->createQuoteHistoryAsyncWithHttpInfo($xero_tenant_id, $quote_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createQuoteHistoryAsyncWithHttpInfo
     *
     * Creates a history record for a specific quote
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $quote_id Unique identifier for an Quote (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createQuoteHistoryAsyncWithHttpInfo($xero_tenant_id, $quote_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createQuoteHistoryRequest($xero_tenant_id, $quote_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createQuoteHistory'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $quote_id Unique identifier for an Quote (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createQuoteHistoryRequest($xero_tenant_id, $quote_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createQuoteHistory'
            );
        }
        // verify the required parameter 'quote_id' is set
        if ($quote_id === null || (is_array($quote_id) && count($quote_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $quote_id when calling createQuoteHistory'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createQuoteHistory'
            );
        }

        $resourcePath = '/Quotes/{QuoteID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($quote_id !== null) {
            $resourcePath = str_replace(
                '{' . 'QuoteID' . '}',
                ObjectSerializer::toPathValue($quote_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($history_records)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($history_records));
            } else {
                $httpBody = $history_records;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createQuotes
     *
     * Create one or more quotes
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Quotes $quotes Quotes with an array of Quote object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Quotes|\Xero2\Accounting\Model\Error
     */
    public function createQuotes($xero_tenant_id, $quotes, $summarize_errors = false)
    {
        list($response) = $this->createQuotesWithHttpInfo($xero_tenant_id, $quotes, $summarize_errors);
        return $response;
    }

    /**
     * Operation createQuotesWithHttpInfo
     *
     * Create one or more quotes
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Quotes $quotes Quotes with an array of Quote object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Quotes|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createQuotesWithHttpInfo($xero_tenant_id, $quotes, $summarize_errors = false)
    {
        $request = $this->createQuotesRequest($xero_tenant_id, $quotes, $summarize_errors);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Quotes' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Quotes' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Quotes', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Quotes';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Quotes',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createQuotesAsync
     *
     * Create one or more quotes
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Quotes $quotes Quotes with an array of Quote object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createQuotesAsync($xero_tenant_id, $quotes, $summarize_errors = false)
    {
        return $this->createQuotesAsyncWithHttpInfo($xero_tenant_id, $quotes, $summarize_errors)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createQuotesAsyncWithHttpInfo
     *
     * Create one or more quotes
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Quotes $quotes Quotes with an array of Quote object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createQuotesAsyncWithHttpInfo($xero_tenant_id, $quotes, $summarize_errors = false)
    {
        $returnType = '\Xero2\Accounting\Model\Quotes';
        $request = $this->createQuotesRequest($xero_tenant_id, $quotes, $summarize_errors);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createQuotes'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Quotes $quotes Quotes with an array of Quote object in body of request (required)
     * @param  bool $summarize_errors If false return 200 OK and mix of successfully created objects and any with validation errors (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createQuotesRequest($xero_tenant_id, $quotes, $summarize_errors = false)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createQuotes'
            );
        }
        // verify the required parameter 'quotes' is set
        if ($quotes === null || (is_array($quotes) && count($quotes) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $quotes when calling createQuotes'
            );
        }

        $resourcePath = '/Quotes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $summarize_errors,
            'summarizeErrors', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }



        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($quotes)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($quotes));
            } else {
                $httpBody = $quotes;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createReceipt
     *
     * Creates draft expense claim receipts for any user
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Receipts $receipts Receipts with an array of Receipt object in body of request (required)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Receipts|\Xero2\Accounting\Model\Error
     */
    public function createReceipt($xero_tenant_id, $receipts, $unitdp = null)
    {
        list($response) = $this->createReceiptWithHttpInfo($xero_tenant_id, $receipts, $unitdp);
        return $response;
    }

    /**
     * Operation createReceiptWithHttpInfo
     *
     * Creates draft expense claim receipts for any user
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Receipts $receipts Receipts with an array of Receipt object in body of request (required)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Receipts|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createReceiptWithHttpInfo($xero_tenant_id, $receipts, $unitdp = null)
    {
        $request = $this->createReceiptRequest($xero_tenant_id, $receipts, $unitdp);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Receipts' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Receipts' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Receipts', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Receipts';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Receipts',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createReceiptAsync
     *
     * Creates draft expense claim receipts for any user
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Receipts $receipts Receipts with an array of Receipt object in body of request (required)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createReceiptAsync($xero_tenant_id, $receipts, $unitdp = null)
    {
        return $this->createReceiptAsyncWithHttpInfo($xero_tenant_id, $receipts, $unitdp)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createReceiptAsyncWithHttpInfo
     *
     * Creates draft expense claim receipts for any user
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Receipts $receipts Receipts with an array of Receipt object in body of request (required)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createReceiptAsyncWithHttpInfo($xero_tenant_id, $receipts, $unitdp = null)
    {
        $returnType = '\Xero2\Accounting\Model\Receipts';
        $request = $this->createReceiptRequest($xero_tenant_id, $receipts, $unitdp);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createReceipt'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Receipts $receipts Receipts with an array of Receipt object in body of request (required)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createReceiptRequest($xero_tenant_id, $receipts, $unitdp = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createReceipt'
            );
        }
        // verify the required parameter 'receipts' is set
        if ($receipts === null || (is_array($receipts) && count($receipts) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $receipts when calling createReceipt'
            );
        }

        $resourcePath = '/Receipts';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $unitdp,
            'unitdp', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }



        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($receipts)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($receipts));
            } else {
                $httpBody = $receipts;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createReceiptAttachmentByFileName
     *
     * Creates an attachment on a specific expense claim receipts by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $receipt_id Unique identifier for a Receipt (required)
     * @param  string $file_name The name of the file being attached to the Receipt (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error
     */
    public function createReceiptAttachmentByFileName($xero_tenant_id, $receipt_id, $file_name, $body)
    {
        list($response) = $this->createReceiptAttachmentByFileNameWithHttpInfo($xero_tenant_id, $receipt_id, $file_name, $body);
        return $response;
    }

    /**
     * Operation createReceiptAttachmentByFileNameWithHttpInfo
     *
     * Creates an attachment on a specific expense claim receipts by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $receipt_id Unique identifier for a Receipt (required)
     * @param  string $file_name The name of the file being attached to the Receipt (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createReceiptAttachmentByFileNameWithHttpInfo($xero_tenant_id, $receipt_id, $file_name, $body)
    {
        $request = $this->createReceiptAttachmentByFileNameRequest($xero_tenant_id, $receipt_id, $file_name, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Attachments' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Attachments' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Attachments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Attachments';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Attachments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createReceiptAttachmentByFileNameAsync
     *
     * Creates an attachment on a specific expense claim receipts by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $receipt_id Unique identifier for a Receipt (required)
     * @param  string $file_name The name of the file being attached to the Receipt (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createReceiptAttachmentByFileNameAsync($xero_tenant_id, $receipt_id, $file_name, $body)
    {
        return $this->createReceiptAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $receipt_id, $file_name, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createReceiptAttachmentByFileNameAsyncWithHttpInfo
     *
     * Creates an attachment on a specific expense claim receipts by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $receipt_id Unique identifier for a Receipt (required)
     * @param  string $file_name The name of the file being attached to the Receipt (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createReceiptAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $receipt_id, $file_name, $body)
    {
        $returnType = '\Xero2\Accounting\Model\Attachments';
        $request = $this->createReceiptAttachmentByFileNameRequest($xero_tenant_id, $receipt_id, $file_name, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createReceiptAttachmentByFileName'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $receipt_id Unique identifier for a Receipt (required)
     * @param  string $file_name The name of the file being attached to the Receipt (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createReceiptAttachmentByFileNameRequest($xero_tenant_id, $receipt_id, $file_name, $body)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createReceiptAttachmentByFileName'
            );
        }
        // verify the required parameter 'receipt_id' is set
        if ($receipt_id === null || (is_array($receipt_id) && count($receipt_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $receipt_id when calling createReceiptAttachmentByFileName'
            );
        }
        // verify the required parameter 'file_name' is set
        if ($file_name === null || (is_array($file_name) && count($file_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_name when calling createReceiptAttachmentByFileName'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createReceiptAttachmentByFileName'
            );
        }

        $resourcePath = '/Receipts/{ReceiptID}/Attachments/{FileName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($receipt_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ReceiptID' . '}',
                ObjectSerializer::toPathValue($receipt_id),
                $resourcePath
            );
        }
        // path params
        if ($file_name !== null) {
            $resourcePath = str_replace(
                '{' . 'FileName' . '}',
                ObjectSerializer::toPathValue($file_name),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/octet-stream']
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createReceiptHistory
     *
     * Creates a history record for a specific receipt
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $receipt_id Unique identifier for a Receipt (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error
     */
    public function createReceiptHistory($xero_tenant_id, $receipt_id, $history_records)
    {
        list($response) = $this->createReceiptHistoryWithHttpInfo($xero_tenant_id, $receipt_id, $history_records);
        return $response;
    }

    /**
     * Operation createReceiptHistoryWithHttpInfo
     *
     * Creates a history record for a specific receipt
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $receipt_id Unique identifier for a Receipt (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createReceiptHistoryWithHttpInfo($xero_tenant_id, $receipt_id, $history_records)
    {
        $request = $this->createReceiptHistoryRequest($xero_tenant_id, $receipt_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\HistoryRecords' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createReceiptHistoryAsync
     *
     * Creates a history record for a specific receipt
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $receipt_id Unique identifier for a Receipt (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createReceiptHistoryAsync($xero_tenant_id, $receipt_id, $history_records)
    {
        return $this->createReceiptHistoryAsyncWithHttpInfo($xero_tenant_id, $receipt_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createReceiptHistoryAsyncWithHttpInfo
     *
     * Creates a history record for a specific receipt
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $receipt_id Unique identifier for a Receipt (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createReceiptHistoryAsyncWithHttpInfo($xero_tenant_id, $receipt_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createReceiptHistoryRequest($xero_tenant_id, $receipt_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createReceiptHistory'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $receipt_id Unique identifier for a Receipt (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createReceiptHistoryRequest($xero_tenant_id, $receipt_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createReceiptHistory'
            );
        }
        // verify the required parameter 'receipt_id' is set
        if ($receipt_id === null || (is_array($receipt_id) && count($receipt_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $receipt_id when calling createReceiptHistory'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createReceiptHistory'
            );
        }

        $resourcePath = '/Receipts/{ReceiptID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($receipt_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ReceiptID' . '}',
                ObjectSerializer::toPathValue($receipt_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($history_records)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($history_records));
            } else {
                $httpBody = $history_records;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createRepeatingInvoiceAttachmentByFileName
     *
     * Creates an attachment from a specific repeating invoices by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $repeating_invoice_id Unique identifier for a Repeating Invoice (required)
     * @param  string $file_name The name of the file being attached to a Repeating Invoice (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error
     */
    public function createRepeatingInvoiceAttachmentByFileName($xero_tenant_id, $repeating_invoice_id, $file_name, $body)
    {
        list($response) = $this->createRepeatingInvoiceAttachmentByFileNameWithHttpInfo($xero_tenant_id, $repeating_invoice_id, $file_name, $body);
        return $response;
    }

    /**
     * Operation createRepeatingInvoiceAttachmentByFileNameWithHttpInfo
     *
     * Creates an attachment from a specific repeating invoices by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $repeating_invoice_id Unique identifier for a Repeating Invoice (required)
     * @param  string $file_name The name of the file being attached to a Repeating Invoice (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createRepeatingInvoiceAttachmentByFileNameWithHttpInfo($xero_tenant_id, $repeating_invoice_id, $file_name, $body)
    {
        $request = $this->createRepeatingInvoiceAttachmentByFileNameRequest($xero_tenant_id, $repeating_invoice_id, $file_name, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Attachments' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Attachments' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Attachments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Attachments';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Attachments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createRepeatingInvoiceAttachmentByFileNameAsync
     *
     * Creates an attachment from a specific repeating invoices by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $repeating_invoice_id Unique identifier for a Repeating Invoice (required)
     * @param  string $file_name The name of the file being attached to a Repeating Invoice (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createRepeatingInvoiceAttachmentByFileNameAsync($xero_tenant_id, $repeating_invoice_id, $file_name, $body)
    {
        return $this->createRepeatingInvoiceAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $repeating_invoice_id, $file_name, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createRepeatingInvoiceAttachmentByFileNameAsyncWithHttpInfo
     *
     * Creates an attachment from a specific repeating invoices by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $repeating_invoice_id Unique identifier for a Repeating Invoice (required)
     * @param  string $file_name The name of the file being attached to a Repeating Invoice (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createRepeatingInvoiceAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $repeating_invoice_id, $file_name, $body)
    {
        $returnType = '\Xero2\Accounting\Model\Attachments';
        $request = $this->createRepeatingInvoiceAttachmentByFileNameRequest($xero_tenant_id, $repeating_invoice_id, $file_name, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createRepeatingInvoiceAttachmentByFileName'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $repeating_invoice_id Unique identifier for a Repeating Invoice (required)
     * @param  string $file_name The name of the file being attached to a Repeating Invoice (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createRepeatingInvoiceAttachmentByFileNameRequest($xero_tenant_id, $repeating_invoice_id, $file_name, $body)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createRepeatingInvoiceAttachmentByFileName'
            );
        }
        // verify the required parameter 'repeating_invoice_id' is set
        if ($repeating_invoice_id === null || (is_array($repeating_invoice_id) && count($repeating_invoice_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $repeating_invoice_id when calling createRepeatingInvoiceAttachmentByFileName'
            );
        }
        // verify the required parameter 'file_name' is set
        if ($file_name === null || (is_array($file_name) && count($file_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_name when calling createRepeatingInvoiceAttachmentByFileName'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createRepeatingInvoiceAttachmentByFileName'
            );
        }

        $resourcePath = '/RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{FileName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($repeating_invoice_id !== null) {
            $resourcePath = str_replace(
                '{' . 'RepeatingInvoiceID' . '}',
                ObjectSerializer::toPathValue($repeating_invoice_id),
                $resourcePath
            );
        }
        // path params
        if ($file_name !== null) {
            $resourcePath = str_replace(
                '{' . 'FileName' . '}',
                ObjectSerializer::toPathValue($file_name),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/octet-stream']
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createRepeatingInvoiceHistory
     *
     * Creates a  history record for a specific repeating invoice
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $repeating_invoice_id Unique identifier for a Repeating Invoice (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error
     */
    public function createRepeatingInvoiceHistory($xero_tenant_id, $repeating_invoice_id, $history_records)
    {
        list($response) = $this->createRepeatingInvoiceHistoryWithHttpInfo($xero_tenant_id, $repeating_invoice_id, $history_records);
        return $response;
    }

    /**
     * Operation createRepeatingInvoiceHistoryWithHttpInfo
     *
     * Creates a  history record for a specific repeating invoice
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $repeating_invoice_id Unique identifier for a Repeating Invoice (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createRepeatingInvoiceHistoryWithHttpInfo($xero_tenant_id, $repeating_invoice_id, $history_records)
    {
        $request = $this->createRepeatingInvoiceHistoryRequest($xero_tenant_id, $repeating_invoice_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\HistoryRecords' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createRepeatingInvoiceHistoryAsync
     *
     * Creates a  history record for a specific repeating invoice
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $repeating_invoice_id Unique identifier for a Repeating Invoice (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createRepeatingInvoiceHistoryAsync($xero_tenant_id, $repeating_invoice_id, $history_records)
    {
        return $this->createRepeatingInvoiceHistoryAsyncWithHttpInfo($xero_tenant_id, $repeating_invoice_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createRepeatingInvoiceHistoryAsyncWithHttpInfo
     *
     * Creates a  history record for a specific repeating invoice
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $repeating_invoice_id Unique identifier for a Repeating Invoice (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createRepeatingInvoiceHistoryAsyncWithHttpInfo($xero_tenant_id, $repeating_invoice_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createRepeatingInvoiceHistoryRequest($xero_tenant_id, $repeating_invoice_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createRepeatingInvoiceHistory'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $repeating_invoice_id Unique identifier for a Repeating Invoice (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records HistoryRecords containing an array of HistoryRecord objects in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createRepeatingInvoiceHistoryRequest($xero_tenant_id, $repeating_invoice_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createRepeatingInvoiceHistory'
            );
        }
        // verify the required parameter 'repeating_invoice_id' is set
        if ($repeating_invoice_id === null || (is_array($repeating_invoice_id) && count($repeating_invoice_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $repeating_invoice_id when calling createRepeatingInvoiceHistory'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createRepeatingInvoiceHistory'
            );
        }

        $resourcePath = '/RepeatingInvoices/{RepeatingInvoiceID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($repeating_invoice_id !== null) {
            $resourcePath = str_replace(
                '{' . 'RepeatingInvoiceID' . '}',
                ObjectSerializer::toPathValue($repeating_invoice_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($history_records)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($history_records));
            } else {
                $httpBody = $history_records;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createTaxRates
     *
     * Creates one or more tax rates
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\TaxRates $tax_rates TaxRates array with TaxRate object in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\TaxRates|\Xero2\Accounting\Model\Error
     */
    public function createTaxRates($xero_tenant_id, $tax_rates)
    {
        list($response) = $this->createTaxRatesWithHttpInfo($xero_tenant_id, $tax_rates);
        return $response;
    }

    /**
     * Operation createTaxRatesWithHttpInfo
     *
     * Creates one or more tax rates
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\TaxRates $tax_rates TaxRates array with TaxRate object in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\TaxRates|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTaxRatesWithHttpInfo($xero_tenant_id, $tax_rates)
    {
        $request = $this->createTaxRatesRequest($xero_tenant_id, $tax_rates);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\TaxRates' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\TaxRates' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\TaxRates', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\TaxRates';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\TaxRates',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createTaxRatesAsync
     *
     * Creates one or more tax rates
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\TaxRates $tax_rates TaxRates array with TaxRate object in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTaxRatesAsync($xero_tenant_id, $tax_rates)
    {
        return $this->createTaxRatesAsyncWithHttpInfo($xero_tenant_id, $tax_rates)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createTaxRatesAsyncWithHttpInfo
     *
     * Creates one or more tax rates
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\TaxRates $tax_rates TaxRates array with TaxRate object in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTaxRatesAsyncWithHttpInfo($xero_tenant_id, $tax_rates)
    {
        $returnType = '\Xero2\Accounting\Model\TaxRates';
        $request = $this->createTaxRatesRequest($xero_tenant_id, $tax_rates);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createTaxRates'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\TaxRates $tax_rates TaxRates array with TaxRate object in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createTaxRatesRequest($xero_tenant_id, $tax_rates)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createTaxRates'
            );
        }
        // verify the required parameter 'tax_rates' is set
        if ($tax_rates === null || (is_array($tax_rates) && count($tax_rates) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $tax_rates when calling createTaxRates'
            );
        }

        $resourcePath = '/TaxRates';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }



        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($tax_rates)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($tax_rates));
            } else {
                $httpBody = $tax_rates;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createTrackingCategory
     *
     * Create tracking categories
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\TrackingCategory $tracking_category TrackingCategory object in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\TrackingCategories|\Xero2\Accounting\Model\Error
     */
    public function createTrackingCategory($xero_tenant_id, $tracking_category)
    {
        list($response) = $this->createTrackingCategoryWithHttpInfo($xero_tenant_id, $tracking_category);
        return $response;
    }

    /**
     * Operation createTrackingCategoryWithHttpInfo
     *
     * Create tracking categories
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\TrackingCategory $tracking_category TrackingCategory object in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\TrackingCategories|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTrackingCategoryWithHttpInfo($xero_tenant_id, $tracking_category)
    {
        $request = $this->createTrackingCategoryRequest($xero_tenant_id, $tracking_category);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\TrackingCategories' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\TrackingCategories' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\TrackingCategories', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\TrackingCategories';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\TrackingCategories',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createTrackingCategoryAsync
     *
     * Create tracking categories
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\TrackingCategory $tracking_category TrackingCategory object in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTrackingCategoryAsync($xero_tenant_id, $tracking_category)
    {
        return $this->createTrackingCategoryAsyncWithHttpInfo($xero_tenant_id, $tracking_category)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createTrackingCategoryAsyncWithHttpInfo
     *
     * Create tracking categories
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\TrackingCategory $tracking_category TrackingCategory object in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTrackingCategoryAsyncWithHttpInfo($xero_tenant_id, $tracking_category)
    {
        $returnType = '\Xero2\Accounting\Model\TrackingCategories';
        $request = $this->createTrackingCategoryRequest($xero_tenant_id, $tracking_category);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createTrackingCategory'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\TrackingCategory $tracking_category TrackingCategory object in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createTrackingCategoryRequest($xero_tenant_id, $tracking_category)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createTrackingCategory'
            );
        }
        // verify the required parameter 'tracking_category' is set
        if ($tracking_category === null || (is_array($tracking_category) && count($tracking_category) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $tracking_category when calling createTrackingCategory'
            );
        }

        $resourcePath = '/TrackingCategories';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }



        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($tracking_category)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($tracking_category));
            } else {
                $httpBody = $tracking_category;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createTrackingOptions
     *
     * Creates options for a specific tracking category
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     * @param  \Xero2\Accounting\Model\TrackingOption $tracking_option TrackingOption object in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\TrackingOptions|\Xero2\Accounting\Model\Error
     */
    public function createTrackingOptions($xero_tenant_id, $tracking_category_id, $tracking_option)
    {
        list($response) = $this->createTrackingOptionsWithHttpInfo($xero_tenant_id, $tracking_category_id, $tracking_option);
        return $response;
    }

    /**
     * Operation createTrackingOptionsWithHttpInfo
     *
     * Creates options for a specific tracking category
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     * @param  \Xero2\Accounting\Model\TrackingOption $tracking_option TrackingOption object in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\TrackingOptions|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTrackingOptionsWithHttpInfo($xero_tenant_id, $tracking_category_id, $tracking_option)
    {
        $request = $this->createTrackingOptionsRequest($xero_tenant_id, $tracking_category_id, $tracking_option);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\TrackingOptions' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\TrackingOptions' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\TrackingOptions', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\TrackingOptions';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\TrackingOptions',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createTrackingOptionsAsync
     *
     * Creates options for a specific tracking category
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     * @param  \Xero2\Accounting\Model\TrackingOption $tracking_option TrackingOption object in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTrackingOptionsAsync($xero_tenant_id, $tracking_category_id, $tracking_option)
    {
        return $this->createTrackingOptionsAsyncWithHttpInfo($xero_tenant_id, $tracking_category_id, $tracking_option)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createTrackingOptionsAsyncWithHttpInfo
     *
     * Creates options for a specific tracking category
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     * @param  \Xero2\Accounting\Model\TrackingOption $tracking_option TrackingOption object in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTrackingOptionsAsyncWithHttpInfo($xero_tenant_id, $tracking_category_id, $tracking_option)
    {
        $returnType = '\Xero2\Accounting\Model\TrackingOptions';
        $request = $this->createTrackingOptionsRequest($xero_tenant_id, $tracking_category_id, $tracking_option);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createTrackingOptions'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     * @param  \Xero2\Accounting\Model\TrackingOption $tracking_option TrackingOption object in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createTrackingOptionsRequest($xero_tenant_id, $tracking_category_id, $tracking_option)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createTrackingOptions'
            );
        }
        // verify the required parameter 'tracking_category_id' is set
        if ($tracking_category_id === null || (is_array($tracking_category_id) && count($tracking_category_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $tracking_category_id when calling createTrackingOptions'
            );
        }
        // verify the required parameter 'tracking_option' is set
        if ($tracking_option === null || (is_array($tracking_option) && count($tracking_option) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $tracking_option when calling createTrackingOptions'
            );
        }

        $resourcePath = '/TrackingCategories/{TrackingCategoryID}/Options';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($tracking_category_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TrackingCategoryID' . '}',
                ObjectSerializer::toPathValue($tracking_category_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($tracking_option)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($tracking_option));
            } else {
                $httpBody = $tracking_option;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteAccount
     *
     * Deletes a chart of accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for retrieving single object (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Accounts|\Xero2\Accounting\Model\Error
     */
    public function deleteAccount($xero_tenant_id, $account_id)
    {
        list($response) = $this->deleteAccountWithHttpInfo($xero_tenant_id, $account_id);
        return $response;
    }

    /**
     * Operation deleteAccountWithHttpInfo
     *
     * Deletes a chart of accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for retrieving single object (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Accounts|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteAccountWithHttpInfo($xero_tenant_id, $account_id)
    {
        $request = $this->deleteAccountRequest($xero_tenant_id, $account_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Accounts' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Accounts' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Accounts', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Accounts';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Accounts',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteAccountAsync
     *
     * Deletes a chart of accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for retrieving single object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteAccountAsync($xero_tenant_id, $account_id)
    {
        return $this->deleteAccountAsyncWithHttpInfo($xero_tenant_id, $account_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteAccountAsyncWithHttpInfo
     *
     * Deletes a chart of accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for retrieving single object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteAccountAsyncWithHttpInfo($xero_tenant_id, $account_id)
    {
        $returnType = '\Xero2\Accounting\Model\Accounts';
        $request = $this->deleteAccountRequest($xero_tenant_id, $account_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteAccount'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for retrieving single object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteAccountRequest($xero_tenant_id, $account_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deleteAccount'
            );
        }
        // verify the required parameter 'account_id' is set
        if ($account_id === null || (is_array($account_id) && count($account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $account_id when calling deleteAccount'
            );
        }

        $resourcePath = '/Accounts/{AccountID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                '{' . 'AccountID' . '}',
                ObjectSerializer::toPathValue($account_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteContactGroupContact
     *
     * Deletes a specific contact from a contact group using a unique contact Id
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteContactGroupContact($xero_tenant_id, $contact_group_id, $contact_id)
    {
        $this->deleteContactGroupContactWithHttpInfo($xero_tenant_id, $contact_group_id, $contact_id);
    }

    /**
     * Operation deleteContactGroupContactWithHttpInfo
     *
     * Deletes a specific contact from a contact group using a unique contact Id
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteContactGroupContactWithHttpInfo($xero_tenant_id, $contact_group_id, $contact_id)
    {
        $request = $this->deleteContactGroupContactRequest($xero_tenant_id, $contact_group_id, $contact_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteContactGroupContactAsync
     *
     * Deletes a specific contact from a contact group using a unique contact Id
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteContactGroupContactAsync($xero_tenant_id, $contact_group_id, $contact_id)
    {
        return $this->deleteContactGroupContactAsyncWithHttpInfo($xero_tenant_id, $contact_group_id, $contact_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteContactGroupContactAsyncWithHttpInfo
     *
     * Deletes a specific contact from a contact group using a unique contact Id
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteContactGroupContactAsyncWithHttpInfo($xero_tenant_id, $contact_group_id, $contact_id)
    {
        $returnType = '';
        $request = $this->deleteContactGroupContactRequest($xero_tenant_id, $contact_group_id, $contact_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteContactGroupContact'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteContactGroupContactRequest($xero_tenant_id, $contact_group_id, $contact_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deleteContactGroupContact'
            );
        }
        // verify the required parameter 'contact_group_id' is set
        if ($contact_group_id === null || (is_array($contact_group_id) && count($contact_group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $contact_group_id when calling deleteContactGroupContact'
            );
        }
        // verify the required parameter 'contact_id' is set
        if ($contact_id === null || (is_array($contact_id) && count($contact_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $contact_id when calling deleteContactGroupContact'
            );
        }

        $resourcePath = '/ContactGroups/{ContactGroupID}/Contacts/{ContactID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($contact_group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ContactGroupID' . '}',
                ObjectSerializer::toPathValue($contact_group_id),
                $resourcePath
            );
        }
        // path params
        if ($contact_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ContactID' . '}',
                ObjectSerializer::toPathValue($contact_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteContactGroupContacts
     *
     * Deletes all contacts from a specific contact group
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteContactGroupContacts($xero_tenant_id, $contact_group_id)
    {
        $this->deleteContactGroupContactsWithHttpInfo($xero_tenant_id, $contact_group_id);
    }

    /**
     * Operation deleteContactGroupContactsWithHttpInfo
     *
     * Deletes all contacts from a specific contact group
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteContactGroupContactsWithHttpInfo($xero_tenant_id, $contact_group_id)
    {
        $request = $this->deleteContactGroupContactsRequest($xero_tenant_id, $contact_group_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteContactGroupContactsAsync
     *
     * Deletes all contacts from a specific contact group
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteContactGroupContactsAsync($xero_tenant_id, $contact_group_id)
    {
        return $this->deleteContactGroupContactsAsyncWithHttpInfo($xero_tenant_id, $contact_group_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteContactGroupContactsAsyncWithHttpInfo
     *
     * Deletes all contacts from a specific contact group
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteContactGroupContactsAsyncWithHttpInfo($xero_tenant_id, $contact_group_id)
    {
        $returnType = '';
        $request = $this->deleteContactGroupContactsRequest($xero_tenant_id, $contact_group_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteContactGroupContacts'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteContactGroupContactsRequest($xero_tenant_id, $contact_group_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deleteContactGroupContacts'
            );
        }
        // verify the required parameter 'contact_group_id' is set
        if ($contact_group_id === null || (is_array($contact_group_id) && count($contact_group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $contact_group_id when calling deleteContactGroupContacts'
            );
        }

        $resourcePath = '/ContactGroups/{ContactGroupID}/Contacts';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($contact_group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ContactGroupID' . '}',
                ObjectSerializer::toPathValue($contact_group_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteItem
     *
     * Deletes a specific item
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $item_id Unique identifier for an Item (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteItem($xero_tenant_id, $item_id)
    {
        $this->deleteItemWithHttpInfo($xero_tenant_id, $item_id);
    }

    /**
     * Operation deleteItemWithHttpInfo
     *
     * Deletes a specific item
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $item_id Unique identifier for an Item (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteItemWithHttpInfo($xero_tenant_id, $item_id)
    {
        $request = $this->deleteItemRequest($xero_tenant_id, $item_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteItemAsync
     *
     * Deletes a specific item
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $item_id Unique identifier for an Item (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteItemAsync($xero_tenant_id, $item_id)
    {
        return $this->deleteItemAsyncWithHttpInfo($xero_tenant_id, $item_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteItemAsyncWithHttpInfo
     *
     * Deletes a specific item
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $item_id Unique identifier for an Item (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteItemAsyncWithHttpInfo($xero_tenant_id, $item_id)
    {
        $returnType = '';
        $request = $this->deleteItemRequest($xero_tenant_id, $item_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteItem'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $item_id Unique identifier for an Item (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteItemRequest($xero_tenant_id, $item_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deleteItem'
            );
        }
        // verify the required parameter 'item_id' is set
        if ($item_id === null || (is_array($item_id) && count($item_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $item_id when calling deleteItem'
            );
        }

        $resourcePath = '/Items/{ItemID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($item_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ItemID' . '}',
                ObjectSerializer::toPathValue($item_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteLinkedTransaction
     *
     * Deletes a specific linked transactions (billable expenses)
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $linked_transaction_id Unique identifier for a LinkedTransaction (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteLinkedTransaction($xero_tenant_id, $linked_transaction_id)
    {
        $this->deleteLinkedTransactionWithHttpInfo($xero_tenant_id, $linked_transaction_id);
    }

    /**
     * Operation deleteLinkedTransactionWithHttpInfo
     *
     * Deletes a specific linked transactions (billable expenses)
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $linked_transaction_id Unique identifier for a LinkedTransaction (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteLinkedTransactionWithHttpInfo($xero_tenant_id, $linked_transaction_id)
    {
        $request = $this->deleteLinkedTransactionRequest($xero_tenant_id, $linked_transaction_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteLinkedTransactionAsync
     *
     * Deletes a specific linked transactions (billable expenses)
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $linked_transaction_id Unique identifier for a LinkedTransaction (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteLinkedTransactionAsync($xero_tenant_id, $linked_transaction_id)
    {
        return $this->deleteLinkedTransactionAsyncWithHttpInfo($xero_tenant_id, $linked_transaction_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteLinkedTransactionAsyncWithHttpInfo
     *
     * Deletes a specific linked transactions (billable expenses)
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $linked_transaction_id Unique identifier for a LinkedTransaction (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteLinkedTransactionAsyncWithHttpInfo($xero_tenant_id, $linked_transaction_id)
    {
        $returnType = '';
        $request = $this->deleteLinkedTransactionRequest($xero_tenant_id, $linked_transaction_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteLinkedTransaction'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $linked_transaction_id Unique identifier for a LinkedTransaction (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteLinkedTransactionRequest($xero_tenant_id, $linked_transaction_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deleteLinkedTransaction'
            );
        }
        // verify the required parameter 'linked_transaction_id' is set
        if ($linked_transaction_id === null || (is_array($linked_transaction_id) && count($linked_transaction_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $linked_transaction_id when calling deleteLinkedTransaction'
            );
        }

        $resourcePath = '/LinkedTransactions/{LinkedTransactionID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($linked_transaction_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LinkedTransactionID' . '}',
                ObjectSerializer::toPathValue($linked_transaction_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deletePayment
     *
     * Updates a specific payment for invoices and credit notes
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payment_id Unique identifier for a Payment (required)
     * @param  \Xero2\Accounting\Model\PaymentDelete $payment_delete payment_delete (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Payments|\Xero2\Accounting\Model\Error
     */
    public function deletePayment($xero_tenant_id, $payment_id, $payment_delete)
    {
        list($response) = $this->deletePaymentWithHttpInfo($xero_tenant_id, $payment_id, $payment_delete);
        return $response;
    }

    /**
     * Operation deletePaymentWithHttpInfo
     *
     * Updates a specific payment for invoices and credit notes
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payment_id Unique identifier for a Payment (required)
     * @param  \Xero2\Accounting\Model\PaymentDelete $payment_delete (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Payments|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function deletePaymentWithHttpInfo($xero_tenant_id, $payment_id, $payment_delete)
    {
        $request = $this->deletePaymentRequest($xero_tenant_id, $payment_id, $payment_delete);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Payments' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Payments' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Payments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Payments';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Payments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deletePaymentAsync
     *
     * Updates a specific payment for invoices and credit notes
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payment_id Unique identifier for a Payment (required)
     * @param  \Xero2\Accounting\Model\PaymentDelete $payment_delete (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deletePaymentAsync($xero_tenant_id, $payment_id, $payment_delete)
    {
        return $this->deletePaymentAsyncWithHttpInfo($xero_tenant_id, $payment_id, $payment_delete)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deletePaymentAsyncWithHttpInfo
     *
     * Updates a specific payment for invoices and credit notes
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payment_id Unique identifier for a Payment (required)
     * @param  \Xero2\Accounting\Model\PaymentDelete $payment_delete (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deletePaymentAsyncWithHttpInfo($xero_tenant_id, $payment_id, $payment_delete)
    {
        $returnType = '\Xero2\Accounting\Model\Payments';
        $request = $this->deletePaymentRequest($xero_tenant_id, $payment_id, $payment_delete);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deletePayment'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payment_id Unique identifier for a Payment (required)
     * @param  \Xero2\Accounting\Model\PaymentDelete $payment_delete (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deletePaymentRequest($xero_tenant_id, $payment_id, $payment_delete)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deletePayment'
            );
        }
        // verify the required parameter 'payment_id' is set
        if ($payment_id === null || (is_array($payment_id) && count($payment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payment_id when calling deletePayment'
            );
        }
        // verify the required parameter 'payment_delete' is set
        if ($payment_delete === null || (is_array($payment_delete) && count($payment_delete) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payment_delete when calling deletePayment'
            );
        }

        $resourcePath = '/Payments/{PaymentID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($payment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PaymentID' . '}',
                ObjectSerializer::toPathValue($payment_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($payment_delete)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($payment_delete));
            } else {
                $httpBody = $payment_delete;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteTrackingCategory
     *
     * Deletes a specific tracking category
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\TrackingCategories|\Xero2\Accounting\Model\Error
     */
    public function deleteTrackingCategory($xero_tenant_id, $tracking_category_id)
    {
        list($response) = $this->deleteTrackingCategoryWithHttpInfo($xero_tenant_id, $tracking_category_id);
        return $response;
    }

    /**
     * Operation deleteTrackingCategoryWithHttpInfo
     *
     * Deletes a specific tracking category
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\TrackingCategories|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTrackingCategoryWithHttpInfo($xero_tenant_id, $tracking_category_id)
    {
        $request = $this->deleteTrackingCategoryRequest($xero_tenant_id, $tracking_category_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\TrackingCategories' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\TrackingCategories' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\TrackingCategories', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\TrackingCategories';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\TrackingCategories',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteTrackingCategoryAsync
     *
     * Deletes a specific tracking category
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteTrackingCategoryAsync($xero_tenant_id, $tracking_category_id)
    {
        return $this->deleteTrackingCategoryAsyncWithHttpInfo($xero_tenant_id, $tracking_category_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteTrackingCategoryAsyncWithHttpInfo
     *
     * Deletes a specific tracking category
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteTrackingCategoryAsyncWithHttpInfo($xero_tenant_id, $tracking_category_id)
    {
        $returnType = '\Xero2\Accounting\Model\TrackingCategories';
        $request = $this->deleteTrackingCategoryRequest($xero_tenant_id, $tracking_category_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteTrackingCategory'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteTrackingCategoryRequest($xero_tenant_id, $tracking_category_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deleteTrackingCategory'
            );
        }
        // verify the required parameter 'tracking_category_id' is set
        if ($tracking_category_id === null || (is_array($tracking_category_id) && count($tracking_category_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $tracking_category_id when calling deleteTrackingCategory'
            );
        }

        $resourcePath = '/TrackingCategories/{TrackingCategoryID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($tracking_category_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TrackingCategoryID' . '}',
                ObjectSerializer::toPathValue($tracking_category_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteTrackingOptions
     *
     * Deletes a specific option for a specific tracking category
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     * @param  string $tracking_option_id Unique identifier for a Tracking Option (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\TrackingOptions|\Xero2\Accounting\Model\Error
     */
    public function deleteTrackingOptions($xero_tenant_id, $tracking_category_id, $tracking_option_id)
    {
        list($response) = $this->deleteTrackingOptionsWithHttpInfo($xero_tenant_id, $tracking_category_id, $tracking_option_id);
        return $response;
    }

    /**
     * Operation deleteTrackingOptionsWithHttpInfo
     *
     * Deletes a specific option for a specific tracking category
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     * @param  string $tracking_option_id Unique identifier for a Tracking Option (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\TrackingOptions|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTrackingOptionsWithHttpInfo($xero_tenant_id, $tracking_category_id, $tracking_option_id)
    {
        $request = $this->deleteTrackingOptionsRequest($xero_tenant_id, $tracking_category_id, $tracking_option_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\TrackingOptions' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\TrackingOptions' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\TrackingOptions', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Error' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\TrackingOptions';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\TrackingOptions',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteTrackingOptionsAsync
     *
     * Deletes a specific option for a specific tracking category
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     * @param  string $tracking_option_id Unique identifier for a Tracking Option (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteTrackingOptionsAsync($xero_tenant_id, $tracking_category_id, $tracking_option_id)
    {
        return $this->deleteTrackingOptionsAsyncWithHttpInfo($xero_tenant_id, $tracking_category_id, $tracking_option_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteTrackingOptionsAsyncWithHttpInfo
     *
     * Deletes a specific option for a specific tracking category
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     * @param  string $tracking_option_id Unique identifier for a Tracking Option (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteTrackingOptionsAsyncWithHttpInfo($xero_tenant_id, $tracking_category_id, $tracking_option_id)
    {
        $returnType = '\Xero2\Accounting\Model\TrackingOptions';
        $request = $this->deleteTrackingOptionsRequest($xero_tenant_id, $tracking_category_id, $tracking_option_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteTrackingOptions'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     * @param  string $tracking_option_id Unique identifier for a Tracking Option (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteTrackingOptionsRequest($xero_tenant_id, $tracking_category_id, $tracking_option_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deleteTrackingOptions'
            );
        }
        // verify the required parameter 'tracking_category_id' is set
        if ($tracking_category_id === null || (is_array($tracking_category_id) && count($tracking_category_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $tracking_category_id when calling deleteTrackingOptions'
            );
        }
        // verify the required parameter 'tracking_option_id' is set
        if ($tracking_option_id === null || (is_array($tracking_option_id) && count($tracking_option_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $tracking_option_id when calling deleteTrackingOptions'
            );
        }

        $resourcePath = '/TrackingCategories/{TrackingCategoryID}/Options/{TrackingOptionID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($tracking_category_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TrackingCategoryID' . '}',
                ObjectSerializer::toPathValue($tracking_category_id),
                $resourcePath
            );
        }
        // path params
        if ($tracking_option_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TrackingOptionID' . '}',
                ObjectSerializer::toPathValue($tracking_option_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation emailInvoice
     *
     * Sends a copy of a specific invoice to related contact via email
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  \Xero2\Accounting\Model\RequestEmpty $request_empty request_empty (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function emailInvoice($xero_tenant_id, $invoice_id, $request_empty)
    {
        $this->emailInvoiceWithHttpInfo($xero_tenant_id, $invoice_id, $request_empty);
    }

    /**
     * Operation emailInvoiceWithHttpInfo
     *
     * Sends a copy of a specific invoice to related contact via email
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  \Xero2\Accounting\Model\RequestEmpty $request_empty (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function emailInvoiceWithHttpInfo($xero_tenant_id, $invoice_id, $request_empty)
    {
        $request = $this->emailInvoiceRequest($xero_tenant_id, $invoice_id, $request_empty);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation emailInvoiceAsync
     *
     * Sends a copy of a specific invoice to related contact via email
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  \Xero2\Accounting\Model\RequestEmpty $request_empty (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function emailInvoiceAsync($xero_tenant_id, $invoice_id, $request_empty)
    {
        return $this->emailInvoiceAsyncWithHttpInfo($xero_tenant_id, $invoice_id, $request_empty)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation emailInvoiceAsyncWithHttpInfo
     *
     * Sends a copy of a specific invoice to related contact via email
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  \Xero2\Accounting\Model\RequestEmpty $request_empty (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function emailInvoiceAsyncWithHttpInfo($xero_tenant_id, $invoice_id, $request_empty)
    {
        $returnType = '';
        $request = $this->emailInvoiceRequest($xero_tenant_id, $invoice_id, $request_empty);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'emailInvoice'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  \Xero2\Accounting\Model\RequestEmpty $request_empty (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function emailInvoiceRequest($xero_tenant_id, $invoice_id, $request_empty)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling emailInvoice'
            );
        }
        // verify the required parameter 'invoice_id' is set
        if ($invoice_id === null || (is_array($invoice_id) && count($invoice_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $invoice_id when calling emailInvoice'
            );
        }
        // verify the required parameter 'request_empty' is set
        if ($request_empty === null || (is_array($request_empty) && count($request_empty) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $request_empty when calling emailInvoice'
            );
        }

        $resourcePath = '/Invoices/{InvoiceID}/Email';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($invoice_id !== null) {
            $resourcePath = str_replace(
                '{' . 'InvoiceID' . '}',
                ObjectSerializer::toPathValue($invoice_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($request_empty)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($request_empty));
            } else {
                $httpBody = $request_empty;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAccount
     *
     * Retrieves a single chart of accounts by using a unique account Id
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for retrieving single object (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Accounts
     */
    public function getAccount($xero_tenant_id, $account_id)
    {
        list($response) = $this->getAccountWithHttpInfo($xero_tenant_id, $account_id);
        return $response;
    }

    /**
     * Operation getAccountWithHttpInfo
     *
     * Retrieves a single chart of accounts by using a unique account Id
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for retrieving single object (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Accounts, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAccountWithHttpInfo($xero_tenant_id, $account_id)
    {
        $request = $this->getAccountRequest($xero_tenant_id, $account_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Accounts' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Accounts' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Accounts', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Accounts';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Accounts',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAccountAsync
     *
     * Retrieves a single chart of accounts by using a unique account Id
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for retrieving single object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAccountAsync($xero_tenant_id, $account_id)
    {
        return $this->getAccountAsyncWithHttpInfo($xero_tenant_id, $account_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAccountAsyncWithHttpInfo
     *
     * Retrieves a single chart of accounts by using a unique account Id
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for retrieving single object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAccountAsyncWithHttpInfo($xero_tenant_id, $account_id)
    {
        $returnType = '\Xero2\Accounting\Model\Accounts';
        $request = $this->getAccountRequest($xero_tenant_id, $account_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAccount'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for retrieving single object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAccountRequest($xero_tenant_id, $account_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getAccount'
            );
        }
        // verify the required parameter 'account_id' is set
        if ($account_id === null || (is_array($account_id) && count($account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $account_id when calling getAccount'
            );
        }

        $resourcePath = '/Accounts/{AccountID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                '{' . 'AccountID' . '}',
                ObjectSerializer::toPathValue($account_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAccountAttachmentByFileName
     *
     * Retrieves an attachment for a specific account by filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SplFileObject
     */
    public function getAccountAttachmentByFileName($xero_tenant_id, $account_id, $file_name, $content_type)
    {
        list($response) = $this->getAccountAttachmentByFileNameWithHttpInfo($xero_tenant_id, $account_id, $file_name, $content_type);
        return $response;
    }

    /**
     * Operation getAccountAttachmentByFileNameWithHttpInfo
     *
     * Retrieves an attachment for a specific account by filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAccountAttachmentByFileNameWithHttpInfo($xero_tenant_id, $account_id, $file_name, $content_type)
    {
        $request = $this->getAccountAttachmentByFileNameRequest($xero_tenant_id, $account_id, $file_name, $content_type);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\SplFileObject' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SplFileObject' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SplFileObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SplFileObject';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SplFileObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAccountAttachmentByFileNameAsync
     *
     * Retrieves an attachment for a specific account by filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAccountAttachmentByFileNameAsync($xero_tenant_id, $account_id, $file_name, $content_type)
    {
        return $this->getAccountAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $account_id, $file_name, $content_type)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAccountAttachmentByFileNameAsyncWithHttpInfo
     *
     * Retrieves an attachment for a specific account by filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAccountAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $account_id, $file_name, $content_type)
    {
        $returnType = '\SplFileObject';
        $request = $this->getAccountAttachmentByFileNameRequest($xero_tenant_id, $account_id, $file_name, $content_type);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAccountAttachmentByFileName'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAccountAttachmentByFileNameRequest($xero_tenant_id, $account_id, $file_name, $content_type)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getAccountAttachmentByFileName'
            );
        }
        // verify the required parameter 'account_id' is set
        if ($account_id === null || (is_array($account_id) && count($account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $account_id when calling getAccountAttachmentByFileName'
            );
        }
        // verify the required parameter 'file_name' is set
        if ($file_name === null || (is_array($file_name) && count($file_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_name when calling getAccountAttachmentByFileName'
            );
        }
        // verify the required parameter 'content_type' is set
        if ($content_type === null || (is_array($content_type) && count($content_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $content_type when calling getAccountAttachmentByFileName'
            );
        }

        $resourcePath = '/Accounts/{AccountID}/Attachments/{FileName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($content_type !== null) {
            $headerParams['contentType'] = ObjectSerializer::toHeaderValue($content_type);
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                '{' . 'AccountID' . '}',
                ObjectSerializer::toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($file_name !== null) {
            $resourcePath = str_replace(
                '{' . 'FileName' . '}',
                ObjectSerializer::toPathValue($file_name),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/octet-stream']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/octet-stream'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAccountAttachmentById
     *
     * Retrieves a specific attachment from a specific account using a unique attachment Id
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $attachment_id Unique identifier for Attachment object (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SplFileObject
     */
    public function getAccountAttachmentById($xero_tenant_id, $account_id, $attachment_id, $content_type)
    {
        list($response) = $this->getAccountAttachmentByIdWithHttpInfo($xero_tenant_id, $account_id, $attachment_id, $content_type);
        return $response;
    }

    /**
     * Operation getAccountAttachmentByIdWithHttpInfo
     *
     * Retrieves a specific attachment from a specific account using a unique attachment Id
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $attachment_id Unique identifier for Attachment object (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAccountAttachmentByIdWithHttpInfo($xero_tenant_id, $account_id, $attachment_id, $content_type)
    {
        $request = $this->getAccountAttachmentByIdRequest($xero_tenant_id, $account_id, $attachment_id, $content_type);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\SplFileObject' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SplFileObject' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SplFileObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SplFileObject';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SplFileObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAccountAttachmentByIdAsync
     *
     * Retrieves a specific attachment from a specific account using a unique attachment Id
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $attachment_id Unique identifier for Attachment object (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAccountAttachmentByIdAsync($xero_tenant_id, $account_id, $attachment_id, $content_type)
    {
        return $this->getAccountAttachmentByIdAsyncWithHttpInfo($xero_tenant_id, $account_id, $attachment_id, $content_type)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAccountAttachmentByIdAsyncWithHttpInfo
     *
     * Retrieves a specific attachment from a specific account using a unique attachment Id
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $attachment_id Unique identifier for Attachment object (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAccountAttachmentByIdAsyncWithHttpInfo($xero_tenant_id, $account_id, $attachment_id, $content_type)
    {
        $returnType = '\SplFileObject';
        $request = $this->getAccountAttachmentByIdRequest($xero_tenant_id, $account_id, $attachment_id, $content_type);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAccountAttachmentById'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $attachment_id Unique identifier for Attachment object (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAccountAttachmentByIdRequest($xero_tenant_id, $account_id, $attachment_id, $content_type)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getAccountAttachmentById'
            );
        }
        // verify the required parameter 'account_id' is set
        if ($account_id === null || (is_array($account_id) && count($account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $account_id when calling getAccountAttachmentById'
            );
        }
        // verify the required parameter 'attachment_id' is set
        if ($attachment_id === null || (is_array($attachment_id) && count($attachment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $attachment_id when calling getAccountAttachmentById'
            );
        }
        // verify the required parameter 'content_type' is set
        if ($content_type === null || (is_array($content_type) && count($content_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $content_type when calling getAccountAttachmentById'
            );
        }

        $resourcePath = '/Accounts/{AccountID}/Attachments/{AttachmentID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($content_type !== null) {
            $headerParams['contentType'] = ObjectSerializer::toHeaderValue($content_type);
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                '{' . 'AccountID' . '}',
                ObjectSerializer::toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($attachment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'AttachmentID' . '}',
                ObjectSerializer::toPathValue($attachment_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/octet-stream']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/octet-stream'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAccountAttachments
     *
     * Retrieves attachments for a specific accounts by using a unique account Id
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Attachments
     */
    public function getAccountAttachments($xero_tenant_id, $account_id)
    {
        list($response) = $this->getAccountAttachmentsWithHttpInfo($xero_tenant_id, $account_id);
        return $response;
    }

    /**
     * Operation getAccountAttachmentsWithHttpInfo
     *
     * Retrieves attachments for a specific accounts by using a unique account Id
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Attachments, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAccountAttachmentsWithHttpInfo($xero_tenant_id, $account_id)
    {
        $request = $this->getAccountAttachmentsRequest($xero_tenant_id, $account_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Attachments' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Attachments' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Attachments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Attachments';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Attachments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAccountAttachmentsAsync
     *
     * Retrieves attachments for a specific accounts by using a unique account Id
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAccountAttachmentsAsync($xero_tenant_id, $account_id)
    {
        return $this->getAccountAttachmentsAsyncWithHttpInfo($xero_tenant_id, $account_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAccountAttachmentsAsyncWithHttpInfo
     *
     * Retrieves attachments for a specific accounts by using a unique account Id
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAccountAttachmentsAsyncWithHttpInfo($xero_tenant_id, $account_id)
    {
        $returnType = '\Xero2\Accounting\Model\Attachments';
        $request = $this->getAccountAttachmentsRequest($xero_tenant_id, $account_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAccountAttachments'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAccountAttachmentsRequest($xero_tenant_id, $account_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getAccountAttachments'
            );
        }
        // verify the required parameter 'account_id' is set
        if ($account_id === null || (is_array($account_id) && count($account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $account_id when calling getAccountAttachments'
            );
        }

        $resourcePath = '/Accounts/{AccountID}/Attachments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                '{' . 'AccountID' . '}',
                ObjectSerializer::toPathValue($account_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAccounts
     *
     * Retrieves the full chart of accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \DateTime $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Accounts
     */
    public function getAccounts($xero_tenant_id, $if_modified_since = null, $where = null, $order = null)
    {
        list($response) = $this->getAccountsWithHttpInfo($xero_tenant_id, $if_modified_since, $where, $order);
        return $response;
    }

    /**
     * Operation getAccountsWithHttpInfo
     *
     * Retrieves the full chart of accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \DateTime $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Accounts, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAccountsWithHttpInfo($xero_tenant_id, $if_modified_since = null, $where = null, $order = null)
    {
        $request = $this->getAccountsRequest($xero_tenant_id, $if_modified_since, $where, $order);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Accounts' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Accounts' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Accounts', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Accounts';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Accounts',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAccountsAsync
     *
     * Retrieves the full chart of accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \DateTime $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAccountsAsync($xero_tenant_id, $if_modified_since = null, $where = null, $order = null)
    {
        return $this->getAccountsAsyncWithHttpInfo($xero_tenant_id, $if_modified_since, $where, $order)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAccountsAsyncWithHttpInfo
     *
     * Retrieves the full chart of accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \DateTime $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAccountsAsyncWithHttpInfo($xero_tenant_id, $if_modified_since = null, $where = null, $order = null)
    {
        $returnType = '\Xero2\Accounting\Model\Accounts';
        $request = $this->getAccountsRequest($xero_tenant_id, $if_modified_since, $where, $order);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAccounts'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \DateTime $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAccountsRequest($xero_tenant_id, $if_modified_since = null, $where = null, $order = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getAccounts'
            );
        }

        $resourcePath = '/Accounts';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $where,
            'where', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order,
            'order', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($if_modified_since !== null) {
            $headerParams['If-Modified-Since'] = ObjectSerializer::toHeaderValue($if_modified_since);
        }



        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBankTransaction
     *
     * Retrieves a single spent or received money transaction by using a unique bank transaction Id
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\BankTransactions
     */
    public function getBankTransaction($xero_tenant_id, $bank_transaction_id, $unitdp = null)
    {
        list($response) = $this->getBankTransactionWithHttpInfo($xero_tenant_id, $bank_transaction_id, $unitdp);
        return $response;
    }

    /**
     * Operation getBankTransactionWithHttpInfo
     *
     * Retrieves a single spent or received money transaction by using a unique bank transaction Id
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\BankTransactions, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBankTransactionWithHttpInfo($xero_tenant_id, $bank_transaction_id, $unitdp = null)
    {
        $request = $this->getBankTransactionRequest($xero_tenant_id, $bank_transaction_id, $unitdp);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\BankTransactions' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\BankTransactions' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\BankTransactions', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\BankTransactions';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\BankTransactions',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getBankTransactionAsync
     *
     * Retrieves a single spent or received money transaction by using a unique bank transaction Id
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankTransactionAsync($xero_tenant_id, $bank_transaction_id, $unitdp = null)
    {
        return $this->getBankTransactionAsyncWithHttpInfo($xero_tenant_id, $bank_transaction_id, $unitdp)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getBankTransactionAsyncWithHttpInfo
     *
     * Retrieves a single spent or received money transaction by using a unique bank transaction Id
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankTransactionAsyncWithHttpInfo($xero_tenant_id, $bank_transaction_id, $unitdp = null)
    {
        $returnType = '\Xero2\Accounting\Model\BankTransactions';
        $request = $this->getBankTransactionRequest($xero_tenant_id, $bank_transaction_id, $unitdp);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBankTransaction'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getBankTransactionRequest($xero_tenant_id, $bank_transaction_id, $unitdp = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getBankTransaction'
            );
        }
        // verify the required parameter 'bank_transaction_id' is set
        if ($bank_transaction_id === null || (is_array($bank_transaction_id) && count($bank_transaction_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bank_transaction_id when calling getBankTransaction'
            );
        }

        $resourcePath = '/BankTransactions/{BankTransactionID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $unitdp,
            'unitdp', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($bank_transaction_id !== null) {
            $resourcePath = str_replace(
                '{' . 'BankTransactionID' . '}',
                ObjectSerializer::toPathValue($bank_transaction_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBankTransactionAttachmentByFileName
     *
     * Retrieves a specific attachment from a specific bank transaction by filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $file_name The name of the file being attached (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SplFileObject
     */
    public function getBankTransactionAttachmentByFileName($xero_tenant_id, $bank_transaction_id, $file_name, $content_type)
    {
        list($response) = $this->getBankTransactionAttachmentByFileNameWithHttpInfo($xero_tenant_id, $bank_transaction_id, $file_name, $content_type);
        return $response;
    }

    /**
     * Operation getBankTransactionAttachmentByFileNameWithHttpInfo
     *
     * Retrieves a specific attachment from a specific bank transaction by filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $file_name The name of the file being attached (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBankTransactionAttachmentByFileNameWithHttpInfo($xero_tenant_id, $bank_transaction_id, $file_name, $content_type)
    {
        $request = $this->getBankTransactionAttachmentByFileNameRequest($xero_tenant_id, $bank_transaction_id, $file_name, $content_type);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\SplFileObject' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SplFileObject' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SplFileObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SplFileObject';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SplFileObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getBankTransactionAttachmentByFileNameAsync
     *
     * Retrieves a specific attachment from a specific bank transaction by filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $file_name The name of the file being attached (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankTransactionAttachmentByFileNameAsync($xero_tenant_id, $bank_transaction_id, $file_name, $content_type)
    {
        return $this->getBankTransactionAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $bank_transaction_id, $file_name, $content_type)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getBankTransactionAttachmentByFileNameAsyncWithHttpInfo
     *
     * Retrieves a specific attachment from a specific bank transaction by filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $file_name The name of the file being attached (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankTransactionAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $bank_transaction_id, $file_name, $content_type)
    {
        $returnType = '\SplFileObject';
        $request = $this->getBankTransactionAttachmentByFileNameRequest($xero_tenant_id, $bank_transaction_id, $file_name, $content_type);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBankTransactionAttachmentByFileName'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $file_name The name of the file being attached (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getBankTransactionAttachmentByFileNameRequest($xero_tenant_id, $bank_transaction_id, $file_name, $content_type)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getBankTransactionAttachmentByFileName'
            );
        }
        // verify the required parameter 'bank_transaction_id' is set
        if ($bank_transaction_id === null || (is_array($bank_transaction_id) && count($bank_transaction_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bank_transaction_id when calling getBankTransactionAttachmentByFileName'
            );
        }
        // verify the required parameter 'file_name' is set
        if ($file_name === null || (is_array($file_name) && count($file_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_name when calling getBankTransactionAttachmentByFileName'
            );
        }
        // verify the required parameter 'content_type' is set
        if ($content_type === null || (is_array($content_type) && count($content_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $content_type when calling getBankTransactionAttachmentByFileName'
            );
        }

        $resourcePath = '/BankTransactions/{BankTransactionID}/Attachments/{FileName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($content_type !== null) {
            $headerParams['contentType'] = ObjectSerializer::toHeaderValue($content_type);
        }

        // path params
        if ($bank_transaction_id !== null) {
            $resourcePath = str_replace(
                '{' . 'BankTransactionID' . '}',
                ObjectSerializer::toPathValue($bank_transaction_id),
                $resourcePath
            );
        }
        // path params
        if ($file_name !== null) {
            $resourcePath = str_replace(
                '{' . 'FileName' . '}',
                ObjectSerializer::toPathValue($file_name),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/octet-stream']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/octet-stream'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBankTransactionAttachmentById
     *
     * Retrieves specific attachments from a specific BankTransaction using a unique attachment Id
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $attachment_id Xero generated unique identifier for an attachment (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SplFileObject
     */
    public function getBankTransactionAttachmentById($xero_tenant_id, $bank_transaction_id, $attachment_id, $content_type)
    {
        list($response) = $this->getBankTransactionAttachmentByIdWithHttpInfo($xero_tenant_id, $bank_transaction_id, $attachment_id, $content_type);
        return $response;
    }

    /**
     * Operation getBankTransactionAttachmentByIdWithHttpInfo
     *
     * Retrieves specific attachments from a specific BankTransaction using a unique attachment Id
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $attachment_id Xero generated unique identifier for an attachment (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBankTransactionAttachmentByIdWithHttpInfo($xero_tenant_id, $bank_transaction_id, $attachment_id, $content_type)
    {
        $request = $this->getBankTransactionAttachmentByIdRequest($xero_tenant_id, $bank_transaction_id, $attachment_id, $content_type);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\SplFileObject' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SplFileObject' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SplFileObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SplFileObject';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SplFileObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getBankTransactionAttachmentByIdAsync
     *
     * Retrieves specific attachments from a specific BankTransaction using a unique attachment Id
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $attachment_id Xero generated unique identifier for an attachment (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankTransactionAttachmentByIdAsync($xero_tenant_id, $bank_transaction_id, $attachment_id, $content_type)
    {
        return $this->getBankTransactionAttachmentByIdAsyncWithHttpInfo($xero_tenant_id, $bank_transaction_id, $attachment_id, $content_type)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getBankTransactionAttachmentByIdAsyncWithHttpInfo
     *
     * Retrieves specific attachments from a specific BankTransaction using a unique attachment Id
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $attachment_id Xero generated unique identifier for an attachment (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankTransactionAttachmentByIdAsyncWithHttpInfo($xero_tenant_id, $bank_transaction_id, $attachment_id, $content_type)
    {
        $returnType = '\SplFileObject';
        $request = $this->getBankTransactionAttachmentByIdRequest($xero_tenant_id, $bank_transaction_id, $attachment_id, $content_type);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBankTransactionAttachmentById'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $attachment_id Xero generated unique identifier for an attachment (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getBankTransactionAttachmentByIdRequest($xero_tenant_id, $bank_transaction_id, $attachment_id, $content_type)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getBankTransactionAttachmentById'
            );
        }
        // verify the required parameter 'bank_transaction_id' is set
        if ($bank_transaction_id === null || (is_array($bank_transaction_id) && count($bank_transaction_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bank_transaction_id when calling getBankTransactionAttachmentById'
            );
        }
        // verify the required parameter 'attachment_id' is set
        if ($attachment_id === null || (is_array($attachment_id) && count($attachment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $attachment_id when calling getBankTransactionAttachmentById'
            );
        }
        // verify the required parameter 'content_type' is set
        if ($content_type === null || (is_array($content_type) && count($content_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $content_type when calling getBankTransactionAttachmentById'
            );
        }

        $resourcePath = '/BankTransactions/{BankTransactionID}/Attachments/{AttachmentID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($content_type !== null) {
            $headerParams['contentType'] = ObjectSerializer::toHeaderValue($content_type);
        }

        // path params
        if ($bank_transaction_id !== null) {
            $resourcePath = str_replace(
                '{' . 'BankTransactionID' . '}',
                ObjectSerializer::toPathValue($bank_transaction_id),
                $resourcePath
            );
        }
        // path params
        if ($attachment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'AttachmentID' . '}',
                ObjectSerializer::toPathValue($attachment_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/octet-stream']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/octet-stream'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBankTransactionAttachments
     *
     * Retrieves any attachments from a specific bank transactions
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Attachments
     */
    public function getBankTransactionAttachments($xero_tenant_id, $bank_transaction_id)
    {
        list($response) = $this->getBankTransactionAttachmentsWithHttpInfo($xero_tenant_id, $bank_transaction_id);
        return $response;
    }

    /**
     * Operation getBankTransactionAttachmentsWithHttpInfo
     *
     * Retrieves any attachments from a specific bank transactions
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Attachments, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBankTransactionAttachmentsWithHttpInfo($xero_tenant_id, $bank_transaction_id)
    {
        $request = $this->getBankTransactionAttachmentsRequest($xero_tenant_id, $bank_transaction_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Attachments' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\Attachments' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Attachments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Attachments';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Attachments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getBankTransactionAttachmentsAsync
     *
     * Retrieves any attachments from a specific bank transactions
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankTransactionAttachmentsAsync($xero_tenant_id, $bank_transaction_id)
    {
        return $this->getBankTransactionAttachmentsAsyncWithHttpInfo($xero_tenant_id, $bank_transaction_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getBankTransactionAttachmentsAsyncWithHttpInfo
     *
     * Retrieves any attachments from a specific bank transactions
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankTransactionAttachmentsAsyncWithHttpInfo($xero_tenant_id, $bank_transaction_id)
    {
        $returnType = '\Xero2\Accounting\Model\Attachments';
        $request = $this->getBankTransactionAttachmentsRequest($xero_tenant_id, $bank_transaction_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBankTransactionAttachments'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getBankTransactionAttachmentsRequest($xero_tenant_id, $bank_transaction_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getBankTransactionAttachments'
            );
        }
        // verify the required parameter 'bank_transaction_id' is set
        if ($bank_transaction_id === null || (is_array($bank_transaction_id) && count($bank_transaction_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bank_transaction_id when calling getBankTransactionAttachments'
            );
        }

        $resourcePath = '/BankTransactions/{BankTransactionID}/Attachments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($bank_transaction_id !== null) {
            $resourcePath = str_replace(
                '{' . 'BankTransactionID' . '}',
                ObjectSerializer::toPathValue($bank_transaction_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBankTransactions
     *
     * Retrieves any spent or received money transactions
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \DateTime $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page Up to 100 bank transactions will be returned in a single API call with line items details (optional)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\BankTransactions
     */
    public function getBankTransactions($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null, $unitdp = null)
    {
        list($response) = $this->getBankTransactionsWithHttpInfo($xero_tenant_id, $if_modified_since, $where, $order, $page, $unitdp);
        return $response;
    }

    /**
     * Operation getBankTransactionsWithHttpInfo
     *
     * Retrieves any spent or received money transactions
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \DateTime $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page Up to 100 bank transactions will be returned in a single API call with line items details (optional)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\BankTransactions, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBankTransactionsWithHttpInfo($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null, $unitdp = null)
    {
        $request = $this->getBankTransactionsRequest($xero_tenant_id, $if_modified_since, $where, $order, $page, $unitdp);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\BankTransactions' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Xero2\Accounting\Model\BankTransactions' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\BankTransactions', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\BankTransactions';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\BankTransactions',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getBankTransactionsAsync
     *
     * Retrieves any spent or received money transactions
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \DateTime $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page Up to 100 bank transactions will be returned in a single API call with line items details (optional)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankTransactionsAsync($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null, $unitdp = null)
    {
        return $this->getBankTransactionsAsyncWithHttpInfo($xero_tenant_id, $if_modified_since, $where, $order, $page, $unitdp)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getBankTransactionsAsyncWithHttpInfo
     *
     * Retrieves any spent or received money transactions
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \DateTime $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page Up to 100 bank transactions will be returned in a single API call with line items details (optional)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankTransactionsAsyncWithHttpInfo($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null, $unitdp = null)
    {
        $returnType = '\Xero2\Accounting\Model\BankTransactions';
        $request = $this->getBankTransactionsRequest($xero_tenant_id, $if_modified_since, $where, $order, $page, $unitdp);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBankTransactions'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \DateTime $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page Up to 100 bank transactions will be returned in a single API call with line items details (optional)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – (Unit Decimal Places) You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getBankTransactionsRequest($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null, $unitdp = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getBankTransactions'
            );
        }

        $resourcePath = '/BankTransactions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $where,
            'where', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order,
            'order', // param base name
            '