# OpenAPIClient-php

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

For more information, please visit [https://developer.xero.com](https://developer.xero.com).

## Installation & Usage

### Requirements

PHP 7.4 and later.
Should also work with PHP 8.0.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/xero2.git"
    }
  ],
  "require": {
    "talisman/xero2": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure OAuth2 access token for authorization: OAuth2
$config = Xero2\Accounting\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Xero2\Accounting\Api\AccountingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$xero_tenant_id = YOUR_XERO_TENANT_ID; // string | Xero identifier for Tenant
$account = { "Code":"123456", "Name":"Foobar", "Type":"EXPENSE", "Description":"Hello World" }; // \Xero2\Accounting\Model\Account | Account object in body of request

try {
    $result = $apiInstance->createAccount($xero_tenant_id, $account);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AccountingApi->createAccount: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://api.xero.com/api.xro/2.0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountingApi* | [**createAccount**](docs/Api/AccountingApi.md#createaccount) | **PUT** /Accounts | Creates a new chart of accounts
*AccountingApi* | [**createAccountAttachmentByFileName**](docs/Api/AccountingApi.md#createaccountattachmentbyfilename) | **PUT** /Accounts/{AccountID}/Attachments/{FileName} | Creates an attachment on a specific account
*AccountingApi* | [**createBankTransactionAttachmentByFileName**](docs/Api/AccountingApi.md#createbanktransactionattachmentbyfilename) | **PUT** /BankTransactions/{BankTransactionID}/Attachments/{FileName} | Creates an attachment for a specific bank transaction by filename
*AccountingApi* | [**createBankTransactionHistoryRecord**](docs/Api/AccountingApi.md#createbanktransactionhistoryrecord) | **PUT** /BankTransactions/{BankTransactionID}/History | Creates a history record for a specific bank transactions
*AccountingApi* | [**createBankTransactions**](docs/Api/AccountingApi.md#createbanktransactions) | **PUT** /BankTransactions | Creates one or more spent or received money transaction
*AccountingApi* | [**createBankTransfer**](docs/Api/AccountingApi.md#createbanktransfer) | **PUT** /BankTransfers | Creates a bank transfer
*AccountingApi* | [**createBankTransferAttachmentByFileName**](docs/Api/AccountingApi.md#createbanktransferattachmentbyfilename) | **PUT** /BankTransfers/{BankTransferID}/Attachments/{FileName} | 
*AccountingApi* | [**createBankTransferHistoryRecord**](docs/Api/AccountingApi.md#createbanktransferhistoryrecord) | **PUT** /BankTransfers/{BankTransferID}/History | Creates a history record for a specific bank transfer
*AccountingApi* | [**createBatchPayment**](docs/Api/AccountingApi.md#createbatchpayment) | **PUT** /BatchPayments | Creates one or many batch payments for invoices
*AccountingApi* | [**createBatchPaymentHistoryRecord**](docs/Api/AccountingApi.md#createbatchpaymenthistoryrecord) | **PUT** /BatchPayments/{BatchPaymentID}/History | Creates a history record for a specific batch payment
*AccountingApi* | [**createBrandingThemePaymentServices**](docs/Api/AccountingApi.md#createbrandingthemepaymentservices) | **POST** /BrandingThemes/{BrandingThemeID}/PaymentServices | Creates a new custom payment service for a specific branding theme
*AccountingApi* | [**createContactAttachmentByFileName**](docs/Api/AccountingApi.md#createcontactattachmentbyfilename) | **PUT** /Contacts/{ContactID}/Attachments/{FileName} | 
*AccountingApi* | [**createContactGroup**](docs/Api/AccountingApi.md#createcontactgroup) | **PUT** /ContactGroups | Creates a contact group
*AccountingApi* | [**createContactGroupContacts**](docs/Api/AccountingApi.md#createcontactgroupcontacts) | **PUT** /ContactGroups/{ContactGroupID}/Contacts | Creates contacts to a specific contact group
*AccountingApi* | [**createContactHistory**](docs/Api/AccountingApi.md#createcontacthistory) | **PUT** /Contacts/{ContactID}/History | Creates a new history record for a specific contact
*AccountingApi* | [**createContacts**](docs/Api/AccountingApi.md#createcontacts) | **PUT** /Contacts | Creates multiple contacts (bulk) in a Xero organisation
*AccountingApi* | [**createCreditNoteAllocation**](docs/Api/AccountingApi.md#createcreditnoteallocation) | **PUT** /CreditNotes/{CreditNoteID}/Allocations | Creates allocation for a specific credit note
*AccountingApi* | [**createCreditNoteAttachmentByFileName**](docs/Api/AccountingApi.md#createcreditnoteattachmentbyfilename) | **PUT** /CreditNotes/{CreditNoteID}/Attachments/{FileName} | Creates an attachment for a specific credit note
*AccountingApi* | [**createCreditNoteHistory**](docs/Api/AccountingApi.md#createcreditnotehistory) | **PUT** /CreditNotes/{CreditNoteID}/History | Retrieves history records of a specific credit note
*AccountingApi* | [**createCreditNotes**](docs/Api/AccountingApi.md#createcreditnotes) | **PUT** /CreditNotes | Creates a new credit note
*AccountingApi* | [**createCurrency**](docs/Api/AccountingApi.md#createcurrency) | **PUT** /Currencies | Create a new currency for a Xero organisation
*AccountingApi* | [**createEmployees**](docs/Api/AccountingApi.md#createemployees) | **PUT** /Employees | Creates new employees used in Xero payrun
*AccountingApi* | [**createExpenseClaimHistory**](docs/Api/AccountingApi.md#createexpenseclaimhistory) | **PUT** /ExpenseClaims/{ExpenseClaimID}/History | Creates a history record for a specific expense claim
*AccountingApi* | [**createExpenseClaims**](docs/Api/AccountingApi.md#createexpenseclaims) | **PUT** /ExpenseClaims | Creates expense claims
*AccountingApi* | [**createInvoiceAttachmentByFileName**](docs/Api/AccountingApi.md#createinvoiceattachmentbyfilename) | **PUT** /Invoices/{InvoiceID}/Attachments/{FileName} | Creates an attachment for a specific invoice or purchase bill by filename
*AccountingApi* | [**createInvoiceHistory**](docs/Api/AccountingApi.md#createinvoicehistory) | **PUT** /Invoices/{InvoiceID}/History | Creates a history record for a specific invoice
*AccountingApi* | [**createInvoices**](docs/Api/AccountingApi.md#createinvoices) | **PUT** /Invoices | Creates one or more sales invoices or purchase bills
*AccountingApi* | [**createItemHistory**](docs/Api/AccountingApi.md#createitemhistory) | **PUT** /Items/{ItemID}/History | Creates a history record for a specific item
*AccountingApi* | [**createItems**](docs/Api/AccountingApi.md#createitems) | **PUT** /Items | Creates one or more items
*AccountingApi* | [**createLinkedTransaction**](docs/Api/AccountingApi.md#createlinkedtransaction) | **PUT** /LinkedTransactions | Creates linked transactions (billable expenses)
*AccountingApi* | [**createManualJournalAttachmentByFileName**](docs/Api/AccountingApi.md#createmanualjournalattachmentbyfilename) | **PUT** /ManualJournals/{ManualJournalID}/Attachments/{FileName} | Creates a specific attachment for a specific manual journal by file name
*AccountingApi* | [**createManualJournalHistoryRecord**](docs/Api/AccountingApi.md#createmanualjournalhistoryrecord) | **PUT** /ManualJournals/{ManualJournalID}/History | Creates a history record for a specific manual journal
*AccountingApi* | [**createManualJournals**](docs/Api/AccountingApi.md#createmanualjournals) | **PUT** /ManualJournals | Creates one or more manual journals
*AccountingApi* | [**createOverpaymentAllocations**](docs/Api/AccountingApi.md#createoverpaymentallocations) | **PUT** /Overpayments/{OverpaymentID}/Allocations | Creates a single allocation for a specific overpayment
*AccountingApi* | [**createOverpaymentHistory**](docs/Api/AccountingApi.md#createoverpaymenthistory) | **PUT** /Overpayments/{OverpaymentID}/History | Creates a history record for a specific overpayment
*AccountingApi* | [**createPayment**](docs/Api/AccountingApi.md#createpayment) | **POST** /Payments | Creates a single payment for invoice or credit notes
*AccountingApi* | [**createPaymentHistory**](docs/Api/AccountingApi.md#createpaymenthistory) | **PUT** /Payments/{PaymentID}/History | Creates a history record for a specific payment
*AccountingApi* | [**createPaymentService**](docs/Api/AccountingApi.md#createpaymentservice) | **PUT** /PaymentServices | Creates a payment service
*AccountingApi* | [**createPayments**](docs/Api/AccountingApi.md#createpayments) | **PUT** /Payments | Creates multiple payments for invoices or credit notes
*AccountingApi* | [**createPrepaymentAllocations**](docs/Api/AccountingApi.md#createprepaymentallocations) | **PUT** /Prepayments/{PrepaymentID}/Allocations | Allows you to create an Allocation for prepayments
*AccountingApi* | [**createPrepaymentHistory**](docs/Api/AccountingApi.md#createprepaymenthistory) | **PUT** /Prepayments/{PrepaymentID}/History | Creates a history record for a specific prepayment
*AccountingApi* | [**createPurchaseOrderAttachmentByFileName**](docs/Api/AccountingApi.md#createpurchaseorderattachmentbyfilename) | **PUT** /PurchaseOrders/{PurchaseOrderID}/Attachments/{FileName} | Creates attachment for a specific purchase order
*AccountingApi* | [**createPurchaseOrderHistory**](docs/Api/AccountingApi.md#createpurchaseorderhistory) | **PUT** /PurchaseOrders/{PurchaseOrderID}/History | Creates a history record for a specific purchase orders
*AccountingApi* | [**createPurchaseOrders**](docs/Api/AccountingApi.md#createpurchaseorders) | **PUT** /PurchaseOrders | Creates one or more purchase orders
*AccountingApi* | [**createQuoteAttachmentByFileName**](docs/Api/AccountingApi.md#createquoteattachmentbyfilename) | **PUT** /Quotes/{QuoteID}/Attachments/{FileName} | Creates attachment for a specific quote
*AccountingApi* | [**createQuoteHistory**](docs/Api/AccountingApi.md#createquotehistory) | **PUT** /Quotes/{QuoteID}/History | Creates a history record for a specific quote
*AccountingApi* | [**createQuotes**](docs/Api/AccountingApi.md#createquotes) | **PUT** /Quotes | Create one or more quotes
*AccountingApi* | [**createReceipt**](docs/Api/AccountingApi.md#createreceipt) | **PUT** /Receipts | Creates draft expense claim receipts for any user
*AccountingApi* | [**createReceiptAttachmentByFileName**](docs/Api/AccountingApi.md#createreceiptattachmentbyfilename) | **PUT** /Receipts/{ReceiptID}/Attachments/{FileName} | Creates an attachment on a specific expense claim receipts by file name
*AccountingApi* | [**createReceiptHistory**](docs/Api/AccountingApi.md#createreceipthistory) | **PUT** /Receipts/{ReceiptID}/History | Creates a history record for a specific receipt
*AccountingApi* | [**createRepeatingInvoiceAttachmentByFileName**](docs/Api/AccountingApi.md#createrepeatinginvoiceattachmentbyfilename) | **PUT** /RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{FileName} | Creates an attachment from a specific repeating invoices by file name
*AccountingApi* | [**createRepeatingInvoiceHistory**](docs/Api/AccountingApi.md#createrepeatinginvoicehistory) | **PUT** /RepeatingInvoices/{RepeatingInvoiceID}/History | Creates a  history record for a specific repeating invoice
*AccountingApi* | [**createTaxRates**](docs/Api/AccountingApi.md#createtaxrates) | **PUT** /TaxRates | Creates one or more tax rates
*AccountingApi* | [**createTrackingCategory**](docs/Api/AccountingApi.md#createtrackingcategory) | **PUT** /TrackingCategories | Create tracking categories
*AccountingApi* | [**createTrackingOptions**](docs/Api/AccountingApi.md#createtrackingoptions) | **PUT** /TrackingCategories/{TrackingCategoryID}/Options | Creates options for a specific tracking category
*AccountingApi* | [**deleteAccount**](docs/Api/AccountingApi.md#deleteaccount) | **DELETE** /Accounts/{AccountID} | Deletes a chart of accounts
*AccountingApi* | [**deleteContactGroupContact**](docs/Api/AccountingApi.md#deletecontactgroupcontact) | **DELETE** /ContactGroups/{ContactGroupID}/Contacts/{ContactID} | Deletes a specific contact from a contact group using a unique contact Id
*AccountingApi* | [**deleteContactGroupContacts**](docs/Api/AccountingApi.md#deletecontactgroupcontacts) | **DELETE** /ContactGroups/{ContactGroupID}/Contacts | Deletes all contacts from a specific contact group
*AccountingApi* | [**deleteItem**](docs/Api/AccountingApi.md#deleteitem) | **DELETE** /Items/{ItemID} | Deletes a specific item
*AccountingApi* | [**deleteLinkedTransaction**](docs/Api/AccountingApi.md#deletelinkedtransaction) | **DELETE** /LinkedTransactions/{LinkedTransactionID} | Deletes a specific linked transactions (billable expenses)
*AccountingApi* | [**deletePayment**](docs/Api/AccountingApi.md#deletepayment) | **POST** /Payments/{PaymentID} | Updates a specific payment for invoices and credit notes
*AccountingApi* | [**deleteTrackingCategory**](docs/Api/AccountingApi.md#deletetrackingcategory) | **DELETE** /TrackingCategories/{TrackingCategoryID} | Deletes a specific tracking category
*AccountingApi* | [**deleteTrackingOptions**](docs/Api/AccountingApi.md#deletetrackingoptions) | **DELETE** /TrackingCategories/{TrackingCategoryID}/Options/{TrackingOptionID} | Deletes a specific option for a specific tracking category
*AccountingApi* | [**emailInvoice**](docs/Api/AccountingApi.md#emailinvoice) | **POST** /Invoices/{InvoiceID}/Email | Sends a copy of a specific invoice to related contact via email
*AccountingApi* | [**getAccount**](docs/Api/AccountingApi.md#getaccount) | **GET** /Accounts/{AccountID} | Retrieves a single chart of accounts by using a unique account Id
*AccountingApi* | [**getAccountAttachmentByFileName**](docs/Api/AccountingApi.md#getaccountattachmentbyfilename) | **GET** /Accounts/{AccountID}/Attachments/{FileName} | Retrieves an attachment for a specific account by filename
*AccountingApi* | [**getAccountAttachmentById**](docs/Api/AccountingApi.md#getaccountattachmentbyid) | **GET** /Accounts/{AccountID}/Attachments/{AttachmentID} | Retrieves a specific attachment from a specific account using a unique attachment Id
*AccountingApi* | [**getAccountAttachments**](docs/Api/AccountingApi.md#getaccountattachments) | **GET** /Accounts/{AccountID}/Attachments | Retrieves attachments for a specific accounts by using a unique account Id
*AccountingApi* | [**getAccounts**](docs/Api/AccountingApi.md#getaccounts) | **GET** /Accounts | Retrieves the full chart of accounts
*AccountingApi* | [**getBankTransaction**](docs/Api/AccountingApi.md#getbanktransaction) | **GET** /BankTransactions/{BankTransactionID} | Retrieves a single spent or received money transaction by using a unique bank transaction Id
*AccountingApi* | [**getBankTransactionAttachmentByFileName**](docs/Api/AccountingApi.md#getbanktransactionattachmentbyfilename) | **GET** /BankTransactions/{BankTransactionID}/Attachments/{FileName} | Retrieves a specific attachment from a specific bank transaction by filename
*AccountingApi* | [**getBankTransactionAttachmentById**](docs/Api/AccountingApi.md#getbanktransactionattachmentbyid) | **GET** /BankTransactions/{BankTransactionID}/Attachments/{AttachmentID} | Retrieves specific attachments from a specific BankTransaction using a unique attachment Id
*AccountingApi* | [**getBankTransactionAttachments**](docs/Api/AccountingApi.md#getbanktransactionattachments) | **GET** /BankTransactions/{BankTransactionID}/Attachments | Retrieves any attachments from a specific bank transactions
*AccountingApi* | [**getBankTransactions**](docs/Api/AccountingApi.md#getbanktransactions) | **GET** /BankTransactions | Retrieves any spent or received money transactions
*AccountingApi* | [**getBankTransactionsHistory**](docs/Api/AccountingApi.md#getbanktransactionshistory) | **GET** /BankTransactions/{BankTransactionID}/History | Retrieves history from a specific bank transaction using a unique bank transaction Id
*AccountingApi* | [**getBankTransfer**](docs/Api/AccountingApi.md#getbanktransfer) | **GET** /BankTransfers/{BankTransferID} | Retrieves specific bank transfers by using a unique bank transfer Id
*AccountingApi* | [**getBankTransferAttachmentByFileName**](docs/Api/AccountingApi.md#getbanktransferattachmentbyfilename) | **GET** /BankTransfers/{BankTransferID}/Attachments/{FileName} | Retrieves a specific attachment on a specific bank transfer by file name
*AccountingApi* | [**getBankTransferAttachmentById**](docs/Api/AccountingApi.md#getbanktransferattachmentbyid) | **GET** /BankTransfers/{BankTransferID}/Attachments/{AttachmentID} | Retrieves a specific attachment from a specific bank transfer using a unique attachment ID
*AccountingApi* | [**getBankTransferAttachments**](docs/Api/AccountingApi.md#getbanktransferattachments) | **GET** /BankTransfers/{BankTransferID}/Attachments | Retrieves attachments from a specific bank transfer
*AccountingApi* | [**getBankTransferHistory**](docs/Api/AccountingApi.md#getbanktransferhistory) | **GET** /BankTransfers/{BankTransferID}/History | Retrieves history from a specific bank transfer using a unique bank transfer Id
*AccountingApi* | [**getBankTransfers**](docs/Api/AccountingApi.md#getbanktransfers) | **GET** /BankTransfers | Retrieves all bank transfers
*AccountingApi* | [**getBatchPaymentHistory**](docs/Api/AccountingApi.md#getbatchpaymenthistory) | **GET** /BatchPayments/{BatchPaymentID}/History | Retrieves history from a specific batch payment
*AccountingApi* | [**getBatchPayments**](docs/Api/AccountingApi.md#getbatchpayments) | **GET** /BatchPayments | Retrieves either one or many batch payments for invoices
*AccountingApi* | [**getBrandingTheme**](docs/Api/AccountingApi.md#getbrandingtheme) | **GET** /BrandingThemes/{BrandingThemeID} | Retrieves a specific branding theme using a unique branding theme Id
*AccountingApi* | [**getBrandingThemePaymentServices**](docs/Api/AccountingApi.md#getbrandingthemepaymentservices) | **GET** /BrandingThemes/{BrandingThemeID}/PaymentServices | Retrieves the payment services for a specific branding theme
*AccountingApi* | [**getBrandingThemes**](docs/Api/AccountingApi.md#getbrandingthemes) | **GET** /BrandingThemes | Retrieves all the branding themes
*AccountingApi* | [**getContact**](docs/Api/AccountingApi.md#getcontact) | **GET** /Contacts/{ContactID} | Retrieves a specific contacts in a Xero organisation using a unique contact Id
*AccountingApi* | [**getContactAttachmentByFileName**](docs/Api/AccountingApi.md#getcontactattachmentbyfilename) | **GET** /Contacts/{ContactID}/Attachments/{FileName} | Retrieves a specific attachment from a specific contact by file name
*AccountingApi* | [**getContactAttachmentById**](docs/Api/AccountingApi.md#getcontactattachmentbyid) | **GET** /Contacts/{ContactID}/Attachments/{AttachmentID} | Retrieves a specific attachment from a specific contact using a unique attachment Id
*AccountingApi* | [**getContactAttachments**](docs/Api/AccountingApi.md#getcontactattachments) | **GET** /Contacts/{ContactID}/Attachments | Retrieves attachments for a specific contact in a Xero organisation
*AccountingApi* | [**getContactByContactNumber**](docs/Api/AccountingApi.md#getcontactbycontactnumber) | **GET** /Contacts/{ContactNumber} | Retrieves a specific contact by contact number in a Xero organisation
*AccountingApi* | [**getContactCISSettings**](docs/Api/AccountingApi.md#getcontactcissettings) | **GET** /Contacts/{ContactID}/CISSettings | Retrieves CIS settings for a specific contact in a Xero organisation
*AccountingApi* | [**getContactGroup**](docs/Api/AccountingApi.md#getcontactgroup) | **GET** /ContactGroups/{ContactGroupID} | Retrieves a specific contact group by using a unique contact group Id
*AccountingApi* | [**getContactGroups**](docs/Api/AccountingApi.md#getcontactgroups) | **GET** /ContactGroups | Retrieves the contact Id and name of all the contacts in a contact group
*AccountingApi* | [**getContactHistory**](docs/Api/AccountingApi.md#getcontacthistory) | **GET** /Contacts/{ContactID}/History | Retrieves history records for a specific contact
*AccountingApi* | [**getContacts**](docs/Api/AccountingApi.md#getcontacts) | **GET** /Contacts | Retrieves all contacts in a Xero organisation
*AccountingApi* | [**getCreditNote**](docs/Api/AccountingApi.md#getcreditnote) | **GET** /CreditNotes/{CreditNoteID} | Retrieves a specific credit note using a unique credit note Id
*AccountingApi* | [**getCreditNoteAsPdf**](docs/Api/AccountingApi.md#getcreditnoteaspdf) | **GET** /CreditNotes/{CreditNoteID}/pdf | Retrieves credit notes as PDF files
*AccountingApi* | [**getCreditNoteAttachmentByFileName**](docs/Api/AccountingApi.md#getcreditnoteattachmentbyfilename) | **GET** /CreditNotes/{CreditNoteID}/Attachments/{FileName} | Retrieves a specific attachment on a specific credit note by file name
*AccountingApi* | [**getCreditNoteAttachmentById**](docs/Api/AccountingApi.md#getcreditnoteattachmentbyid) | **GET** /CreditNotes/{CreditNoteID}/Attachments/{AttachmentID} | Retrieves a specific attachment from a specific credit note using a unique attachment Id
*AccountingApi* | [**getCreditNoteAttachments**](docs/Api/AccountingApi.md#getcreditnoteattachments) | **GET** /CreditNotes/{CreditNoteID}/Attachments | Retrieves attachments for a specific credit notes
*AccountingApi* | [**getCreditNoteHistory**](docs/Api/AccountingApi.md#getcreditnotehistory) | **GET** /CreditNotes/{CreditNoteID}/History | Retrieves history records of a specific credit note
*AccountingApi* | [**getCreditNotes**](docs/Api/AccountingApi.md#getcreditnotes) | **GET** /CreditNotes | Retrieves any credit notes
*AccountingApi* | [**getCurrencies**](docs/Api/AccountingApi.md#getcurrencies) | **GET** /Currencies | Retrieves currencies for your Xero organisation
*AccountingApi* | [**getEmployee**](docs/Api/AccountingApi.md#getemployee) | **GET** /Employees/{EmployeeID} | Retrieves a specific employee used in Xero payrun using a unique employee Id
*AccountingApi* | [**getEmployees**](docs/Api/AccountingApi.md#getemployees) | **GET** /Employees | Retrieves employees used in Xero payrun
*AccountingApi* | [**getExpenseClaim**](docs/Api/AccountingApi.md#getexpenseclaim) | **GET** /ExpenseClaims/{ExpenseClaimID} | Retrieves a specific expense claim using a unique expense claim Id
*AccountingApi* | [**getExpenseClaimHistory**](docs/Api/AccountingApi.md#getexpenseclaimhistory) | **GET** /ExpenseClaims/{ExpenseClaimID}/History | Retrieves history records of a specific expense claim
*AccountingApi* | [**getExpenseClaims**](docs/Api/AccountingApi.md#getexpenseclaims) | **GET** /ExpenseClaims | Retrieves expense claims
*AccountingApi* | [**getInvoice**](docs/Api/AccountingApi.md#getinvoice) | **GET** /Invoices/{InvoiceID} | Retrieves a specific sales invoice or purchase bill using a unique invoice Id
*AccountingApi* | [**getInvoiceAsPdf**](docs/Api/AccountingApi.md#getinvoiceaspdf) | **GET** /Invoices/{InvoiceID}/pdf | Retrieves invoices or purchase bills as PDF files
*AccountingApi* | [**getInvoiceAttachmentByFileName**](docs/Api/AccountingApi.md#getinvoiceattachmentbyfilename) | **GET** /Invoices/{InvoiceID}/Attachments/{FileName} | Retrieves an attachment from a specific invoice or purchase bill by filename
*AccountingApi* | [**getInvoiceAttachmentById**](docs/Api/AccountingApi.md#getinvoiceattachmentbyid) | **GET** /Invoices/{InvoiceID}/Attachments/{AttachmentID} | Retrieves a specific attachment from a specific invoices or purchase bills by using a unique attachment Id
*AccountingApi* | [**getInvoiceAttachments**](docs/Api/AccountingApi.md#getinvoiceattachments) | **GET** /Invoices/{InvoiceID}/Attachments | Retrieves attachments for a specific invoice or purchase bill
*AccountingApi* | [**getInvoiceHistory**](docs/Api/AccountingApi.md#getinvoicehistory) | **GET** /Invoices/{InvoiceID}/History | Retrieves history records for a specific invoice
*AccountingApi* | [**getInvoiceReminders**](docs/Api/AccountingApi.md#getinvoicereminders) | **GET** /InvoiceReminders/Settings | Retrieves invoice reminder settings
*AccountingApi* | [**getInvoices**](docs/Api/AccountingApi.md#getinvoices) | **GET** /Invoices | Retrieves sales invoices or purchase bills
*AccountingApi* | [**getItem**](docs/Api/AccountingApi.md#getitem) | **GET** /Items/{ItemID} | Retrieves a specific item using a unique item Id
*AccountingApi* | [**getItemHistory**](docs/Api/AccountingApi.md#getitemhistory) | **GET** /Items/{ItemID}/History | Retrieves history for a specific item
*AccountingApi* | [**getItems**](docs/Api/AccountingApi.md#getitems) | **GET** /Items | Retrieves items
*AccountingApi* | [**getJournal**](docs/Api/AccountingApi.md#getjournal) | **GET** /Journals/{JournalID} | Retrieves a specific journal using a unique journal Id.
*AccountingApi* | [**getJournals**](docs/Api/AccountingApi.md#getjournals) | **GET** /Journals | Retrieves journals
*AccountingApi* | [**getLinkedTransaction**](docs/Api/AccountingApi.md#getlinkedtransaction) | **GET** /LinkedTransactions/{LinkedTransactionID} | Retrieves a specific linked transaction (billable expenses) using a unique linked transaction Id
*AccountingApi* | [**getLinkedTransactions**](docs/Api/AccountingApi.md#getlinkedtransactions) | **GET** /LinkedTransactions | Retrieves linked transactions (billable expenses)
*AccountingApi* | [**getManualJournal**](docs/Api/AccountingApi.md#getmanualjournal) | **GET** /ManualJournals/{ManualJournalID} | Retrieves a specific manual journal
*AccountingApi* | [**getManualJournalAttachmentByFileName**](docs/Api/AccountingApi.md#getmanualjournalattachmentbyfilename) | **GET** /ManualJournals/{ManualJournalID}/Attachments/{FileName} | Retrieves a specific attachment from a specific manual journal by file name
*AccountingApi* | [**getManualJournalAttachmentById**](docs/Api/AccountingApi.md#getmanualjournalattachmentbyid) | **GET** /ManualJournals/{ManualJournalID}/Attachments/{AttachmentID} | Allows you to retrieve a specific attachment from a specific manual journal using a unique attachment Id
*AccountingApi* | [**getManualJournalAttachments**](docs/Api/AccountingApi.md#getmanualjournalattachments) | **GET** /ManualJournals/{ManualJournalID}/Attachments | Retrieves attachment for a specific manual journal
*AccountingApi* | [**getManualJournals**](docs/Api/AccountingApi.md#getmanualjournals) | **GET** /ManualJournals | Retrieves manual journals
*AccountingApi* | [**getManualJournalsHistory**](docs/Api/AccountingApi.md#getmanualjournalshistory) | **GET** /ManualJournals/{ManualJournalID}/History | Retrieves history for a specific manual journal
*AccountingApi* | [**getOnlineInvoice**](docs/Api/AccountingApi.md#getonlineinvoice) | **GET** /Invoices/{InvoiceID}/OnlineInvoice | Retrieves a URL to an online invoice
*AccountingApi* | [**getOrganisationActions**](docs/Api/AccountingApi.md#getorganisationactions) | **GET** /Organisation/Actions | Retrieves a list of the key actions your app has permission to perform in the connected Xero organisation.
*AccountingApi* | [**getOrganisationCISSettings**](docs/Api/AccountingApi.md#getorganisationcissettings) | **GET** /Organisation/{OrganisationID}/CISSettings | Retrieves the CIS settings for the Xero organistaion.
*AccountingApi* | [**getOrganisations**](docs/Api/AccountingApi.md#getorganisations) | **GET** /Organisation | Retrieves Xero organisation details
*AccountingApi* | [**getOverpayment**](docs/Api/AccountingApi.md#getoverpayment) | **GET** /Overpayments/{OverpaymentID} | Retrieves a specific overpayment using a unique overpayment Id
*AccountingApi* | [**getOverpaymentHistory**](docs/Api/AccountingApi.md#getoverpaymenthistory) | **GET** /Overpayments/{OverpaymentID}/History | Retrieves history records of a specific overpayment
*AccountingApi* | [**getOverpayments**](docs/Api/AccountingApi.md#getoverpayments) | **GET** /Overpayments | Retrieves overpayments
*AccountingApi* | [**getPayment**](docs/Api/AccountingApi.md#getpayment) | **GET** /Payments/{PaymentID} | Retrieves a specific payment for invoices and credit notes using a unique payment Id
*AccountingApi* | [**getPaymentHistory**](docs/Api/AccountingApi.md#getpaymenthistory) | **GET** /Payments/{PaymentID}/History | Retrieves history records of a specific payment
*AccountingApi* | [**getPaymentServices**](docs/Api/AccountingApi.md#getpaymentservices) | **GET** /PaymentServices | Retrieves payment services
*AccountingApi* | [**getPayments**](docs/Api/AccountingApi.md#getpayments) | **GET** /Payments | Retrieves payments for invoices and credit notes
*AccountingApi* | [**getPrepayment**](docs/Api/AccountingApi.md#getprepayment) | **GET** /Prepayments/{PrepaymentID} | Allows you to retrieve a specified prepayments
*AccountingApi* | [**getPrepaymentHistory**](docs/Api/AccountingApi.md#getprepaymenthistory) | **GET** /Prepayments/{PrepaymentID}/History | Retrieves history record for a specific prepayment
*AccountingApi* | [**getPrepayments**](docs/Api/AccountingApi.md#getprepayments) | **GET** /Prepayments | Retrieves prepayments
*AccountingApi* | [**getPurchaseOrder**](docs/Api/AccountingApi.md#getpurchaseorder) | **GET** /PurchaseOrders/{PurchaseOrderID} | Retrieves a specific purchase order using a unique purchase order Id
*AccountingApi* | [**getPurchaseOrderAsPdf**](docs/Api/AccountingApi.md#getpurchaseorderaspdf) | **GET** /PurchaseOrders/{PurchaseOrderID}/pdf | Retrieves specific purchase order as PDF files using a unique purchase order Id
*AccountingApi* | [**getPurchaseOrderAttachmentByFileName**](docs/Api/AccountingApi.md#getpurchaseorderattachmentbyfilename) | **GET** /PurchaseOrders/{PurchaseOrderID}/Attachments/{FileName} | Retrieves a specific attachment for a specific purchase order by filename
*AccountingApi* | [**getPurchaseOrderAttachmentById**](docs/Api/AccountingApi.md#getpurchaseorderattachmentbyid) | **GET** /PurchaseOrders/{PurchaseOrderID}/Attachments/{AttachmentID} | Retrieves specific attachment for a specific purchase order using a unique attachment Id
*AccountingApi* | [**getPurchaseOrderAttachments**](docs/Api/AccountingApi.md#getpurchaseorderattachments) | **GET** /PurchaseOrders/{PurchaseOrderID}/Attachments | Retrieves attachments for a specific purchase order
*AccountingApi* | [**getPurchaseOrderByNumber**](docs/Api/AccountingApi.md#getpurchaseorderbynumber) | **GET** /PurchaseOrders/{PurchaseOrderNumber} | Retrieves a specific purchase order using purchase order number
*AccountingApi* | [**getPurchaseOrderHistory**](docs/Api/AccountingApi.md#getpurchaseorderhistory) | **GET** /PurchaseOrders/{PurchaseOrderID}/History | Retrieves history for a specific purchase order
*AccountingApi* | [**getPurchaseOrders**](docs/Api/AccountingApi.md#getpurchaseorders) | **GET** /PurchaseOrders | Retrieves purchase orders
*AccountingApi* | [**getQuote**](docs/Api/AccountingApi.md#getquote) | **GET** /Quotes/{QuoteID} | Retrieves a specific quote using a unique quote Id
*AccountingApi* | [**getQuoteAsPdf**](docs/Api/AccountingApi.md#getquoteaspdf) | **GET** /Quotes/{QuoteID}/pdf | Retrieves a specific quote as a PDF file using a unique quote Id
*AccountingApi* | [**getQuoteAttachmentByFileName**](docs/Api/AccountingApi.md#getquoteattachmentbyfilename) | **GET** /Quotes/{QuoteID}/Attachments/{FileName} | Retrieves a specific attachment from a specific quote by filename
*AccountingApi* | [**getQuoteAttachmentById**](docs/Api/AccountingApi.md#getquoteattachmentbyid) | **GET** /Quotes/{QuoteID}/Attachments/{AttachmentID} | Retrieves a specific attachment from a specific quote using a unique attachment Id
*AccountingApi* | [**getQuoteAttachments**](docs/Api/AccountingApi.md#getquoteattachments) | **GET** /Quotes/{QuoteID}/Attachments | Retrieves attachments for a specific quote
*AccountingApi* | [**getQuoteHistory**](docs/Api/AccountingApi.md#getquotehistory) | **GET** /Quotes/{QuoteID}/History | Retrieves history records of a specific quote
*AccountingApi* | [**getQuotes**](docs/Api/AccountingApi.md#getquotes) | **GET** /Quotes | Retrieves sales quotes
*AccountingApi* | [**getReceipt**](docs/Api/AccountingApi.md#getreceipt) | **GET** /Receipts/{ReceiptID} | Retrieves a specific draft expense claim receipt by using a unique receipt Id
*AccountingApi* | [**getReceiptAttachmentByFileName**](docs/Api/AccountingApi.md#getreceiptattachmentbyfilename) | **GET** /Receipts/{ReceiptID}/Attachments/{FileName} | Retrieves a specific attachment from a specific expense claim receipts by file name
*AccountingApi* | [**getReceiptAttachmentById**](docs/Api/AccountingApi.md#getreceiptattachmentbyid) | **GET** /Receipts/{ReceiptID}/Attachments/{AttachmentID} | Retrieves a specific attachments from a specific expense claim receipts by using a unique attachment Id
*AccountingApi* | [**getReceiptAttachments**](docs/Api/AccountingApi.md#getreceiptattachments) | **GET** /Receipts/{ReceiptID}/Attachments | Retrieves attachments for a specific expense claim receipt
*AccountingApi* | [**getReceiptHistory**](docs/Api/AccountingApi.md#getreceipthistory) | **GET** /Receipts/{ReceiptID}/History | Retrieves a history record for a specific receipt
*AccountingApi* | [**getReceipts**](docs/Api/AccountingApi.md#getreceipts) | **GET** /Receipts | Retrieves draft expense claim receipts for any user
*AccountingApi* | [**getRepeatingInvoice**](docs/Api/AccountingApi.md#getrepeatinginvoice) | **GET** /RepeatingInvoices/{RepeatingInvoiceID} | Retrieves a specific repeating invoice by using a unique repeating invoice Id
*AccountingApi* | [**getRepeatingInvoiceAttachmentByFileName**](docs/Api/AccountingApi.md#getrepeatinginvoiceattachmentbyfilename) | **GET** /RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{FileName} | Retrieves a specific attachment from a specific repeating invoices by file name
*AccountingApi* | [**getRepeatingInvoiceAttachmentById**](docs/Api/AccountingApi.md#getrepeatinginvoiceattachmentbyid) | **GET** /RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{AttachmentID} | Retrieves a specific attachment from a specific repeating invoice
*AccountingApi* | [**getRepeatingInvoiceAttachments**](docs/Api/AccountingApi.md#getrepeatinginvoiceattachments) | **GET** /RepeatingInvoices/{RepeatingInvoiceID}/Attachments | Retrieves attachments from a specific repeating invoice
*AccountingApi* | [**getRepeatingInvoiceHistory**](docs/Api/AccountingApi.md#getrepeatinginvoicehistory) | **GET** /RepeatingInvoices/{RepeatingInvoiceID}/History | Retrieves history record for a specific repeating invoice
*AccountingApi* | [**getRepeatingInvoices**](docs/Api/AccountingApi.md#getrepeatinginvoices) | **GET** /RepeatingInvoices | Retrieves repeating invoices
*AccountingApi* | [**getReportAgedPayablesByContact**](docs/Api/AccountingApi.md#getreportagedpayablesbycontact) | **GET** /Reports/AgedPayablesByContact | Retrieves report for aged payables by contact
*AccountingApi* | [**getReportAgedReceivablesByContact**](docs/Api/AccountingApi.md#getreportagedreceivablesbycontact) | **GET** /Reports/AgedReceivablesByContact | Retrieves report for aged receivables by contact
*AccountingApi* | [**getReportBASorGST**](docs/Api/AccountingApi.md#getreportbasorgst) | **GET** /Reports/{ReportID} | Retrieves a specific report for BAS using a unique report Id (only valid for AU orgs)
*AccountingApi* | [**getReportBASorGSTList**](docs/Api/AccountingApi.md#getreportbasorgstlist) | **GET** /Reports | Retrieves report for BAS (only valid for AU orgs)
*AccountingApi* | [**getReportBalanceSheet**](docs/Api/AccountingApi.md#getreportbalancesheet) | **GET** /Reports/BalanceSheet | Retrieves report for balancesheet
*AccountingApi* | [**getReportBankSummary**](docs/Api/AccountingApi.md#getreportbanksummary) | **GET** /Reports/BankSummary | Retrieves report for bank summary
*AccountingApi* | [**getReportBudgetSummary**](docs/Api/AccountingApi.md#getreportbudgetsummary) | **GET** /Reports/BudgetSummary | Retrieves report for budget summary
*AccountingApi* | [**getReportExecutiveSummary**](docs/Api/AccountingApi.md#getreportexecutivesummary) | **GET** /Reports/ExecutiveSummary | Retrieves report for executive summary
*AccountingApi* | [**getReportProfitAndLoss**](docs/Api/AccountingApi.md#getreportprofitandloss) | **GET** /Reports/ProfitAndLoss | Retrieves report for profit and loss
*AccountingApi* | [**getReportTenNinetyNine**](docs/Api/AccountingApi.md#getreporttenninetynine) | **GET** /Reports/TenNinetyNine | Retrieve reports for 1099
*AccountingApi* | [**getReportTrialBalance**](docs/Api/AccountingApi.md#getreporttrialbalance) | **GET** /Reports/TrialBalance | Retrieves report for trial balance
*AccountingApi* | [**getTaxRates**](docs/Api/AccountingApi.md#gettaxrates) | **GET** /TaxRates | Retrieves tax rates
*AccountingApi* | [**getTrackingCategories**](docs/Api/AccountingApi.md#gettrackingcategories) | **GET** /TrackingCategories | Retrieves tracking categories and options
*AccountingApi* | [**getTrackingCategory**](docs/Api/AccountingApi.md#gettrackingcategory) | **GET** /TrackingCategories/{TrackingCategoryID} | Retrieves specific tracking categories and options using a unique tracking category Id
*AccountingApi* | [**getUser**](docs/Api/AccountingApi.md#getuser) | **GET** /Users/{UserID} | Retrieves a specific user
*AccountingApi* | [**getUsers**](docs/Api/AccountingApi.md#getusers) | **GET** /Users | Retrieves users
*AccountingApi* | [**postSetup**](docs/Api/AccountingApi.md#postsetup) | **POST** /Setup | Sets the chart of accounts, the conversion date and conversion balances
*AccountingApi* | [**updateAccount**](docs/Api/AccountingApi.md#updateaccount) | **POST** /Accounts/{AccountID} | Updates a chart of accounts
*AccountingApi* | [**updateAccountAttachmentByFileName**](docs/Api/AccountingApi.md#updateaccountattachmentbyfilename) | **POST** /Accounts/{AccountID}/Attachments/{FileName} | Updates attachment on a specific account by filename
*AccountingApi* | [**updateBankTransaction**](docs/Api/AccountingApi.md#updatebanktransaction) | **POST** /BankTransactions/{BankTransactionID} | Updates a single spent or received money transaction
*AccountingApi* | [**updateBankTransactionAttachmentByFileName**](docs/Api/AccountingApi.md#updatebanktransactionattachmentbyfilename) | **POST** /BankTransactions/{BankTransactionID}/Attachments/{FileName} | Updates a specific attachment from a specific bank transaction by filename
*AccountingApi* | [**updateBankTransferAttachmentByFileName**](docs/Api/AccountingApi.md#updatebanktransferattachmentbyfilename) | **POST** /BankTransfers/{BankTransferID}/Attachments/{FileName} | 
*AccountingApi* | [**updateContact**](docs/Api/AccountingApi.md#updatecontact) | **POST** /Contacts/{ContactID} | Updates a specific contact in a Xero organisation
*AccountingApi* | [**updateContactAttachmentByFileName**](docs/Api/AccountingApi.md#updatecontactattachmentbyfilename) | **POST** /Contacts/{ContactID}/Attachments/{FileName} | 
*AccountingApi* | [**updateContactGroup**](docs/Api/AccountingApi.md#updatecontactgroup) | **POST** /ContactGroups/{ContactGroupID} | Updates a specific contact group
*AccountingApi* | [**updateCreditNote**](docs/Api/AccountingApi.md#updatecreditnote) | **POST** /CreditNotes/{CreditNoteID} | Updates a specific credit note
*AccountingApi* | [**updateCreditNoteAttachmentByFileName**](docs/Api/AccountingApi.md#updatecreditnoteattachmentbyfilename) | **POST** /CreditNotes/{CreditNoteID}/Attachments/{FileName} | Updates attachments on a specific credit note by file name
*AccountingApi* | [**updateExpenseClaim**](docs/Api/AccountingApi.md#updateexpenseclaim) | **POST** /ExpenseClaims/{ExpenseClaimID} | Updates a specific expense claims
*AccountingApi* | [**updateInvoice**](docs/Api/AccountingApi.md#updateinvoice) | **POST** /Invoices/{InvoiceID} | Updates a specific sales invoices or purchase bills
*AccountingApi* | [**updateInvoiceAttachmentByFileName**](docs/Api/AccountingApi.md#updateinvoiceattachmentbyfilename) | **POST** /Invoices/{InvoiceID}/Attachments/{FileName} | Updates an attachment from a specific invoices or purchase bill by filename
*AccountingApi* | [**updateItem**](docs/Api/AccountingApi.md#updateitem) | **POST** /Items/{ItemID} | Updates a specific item
*AccountingApi* | [**updateLinkedTransaction**](docs/Api/AccountingApi.md#updatelinkedtransaction) | **POST** /LinkedTransactions/{LinkedTransactionID} | Updates a specific linked transactions (billable expenses)
*AccountingApi* | [**updateManualJournal**](docs/Api/AccountingApi.md#updatemanualjournal) | **POST** /ManualJournals/{ManualJournalID} | Updates a specific manual journal
*AccountingApi* | [**updateManualJournalAttachmentByFileName**](docs/Api/AccountingApi.md#updatemanualjournalattachmentbyfilename) | **POST** /ManualJournals/{ManualJournalID}/Attachments/{FileName} | Updates a specific attachment from a specific manual journal by file name
*AccountingApi* | [**updateOrCreateBankTransactions**](docs/Api/AccountingApi.md#updateorcreatebanktransactions) | **POST** /BankTransactions | Updates or creates one or more spent or received money transaction
*AccountingApi* | [**updateOrCreateContacts**](docs/Api/AccountingApi.md#updateorcreatecontacts) | **POST** /Contacts | Updates or creates one or more contacts in a Xero organisation
*AccountingApi* | [**updateOrCreateCreditNotes**](docs/Api/AccountingApi.md#updateorcreatecreditnotes) | **POST** /CreditNotes | Updates or creates one or more credit notes
*AccountingApi* | [**updateOrCreateEmployees**](docs/Api/AccountingApi.md#updateorcreateemployees) | **POST** /Employees | Creates a single new employees used in Xero payrun
*AccountingApi* | [**updateOrCreateInvoices**](docs/Api/AccountingApi.md#updateorcreateinvoices) | **POST** /Invoices | Updates or creates one or more sales invoices or purchase bills
*AccountingApi* | [**updateOrCreateItems**](docs/Api/AccountingApi.md#updateorcreateitems) | **POST** /Items | Updates or creates one or more items
*AccountingApi* | [**updateOrCreateManualJournals**](docs/Api/AccountingApi.md#updateorcreatemanualjournals) | **POST** /ManualJournals | Updates or creates a single manual journal
*AccountingApi* | [**updateOrCreatePurchaseOrders**](docs/Api/AccountingApi.md#updateorcreatepurchaseorders) | **POST** /PurchaseOrders | Updates or creates one or more purchase orders
*AccountingApi* | [**updateOrCreateQuotes**](docs/Api/AccountingApi.md#updateorcreatequotes) | **POST** /Quotes | Updates or creates one or more quotes
*AccountingApi* | [**updatePurchaseOrder**](docs/Api/AccountingApi.md#updatepurchaseorder) | **POST** /PurchaseOrders/{PurchaseOrderID} | Updates a specific purchase order
*AccountingApi* | [**updatePurchaseOrderAttachmentByFileName**](docs/Api/AccountingApi.md#updatepurchaseorderattachmentbyfilename) | **POST** /PurchaseOrders/{PurchaseOrderID}/Attachments/{FileName} | Updates a specific attachment for a specific purchase order by filename
*AccountingApi* | [**updateQuote**](docs/Api/AccountingApi.md#updatequote) | **POST** /Quotes/{QuoteID} | Updates a specific quote
*AccountingApi* | [**updateQuoteAttachmentByFileName**](docs/Api/AccountingApi.md#updatequoteattachmentbyfilename) | **POST** /Quotes/{QuoteID}/Attachments/{FileName} | Updates a specific attachment from a specific quote by filename
*AccountingApi* | [**updateReceipt**](docs/Api/AccountingApi.md#updatereceipt) | **POST** /Receipts/{ReceiptID} | Updates a specific draft expense claim receipts
*AccountingApi* | [**updateReceiptAttachmentByFileName**](docs/Api/AccountingApi.md#updatereceiptattachmentbyfilename) | **POST** /Receipts/{ReceiptID}/Attachments/{FileName} | Updates a specific attachment on a specific expense claim receipts by file name
*AccountingApi* | [**updateRepeatingInvoiceAttachmentByFileName**](docs/Api/AccountingApi.md#updaterepeatinginvoiceattachmentbyfilename) | **POST** /RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{FileName} | Updates a specific attachment from a specific repeating invoices by file name
*AccountingApi* | [**updateTaxRate**](docs/Api/AccountingApi.md#updatetaxrate) | **POST** /TaxRates | Updates tax rates
*AccountingApi* | [**updateTrackingCategory**](docs/Api/AccountingApi.md#updatetrackingcategory) | **POST** /TrackingCategories/{TrackingCategoryID} | Updates a specific tracking category
*AccountingApi* | [**updateTrackingOptions**](docs/Api/AccountingApi.md#updatetrackingoptions) | **POST** /TrackingCategories/{TrackingCategoryID}/Options/{TrackingOptionID} | Updates a specific option for a specific tracking category

## Models

- [Account](docs/Model/Account.md)
- [AccountType](docs/Model/AccountType.md)
- [Accounts](docs/Model/Accounts.md)
- [AccountsPayable](docs/Model/AccountsPayable.md)
- [AccountsReceivable](docs/Model/AccountsReceivable.md)
- [Action](docs/Model/Action.md)
- [Actions](docs/Model/Actions.md)
- [Address](docs/Model/Address.md)
- [AddressForOrganisation](docs/Model/AddressForOrganisation.md)
- [Allocation](docs/Model/Allocation.md)
- [Allocations](docs/Model/Allocations.md)
- [Attachment](docs/Model/Attachment.md)
- [Attachments](docs/Model/Attachments.md)
- [BalanceDetails](docs/Model/BalanceDetails.md)
- [Balances](docs/Model/Balances.md)
- [BankTransaction](docs/Model/BankTransaction.md)
- [BankTransactions](docs/Model/BankTransactions.md)
- [BankTransfer](docs/Model/BankTransfer.md)
- [BankTransfers](docs/Model/BankTransfers.md)
- [BatchPayment](docs/Model/BatchPayment.md)
- [BatchPaymentDetails](docs/Model/BatchPaymentDetails.md)
- [BatchPayments](docs/Model/BatchPayments.md)
- [Bill](docs/Model/Bill.md)
- [BrandingTheme](docs/Model/BrandingTheme.md)
- [BrandingThemes](docs/Model/BrandingThemes.md)
- [CISOrgSetting](docs/Model/CISOrgSetting.md)
- [CISOrgSettings](docs/Model/CISOrgSettings.md)
- [CISSetting](docs/Model/CISSetting.md)
- [CISSettings](docs/Model/CISSettings.md)
- [Contact](docs/Model/Contact.md)
- [ContactGroup](docs/Model/ContactGroup.md)
- [ContactGroups](docs/Model/ContactGroups.md)
- [ContactPerson](docs/Model/ContactPerson.md)
- [Contacts](docs/Model/Contacts.md)
- [ConversionBalances](docs/Model/ConversionBalances.md)
- [ConversionDate](docs/Model/ConversionDate.md)
- [CountryCode](docs/Model/CountryCode.md)
- [CreditNote](docs/Model/CreditNote.md)
- [CreditNotes](docs/Model/CreditNotes.md)
- [Currencies](docs/Model/Currencies.md)
- [Currency](docs/Model/Currency.md)
- [CurrencyCode](docs/Model/CurrencyCode.md)
- [Element](docs/Model/Element.md)
- [Employee](docs/Model/Employee.md)
- [Employees](docs/Model/Employees.md)
- [Error](docs/Model/Error.md)
- [ExpenseClaim](docs/Model/ExpenseClaim.md)
- [ExpenseClaims](docs/Model/ExpenseClaims.md)
- [ExternalLink](docs/Model/ExternalLink.md)
- [HistoryRecord](docs/Model/HistoryRecord.md)
- [HistoryRecords](docs/Model/HistoryRecords.md)
- [ImportSummary](docs/Model/ImportSummary.md)
- [ImportSummaryAccounts](docs/Model/ImportSummaryAccounts.md)
- [ImportSummaryObject](docs/Model/ImportSummaryObject.md)
- [ImportSummaryOrganisation](docs/Model/ImportSummaryOrganisation.md)
- [Invoice](docs/Model/Invoice.md)
- [InvoiceReminder](docs/Model/InvoiceReminder.md)
- [InvoiceReminders](docs/Model/InvoiceReminders.md)
- [Invoices](docs/Model/Invoices.md)
- [Item](docs/Model/Item.md)
- [Items](docs/Model/Items.md)
- [Journal](docs/Model/Journal.md)
- [JournalLine](docs/Model/JournalLine.md)
- [Journals](docs/Model/Journals.md)
- [LineAmountTypes](docs/Model/LineAmountTypes.md)
- [LineItem](docs/Model/LineItem.md)
- [LineItemTracking](docs/Model/LineItemTracking.md)
- [LinkedTransaction](docs/Model/LinkedTransaction.md)
- [LinkedTransactions](docs/Model/LinkedTransactions.md)
- [ManualJournal](docs/Model/ManualJournal.md)
- [ManualJournalLine](docs/Model/ManualJournalLine.md)
- [ManualJournals](docs/Model/ManualJournals.md)
- [OnlineInvoice](docs/Model/OnlineInvoice.md)
- [OnlineInvoices](docs/Model/OnlineInvoices.md)
- [Organisation](docs/Model/Organisation.md)
- [Organisations](docs/Model/Organisations.md)
- [Overpayment](docs/Model/Overpayment.md)
- [Overpayments](docs/Model/Overpayments.md)
- [Payment](docs/Model/Payment.md)
- [PaymentDelete](docs/Model/PaymentDelete.md)
- [PaymentService](docs/Model/PaymentService.md)
- [PaymentServices](docs/Model/PaymentServices.md)
- [PaymentTerm](docs/Model/PaymentTerm.md)
- [PaymentTermType](docs/Model/PaymentTermType.md)
- [Payments](docs/Model/Payments.md)
- [Phone](docs/Model/Phone.md)
- [Prepayment](docs/Model/Prepayment.md)
- [Prepayments](docs/Model/Prepayments.md)
- [Purchase](docs/Model/Purchase.md)
- [PurchaseOrder](docs/Model/PurchaseOrder.md)
- [PurchaseOrders](docs/Model/PurchaseOrders.md)
- [Quote](docs/Model/Quote.md)
- [QuoteLineAmountTypes](docs/Model/QuoteLineAmountTypes.md)
- [QuoteStatusCodes](docs/Model/QuoteStatusCodes.md)
- [Quotes](docs/Model/Quotes.md)
- [Receipt](docs/Model/Receipt.md)
- [Receipts](docs/Model/Receipts.md)
- [RepeatingInvoice](docs/Model/RepeatingInvoice.md)
- [RepeatingInvoices](docs/Model/RepeatingInvoices.md)
- [Report](docs/Model/Report.md)
- [ReportAttribute](docs/Model/ReportAttribute.md)
- [ReportCell](docs/Model/ReportCell.md)
- [ReportFields](docs/Model/ReportFields.md)
- [ReportRow](docs/Model/ReportRow.md)
- [ReportRows](docs/Model/ReportRows.md)
- [ReportWithRow](docs/Model/ReportWithRow.md)
- [ReportWithRows](docs/Model/ReportWithRows.md)
- [Reports](docs/Model/Reports.md)
- [RequestEmpty](docs/Model/RequestEmpty.md)
- [RowType](docs/Model/RowType.md)
- [SalesTrackingCategory](docs/Model/SalesTrackingCategory.md)
- [Schedule](docs/Model/Schedule.md)
- [Setup](docs/Model/Setup.md)
- [TaxComponent](docs/Model/TaxComponent.md)
- [TaxRate](docs/Model/TaxRate.md)
- [TaxRates](docs/Model/TaxRates.md)
- [TaxType](docs/Model/TaxType.md)
- [TenNinetyNineContact](docs/Model/TenNinetyNineContact.md)
- [TimeZone](docs/Model/TimeZone.md)
- [TrackingCategories](docs/Model/TrackingCategories.md)
- [TrackingCategory](docs/Model/TrackingCategory.md)
- [TrackingOption](docs/Model/TrackingOption.md)
- [TrackingOptions](docs/Model/TrackingOptions.md)
- [User](docs/Model/User.md)
- [Users](docs/Model/Users.md)
- [ValidationError](docs/Model/ValidationError.md)

## Authorization

### OAuth2

- **Type**: `OAuth`
- **Flow**: `accessCode`
- **Authorization URL**: `https://login.xero.com/identity/connect/authorize`
- **Scopes**: 
    - **email**: Grant read-only access to your email
    - **openid**: Grant read-only access to your open id
    - **profile**: your profile information
    - **accounting.transactions**: Grant read-write access to bank transactions, credit notes, invoices, repeating invoices
    - **accounting.transactions.read**: Grant read-only access to invoices
    - **accounting.reports.read**: Grant read-only access to accounting reports
    - **accounting.reports.tenninetynine.read**: Grant read-only access to 1099 reports
    - **accounting.journals.read**: Grant read-only access to journals
    - **accounting.settings**: Grant read-write access to organisation and account settings
    - **accounting.settings.read**: Grant read-only access to organisation and account settings
    - **accounting.contacts**: Grant read-write access to contacts and contact groups
    - **accounting.contacts.read**: Grant read-only access to contacts and contact groups
    - **accounting.attachments**: Grant read-write access to attachments
    - **accounting.attachments.read**: Grant read-only access to attachments
    - **assets**: Grant read-write access to assets
    - **assets.read**: Grant read-only access to fixed assets
    - **bankfeeds**: Grant read-write access to bankfeeds
    - **files**: Grant read-write access to files and folders
    - **files.read**: Grant read-only access to files and folders
    - **payroll**: Grant read-write access to payroll
    - **payroll.read**: Grant read-only access to payroll
    - **payroll.employees**: Grant read-write access to payroll employees
    - **payroll.employees.read**: Grant read-only access to payroll employees
    - **payroll.leaveapplications**: Grant read-write access to payroll leaveapplications
    - **payroll.leaveapplications.read**: Grant read-only access to payroll leaveapplications
    - **payroll.payitems**: Grant read-write access to payroll payitems
    - **payroll.payitems.read**: Grant read-only access to payroll payitems
    - **payroll.payrollcalendars**: Grant read-write access to payroll calendars
    - **payroll.payrollcalendars.read**: Grant read-only access to payroll calendars
    - **payroll.payruns**: Grant read-write access to payroll payruns
    - **payroll.payruns.read**: Grant read-only access to payroll payruns
    - **payroll.payslip**: Grant read-write access to payroll payslips
    - **payroll.payslip.read**: Grant read-only access to payroll payslips
    - **payroll.settings.read**: Grant read-only access to payroll settings
    - **payroll.superfunds**: Grant read-write access to payroll superfunds
    - **payroll.superfunds.read**: Grant read-only access to payroll superfunds
    - **payroll.superfundproducts.read**: Grant read-only access to payroll superfundproducts
    - **payroll.timesheets**: Grant read-write access to payroll timesheets
    - **payroll.timesheets.read**: Grant read-only access to payroll timesheets
    - **paymentservices**: Grant read-write access to payment services
    - **projects**: Grant read-write access to projects
    - **projects.read**: Grant read-only access to projects

## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author

api@xero.com

## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `2.10.0`
    - Package version: `2.0.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
