# OpenAPIClient-php

This specifing endpoints related to managing authentication tokens and identity for Xero API

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 2.0.0
- Build package: org.openapitools.codegen.languages.PhpClientCodegen
For more information, please visit [https://developer.xero.com](https://developer.xero.com)

## Requirements

PHP 5.5 and later

## Installation & Usage

### Composer

To install the bindings via [Composer](http://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/xero2.git"
    }
  ],
  "require": {
    "talisman/xero2": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
    require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Tests

To run the unit tests:

```bash
composer install
./vendor/bin/phpunit
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure OAuth2 access token for authorization: OAuth2
$config = Xero2\Identity\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Xero2\Identity\Api\IdentityApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 'id_example'; // string | Unique identifier for retrieving single object

try {
    $apiInstance->deleteConnection($id);
} catch (Exception $e) {
    echo 'Exception when calling IdentityApi->deleteConnection: ', $e->getMessage(), PHP_EOL;
}

?>
```

## Documentation for API Endpoints

All URIs are relative to *https://api.xero.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*IdentityApi* | [**deleteConnection**](docs/Api/IdentityApi.md#deleteconnection) | **DELETE** /connections/{id} | Allows you to delete a connection for this user (i.e. disconnect a tenant)
*IdentityApi* | [**getConnections**](docs/Api/IdentityApi.md#getconnections) | **GET** /connections | Allows you to retrieve the connections for this user


## Documentation For Models

 - [AccessToken](docs/Model/AccessToken.md)
 - [Connection](docs/Model/Connection.md)
 - [RefreshToken](docs/Model/RefreshToken.md)


## Documentation For Authorization



## OAuth2


- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: https://login.xero.com/identity/connect/authorize
- **Scopes**: 
- **email**: Grant read-only access to your email
- **openid**: Grant read-only access to your open id
- **profile**: your profile information
- **accounting.transactions**: Grant read-write access to bank transactions, credit notes, invoices, repeating invoices
- **accounting.transactions.read**: Grant read-only access to invoices
- **accounting.reports.read**: Grant read-only access to accounting reports
- **accounting.journals.read**: Grant read-only access to journals
- **accounting.settings**: Grant read-write access to organisation and account settings
- **accounting.settings.read**: Grant read-only access to organisation and account settings
- **accounting.contacts**: Grant read-write access to
- **accounting.contacts.read**: Grant read-only access to
- **accounting.attachments**: Grant read-write access to
- **accounting.attachments.read**: Grant read-only access to
- **assets assets.read**: Grant read-only access to
- **files**: Grant read-write access to
- **files.read**: Grant read-only access to
- **payroll**: Grant read-write access to
- **payroll.read**: Grant read-only access to
- **payroll.employees**: Grant read-write access to
- **payroll.employees.read**: Grant read-only access to
- **payroll.leaveapplications**: Grant read-write access to
- **payroll.leaveapplications.read**: Grant read-only access to
- **payroll.payitems**: Grant read-write access to
- **payroll.payitems.read**: Grant read-only access to
- **payroll.payrollcalendars**: Grant read-write access to
- **payroll.payrollcalendars.read**: Grant read-only access to
- **payroll.payruns**: Grant read-write access to
- **payroll.payruns.read**: Grant read-only access to
- **payroll.payslip**: Grant read-write access to
- **payroll.payslip.read**: Grant read-only access to
- **payroll.settings.read**: Grant read-only access to
- **payroll.superfunds**: Grant read-write access to
- **payroll.superfunds.read**: Grant read-only access to
- **payroll.superfundproducts.read**: Grant read-only access to
- **payroll.timesheets**: Grant read-write access to
- **payroll.timesheets.read**: Grant read-only access to
- **projects**: Grant read-write access to projects
- **projects.read**: Grant read-only access to projects


## Author

api@xero.com

