<?php
/**
 * AccountingApi
 * PHP version 5
 *
 * @category Class
 * @package  Xero2\Accounting
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Accounting API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: api@xero.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 4.2.3-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Xero2\Accounting\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Xero2\Accounting\ApiException;
use Xero2\Accounting\Configuration;
use Xero2\Accounting\HeaderSelector;
use Xero2\Accounting\ObjectSerializer;

/**
 * AccountingApi Class Doc Comment
 *
 * @category Class
 * @package  Xero2\Accounting
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class AccountingApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $host_index (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $host_index = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $host_index;
    }

    /**
     * Set the host index
     *
     * @param  int Host index (required)
     */
    public function setHostIndex($host_index)
    {
        $this->hostIndex = $host_index;
    }

    /**
     * Get the host index
     *
     * @return Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createAccount
     *
     * Allows you to create a new chart of accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Account $account Request of type Account (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Accounts|\Xero2\Accounting\Model\Error
     */
    public function createAccount($xero_tenant_id, $account)
    {
        list($response) = $this->createAccountWithHttpInfo($xero_tenant_id, $account);
        return $response;
    }

    /**
     * Operation createAccountWithHttpInfo
     *
     * Allows you to create a new chart of accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Account $account Request of type Account (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Accounts|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createAccountWithHttpInfo($xero_tenant_id, $account)
    {
        $request = $this->createAccountRequest($xero_tenant_id, $account);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Accounts' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Accounts', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Accounts';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Accounts',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createAccountAsync
     *
     * Allows you to create a new chart of accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Account $account Request of type Account (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAccountAsync($xero_tenant_id, $account)
    {
        return $this->createAccountAsyncWithHttpInfo($xero_tenant_id, $account)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createAccountAsyncWithHttpInfo
     *
     * Allows you to create a new chart of accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Account $account Request of type Account (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAccountAsyncWithHttpInfo($xero_tenant_id, $account)
    {
        $returnType = '\Xero2\Accounting\Model\Accounts';
        $request = $this->createAccountRequest($xero_tenant_id, $account);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createAccount'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Account $account Request of type Account (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createAccountRequest($xero_tenant_id, $account)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createAccount'
            );
        }
        // verify the required parameter 'account' is set
        if ($account === null || (is_array($account) && count($account) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $account when calling createAccount'
            );
        }

        $resourcePath = '/Accounts';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($account)) {
            $_tempBody = $account;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createAccountAttachmentByFileName
     *
     * Allows you to create Attachment on Account
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error
     */
    public function createAccountAttachmentByFileName($xero_tenant_id, $account_id, $file_name, $body)
    {
        list($response) = $this->createAccountAttachmentByFileNameWithHttpInfo($xero_tenant_id, $account_id, $file_name, $body);
        return $response;
    }

    /**
     * Operation createAccountAttachmentByFileNameWithHttpInfo
     *
     * Allows you to create Attachment on Account
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createAccountAttachmentByFileNameWithHttpInfo($xero_tenant_id, $account_id, $file_name, $body)
    {
        $request = $this->createAccountAttachmentByFileNameRequest($xero_tenant_id, $account_id, $file_name, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Attachments' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Attachments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Attachments';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Attachments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createAccountAttachmentByFileNameAsync
     *
     * Allows you to create Attachment on Account
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAccountAttachmentByFileNameAsync($xero_tenant_id, $account_id, $file_name, $body)
    {
        return $this->createAccountAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $account_id, $file_name, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createAccountAttachmentByFileNameAsyncWithHttpInfo
     *
     * Allows you to create Attachment on Account
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAccountAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $account_id, $file_name, $body)
    {
        $returnType = '\Xero2\Accounting\Model\Attachments';
        $request = $this->createAccountAttachmentByFileNameRequest($xero_tenant_id, $account_id, $file_name, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createAccountAttachmentByFileName'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createAccountAttachmentByFileNameRequest($xero_tenant_id, $account_id, $file_name, $body)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createAccountAttachmentByFileName'
            );
        }
        // verify the required parameter 'account_id' is set
        if ($account_id === null || (is_array($account_id) && count($account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $account_id when calling createAccountAttachmentByFileName'
            );
        }
        // verify the required parameter 'file_name' is set
        if ($file_name === null || (is_array($file_name) && count($file_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_name when calling createAccountAttachmentByFileName'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createAccountAttachmentByFileName'
            );
        }

        $resourcePath = '/Accounts/{AccountID}/Attachments/{FileName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                '{' . 'AccountID' . '}',
                ObjectSerializer::toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($file_name !== null) {
            $resourcePath = str_replace(
                '{' . 'FileName' . '}',
                ObjectSerializer::toPathValue($file_name),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/octet-stream']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createBankTransaction
     *
     * Allows you to create a single spend or receive money transaction
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BankTransaction $bank_transaction bank_transaction (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\BankTransactions|\Xero2\Accounting\Model\Error
     */
    public function createBankTransaction($xero_tenant_id, $bank_transaction)
    {
        list($response) = $this->createBankTransactionWithHttpInfo($xero_tenant_id, $bank_transaction);
        return $response;
    }

    /**
     * Operation createBankTransactionWithHttpInfo
     *
     * Allows you to create a single spend or receive money transaction
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BankTransaction $bank_transaction (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\BankTransactions|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBankTransactionWithHttpInfo($xero_tenant_id, $bank_transaction)
    {
        $request = $this->createBankTransactionRequest($xero_tenant_id, $bank_transaction);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\BankTransactions' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\BankTransactions', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\BankTransactions';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\BankTransactions',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createBankTransactionAsync
     *
     * Allows you to create a single spend or receive money transaction
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BankTransaction $bank_transaction (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBankTransactionAsync($xero_tenant_id, $bank_transaction)
    {
        return $this->createBankTransactionAsyncWithHttpInfo($xero_tenant_id, $bank_transaction)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createBankTransactionAsyncWithHttpInfo
     *
     * Allows you to create a single spend or receive money transaction
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BankTransaction $bank_transaction (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBankTransactionAsyncWithHttpInfo($xero_tenant_id, $bank_transaction)
    {
        $returnType = '\Xero2\Accounting\Model\BankTransactions';
        $request = $this->createBankTransactionRequest($xero_tenant_id, $bank_transaction);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createBankTransaction'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BankTransaction $bank_transaction (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createBankTransactionRequest($xero_tenant_id, $bank_transaction)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createBankTransaction'
            );
        }
        // verify the required parameter 'bank_transaction' is set
        if ($bank_transaction === null || (is_array($bank_transaction) && count($bank_transaction) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bank_transaction when calling createBankTransaction'
            );
        }

        $resourcePath = '/BankTransactions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($bank_transaction)) {
            $_tempBody = $bank_transaction;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createBankTransactionAttachmentByFileName
     *
     * Allows you to createa an Attachment on BankTransaction by Filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $file_name The name of the file being attached (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error
     */
    public function createBankTransactionAttachmentByFileName($xero_tenant_id, $bank_transaction_id, $file_name, $body)
    {
        list($response) = $this->createBankTransactionAttachmentByFileNameWithHttpInfo($xero_tenant_id, $bank_transaction_id, $file_name, $body);
        return $response;
    }

    /**
     * Operation createBankTransactionAttachmentByFileNameWithHttpInfo
     *
     * Allows you to createa an Attachment on BankTransaction by Filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $file_name The name of the file being attached (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBankTransactionAttachmentByFileNameWithHttpInfo($xero_tenant_id, $bank_transaction_id, $file_name, $body)
    {
        $request = $this->createBankTransactionAttachmentByFileNameRequest($xero_tenant_id, $bank_transaction_id, $file_name, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Attachments' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Attachments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Attachments';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Attachments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createBankTransactionAttachmentByFileNameAsync
     *
     * Allows you to createa an Attachment on BankTransaction by Filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $file_name The name of the file being attached (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBankTransactionAttachmentByFileNameAsync($xero_tenant_id, $bank_transaction_id, $file_name, $body)
    {
        return $this->createBankTransactionAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $bank_transaction_id, $file_name, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createBankTransactionAttachmentByFileNameAsyncWithHttpInfo
     *
     * Allows you to createa an Attachment on BankTransaction by Filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $file_name The name of the file being attached (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBankTransactionAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $bank_transaction_id, $file_name, $body)
    {
        $returnType = '\Xero2\Accounting\Model\Attachments';
        $request = $this->createBankTransactionAttachmentByFileNameRequest($xero_tenant_id, $bank_transaction_id, $file_name, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createBankTransactionAttachmentByFileName'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $file_name The name of the file being attached (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createBankTransactionAttachmentByFileNameRequest($xero_tenant_id, $bank_transaction_id, $file_name, $body)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createBankTransactionAttachmentByFileName'
            );
        }
        // verify the required parameter 'bank_transaction_id' is set
        if ($bank_transaction_id === null || (is_array($bank_transaction_id) && count($bank_transaction_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bank_transaction_id when calling createBankTransactionAttachmentByFileName'
            );
        }
        // verify the required parameter 'file_name' is set
        if ($file_name === null || (is_array($file_name) && count($file_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_name when calling createBankTransactionAttachmentByFileName'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createBankTransactionAttachmentByFileName'
            );
        }

        $resourcePath = '/BankTransactions/{BankTransactionID}/Attachments/{FileName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($bank_transaction_id !== null) {
            $resourcePath = str_replace(
                '{' . 'BankTransactionID' . '}',
                ObjectSerializer::toPathValue($bank_transaction_id),
                $resourcePath
            );
        }
        // path params
        if ($file_name !== null) {
            $resourcePath = str_replace(
                '{' . 'FileName' . '}',
                ObjectSerializer::toPathValue($file_name),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/octet-stream']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createBankTransactionHistoryRecord
     *
     * Allows you to create history record for a bank transactions
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records history_records (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error
     */
    public function createBankTransactionHistoryRecord($xero_tenant_id, $bank_transaction_id, $history_records)
    {
        list($response) = $this->createBankTransactionHistoryRecordWithHttpInfo($xero_tenant_id, $bank_transaction_id, $history_records);
        return $response;
    }

    /**
     * Operation createBankTransactionHistoryRecordWithHttpInfo
     *
     * Allows you to create history record for a bank transactions
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBankTransactionHistoryRecordWithHttpInfo($xero_tenant_id, $bank_transaction_id, $history_records)
    {
        $request = $this->createBankTransactionHistoryRecordRequest($xero_tenant_id, $bank_transaction_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createBankTransactionHistoryRecordAsync
     *
     * Allows you to create history record for a bank transactions
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBankTransactionHistoryRecordAsync($xero_tenant_id, $bank_transaction_id, $history_records)
    {
        return $this->createBankTransactionHistoryRecordAsyncWithHttpInfo($xero_tenant_id, $bank_transaction_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createBankTransactionHistoryRecordAsyncWithHttpInfo
     *
     * Allows you to create history record for a bank transactions
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBankTransactionHistoryRecordAsyncWithHttpInfo($xero_tenant_id, $bank_transaction_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createBankTransactionHistoryRecordRequest($xero_tenant_id, $bank_transaction_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createBankTransactionHistoryRecord'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createBankTransactionHistoryRecordRequest($xero_tenant_id, $bank_transaction_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createBankTransactionHistoryRecord'
            );
        }
        // verify the required parameter 'bank_transaction_id' is set
        if ($bank_transaction_id === null || (is_array($bank_transaction_id) && count($bank_transaction_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bank_transaction_id when calling createBankTransactionHistoryRecord'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createBankTransactionHistoryRecord'
            );
        }

        $resourcePath = '/BankTransactions/{BankTransactionID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($bank_transaction_id !== null) {
            $resourcePath = str_replace(
                '{' . 'BankTransactionID' . '}',
                ObjectSerializer::toPathValue($bank_transaction_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($history_records)) {
            $_tempBody = $history_records;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createBankTransactions
     *
     * Allows you to create a spend or receive money transaction
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BankTransactions $bank_transactions bank_transactions (required)
     * @param  bool $summarize_errors response format that shows validation errors for each bank transaction (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\BankTransactions|\Xero2\Accounting\Model\Error
     */
    public function createBankTransactions($xero_tenant_id, $bank_transactions, $summarize_errors = false)
    {
        list($response) = $this->createBankTransactionsWithHttpInfo($xero_tenant_id, $bank_transactions, $summarize_errors);
        return $response;
    }

    /**
     * Operation createBankTransactionsWithHttpInfo
     *
     * Allows you to create a spend or receive money transaction
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BankTransactions $bank_transactions (required)
     * @param  bool $summarize_errors response format that shows validation errors for each bank transaction (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\BankTransactions|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBankTransactionsWithHttpInfo($xero_tenant_id, $bank_transactions, $summarize_errors = false)
    {
        $request = $this->createBankTransactionsRequest($xero_tenant_id, $bank_transactions, $summarize_errors);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\BankTransactions' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\BankTransactions', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\BankTransactions';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\BankTransactions',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createBankTransactionsAsync
     *
     * Allows you to create a spend or receive money transaction
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BankTransactions $bank_transactions (required)
     * @param  bool $summarize_errors response format that shows validation errors for each bank transaction (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBankTransactionsAsync($xero_tenant_id, $bank_transactions, $summarize_errors = false)
    {
        return $this->createBankTransactionsAsyncWithHttpInfo($xero_tenant_id, $bank_transactions, $summarize_errors)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createBankTransactionsAsyncWithHttpInfo
     *
     * Allows you to create a spend or receive money transaction
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BankTransactions $bank_transactions (required)
     * @param  bool $summarize_errors response format that shows validation errors for each bank transaction (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBankTransactionsAsyncWithHttpInfo($xero_tenant_id, $bank_transactions, $summarize_errors = false)
    {
        $returnType = '\Xero2\Accounting\Model\BankTransactions';
        $request = $this->createBankTransactionsRequest($xero_tenant_id, $bank_transactions, $summarize_errors);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createBankTransactions'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BankTransactions $bank_transactions (required)
     * @param  bool $summarize_errors response format that shows validation errors for each bank transaction (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createBankTransactionsRequest($xero_tenant_id, $bank_transactions, $summarize_errors = false)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createBankTransactions'
            );
        }
        // verify the required parameter 'bank_transactions' is set
        if ($bank_transactions === null || (is_array($bank_transactions) && count($bank_transactions) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bank_transactions when calling createBankTransactions'
            );
        }

        $resourcePath = '/BankTransactions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($summarize_errors !== null) {
            $queryParams['summarizeErrors'] = ObjectSerializer::toQueryValue($summarize_errors);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($bank_transactions)) {
            $_tempBody = $bank_transactions;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createBankTransfer
     *
     * Allows you to create a bank transfers
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BankTransfers $bank_transfers bank_transfers (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\BankTransfers|\Xero2\Accounting\Model\Error
     */
    public function createBankTransfer($xero_tenant_id, $bank_transfers)
    {
        list($response) = $this->createBankTransferWithHttpInfo($xero_tenant_id, $bank_transfers);
        return $response;
    }

    /**
     * Operation createBankTransferWithHttpInfo
     *
     * Allows you to create a bank transfers
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BankTransfers $bank_transfers (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\BankTransfers|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBankTransferWithHttpInfo($xero_tenant_id, $bank_transfers)
    {
        $request = $this->createBankTransferRequest($xero_tenant_id, $bank_transfers);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\BankTransfers' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\BankTransfers', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\BankTransfers';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\BankTransfers',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createBankTransferAsync
     *
     * Allows you to create a bank transfers
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BankTransfers $bank_transfers (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBankTransferAsync($xero_tenant_id, $bank_transfers)
    {
        return $this->createBankTransferAsyncWithHttpInfo($xero_tenant_id, $bank_transfers)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createBankTransferAsyncWithHttpInfo
     *
     * Allows you to create a bank transfers
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BankTransfers $bank_transfers (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBankTransferAsyncWithHttpInfo($xero_tenant_id, $bank_transfers)
    {
        $returnType = '\Xero2\Accounting\Model\BankTransfers';
        $request = $this->createBankTransferRequest($xero_tenant_id, $bank_transfers);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createBankTransfer'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BankTransfers $bank_transfers (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createBankTransferRequest($xero_tenant_id, $bank_transfers)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createBankTransfer'
            );
        }
        // verify the required parameter 'bank_transfers' is set
        if ($bank_transfers === null || (is_array($bank_transfers) && count($bank_transfers) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bank_transfers when calling createBankTransfer'
            );
        }

        $resourcePath = '/BankTransfers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($bank_transfers)) {
            $_tempBody = $bank_transfers;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createBankTransferAttachmentByFileName
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  string $file_name The name of the file being attached to a Bank Transfer (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error
     */
    public function createBankTransferAttachmentByFileName($xero_tenant_id, $bank_transfer_id, $file_name, $body)
    {
        list($response) = $this->createBankTransferAttachmentByFileNameWithHttpInfo($xero_tenant_id, $bank_transfer_id, $file_name, $body);
        return $response;
    }

    /**
     * Operation createBankTransferAttachmentByFileNameWithHttpInfo
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  string $file_name The name of the file being attached to a Bank Transfer (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBankTransferAttachmentByFileNameWithHttpInfo($xero_tenant_id, $bank_transfer_id, $file_name, $body)
    {
        $request = $this->createBankTransferAttachmentByFileNameRequest($xero_tenant_id, $bank_transfer_id, $file_name, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Attachments' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Attachments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Attachments';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Attachments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createBankTransferAttachmentByFileNameAsync
     *
     * 
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  string $file_name The name of the file being attached to a Bank Transfer (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBankTransferAttachmentByFileNameAsync($xero_tenant_id, $bank_transfer_id, $file_name, $body)
    {
        return $this->createBankTransferAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $bank_transfer_id, $file_name, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createBankTransferAttachmentByFileNameAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  string $file_name The name of the file being attached to a Bank Transfer (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBankTransferAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $bank_transfer_id, $file_name, $body)
    {
        $returnType = '\Xero2\Accounting\Model\Attachments';
        $request = $this->createBankTransferAttachmentByFileNameRequest($xero_tenant_id, $bank_transfer_id, $file_name, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createBankTransferAttachmentByFileName'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  string $file_name The name of the file being attached to a Bank Transfer (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createBankTransferAttachmentByFileNameRequest($xero_tenant_id, $bank_transfer_id, $file_name, $body)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createBankTransferAttachmentByFileName'
            );
        }
        // verify the required parameter 'bank_transfer_id' is set
        if ($bank_transfer_id === null || (is_array($bank_transfer_id) && count($bank_transfer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bank_transfer_id when calling createBankTransferAttachmentByFileName'
            );
        }
        // verify the required parameter 'file_name' is set
        if ($file_name === null || (is_array($file_name) && count($file_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_name when calling createBankTransferAttachmentByFileName'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createBankTransferAttachmentByFileName'
            );
        }

        $resourcePath = '/BankTransfers/{BankTransferID}/Attachments/{FileName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($bank_transfer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'BankTransferID' . '}',
                ObjectSerializer::toPathValue($bank_transfer_id),
                $resourcePath
            );
        }
        // path params
        if ($file_name !== null) {
            $resourcePath = str_replace(
                '{' . 'FileName' . '}',
                ObjectSerializer::toPathValue($file_name),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/octet-stream']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createBankTransferHistoryRecord
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records history_records (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error
     */
    public function createBankTransferHistoryRecord($xero_tenant_id, $bank_transfer_id, $history_records)
    {
        list($response) = $this->createBankTransferHistoryRecordWithHttpInfo($xero_tenant_id, $bank_transfer_id, $history_records);
        return $response;
    }

    /**
     * Operation createBankTransferHistoryRecordWithHttpInfo
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBankTransferHistoryRecordWithHttpInfo($xero_tenant_id, $bank_transfer_id, $history_records)
    {
        $request = $this->createBankTransferHistoryRecordRequest($xero_tenant_id, $bank_transfer_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createBankTransferHistoryRecordAsync
     *
     * 
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBankTransferHistoryRecordAsync($xero_tenant_id, $bank_transfer_id, $history_records)
    {
        return $this->createBankTransferHistoryRecordAsyncWithHttpInfo($xero_tenant_id, $bank_transfer_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createBankTransferHistoryRecordAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBankTransferHistoryRecordAsyncWithHttpInfo($xero_tenant_id, $bank_transfer_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createBankTransferHistoryRecordRequest($xero_tenant_id, $bank_transfer_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createBankTransferHistoryRecord'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createBankTransferHistoryRecordRequest($xero_tenant_id, $bank_transfer_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createBankTransferHistoryRecord'
            );
        }
        // verify the required parameter 'bank_transfer_id' is set
        if ($bank_transfer_id === null || (is_array($bank_transfer_id) && count($bank_transfer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bank_transfer_id when calling createBankTransferHistoryRecord'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createBankTransferHistoryRecord'
            );
        }

        $resourcePath = '/BankTransfers/{BankTransferID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($bank_transfer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'BankTransferID' . '}',
                ObjectSerializer::toPathValue($bank_transfer_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($history_records)) {
            $_tempBody = $history_records;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createBatchPayment
     *
     * Create one or many BatchPayments for invoices
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BatchPayments $batch_payments Request of type BatchPayments containing a Payments array with one or more Payment objects (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\BatchPayments|\Xero2\Accounting\Model\Error
     */
    public function createBatchPayment($xero_tenant_id, $batch_payments)
    {
        list($response) = $this->createBatchPaymentWithHttpInfo($xero_tenant_id, $batch_payments);
        return $response;
    }

    /**
     * Operation createBatchPaymentWithHttpInfo
     *
     * Create one or many BatchPayments for invoices
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BatchPayments $batch_payments Request of type BatchPayments containing a Payments array with one or more Payment objects (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\BatchPayments|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBatchPaymentWithHttpInfo($xero_tenant_id, $batch_payments)
    {
        $request = $this->createBatchPaymentRequest($xero_tenant_id, $batch_payments);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\BatchPayments' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\BatchPayments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\BatchPayments';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\BatchPayments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createBatchPaymentAsync
     *
     * Create one or many BatchPayments for invoices
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BatchPayments $batch_payments Request of type BatchPayments containing a Payments array with one or more Payment objects (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBatchPaymentAsync($xero_tenant_id, $batch_payments)
    {
        return $this->createBatchPaymentAsyncWithHttpInfo($xero_tenant_id, $batch_payments)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createBatchPaymentAsyncWithHttpInfo
     *
     * Create one or many BatchPayments for invoices
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BatchPayments $batch_payments Request of type BatchPayments containing a Payments array with one or more Payment objects (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBatchPaymentAsyncWithHttpInfo($xero_tenant_id, $batch_payments)
    {
        $returnType = '\Xero2\Accounting\Model\BatchPayments';
        $request = $this->createBatchPaymentRequest($xero_tenant_id, $batch_payments);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createBatchPayment'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\BatchPayments $batch_payments Request of type BatchPayments containing a Payments array with one or more Payment objects (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createBatchPaymentRequest($xero_tenant_id, $batch_payments)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createBatchPayment'
            );
        }
        // verify the required parameter 'batch_payments' is set
        if ($batch_payments === null || (is_array($batch_payments) && count($batch_payments) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_payments when calling createBatchPayment'
            );
        }

        $resourcePath = '/BatchPayments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($batch_payments)) {
            $_tempBody = $batch_payments;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createBatchPaymentHistoryRecord
     *
     * Allows you to create a history record for a Batch Payment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $batch_payment_id Unique identifier for BatchPayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records history_records (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error
     */
    public function createBatchPaymentHistoryRecord($xero_tenant_id, $batch_payment_id, $history_records)
    {
        list($response) = $this->createBatchPaymentHistoryRecordWithHttpInfo($xero_tenant_id, $batch_payment_id, $history_records);
        return $response;
    }

    /**
     * Operation createBatchPaymentHistoryRecordWithHttpInfo
     *
     * Allows you to create a history record for a Batch Payment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $batch_payment_id Unique identifier for BatchPayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBatchPaymentHistoryRecordWithHttpInfo($xero_tenant_id, $batch_payment_id, $history_records)
    {
        $request = $this->createBatchPaymentHistoryRecordRequest($xero_tenant_id, $batch_payment_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createBatchPaymentHistoryRecordAsync
     *
     * Allows you to create a history record for a Batch Payment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $batch_payment_id Unique identifier for BatchPayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBatchPaymentHistoryRecordAsync($xero_tenant_id, $batch_payment_id, $history_records)
    {
        return $this->createBatchPaymentHistoryRecordAsyncWithHttpInfo($xero_tenant_id, $batch_payment_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createBatchPaymentHistoryRecordAsyncWithHttpInfo
     *
     * Allows you to create a history record for a Batch Payment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $batch_payment_id Unique identifier for BatchPayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBatchPaymentHistoryRecordAsyncWithHttpInfo($xero_tenant_id, $batch_payment_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createBatchPaymentHistoryRecordRequest($xero_tenant_id, $batch_payment_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createBatchPaymentHistoryRecord'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $batch_payment_id Unique identifier for BatchPayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createBatchPaymentHistoryRecordRequest($xero_tenant_id, $batch_payment_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createBatchPaymentHistoryRecord'
            );
        }
        // verify the required parameter 'batch_payment_id' is set
        if ($batch_payment_id === null || (is_array($batch_payment_id) && count($batch_payment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_payment_id when calling createBatchPaymentHistoryRecord'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createBatchPaymentHistoryRecord'
            );
        }

        $resourcePath = '/BatchPayments/{BatchPaymentID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($batch_payment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'BatchPaymentID' . '}',
                ObjectSerializer::toPathValue($batch_payment_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($history_records)) {
            $_tempBody = $history_records;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createBrandingThemePaymentServices
     *
     * Allow for the creation of new custom payment service for specified Branding Theme
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $branding_theme_id Unique identifier for a Branding Theme (required)
     * @param  \Xero2\Accounting\Model\PaymentService $payment_service payment_service (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\PaymentServices|\Xero2\Accounting\Model\Error
     */
    public function createBrandingThemePaymentServices($xero_tenant_id, $branding_theme_id, $payment_service)
    {
        list($response) = $this->createBrandingThemePaymentServicesWithHttpInfo($xero_tenant_id, $branding_theme_id, $payment_service);
        return $response;
    }

    /**
     * Operation createBrandingThemePaymentServicesWithHttpInfo
     *
     * Allow for the creation of new custom payment service for specified Branding Theme
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $branding_theme_id Unique identifier for a Branding Theme (required)
     * @param  \Xero2\Accounting\Model\PaymentService $payment_service (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\PaymentServices|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBrandingThemePaymentServicesWithHttpInfo($xero_tenant_id, $branding_theme_id, $payment_service)
    {
        $request = $this->createBrandingThemePaymentServicesRequest($xero_tenant_id, $branding_theme_id, $payment_service);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\PaymentServices' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\PaymentServices', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\PaymentServices';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\PaymentServices',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createBrandingThemePaymentServicesAsync
     *
     * Allow for the creation of new custom payment service for specified Branding Theme
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $branding_theme_id Unique identifier for a Branding Theme (required)
     * @param  \Xero2\Accounting\Model\PaymentService $payment_service (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBrandingThemePaymentServicesAsync($xero_tenant_id, $branding_theme_id, $payment_service)
    {
        return $this->createBrandingThemePaymentServicesAsyncWithHttpInfo($xero_tenant_id, $branding_theme_id, $payment_service)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createBrandingThemePaymentServicesAsyncWithHttpInfo
     *
     * Allow for the creation of new custom payment service for specified Branding Theme
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $branding_theme_id Unique identifier for a Branding Theme (required)
     * @param  \Xero2\Accounting\Model\PaymentService $payment_service (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBrandingThemePaymentServicesAsyncWithHttpInfo($xero_tenant_id, $branding_theme_id, $payment_service)
    {
        $returnType = '\Xero2\Accounting\Model\PaymentServices';
        $request = $this->createBrandingThemePaymentServicesRequest($xero_tenant_id, $branding_theme_id, $payment_service);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createBrandingThemePaymentServices'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $branding_theme_id Unique identifier for a Branding Theme (required)
     * @param  \Xero2\Accounting\Model\PaymentService $payment_service (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createBrandingThemePaymentServicesRequest($xero_tenant_id, $branding_theme_id, $payment_service)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createBrandingThemePaymentServices'
            );
        }
        // verify the required parameter 'branding_theme_id' is set
        if ($branding_theme_id === null || (is_array($branding_theme_id) && count($branding_theme_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $branding_theme_id when calling createBrandingThemePaymentServices'
            );
        }
        // verify the required parameter 'payment_service' is set
        if ($payment_service === null || (is_array($payment_service) && count($payment_service) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payment_service when calling createBrandingThemePaymentServices'
            );
        }

        $resourcePath = '/BrandingThemes/{BrandingThemeID}/PaymentServices';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($branding_theme_id !== null) {
            $resourcePath = str_replace(
                '{' . 'BrandingThemeID' . '}',
                ObjectSerializer::toPathValue($branding_theme_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($payment_service)) {
            $_tempBody = $payment_service;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createContact
     *
     * Allows you to create a single contact in a Xero organisation
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Contact $contact contact (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Contacts|\Xero2\Accounting\Model\Error
     */
    public function createContact($xero_tenant_id, $contact)
    {
        list($response) = $this->createContactWithHttpInfo($xero_tenant_id, $contact);
        return $response;
    }

    /**
     * Operation createContactWithHttpInfo
     *
     * Allows you to create a single contact in a Xero organisation
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Contact $contact (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Contacts|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createContactWithHttpInfo($xero_tenant_id, $contact)
    {
        $request = $this->createContactRequest($xero_tenant_id, $contact);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Contacts' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Contacts', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Contacts';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Contacts',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createContactAsync
     *
     * Allows you to create a single contact in a Xero organisation
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Contact $contact (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createContactAsync($xero_tenant_id, $contact)
    {
        return $this->createContactAsyncWithHttpInfo($xero_tenant_id, $contact)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createContactAsyncWithHttpInfo
     *
     * Allows you to create a single contact in a Xero organisation
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Contact $contact (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createContactAsyncWithHttpInfo($xero_tenant_id, $contact)
    {
        $returnType = '\Xero2\Accounting\Model\Contacts';
        $request = $this->createContactRequest($xero_tenant_id, $contact);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createContact'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Contact $contact (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createContactRequest($xero_tenant_id, $contact)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createContact'
            );
        }
        // verify the required parameter 'contact' is set
        if ($contact === null || (is_array($contact) && count($contact) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $contact when calling createContact'
            );
        }

        $resourcePath = '/Contacts';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($contact)) {
            $_tempBody = $contact;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createContactAttachmentByFileName
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     * @param  string $file_name Name for the file you are attaching (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error
     */
    public function createContactAttachmentByFileName($xero_tenant_id, $contact_id, $file_name, $body)
    {
        list($response) = $this->createContactAttachmentByFileNameWithHttpInfo($xero_tenant_id, $contact_id, $file_name, $body);
        return $response;
    }

    /**
     * Operation createContactAttachmentByFileNameWithHttpInfo
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     * @param  string $file_name Name for the file you are attaching (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createContactAttachmentByFileNameWithHttpInfo($xero_tenant_id, $contact_id, $file_name, $body)
    {
        $request = $this->createContactAttachmentByFileNameRequest($xero_tenant_id, $contact_id, $file_name, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Attachments' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Attachments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Attachments';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Attachments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createContactAttachmentByFileNameAsync
     *
     * 
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     * @param  string $file_name Name for the file you are attaching (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createContactAttachmentByFileNameAsync($xero_tenant_id, $contact_id, $file_name, $body)
    {
        return $this->createContactAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $contact_id, $file_name, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createContactAttachmentByFileNameAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     * @param  string $file_name Name for the file you are attaching (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createContactAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $contact_id, $file_name, $body)
    {
        $returnType = '\Xero2\Accounting\Model\Attachments';
        $request = $this->createContactAttachmentByFileNameRequest($xero_tenant_id, $contact_id, $file_name, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createContactAttachmentByFileName'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     * @param  string $file_name Name for the file you are attaching (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createContactAttachmentByFileNameRequest($xero_tenant_id, $contact_id, $file_name, $body)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createContactAttachmentByFileName'
            );
        }
        // verify the required parameter 'contact_id' is set
        if ($contact_id === null || (is_array($contact_id) && count($contact_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $contact_id when calling createContactAttachmentByFileName'
            );
        }
        // verify the required parameter 'file_name' is set
        if ($file_name === null || (is_array($file_name) && count($file_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_name when calling createContactAttachmentByFileName'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createContactAttachmentByFileName'
            );
        }

        $resourcePath = '/Contacts/{ContactID}/Attachments/{FileName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($contact_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ContactID' . '}',
                ObjectSerializer::toPathValue($contact_id),
                $resourcePath
            );
        }
        // path params
        if ($file_name !== null) {
            $resourcePath = str_replace(
                '{' . 'FileName' . '}',
                ObjectSerializer::toPathValue($file_name),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/octet-stream']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createContactGroup
     *
     * Allows you to create a contact group
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ContactGroups $contact_groups an array of contact groups with names specified (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\ContactGroups|\Xero2\Accounting\Model\Error
     */
    public function createContactGroup($xero_tenant_id, $contact_groups)
    {
        list($response) = $this->createContactGroupWithHttpInfo($xero_tenant_id, $contact_groups);
        return $response;
    }

    /**
     * Operation createContactGroupWithHttpInfo
     *
     * Allows you to create a contact group
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ContactGroups $contact_groups an array of contact groups with names specified (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\ContactGroups|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createContactGroupWithHttpInfo($xero_tenant_id, $contact_groups)
    {
        $request = $this->createContactGroupRequest($xero_tenant_id, $contact_groups);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\ContactGroups' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\ContactGroups', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\ContactGroups';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\ContactGroups',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createContactGroupAsync
     *
     * Allows you to create a contact group
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ContactGroups $contact_groups an array of contact groups with names specified (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createContactGroupAsync($xero_tenant_id, $contact_groups)
    {
        return $this->createContactGroupAsyncWithHttpInfo($xero_tenant_id, $contact_groups)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createContactGroupAsyncWithHttpInfo
     *
     * Allows you to create a contact group
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ContactGroups $contact_groups an array of contact groups with names specified (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createContactGroupAsyncWithHttpInfo($xero_tenant_id, $contact_groups)
    {
        $returnType = '\Xero2\Accounting\Model\ContactGroups';
        $request = $this->createContactGroupRequest($xero_tenant_id, $contact_groups);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createContactGroup'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ContactGroups $contact_groups an array of contact groups with names specified (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createContactGroupRequest($xero_tenant_id, $contact_groups)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createContactGroup'
            );
        }
        // verify the required parameter 'contact_groups' is set
        if ($contact_groups === null || (is_array($contact_groups) && count($contact_groups) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $contact_groups when calling createContactGroup'
            );
        }

        $resourcePath = '/ContactGroups';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($contact_groups)) {
            $_tempBody = $contact_groups;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createContactGroupContacts
     *
     * Allows you to add Contacts to a Contract Group
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     * @param  \Xero2\Accounting\Model\Contacts $contacts an array of contacts with ContactID to be added to ContactGroup (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Contacts|\Xero2\Accounting\Model\Error
     */
    public function createContactGroupContacts($xero_tenant_id, $contact_group_id, $contacts)
    {
        list($response) = $this->createContactGroupContactsWithHttpInfo($xero_tenant_id, $contact_group_id, $contacts);
        return $response;
    }

    /**
     * Operation createContactGroupContactsWithHttpInfo
     *
     * Allows you to add Contacts to a Contract Group
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     * @param  \Xero2\Accounting\Model\Contacts $contacts an array of contacts with ContactID to be added to ContactGroup (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Contacts|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createContactGroupContactsWithHttpInfo($xero_tenant_id, $contact_group_id, $contacts)
    {
        $request = $this->createContactGroupContactsRequest($xero_tenant_id, $contact_group_id, $contacts);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Contacts' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Contacts', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Contacts';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Contacts',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createContactGroupContactsAsync
     *
     * Allows you to add Contacts to a Contract Group
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     * @param  \Xero2\Accounting\Model\Contacts $contacts an array of contacts with ContactID to be added to ContactGroup (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createContactGroupContactsAsync($xero_tenant_id, $contact_group_id, $contacts)
    {
        return $this->createContactGroupContactsAsyncWithHttpInfo($xero_tenant_id, $contact_group_id, $contacts)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createContactGroupContactsAsyncWithHttpInfo
     *
     * Allows you to add Contacts to a Contract Group
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     * @param  \Xero2\Accounting\Model\Contacts $contacts an array of contacts with ContactID to be added to ContactGroup (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createContactGroupContactsAsyncWithHttpInfo($xero_tenant_id, $contact_group_id, $contacts)
    {
        $returnType = '\Xero2\Accounting\Model\Contacts';
        $request = $this->createContactGroupContactsRequest($xero_tenant_id, $contact_group_id, $contacts);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createContactGroupContacts'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     * @param  \Xero2\Accounting\Model\Contacts $contacts an array of contacts with ContactID to be added to ContactGroup (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createContactGroupContactsRequest($xero_tenant_id, $contact_group_id, $contacts)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createContactGroupContacts'
            );
        }
        // verify the required parameter 'contact_group_id' is set
        if ($contact_group_id === null || (is_array($contact_group_id) && count($contact_group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $contact_group_id when calling createContactGroupContacts'
            );
        }
        // verify the required parameter 'contacts' is set
        if ($contacts === null || (is_array($contacts) && count($contacts) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $contacts when calling createContactGroupContacts'
            );
        }

        $resourcePath = '/ContactGroups/{ContactGroupID}/Contacts';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($contact_group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ContactGroupID' . '}',
                ObjectSerializer::toPathValue($contact_group_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($contacts)) {
            $_tempBody = $contacts;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createContactHistory
     *
     * Allows you to retrieve a history records of an Contact
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records history_records (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error
     */
    public function createContactHistory($xero_tenant_id, $contact_id, $history_records)
    {
        list($response) = $this->createContactHistoryWithHttpInfo($xero_tenant_id, $contact_id, $history_records);
        return $response;
    }

    /**
     * Operation createContactHistoryWithHttpInfo
     *
     * Allows you to retrieve a history records of an Contact
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createContactHistoryWithHttpInfo($xero_tenant_id, $contact_id, $history_records)
    {
        $request = $this->createContactHistoryRequest($xero_tenant_id, $contact_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createContactHistoryAsync
     *
     * Allows you to retrieve a history records of an Contact
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createContactHistoryAsync($xero_tenant_id, $contact_id, $history_records)
    {
        return $this->createContactHistoryAsyncWithHttpInfo($xero_tenant_id, $contact_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createContactHistoryAsyncWithHttpInfo
     *
     * Allows you to retrieve a history records of an Contact
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createContactHistoryAsyncWithHttpInfo($xero_tenant_id, $contact_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createContactHistoryRequest($xero_tenant_id, $contact_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createContactHistory'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createContactHistoryRequest($xero_tenant_id, $contact_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createContactHistory'
            );
        }
        // verify the required parameter 'contact_id' is set
        if ($contact_id === null || (is_array($contact_id) && count($contact_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $contact_id when calling createContactHistory'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createContactHistory'
            );
        }

        $resourcePath = '/Contacts/{ContactID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($contact_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ContactID' . '}',
                ObjectSerializer::toPathValue($contact_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($history_records)) {
            $_tempBody = $history_records;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createContacts
     *
     * Allows you to create a multiple contacts (bulk) in a Xero organisation
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Contacts $contacts contacts (required)
     * @param  bool $summarize_errors response format that shows validation errors for each bank transaction (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Contacts|\Xero2\Accounting\Model\Error
     */
    public function createContacts($xero_tenant_id, $contacts, $summarize_errors = false)
    {
        list($response) = $this->createContactsWithHttpInfo($xero_tenant_id, $contacts, $summarize_errors);
        return $response;
    }

    /**
     * Operation createContactsWithHttpInfo
     *
     * Allows you to create a multiple contacts (bulk) in a Xero organisation
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Contacts $contacts (required)
     * @param  bool $summarize_errors response format that shows validation errors for each bank transaction (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Contacts|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createContactsWithHttpInfo($xero_tenant_id, $contacts, $summarize_errors = false)
    {
        $request = $this->createContactsRequest($xero_tenant_id, $contacts, $summarize_errors);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Contacts' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Contacts', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Contacts';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Contacts',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createContactsAsync
     *
     * Allows you to create a multiple contacts (bulk) in a Xero organisation
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Contacts $contacts (required)
     * @param  bool $summarize_errors response format that shows validation errors for each bank transaction (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createContactsAsync($xero_tenant_id, $contacts, $summarize_errors = false)
    {
        return $this->createContactsAsyncWithHttpInfo($xero_tenant_id, $contacts, $summarize_errors)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createContactsAsyncWithHttpInfo
     *
     * Allows you to create a multiple contacts (bulk) in a Xero organisation
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Contacts $contacts (required)
     * @param  bool $summarize_errors response format that shows validation errors for each bank transaction (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createContactsAsyncWithHttpInfo($xero_tenant_id, $contacts, $summarize_errors = false)
    {
        $returnType = '\Xero2\Accounting\Model\Contacts';
        $request = $this->createContactsRequest($xero_tenant_id, $contacts, $summarize_errors);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createContacts'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Contacts $contacts (required)
     * @param  bool $summarize_errors response format that shows validation errors for each bank transaction (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createContactsRequest($xero_tenant_id, $contacts, $summarize_errors = false)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createContacts'
            );
        }
        // verify the required parameter 'contacts' is set
        if ($contacts === null || (is_array($contacts) && count($contacts) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $contacts when calling createContacts'
            );
        }

        $resourcePath = '/Contacts';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($summarize_errors !== null) {
            $queryParams['summarizeErrors'] = ObjectSerializer::toQueryValue($summarize_errors);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($contacts)) {
            $_tempBody = $contacts;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createCreditNote
     *
     * Allows you to create a single credit note
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\CreditNote $credit_note an array of Credit Notes with a single CreditNote object. (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\CreditNotes|\Xero2\Accounting\Model\Error
     */
    public function createCreditNote($xero_tenant_id, $credit_note)
    {
        list($response) = $this->createCreditNoteWithHttpInfo($xero_tenant_id, $credit_note);
        return $response;
    }

    /**
     * Operation createCreditNoteWithHttpInfo
     *
     * Allows you to create a single credit note
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\CreditNote $credit_note an array of Credit Notes with a single CreditNote object. (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\CreditNotes|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCreditNoteWithHttpInfo($xero_tenant_id, $credit_note)
    {
        $request = $this->createCreditNoteRequest($xero_tenant_id, $credit_note);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\CreditNotes' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\CreditNotes', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\CreditNotes';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\CreditNotes',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createCreditNoteAsync
     *
     * Allows you to create a single credit note
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\CreditNote $credit_note an array of Credit Notes with a single CreditNote object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCreditNoteAsync($xero_tenant_id, $credit_note)
    {
        return $this->createCreditNoteAsyncWithHttpInfo($xero_tenant_id, $credit_note)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createCreditNoteAsyncWithHttpInfo
     *
     * Allows you to create a single credit note
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\CreditNote $credit_note an array of Credit Notes with a single CreditNote object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCreditNoteAsyncWithHttpInfo($xero_tenant_id, $credit_note)
    {
        $returnType = '\Xero2\Accounting\Model\CreditNotes';
        $request = $this->createCreditNoteRequest($xero_tenant_id, $credit_note);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createCreditNote'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\CreditNote $credit_note an array of Credit Notes with a single CreditNote object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createCreditNoteRequest($xero_tenant_id, $credit_note)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createCreditNote'
            );
        }
        // verify the required parameter 'credit_note' is set
        if ($credit_note === null || (is_array($credit_note) && count($credit_note) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $credit_note when calling createCreditNote'
            );
        }

        $resourcePath = '/CreditNotes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($credit_note)) {
            $_tempBody = $credit_note;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createCreditNoteAllocation
     *
     * Allows you to create Allocation on CreditNote
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations an array of Allocations with single Allocation object defined. (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Allocations|\Xero2\Accounting\Model\Error
     */
    public function createCreditNoteAllocation($xero_tenant_id, $credit_note_id, $allocations)
    {
        list($response) = $this->createCreditNoteAllocationWithHttpInfo($xero_tenant_id, $credit_note_id, $allocations);
        return $response;
    }

    /**
     * Operation createCreditNoteAllocationWithHttpInfo
     *
     * Allows you to create Allocation on CreditNote
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations an array of Allocations with single Allocation object defined. (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Allocations|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCreditNoteAllocationWithHttpInfo($xero_tenant_id, $credit_note_id, $allocations)
    {
        $request = $this->createCreditNoteAllocationRequest($xero_tenant_id, $credit_note_id, $allocations);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Allocations' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Allocations', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Allocations';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Allocations',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createCreditNoteAllocationAsync
     *
     * Allows you to create Allocation on CreditNote
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations an array of Allocations with single Allocation object defined. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCreditNoteAllocationAsync($xero_tenant_id, $credit_note_id, $allocations)
    {
        return $this->createCreditNoteAllocationAsyncWithHttpInfo($xero_tenant_id, $credit_note_id, $allocations)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createCreditNoteAllocationAsyncWithHttpInfo
     *
     * Allows you to create Allocation on CreditNote
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations an array of Allocations with single Allocation object defined. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCreditNoteAllocationAsyncWithHttpInfo($xero_tenant_id, $credit_note_id, $allocations)
    {
        $returnType = '\Xero2\Accounting\Model\Allocations';
        $request = $this->createCreditNoteAllocationRequest($xero_tenant_id, $credit_note_id, $allocations);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createCreditNoteAllocation'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations an array of Allocations with single Allocation object defined. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createCreditNoteAllocationRequest($xero_tenant_id, $credit_note_id, $allocations)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createCreditNoteAllocation'
            );
        }
        // verify the required parameter 'credit_note_id' is set
        if ($credit_note_id === null || (is_array($credit_note_id) && count($credit_note_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $credit_note_id when calling createCreditNoteAllocation'
            );
        }
        // verify the required parameter 'allocations' is set
        if ($allocations === null || (is_array($allocations) && count($allocations) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $allocations when calling createCreditNoteAllocation'
            );
        }

        $resourcePath = '/CreditNotes/{CreditNoteID}/Allocations';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($credit_note_id !== null) {
            $resourcePath = str_replace(
                '{' . 'CreditNoteID' . '}',
                ObjectSerializer::toPathValue($credit_note_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($allocations)) {
            $_tempBody = $allocations;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createCreditNoteAttachmentByFileName
     *
     * Allows you to create Attachments on CreditNote by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  string $file_name Name of the file you are attaching to Credit Note (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error
     */
    public function createCreditNoteAttachmentByFileName($xero_tenant_id, $credit_note_id, $file_name, $body)
    {
        list($response) = $this->createCreditNoteAttachmentByFileNameWithHttpInfo($xero_tenant_id, $credit_note_id, $file_name, $body);
        return $response;
    }

    /**
     * Operation createCreditNoteAttachmentByFileNameWithHttpInfo
     *
     * Allows you to create Attachments on CreditNote by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  string $file_name Name of the file you are attaching to Credit Note (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCreditNoteAttachmentByFileNameWithHttpInfo($xero_tenant_id, $credit_note_id, $file_name, $body)
    {
        $request = $this->createCreditNoteAttachmentByFileNameRequest($xero_tenant_id, $credit_note_id, $file_name, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Attachments' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Attachments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Attachments';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Attachments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createCreditNoteAttachmentByFileNameAsync
     *
     * Allows you to create Attachments on CreditNote by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  string $file_name Name of the file you are attaching to Credit Note (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCreditNoteAttachmentByFileNameAsync($xero_tenant_id, $credit_note_id, $file_name, $body)
    {
        return $this->createCreditNoteAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $credit_note_id, $file_name, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createCreditNoteAttachmentByFileNameAsyncWithHttpInfo
     *
     * Allows you to create Attachments on CreditNote by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  string $file_name Name of the file you are attaching to Credit Note (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCreditNoteAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $credit_note_id, $file_name, $body)
    {
        $returnType = '\Xero2\Accounting\Model\Attachments';
        $request = $this->createCreditNoteAttachmentByFileNameRequest($xero_tenant_id, $credit_note_id, $file_name, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createCreditNoteAttachmentByFileName'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  string $file_name Name of the file you are attaching to Credit Note (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createCreditNoteAttachmentByFileNameRequest($xero_tenant_id, $credit_note_id, $file_name, $body)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createCreditNoteAttachmentByFileName'
            );
        }
        // verify the required parameter 'credit_note_id' is set
        if ($credit_note_id === null || (is_array($credit_note_id) && count($credit_note_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $credit_note_id when calling createCreditNoteAttachmentByFileName'
            );
        }
        // verify the required parameter 'file_name' is set
        if ($file_name === null || (is_array($file_name) && count($file_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_name when calling createCreditNoteAttachmentByFileName'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createCreditNoteAttachmentByFileName'
            );
        }

        $resourcePath = '/CreditNotes/{CreditNoteID}/Attachments/{FileName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($credit_note_id !== null) {
            $resourcePath = str_replace(
                '{' . 'CreditNoteID' . '}',
                ObjectSerializer::toPathValue($credit_note_id),
                $resourcePath
            );
        }
        // path params
        if ($file_name !== null) {
            $resourcePath = str_replace(
                '{' . 'FileName' . '}',
                ObjectSerializer::toPathValue($file_name),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/octet-stream']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createCreditNoteHistory
     *
     * Allows you to retrieve a history records of an CreditNote
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records history_records (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error
     */
    public function createCreditNoteHistory($xero_tenant_id, $credit_note_id, $history_records)
    {
        list($response) = $this->createCreditNoteHistoryWithHttpInfo($xero_tenant_id, $credit_note_id, $history_records);
        return $response;
    }

    /**
     * Operation createCreditNoteHistoryWithHttpInfo
     *
     * Allows you to retrieve a history records of an CreditNote
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCreditNoteHistoryWithHttpInfo($xero_tenant_id, $credit_note_id, $history_records)
    {
        $request = $this->createCreditNoteHistoryRequest($xero_tenant_id, $credit_note_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createCreditNoteHistoryAsync
     *
     * Allows you to retrieve a history records of an CreditNote
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCreditNoteHistoryAsync($xero_tenant_id, $credit_note_id, $history_records)
    {
        return $this->createCreditNoteHistoryAsyncWithHttpInfo($xero_tenant_id, $credit_note_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createCreditNoteHistoryAsyncWithHttpInfo
     *
     * Allows you to retrieve a history records of an CreditNote
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCreditNoteHistoryAsyncWithHttpInfo($xero_tenant_id, $credit_note_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createCreditNoteHistoryRequest($xero_tenant_id, $credit_note_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createCreditNoteHistory'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $credit_note_id Unique identifier for a Credit Note (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createCreditNoteHistoryRequest($xero_tenant_id, $credit_note_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createCreditNoteHistory'
            );
        }
        // verify the required parameter 'credit_note_id' is set
        if ($credit_note_id === null || (is_array($credit_note_id) && count($credit_note_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $credit_note_id when calling createCreditNoteHistory'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createCreditNoteHistory'
            );
        }

        $resourcePath = '/CreditNotes/{CreditNoteID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($credit_note_id !== null) {
            $resourcePath = str_replace(
                '{' . 'CreditNoteID' . '}',
                ObjectSerializer::toPathValue($credit_note_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($history_records)) {
            $_tempBody = $history_records;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createCreditNotes
     *
     * Allows you to create a credit note
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\CreditNotes $credit_notes an array of Credit Notes with a single CreditNote object. (required)
     * @param  bool $summarize_errors shows validation errors for each credit note (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\CreditNotes|\Xero2\Accounting\Model\Error
     */
    public function createCreditNotes($xero_tenant_id, $credit_notes, $summarize_errors = false)
    {
        list($response) = $this->createCreditNotesWithHttpInfo($xero_tenant_id, $credit_notes, $summarize_errors);
        return $response;
    }

    /**
     * Operation createCreditNotesWithHttpInfo
     *
     * Allows you to create a credit note
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\CreditNotes $credit_notes an array of Credit Notes with a single CreditNote object. (required)
     * @param  bool $summarize_errors shows validation errors for each credit note (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\CreditNotes|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCreditNotesWithHttpInfo($xero_tenant_id, $credit_notes, $summarize_errors = false)
    {
        $request = $this->createCreditNotesRequest($xero_tenant_id, $credit_notes, $summarize_errors);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\CreditNotes' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\CreditNotes', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\CreditNotes';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\CreditNotes',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createCreditNotesAsync
     *
     * Allows you to create a credit note
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\CreditNotes $credit_notes an array of Credit Notes with a single CreditNote object. (required)
     * @param  bool $summarize_errors shows validation errors for each credit note (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCreditNotesAsync($xero_tenant_id, $credit_notes, $summarize_errors = false)
    {
        return $this->createCreditNotesAsyncWithHttpInfo($xero_tenant_id, $credit_notes, $summarize_errors)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createCreditNotesAsyncWithHttpInfo
     *
     * Allows you to create a credit note
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\CreditNotes $credit_notes an array of Credit Notes with a single CreditNote object. (required)
     * @param  bool $summarize_errors shows validation errors for each credit note (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCreditNotesAsyncWithHttpInfo($xero_tenant_id, $credit_notes, $summarize_errors = false)
    {
        $returnType = '\Xero2\Accounting\Model\CreditNotes';
        $request = $this->createCreditNotesRequest($xero_tenant_id, $credit_notes, $summarize_errors);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createCreditNotes'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\CreditNotes $credit_notes an array of Credit Notes with a single CreditNote object. (required)
     * @param  bool $summarize_errors shows validation errors for each credit note (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createCreditNotesRequest($xero_tenant_id, $credit_notes, $summarize_errors = false)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createCreditNotes'
            );
        }
        // verify the required parameter 'credit_notes' is set
        if ($credit_notes === null || (is_array($credit_notes) && count($credit_notes) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $credit_notes when calling createCreditNotes'
            );
        }

        $resourcePath = '/CreditNotes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($summarize_errors !== null) {
            $queryParams['summarizeErrors'] = ObjectSerializer::toQueryValue($summarize_errors);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($credit_notes)) {
            $_tempBody = $credit_notes;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createCurrency
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Currency $currency currency (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Currencies
     */
    public function createCurrency($xero_tenant_id, $currency)
    {
        list($response) = $this->createCurrencyWithHttpInfo($xero_tenant_id, $currency);
        return $response;
    }

    /**
     * Operation createCurrencyWithHttpInfo
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Currency $currency (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Currencies, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCurrencyWithHttpInfo($xero_tenant_id, $currency)
    {
        $request = $this->createCurrencyRequest($xero_tenant_id, $currency);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Currencies' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Currencies', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Currencies';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Currencies',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createCurrencyAsync
     *
     * 
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Currency $currency (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCurrencyAsync($xero_tenant_id, $currency)
    {
        return $this->createCurrencyAsyncWithHttpInfo($xero_tenant_id, $currency)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createCurrencyAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Currency $currency (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCurrencyAsyncWithHttpInfo($xero_tenant_id, $currency)
    {
        $returnType = '\Xero2\Accounting\Model\Currencies';
        $request = $this->createCurrencyRequest($xero_tenant_id, $currency);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createCurrency'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Currency $currency (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createCurrencyRequest($xero_tenant_id, $currency)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createCurrency'
            );
        }
        // verify the required parameter 'currency' is set
        if ($currency === null || (is_array($currency) && count($currency) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $currency when calling createCurrency'
            );
        }

        $resourcePath = '/Currencies';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($currency)) {
            $_tempBody = $currency;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createEmployee
     *
     * Allows you to create a single new employees used in Xero payrun
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Employee $employee employee (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Employees|\Xero2\Accounting\Model\Error
     */
    public function createEmployee($xero_tenant_id, $employee)
    {
        list($response) = $this->createEmployeeWithHttpInfo($xero_tenant_id, $employee);
        return $response;
    }

    /**
     * Operation createEmployeeWithHttpInfo
     *
     * Allows you to create a single new employees used in Xero payrun
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Employee $employee (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Employees|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEmployeeWithHttpInfo($xero_tenant_id, $employee)
    {
        $request = $this->createEmployeeRequest($xero_tenant_id, $employee);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Employees' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Employees', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Employees';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Employees',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createEmployeeAsync
     *
     * Allows you to create a single new employees used in Xero payrun
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Employee $employee (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEmployeeAsync($xero_tenant_id, $employee)
    {
        return $this->createEmployeeAsyncWithHttpInfo($xero_tenant_id, $employee)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createEmployeeAsyncWithHttpInfo
     *
     * Allows you to create a single new employees used in Xero payrun
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Employee $employee (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEmployeeAsyncWithHttpInfo($xero_tenant_id, $employee)
    {
        $returnType = '\Xero2\Accounting\Model\Employees';
        $request = $this->createEmployeeRequest($xero_tenant_id, $employee);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createEmployee'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Employee $employee (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createEmployeeRequest($xero_tenant_id, $employee)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createEmployee'
            );
        }
        // verify the required parameter 'employee' is set
        if ($employee === null || (is_array($employee) && count($employee) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee when calling createEmployee'
            );
        }

        $resourcePath = '/Employees';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($employee)) {
            $_tempBody = $employee;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createEmployees
     *
     * Allows you to create new employees used in Xero payrun
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Employees $employees employees (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Employees|\Xero2\Accounting\Model\Error
     */
    public function createEmployees($xero_tenant_id, $employees)
    {
        list($response) = $this->createEmployeesWithHttpInfo($xero_tenant_id, $employees);
        return $response;
    }

    /**
     * Operation createEmployeesWithHttpInfo
     *
     * Allows you to create new employees used in Xero payrun
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Employees $employees (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Employees|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEmployeesWithHttpInfo($xero_tenant_id, $employees)
    {
        $request = $this->createEmployeesRequest($xero_tenant_id, $employees);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Employees' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Employees', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Employees';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Employees',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createEmployeesAsync
     *
     * Allows you to create new employees used in Xero payrun
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Employees $employees (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEmployeesAsync($xero_tenant_id, $employees)
    {
        return $this->createEmployeesAsyncWithHttpInfo($xero_tenant_id, $employees)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createEmployeesAsyncWithHttpInfo
     *
     * Allows you to create new employees used in Xero payrun
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Employees $employees (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEmployeesAsyncWithHttpInfo($xero_tenant_id, $employees)
    {
        $returnType = '\Xero2\Accounting\Model\Employees';
        $request = $this->createEmployeesRequest($xero_tenant_id, $employees);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createEmployees'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Employees $employees (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createEmployeesRequest($xero_tenant_id, $employees)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createEmployees'
            );
        }
        // verify the required parameter 'employees' is set
        if ($employees === null || (is_array($employees) && count($employees) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employees when calling createEmployees'
            );
        }

        $resourcePath = '/Employees';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($employees)) {
            $_tempBody = $employees;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createExpenseClaimHistory
     *
     * Allows you to create a history records of an ExpenseClaim
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $expense_claim_id Unique identifier for a ExpenseClaim (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records history_records (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords
     */
    public function createExpenseClaimHistory($xero_tenant_id, $expense_claim_id, $history_records)
    {
        list($response) = $this->createExpenseClaimHistoryWithHttpInfo($xero_tenant_id, $expense_claim_id, $history_records);
        return $response;
    }

    /**
     * Operation createExpenseClaimHistoryWithHttpInfo
     *
     * Allows you to create a history records of an ExpenseClaim
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $expense_claim_id Unique identifier for a ExpenseClaim (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords, HTTP status code, HTTP response headers (array of strings)
     */
    public function createExpenseClaimHistoryWithHttpInfo($xero_tenant_id, $expense_claim_id, $history_records)
    {
        $request = $this->createExpenseClaimHistoryRequest($xero_tenant_id, $expense_claim_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createExpenseClaimHistoryAsync
     *
     * Allows you to create a history records of an ExpenseClaim
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $expense_claim_id Unique identifier for a ExpenseClaim (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createExpenseClaimHistoryAsync($xero_tenant_id, $expense_claim_id, $history_records)
    {
        return $this->createExpenseClaimHistoryAsyncWithHttpInfo($xero_tenant_id, $expense_claim_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createExpenseClaimHistoryAsyncWithHttpInfo
     *
     * Allows you to create a history records of an ExpenseClaim
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $expense_claim_id Unique identifier for a ExpenseClaim (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createExpenseClaimHistoryAsyncWithHttpInfo($xero_tenant_id, $expense_claim_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createExpenseClaimHistoryRequest($xero_tenant_id, $expense_claim_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createExpenseClaimHistory'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $expense_claim_id Unique identifier for a ExpenseClaim (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createExpenseClaimHistoryRequest($xero_tenant_id, $expense_claim_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createExpenseClaimHistory'
            );
        }
        // verify the required parameter 'expense_claim_id' is set
        if ($expense_claim_id === null || (is_array($expense_claim_id) && count($expense_claim_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $expense_claim_id when calling createExpenseClaimHistory'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createExpenseClaimHistory'
            );
        }

        $resourcePath = '/ExpenseClaims/{ExpenseClaimID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($expense_claim_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ExpenseClaimID' . '}',
                ObjectSerializer::toPathValue($expense_claim_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($history_records)) {
            $_tempBody = $history_records;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createExpenseClaims
     *
     * Allows you to retrieve expense claims
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ExpenseClaims $expense_claims expense_claims (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\ExpenseClaims|\Xero2\Accounting\Model\Error
     */
    public function createExpenseClaims($xero_tenant_id, $expense_claims)
    {
        list($response) = $this->createExpenseClaimsWithHttpInfo($xero_tenant_id, $expense_claims);
        return $response;
    }

    /**
     * Operation createExpenseClaimsWithHttpInfo
     *
     * Allows you to retrieve expense claims
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ExpenseClaims $expense_claims (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\ExpenseClaims|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createExpenseClaimsWithHttpInfo($xero_tenant_id, $expense_claims)
    {
        $request = $this->createExpenseClaimsRequest($xero_tenant_id, $expense_claims);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\ExpenseClaims' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\ExpenseClaims', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\ExpenseClaims';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\ExpenseClaims',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createExpenseClaimsAsync
     *
     * Allows you to retrieve expense claims
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ExpenseClaims $expense_claims (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createExpenseClaimsAsync($xero_tenant_id, $expense_claims)
    {
        return $this->createExpenseClaimsAsyncWithHttpInfo($xero_tenant_id, $expense_claims)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createExpenseClaimsAsyncWithHttpInfo
     *
     * Allows you to retrieve expense claims
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ExpenseClaims $expense_claims (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createExpenseClaimsAsyncWithHttpInfo($xero_tenant_id, $expense_claims)
    {
        $returnType = '\Xero2\Accounting\Model\ExpenseClaims';
        $request = $this->createExpenseClaimsRequest($xero_tenant_id, $expense_claims);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createExpenseClaims'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ExpenseClaims $expense_claims (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createExpenseClaimsRequest($xero_tenant_id, $expense_claims)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createExpenseClaims'
            );
        }
        // verify the required parameter 'expense_claims' is set
        if ($expense_claims === null || (is_array($expense_claims) && count($expense_claims) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $expense_claims when calling createExpenseClaims'
            );
        }

        $resourcePath = '/ExpenseClaims';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($expense_claims)) {
            $_tempBody = $expense_claims;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createInvoice
     *
     * Allows you to create any sales invoices or purchase bills
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Invoice $invoice invoice (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Invoices|\Xero2\Accounting\Model\Error
     */
    public function createInvoice($xero_tenant_id, $invoice)
    {
        list($response) = $this->createInvoiceWithHttpInfo($xero_tenant_id, $invoice);
        return $response;
    }

    /**
     * Operation createInvoiceWithHttpInfo
     *
     * Allows you to create any sales invoices or purchase bills
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Invoice $invoice (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Invoices|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createInvoiceWithHttpInfo($xero_tenant_id, $invoice)
    {
        $request = $this->createInvoiceRequest($xero_tenant_id, $invoice);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Invoices' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Invoices', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Invoices';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Invoices',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createInvoiceAsync
     *
     * Allows you to create any sales invoices or purchase bills
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Invoice $invoice (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInvoiceAsync($xero_tenant_id, $invoice)
    {
        return $this->createInvoiceAsyncWithHttpInfo($xero_tenant_id, $invoice)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createInvoiceAsyncWithHttpInfo
     *
     * Allows you to create any sales invoices or purchase bills
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Invoice $invoice (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInvoiceAsyncWithHttpInfo($xero_tenant_id, $invoice)
    {
        $returnType = '\Xero2\Accounting\Model\Invoices';
        $request = $this->createInvoiceRequest($xero_tenant_id, $invoice);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createInvoice'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Invoice $invoice (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createInvoiceRequest($xero_tenant_id, $invoice)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createInvoice'
            );
        }
        // verify the required parameter 'invoice' is set
        if ($invoice === null || (is_array($invoice) && count($invoice) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $invoice when calling createInvoice'
            );
        }

        $resourcePath = '/Invoices';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($invoice)) {
            $_tempBody = $invoice;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createInvoiceAttachmentByFileName
     *
     * Allows you to create an Attachment on invoices or purchase bills by it's filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  string $file_name Name of the file you are attaching (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error
     */
    public function createInvoiceAttachmentByFileName($xero_tenant_id, $invoice_id, $file_name, $body)
    {
        list($response) = $this->createInvoiceAttachmentByFileNameWithHttpInfo($xero_tenant_id, $invoice_id, $file_name, $body);
        return $response;
    }

    /**
     * Operation createInvoiceAttachmentByFileNameWithHttpInfo
     *
     * Allows you to create an Attachment on invoices or purchase bills by it's filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  string $file_name Name of the file you are attaching (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createInvoiceAttachmentByFileNameWithHttpInfo($xero_tenant_id, $invoice_id, $file_name, $body)
    {
        $request = $this->createInvoiceAttachmentByFileNameRequest($xero_tenant_id, $invoice_id, $file_name, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Attachments' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Attachments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Attachments';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Attachments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createInvoiceAttachmentByFileNameAsync
     *
     * Allows you to create an Attachment on invoices or purchase bills by it's filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  string $file_name Name of the file you are attaching (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInvoiceAttachmentByFileNameAsync($xero_tenant_id, $invoice_id, $file_name, $body)
    {
        return $this->createInvoiceAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $invoice_id, $file_name, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createInvoiceAttachmentByFileNameAsyncWithHttpInfo
     *
     * Allows you to create an Attachment on invoices or purchase bills by it's filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  string $file_name Name of the file you are attaching (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInvoiceAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $invoice_id, $file_name, $body)
    {
        $returnType = '\Xero2\Accounting\Model\Attachments';
        $request = $this->createInvoiceAttachmentByFileNameRequest($xero_tenant_id, $invoice_id, $file_name, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createInvoiceAttachmentByFileName'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  string $file_name Name of the file you are attaching (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createInvoiceAttachmentByFileNameRequest($xero_tenant_id, $invoice_id, $file_name, $body)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createInvoiceAttachmentByFileName'
            );
        }
        // verify the required parameter 'invoice_id' is set
        if ($invoice_id === null || (is_array($invoice_id) && count($invoice_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $invoice_id when calling createInvoiceAttachmentByFileName'
            );
        }
        // verify the required parameter 'file_name' is set
        if ($file_name === null || (is_array($file_name) && count($file_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_name when calling createInvoiceAttachmentByFileName'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createInvoiceAttachmentByFileName'
            );
        }

        $resourcePath = '/Invoices/{InvoiceID}/Attachments/{FileName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($invoice_id !== null) {
            $resourcePath = str_replace(
                '{' . 'InvoiceID' . '}',
                ObjectSerializer::toPathValue($invoice_id),
                $resourcePath
            );
        }
        // path params
        if ($file_name !== null) {
            $resourcePath = str_replace(
                '{' . 'FileName' . '}',
                ObjectSerializer::toPathValue($file_name),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/octet-stream']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createInvoiceHistory
     *
     * Allows you to retrieve a history records of an invoice
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records history_records (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error
     */
    public function createInvoiceHistory($xero_tenant_id, $invoice_id, $history_records)
    {
        list($response) = $this->createInvoiceHistoryWithHttpInfo($xero_tenant_id, $invoice_id, $history_records);
        return $response;
    }

    /**
     * Operation createInvoiceHistoryWithHttpInfo
     *
     * Allows you to retrieve a history records of an invoice
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createInvoiceHistoryWithHttpInfo($xero_tenant_id, $invoice_id, $history_records)
    {
        $request = $this->createInvoiceHistoryRequest($xero_tenant_id, $invoice_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createInvoiceHistoryAsync
     *
     * Allows you to retrieve a history records of an invoice
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInvoiceHistoryAsync($xero_tenant_id, $invoice_id, $history_records)
    {
        return $this->createInvoiceHistoryAsyncWithHttpInfo($xero_tenant_id, $invoice_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createInvoiceHistoryAsyncWithHttpInfo
     *
     * Allows you to retrieve a history records of an invoice
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInvoiceHistoryAsyncWithHttpInfo($xero_tenant_id, $invoice_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createInvoiceHistoryRequest($xero_tenant_id, $invoice_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createInvoiceHistory'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createInvoiceHistoryRequest($xero_tenant_id, $invoice_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createInvoiceHistory'
            );
        }
        // verify the required parameter 'invoice_id' is set
        if ($invoice_id === null || (is_array($invoice_id) && count($invoice_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $invoice_id when calling createInvoiceHistory'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createInvoiceHistory'
            );
        }

        $resourcePath = '/Invoices/{InvoiceID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($invoice_id !== null) {
            $resourcePath = str_replace(
                '{' . 'InvoiceID' . '}',
                ObjectSerializer::toPathValue($invoice_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($history_records)) {
            $_tempBody = $history_records;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createInvoices
     *
     * Allows you to create a single sales invoices or purchase bills
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Invoices $invoices invoices (required)
     * @param  bool $summarize_errors shows validation errors for each invoice (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Invoices|\Xero2\Accounting\Model\Error
     */
    public function createInvoices($xero_tenant_id, $invoices, $summarize_errors = false)
    {
        list($response) = $this->createInvoicesWithHttpInfo($xero_tenant_id, $invoices, $summarize_errors);
        return $response;
    }

    /**
     * Operation createInvoicesWithHttpInfo
     *
     * Allows you to create a single sales invoices or purchase bills
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Invoices $invoices (required)
     * @param  bool $summarize_errors shows validation errors for each invoice (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Invoices|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createInvoicesWithHttpInfo($xero_tenant_id, $invoices, $summarize_errors = false)
    {
        $request = $this->createInvoicesRequest($xero_tenant_id, $invoices, $summarize_errors);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Invoices' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Invoices', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Invoices';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Invoices',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createInvoicesAsync
     *
     * Allows you to create a single sales invoices or purchase bills
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Invoices $invoices (required)
     * @param  bool $summarize_errors shows validation errors for each invoice (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInvoicesAsync($xero_tenant_id, $invoices, $summarize_errors = false)
    {
        return $this->createInvoicesAsyncWithHttpInfo($xero_tenant_id, $invoices, $summarize_errors)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createInvoicesAsyncWithHttpInfo
     *
     * Allows you to create a single sales invoices or purchase bills
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Invoices $invoices (required)
     * @param  bool $summarize_errors shows validation errors for each invoice (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInvoicesAsyncWithHttpInfo($xero_tenant_id, $invoices, $summarize_errors = false)
    {
        $returnType = '\Xero2\Accounting\Model\Invoices';
        $request = $this->createInvoicesRequest($xero_tenant_id, $invoices, $summarize_errors);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createInvoices'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Invoices $invoices (required)
     * @param  bool $summarize_errors shows validation errors for each invoice (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createInvoicesRequest($xero_tenant_id, $invoices, $summarize_errors = false)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createInvoices'
            );
        }
        // verify the required parameter 'invoices' is set
        if ($invoices === null || (is_array($invoices) && count($invoices) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $invoices when calling createInvoices'
            );
        }

        $resourcePath = '/Invoices';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($summarize_errors !== null) {
            $queryParams['summarizeErrors'] = ObjectSerializer::toQueryValue($summarize_errors);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($invoices)) {
            $_tempBody = $invoices;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createItem
     *
     * Allows you to create a single item
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Item $item item (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Items|\Xero2\Accounting\Model\Error
     */
    public function createItem($xero_tenant_id, $item)
    {
        list($response) = $this->createItemWithHttpInfo($xero_tenant_id, $item);
        return $response;
    }

    /**
     * Operation createItemWithHttpInfo
     *
     * Allows you to create a single item
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Item $item (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Items|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createItemWithHttpInfo($xero_tenant_id, $item)
    {
        $request = $this->createItemRequest($xero_tenant_id, $item);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Items' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Items', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Items';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Items',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createItemAsync
     *
     * Allows you to create a single item
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Item $item (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createItemAsync($xero_tenant_id, $item)
    {
        return $this->createItemAsyncWithHttpInfo($xero_tenant_id, $item)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createItemAsyncWithHttpInfo
     *
     * Allows you to create a single item
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Item $item (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createItemAsyncWithHttpInfo($xero_tenant_id, $item)
    {
        $returnType = '\Xero2\Accounting\Model\Items';
        $request = $this->createItemRequest($xero_tenant_id, $item);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createItem'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Item $item (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createItemRequest($xero_tenant_id, $item)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createItem'
            );
        }
        // verify the required parameter 'item' is set
        if ($item === null || (is_array($item) && count($item) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $item when calling createItem'
            );
        }

        $resourcePath = '/Items';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($item)) {
            $_tempBody = $item;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createItemHistory
     *
     * Allows you to create a history record for items
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $item_id Unique identifier for an Item (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records history_records (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords
     */
    public function createItemHistory($xero_tenant_id, $item_id, $history_records)
    {
        list($response) = $this->createItemHistoryWithHttpInfo($xero_tenant_id, $item_id, $history_records);
        return $response;
    }

    /**
     * Operation createItemHistoryWithHttpInfo
     *
     * Allows you to create a history record for items
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $item_id Unique identifier for an Item (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords, HTTP status code, HTTP response headers (array of strings)
     */
    public function createItemHistoryWithHttpInfo($xero_tenant_id, $item_id, $history_records)
    {
        $request = $this->createItemHistoryRequest($xero_tenant_id, $item_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createItemHistoryAsync
     *
     * Allows you to create a history record for items
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $item_id Unique identifier for an Item (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createItemHistoryAsync($xero_tenant_id, $item_id, $history_records)
    {
        return $this->createItemHistoryAsyncWithHttpInfo($xero_tenant_id, $item_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createItemHistoryAsyncWithHttpInfo
     *
     * Allows you to create a history record for items
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $item_id Unique identifier for an Item (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createItemHistoryAsyncWithHttpInfo($xero_tenant_id, $item_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createItemHistoryRequest($xero_tenant_id, $item_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createItemHistory'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $item_id Unique identifier for an Item (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createItemHistoryRequest($xero_tenant_id, $item_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createItemHistory'
            );
        }
        // verify the required parameter 'item_id' is set
        if ($item_id === null || (is_array($item_id) && count($item_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $item_id when calling createItemHistory'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createItemHistory'
            );
        }

        $resourcePath = '/Items/{ItemID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($item_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ItemID' . '}',
                ObjectSerializer::toPathValue($item_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($history_records)) {
            $_tempBody = $history_records;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createItems
     *
     * Allows you to create multiple items
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Items $items items (required)
     * @param  bool $summarize_errors response format that shows validation errors for each bank transaction (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Items|\Xero2\Accounting\Model\Error
     */
    public function createItems($xero_tenant_id, $items, $summarize_errors = false)
    {
        list($response) = $this->createItemsWithHttpInfo($xero_tenant_id, $items, $summarize_errors);
        return $response;
    }

    /**
     * Operation createItemsWithHttpInfo
     *
     * Allows you to create multiple items
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Items $items (required)
     * @param  bool $summarize_errors response format that shows validation errors for each bank transaction (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Items|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createItemsWithHttpInfo($xero_tenant_id, $items, $summarize_errors = false)
    {
        $request = $this->createItemsRequest($xero_tenant_id, $items, $summarize_errors);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Items' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Items', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Items';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Items',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createItemsAsync
     *
     * Allows you to create multiple items
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Items $items (required)
     * @param  bool $summarize_errors response format that shows validation errors for each bank transaction (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createItemsAsync($xero_tenant_id, $items, $summarize_errors = false)
    {
        return $this->createItemsAsyncWithHttpInfo($xero_tenant_id, $items, $summarize_errors)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createItemsAsyncWithHttpInfo
     *
     * Allows you to create multiple items
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Items $items (required)
     * @param  bool $summarize_errors response format that shows validation errors for each bank transaction (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createItemsAsyncWithHttpInfo($xero_tenant_id, $items, $summarize_errors = false)
    {
        $returnType = '\Xero2\Accounting\Model\Items';
        $request = $this->createItemsRequest($xero_tenant_id, $items, $summarize_errors);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createItems'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Items $items (required)
     * @param  bool $summarize_errors response format that shows validation errors for each bank transaction (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createItemsRequest($xero_tenant_id, $items, $summarize_errors = false)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createItems'
            );
        }
        // verify the required parameter 'items' is set
        if ($items === null || (is_array($items) && count($items) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $items when calling createItems'
            );
        }

        $resourcePath = '/Items';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($summarize_errors !== null) {
            $queryParams['summarizeErrors'] = ObjectSerializer::toQueryValue($summarize_errors);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($items)) {
            $_tempBody = $items;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createLinkedTransaction
     *
     * Allows you to create linked transactions (billable expenses)
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\LinkedTransaction $linked_transaction linked_transaction (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\LinkedTransactions|\Xero2\Accounting\Model\Error
     */
    public function createLinkedTransaction($xero_tenant_id, $linked_transaction)
    {
        list($response) = $this->createLinkedTransactionWithHttpInfo($xero_tenant_id, $linked_transaction);
        return $response;
    }

    /**
     * Operation createLinkedTransactionWithHttpInfo
     *
     * Allows you to create linked transactions (billable expenses)
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\LinkedTransaction $linked_transaction (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\LinkedTransactions|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createLinkedTransactionWithHttpInfo($xero_tenant_id, $linked_transaction)
    {
        $request = $this->createLinkedTransactionRequest($xero_tenant_id, $linked_transaction);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\LinkedTransactions' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\LinkedTransactions', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\LinkedTransactions';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\LinkedTransactions',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createLinkedTransactionAsync
     *
     * Allows you to create linked transactions (billable expenses)
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\LinkedTransaction $linked_transaction (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createLinkedTransactionAsync($xero_tenant_id, $linked_transaction)
    {
        return $this->createLinkedTransactionAsyncWithHttpInfo($xero_tenant_id, $linked_transaction)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createLinkedTransactionAsyncWithHttpInfo
     *
     * Allows you to create linked transactions (billable expenses)
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\LinkedTransaction $linked_transaction (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createLinkedTransactionAsyncWithHttpInfo($xero_tenant_id, $linked_transaction)
    {
        $returnType = '\Xero2\Accounting\Model\LinkedTransactions';
        $request = $this->createLinkedTransactionRequest($xero_tenant_id, $linked_transaction);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createLinkedTransaction'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\LinkedTransaction $linked_transaction (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createLinkedTransactionRequest($xero_tenant_id, $linked_transaction)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createLinkedTransaction'
            );
        }
        // verify the required parameter 'linked_transaction' is set
        if ($linked_transaction === null || (is_array($linked_transaction) && count($linked_transaction) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $linked_transaction when calling createLinkedTransaction'
            );
        }

        $resourcePath = '/LinkedTransactions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($linked_transaction)) {
            $_tempBody = $linked_transaction;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createManualJournal
     *
     * Allows you to create a single manual journal
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ManualJournal $manual_journal manual_journal (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\ManualJournals|\Xero2\Accounting\Model\Error
     */
    public function createManualJournal($xero_tenant_id, $manual_journal)
    {
        list($response) = $this->createManualJournalWithHttpInfo($xero_tenant_id, $manual_journal);
        return $response;
    }

    /**
     * Operation createManualJournalWithHttpInfo
     *
     * Allows you to create a single manual journal
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ManualJournal $manual_journal (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\ManualJournals|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createManualJournalWithHttpInfo($xero_tenant_id, $manual_journal)
    {
        $request = $this->createManualJournalRequest($xero_tenant_id, $manual_journal);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\ManualJournals' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\ManualJournals', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\ManualJournals';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\ManualJournals',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createManualJournalAsync
     *
     * Allows you to create a single manual journal
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ManualJournal $manual_journal (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createManualJournalAsync($xero_tenant_id, $manual_journal)
    {
        return $this->createManualJournalAsyncWithHttpInfo($xero_tenant_id, $manual_journal)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createManualJournalAsyncWithHttpInfo
     *
     * Allows you to create a single manual journal
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ManualJournal $manual_journal (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createManualJournalAsyncWithHttpInfo($xero_tenant_id, $manual_journal)
    {
        $returnType = '\Xero2\Accounting\Model\ManualJournals';
        $request = $this->createManualJournalRequest($xero_tenant_id, $manual_journal);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createManualJournal'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ManualJournal $manual_journal (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createManualJournalRequest($xero_tenant_id, $manual_journal)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createManualJournal'
            );
        }
        // verify the required parameter 'manual_journal' is set
        if ($manual_journal === null || (is_array($manual_journal) && count($manual_journal) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $manual_journal when calling createManualJournal'
            );
        }

        $resourcePath = '/ManualJournals';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($manual_journal)) {
            $_tempBody = $manual_journal;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createManualJournalAttachmentByFileName
     *
     * Allows you to create a specified Attachment on ManualJournal by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $manual_journal_id Unique identifier for a ManualJournal (required)
     * @param  string $file_name The name of the file being attached to a ManualJournal (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error
     */
    public function createManualJournalAttachmentByFileName($xero_tenant_id, $manual_journal_id, $file_name, $body)
    {
        list($response) = $this->createManualJournalAttachmentByFileNameWithHttpInfo($xero_tenant_id, $manual_journal_id, $file_name, $body);
        return $response;
    }

    /**
     * Operation createManualJournalAttachmentByFileNameWithHttpInfo
     *
     * Allows you to create a specified Attachment on ManualJournal by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $manual_journal_id Unique identifier for a ManualJournal (required)
     * @param  string $file_name The name of the file being attached to a ManualJournal (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createManualJournalAttachmentByFileNameWithHttpInfo($xero_tenant_id, $manual_journal_id, $file_name, $body)
    {
        $request = $this->createManualJournalAttachmentByFileNameRequest($xero_tenant_id, $manual_journal_id, $file_name, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Attachments' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Attachments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Attachments';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Attachments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createManualJournalAttachmentByFileNameAsync
     *
     * Allows you to create a specified Attachment on ManualJournal by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $manual_journal_id Unique identifier for a ManualJournal (required)
     * @param  string $file_name The name of the file being attached to a ManualJournal (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createManualJournalAttachmentByFileNameAsync($xero_tenant_id, $manual_journal_id, $file_name, $body)
    {
        return $this->createManualJournalAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $manual_journal_id, $file_name, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createManualJournalAttachmentByFileNameAsyncWithHttpInfo
     *
     * Allows you to create a specified Attachment on ManualJournal by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $manual_journal_id Unique identifier for a ManualJournal (required)
     * @param  string $file_name The name of the file being attached to a ManualJournal (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createManualJournalAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $manual_journal_id, $file_name, $body)
    {
        $returnType = '\Xero2\Accounting\Model\Attachments';
        $request = $this->createManualJournalAttachmentByFileNameRequest($xero_tenant_id, $manual_journal_id, $file_name, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createManualJournalAttachmentByFileName'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $manual_journal_id Unique identifier for a ManualJournal (required)
     * @param  string $file_name The name of the file being attached to a ManualJournal (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createManualJournalAttachmentByFileNameRequest($xero_tenant_id, $manual_journal_id, $file_name, $body)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createManualJournalAttachmentByFileName'
            );
        }
        // verify the required parameter 'manual_journal_id' is set
        if ($manual_journal_id === null || (is_array($manual_journal_id) && count($manual_journal_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $manual_journal_id when calling createManualJournalAttachmentByFileName'
            );
        }
        // verify the required parameter 'file_name' is set
        if ($file_name === null || (is_array($file_name) && count($file_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_name when calling createManualJournalAttachmentByFileName'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createManualJournalAttachmentByFileName'
            );
        }

        $resourcePath = '/ManualJournals/{ManualJournalID}/Attachments/{FileName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($manual_journal_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ManualJournalID' . '}',
                ObjectSerializer::toPathValue($manual_journal_id),
                $resourcePath
            );
        }
        // path params
        if ($file_name !== null) {
            $resourcePath = str_replace(
                '{' . 'FileName' . '}',
                ObjectSerializer::toPathValue($file_name),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/octet-stream']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createManualJournals
     *
     * Allows you to create multiple manual journals
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ManualJournals $manual_journals manual_journals (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\ManualJournals|\Xero2\Accounting\Model\Error
     */
    public function createManualJournals($xero_tenant_id, $manual_journals)
    {
        list($response) = $this->createManualJournalsWithHttpInfo($xero_tenant_id, $manual_journals);
        return $response;
    }

    /**
     * Operation createManualJournalsWithHttpInfo
     *
     * Allows you to create multiple manual journals
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ManualJournals $manual_journals (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\ManualJournals|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createManualJournalsWithHttpInfo($xero_tenant_id, $manual_journals)
    {
        $request = $this->createManualJournalsRequest($xero_tenant_id, $manual_journals);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\ManualJournals' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\ManualJournals', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\ManualJournals';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\ManualJournals',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createManualJournalsAsync
     *
     * Allows you to create multiple manual journals
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ManualJournals $manual_journals (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createManualJournalsAsync($xero_tenant_id, $manual_journals)
    {
        return $this->createManualJournalsAsyncWithHttpInfo($xero_tenant_id, $manual_journals)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createManualJournalsAsyncWithHttpInfo
     *
     * Allows you to create multiple manual journals
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ManualJournals $manual_journals (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createManualJournalsAsyncWithHttpInfo($xero_tenant_id, $manual_journals)
    {
        $returnType = '\Xero2\Accounting\Model\ManualJournals';
        $request = $this->createManualJournalsRequest($xero_tenant_id, $manual_journals);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createManualJournals'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\ManualJournals $manual_journals (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createManualJournalsRequest($xero_tenant_id, $manual_journals)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createManualJournals'
            );
        }
        // verify the required parameter 'manual_journals' is set
        if ($manual_journals === null || (is_array($manual_journals) && count($manual_journals) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $manual_journals when calling createManualJournals'
            );
        }

        $resourcePath = '/ManualJournals';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($manual_journals)) {
            $_tempBody = $manual_journals;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createOverpaymentAllocation
     *
     * Allows you to create a single allocations for overpayments
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $overpayment_id Unique identifier for a Overpayment (required)
     * @param  \Xero2\Accounting\Model\Allocation $allocation allocation (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Allocations|\Xero2\Accounting\Model\Error
     */
    public function createOverpaymentAllocation($xero_tenant_id, $overpayment_id, $allocation)
    {
        list($response) = $this->createOverpaymentAllocationWithHttpInfo($xero_tenant_id, $overpayment_id, $allocation);
        return $response;
    }

    /**
     * Operation createOverpaymentAllocationWithHttpInfo
     *
     * Allows you to create a single allocations for overpayments
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $overpayment_id Unique identifier for a Overpayment (required)
     * @param  \Xero2\Accounting\Model\Allocation $allocation (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Allocations|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createOverpaymentAllocationWithHttpInfo($xero_tenant_id, $overpayment_id, $allocation)
    {
        $request = $this->createOverpaymentAllocationRequest($xero_tenant_id, $overpayment_id, $allocation);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Allocations' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Allocations', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Allocations';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Allocations',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createOverpaymentAllocationAsync
     *
     * Allows you to create a single allocations for overpayments
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $overpayment_id Unique identifier for a Overpayment (required)
     * @param  \Xero2\Accounting\Model\Allocation $allocation (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOverpaymentAllocationAsync($xero_tenant_id, $overpayment_id, $allocation)
    {
        return $this->createOverpaymentAllocationAsyncWithHttpInfo($xero_tenant_id, $overpayment_id, $allocation)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createOverpaymentAllocationAsyncWithHttpInfo
     *
     * Allows you to create a single allocations for overpayments
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $overpayment_id Unique identifier for a Overpayment (required)
     * @param  \Xero2\Accounting\Model\Allocation $allocation (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOverpaymentAllocationAsyncWithHttpInfo($xero_tenant_id, $overpayment_id, $allocation)
    {
        $returnType = '\Xero2\Accounting\Model\Allocations';
        $request = $this->createOverpaymentAllocationRequest($xero_tenant_id, $overpayment_id, $allocation);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createOverpaymentAllocation'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $overpayment_id Unique identifier for a Overpayment (required)
     * @param  \Xero2\Accounting\Model\Allocation $allocation (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createOverpaymentAllocationRequest($xero_tenant_id, $overpayment_id, $allocation)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createOverpaymentAllocation'
            );
        }
        // verify the required parameter 'overpayment_id' is set
        if ($overpayment_id === null || (is_array($overpayment_id) && count($overpayment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $overpayment_id when calling createOverpaymentAllocation'
            );
        }
        // verify the required parameter 'allocation' is set
        if ($allocation === null || (is_array($allocation) && count($allocation) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $allocation when calling createOverpaymentAllocation'
            );
        }

        $resourcePath = '/Overpayments/{OverpaymentID}/Allocations';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($overpayment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'OverpaymentID' . '}',
                ObjectSerializer::toPathValue($overpayment_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($allocation)) {
            $_tempBody = $allocation;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createOverpaymentAllocations
     *
     * Allows you to create a single allocation for an overpayment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $overpayment_id Unique identifier for a Overpayment (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations allocations (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Allocations|\Xero2\Accounting\Model\Error
     */
    public function createOverpaymentAllocations($xero_tenant_id, $overpayment_id, $allocations)
    {
        list($response) = $this->createOverpaymentAllocationsWithHttpInfo($xero_tenant_id, $overpayment_id, $allocations);
        return $response;
    }

    /**
     * Operation createOverpaymentAllocationsWithHttpInfo
     *
     * Allows you to create a single allocation for an overpayment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $overpayment_id Unique identifier for a Overpayment (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Allocations|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createOverpaymentAllocationsWithHttpInfo($xero_tenant_id, $overpayment_id, $allocations)
    {
        $request = $this->createOverpaymentAllocationsRequest($xero_tenant_id, $overpayment_id, $allocations);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Allocations' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Allocations', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Allocations';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Allocations',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createOverpaymentAllocationsAsync
     *
     * Allows you to create a single allocation for an overpayment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $overpayment_id Unique identifier for a Overpayment (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOverpaymentAllocationsAsync($xero_tenant_id, $overpayment_id, $allocations)
    {
        return $this->createOverpaymentAllocationsAsyncWithHttpInfo($xero_tenant_id, $overpayment_id, $allocations)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createOverpaymentAllocationsAsyncWithHttpInfo
     *
     * Allows you to create a single allocation for an overpayment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $overpayment_id Unique identifier for a Overpayment (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOverpaymentAllocationsAsyncWithHttpInfo($xero_tenant_id, $overpayment_id, $allocations)
    {
        $returnType = '\Xero2\Accounting\Model\Allocations';
        $request = $this->createOverpaymentAllocationsRequest($xero_tenant_id, $overpayment_id, $allocations);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createOverpaymentAllocations'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $overpayment_id Unique identifier for a Overpayment (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createOverpaymentAllocationsRequest($xero_tenant_id, $overpayment_id, $allocations)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createOverpaymentAllocations'
            );
        }
        // verify the required parameter 'overpayment_id' is set
        if ($overpayment_id === null || (is_array($overpayment_id) && count($overpayment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $overpayment_id when calling createOverpaymentAllocations'
            );
        }
        // verify the required parameter 'allocations' is set
        if ($allocations === null || (is_array($allocations) && count($allocations) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $allocations when calling createOverpaymentAllocations'
            );
        }

        $resourcePath = '/Overpayments/{OverpaymentID}/Allocations';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($overpayment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'OverpaymentID' . '}',
                ObjectSerializer::toPathValue($overpayment_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($allocations)) {
            $_tempBody = $allocations;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createOverpaymentHistory
     *
     * Allows you to create history records of an Overpayment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $overpayment_id Unique identifier for a Overpayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records history_records (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error
     */
    public function createOverpaymentHistory($xero_tenant_id, $overpayment_id, $history_records)
    {
        list($response) = $this->createOverpaymentHistoryWithHttpInfo($xero_tenant_id, $overpayment_id, $history_records);
        return $response;
    }

    /**
     * Operation createOverpaymentHistoryWithHttpInfo
     *
     * Allows you to create history records of an Overpayment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $overpayment_id Unique identifier for a Overpayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createOverpaymentHistoryWithHttpInfo($xero_tenant_id, $overpayment_id, $history_records)
    {
        $request = $this->createOverpaymentHistoryRequest($xero_tenant_id, $overpayment_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createOverpaymentHistoryAsync
     *
     * Allows you to create history records of an Overpayment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $overpayment_id Unique identifier for a Overpayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOverpaymentHistoryAsync($xero_tenant_id, $overpayment_id, $history_records)
    {
        return $this->createOverpaymentHistoryAsyncWithHttpInfo($xero_tenant_id, $overpayment_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createOverpaymentHistoryAsyncWithHttpInfo
     *
     * Allows you to create history records of an Overpayment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $overpayment_id Unique identifier for a Overpayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOverpaymentHistoryAsyncWithHttpInfo($xero_tenant_id, $overpayment_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createOverpaymentHistoryRequest($xero_tenant_id, $overpayment_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createOverpaymentHistory'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $overpayment_id Unique identifier for a Overpayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createOverpaymentHistoryRequest($xero_tenant_id, $overpayment_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createOverpaymentHistory'
            );
        }
        // verify the required parameter 'overpayment_id' is set
        if ($overpayment_id === null || (is_array($overpayment_id) && count($overpayment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $overpayment_id when calling createOverpaymentHistory'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createOverpaymentHistory'
            );
        }

        $resourcePath = '/Overpayments/{OverpaymentID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($overpayment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'OverpaymentID' . '}',
                ObjectSerializer::toPathValue($overpayment_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($history_records)) {
            $_tempBody = $history_records;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPayment
     *
     * Allows you to create a single payment for invoices or credit notes
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Payment $payment payment (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Payments|\Xero2\Accounting\Model\Error
     */
    public function createPayment($xero_tenant_id, $payment)
    {
        list($response) = $this->createPaymentWithHttpInfo($xero_tenant_id, $payment);
        return $response;
    }

    /**
     * Operation createPaymentWithHttpInfo
     *
     * Allows you to create a single payment for invoices or credit notes
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Payment $payment (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Payments|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPaymentWithHttpInfo($xero_tenant_id, $payment)
    {
        $request = $this->createPaymentRequest($xero_tenant_id, $payment);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Payments' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Payments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Payments';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Payments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createPaymentAsync
     *
     * Allows you to create a single payment for invoices or credit notes
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Payment $payment (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPaymentAsync($xero_tenant_id, $payment)
    {
        return $this->createPaymentAsyncWithHttpInfo($xero_tenant_id, $payment)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPaymentAsyncWithHttpInfo
     *
     * Allows you to create a single payment for invoices or credit notes
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Payment $payment (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPaymentAsyncWithHttpInfo($xero_tenant_id, $payment)
    {
        $returnType = '\Xero2\Accounting\Model\Payments';
        $request = $this->createPaymentRequest($xero_tenant_id, $payment);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPayment'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Payment $payment (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createPaymentRequest($xero_tenant_id, $payment)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createPayment'
            );
        }
        // verify the required parameter 'payment' is set
        if ($payment === null || (is_array($payment) && count($payment) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payment when calling createPayment'
            );
        }

        $resourcePath = '/Payments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($payment)) {
            $_tempBody = $payment;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPaymentHistory
     *
     * Allows you to create a history record for a payment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payment_id Unique identifier for a Payment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records history_records (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error
     */
    public function createPaymentHistory($xero_tenant_id, $payment_id, $history_records)
    {
        list($response) = $this->createPaymentHistoryWithHttpInfo($xero_tenant_id, $payment_id, $history_records);
        return $response;
    }

    /**
     * Operation createPaymentHistoryWithHttpInfo
     *
     * Allows you to create a history record for a payment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payment_id Unique identifier for a Payment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPaymentHistoryWithHttpInfo($xero_tenant_id, $payment_id, $history_records)
    {
        $request = $this->createPaymentHistoryRequest($xero_tenant_id, $payment_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createPaymentHistoryAsync
     *
     * Allows you to create a history record for a payment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payment_id Unique identifier for a Payment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPaymentHistoryAsync($xero_tenant_id, $payment_id, $history_records)
    {
        return $this->createPaymentHistoryAsyncWithHttpInfo($xero_tenant_id, $payment_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPaymentHistoryAsyncWithHttpInfo
     *
     * Allows you to create a history record for a payment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payment_id Unique identifier for a Payment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPaymentHistoryAsyncWithHttpInfo($xero_tenant_id, $payment_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createPaymentHistoryRequest($xero_tenant_id, $payment_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPaymentHistory'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payment_id Unique identifier for a Payment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createPaymentHistoryRequest($xero_tenant_id, $payment_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createPaymentHistory'
            );
        }
        // verify the required parameter 'payment_id' is set
        if ($payment_id === null || (is_array($payment_id) && count($payment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payment_id when calling createPaymentHistory'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createPaymentHistory'
            );
        }

        $resourcePath = '/Payments/{PaymentID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($payment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PaymentID' . '}',
                ObjectSerializer::toPathValue($payment_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($history_records)) {
            $_tempBody = $history_records;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPaymentService
     *
     * Allows you to create payment services
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\PaymentServices $payment_services payment_services (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\PaymentServices|\Xero2\Accounting\Model\Error
     */
    public function createPaymentService($xero_tenant_id, $payment_services)
    {
        list($response) = $this->createPaymentServiceWithHttpInfo($xero_tenant_id, $payment_services);
        return $response;
    }

    /**
     * Operation createPaymentServiceWithHttpInfo
     *
     * Allows you to create payment services
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\PaymentServices $payment_services (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\PaymentServices|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPaymentServiceWithHttpInfo($xero_tenant_id, $payment_services)
    {
        $request = $this->createPaymentServiceRequest($xero_tenant_id, $payment_services);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\PaymentServices' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\PaymentServices', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\PaymentServices';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\PaymentServices',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createPaymentServiceAsync
     *
     * Allows you to create payment services
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\PaymentServices $payment_services (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPaymentServiceAsync($xero_tenant_id, $payment_services)
    {
        return $this->createPaymentServiceAsyncWithHttpInfo($xero_tenant_id, $payment_services)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPaymentServiceAsyncWithHttpInfo
     *
     * Allows you to create payment services
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\PaymentServices $payment_services (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPaymentServiceAsyncWithHttpInfo($xero_tenant_id, $payment_services)
    {
        $returnType = '\Xero2\Accounting\Model\PaymentServices';
        $request = $this->createPaymentServiceRequest($xero_tenant_id, $payment_services);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPaymentService'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\PaymentServices $payment_services (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createPaymentServiceRequest($xero_tenant_id, $payment_services)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createPaymentService'
            );
        }
        // verify the required parameter 'payment_services' is set
        if ($payment_services === null || (is_array($payment_services) && count($payment_services) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payment_services when calling createPaymentService'
            );
        }

        $resourcePath = '/PaymentServices';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($payment_services)) {
            $_tempBody = $payment_services;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPayments
     *
     * Allows you to create multiple payments for invoices or credit notes
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Payments $payments payments (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Payments|\Xero2\Accounting\Model\Error
     */
    public function createPayments($xero_tenant_id, $payments)
    {
        list($response) = $this->createPaymentsWithHttpInfo($xero_tenant_id, $payments);
        return $response;
    }

    /**
     * Operation createPaymentsWithHttpInfo
     *
     * Allows you to create multiple payments for invoices or credit notes
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Payments $payments (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Payments|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPaymentsWithHttpInfo($xero_tenant_id, $payments)
    {
        $request = $this->createPaymentsRequest($xero_tenant_id, $payments);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Payments' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Payments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Payments';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Payments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createPaymentsAsync
     *
     * Allows you to create multiple payments for invoices or credit notes
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Payments $payments (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPaymentsAsync($xero_tenant_id, $payments)
    {
        return $this->createPaymentsAsyncWithHttpInfo($xero_tenant_id, $payments)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPaymentsAsyncWithHttpInfo
     *
     * Allows you to create multiple payments for invoices or credit notes
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Payments $payments (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPaymentsAsyncWithHttpInfo($xero_tenant_id, $payments)
    {
        $returnType = '\Xero2\Accounting\Model\Payments';
        $request = $this->createPaymentsRequest($xero_tenant_id, $payments);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPayments'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Payments $payments (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createPaymentsRequest($xero_tenant_id, $payments)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createPayments'
            );
        }
        // verify the required parameter 'payments' is set
        if ($payments === null || (is_array($payments) && count($payments) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payments when calling createPayments'
            );
        }

        $resourcePath = '/Payments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($payments)) {
            $_tempBody = $payments;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPrepaymentAllocation
     *
     * Allows you to create an Allocation for prepayments
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $prepayment_id prepayment_id (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations allocations (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Allocations|\Xero2\Accounting\Model\Error
     */
    public function createPrepaymentAllocation($xero_tenant_id, $prepayment_id, $allocations)
    {
        list($response) = $this->createPrepaymentAllocationWithHttpInfo($xero_tenant_id, $prepayment_id, $allocations);
        return $response;
    }

    /**
     * Operation createPrepaymentAllocationWithHttpInfo
     *
     * Allows you to create an Allocation for prepayments
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $prepayment_id (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Allocations|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPrepaymentAllocationWithHttpInfo($xero_tenant_id, $prepayment_id, $allocations)
    {
        $request = $this->createPrepaymentAllocationRequest($xero_tenant_id, $prepayment_id, $allocations);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Allocations' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Allocations', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Allocations';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Allocations',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createPrepaymentAllocationAsync
     *
     * Allows you to create an Allocation for prepayments
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $prepayment_id (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPrepaymentAllocationAsync($xero_tenant_id, $prepayment_id, $allocations)
    {
        return $this->createPrepaymentAllocationAsyncWithHttpInfo($xero_tenant_id, $prepayment_id, $allocations)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPrepaymentAllocationAsyncWithHttpInfo
     *
     * Allows you to create an Allocation for prepayments
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $prepayment_id (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPrepaymentAllocationAsyncWithHttpInfo($xero_tenant_id, $prepayment_id, $allocations)
    {
        $returnType = '\Xero2\Accounting\Model\Allocations';
        $request = $this->createPrepaymentAllocationRequest($xero_tenant_id, $prepayment_id, $allocations);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPrepaymentAllocation'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $prepayment_id (required)
     * @param  \Xero2\Accounting\Model\Allocations $allocations (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createPrepaymentAllocationRequest($xero_tenant_id, $prepayment_id, $allocations)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createPrepaymentAllocation'
            );
        }
        // verify the required parameter 'prepayment_id' is set
        if ($prepayment_id === null || (is_array($prepayment_id) && count($prepayment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $prepayment_id when calling createPrepaymentAllocation'
            );
        }
        // verify the required parameter 'allocations' is set
        if ($allocations === null || (is_array($allocations) && count($allocations) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $allocations when calling createPrepaymentAllocation'
            );
        }

        $resourcePath = '/Prepayments/{PrepaymentID}/Allocations';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($prepayment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PrepaymentID' . '}',
                ObjectSerializer::toPathValue($prepayment_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($allocations)) {
            $_tempBody = $allocations;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPrepaymentHistory
     *
     * Allows you to create a history record for an Prepayment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $prepayment_id Unique identifier for a PrePayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records history_records (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error
     */
    public function createPrepaymentHistory($xero_tenant_id, $prepayment_id, $history_records)
    {
        list($response) = $this->createPrepaymentHistoryWithHttpInfo($xero_tenant_id, $prepayment_id, $history_records);
        return $response;
    }

    /**
     * Operation createPrepaymentHistoryWithHttpInfo
     *
     * Allows you to create a history record for an Prepayment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $prepayment_id Unique identifier for a PrePayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPrepaymentHistoryWithHttpInfo($xero_tenant_id, $prepayment_id, $history_records)
    {
        $request = $this->createPrepaymentHistoryRequest($xero_tenant_id, $prepayment_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createPrepaymentHistoryAsync
     *
     * Allows you to create a history record for an Prepayment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $prepayment_id Unique identifier for a PrePayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPrepaymentHistoryAsync($xero_tenant_id, $prepayment_id, $history_records)
    {
        return $this->createPrepaymentHistoryAsyncWithHttpInfo($xero_tenant_id, $prepayment_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPrepaymentHistoryAsyncWithHttpInfo
     *
     * Allows you to create a history record for an Prepayment
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $prepayment_id Unique identifier for a PrePayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPrepaymentHistoryAsyncWithHttpInfo($xero_tenant_id, $prepayment_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createPrepaymentHistoryRequest($xero_tenant_id, $prepayment_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPrepaymentHistory'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $prepayment_id Unique identifier for a PrePayment (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createPrepaymentHistoryRequest($xero_tenant_id, $prepayment_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createPrepaymentHistory'
            );
        }
        // verify the required parameter 'prepayment_id' is set
        if ($prepayment_id === null || (is_array($prepayment_id) && count($prepayment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $prepayment_id when calling createPrepaymentHistory'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createPrepaymentHistory'
            );
        }

        $resourcePath = '/Prepayments/{PrepaymentID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($prepayment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PrepaymentID' . '}',
                ObjectSerializer::toPathValue($prepayment_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($history_records)) {
            $_tempBody = $history_records;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPurchaseOrder
     *
     * Allows you to create a single purchase order
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\PurchaseOrder $purchase_order purchase_order (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\PurchaseOrders|\Xero2\Accounting\Model\Error
     */
    public function createPurchaseOrder($xero_tenant_id, $purchase_order)
    {
        list($response) = $this->createPurchaseOrderWithHttpInfo($xero_tenant_id, $purchase_order);
        return $response;
    }

    /**
     * Operation createPurchaseOrderWithHttpInfo
     *
     * Allows you to create a single purchase order
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\PurchaseOrder $purchase_order (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\PurchaseOrders|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPurchaseOrderWithHttpInfo($xero_tenant_id, $purchase_order)
    {
        $request = $this->createPurchaseOrderRequest($xero_tenant_id, $purchase_order);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\PurchaseOrders' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\PurchaseOrders', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\PurchaseOrders';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\PurchaseOrders',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createPurchaseOrderAsync
     *
     * Allows you to create a single purchase order
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\PurchaseOrder $purchase_order (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPurchaseOrderAsync($xero_tenant_id, $purchase_order)
    {
        return $this->createPurchaseOrderAsyncWithHttpInfo($xero_tenant_id, $purchase_order)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPurchaseOrderAsyncWithHttpInfo
     *
     * Allows you to create a single purchase order
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\PurchaseOrder $purchase_order (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPurchaseOrderAsyncWithHttpInfo($xero_tenant_id, $purchase_order)
    {
        $returnType = '\Xero2\Accounting\Model\PurchaseOrders';
        $request = $this->createPurchaseOrderRequest($xero_tenant_id, $purchase_order);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPurchaseOrder'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\PurchaseOrder $purchase_order (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createPurchaseOrderRequest($xero_tenant_id, $purchase_order)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createPurchaseOrder'
            );
        }
        // verify the required parameter 'purchase_order' is set
        if ($purchase_order === null || (is_array($purchase_order) && count($purchase_order) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $purchase_order when calling createPurchaseOrder'
            );
        }

        $resourcePath = '/PurchaseOrders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($purchase_order)) {
            $_tempBody = $purchase_order;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPurchaseOrderHistory
     *
     * Allows you to create HistoryRecord for purchase orders
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $purchase_order_id Unique identifier for a PurchaseOrder (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records history_records (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error
     */
    public function createPurchaseOrderHistory($xero_tenant_id, $purchase_order_id, $history_records)
    {
        list($response) = $this->createPurchaseOrderHistoryWithHttpInfo($xero_tenant_id, $purchase_order_id, $history_records);
        return $response;
    }

    /**
     * Operation createPurchaseOrderHistoryWithHttpInfo
     *
     * Allows you to create HistoryRecord for purchase orders
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $purchase_order_id Unique identifier for a PurchaseOrder (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPurchaseOrderHistoryWithHttpInfo($xero_tenant_id, $purchase_order_id, $history_records)
    {
        $request = $this->createPurchaseOrderHistoryRequest($xero_tenant_id, $purchase_order_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createPurchaseOrderHistoryAsync
     *
     * Allows you to create HistoryRecord for purchase orders
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $purchase_order_id Unique identifier for a PurchaseOrder (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPurchaseOrderHistoryAsync($xero_tenant_id, $purchase_order_id, $history_records)
    {
        return $this->createPurchaseOrderHistoryAsyncWithHttpInfo($xero_tenant_id, $purchase_order_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPurchaseOrderHistoryAsyncWithHttpInfo
     *
     * Allows you to create HistoryRecord for purchase orders
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $purchase_order_id Unique identifier for a PurchaseOrder (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPurchaseOrderHistoryAsyncWithHttpInfo($xero_tenant_id, $purchase_order_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createPurchaseOrderHistoryRequest($xero_tenant_id, $purchase_order_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPurchaseOrderHistory'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $purchase_order_id Unique identifier for a PurchaseOrder (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createPurchaseOrderHistoryRequest($xero_tenant_id, $purchase_order_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createPurchaseOrderHistory'
            );
        }
        // verify the required parameter 'purchase_order_id' is set
        if ($purchase_order_id === null || (is_array($purchase_order_id) && count($purchase_order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $purchase_order_id when calling createPurchaseOrderHistory'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createPurchaseOrderHistory'
            );
        }

        $resourcePath = '/PurchaseOrders/{PurchaseOrderID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($purchase_order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PurchaseOrderID' . '}',
                ObjectSerializer::toPathValue($purchase_order_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($history_records)) {
            $_tempBody = $history_records;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPurchaseOrders
     *
     * Allows you to create multiple purchase orders
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\PurchaseOrders $purchase_orders purchase_orders (required)
     * @param  bool $summarize_errors shows validation errors for each purchase order. (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\PurchaseOrders|\Xero2\Accounting\Model\Error
     */
    public function createPurchaseOrders($xero_tenant_id, $purchase_orders, $summarize_errors = false)
    {
        list($response) = $this->createPurchaseOrdersWithHttpInfo($xero_tenant_id, $purchase_orders, $summarize_errors);
        return $response;
    }

    /**
     * Operation createPurchaseOrdersWithHttpInfo
     *
     * Allows you to create multiple purchase orders
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\PurchaseOrders $purchase_orders (required)
     * @param  bool $summarize_errors shows validation errors for each purchase order. (optional, default to false)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\PurchaseOrders|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPurchaseOrdersWithHttpInfo($xero_tenant_id, $purchase_orders, $summarize_errors = false)
    {
        $request = $this->createPurchaseOrdersRequest($xero_tenant_id, $purchase_orders, $summarize_errors);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\PurchaseOrders' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\PurchaseOrders', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\PurchaseOrders';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\PurchaseOrders',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createPurchaseOrdersAsync
     *
     * Allows you to create multiple purchase orders
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\PurchaseOrders $purchase_orders (required)
     * @param  bool $summarize_errors shows validation errors for each purchase order. (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPurchaseOrdersAsync($xero_tenant_id, $purchase_orders, $summarize_errors = false)
    {
        return $this->createPurchaseOrdersAsyncWithHttpInfo($xero_tenant_id, $purchase_orders, $summarize_errors)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPurchaseOrdersAsyncWithHttpInfo
     *
     * Allows you to create multiple purchase orders
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\PurchaseOrders $purchase_orders (required)
     * @param  bool $summarize_errors shows validation errors for each purchase order. (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPurchaseOrdersAsyncWithHttpInfo($xero_tenant_id, $purchase_orders, $summarize_errors = false)
    {
        $returnType = '\Xero2\Accounting\Model\PurchaseOrders';
        $request = $this->createPurchaseOrdersRequest($xero_tenant_id, $purchase_orders, $summarize_errors);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPurchaseOrders'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\PurchaseOrders $purchase_orders (required)
     * @param  bool $summarize_errors shows validation errors for each purchase order. (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createPurchaseOrdersRequest($xero_tenant_id, $purchase_orders, $summarize_errors = false)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createPurchaseOrders'
            );
        }
        // verify the required parameter 'purchase_orders' is set
        if ($purchase_orders === null || (is_array($purchase_orders) && count($purchase_orders) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $purchase_orders when calling createPurchaseOrders'
            );
        }

        $resourcePath = '/PurchaseOrders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($summarize_errors !== null) {
            $queryParams['summarizeErrors'] = ObjectSerializer::toQueryValue($summarize_errors);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($purchase_orders)) {
            $_tempBody = $purchase_orders;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createReceipt
     *
     * Allows you to create draft expense claim receipts for any user
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Receipts $receipts receipts (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Receipts|\Xero2\Accounting\Model\Error
     */
    public function createReceipt($xero_tenant_id, $receipts)
    {
        list($response) = $this->createReceiptWithHttpInfo($xero_tenant_id, $receipts);
        return $response;
    }

    /**
     * Operation createReceiptWithHttpInfo
     *
     * Allows you to create draft expense claim receipts for any user
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Receipts $receipts (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Receipts|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createReceiptWithHttpInfo($xero_tenant_id, $receipts)
    {
        $request = $this->createReceiptRequest($xero_tenant_id, $receipts);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Receipts' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Receipts', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Receipts';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Receipts',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createReceiptAsync
     *
     * Allows you to create draft expense claim receipts for any user
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Receipts $receipts (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createReceiptAsync($xero_tenant_id, $receipts)
    {
        return $this->createReceiptAsyncWithHttpInfo($xero_tenant_id, $receipts)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createReceiptAsyncWithHttpInfo
     *
     * Allows you to create draft expense claim receipts for any user
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Receipts $receipts (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createReceiptAsyncWithHttpInfo($xero_tenant_id, $receipts)
    {
        $returnType = '\Xero2\Accounting\Model\Receipts';
        $request = $this->createReceiptRequest($xero_tenant_id, $receipts);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createReceipt'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\Receipts $receipts (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createReceiptRequest($xero_tenant_id, $receipts)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createReceipt'
            );
        }
        // verify the required parameter 'receipts' is set
        if ($receipts === null || (is_array($receipts) && count($receipts) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $receipts when calling createReceipt'
            );
        }

        $resourcePath = '/Receipts';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($receipts)) {
            $_tempBody = $receipts;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createReceiptAttachmentByFileName
     *
     * Allows you to create Attachment on expense claim receipts by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $receipt_id Unique identifier for a Receipt (required)
     * @param  string $file_name The name of the file being attached to the Receipt (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error
     */
    public function createReceiptAttachmentByFileName($xero_tenant_id, $receipt_id, $file_name, $body)
    {
        list($response) = $this->createReceiptAttachmentByFileNameWithHttpInfo($xero_tenant_id, $receipt_id, $file_name, $body);
        return $response;
    }

    /**
     * Operation createReceiptAttachmentByFileNameWithHttpInfo
     *
     * Allows you to create Attachment on expense claim receipts by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $receipt_id Unique identifier for a Receipt (required)
     * @param  string $file_name The name of the file being attached to the Receipt (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createReceiptAttachmentByFileNameWithHttpInfo($xero_tenant_id, $receipt_id, $file_name, $body)
    {
        $request = $this->createReceiptAttachmentByFileNameRequest($xero_tenant_id, $receipt_id, $file_name, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Attachments' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Attachments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Attachments';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Attachments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createReceiptAttachmentByFileNameAsync
     *
     * Allows you to create Attachment on expense claim receipts by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $receipt_id Unique identifier for a Receipt (required)
     * @param  string $file_name The name of the file being attached to the Receipt (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createReceiptAttachmentByFileNameAsync($xero_tenant_id, $receipt_id, $file_name, $body)
    {
        return $this->createReceiptAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $receipt_id, $file_name, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createReceiptAttachmentByFileNameAsyncWithHttpInfo
     *
     * Allows you to create Attachment on expense claim receipts by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $receipt_id Unique identifier for a Receipt (required)
     * @param  string $file_name The name of the file being attached to the Receipt (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createReceiptAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $receipt_id, $file_name, $body)
    {
        $returnType = '\Xero2\Accounting\Model\Attachments';
        $request = $this->createReceiptAttachmentByFileNameRequest($xero_tenant_id, $receipt_id, $file_name, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createReceiptAttachmentByFileName'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $receipt_id Unique identifier for a Receipt (required)
     * @param  string $file_name The name of the file being attached to the Receipt (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createReceiptAttachmentByFileNameRequest($xero_tenant_id, $receipt_id, $file_name, $body)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createReceiptAttachmentByFileName'
            );
        }
        // verify the required parameter 'receipt_id' is set
        if ($receipt_id === null || (is_array($receipt_id) && count($receipt_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $receipt_id when calling createReceiptAttachmentByFileName'
            );
        }
        // verify the required parameter 'file_name' is set
        if ($file_name === null || (is_array($file_name) && count($file_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_name when calling createReceiptAttachmentByFileName'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createReceiptAttachmentByFileName'
            );
        }

        $resourcePath = '/Receipts/{ReceiptID}/Attachments/{FileName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($receipt_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ReceiptID' . '}',
                ObjectSerializer::toPathValue($receipt_id),
                $resourcePath
            );
        }
        // path params
        if ($file_name !== null) {
            $resourcePath = str_replace(
                '{' . 'FileName' . '}',
                ObjectSerializer::toPathValue($file_name),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/octet-stream']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createReceiptHistory
     *
     * Allows you to retrieve a history records of an Receipt
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $receipt_id Unique identifier for a Receipt (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records history_records (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error
     */
    public function createReceiptHistory($xero_tenant_id, $receipt_id, $history_records)
    {
        list($response) = $this->createReceiptHistoryWithHttpInfo($xero_tenant_id, $receipt_id, $history_records);
        return $response;
    }

    /**
     * Operation createReceiptHistoryWithHttpInfo
     *
     * Allows you to retrieve a history records of an Receipt
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $receipt_id Unique identifier for a Receipt (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createReceiptHistoryWithHttpInfo($xero_tenant_id, $receipt_id, $history_records)
    {
        $request = $this->createReceiptHistoryRequest($xero_tenant_id, $receipt_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createReceiptHistoryAsync
     *
     * Allows you to retrieve a history records of an Receipt
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $receipt_id Unique identifier for a Receipt (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createReceiptHistoryAsync($xero_tenant_id, $receipt_id, $history_records)
    {
        return $this->createReceiptHistoryAsyncWithHttpInfo($xero_tenant_id, $receipt_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createReceiptHistoryAsyncWithHttpInfo
     *
     * Allows you to retrieve a history records of an Receipt
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $receipt_id Unique identifier for a Receipt (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createReceiptHistoryAsyncWithHttpInfo($xero_tenant_id, $receipt_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createReceiptHistoryRequest($xero_tenant_id, $receipt_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createReceiptHistory'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $receipt_id Unique identifier for a Receipt (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createReceiptHistoryRequest($xero_tenant_id, $receipt_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createReceiptHistory'
            );
        }
        // verify the required parameter 'receipt_id' is set
        if ($receipt_id === null || (is_array($receipt_id) && count($receipt_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $receipt_id when calling createReceiptHistory'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createReceiptHistory'
            );
        }

        $resourcePath = '/Receipts/{ReceiptID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($receipt_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ReceiptID' . '}',
                ObjectSerializer::toPathValue($receipt_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($history_records)) {
            $_tempBody = $history_records;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createRepeatingInvoiceAttachmentByFileName
     *
     * Allows you to create attachment on repeating invoices by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $repeating_invoice_id Unique identifier for a Repeating Invoice (required)
     * @param  string $file_name The name of the file being attached to a Repeating Invoice (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error
     */
    public function createRepeatingInvoiceAttachmentByFileName($xero_tenant_id, $repeating_invoice_id, $file_name, $body)
    {
        list($response) = $this->createRepeatingInvoiceAttachmentByFileNameWithHttpInfo($xero_tenant_id, $repeating_invoice_id, $file_name, $body);
        return $response;
    }

    /**
     * Operation createRepeatingInvoiceAttachmentByFileNameWithHttpInfo
     *
     * Allows you to create attachment on repeating invoices by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $repeating_invoice_id Unique identifier for a Repeating Invoice (required)
     * @param  string $file_name The name of the file being attached to a Repeating Invoice (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Attachments|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createRepeatingInvoiceAttachmentByFileNameWithHttpInfo($xero_tenant_id, $repeating_invoice_id, $file_name, $body)
    {
        $request = $this->createRepeatingInvoiceAttachmentByFileNameRequest($xero_tenant_id, $repeating_invoice_id, $file_name, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Attachments' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Attachments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Attachments';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Attachments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createRepeatingInvoiceAttachmentByFileNameAsync
     *
     * Allows you to create attachment on repeating invoices by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $repeating_invoice_id Unique identifier for a Repeating Invoice (required)
     * @param  string $file_name The name of the file being attached to a Repeating Invoice (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createRepeatingInvoiceAttachmentByFileNameAsync($xero_tenant_id, $repeating_invoice_id, $file_name, $body)
    {
        return $this->createRepeatingInvoiceAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $repeating_invoice_id, $file_name, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createRepeatingInvoiceAttachmentByFileNameAsyncWithHttpInfo
     *
     * Allows you to create attachment on repeating invoices by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $repeating_invoice_id Unique identifier for a Repeating Invoice (required)
     * @param  string $file_name The name of the file being attached to a Repeating Invoice (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createRepeatingInvoiceAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $repeating_invoice_id, $file_name, $body)
    {
        $returnType = '\Xero2\Accounting\Model\Attachments';
        $request = $this->createRepeatingInvoiceAttachmentByFileNameRequest($xero_tenant_id, $repeating_invoice_id, $file_name, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createRepeatingInvoiceAttachmentByFileName'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $repeating_invoice_id Unique identifier for a Repeating Invoice (required)
     * @param  string $file_name The name of the file being attached to a Repeating Invoice (required)
     * @param  string $body Byte array of file in body of request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createRepeatingInvoiceAttachmentByFileNameRequest($xero_tenant_id, $repeating_invoice_id, $file_name, $body)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createRepeatingInvoiceAttachmentByFileName'
            );
        }
        // verify the required parameter 'repeating_invoice_id' is set
        if ($repeating_invoice_id === null || (is_array($repeating_invoice_id) && count($repeating_invoice_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $repeating_invoice_id when calling createRepeatingInvoiceAttachmentByFileName'
            );
        }
        // verify the required parameter 'file_name' is set
        if ($file_name === null || (is_array($file_name) && count($file_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_name when calling createRepeatingInvoiceAttachmentByFileName'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createRepeatingInvoiceAttachmentByFileName'
            );
        }

        $resourcePath = '/RepeatingInvoices/{RepeatingInvoiceID}/Attachments/{FileName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($repeating_invoice_id !== null) {
            $resourcePath = str_replace(
                '{' . 'RepeatingInvoiceID' . '}',
                ObjectSerializer::toPathValue($repeating_invoice_id),
                $resourcePath
            );
        }
        // path params
        if ($file_name !== null) {
            $resourcePath = str_replace(
                '{' . 'FileName' . '}',
                ObjectSerializer::toPathValue($file_name),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/octet-stream']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createRepeatingInvoiceHistory
     *
     * Allows you to create history for a repeating invoice
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $repeating_invoice_id Unique identifier for a Repeating Invoice (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records history_records (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error
     */
    public function createRepeatingInvoiceHistory($xero_tenant_id, $repeating_invoice_id, $history_records)
    {
        list($response) = $this->createRepeatingInvoiceHistoryWithHttpInfo($xero_tenant_id, $repeating_invoice_id, $history_records);
        return $response;
    }

    /**
     * Operation createRepeatingInvoiceHistoryWithHttpInfo
     *
     * Allows you to create history for a repeating invoice
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $repeating_invoice_id Unique identifier for a Repeating Invoice (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createRepeatingInvoiceHistoryWithHttpInfo($xero_tenant_id, $repeating_invoice_id, $history_records)
    {
        $request = $this->createRepeatingInvoiceHistoryRequest($xero_tenant_id, $repeating_invoice_id, $history_records);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createRepeatingInvoiceHistoryAsync
     *
     * Allows you to create history for a repeating invoice
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $repeating_invoice_id Unique identifier for a Repeating Invoice (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createRepeatingInvoiceHistoryAsync($xero_tenant_id, $repeating_invoice_id, $history_records)
    {
        return $this->createRepeatingInvoiceHistoryAsyncWithHttpInfo($xero_tenant_id, $repeating_invoice_id, $history_records)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createRepeatingInvoiceHistoryAsyncWithHttpInfo
     *
     * Allows you to create history for a repeating invoice
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $repeating_invoice_id Unique identifier for a Repeating Invoice (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createRepeatingInvoiceHistoryAsyncWithHttpInfo($xero_tenant_id, $repeating_invoice_id, $history_records)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->createRepeatingInvoiceHistoryRequest($xero_tenant_id, $repeating_invoice_id, $history_records);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createRepeatingInvoiceHistory'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $repeating_invoice_id Unique identifier for a Repeating Invoice (required)
     * @param  \Xero2\Accounting\Model\HistoryRecords $history_records (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createRepeatingInvoiceHistoryRequest($xero_tenant_id, $repeating_invoice_id, $history_records)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createRepeatingInvoiceHistory'
            );
        }
        // verify the required parameter 'repeating_invoice_id' is set
        if ($repeating_invoice_id === null || (is_array($repeating_invoice_id) && count($repeating_invoice_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $repeating_invoice_id when calling createRepeatingInvoiceHistory'
            );
        }
        // verify the required parameter 'history_records' is set
        if ($history_records === null || (is_array($history_records) && count($history_records) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $history_records when calling createRepeatingInvoiceHistory'
            );
        }

        $resourcePath = '/RepeatingInvoices/{RepeatingInvoiceID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($repeating_invoice_id !== null) {
            $resourcePath = str_replace(
                '{' . 'RepeatingInvoiceID' . '}',
                ObjectSerializer::toPathValue($repeating_invoice_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($history_records)) {
            $_tempBody = $history_records;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createTaxRates
     *
     * Allows you to create one or more Tax Rates
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\TaxRates $tax_rates tax_rates (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\TaxRates|\Xero2\Accounting\Model\Error
     */
    public function createTaxRates($xero_tenant_id, $tax_rates)
    {
        list($response) = $this->createTaxRatesWithHttpInfo($xero_tenant_id, $tax_rates);
        return $response;
    }

    /**
     * Operation createTaxRatesWithHttpInfo
     *
     * Allows you to create one or more Tax Rates
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\TaxRates $tax_rates (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\TaxRates|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTaxRatesWithHttpInfo($xero_tenant_id, $tax_rates)
    {
        $request = $this->createTaxRatesRequest($xero_tenant_id, $tax_rates);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\TaxRates' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\TaxRates', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\TaxRates';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\TaxRates',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createTaxRatesAsync
     *
     * Allows you to create one or more Tax Rates
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\TaxRates $tax_rates (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTaxRatesAsync($xero_tenant_id, $tax_rates)
    {
        return $this->createTaxRatesAsyncWithHttpInfo($xero_tenant_id, $tax_rates)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createTaxRatesAsyncWithHttpInfo
     *
     * Allows you to create one or more Tax Rates
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\TaxRates $tax_rates (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTaxRatesAsyncWithHttpInfo($xero_tenant_id, $tax_rates)
    {
        $returnType = '\Xero2\Accounting\Model\TaxRates';
        $request = $this->createTaxRatesRequest($xero_tenant_id, $tax_rates);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createTaxRates'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\TaxRates $tax_rates (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createTaxRatesRequest($xero_tenant_id, $tax_rates)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createTaxRates'
            );
        }
        // verify the required parameter 'tax_rates' is set
        if ($tax_rates === null || (is_array($tax_rates) && count($tax_rates) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $tax_rates when calling createTaxRates'
            );
        }

        $resourcePath = '/TaxRates';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($tax_rates)) {
            $_tempBody = $tax_rates;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createTrackingCategory
     *
     * Allows you to create tracking categories
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\TrackingCategory $tracking_category tracking_category (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\TrackingCategories|\Xero2\Accounting\Model\Error
     */
    public function createTrackingCategory($xero_tenant_id, $tracking_category)
    {
        list($response) = $this->createTrackingCategoryWithHttpInfo($xero_tenant_id, $tracking_category);
        return $response;
    }

    /**
     * Operation createTrackingCategoryWithHttpInfo
     *
     * Allows you to create tracking categories
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\TrackingCategory $tracking_category (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\TrackingCategories|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTrackingCategoryWithHttpInfo($xero_tenant_id, $tracking_category)
    {
        $request = $this->createTrackingCategoryRequest($xero_tenant_id, $tracking_category);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\TrackingCategories' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\TrackingCategories', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\TrackingCategories';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\TrackingCategories',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createTrackingCategoryAsync
     *
     * Allows you to create tracking categories
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\TrackingCategory $tracking_category (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTrackingCategoryAsync($xero_tenant_id, $tracking_category)
    {
        return $this->createTrackingCategoryAsyncWithHttpInfo($xero_tenant_id, $tracking_category)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createTrackingCategoryAsyncWithHttpInfo
     *
     * Allows you to create tracking categories
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\TrackingCategory $tracking_category (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTrackingCategoryAsyncWithHttpInfo($xero_tenant_id, $tracking_category)
    {
        $returnType = '\Xero2\Accounting\Model\TrackingCategories';
        $request = $this->createTrackingCategoryRequest($xero_tenant_id, $tracking_category);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createTrackingCategory'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \Xero2\Accounting\Model\TrackingCategory $tracking_category (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createTrackingCategoryRequest($xero_tenant_id, $tracking_category)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createTrackingCategory'
            );
        }
        // verify the required parameter 'tracking_category' is set
        if ($tracking_category === null || (is_array($tracking_category) && count($tracking_category) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $tracking_category when calling createTrackingCategory'
            );
        }

        $resourcePath = '/TrackingCategories';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }


        // body params
        $_tempBody = null;
        if (isset($tracking_category)) {
            $_tempBody = $tracking_category;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createTrackingOptions
     *
     * Allows you to create options for a specified tracking category
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     * @param  \Xero2\Accounting\Model\TrackingOption $tracking_option tracking_option (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\TrackingOptions|\Xero2\Accounting\Model\Error
     */
    public function createTrackingOptions($xero_tenant_id, $tracking_category_id, $tracking_option)
    {
        list($response) = $this->createTrackingOptionsWithHttpInfo($xero_tenant_id, $tracking_category_id, $tracking_option);
        return $response;
    }

    /**
     * Operation createTrackingOptionsWithHttpInfo
     *
     * Allows you to create options for a specified tracking category
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     * @param  \Xero2\Accounting\Model\TrackingOption $tracking_option (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\TrackingOptions|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTrackingOptionsWithHttpInfo($xero_tenant_id, $tracking_category_id, $tracking_option)
    {
        $request = $this->createTrackingOptionsRequest($xero_tenant_id, $tracking_category_id, $tracking_option);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\TrackingOptions' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\TrackingOptions', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\TrackingOptions';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\TrackingOptions',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createTrackingOptionsAsync
     *
     * Allows you to create options for a specified tracking category
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     * @param  \Xero2\Accounting\Model\TrackingOption $tracking_option (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTrackingOptionsAsync($xero_tenant_id, $tracking_category_id, $tracking_option)
    {
        return $this->createTrackingOptionsAsyncWithHttpInfo($xero_tenant_id, $tracking_category_id, $tracking_option)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createTrackingOptionsAsyncWithHttpInfo
     *
     * Allows you to create options for a specified tracking category
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     * @param  \Xero2\Accounting\Model\TrackingOption $tracking_option (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTrackingOptionsAsyncWithHttpInfo($xero_tenant_id, $tracking_category_id, $tracking_option)
    {
        $returnType = '\Xero2\Accounting\Model\TrackingOptions';
        $request = $this->createTrackingOptionsRequest($xero_tenant_id, $tracking_category_id, $tracking_option);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createTrackingOptions'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     * @param  \Xero2\Accounting\Model\TrackingOption $tracking_option (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createTrackingOptionsRequest($xero_tenant_id, $tracking_category_id, $tracking_option)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createTrackingOptions'
            );
        }
        // verify the required parameter 'tracking_category_id' is set
        if ($tracking_category_id === null || (is_array($tracking_category_id) && count($tracking_category_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $tracking_category_id when calling createTrackingOptions'
            );
        }
        // verify the required parameter 'tracking_option' is set
        if ($tracking_option === null || (is_array($tracking_option) && count($tracking_option) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $tracking_option when calling createTrackingOptions'
            );
        }

        $resourcePath = '/TrackingCategories/{TrackingCategoryID}/Options';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($tracking_category_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TrackingCategoryID' . '}',
                ObjectSerializer::toPathValue($tracking_category_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($tracking_option)) {
            $_tempBody = $tracking_option;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteAccount
     *
     * Allows you to delete a chart of accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for retrieving single object (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Accounts|\Xero2\Accounting\Model\Error
     */
    public function deleteAccount($xero_tenant_id, $account_id)
    {
        list($response) = $this->deleteAccountWithHttpInfo($xero_tenant_id, $account_id);
        return $response;
    }

    /**
     * Operation deleteAccountWithHttpInfo
     *
     * Allows you to delete a chart of accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for retrieving single object (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Accounts|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteAccountWithHttpInfo($xero_tenant_id, $account_id)
    {
        $request = $this->deleteAccountRequest($xero_tenant_id, $account_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Accounts' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Accounts', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Accounts';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Accounts',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteAccountAsync
     *
     * Allows you to delete a chart of accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for retrieving single object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteAccountAsync($xero_tenant_id, $account_id)
    {
        return $this->deleteAccountAsyncWithHttpInfo($xero_tenant_id, $account_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteAccountAsyncWithHttpInfo
     *
     * Allows you to delete a chart of accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for retrieving single object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteAccountAsyncWithHttpInfo($xero_tenant_id, $account_id)
    {
        $returnType = '\Xero2\Accounting\Model\Accounts';
        $request = $this->deleteAccountRequest($xero_tenant_id, $account_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteAccount'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for retrieving single object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function deleteAccountRequest($xero_tenant_id, $account_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deleteAccount'
            );
        }
        // verify the required parameter 'account_id' is set
        if ($account_id === null || (is_array($account_id) && count($account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $account_id when calling deleteAccount'
            );
        }

        $resourcePath = '/Accounts/{AccountID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                '{' . 'AccountID' . '}',
                ObjectSerializer::toPathValue($account_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteContactGroupContact
     *
     * Allows you to delete a specific Contact from a Contract Group
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteContactGroupContact($xero_tenant_id, $contact_group_id, $contact_id)
    {
        $this->deleteContactGroupContactWithHttpInfo($xero_tenant_id, $contact_group_id, $contact_id);
    }

    /**
     * Operation deleteContactGroupContactWithHttpInfo
     *
     * Allows you to delete a specific Contact from a Contract Group
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteContactGroupContactWithHttpInfo($xero_tenant_id, $contact_group_id, $contact_id)
    {
        $request = $this->deleteContactGroupContactRequest($xero_tenant_id, $contact_group_id, $contact_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteContactGroupContactAsync
     *
     * Allows you to delete a specific Contact from a Contract Group
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteContactGroupContactAsync($xero_tenant_id, $contact_group_id, $contact_id)
    {
        return $this->deleteContactGroupContactAsyncWithHttpInfo($xero_tenant_id, $contact_group_id, $contact_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteContactGroupContactAsyncWithHttpInfo
     *
     * Allows you to delete a specific Contact from a Contract Group
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteContactGroupContactAsyncWithHttpInfo($xero_tenant_id, $contact_group_id, $contact_id)
    {
        $returnType = '';
        $request = $this->deleteContactGroupContactRequest($xero_tenant_id, $contact_group_id, $contact_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteContactGroupContact'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     * @param  string $contact_id Unique identifier for a Contact (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function deleteContactGroupContactRequest($xero_tenant_id, $contact_group_id, $contact_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deleteContactGroupContact'
            );
        }
        // verify the required parameter 'contact_group_id' is set
        if ($contact_group_id === null || (is_array($contact_group_id) && count($contact_group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $contact_group_id when calling deleteContactGroupContact'
            );
        }
        // verify the required parameter 'contact_id' is set
        if ($contact_id === null || (is_array($contact_id) && count($contact_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $contact_id when calling deleteContactGroupContact'
            );
        }

        $resourcePath = '/ContactGroups/{ContactGroupID}/Contacts/{ContactID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($contact_group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ContactGroupID' . '}',
                ObjectSerializer::toPathValue($contact_group_id),
                $resourcePath
            );
        }
        // path params
        if ($contact_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ContactID' . '}',
                ObjectSerializer::toPathValue($contact_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteContactGroupContacts
     *
     * Allows you to delete  all Contacts from a Contract Group
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteContactGroupContacts($xero_tenant_id, $contact_group_id)
    {
        $this->deleteContactGroupContactsWithHttpInfo($xero_tenant_id, $contact_group_id);
    }

    /**
     * Operation deleteContactGroupContactsWithHttpInfo
     *
     * Allows you to delete  all Contacts from a Contract Group
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteContactGroupContactsWithHttpInfo($xero_tenant_id, $contact_group_id)
    {
        $request = $this->deleteContactGroupContactsRequest($xero_tenant_id, $contact_group_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteContactGroupContactsAsync
     *
     * Allows you to delete  all Contacts from a Contract Group
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteContactGroupContactsAsync($xero_tenant_id, $contact_group_id)
    {
        return $this->deleteContactGroupContactsAsyncWithHttpInfo($xero_tenant_id, $contact_group_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteContactGroupContactsAsyncWithHttpInfo
     *
     * Allows you to delete  all Contacts from a Contract Group
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteContactGroupContactsAsyncWithHttpInfo($xero_tenant_id, $contact_group_id)
    {
        $returnType = '';
        $request = $this->deleteContactGroupContactsRequest($xero_tenant_id, $contact_group_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteContactGroupContacts'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $contact_group_id Unique identifier for a Contact Group (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function deleteContactGroupContactsRequest($xero_tenant_id, $contact_group_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deleteContactGroupContacts'
            );
        }
        // verify the required parameter 'contact_group_id' is set
        if ($contact_group_id === null || (is_array($contact_group_id) && count($contact_group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $contact_group_id when calling deleteContactGroupContacts'
            );
        }

        $resourcePath = '/ContactGroups/{ContactGroupID}/Contacts';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($contact_group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ContactGroupID' . '}',
                ObjectSerializer::toPathValue($contact_group_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteItem
     *
     * Allows you to delete a specified item
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $item_id Unique identifier for an Item (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteItem($xero_tenant_id, $item_id)
    {
        $this->deleteItemWithHttpInfo($xero_tenant_id, $item_id);
    }

    /**
     * Operation deleteItemWithHttpInfo
     *
     * Allows you to delete a specified item
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $item_id Unique identifier for an Item (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteItemWithHttpInfo($xero_tenant_id, $item_id)
    {
        $request = $this->deleteItemRequest($xero_tenant_id, $item_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteItemAsync
     *
     * Allows you to delete a specified item
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $item_id Unique identifier for an Item (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteItemAsync($xero_tenant_id, $item_id)
    {
        return $this->deleteItemAsyncWithHttpInfo($xero_tenant_id, $item_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteItemAsyncWithHttpInfo
     *
     * Allows you to delete a specified item
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $item_id Unique identifier for an Item (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteItemAsyncWithHttpInfo($xero_tenant_id, $item_id)
    {
        $returnType = '';
        $request = $this->deleteItemRequest($xero_tenant_id, $item_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteItem'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $item_id Unique identifier for an Item (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function deleteItemRequest($xero_tenant_id, $item_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deleteItem'
            );
        }
        // verify the required parameter 'item_id' is set
        if ($item_id === null || (is_array($item_id) && count($item_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $item_id when calling deleteItem'
            );
        }

        $resourcePath = '/Items/{ItemID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($item_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ItemID' . '}',
                ObjectSerializer::toPathValue($item_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteLinkedTransaction
     *
     * Allows you to delete a specified linked transactions (billable expenses)
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $linked_transaction_id Unique identifier for a LinkedTransaction (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteLinkedTransaction($xero_tenant_id, $linked_transaction_id)
    {
        $this->deleteLinkedTransactionWithHttpInfo($xero_tenant_id, $linked_transaction_id);
    }

    /**
     * Operation deleteLinkedTransactionWithHttpInfo
     *
     * Allows you to delete a specified linked transactions (billable expenses)
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $linked_transaction_id Unique identifier for a LinkedTransaction (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteLinkedTransactionWithHttpInfo($xero_tenant_id, $linked_transaction_id)
    {
        $request = $this->deleteLinkedTransactionRequest($xero_tenant_id, $linked_transaction_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteLinkedTransactionAsync
     *
     * Allows you to delete a specified linked transactions (billable expenses)
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $linked_transaction_id Unique identifier for a LinkedTransaction (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteLinkedTransactionAsync($xero_tenant_id, $linked_transaction_id)
    {
        return $this->deleteLinkedTransactionAsyncWithHttpInfo($xero_tenant_id, $linked_transaction_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteLinkedTransactionAsyncWithHttpInfo
     *
     * Allows you to delete a specified linked transactions (billable expenses)
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $linked_transaction_id Unique identifier for a LinkedTransaction (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteLinkedTransactionAsyncWithHttpInfo($xero_tenant_id, $linked_transaction_id)
    {
        $returnType = '';
        $request = $this->deleteLinkedTransactionRequest($xero_tenant_id, $linked_transaction_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteLinkedTransaction'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $linked_transaction_id Unique identifier for a LinkedTransaction (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function deleteLinkedTransactionRequest($xero_tenant_id, $linked_transaction_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deleteLinkedTransaction'
            );
        }
        // verify the required parameter 'linked_transaction_id' is set
        if ($linked_transaction_id === null || (is_array($linked_transaction_id) && count($linked_transaction_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $linked_transaction_id when calling deleteLinkedTransaction'
            );
        }

        $resourcePath = '/LinkedTransactions/{LinkedTransactionID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($linked_transaction_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LinkedTransactionID' . '}',
                ObjectSerializer::toPathValue($linked_transaction_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deletePayment
     *
     * Allows you to update a specified payment for invoices and credit notes
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payment_id Unique identifier for a Payment (required)
     * @param  \Xero2\Accounting\Model\Payments $payments payments (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Payments|\Xero2\Accounting\Model\Error
     */
    public function deletePayment($xero_tenant_id, $payment_id, $payments)
    {
        list($response) = $this->deletePaymentWithHttpInfo($xero_tenant_id, $payment_id, $payments);
        return $response;
    }

    /**
     * Operation deletePaymentWithHttpInfo
     *
     * Allows you to update a specified payment for invoices and credit notes
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payment_id Unique identifier for a Payment (required)
     * @param  \Xero2\Accounting\Model\Payments $payments (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Payments|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function deletePaymentWithHttpInfo($xero_tenant_id, $payment_id, $payments)
    {
        $request = $this->deletePaymentRequest($xero_tenant_id, $payment_id, $payments);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Payments' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Payments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Payments';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Payments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deletePaymentAsync
     *
     * Allows you to update a specified payment for invoices and credit notes
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payment_id Unique identifier for a Payment (required)
     * @param  \Xero2\Accounting\Model\Payments $payments (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deletePaymentAsync($xero_tenant_id, $payment_id, $payments)
    {
        return $this->deletePaymentAsyncWithHttpInfo($xero_tenant_id, $payment_id, $payments)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deletePaymentAsyncWithHttpInfo
     *
     * Allows you to update a specified payment for invoices and credit notes
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payment_id Unique identifier for a Payment (required)
     * @param  \Xero2\Accounting\Model\Payments $payments (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deletePaymentAsyncWithHttpInfo($xero_tenant_id, $payment_id, $payments)
    {
        $returnType = '\Xero2\Accounting\Model\Payments';
        $request = $this->deletePaymentRequest($xero_tenant_id, $payment_id, $payments);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deletePayment'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payment_id Unique identifier for a Payment (required)
     * @param  \Xero2\Accounting\Model\Payments $payments (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function deletePaymentRequest($xero_tenant_id, $payment_id, $payments)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deletePayment'
            );
        }
        // verify the required parameter 'payment_id' is set
        if ($payment_id === null || (is_array($payment_id) && count($payment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payment_id when calling deletePayment'
            );
        }
        // verify the required parameter 'payments' is set
        if ($payments === null || (is_array($payments) && count($payments) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payments when calling deletePayment'
            );
        }

        $resourcePath = '/Payments/{PaymentID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($payment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PaymentID' . '}',
                ObjectSerializer::toPathValue($payment_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($payments)) {
            $_tempBody = $payments;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteTrackingCategory
     *
     * Allows you to delete tracking categories
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\TrackingCategories|\Xero2\Accounting\Model\Error
     */
    public function deleteTrackingCategory($xero_tenant_id, $tracking_category_id)
    {
        list($response) = $this->deleteTrackingCategoryWithHttpInfo($xero_tenant_id, $tracking_category_id);
        return $response;
    }

    /**
     * Operation deleteTrackingCategoryWithHttpInfo
     *
     * Allows you to delete tracking categories
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\TrackingCategories|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTrackingCategoryWithHttpInfo($xero_tenant_id, $tracking_category_id)
    {
        $request = $this->deleteTrackingCategoryRequest($xero_tenant_id, $tracking_category_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\TrackingCategories' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\TrackingCategories', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\TrackingCategories';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\TrackingCategories',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteTrackingCategoryAsync
     *
     * Allows you to delete tracking categories
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteTrackingCategoryAsync($xero_tenant_id, $tracking_category_id)
    {
        return $this->deleteTrackingCategoryAsyncWithHttpInfo($xero_tenant_id, $tracking_category_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteTrackingCategoryAsyncWithHttpInfo
     *
     * Allows you to delete tracking categories
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteTrackingCategoryAsyncWithHttpInfo($xero_tenant_id, $tracking_category_id)
    {
        $returnType = '\Xero2\Accounting\Model\TrackingCategories';
        $request = $this->deleteTrackingCategoryRequest($xero_tenant_id, $tracking_category_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteTrackingCategory'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function deleteTrackingCategoryRequest($xero_tenant_id, $tracking_category_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deleteTrackingCategory'
            );
        }
        // verify the required parameter 'tracking_category_id' is set
        if ($tracking_category_id === null || (is_array($tracking_category_id) && count($tracking_category_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $tracking_category_id when calling deleteTrackingCategory'
            );
        }

        $resourcePath = '/TrackingCategories/{TrackingCategoryID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($tracking_category_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TrackingCategoryID' . '}',
                ObjectSerializer::toPathValue($tracking_category_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteTrackingOptions
     *
     * Allows you to delete a specified option for a specified tracking category
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     * @param  string $tracking_option_id Unique identifier for a Tracking Option (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\TrackingOptions|\Xero2\Accounting\Model\Error
     */
    public function deleteTrackingOptions($xero_tenant_id, $tracking_category_id, $tracking_option_id)
    {
        list($response) = $this->deleteTrackingOptionsWithHttpInfo($xero_tenant_id, $tracking_category_id, $tracking_option_id);
        return $response;
    }

    /**
     * Operation deleteTrackingOptionsWithHttpInfo
     *
     * Allows you to delete a specified option for a specified tracking category
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     * @param  string $tracking_option_id Unique identifier for a Tracking Option (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\TrackingOptions|\Xero2\Accounting\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTrackingOptionsWithHttpInfo($xero_tenant_id, $tracking_category_id, $tracking_option_id)
    {
        $request = $this->deleteTrackingOptionsRequest($xero_tenant_id, $tracking_category_id, $tracking_option_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\TrackingOptions' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\TrackingOptions', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Xero2\Accounting\Model\Error' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\TrackingOptions';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\TrackingOptions',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteTrackingOptionsAsync
     *
     * Allows you to delete a specified option for a specified tracking category
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     * @param  string $tracking_option_id Unique identifier for a Tracking Option (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteTrackingOptionsAsync($xero_tenant_id, $tracking_category_id, $tracking_option_id)
    {
        return $this->deleteTrackingOptionsAsyncWithHttpInfo($xero_tenant_id, $tracking_category_id, $tracking_option_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteTrackingOptionsAsyncWithHttpInfo
     *
     * Allows you to delete a specified option for a specified tracking category
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     * @param  string $tracking_option_id Unique identifier for a Tracking Option (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteTrackingOptionsAsyncWithHttpInfo($xero_tenant_id, $tracking_category_id, $tracking_option_id)
    {
        $returnType = '\Xero2\Accounting\Model\TrackingOptions';
        $request = $this->deleteTrackingOptionsRequest($xero_tenant_id, $tracking_category_id, $tracking_option_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteTrackingOptions'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $tracking_category_id Unique identifier for a TrackingCategory (required)
     * @param  string $tracking_option_id Unique identifier for a Tracking Option (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function deleteTrackingOptionsRequest($xero_tenant_id, $tracking_category_id, $tracking_option_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deleteTrackingOptions'
            );
        }
        // verify the required parameter 'tracking_category_id' is set
        if ($tracking_category_id === null || (is_array($tracking_category_id) && count($tracking_category_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $tracking_category_id when calling deleteTrackingOptions'
            );
        }
        // verify the required parameter 'tracking_option_id' is set
        if ($tracking_option_id === null || (is_array($tracking_option_id) && count($tracking_option_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $tracking_option_id when calling deleteTrackingOptions'
            );
        }

        $resourcePath = '/TrackingCategories/{TrackingCategoryID}/Options/{TrackingOptionID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($tracking_category_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TrackingCategoryID' . '}',
                ObjectSerializer::toPathValue($tracking_category_id),
                $resourcePath
            );
        }
        // path params
        if ($tracking_option_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TrackingOptionID' . '}',
                ObjectSerializer::toPathValue($tracking_option_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation emailInvoice
     *
     * Allows you to email a copy of invoice to related Contact
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  \Xero2\Accounting\Model\RequestEmpty $request_empty request_empty (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function emailInvoice($xero_tenant_id, $invoice_id, $request_empty)
    {
        $this->emailInvoiceWithHttpInfo($xero_tenant_id, $invoice_id, $request_empty);
    }

    /**
     * Operation emailInvoiceWithHttpInfo
     *
     * Allows you to email a copy of invoice to related Contact
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  \Xero2\Accounting\Model\RequestEmpty $request_empty (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function emailInvoiceWithHttpInfo($xero_tenant_id, $invoice_id, $request_empty)
    {
        $request = $this->emailInvoiceRequest($xero_tenant_id, $invoice_id, $request_empty);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation emailInvoiceAsync
     *
     * Allows you to email a copy of invoice to related Contact
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  \Xero2\Accounting\Model\RequestEmpty $request_empty (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function emailInvoiceAsync($xero_tenant_id, $invoice_id, $request_empty)
    {
        return $this->emailInvoiceAsyncWithHttpInfo($xero_tenant_id, $invoice_id, $request_empty)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation emailInvoiceAsyncWithHttpInfo
     *
     * Allows you to email a copy of invoice to related Contact
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  \Xero2\Accounting\Model\RequestEmpty $request_empty (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function emailInvoiceAsyncWithHttpInfo($xero_tenant_id, $invoice_id, $request_empty)
    {
        $returnType = '';
        $request = $this->emailInvoiceRequest($xero_tenant_id, $invoice_id, $request_empty);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'emailInvoice'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $invoice_id Unique identifier for an Invoice (required)
     * @param  \Xero2\Accounting\Model\RequestEmpty $request_empty (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function emailInvoiceRequest($xero_tenant_id, $invoice_id, $request_empty)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling emailInvoice'
            );
        }
        // verify the required parameter 'invoice_id' is set
        if ($invoice_id === null || (is_array($invoice_id) && count($invoice_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $invoice_id when calling emailInvoice'
            );
        }
        // verify the required parameter 'request_empty' is set
        if ($request_empty === null || (is_array($request_empty) && count($request_empty) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $request_empty when calling emailInvoice'
            );
        }

        $resourcePath = '/Invoices/{InvoiceID}/Email';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($invoice_id !== null) {
            $resourcePath = str_replace(
                '{' . 'InvoiceID' . '}',
                ObjectSerializer::toPathValue($invoice_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($request_empty)) {
            $_tempBody = $request_empty;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAccount
     *
     * Allows you to retrieve a single chart of accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for retrieving single object (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Accounts
     */
    public function getAccount($xero_tenant_id, $account_id)
    {
        list($response) = $this->getAccountWithHttpInfo($xero_tenant_id, $account_id);
        return $response;
    }

    /**
     * Operation getAccountWithHttpInfo
     *
     * Allows you to retrieve a single chart of accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for retrieving single object (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Accounts, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAccountWithHttpInfo($xero_tenant_id, $account_id)
    {
        $request = $this->getAccountRequest($xero_tenant_id, $account_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Accounts' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Accounts', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Accounts';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Accounts',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAccountAsync
     *
     * Allows you to retrieve a single chart of accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for retrieving single object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAccountAsync($xero_tenant_id, $account_id)
    {
        return $this->getAccountAsyncWithHttpInfo($xero_tenant_id, $account_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAccountAsyncWithHttpInfo
     *
     * Allows you to retrieve a single chart of accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for retrieving single object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAccountAsyncWithHttpInfo($xero_tenant_id, $account_id)
    {
        $returnType = '\Xero2\Accounting\Model\Accounts';
        $request = $this->getAccountRequest($xero_tenant_id, $account_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAccount'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for retrieving single object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getAccountRequest($xero_tenant_id, $account_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getAccount'
            );
        }
        // verify the required parameter 'account_id' is set
        if ($account_id === null || (is_array($account_id) && count($account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $account_id when calling getAccount'
            );
        }

        $resourcePath = '/Accounts/{AccountID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                '{' . 'AccountID' . '}',
                ObjectSerializer::toPathValue($account_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAccountAttachmentByFileName
     *
     * Allows you to retrieve Attachment on Account by Filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SplFileObject
     */
    public function getAccountAttachmentByFileName($xero_tenant_id, $account_id, $file_name, $content_type)
    {
        list($response) = $this->getAccountAttachmentByFileNameWithHttpInfo($xero_tenant_id, $account_id, $file_name, $content_type);
        return $response;
    }

    /**
     * Operation getAccountAttachmentByFileNameWithHttpInfo
     *
     * Allows you to retrieve Attachment on Account by Filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAccountAttachmentByFileNameWithHttpInfo($xero_tenant_id, $account_id, $file_name, $content_type)
    {
        $request = $this->getAccountAttachmentByFileNameRequest($xero_tenant_id, $account_id, $file_name, $content_type);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\SplFileObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SplFileObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SplFileObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SplFileObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAccountAttachmentByFileNameAsync
     *
     * Allows you to retrieve Attachment on Account by Filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAccountAttachmentByFileNameAsync($xero_tenant_id, $account_id, $file_name, $content_type)
    {
        return $this->getAccountAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $account_id, $file_name, $content_type)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAccountAttachmentByFileNameAsyncWithHttpInfo
     *
     * Allows you to retrieve Attachment on Account by Filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAccountAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $account_id, $file_name, $content_type)
    {
        $returnType = '\SplFileObject';
        $request = $this->getAccountAttachmentByFileNameRequest($xero_tenant_id, $account_id, $file_name, $content_type);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAccountAttachmentByFileName'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $file_name Name of the attachment (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getAccountAttachmentByFileNameRequest($xero_tenant_id, $account_id, $file_name, $content_type)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getAccountAttachmentByFileName'
            );
        }
        // verify the required parameter 'account_id' is set
        if ($account_id === null || (is_array($account_id) && count($account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $account_id when calling getAccountAttachmentByFileName'
            );
        }
        // verify the required parameter 'file_name' is set
        if ($file_name === null || (is_array($file_name) && count($file_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_name when calling getAccountAttachmentByFileName'
            );
        }
        // verify the required parameter 'content_type' is set
        if ($content_type === null || (is_array($content_type) && count($content_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $content_type when calling getAccountAttachmentByFileName'
            );
        }

        $resourcePath = '/Accounts/{AccountID}/Attachments/{FileName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($content_type !== null) {
            $headerParams['contentType'] = ObjectSerializer::toHeaderValue($content_type);
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                '{' . 'AccountID' . '}',
                ObjectSerializer::toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($file_name !== null) {
            $resourcePath = str_replace(
                '{' . 'FileName' . '}',
                ObjectSerializer::toPathValue($file_name),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/octet-stream']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/octet-stream'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAccountAttachmentById
     *
     * Allows you to retrieve specific Attachment on Account
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $attachment_id Unique identifier for Attachment object (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SplFileObject
     */
    public function getAccountAttachmentById($xero_tenant_id, $account_id, $attachment_id, $content_type)
    {
        list($response) = $this->getAccountAttachmentByIdWithHttpInfo($xero_tenant_id, $account_id, $attachment_id, $content_type);
        return $response;
    }

    /**
     * Operation getAccountAttachmentByIdWithHttpInfo
     *
     * Allows you to retrieve specific Attachment on Account
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $attachment_id Unique identifier for Attachment object (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAccountAttachmentByIdWithHttpInfo($xero_tenant_id, $account_id, $attachment_id, $content_type)
    {
        $request = $this->getAccountAttachmentByIdRequest($xero_tenant_id, $account_id, $attachment_id, $content_type);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\SplFileObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SplFileObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SplFileObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SplFileObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAccountAttachmentByIdAsync
     *
     * Allows you to retrieve specific Attachment on Account
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $attachment_id Unique identifier for Attachment object (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAccountAttachmentByIdAsync($xero_tenant_id, $account_id, $attachment_id, $content_type)
    {
        return $this->getAccountAttachmentByIdAsyncWithHttpInfo($xero_tenant_id, $account_id, $attachment_id, $content_type)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAccountAttachmentByIdAsyncWithHttpInfo
     *
     * Allows you to retrieve specific Attachment on Account
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $attachment_id Unique identifier for Attachment object (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAccountAttachmentByIdAsyncWithHttpInfo($xero_tenant_id, $account_id, $attachment_id, $content_type)
    {
        $returnType = '\SplFileObject';
        $request = $this->getAccountAttachmentByIdRequest($xero_tenant_id, $account_id, $attachment_id, $content_type);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAccountAttachmentById'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     * @param  string $attachment_id Unique identifier for Attachment object (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getAccountAttachmentByIdRequest($xero_tenant_id, $account_id, $attachment_id, $content_type)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getAccountAttachmentById'
            );
        }
        // verify the required parameter 'account_id' is set
        if ($account_id === null || (is_array($account_id) && count($account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $account_id when calling getAccountAttachmentById'
            );
        }
        // verify the required parameter 'attachment_id' is set
        if ($attachment_id === null || (is_array($attachment_id) && count($attachment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $attachment_id when calling getAccountAttachmentById'
            );
        }
        // verify the required parameter 'content_type' is set
        if ($content_type === null || (is_array($content_type) && count($content_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $content_type when calling getAccountAttachmentById'
            );
        }

        $resourcePath = '/Accounts/{AccountID}/Attachments/{AttachmentID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($content_type !== null) {
            $headerParams['contentType'] = ObjectSerializer::toHeaderValue($content_type);
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                '{' . 'AccountID' . '}',
                ObjectSerializer::toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($attachment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'AttachmentID' . '}',
                ObjectSerializer::toPathValue($attachment_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/octet-stream']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/octet-stream'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAccountAttachments
     *
     * Allows you to retrieve Attachments for accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Attachments
     */
    public function getAccountAttachments($xero_tenant_id, $account_id)
    {
        list($response) = $this->getAccountAttachmentsWithHttpInfo($xero_tenant_id, $account_id);
        return $response;
    }

    /**
     * Operation getAccountAttachmentsWithHttpInfo
     *
     * Allows you to retrieve Attachments for accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Attachments, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAccountAttachmentsWithHttpInfo($xero_tenant_id, $account_id)
    {
        $request = $this->getAccountAttachmentsRequest($xero_tenant_id, $account_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Attachments' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Attachments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Attachments';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Attachments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAccountAttachmentsAsync
     *
     * Allows you to retrieve Attachments for accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAccountAttachmentsAsync($xero_tenant_id, $account_id)
    {
        return $this->getAccountAttachmentsAsyncWithHttpInfo($xero_tenant_id, $account_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAccountAttachmentsAsyncWithHttpInfo
     *
     * Allows you to retrieve Attachments for accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAccountAttachmentsAsyncWithHttpInfo($xero_tenant_id, $account_id)
    {
        $returnType = '\Xero2\Accounting\Model\Attachments';
        $request = $this->getAccountAttachmentsRequest($xero_tenant_id, $account_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAccountAttachments'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $account_id Unique identifier for Account object (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getAccountAttachmentsRequest($xero_tenant_id, $account_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getAccountAttachments'
            );
        }
        // verify the required parameter 'account_id' is set
        if ($account_id === null || (is_array($account_id) && count($account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $account_id when calling getAccountAttachments'
            );
        }

        $resourcePath = '/Accounts/{AccountID}/Attachments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                '{' . 'AccountID' . '}',
                ObjectSerializer::toPathValue($account_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAccounts
     *
     * Allows you to retrieve the full chart of accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \DateTime $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Accounts
     */
    public function getAccounts($xero_tenant_id, $if_modified_since = null, $where = null, $order = null)
    {
        list($response) = $this->getAccountsWithHttpInfo($xero_tenant_id, $if_modified_since, $where, $order);
        return $response;
    }

    /**
     * Operation getAccountsWithHttpInfo
     *
     * Allows you to retrieve the full chart of accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \DateTime $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Accounts, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAccountsWithHttpInfo($xero_tenant_id, $if_modified_since = null, $where = null, $order = null)
    {
        $request = $this->getAccountsRequest($xero_tenant_id, $if_modified_since, $where, $order);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Accounts' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Accounts', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Accounts';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Accounts',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAccountsAsync
     *
     * Allows you to retrieve the full chart of accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \DateTime $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAccountsAsync($xero_tenant_id, $if_modified_since = null, $where = null, $order = null)
    {
        return $this->getAccountsAsyncWithHttpInfo($xero_tenant_id, $if_modified_since, $where, $order)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAccountsAsyncWithHttpInfo
     *
     * Allows you to retrieve the full chart of accounts
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \DateTime $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAccountsAsyncWithHttpInfo($xero_tenant_id, $if_modified_since = null, $where = null, $order = null)
    {
        $returnType = '\Xero2\Accounting\Model\Accounts';
        $request = $this->getAccountsRequest($xero_tenant_id, $if_modified_since, $where, $order);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAccounts'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \DateTime $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getAccountsRequest($xero_tenant_id, $if_modified_since = null, $where = null, $order = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getAccounts'
            );
        }

        $resourcePath = '/Accounts';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($where !== null) {
            $queryParams['where'] = ObjectSerializer::toQueryValue($where);
        }
        // query params
        if ($order !== null) {
            $queryParams['order'] = ObjectSerializer::toQueryValue($order);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($if_modified_since !== null) {
            $headerParams['If-Modified-Since'] = ObjectSerializer::toHeaderValue($if_modified_since);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBankTransaction
     *
     * Allows you to retrieve a single spend or receive money transaction
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\BankTransactions
     */
    public function getBankTransaction($xero_tenant_id, $bank_transaction_id)
    {
        list($response) = $this->getBankTransactionWithHttpInfo($xero_tenant_id, $bank_transaction_id);
        return $response;
    }

    /**
     * Operation getBankTransactionWithHttpInfo
     *
     * Allows you to retrieve a single spend or receive money transaction
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\BankTransactions, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBankTransactionWithHttpInfo($xero_tenant_id, $bank_transaction_id)
    {
        $request = $this->getBankTransactionRequest($xero_tenant_id, $bank_transaction_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\BankTransactions' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\BankTransactions', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\BankTransactions';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\BankTransactions',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getBankTransactionAsync
     *
     * Allows you to retrieve a single spend or receive money transaction
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankTransactionAsync($xero_tenant_id, $bank_transaction_id)
    {
        return $this->getBankTransactionAsyncWithHttpInfo($xero_tenant_id, $bank_transaction_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getBankTransactionAsyncWithHttpInfo
     *
     * Allows you to retrieve a single spend or receive money transaction
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankTransactionAsyncWithHttpInfo($xero_tenant_id, $bank_transaction_id)
    {
        $returnType = '\Xero2\Accounting\Model\BankTransactions';
        $request = $this->getBankTransactionRequest($xero_tenant_id, $bank_transaction_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBankTransaction'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getBankTransactionRequest($xero_tenant_id, $bank_transaction_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getBankTransaction'
            );
        }
        // verify the required parameter 'bank_transaction_id' is set
        if ($bank_transaction_id === null || (is_array($bank_transaction_id) && count($bank_transaction_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bank_transaction_id when calling getBankTransaction'
            );
        }

        $resourcePath = '/BankTransactions/{BankTransactionID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($bank_transaction_id !== null) {
            $resourcePath = str_replace(
                '{' . 'BankTransactionID' . '}',
                ObjectSerializer::toPathValue($bank_transaction_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBankTransactionAttachmentByFileName
     *
     * Allows you to retrieve Attachments on BankTransaction by Filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $file_name The name of the file being attached (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SplFileObject
     */
    public function getBankTransactionAttachmentByFileName($xero_tenant_id, $bank_transaction_id, $file_name, $content_type)
    {
        list($response) = $this->getBankTransactionAttachmentByFileNameWithHttpInfo($xero_tenant_id, $bank_transaction_id, $file_name, $content_type);
        return $response;
    }

    /**
     * Operation getBankTransactionAttachmentByFileNameWithHttpInfo
     *
     * Allows you to retrieve Attachments on BankTransaction by Filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $file_name The name of the file being attached (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBankTransactionAttachmentByFileNameWithHttpInfo($xero_tenant_id, $bank_transaction_id, $file_name, $content_type)
    {
        $request = $this->getBankTransactionAttachmentByFileNameRequest($xero_tenant_id, $bank_transaction_id, $file_name, $content_type);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\SplFileObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SplFileObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SplFileObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SplFileObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getBankTransactionAttachmentByFileNameAsync
     *
     * Allows you to retrieve Attachments on BankTransaction by Filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $file_name The name of the file being attached (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankTransactionAttachmentByFileNameAsync($xero_tenant_id, $bank_transaction_id, $file_name, $content_type)
    {
        return $this->getBankTransactionAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $bank_transaction_id, $file_name, $content_type)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getBankTransactionAttachmentByFileNameAsyncWithHttpInfo
     *
     * Allows you to retrieve Attachments on BankTransaction by Filename
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $file_name The name of the file being attached (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankTransactionAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $bank_transaction_id, $file_name, $content_type)
    {
        $returnType = '\SplFileObject';
        $request = $this->getBankTransactionAttachmentByFileNameRequest($xero_tenant_id, $bank_transaction_id, $file_name, $content_type);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBankTransactionAttachmentByFileName'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $file_name The name of the file being attached (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getBankTransactionAttachmentByFileNameRequest($xero_tenant_id, $bank_transaction_id, $file_name, $content_type)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getBankTransactionAttachmentByFileName'
            );
        }
        // verify the required parameter 'bank_transaction_id' is set
        if ($bank_transaction_id === null || (is_array($bank_transaction_id) && count($bank_transaction_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bank_transaction_id when calling getBankTransactionAttachmentByFileName'
            );
        }
        // verify the required parameter 'file_name' is set
        if ($file_name === null || (is_array($file_name) && count($file_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_name when calling getBankTransactionAttachmentByFileName'
            );
        }
        // verify the required parameter 'content_type' is set
        if ($content_type === null || (is_array($content_type) && count($content_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $content_type when calling getBankTransactionAttachmentByFileName'
            );
        }

        $resourcePath = '/BankTransactions/{BankTransactionID}/Attachments/{FileName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($content_type !== null) {
            $headerParams['contentType'] = ObjectSerializer::toHeaderValue($content_type);
        }

        // path params
        if ($bank_transaction_id !== null) {
            $resourcePath = str_replace(
                '{' . 'BankTransactionID' . '}',
                ObjectSerializer::toPathValue($bank_transaction_id),
                $resourcePath
            );
        }
        // path params
        if ($file_name !== null) {
            $resourcePath = str_replace(
                '{' . 'FileName' . '}',
                ObjectSerializer::toPathValue($file_name),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/octet-stream']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/octet-stream'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBankTransactionAttachmentById
     *
     * Allows you to retrieve Attachments on a specific BankTransaction
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $attachment_id Xero generated unique identifier for an attachment (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SplFileObject
     */
    public function getBankTransactionAttachmentById($xero_tenant_id, $bank_transaction_id, $attachment_id, $content_type)
    {
        list($response) = $this->getBankTransactionAttachmentByIdWithHttpInfo($xero_tenant_id, $bank_transaction_id, $attachment_id, $content_type);
        return $response;
    }

    /**
     * Operation getBankTransactionAttachmentByIdWithHttpInfo
     *
     * Allows you to retrieve Attachments on a specific BankTransaction
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $attachment_id Xero generated unique identifier for an attachment (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBankTransactionAttachmentByIdWithHttpInfo($xero_tenant_id, $bank_transaction_id, $attachment_id, $content_type)
    {
        $request = $this->getBankTransactionAttachmentByIdRequest($xero_tenant_id, $bank_transaction_id, $attachment_id, $content_type);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\SplFileObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SplFileObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SplFileObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SplFileObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getBankTransactionAttachmentByIdAsync
     *
     * Allows you to retrieve Attachments on a specific BankTransaction
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $attachment_id Xero generated unique identifier for an attachment (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankTransactionAttachmentByIdAsync($xero_tenant_id, $bank_transaction_id, $attachment_id, $content_type)
    {
        return $this->getBankTransactionAttachmentByIdAsyncWithHttpInfo($xero_tenant_id, $bank_transaction_id, $attachment_id, $content_type)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getBankTransactionAttachmentByIdAsyncWithHttpInfo
     *
     * Allows you to retrieve Attachments on a specific BankTransaction
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $attachment_id Xero generated unique identifier for an attachment (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankTransactionAttachmentByIdAsyncWithHttpInfo($xero_tenant_id, $bank_transaction_id, $attachment_id, $content_type)
    {
        $returnType = '\SplFileObject';
        $request = $this->getBankTransactionAttachmentByIdRequest($xero_tenant_id, $bank_transaction_id, $attachment_id, $content_type);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBankTransactionAttachmentById'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     * @param  string $attachment_id Xero generated unique identifier for an attachment (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getBankTransactionAttachmentByIdRequest($xero_tenant_id, $bank_transaction_id, $attachment_id, $content_type)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getBankTransactionAttachmentById'
            );
        }
        // verify the required parameter 'bank_transaction_id' is set
        if ($bank_transaction_id === null || (is_array($bank_transaction_id) && count($bank_transaction_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bank_transaction_id when calling getBankTransactionAttachmentById'
            );
        }
        // verify the required parameter 'attachment_id' is set
        if ($attachment_id === null || (is_array($attachment_id) && count($attachment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $attachment_id when calling getBankTransactionAttachmentById'
            );
        }
        // verify the required parameter 'content_type' is set
        if ($content_type === null || (is_array($content_type) && count($content_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $content_type when calling getBankTransactionAttachmentById'
            );
        }

        $resourcePath = '/BankTransactions/{BankTransactionID}/Attachments/{AttachmentID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($content_type !== null) {
            $headerParams['contentType'] = ObjectSerializer::toHeaderValue($content_type);
        }

        // path params
        if ($bank_transaction_id !== null) {
            $resourcePath = str_replace(
                '{' . 'BankTransactionID' . '}',
                ObjectSerializer::toPathValue($bank_transaction_id),
                $resourcePath
            );
        }
        // path params
        if ($attachment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'AttachmentID' . '}',
                ObjectSerializer::toPathValue($attachment_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/octet-stream']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/octet-stream'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBankTransactionAttachments
     *
     * Allows you to retrieve any attachments to bank transactions
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\Attachments
     */
    public function getBankTransactionAttachments($xero_tenant_id, $bank_transaction_id)
    {
        list($response) = $this->getBankTransactionAttachmentsWithHttpInfo($xero_tenant_id, $bank_transaction_id);
        return $response;
    }

    /**
     * Operation getBankTransactionAttachmentsWithHttpInfo
     *
     * Allows you to retrieve any attachments to bank transactions
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\Attachments, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBankTransactionAttachmentsWithHttpInfo($xero_tenant_id, $bank_transaction_id)
    {
        $request = $this->getBankTransactionAttachmentsRequest($xero_tenant_id, $bank_transaction_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\Attachments' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\Attachments', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\Attachments';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\Attachments',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getBankTransactionAttachmentsAsync
     *
     * Allows you to retrieve any attachments to bank transactions
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankTransactionAttachmentsAsync($xero_tenant_id, $bank_transaction_id)
    {
        return $this->getBankTransactionAttachmentsAsyncWithHttpInfo($xero_tenant_id, $bank_transaction_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getBankTransactionAttachmentsAsyncWithHttpInfo
     *
     * Allows you to retrieve any attachments to bank transactions
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankTransactionAttachmentsAsyncWithHttpInfo($xero_tenant_id, $bank_transaction_id)
    {
        $returnType = '\Xero2\Accounting\Model\Attachments';
        $request = $this->getBankTransactionAttachmentsRequest($xero_tenant_id, $bank_transaction_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBankTransactionAttachments'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getBankTransactionAttachmentsRequest($xero_tenant_id, $bank_transaction_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getBankTransactionAttachments'
            );
        }
        // verify the required parameter 'bank_transaction_id' is set
        if ($bank_transaction_id === null || (is_array($bank_transaction_id) && count($bank_transaction_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bank_transaction_id when calling getBankTransactionAttachments'
            );
        }

        $resourcePath = '/BankTransactions/{BankTransactionID}/Attachments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($bank_transaction_id !== null) {
            $resourcePath = str_replace(
                '{' . 'BankTransactionID' . '}',
                ObjectSerializer::toPathValue($bank_transaction_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBankTransactions
     *
     * Allows you to retrieve any spend or receive money transactions
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \DateTime $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 bank transactions will be returned in a single API call with line items shown for each bank transaction (optional)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\BankTransactions
     */
    public function getBankTransactions($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null, $unitdp = null)
    {
        list($response) = $this->getBankTransactionsWithHttpInfo($xero_tenant_id, $if_modified_since, $where, $order, $page, $unitdp);
        return $response;
    }

    /**
     * Operation getBankTransactionsWithHttpInfo
     *
     * Allows you to retrieve any spend or receive money transactions
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \DateTime $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 bank transactions will be returned in a single API call with line items shown for each bank transaction (optional)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\BankTransactions, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBankTransactionsWithHttpInfo($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null, $unitdp = null)
    {
        $request = $this->getBankTransactionsRequest($xero_tenant_id, $if_modified_since, $where, $order, $page, $unitdp);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\BankTransactions' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\BankTransactions', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\BankTransactions';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\BankTransactions',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getBankTransactionsAsync
     *
     * Allows you to retrieve any spend or receive money transactions
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \DateTime $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 bank transactions will be returned in a single API call with line items shown for each bank transaction (optional)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankTransactionsAsync($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null, $unitdp = null)
    {
        return $this->getBankTransactionsAsyncWithHttpInfo($xero_tenant_id, $if_modified_since, $where, $order, $page, $unitdp)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getBankTransactionsAsyncWithHttpInfo
     *
     * Allows you to retrieve any spend or receive money transactions
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \DateTime $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 bank transactions will be returned in a single API call with line items shown for each bank transaction (optional)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankTransactionsAsyncWithHttpInfo($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null, $unitdp = null)
    {
        $returnType = '\Xero2\Accounting\Model\BankTransactions';
        $request = $this->getBankTransactionsRequest($xero_tenant_id, $if_modified_since, $where, $order, $page, $unitdp);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBankTransactions'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \DateTime $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 bank transactions will be returned in a single API call with line items shown for each bank transaction (optional)
     * @param  int $unitdp e.g. unitdp&#x3D;4 – You can opt in to use four decimal places for unit amounts (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getBankTransactionsRequest($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null, $unitdp = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getBankTransactions'
            );
        }

        $resourcePath = '/BankTransactions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($where !== null) {
            $queryParams['where'] = ObjectSerializer::toQueryValue($where);
        }
        // query params
        if ($order !== null) {
            $queryParams['order'] = ObjectSerializer::toQueryValue($order);
        }
        // query params
        if ($page !== null) {
            $queryParams['page'] = ObjectSerializer::toQueryValue($page);
        }
        // query params
        if ($unitdp !== null) {
            $queryParams['unitdp'] = ObjectSerializer::toQueryValue($unitdp);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($if_modified_since !== null) {
            $headerParams['If-Modified-Since'] = ObjectSerializer::toHeaderValue($if_modified_since);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBankTransactionsHistory
     *
     * Allows you to retrieve history from a bank transactions
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\HistoryRecords
     */
    public function getBankTransactionsHistory($xero_tenant_id, $bank_transaction_id)
    {
        list($response) = $this->getBankTransactionsHistoryWithHttpInfo($xero_tenant_id, $bank_transaction_id);
        return $response;
    }

    /**
     * Operation getBankTransactionsHistoryWithHttpInfo
     *
     * Allows you to retrieve history from a bank transactions
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\HistoryRecords, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBankTransactionsHistoryWithHttpInfo($xero_tenant_id, $bank_transaction_id)
    {
        $request = $this->getBankTransactionsHistoryRequest($xero_tenant_id, $bank_transaction_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\HistoryRecords' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\HistoryRecords', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\HistoryRecords';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\HistoryRecords',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getBankTransactionsHistoryAsync
     *
     * Allows you to retrieve history from a bank transactions
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankTransactionsHistoryAsync($xero_tenant_id, $bank_transaction_id)
    {
        return $this->getBankTransactionsHistoryAsyncWithHttpInfo($xero_tenant_id, $bank_transaction_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getBankTransactionsHistoryAsyncWithHttpInfo
     *
     * Allows you to retrieve history from a bank transactions
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankTransactionsHistoryAsyncWithHttpInfo($xero_tenant_id, $bank_transaction_id)
    {
        $returnType = '\Xero2\Accounting\Model\HistoryRecords';
        $request = $this->getBankTransactionsHistoryRequest($xero_tenant_id, $bank_transaction_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBankTransactionsHistory'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transaction_id Xero generated unique identifier for a bank transaction (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getBankTransactionsHistoryRequest($xero_tenant_id, $bank_transaction_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getBankTransactionsHistory'
            );
        }
        // verify the required parameter 'bank_transaction_id' is set
        if ($bank_transaction_id === null || (is_array($bank_transaction_id) && count($bank_transaction_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bank_transaction_id when calling getBankTransactionsHistory'
            );
        }

        $resourcePath = '/BankTransactions/{BankTransactionID}/History';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($bank_transaction_id !== null) {
            $resourcePath = str_replace(
                '{' . 'BankTransactionID' . '}',
                ObjectSerializer::toPathValue($bank_transaction_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBankTransfer
     *
     * Allows you to retrieve any bank transfers
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Xero2\Accounting\Model\BankTransfers
     */
    public function getBankTransfer($xero_tenant_id, $bank_transfer_id)
    {
        list($response) = $this->getBankTransferWithHttpInfo($xero_tenant_id, $bank_transfer_id);
        return $response;
    }

    /**
     * Operation getBankTransferWithHttpInfo
     *
     * Allows you to retrieve any bank transfers
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Xero2\Accounting\Model\BankTransfers, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBankTransferWithHttpInfo($xero_tenant_id, $bank_transfer_id)
    {
        $request = $this->getBankTransferRequest($xero_tenant_id, $bank_transfer_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Xero2\Accounting\Model\BankTransfers' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Xero2\Accounting\Model\BankTransfers', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Xero2\Accounting\Model\BankTransfers';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Xero2\Accounting\Model\BankTransfers',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getBankTransferAsync
     *
     * Allows you to retrieve any bank transfers
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankTransferAsync($xero_tenant_id, $bank_transfer_id)
    {
        return $this->getBankTransferAsyncWithHttpInfo($xero_tenant_id, $bank_transfer_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getBankTransferAsyncWithHttpInfo
     *
     * Allows you to retrieve any bank transfers
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankTransferAsyncWithHttpInfo($xero_tenant_id, $bank_transfer_id)
    {
        $returnType = '\Xero2\Accounting\Model\BankTransfers';
        $request = $this->getBankTransferRequest($xero_tenant_id, $bank_transfer_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBankTransfer'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getBankTransferRequest($xero_tenant_id, $bank_transfer_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getBankTransfer'
            );
        }
        // verify the required parameter 'bank_transfer_id' is set
        if ($bank_transfer_id === null || (is_array($bank_transfer_id) && count($bank_transfer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bank_transfer_id when calling getBankTransfer'
            );
        }

        $resourcePath = '/BankTransfers/{BankTransferID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }

        // path params
        if ($bank_transfer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'BankTransferID' . '}',
                ObjectSerializer::toPathValue($bank_transfer_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBankTransferAttachmentByFileName
     *
     * Allows you to retrieve Attachments on BankTransfer by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  string $file_name The name of the file being attached to a Bank Transfer (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SplFileObject
     */
    public function getBankTransferAttachmentByFileName($xero_tenant_id, $bank_transfer_id, $file_name, $content_type)
    {
        list($response) = $this->getBankTransferAttachmentByFileNameWithHttpInfo($xero_tenant_id, $bank_transfer_id, $file_name, $content_type);
        return $response;
    }

    /**
     * Operation getBankTransferAttachmentByFileNameWithHttpInfo
     *
     * Allows you to retrieve Attachments on BankTransfer by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  string $file_name The name of the file being attached to a Bank Transfer (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBankTransferAttachmentByFileNameWithHttpInfo($xero_tenant_id, $bank_transfer_id, $file_name, $content_type)
    {
        $request = $this->getBankTransferAttachmentByFileNameRequest($xero_tenant_id, $bank_transfer_id, $file_name, $content_type);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\SplFileObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SplFileObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SplFileObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SplFileObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getBankTransferAttachmentByFileNameAsync
     *
     * Allows you to retrieve Attachments on BankTransfer by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  string $file_name The name of the file being attached to a Bank Transfer (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankTransferAttachmentByFileNameAsync($xero_tenant_id, $bank_transfer_id, $file_name, $content_type)
    {
        return $this->getBankTransferAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $bank_transfer_id, $file_name, $content_type)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getBankTransferAttachmentByFileNameAsyncWithHttpInfo
     *
     * Allows you to retrieve Attachments on BankTransfer by file name
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  string $file_name The name of the file being attached to a Bank Transfer (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankTransferAttachmentByFileNameAsyncWithHttpInfo($xero_tenant_id, $bank_transfer_id, $file_name, $content_type)
    {
        $returnType = '\SplFileObject';
        $request = $this->getBankTransferAttachmentByFileNameRequest($xero_tenant_id, $bank_transfer_id, $file_name, $content_type);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBankTransferAttachmentByFileName'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  string $file_name The name of the file being attached to a Bank Transfer (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getBankTransferAttachmentByFileNameRequest($xero_tenant_id, $bank_transfer_id, $file_name, $content_type)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getBankTransferAttachmentByFileName'
            );
        }
        // verify the required parameter 'bank_transfer_id' is set
        if ($bank_transfer_id === null || (is_array($bank_transfer_id) && count($bank_transfer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bank_transfer_id when calling getBankTransferAttachmentByFileName'
            );
        }
        // verify the required parameter 'file_name' is set
        if ($file_name === null || (is_array($file_name) && count($file_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_name when calling getBankTransferAttachmentByFileName'
            );
        }
        // verify the required parameter 'content_type' is set
        if ($content_type === null || (is_array($content_type) && count($content_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $content_type when calling getBankTransferAttachmentByFileName'
            );
        }

        $resourcePath = '/BankTransfers/{BankTransferID}/Attachments/{FileName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = ObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($content_type !== null) {
            $headerParams['contentType'] = ObjectSerializer::toHeaderValue($content_type);
        }

        // path params
        if ($bank_transfer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'BankTransferID' . '}',
                ObjectSerializer::toPathValue($bank_transfer_id),
                $resourcePath
            );
        }
        // path params
        if ($file_name !== null) {
            $resourcePath = str_replace(
                '{' . 'FileName' . '}',
                ObjectSerializer::toPathValue($file_name),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/octet-stream']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/octet-stream'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBankTransferAttachmentById
     *
     * Allows you to retrieve Attachments on BankTransfer
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  string $attachment_id Xero generated unique identifier for an Attachment to a bank transfer (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SplFileObject
     */
    public function getBankTransferAttachmentById($xero_tenant_id, $bank_transfer_id, $attachment_id, $content_type)
    {
        list($response) = $this->getBankTransferAttachmentByIdWithHttpInfo($xero_tenant_id, $bank_transfer_id, $attachment_id, $content_type);
        return $response;
    }

    /**
     * Operation getBankTransferAttachmentByIdWithHttpInfo
     *
     * Allows you to retrieve Attachments on BankTransfer
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  string $attachment_id Xero generated unique identifier for an Attachment to a bank transfer (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \Xero2\Accounting\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBankTransferAttachmentByIdWithHttpInfo($xero_tenant_id, $bank_transfer_id, $attachment_id, $content_type)
    {
        $request = $this->getBankTransferAttachmentByIdRequest($xero_tenant_id, $bank_transfer_id, $attachment_id, $content_type);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\SplFileObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SplFileObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SplFileObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SplFileObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getBankTransferAttachmentByIdAsync
     *
     * Allows you to retrieve Attachments on BankTransfer
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  string $attachment_id Xero generated unique identifier for an Attachment to a bank transfer (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankTransferAttachmentByIdAsync($xero_tenant_id, $bank_transfer_id, $attachment_id, $content_type)
    {
        return $this->getBankTransferAttachmentByIdAsyncWithHttpInfo($xero_tenant_id, $bank_transfer_id, $attachment_id, $content_type)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getBankTransferAttachmentByIdAsyncWithHttpInfo
     *
     * Allows you to retrieve Attachments on BankTransfer
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  string $attachment_id Xero generated unique identifier for an Attachment to a bank transfer (required)
     * @param  string $content_type The mime type of the attachment file you are retrieving i.e image/jpg, application/pdf (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankTransferAttachmentByIdAsyncWithHttpInfo($xero_tenant_id, $bank_transfer_id, $attachment_id, $content_type)
    {
        $returnType = '\SplFileObject';
        $request = $this->getBankTransferAttachmentByIdRequest($xero_tenant_id, $bank_transfer_id, $attachment_id, $content_type);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBankTransferAttachmentById'
     *
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_transfer_id Xero generated unique identifier for a bank transfer (required)
     * @param  string $attachment_id Xero generated unique identifier for an Attachment to a bank transfer (required)
     *