# # Invoice

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**type** | **string** | See Invoice Types | 
**contact** | [**\Xero2\Accounting\Model\Contact**](Contact.md) |  | 
**line_items** | [**\Xero2\Accounting\Model\LineItem[]**](LineItem.md) | See LineItems | 
**date** | [**\DateTime**](\DateTime.md) | Date invoice was issued – YYYY-MM-DD. If the Date element is not specified it will default to the current date based on the timezone setting of the organisation | [optional] 
**due_date** | [**\DateTime**](\DateTime.md) | Date invoice is due – YYYY-MM-DD | [optional] 
**line_amount_types** | [**\Xero2\Accounting\Model\LineAmountTypes**](LineAmountTypes.md) |  | [optional] 
**invoice_number** | **string** | ACCREC – Unique alpha numeric code identifying invoice (when missing will auto-generate from your Organisation Invoice Settings) (max length &#x3D; 255) | [optional] 
**reference** | **string** | ACCREC only – additional reference number (max length &#x3D; 255) | [optional] 
**branding_theme_id** | **string** | See BrandingThemes | [optional] 
**url** | **string** | URL link to a source document – shown as “Go to [appName]” in the Xero app | [optional] 
**currency_code** | [**\Xero2\Accounting\Model\CurrencyCode**](CurrencyCode.md) |  | [optional] 
**currency_rate** | **double** | The currency rate for a multicurrency invoice. If no rate is specified, the XE.com day rate is used. (max length &#x3D; [18].[6]) | [optional] 
**status** | **string** | See Invoice Status Codes | [optional] 
**sent_to_contact** | **bool** | Boolean to set whether the invoice in the Xero app should be marked as “sent”. This can be set only on invoices that have been approved | [optional] 
**expected_payment_date** | [**\DateTime**](\DateTime.md) | Shown on sales invoices (Accounts Receivable) when this has been set | [optional] 
**planned_payment_date** | [**\DateTime**](\DateTime.md) | Shown on bills (Accounts Payable) when this has been set | [optional] 
**cis_deduction** | **double** | CIS deduction for UK contractors | [optional] [readonly] 
**sub_total** | **double** | Total of invoice excluding taxes | [optional] [readonly] 
**total_tax** | **double** | Total tax on invoice | [optional] [readonly] 
**total** | **double** | Total of Invoice tax inclusive (i.e. SubTotal + TotalTax). This will be ignored if it doesn’t equal the sum of the LineAmounts | [optional] [readonly] 
**total_discount** | **double** | Total of discounts applied on the invoice line items | [optional] [readonly] 
**invoice_id** | **string** | Xero generated unique identifier for invoice | [optional] 
**has_attachments** | **bool** | boolean to indicate if an invoice has an attachment | [optional] [readonly] 
**is_discounted** | **bool** | boolean to indicate if an invoice has a discount | [optional] [readonly] 
**payments** | [**\Xero2\Accounting\Model\Payment[]**](Payment.md) | See Payments | [optional] [readonly] 
**prepayments** | [**\Xero2\Accounting\Model\Prepayment[]**](Prepayment.md) | See Prepayments | [optional] [readonly] 
**overpayments** | [**\Xero2\Accounting\Model\Overpayment[]**](Overpayment.md) | See Overpayments | [optional] [readonly] 
**amount_due** | **double** | Amount remaining to be paid on invoice | [optional] [readonly] 
**amount_paid** | **double** | Sum of payments received for invoice | [optional] [readonly] 
**fully_paid_on_date** | [**\DateTime**](\DateTime.md) | The date the invoice was fully paid. Only returned on fully paid invoices | [optional] [readonly] 
**amount_credited** | **double** | Sum of all credit notes, over-payments and pre-payments applied to invoice | [optional] [readonly] 
**updated_date_utc** | [**\DateTime**](\DateTime.md) | Last modified date UTC format | [optional] [readonly] 
**credit_notes** | [**\Xero2\Accounting\Model\CreditNote[]**](CreditNote.md) | Details of credit notes that have been applied to an invoice | [optional] [readonly] 
**attachments** | [**\Xero2\Accounting\Model\Attachment[]**](Attachment.md) | Displays array of attachments from the API | [optional] 
**has_errors** | **bool** | A boolean to indicate if a invoice has an validation errors | [optional] 
**status_attribute_string** | **string** | A string to indicate if a invoice status | [optional] 
**validation_errors** | [**\Xero2\Accounting\Model\ValidationError[]**](ValidationError.md) | Displays array of validation error messages from the API | [optional] 

[[Back to Model list]](../../README.md#documentation-for-models) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to README]](../../README.md)


