<?php
/**
 * Theme
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Woocommerce
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Woocommerce API
 *
 * Woocommerce v3.0 API See https://woocommerce.github.io/woocommerce-rest-api-docs/#introduction
 *
 * The version of the OpenAPI document: 3.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Woocommerce\Model;

use \ArrayAccess;
use \Woocommerce\ObjectSerializer;

/**
 * Theme Class Doc Comment
 *
 * @category Class
 * @package  Woocommerce
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Theme implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Theme';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'name' => 'string',
        'version' => 'string',
        'version_latest' => 'string',
        'author_url' => 'string',
        'is_child_theme' => 'bool',
        'has_woocommerce_support' => 'bool',
        'has_woocommerce_file' => 'bool',
        'has_outdated_templates' => 'bool',
        'overrides' => 'object[]',
        'parent_name' => 'string',
        'parent_version' => 'string',
        'parent_version_latest' => 'string',
        'parent_author_url' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'name' => null,
        'version' => null,
        'version_latest' => null,
        'author_url' => null,
        'is_child_theme' => null,
        'has_woocommerce_support' => null,
        'has_woocommerce_file' => null,
        'has_outdated_templates' => null,
        'overrides' => null,
        'parent_name' => null,
        'parent_version' => null,
        'parent_version_latest' => null,
        'parent_author_url' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'name' => false,
        'version' => false,
        'version_latest' => false,
        'author_url' => false,
        'is_child_theme' => false,
        'has_woocommerce_support' => false,
        'has_woocommerce_file' => false,
        'has_outdated_templates' => false,
        'overrides' => false,
        'parent_name' => false,
        'parent_version' => false,
        'parent_version_latest' => false,
        'parent_author_url' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'name' => 'name',
        'version' => 'version',
        'version_latest' => 'version_latest',
        'author_url' => 'author_url',
        'is_child_theme' => 'is_child_theme',
        'has_woocommerce_support' => 'has_woocommerce_support',
        'has_woocommerce_file' => 'has_woocommerce_file',
        'has_outdated_templates' => 'has_outdated_templates',
        'overrides' => 'overrides',
        'parent_name' => 'parent_name',
        'parent_version' => 'parent_version',
        'parent_version_latest' => 'parent_version_latest',
        'parent_author_url' => 'parent_author_url'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'name' => 'setName',
        'version' => 'setVersion',
        'version_latest' => 'setVersionLatest',
        'author_url' => 'setAuthorUrl',
        'is_child_theme' => 'setIsChildTheme',
        'has_woocommerce_support' => 'setHasWoocommerceSupport',
        'has_woocommerce_file' => 'setHasWoocommerceFile',
        'has_outdated_templates' => 'setHasOutdatedTemplates',
        'overrides' => 'setOverrides',
        'parent_name' => 'setParentName',
        'parent_version' => 'setParentVersion',
        'parent_version_latest' => 'setParentVersionLatest',
        'parent_author_url' => 'setParentAuthorUrl'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'name' => 'getName',
        'version' => 'getVersion',
        'version_latest' => 'getVersionLatest',
        'author_url' => 'getAuthorUrl',
        'is_child_theme' => 'getIsChildTheme',
        'has_woocommerce_support' => 'getHasWoocommerceSupport',
        'has_woocommerce_file' => 'getHasWoocommerceFile',
        'has_outdated_templates' => 'getHasOutdatedTemplates',
        'overrides' => 'getOverrides',
        'parent_name' => 'getParentName',
        'parent_version' => 'getParentVersion',
        'parent_version_latest' => 'getParentVersionLatest',
        'parent_author_url' => 'getParentAuthorUrl'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('version', $data ?? [], null);
        $this->setIfExists('version_latest', $data ?? [], null);
        $this->setIfExists('author_url', $data ?? [], null);
        $this->setIfExists('is_child_theme', $data ?? [], null);
        $this->setIfExists('has_woocommerce_support', $data ?? [], null);
        $this->setIfExists('has_woocommerce_file', $data ?? [], null);
        $this->setIfExists('has_outdated_templates', $data ?? [], null);
        $this->setIfExists('overrides', $data ?? [], null);
        $this->setIfExists('parent_name', $data ?? [], null);
        $this->setIfExists('parent_version', $data ?? [], null);
        $this->setIfExists('parent_version_latest', $data ?? [], null);
        $this->setIfExists('parent_author_url', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets version
     *
     * @return string|null
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     *
     * @param string|null $version version
     *
     * @return self
     */
    public function setVersion($version)
    {
        if (is_null($version)) {
            throw new \InvalidArgumentException('non-nullable version cannot be null');
        }
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets version_latest
     *
     * @return string|null
     */
    public function getVersionLatest()
    {
        return $this->container['version_latest'];
    }

    /**
     * Sets version_latest
     *
     * @param string|null $version_latest version_latest
     *
     * @return self
     */
    public function setVersionLatest($version_latest)
    {
        if (is_null($version_latest)) {
            throw new \InvalidArgumentException('non-nullable version_latest cannot be null');
        }
        $this->container['version_latest'] = $version_latest;

        return $this;
    }

    /**
     * Gets author_url
     *
     * @return string|null
     */
    public function getAuthorUrl()
    {
        return $this->container['author_url'];
    }

    /**
     * Sets author_url
     *
     * @param string|null $author_url author_url
     *
     * @return self
     */
    public function setAuthorUrl($author_url)
    {
        if (is_null($author_url)) {
            throw new \InvalidArgumentException('non-nullable author_url cannot be null');
        }
        $this->container['author_url'] = $author_url;

        return $this;
    }

    /**
     * Gets is_child_theme
     *
     * @return bool|null
     */
    public function getIsChildTheme()
    {
        return $this->container['is_child_theme'];
    }

    /**
     * Sets is_child_theme
     *
     * @param bool|null $is_child_theme is_child_theme
     *
     * @return self
     */
    public function setIsChildTheme($is_child_theme)
    {
        if (is_null($is_child_theme)) {
            throw new \InvalidArgumentException('non-nullable is_child_theme cannot be null');
        }
        $this->container['is_child_theme'] = $is_child_theme;

        return $this;
    }

    /**
     * Gets has_woocommerce_support
     *
     * @return bool|null
     */
    public function getHasWoocommerceSupport()
    {
        return $this->container['has_woocommerce_support'];
    }

    /**
     * Sets has_woocommerce_support
     *
     * @param bool|null $has_woocommerce_support has_woocommerce_support
     *
     * @return self
     */
    public function setHasWoocommerceSupport($has_woocommerce_support)
    {
        if (is_null($has_woocommerce_support)) {
            throw new \InvalidArgumentException('non-nullable has_woocommerce_support cannot be null');
        }
        $this->container['has_woocommerce_support'] = $has_woocommerce_support;

        return $this;
    }

    /**
     * Gets has_woocommerce_file
     *
     * @return bool|null
     */
    public function getHasWoocommerceFile()
    {
        return $this->container['has_woocommerce_file'];
    }

    /**
     * Sets has_woocommerce_file
     *
     * @param bool|null $has_woocommerce_file has_woocommerce_file
     *
     * @return self
     */
    public function setHasWoocommerceFile($has_woocommerce_file)
    {
        if (is_null($has_woocommerce_file)) {
            throw new \InvalidArgumentException('non-nullable has_woocommerce_file cannot be null');
        }
        $this->container['has_woocommerce_file'] = $has_woocommerce_file;

        return $this;
    }

    /**
     * Gets has_outdated_templates
     *
     * @return bool|null
     */
    public function getHasOutdatedTemplates()
    {
        return $this->container['has_outdated_templates'];
    }

    /**
     * Sets has_outdated_templates
     *
     * @param bool|null $has_outdated_templates has_outdated_templates
     *
     * @return self
     */
    public function setHasOutdatedTemplates($has_outdated_templates)
    {
        if (is_null($has_outdated_templates)) {
            throw new \InvalidArgumentException('non-nullable has_outdated_templates cannot be null');
        }
        $this->container['has_outdated_templates'] = $has_outdated_templates;

        return $this;
    }

    /**
     * Gets overrides
     *
     * @return object[]|null
     */
    public function getOverrides()
    {
        return $this->container['overrides'];
    }

    /**
     * Sets overrides
     *
     * @param object[]|null $overrides overrides
     *
     * @return self
     */
    public function setOverrides($overrides)
    {
        if (is_null($overrides)) {
            throw new \InvalidArgumentException('non-nullable overrides cannot be null');
        }
        $this->container['overrides'] = $overrides;

        return $this;
    }

    /**
     * Gets parent_name
     *
     * @return string|null
     */
    public function getParentName()
    {
        return $this->container['parent_name'];
    }

    /**
     * Sets parent_name
     *
     * @param string|null $parent_name parent_name
     *
     * @return self
     */
    public function setParentName($parent_name)
    {
        if (is_null($parent_name)) {
            throw new \InvalidArgumentException('non-nullable parent_name cannot be null');
        }
        $this->container['parent_name'] = $parent_name;

        return $this;
    }

    /**
     * Gets parent_version
     *
     * @return string|null
     */
    public function getParentVersion()
    {
        return $this->container['parent_version'];
    }

    /**
     * Sets parent_version
     *
     * @param string|null $parent_version parent_version
     *
     * @return self
     */
    public function setParentVersion($parent_version)
    {
        if (is_null($parent_version)) {
            throw new \InvalidArgumentException('non-nullable parent_version cannot be null');
        }
        $this->container['parent_version'] = $parent_version;

        return $this;
    }

    /**
     * Gets parent_version_latest
     *
     * @return string|null
     */
    public function getParentVersionLatest()
    {
        return $this->container['parent_version_latest'];
    }

    /**
     * Sets parent_version_latest
     *
     * @param string|null $parent_version_latest parent_version_latest
     *
     * @return self
     */
    public function setParentVersionLatest($parent_version_latest)
    {
        if (is_null($parent_version_latest)) {
            throw new \InvalidArgumentException('non-nullable parent_version_latest cannot be null');
        }
        $this->container['parent_version_latest'] = $parent_version_latest;

        return $this;
    }

    /**
     * Gets parent_author_url
     *
     * @return string|null
     */
    public function getParentAuthorUrl()
    {
        return $this->container['parent_author_url'];
    }

    /**
     * Sets parent_author_url
     *
     * @param string|null $parent_author_url parent_author_url
     *
     * @return self
     */
    public function setParentAuthorUrl($parent_author_url)
    {
        if (is_null($parent_author_url)) {
            throw new \InvalidArgumentException('non-nullable parent_author_url cannot be null');
        }
        $this->container['parent_author_url'] = $parent_author_url;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


