<?php
/**
 * Settings
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Woocommerce
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Woocommerce API
 *
 * Woocommerce v3.0 API See https://woocommerce.github.io/woocommerce-rest-api-docs/#introduction
 *
 * The version of the OpenAPI document: 3.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Woocommerce\Model;

use \ArrayAccess;
use \Woocommerce\ObjectSerializer;

/**
 * Settings Class Doc Comment
 *
 * @category Class
 * @package  Woocommerce
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Settings implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Settings';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'api_enabled' => 'bool',
        'force_ssl' => 'bool',
        'currency' => 'string',
        'currency_symbol' => 'string',
        'currency_position' => 'string',
        'thousand_separator' => 'string',
        'decimal_separator' => 'string',
        'number_of_decimals' => 'int',
        'geolocation_enabled' => 'bool',
        'taxonomies' => '\Woocommerce\Model\SettingsTaxonomies'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'api_enabled' => null,
        'force_ssl' => null,
        'currency' => null,
        'currency_symbol' => null,
        'currency_position' => null,
        'thousand_separator' => null,
        'decimal_separator' => null,
        'number_of_decimals' => null,
        'geolocation_enabled' => null,
        'taxonomies' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'api_enabled' => false,
        'force_ssl' => false,
        'currency' => false,
        'currency_symbol' => false,
        'currency_position' => false,
        'thousand_separator' => false,
        'decimal_separator' => false,
        'number_of_decimals' => false,
        'geolocation_enabled' => false,
        'taxonomies' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'api_enabled' => 'api_enabled',
        'force_ssl' => 'force_ssl',
        'currency' => 'currency',
        'currency_symbol' => 'currency_symbol',
        'currency_position' => 'currency_position',
        'thousand_separator' => 'thousand_separator',
        'decimal_separator' => 'decimal_separator',
        'number_of_decimals' => 'number_of_decimals',
        'geolocation_enabled' => 'geolocation_enabled',
        'taxonomies' => 'taxonomies'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'api_enabled' => 'setApiEnabled',
        'force_ssl' => 'setForceSsl',
        'currency' => 'setCurrency',
        'currency_symbol' => 'setCurrencySymbol',
        'currency_position' => 'setCurrencyPosition',
        'thousand_separator' => 'setThousandSeparator',
        'decimal_separator' => 'setDecimalSeparator',
        'number_of_decimals' => 'setNumberOfDecimals',
        'geolocation_enabled' => 'setGeolocationEnabled',
        'taxonomies' => 'setTaxonomies'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'api_enabled' => 'getApiEnabled',
        'force_ssl' => 'getForceSsl',
        'currency' => 'getCurrency',
        'currency_symbol' => 'getCurrencySymbol',
        'currency_position' => 'getCurrencyPosition',
        'thousand_separator' => 'getThousandSeparator',
        'decimal_separator' => 'getDecimalSeparator',
        'number_of_decimals' => 'getNumberOfDecimals',
        'geolocation_enabled' => 'getGeolocationEnabled',
        'taxonomies' => 'getTaxonomies'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('api_enabled', $data ?? [], null);
        $this->setIfExists('force_ssl', $data ?? [], null);
        $this->setIfExists('currency', $data ?? [], null);
        $this->setIfExists('currency_symbol', $data ?? [], null);
        $this->setIfExists('currency_position', $data ?? [], null);
        $this->setIfExists('thousand_separator', $data ?? [], null);
        $this->setIfExists('decimal_separator', $data ?? [], null);
        $this->setIfExists('number_of_decimals', $data ?? [], null);
        $this->setIfExists('geolocation_enabled', $data ?? [], null);
        $this->setIfExists('taxonomies', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets api_enabled
     *
     * @return bool|null
     */
    public function getApiEnabled()
    {
        return $this->container['api_enabled'];
    }

    /**
     * Sets api_enabled
     *
     * @param bool|null $api_enabled api_enabled
     *
     * @return self
     */
    public function setApiEnabled($api_enabled)
    {
        if (is_null($api_enabled)) {
            throw new \InvalidArgumentException('non-nullable api_enabled cannot be null');
        }
        $this->container['api_enabled'] = $api_enabled;

        return $this;
    }

    /**
     * Gets force_ssl
     *
     * @return bool|null
     */
    public function getForceSsl()
    {
        return $this->container['force_ssl'];
    }

    /**
     * Sets force_ssl
     *
     * @param bool|null $force_ssl force_ssl
     *
     * @return self
     */
    public function setForceSsl($force_ssl)
    {
        if (is_null($force_ssl)) {
            throw new \InvalidArgumentException('non-nullable force_ssl cannot be null');
        }
        $this->container['force_ssl'] = $force_ssl;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param string|null $currency currency
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        if (is_null($currency)) {
            throw new \InvalidArgumentException('non-nullable currency cannot be null');
        }
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets currency_symbol
     *
     * @return string|null
     */
    public function getCurrencySymbol()
    {
        return $this->container['currency_symbol'];
    }

    /**
     * Sets currency_symbol
     *
     * @param string|null $currency_symbol currency_symbol
     *
     * @return self
     */
    public function setCurrencySymbol($currency_symbol)
    {
        if (is_null($currency_symbol)) {
            throw new \InvalidArgumentException('non-nullable currency_symbol cannot be null');
        }
        $this->container['currency_symbol'] = $currency_symbol;

        return $this;
    }

    /**
     * Gets currency_position
     *
     * @return string|null
     */
    public function getCurrencyPosition()
    {
        return $this->container['currency_position'];
    }

    /**
     * Sets currency_position
     *
     * @param string|null $currency_position currency_position
     *
     * @return self
     */
    public function setCurrencyPosition($currency_position)
    {
        if (is_null($currency_position)) {
            throw new \InvalidArgumentException('non-nullable currency_position cannot be null');
        }
        $this->container['currency_position'] = $currency_position;

        return $this;
    }

    /**
     * Gets thousand_separator
     *
     * @return string|null
     */
    public function getThousandSeparator()
    {
        return $this->container['thousand_separator'];
    }

    /**
     * Sets thousand_separator
     *
     * @param string|null $thousand_separator thousand_separator
     *
     * @return self
     */
    public function setThousandSeparator($thousand_separator)
    {
        if (is_null($thousand_separator)) {
            throw new \InvalidArgumentException('non-nullable thousand_separator cannot be null');
        }
        $this->container['thousand_separator'] = $thousand_separator;

        return $this;
    }

    /**
     * Gets decimal_separator
     *
     * @return string|null
     */
    public function getDecimalSeparator()
    {
        return $this->container['decimal_separator'];
    }

    /**
     * Sets decimal_separator
     *
     * @param string|null $decimal_separator decimal_separator
     *
     * @return self
     */
    public function setDecimalSeparator($decimal_separator)
    {
        if (is_null($decimal_separator)) {
            throw new \InvalidArgumentException('non-nullable decimal_separator cannot be null');
        }
        $this->container['decimal_separator'] = $decimal_separator;

        return $this;
    }

    /**
     * Gets number_of_decimals
     *
     * @return int|null
     */
    public function getNumberOfDecimals()
    {
        return $this->container['number_of_decimals'];
    }

    /**
     * Sets number_of_decimals
     *
     * @param int|null $number_of_decimals number_of_decimals
     *
     * @return self
     */
    public function setNumberOfDecimals($number_of_decimals)
    {
        if (is_null($number_of_decimals)) {
            throw new \InvalidArgumentException('non-nullable number_of_decimals cannot be null');
        }
        $this->container['number_of_decimals'] = $number_of_decimals;

        return $this;
    }

    /**
     * Gets geolocation_enabled
     *
     * @return bool|null
     */
    public function getGeolocationEnabled()
    {
        return $this->container['geolocation_enabled'];
    }

    /**
     * Sets geolocation_enabled
     *
     * @param bool|null $geolocation_enabled geolocation_enabled
     *
     * @return self
     */
    public function setGeolocationEnabled($geolocation_enabled)
    {
        if (is_null($geolocation_enabled)) {
            throw new \InvalidArgumentException('non-nullable geolocation_enabled cannot be null');
        }
        $this->container['geolocation_enabled'] = $geolocation_enabled;

        return $this;
    }

    /**
     * Gets taxonomies
     *
     * @return \Woocommerce\Model\SettingsTaxonomies|null
     */
    public function getTaxonomies()
    {
        return $this->container['taxonomies'];
    }

    /**
     * Sets taxonomies
     *
     * @param \Woocommerce\Model\SettingsTaxonomies|null $taxonomies taxonomies
     *
     * @return self
     */
    public function setTaxonomies($taxonomies)
    {
        if (is_null($taxonomies)) {
            throw new \InvalidArgumentException('non-nullable taxonomies cannot be null');
        }
        $this->container['taxonomies'] = $taxonomies;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


