<?php
/**
 * ProductVariation
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Woocommerce
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Woocommerce API
 *
 * Woocommerce v3.0 API See https://woocommerce.github.io/woocommerce-rest-api-docs/#introduction
 *
 * The version of the OpenAPI document: 3.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Woocommerce\Model;

use \ArrayAccess;
use \Woocommerce\ObjectSerializer;

/**
 * ProductVariation Class Doc Comment
 *
 * @category Class
 * @package  Woocommerce
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ProductVariation implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ProductVariation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'date_created' => '\DateTime',
        'date_created_gmt' => '\DateTime',
        'date_modified' => '\DateTime',
        'date_modified_gmt' => '\DateTime',
        'description' => 'string',
        'permalink' => 'string',
        'sku' => 'string',
        'price' => 'string',
        'regular_price' => 'string',
        'sale_price' => 'string',
        'date_on_sale_from' => '\DateTime',
        'date_on_sale_from_gmt' => '\DateTime',
        'date_on_sale_to' => '\DateTime',
        'date_on_sale_to_gmt' => '\DateTime',
        'on_sale' => 'bool',
        'status' => 'string',
        'purchasable' => 'bool',
        'virtual' => 'bool',
        'downloadable' => 'bool',
        'downloads' => 'object[]',
        'download_limit' => 'int',
        'download_expiry' => 'int',
        'tax_status' => 'string',
        'tax_class' => 'string',
        'manage_stock' => 'bool',
        'stock_quantity' => 'int',
        'stock_status' => 'string',
        'backorders' => 'string',
        'backorders_allowed' => 'bool',
        'backordered' => 'bool',
        'weight' => 'string',
        'dimensions' => '\Woocommerce\Model\ProductVariationDimensions',
        'shipping_class' => 'string',
        'shipping_class_id' => 'int',
        'image' => '\Woocommerce\Model\Image',
        'attributes' => '\Woocommerce\Model\ProductVariationAttributesInner[]',
        'menu_order' => 'int',
        'meta_data' => '\Woocommerce\Model\Metadata[]',
        '_links' => '\Woocommerce\Model\Links',
        'visible' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'date_created' => 'date-time',
        'date_created_gmt' => 'date-time',
        'date_modified' => 'date-time',
        'date_modified_gmt' => 'date-time',
        'description' => null,
        'permalink' => null,
        'sku' => null,
        'price' => null,
        'regular_price' => null,
        'sale_price' => null,
        'date_on_sale_from' => 'date-time',
        'date_on_sale_from_gmt' => 'date-time',
        'date_on_sale_to' => 'date-time',
        'date_on_sale_to_gmt' => 'date-time',
        'on_sale' => null,
        'status' => null,
        'purchasable' => null,
        'virtual' => null,
        'downloadable' => null,
        'downloads' => null,
        'download_limit' => null,
        'download_expiry' => null,
        'tax_status' => null,
        'tax_class' => null,
        'manage_stock' => null,
        'stock_quantity' => null,
        'stock_status' => null,
        'backorders' => null,
        'backorders_allowed' => null,
        'backordered' => null,
        'weight' => null,
        'dimensions' => null,
        'shipping_class' => null,
        'shipping_class_id' => null,
        'image' => null,
        'attributes' => null,
        'menu_order' => null,
        'meta_data' => null,
        '_links' => null,
        'visible' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'date_created' => false,
        'date_created_gmt' => false,
        'date_modified' => false,
        'date_modified_gmt' => false,
        'description' => false,
        'permalink' => false,
        'sku' => false,
        'price' => false,
        'regular_price' => false,
        'sale_price' => false,
        'date_on_sale_from' => false,
        'date_on_sale_from_gmt' => false,
        'date_on_sale_to' => false,
        'date_on_sale_to_gmt' => false,
        'on_sale' => false,
        'status' => false,
        'purchasable' => false,
        'virtual' => false,
        'downloadable' => false,
        'downloads' => false,
        'download_limit' => false,
        'download_expiry' => false,
        'tax_status' => false,
        'tax_class' => false,
        'manage_stock' => false,
        'stock_quantity' => false,
        'stock_status' => false,
        'backorders' => false,
        'backorders_allowed' => false,
        'backordered' => false,
        'weight' => false,
        'dimensions' => false,
        'shipping_class' => false,
        'shipping_class_id' => false,
        'image' => false,
        'attributes' => false,
        'menu_order' => false,
        'meta_data' => false,
        '_links' => false,
        'visible' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'date_created' => 'date_created',
        'date_created_gmt' => 'date_created_gmt',
        'date_modified' => 'date_modified',
        'date_modified_gmt' => 'date_modified_gmt',
        'description' => 'description',
        'permalink' => 'permalink',
        'sku' => 'sku',
        'price' => 'price',
        'regular_price' => 'regular_price',
        'sale_price' => 'sale_price',
        'date_on_sale_from' => 'date_on_sale_from',
        'date_on_sale_from_gmt' => 'date_on_sale_from_gmt',
        'date_on_sale_to' => 'date_on_sale_to',
        'date_on_sale_to_gmt' => 'date_on_sale_to_gmt',
        'on_sale' => 'on_sale',
        'status' => 'status',
        'purchasable' => 'purchasable',
        'virtual' => 'virtual',
        'downloadable' => 'downloadable',
        'downloads' => 'downloads',
        'download_limit' => 'download_limit',
        'download_expiry' => 'download_expiry',
        'tax_status' => 'tax_status',
        'tax_class' => 'tax_class',
        'manage_stock' => 'manage_stock',
        'stock_quantity' => 'stock_quantity',
        'stock_status' => 'stock_status',
        'backorders' => 'backorders',
        'backorders_allowed' => 'backorders_allowed',
        'backordered' => 'backordered',
        'weight' => 'weight',
        'dimensions' => 'dimensions',
        'shipping_class' => 'shipping_class',
        'shipping_class_id' => 'shipping_class_id',
        'image' => 'image',
        'attributes' => 'attributes',
        'menu_order' => 'menu_order',
        'meta_data' => 'meta_data',
        '_links' => '_links',
        'visible' => 'visible'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'date_created' => 'setDateCreated',
        'date_created_gmt' => 'setDateCreatedGmt',
        'date_modified' => 'setDateModified',
        'date_modified_gmt' => 'setDateModifiedGmt',
        'description' => 'setDescription',
        'permalink' => 'setPermalink',
        'sku' => 'setSku',
        'price' => 'setPrice',
        'regular_price' => 'setRegularPrice',
        'sale_price' => 'setSalePrice',
        'date_on_sale_from' => 'setDateOnSaleFrom',
        'date_on_sale_from_gmt' => 'setDateOnSaleFromGmt',
        'date_on_sale_to' => 'setDateOnSaleTo',
        'date_on_sale_to_gmt' => 'setDateOnSaleToGmt',
        'on_sale' => 'setOnSale',
        'status' => 'setStatus',
        'purchasable' => 'setPurchasable',
        'virtual' => 'setVirtual',
        'downloadable' => 'setDownloadable',
        'downloads' => 'setDownloads',
        'download_limit' => 'setDownloadLimit',
        'download_expiry' => 'setDownloadExpiry',
        'tax_status' => 'setTaxStatus',
        'tax_class' => 'setTaxClass',
        'manage_stock' => 'setManageStock',
        'stock_quantity' => 'setStockQuantity',
        'stock_status' => 'setStockStatus',
        'backorders' => 'setBackorders',
        'backorders_allowed' => 'setBackordersAllowed',
        'backordered' => 'setBackordered',
        'weight' => 'setWeight',
        'dimensions' => 'setDimensions',
        'shipping_class' => 'setShippingClass',
        'shipping_class_id' => 'setShippingClassId',
        'image' => 'setImage',
        'attributes' => 'setAttributes',
        'menu_order' => 'setMenuOrder',
        'meta_data' => 'setMetaData',
        '_links' => 'setLinks',
        'visible' => 'setVisible'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'date_created' => 'getDateCreated',
        'date_created_gmt' => 'getDateCreatedGmt',
        'date_modified' => 'getDateModified',
        'date_modified_gmt' => 'getDateModifiedGmt',
        'description' => 'getDescription',
        'permalink' => 'getPermalink',
        'sku' => 'getSku',
        'price' => 'getPrice',
        'regular_price' => 'getRegularPrice',
        'sale_price' => 'getSalePrice',
        'date_on_sale_from' => 'getDateOnSaleFrom',
        'date_on_sale_from_gmt' => 'getDateOnSaleFromGmt',
        'date_on_sale_to' => 'getDateOnSaleTo',
        'date_on_sale_to_gmt' => 'getDateOnSaleToGmt',
        'on_sale' => 'getOnSale',
        'status' => 'getStatus',
        'purchasable' => 'getPurchasable',
        'virtual' => 'getVirtual',
        'downloadable' => 'getDownloadable',
        'downloads' => 'getDownloads',
        'download_limit' => 'getDownloadLimit',
        'download_expiry' => 'getDownloadExpiry',
        'tax_status' => 'getTaxStatus',
        'tax_class' => 'getTaxClass',
        'manage_stock' => 'getManageStock',
        'stock_quantity' => 'getStockQuantity',
        'stock_status' => 'getStockStatus',
        'backorders' => 'getBackorders',
        'backorders_allowed' => 'getBackordersAllowed',
        'backordered' => 'getBackordered',
        'weight' => 'getWeight',
        'dimensions' => 'getDimensions',
        'shipping_class' => 'getShippingClass',
        'shipping_class_id' => 'getShippingClassId',
        'image' => 'getImage',
        'attributes' => 'getAttributes',
        'menu_order' => 'getMenuOrder',
        'meta_data' => 'getMetaData',
        '_links' => 'getLinks',
        'visible' => 'getVisible'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('date_created', $data ?? [], null);
        $this->setIfExists('date_created_gmt', $data ?? [], null);
        $this->setIfExists('date_modified', $data ?? [], null);
        $this->setIfExists('date_modified_gmt', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('permalink', $data ?? [], null);
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('price', $data ?? [], null);
        $this->setIfExists('regular_price', $data ?? [], null);
        $this->setIfExists('sale_price', $data ?? [], null);
        $this->setIfExists('date_on_sale_from', $data ?? [], null);
        $this->setIfExists('date_on_sale_from_gmt', $data ?? [], null);
        $this->setIfExists('date_on_sale_to', $data ?? [], null);
        $this->setIfExists('date_on_sale_to_gmt', $data ?? [], null);
        $this->setIfExists('on_sale', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('purchasable', $data ?? [], null);
        $this->setIfExists('virtual', $data ?? [], null);
        $this->setIfExists('downloadable', $data ?? [], null);
        $this->setIfExists('downloads', $data ?? [], null);
        $this->setIfExists('download_limit', $data ?? [], null);
        $this->setIfExists('download_expiry', $data ?? [], null);
        $this->setIfExists('tax_status', $data ?? [], null);
        $this->setIfExists('tax_class', $data ?? [], null);
        $this->setIfExists('manage_stock', $data ?? [], null);
        $this->setIfExists('stock_quantity', $data ?? [], null);
        $this->setIfExists('stock_status', $data ?? [], null);
        $this->setIfExists('backorders', $data ?? [], null);
        $this->setIfExists('backorders_allowed', $data ?? [], null);
        $this->setIfExists('backordered', $data ?? [], null);
        $this->setIfExists('weight', $data ?? [], null);
        $this->setIfExists('dimensions', $data ?? [], null);
        $this->setIfExists('shipping_class', $data ?? [], null);
        $this->setIfExists('shipping_class_id', $data ?? [], null);
        $this->setIfExists('image', $data ?? [], null);
        $this->setIfExists('attributes', $data ?? [], null);
        $this->setIfExists('menu_order', $data ?? [], null);
        $this->setIfExists('meta_data', $data ?? [], null);
        $this->setIfExists('_links', $data ?? [], null);
        $this->setIfExists('visible', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets date_created
     *
     * @return \DateTime|null
     */
    public function getDateCreated()
    {
        return $this->container['date_created'];
    }

    /**
     * Sets date_created
     *
     * @param \DateTime|null $date_created date_created
     *
     * @return self
     */
    public function setDateCreated($date_created)
    {
        if (is_null($date_created)) {
            throw new \InvalidArgumentException('non-nullable date_created cannot be null');
        }
        $this->container['date_created'] = $date_created;

        return $this;
    }

    /**
     * Gets date_created_gmt
     *
     * @return \DateTime|null
     */
    public function getDateCreatedGmt()
    {
        return $this->container['date_created_gmt'];
    }

    /**
     * Sets date_created_gmt
     *
     * @param \DateTime|null $date_created_gmt date_created_gmt
     *
     * @return self
     */
    public function setDateCreatedGmt($date_created_gmt)
    {
        if (is_null($date_created_gmt)) {
            throw new \InvalidArgumentException('non-nullable date_created_gmt cannot be null');
        }
        $this->container['date_created_gmt'] = $date_created_gmt;

        return $this;
    }

    /**
     * Gets date_modified
     *
     * @return \DateTime|null
     */
    public function getDateModified()
    {
        return $this->container['date_modified'];
    }

    /**
     * Sets date_modified
     *
     * @param \DateTime|null $date_modified date_modified
     *
     * @return self
     */
    public function setDateModified($date_modified)
    {
        if (is_null($date_modified)) {
            throw new \InvalidArgumentException('non-nullable date_modified cannot be null');
        }
        $this->container['date_modified'] = $date_modified;

        return $this;
    }

    /**
     * Gets date_modified_gmt
     *
     * @return \DateTime|null
     */
    public function getDateModifiedGmt()
    {
        return $this->container['date_modified_gmt'];
    }

    /**
     * Sets date_modified_gmt
     *
     * @param \DateTime|null $date_modified_gmt date_modified_gmt
     *
     * @return self
     */
    public function setDateModifiedGmt($date_modified_gmt)
    {
        if (is_null($date_modified_gmt)) {
            throw new \InvalidArgumentException('non-nullable date_modified_gmt cannot be null');
        }
        $this->container['date_modified_gmt'] = $date_modified_gmt;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description description
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            throw new \InvalidArgumentException('non-nullable description cannot be null');
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets permalink
     *
     * @return string|null
     */
    public function getPermalink()
    {
        return $this->container['permalink'];
    }

    /**
     * Sets permalink
     *
     * @param string|null $permalink permalink
     *
     * @return self
     */
    public function setPermalink($permalink)
    {
        if (is_null($permalink)) {
            throw new \InvalidArgumentException('non-nullable permalink cannot be null');
        }
        $this->container['permalink'] = $permalink;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku sku
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            throw new \InvalidArgumentException('non-nullable sku cannot be null');
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets price
     *
     * @return string|null
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param string|null $price price
     *
     * @return self
     */
    public function setPrice($price)
    {
        if (is_null($price)) {
            throw new \InvalidArgumentException('non-nullable price cannot be null');
        }
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets regular_price
     *
     * @return string|null
     */
    public function getRegularPrice()
    {
        return $this->container['regular_price'];
    }

    /**
     * Sets regular_price
     *
     * @param string|null $regular_price regular_price
     *
     * @return self
     */
    public function setRegularPrice($regular_price)
    {
        if (is_null($regular_price)) {
            throw new \InvalidArgumentException('non-nullable regular_price cannot be null');
        }
        $this->container['regular_price'] = $regular_price;

        return $this;
    }

    /**
     * Gets sale_price
     *
     * @return string|null
     */
    public function getSalePrice()
    {
        return $this->container['sale_price'];
    }

    /**
     * Sets sale_price
     *
     * @param string|null $sale_price sale_price
     *
     * @return self
     */
    public function setSalePrice($sale_price)
    {
        if (is_null($sale_price)) {
            throw new \InvalidArgumentException('non-nullable sale_price cannot be null');
        }
        $this->container['sale_price'] = $sale_price;

        return $this;
    }

    /**
     * Gets date_on_sale_from
     *
     * @return \DateTime|null
     */
    public function getDateOnSaleFrom()
    {
        return $this->container['date_on_sale_from'];
    }

    /**
     * Sets date_on_sale_from
     *
     * @param \DateTime|null $date_on_sale_from date_on_sale_from
     *
     * @return self
     */
    public function setDateOnSaleFrom($date_on_sale_from)
    {
        if (is_null($date_on_sale_from)) {
            throw new \InvalidArgumentException('non-nullable date_on_sale_from cannot be null');
        }
        $this->container['date_on_sale_from'] = $date_on_sale_from;

        return $this;
    }

    /**
     * Gets date_on_sale_from_gmt
     *
     * @return \DateTime|null
     */
    public function getDateOnSaleFromGmt()
    {
        return $this->container['date_on_sale_from_gmt'];
    }

    /**
     * Sets date_on_sale_from_gmt
     *
     * @param \DateTime|null $date_on_sale_from_gmt date_on_sale_from_gmt
     *
     * @return self
     */
    public function setDateOnSaleFromGmt($date_on_sale_from_gmt)
    {
        if (is_null($date_on_sale_from_gmt)) {
            throw new \InvalidArgumentException('non-nullable date_on_sale_from_gmt cannot be null');
        }
        $this->container['date_on_sale_from_gmt'] = $date_on_sale_from_gmt;

        return $this;
    }

    /**
     * Gets date_on_sale_to
     *
     * @return \DateTime|null
     */
    public function getDateOnSaleTo()
    {
        return $this->container['date_on_sale_to'];
    }

    /**
     * Sets date_on_sale_to
     *
     * @param \DateTime|null $date_on_sale_to date_on_sale_to
     *
     * @return self
     */
    public function setDateOnSaleTo($date_on_sale_to)
    {
        if (is_null($date_on_sale_to)) {
            throw new \InvalidArgumentException('non-nullable date_on_sale_to cannot be null');
        }
        $this->container['date_on_sale_to'] = $date_on_sale_to;

        return $this;
    }

    /**
     * Gets date_on_sale_to_gmt
     *
     * @return \DateTime|null
     */
    public function getDateOnSaleToGmt()
    {
        return $this->container['date_on_sale_to_gmt'];
    }

    /**
     * Sets date_on_sale_to_gmt
     *
     * @param \DateTime|null $date_on_sale_to_gmt date_on_sale_to_gmt
     *
     * @return self
     */
    public function setDateOnSaleToGmt($date_on_sale_to_gmt)
    {
        if (is_null($date_on_sale_to_gmt)) {
            throw new \InvalidArgumentException('non-nullable date_on_sale_to_gmt cannot be null');
        }
        $this->container['date_on_sale_to_gmt'] = $date_on_sale_to_gmt;

        return $this;
    }

    /**
     * Gets on_sale
     *
     * @return bool|null
     */
    public function getOnSale()
    {
        return $this->container['on_sale'];
    }

    /**
     * Sets on_sale
     *
     * @param bool|null $on_sale on_sale
     *
     * @return self
     */
    public function setOnSale($on_sale)
    {
        if (is_null($on_sale)) {
            throw new \InvalidArgumentException('non-nullable on_sale cannot be null');
        }
        $this->container['on_sale'] = $on_sale;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets purchasable
     *
     * @return bool|null
     */
    public function getPurchasable()
    {
        return $this->container['purchasable'];
    }

    /**
     * Sets purchasable
     *
     * @param bool|null $purchasable purchasable
     *
     * @return self
     */
    public function setPurchasable($purchasable)
    {
        if (is_null($purchasable)) {
            throw new \InvalidArgumentException('non-nullable purchasable cannot be null');
        }
        $this->container['purchasable'] = $purchasable;

        return $this;
    }

    /**
     * Gets virtual
     *
     * @return bool|null
     */
    public function getVirtual()
    {
        return $this->container['virtual'];
    }

    /**
     * Sets virtual
     *
     * @param bool|null $virtual virtual
     *
     * @return self
     */
    public function setVirtual($virtual)
    {
        if (is_null($virtual)) {
            throw new \InvalidArgumentException('non-nullable virtual cannot be null');
        }
        $this->container['virtual'] = $virtual;

        return $this;
    }

    /**
     * Gets downloadable
     *
     * @return bool|null
     */
    public function getDownloadable()
    {
        return $this->container['downloadable'];
    }

    /**
     * Sets downloadable
     *
     * @param bool|null $downloadable downloadable
     *
     * @return self
     */
    public function setDownloadable($downloadable)
    {
        if (is_null($downloadable)) {
            throw new \InvalidArgumentException('non-nullable downloadable cannot be null');
        }
        $this->container['downloadable'] = $downloadable;

        return $this;
    }

    /**
     * Gets downloads
     *
     * @return object[]|null
     */
    public function getDownloads()
    {
        return $this->container['downloads'];
    }

    /**
     * Sets downloads
     *
     * @param object[]|null $downloads downloads
     *
     * @return self
     */
    public function setDownloads($downloads)
    {
        if (is_null($downloads)) {
            throw new \InvalidArgumentException('non-nullable downloads cannot be null');
        }
        $this->container['downloads'] = $downloads;

        return $this;
    }

    /**
     * Gets download_limit
     *
     * @return int|null
     */
    public function getDownloadLimit()
    {
        return $this->container['download_limit'];
    }

    /**
     * Sets download_limit
     *
     * @param int|null $download_limit download_limit
     *
     * @return self
     */
    public function setDownloadLimit($download_limit)
    {
        if (is_null($download_limit)) {
            throw new \InvalidArgumentException('non-nullable download_limit cannot be null');
        }
        $this->container['download_limit'] = $download_limit;

        return $this;
    }

    /**
     * Gets download_expiry
     *
     * @return int|null
     */
    public function getDownloadExpiry()
    {
        return $this->container['download_expiry'];
    }

    /**
     * Sets download_expiry
     *
     * @param int|null $download_expiry download_expiry
     *
     * @return self
     */
    public function setDownloadExpiry($download_expiry)
    {
        if (is_null($download_expiry)) {
            throw new \InvalidArgumentException('non-nullable download_expiry cannot be null');
        }
        $this->container['download_expiry'] = $download_expiry;

        return $this;
    }

    /**
     * Gets tax_status
     *
     * @return string|null
     */
    public function getTaxStatus()
    {
        return $this->container['tax_status'];
    }

    /**
     * Sets tax_status
     *
     * @param string|null $tax_status tax_status
     *
     * @return self
     */
    public function setTaxStatus($tax_status)
    {
        if (is_null($tax_status)) {
            throw new \InvalidArgumentException('non-nullable tax_status cannot be null');
        }
        $this->container['tax_status'] = $tax_status;

        return $this;
    }

    /**
     * Gets tax_class
     *
     * @return string|null
     */
    public function getTaxClass()
    {
        return $this->container['tax_class'];
    }

    /**
     * Sets tax_class
     *
     * @param string|null $tax_class tax_class
     *
     * @return self
     */
    public function setTaxClass($tax_class)
    {
        if (is_null($tax_class)) {
            throw new \InvalidArgumentException('non-nullable tax_class cannot be null');
        }
        $this->container['tax_class'] = $tax_class;

        return $this;
    }

    /**
     * Gets manage_stock
     *
     * @return bool|null
     */
    public function getManageStock()
    {
        return $this->container['manage_stock'];
    }

    /**
     * Sets manage_stock
     *
     * @param bool|null $manage_stock manage_stock
     *
     * @return self
     */
    public function setManageStock($manage_stock)
    {
        if (is_null($manage_stock)) {
            throw new \InvalidArgumentException('non-nullable manage_stock cannot be null');
        }
        $this->container['manage_stock'] = $manage_stock;

        return $this;
    }

    /**
     * Gets stock_quantity
     *
     * @return int|null
     */
    public function getStockQuantity()
    {
        return $this->container['stock_quantity'];
    }

    /**
     * Sets stock_quantity
     *
     * @param int|null $stock_quantity stock_quantity
     *
     * @return self
     */
    public function setStockQuantity($stock_quantity)
    {
        if (is_null($stock_quantity)) {
            throw new \InvalidArgumentException('non-nullable stock_quantity cannot be null');
        }
        $this->container['stock_quantity'] = $stock_quantity;

        return $this;
    }

    /**
     * Gets stock_status
     *
     * @return string|null
     */
    public function getStockStatus()
    {
        return $this->container['stock_status'];
    }

    /**
     * Sets stock_status
     *
     * @param string|null $stock_status stock_status
     *
     * @return self
     */
    public function setStockStatus($stock_status)
    {
        if (is_null($stock_status)) {
            throw new \InvalidArgumentException('non-nullable stock_status cannot be null');
        }
        $this->container['stock_status'] = $stock_status;

        return $this;
    }

    /**
     * Gets backorders
     *
     * @return string|null
     */
    public function getBackorders()
    {
        return $this->container['backorders'];
    }

    /**
     * Sets backorders
     *
     * @param string|null $backorders backorders
     *
     * @return self
     */
    public function setBackorders($backorders)
    {
        if (is_null($backorders)) {
            throw new \InvalidArgumentException('non-nullable backorders cannot be null');
        }
        $this->container['backorders'] = $backorders;

        return $this;
    }

    /**
     * Gets backorders_allowed
     *
     * @return bool|null
     */
    public function getBackordersAllowed()
    {
        return $this->container['backorders_allowed'];
    }

    /**
     * Sets backorders_allowed
     *
     * @param bool|null $backorders_allowed backorders_allowed
     *
     * @return self
     */
    public function setBackordersAllowed($backorders_allowed)
    {
        if (is_null($backorders_allowed)) {
            throw new \InvalidArgumentException('non-nullable backorders_allowed cannot be null');
        }
        $this->container['backorders_allowed'] = $backorders_allowed;

        return $this;
    }

    /**
     * Gets backordered
     *
     * @return bool|null
     */
    public function getBackordered()
    {
        return $this->container['backordered'];
    }

    /**
     * Sets backordered
     *
     * @param bool|null $backordered backordered
     *
     * @return self
     */
    public function setBackordered($backordered)
    {
        if (is_null($backordered)) {
            throw new \InvalidArgumentException('non-nullable backordered cannot be null');
        }
        $this->container['backordered'] = $backordered;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return string|null
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param string|null $weight weight
     *
     * @return self
     */
    public function setWeight($weight)
    {
        if (is_null($weight)) {
            throw new \InvalidArgumentException('non-nullable weight cannot be null');
        }
        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets dimensions
     *
     * @return \Woocommerce\Model\ProductVariationDimensions|null
     */
    public function getDimensions()
    {
        return $this->container['dimensions'];
    }

    /**
     * Sets dimensions
     *
     * @param \Woocommerce\Model\ProductVariationDimensions|null $dimensions dimensions
     *
     * @return self
     */
    public function setDimensions($dimensions)
    {
        if (is_null($dimensions)) {
            throw new \InvalidArgumentException('non-nullable dimensions cannot be null');
        }
        $this->container['dimensions'] = $dimensions;

        return $this;
    }

    /**
     * Gets shipping_class
     *
     * @return string|null
     */
    public function getShippingClass()
    {
        return $this->container['shipping_class'];
    }

    /**
     * Sets shipping_class
     *
     * @param string|null $shipping_class shipping_class
     *
     * @return self
     */
    public function setShippingClass($shipping_class)
    {
        if (is_null($shipping_class)) {
            throw new \InvalidArgumentException('non-nullable shipping_class cannot be null');
        }
        $this->container['shipping_class'] = $shipping_class;

        return $this;
    }

    /**
     * Gets shipping_class_id
     *
     * @return int|null
     */
    public function getShippingClassId()
    {
        return $this->container['shipping_class_id'];
    }

    /**
     * Sets shipping_class_id
     *
     * @param int|null $shipping_class_id shipping_class_id
     *
     * @return self
     */
    public function setShippingClassId($shipping_class_id)
    {
        if (is_null($shipping_class_id)) {
            throw new \InvalidArgumentException('non-nullable shipping_class_id cannot be null');
        }
        $this->container['shipping_class_id'] = $shipping_class_id;

        return $this;
    }

    /**
     * Gets image
     *
     * @return \Woocommerce\Model\Image|null
     */
    public function getImage()
    {
        return $this->container['image'];
    }

    /**
     * Sets image
     *
     * @param \Woocommerce\Model\Image|null $image image
     *
     * @return self
     */
    public function setImage($image)
    {
        if (is_null($image)) {
            throw new \InvalidArgumentException('non-nullable image cannot be null');
        }
        $this->container['image'] = $image;

        return $this;
    }

    /**
     * Gets attributes
     *
     * @return \Woocommerce\Model\ProductVariationAttributesInner[]|null
     */
    public function getAttributes()
    {
        return $this->container['attributes'];
    }

    /**
     * Sets attributes
     *
     * @param \Woocommerce\Model\ProductVariationAttributesInner[]|null $attributes attributes
     *
     * @return self
     */
    public function setAttributes($attributes)
    {
        if (is_null($attributes)) {
            throw new \InvalidArgumentException('non-nullable attributes cannot be null');
        }
        $this->container['attributes'] = $attributes;

        return $this;
    }

    /**
     * Gets menu_order
     *
     * @return int|null
     */
    public function getMenuOrder()
    {
        return $this->container['menu_order'];
    }

    /**
     * Sets menu_order
     *
     * @param int|null $menu_order menu_order
     *
     * @return self
     */
    public function setMenuOrder($menu_order)
    {
        if (is_null($menu_order)) {
            throw new \InvalidArgumentException('non-nullable menu_order cannot be null');
        }
        $this->container['menu_order'] = $menu_order;

        return $this;
    }

    /**
     * Gets meta_data
     *
     * @return \Woocommerce\Model\Metadata[]|null
     */
    public function getMetaData()
    {
        return $this->container['meta_data'];
    }

    /**
     * Sets meta_data
     *
     * @param \Woocommerce\Model\Metadata[]|null $meta_data meta_data
     *
     * @return self
     */
    public function setMetaData($meta_data)
    {
        if (is_null($meta_data)) {
            throw new \InvalidArgumentException('non-nullable meta_data cannot be null');
        }
        $this->container['meta_data'] = $meta_data;

        return $this;
    }

    /**
     * Gets _links
     *
     * @return \Woocommerce\Model\Links|null
     */
    public function getLinks()
    {
        return $this->container['_links'];
    }

    /**
     * Sets _links
     *
     * @param \Woocommerce\Model\Links|null $_links _links
     *
     * @return self
     */
    public function setLinks($_links)
    {
        if (is_null($_links)) {
            throw new \InvalidArgumentException('non-nullable _links cannot be null');
        }
        $this->container['_links'] = $_links;

        return $this;
    }

    /**
     * Gets visible
     *
     * @return bool|null
     */
    public function getVisible()
    {
        return $this->container['visible'];
    }

    /**
     * Sets visible
     *
     * @param bool|null $visible visible
     *
     * @return self
     */
    public function setVisible($visible)
    {
        if (is_null($visible)) {
            throw new \InvalidArgumentException('non-nullable visible cannot be null');
        }
        $this->container['visible'] = $visible;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


