<?php
/**
 * Product
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Woocommerce
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Woocommerce API
 *
 * Woocommerce v3.0 API See https://woocommerce.github.io/woocommerce-rest-api-docs/#introduction
 *
 * The version of the OpenAPI document: 3.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Woocommerce\Model;

use \ArrayAccess;
use \Woocommerce\ObjectSerializer;

/**
 * Product Class Doc Comment
 *
 * @category Class
 * @description 
 * @package  Woocommerce
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Product implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Product';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'name' => 'string',
        'slug' => 'string',
        'permalink' => 'string',
        'date_created' => '\DateTime',
        'date_created_gmt' => '\DateTime',
        'date_modified' => '\DateTime',
        'date_modified_gmt' => '\DateTime',
        'type' => 'string',
        'status' => 'string',
        'featured' => 'bool',
        'catalog_visibility' => 'string',
        'description' => 'string',
        'short_description' => 'string',
        'sku' => 'string',
        'price' => 'string',
        'regular_price' => 'string',
        'sale_price' => 'string',
        'date_on_sale_from' => '\DateTime',
        'date_on_sale_from_gmt' => '\DateTime',
        'date_on_sale_to' => '\DateTime',
        'date_on_sale_to_gmt' => '\DateTime',
        'price_html' => 'string',
        'on_sale' => 'bool',
        'purchasable' => 'bool',
        'total_sales' => 'int',
        'virtual' => 'bool',
        'downloadable' => 'bool',
        'downloads' => '\Woocommerce\Model\Download[]',
        'download_limit' => 'int',
        'download_expiry' => 'int',
        'external_url' => 'string',
        'button_text' => 'string',
        'tax_status' => 'string',
        'tax_class' => 'string',
        'manage_stock' => 'bool',
        'stock_quantity' => 'int',
        'stock_status' => 'string',
        'backorders' => 'string',
        'backorders_allowed' => 'bool',
        'backordered' => 'bool',
        'sold_individually' => 'bool',
        'weight' => 'string',
        'dimensions' => '\Woocommerce\Model\Dimension',
        'shipping_required' => 'bool',
        'shipping_taxable' => 'bool',
        'shipping_class' => 'string',
        'shipping_class_id' => 'int',
        'reviews_allowed' => 'bool',
        'average_rating' => 'string',
        'rating_count' => 'int',
        'related_ids' => 'int[]',
        'upsell_ids' => 'int[]',
        'cross_sell_ids' => 'int[]',
        'parent_id' => 'int',
        'purchase_note' => 'string',
        'categories' => '\Woocommerce\Model\Category[]',
        'tags' => '\Woocommerce\Model\Tag[]',
        'images' => '\Woocommerce\Model\Image[]',
        'attributes' => '\Woocommerce\Model\Attribute[]',
        'default_attributes' => '\Woocommerce\Model\DefaultAttribute[]',
        'variations' => 'int[]',
        'grouped_products' => 'object[]',
        'menu_order' => 'int',
        'meta_data' => '\Woocommerce\Model\Metadata[]',
        '_links' => '\Woocommerce\Model\Links'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'name' => null,
        'slug' => null,
        'permalink' => null,
        'date_created' => 'date-time',
        'date_created_gmt' => 'date-time',
        'date_modified' => 'date-time',
        'date_modified_gmt' => 'date-time',
        'type' => null,
        'status' => null,
        'featured' => null,
        'catalog_visibility' => null,
        'description' => null,
        'short_description' => null,
        'sku' => null,
        'price' => null,
        'regular_price' => null,
        'sale_price' => null,
        'date_on_sale_from' => 'date-time',
        'date_on_sale_from_gmt' => 'date-time',
        'date_on_sale_to' => 'date-time',
        'date_on_sale_to_gmt' => 'date-time',
        'price_html' => null,
        'on_sale' => null,
        'purchasable' => null,
        'total_sales' => null,
        'virtual' => null,
        'downloadable' => null,
        'downloads' => null,
        'download_limit' => null,
        'download_expiry' => null,
        'external_url' => null,
        'button_text' => null,
        'tax_status' => null,
        'tax_class' => null,
        'manage_stock' => null,
        'stock_quantity' => null,
        'stock_status' => null,
        'backorders' => null,
        'backorders_allowed' => null,
        'backordered' => null,
        'sold_individually' => null,
        'weight' => null,
        'dimensions' => null,
        'shipping_required' => null,
        'shipping_taxable' => null,
        'shipping_class' => null,
        'shipping_class_id' => null,
        'reviews_allowed' => null,
        'average_rating' => null,
        'rating_count' => null,
        'related_ids' => null,
        'upsell_ids' => null,
        'cross_sell_ids' => null,
        'parent_id' => null,
        'purchase_note' => null,
        'categories' => null,
        'tags' => null,
        'images' => null,
        'attributes' => null,
        'default_attributes' => null,
        'variations' => null,
        'grouped_products' => null,
        'menu_order' => null,
        'meta_data' => null,
        '_links' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'name' => false,
        'slug' => false,
        'permalink' => false,
        'date_created' => false,
        'date_created_gmt' => false,
        'date_modified' => false,
        'date_modified_gmt' => false,
        'type' => false,
        'status' => false,
        'featured' => false,
        'catalog_visibility' => false,
        'description' => false,
        'short_description' => false,
        'sku' => false,
        'price' => false,
        'regular_price' => false,
        'sale_price' => false,
        'date_on_sale_from' => false,
        'date_on_sale_from_gmt' => false,
        'date_on_sale_to' => false,
        'date_on_sale_to_gmt' => false,
        'price_html' => false,
        'on_sale' => false,
        'purchasable' => false,
        'total_sales' => false,
        'virtual' => false,
        'downloadable' => false,
        'downloads' => false,
        'download_limit' => false,
        'download_expiry' => false,
        'external_url' => false,
        'button_text' => false,
        'tax_status' => false,
        'tax_class' => false,
        'manage_stock' => false,
        'stock_quantity' => false,
        'stock_status' => false,
        'backorders' => false,
        'backorders_allowed' => false,
        'backordered' => false,
        'sold_individually' => false,
        'weight' => false,
        'dimensions' => false,
        'shipping_required' => false,
        'shipping_taxable' => false,
        'shipping_class' => false,
        'shipping_class_id' => false,
        'reviews_allowed' => false,
        'average_rating' => false,
        'rating_count' => false,
        'related_ids' => false,
        'upsell_ids' => false,
        'cross_sell_ids' => false,
        'parent_id' => false,
        'purchase_note' => false,
        'categories' => false,
        'tags' => false,
        'images' => false,
        'attributes' => false,
        'default_attributes' => false,
        'variations' => false,
        'grouped_products' => false,
        'menu_order' => false,
        'meta_data' => false,
        '_links' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'name' => 'name',
        'slug' => 'slug',
        'permalink' => 'permalink',
        'date_created' => 'date_created',
        'date_created_gmt' => 'date_created_gmt',
        'date_modified' => 'date_modified',
        'date_modified_gmt' => 'date_modified_gmt',
        'type' => 'type',
        'status' => 'status',
        'featured' => 'featured',
        'catalog_visibility' => 'catalog_visibility',
        'description' => 'description',
        'short_description' => 'short_description',
        'sku' => 'sku',
        'price' => 'price',
        'regular_price' => 'regular_price',
        'sale_price' => 'sale_price',
        'date_on_sale_from' => 'date_on_sale_from',
        'date_on_sale_from_gmt' => 'date_on_sale_from_gmt',
        'date_on_sale_to' => 'date_on_sale_to',
        'date_on_sale_to_gmt' => 'date_on_sale_to_gmt',
        'price_html' => 'price_html',
        'on_sale' => 'on_sale',
        'purchasable' => 'purchasable',
        'total_sales' => 'total_sales',
        'virtual' => 'virtual',
        'downloadable' => 'downloadable',
        'downloads' => 'downloads',
        'download_limit' => 'download_limit',
        'download_expiry' => 'download_expiry',
        'external_url' => 'external_url',
        'button_text' => 'button_text',
        'tax_status' => 'tax_status',
        'tax_class' => 'tax_class',
        'manage_stock' => 'manage_stock',
        'stock_quantity' => 'stock_quantity',
        'stock_status' => 'stock_status',
        'backorders' => 'backorders',
        'backorders_allowed' => 'backorders_allowed',
        'backordered' => 'backordered',
        'sold_individually' => 'sold_individually',
        'weight' => 'weight',
        'dimensions' => 'dimensions',
        'shipping_required' => 'shipping_required',
        'shipping_taxable' => 'shipping_taxable',
        'shipping_class' => 'shipping_class',
        'shipping_class_id' => 'shipping_class_id',
        'reviews_allowed' => 'reviews_allowed',
        'average_rating' => 'average_rating',
        'rating_count' => 'rating_count',
        'related_ids' => 'related_ids',
        'upsell_ids' => 'upsell_ids',
        'cross_sell_ids' => 'cross_sell_ids',
        'parent_id' => 'parent_id',
        'purchase_note' => 'purchase_note',
        'categories' => 'categories',
        'tags' => 'tags',
        'images' => 'images',
        'attributes' => 'attributes',
        'default_attributes' => 'default_attributes',
        'variations' => 'variations',
        'grouped_products' => 'grouped_products',
        'menu_order' => 'menu_order',
        'meta_data' => 'meta_data',
        '_links' => '_links'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'name' => 'setName',
        'slug' => 'setSlug',
        'permalink' => 'setPermalink',
        'date_created' => 'setDateCreated',
        'date_created_gmt' => 'setDateCreatedGmt',
        'date_modified' => 'setDateModified',
        'date_modified_gmt' => 'setDateModifiedGmt',
        'type' => 'setType',
        'status' => 'setStatus',
        'featured' => 'setFeatured',
        'catalog_visibility' => 'setCatalogVisibility',
        'description' => 'setDescription',
        'short_description' => 'setShortDescription',
        'sku' => 'setSku',
        'price' => 'setPrice',
        'regular_price' => 'setRegularPrice',
        'sale_price' => 'setSalePrice',
        'date_on_sale_from' => 'setDateOnSaleFrom',
        'date_on_sale_from_gmt' => 'setDateOnSaleFromGmt',
        'date_on_sale_to' => 'setDateOnSaleTo',
        'date_on_sale_to_gmt' => 'setDateOnSaleToGmt',
        'price_html' => 'setPriceHtml',
        'on_sale' => 'setOnSale',
        'purchasable' => 'setPurchasable',
        'total_sales' => 'setTotalSales',
        'virtual' => 'setVirtual',
        'downloadable' => 'setDownloadable',
        'downloads' => 'setDownloads',
        'download_limit' => 'setDownloadLimit',
        'download_expiry' => 'setDownloadExpiry',
        'external_url' => 'setExternalUrl',
        'button_text' => 'setButtonText',
        'tax_status' => 'setTaxStatus',
        'tax_class' => 'setTaxClass',
        'manage_stock' => 'setManageStock',
        'stock_quantity' => 'setStockQuantity',
        'stock_status' => 'setStockStatus',
        'backorders' => 'setBackorders',
        'backorders_allowed' => 'setBackordersAllowed',
        'backordered' => 'setBackordered',
        'sold_individually' => 'setSoldIndividually',
        'weight' => 'setWeight',
        'dimensions' => 'setDimensions',
        'shipping_required' => 'setShippingRequired',
        'shipping_taxable' => 'setShippingTaxable',
        'shipping_class' => 'setShippingClass',
        'shipping_class_id' => 'setShippingClassId',
        'reviews_allowed' => 'setReviewsAllowed',
        'average_rating' => 'setAverageRating',
        'rating_count' => 'setRatingCount',
        'related_ids' => 'setRelatedIds',
        'upsell_ids' => 'setUpsellIds',
        'cross_sell_ids' => 'setCrossSellIds',
        'parent_id' => 'setParentId',
        'purchase_note' => 'setPurchaseNote',
        'categories' => 'setCategories',
        'tags' => 'setTags',
        'images' => 'setImages',
        'attributes' => 'setAttributes',
        'default_attributes' => 'setDefaultAttributes',
        'variations' => 'setVariations',
        'grouped_products' => 'setGroupedProducts',
        'menu_order' => 'setMenuOrder',
        'meta_data' => 'setMetaData',
        '_links' => 'setLinks'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'name' => 'getName',
        'slug' => 'getSlug',
        'permalink' => 'getPermalink',
        'date_created' => 'getDateCreated',
        'date_created_gmt' => 'getDateCreatedGmt',
        'date_modified' => 'getDateModified',
        'date_modified_gmt' => 'getDateModifiedGmt',
        'type' => 'getType',
        'status' => 'getStatus',
        'featured' => 'getFeatured',
        'catalog_visibility' => 'getCatalogVisibility',
        'description' => 'getDescription',
        'short_description' => 'getShortDescription',
        'sku' => 'getSku',
        'price' => 'getPrice',
        'regular_price' => 'getRegularPrice',
        'sale_price' => 'getSalePrice',
        'date_on_sale_from' => 'getDateOnSaleFrom',
        'date_on_sale_from_gmt' => 'getDateOnSaleFromGmt',
        'date_on_sale_to' => 'getDateOnSaleTo',
        'date_on_sale_to_gmt' => 'getDateOnSaleToGmt',
        'price_html' => 'getPriceHtml',
        'on_sale' => 'getOnSale',
        'purchasable' => 'getPurchasable',
        'total_sales' => 'getTotalSales',
        'virtual' => 'getVirtual',
        'downloadable' => 'getDownloadable',
        'downloads' => 'getDownloads',
        'download_limit' => 'getDownloadLimit',
        'download_expiry' => 'getDownloadExpiry',
        'external_url' => 'getExternalUrl',
        'button_text' => 'getButtonText',
        'tax_status' => 'getTaxStatus',
        'tax_class' => 'getTaxClass',
        'manage_stock' => 'getManageStock',
        'stock_quantity' => 'getStockQuantity',
        'stock_status' => 'getStockStatus',
        'backorders' => 'getBackorders',
        'backorders_allowed' => 'getBackordersAllowed',
        'backordered' => 'getBackordered',
        'sold_individually' => 'getSoldIndividually',
        'weight' => 'getWeight',
        'dimensions' => 'getDimensions',
        'shipping_required' => 'getShippingRequired',
        'shipping_taxable' => 'getShippingTaxable',
        'shipping_class' => 'getShippingClass',
        'shipping_class_id' => 'getShippingClassId',
        'reviews_allowed' => 'getReviewsAllowed',
        'average_rating' => 'getAverageRating',
        'rating_count' => 'getRatingCount',
        'related_ids' => 'getRelatedIds',
        'upsell_ids' => 'getUpsellIds',
        'cross_sell_ids' => 'getCrossSellIds',
        'parent_id' => 'getParentId',
        'purchase_note' => 'getPurchaseNote',
        'categories' => 'getCategories',
        'tags' => 'getTags',
        'images' => 'getImages',
        'attributes' => 'getAttributes',
        'default_attributes' => 'getDefaultAttributes',
        'variations' => 'getVariations',
        'grouped_products' => 'getGroupedProducts',
        'menu_order' => 'getMenuOrder',
        'meta_data' => 'getMetaData',
        '_links' => 'getLinks'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('slug', $data ?? [], null);
        $this->setIfExists('permalink', $data ?? [], null);
        $this->setIfExists('date_created', $data ?? [], null);
        $this->setIfExists('date_created_gmt', $data ?? [], null);
        $this->setIfExists('date_modified', $data ?? [], null);
        $this->setIfExists('date_modified_gmt', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('featured', $data ?? [], null);
        $this->setIfExists('catalog_visibility', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('short_description', $data ?? [], null);
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('price', $data ?? [], null);
        $this->setIfExists('regular_price', $data ?? [], null);
        $this->setIfExists('sale_price', $data ?? [], null);
        $this->setIfExists('date_on_sale_from', $data ?? [], null);
        $this->setIfExists('date_on_sale_from_gmt', $data ?? [], null);
        $this->setIfExists('date_on_sale_to', $data ?? [], null);
        $this->setIfExists('date_on_sale_to_gmt', $data ?? [], null);
        $this->setIfExists('price_html', $data ?? [], null);
        $this->setIfExists('on_sale', $data ?? [], null);
        $this->setIfExists('purchasable', $data ?? [], null);
        $this->setIfExists('total_sales', $data ?? [], null);
        $this->setIfExists('virtual', $data ?? [], null);
        $this->setIfExists('downloadable', $data ?? [], null);
        $this->setIfExists('downloads', $data ?? [], null);
        $this->setIfExists('download_limit', $data ?? [], null);
        $this->setIfExists('download_expiry', $data ?? [], null);
        $this->setIfExists('external_url', $data ?? [], null);
        $this->setIfExists('button_text', $data ?? [], null);
        $this->setIfExists('tax_status', $data ?? [], null);
        $this->setIfExists('tax_class', $data ?? [], null);
        $this->setIfExists('manage_stock', $data ?? [], null);
        $this->setIfExists('stock_quantity', $data ?? [], null);
        $this->setIfExists('stock_status', $data ?? [], null);
        $this->setIfExists('backorders', $data ?? [], null);
        $this->setIfExists('backorders_allowed', $data ?? [], null);
        $this->setIfExists('backordered', $data ?? [], null);
        $this->setIfExists('sold_individually', $data ?? [], null);
        $this->setIfExists('weight', $data ?? [], null);
        $this->setIfExists('dimensions', $data ?? [], null);
        $this->setIfExists('shipping_required', $data ?? [], null);
        $this->setIfExists('shipping_taxable', $data ?? [], null);
        $this->setIfExists('shipping_class', $data ?? [], null);
        $this->setIfExists('shipping_class_id', $data ?? [], null);
        $this->setIfExists('reviews_allowed', $data ?? [], null);
        $this->setIfExists('average_rating', $data ?? [], null);
        $this->setIfExists('rating_count', $data ?? [], null);
        $this->setIfExists('related_ids', $data ?? [], null);
        $this->setIfExists('upsell_ids', $data ?? [], null);
        $this->setIfExists('cross_sell_ids', $data ?? [], null);
        $this->setIfExists('parent_id', $data ?? [], null);
        $this->setIfExists('purchase_note', $data ?? [], null);
        $this->setIfExists('categories', $data ?? [], null);
        $this->setIfExists('tags', $data ?? [], null);
        $this->setIfExists('images', $data ?? [], null);
        $this->setIfExists('attributes', $data ?? [], null);
        $this->setIfExists('default_attributes', $data ?? [], null);
        $this->setIfExists('variations', $data ?? [], null);
        $this->setIfExists('grouped_products', $data ?? [], null);
        $this->setIfExists('menu_order', $data ?? [], null);
        $this->setIfExists('meta_data', $data ?? [], null);
        $this->setIfExists('_links', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets slug
     *
     * @return string|null
     */
    public function getSlug()
    {
        return $this->container['slug'];
    }

    /**
     * Sets slug
     *
     * @param string|null $slug slug
     *
     * @return self
     */
    public function setSlug($slug)
    {
        if (is_null($slug)) {
            throw new \InvalidArgumentException('non-nullable slug cannot be null');
        }
        $this->container['slug'] = $slug;

        return $this;
    }

    /**
     * Gets permalink
     *
     * @return string|null
     */
    public function getPermalink()
    {
        return $this->container['permalink'];
    }

    /**
     * Sets permalink
     *
     * @param string|null $permalink permalink
     *
     * @return self
     */
    public function setPermalink($permalink)
    {
        if (is_null($permalink)) {
            throw new \InvalidArgumentException('non-nullable permalink cannot be null');
        }
        $this->container['permalink'] = $permalink;

        return $this;
    }

    /**
     * Gets date_created
     *
     * @return \DateTime|null
     */
    public function getDateCreated()
    {
        return $this->container['date_created'];
    }

    /**
     * Sets date_created
     *
     * @param \DateTime|null $date_created date_created
     *
     * @return self
     */
    public function setDateCreated($date_created)
    {
        if (is_null($date_created)) {
            throw new \InvalidArgumentException('non-nullable date_created cannot be null');
        }
        $this->container['date_created'] = $date_created;

        return $this;
    }

    /**
     * Gets date_created_gmt
     *
     * @return \DateTime|null
     */
    public function getDateCreatedGmt()
    {
        return $this->container['date_created_gmt'];
    }

    /**
     * Sets date_created_gmt
     *
     * @param \DateTime|null $date_created_gmt date_created_gmt
     *
     * @return self
     */
    public function setDateCreatedGmt($date_created_gmt)
    {
        if (is_null($date_created_gmt)) {
            throw new \InvalidArgumentException('non-nullable date_created_gmt cannot be null');
        }
        $this->container['date_created_gmt'] = $date_created_gmt;

        return $this;
    }

    /**
     * Gets date_modified
     *
     * @return \DateTime|null
     */
    public function getDateModified()
    {
        return $this->container['date_modified'];
    }

    /**
     * Sets date_modified
     *
     * @param \DateTime|null $date_modified date_modified
     *
     * @return self
     */
    public function setDateModified($date_modified)
    {
        if (is_null($date_modified)) {
            throw new \InvalidArgumentException('non-nullable date_modified cannot be null');
        }
        $this->container['date_modified'] = $date_modified;

        return $this;
    }

    /**
     * Gets date_modified_gmt
     *
     * @return \DateTime|null
     */
    public function getDateModifiedGmt()
    {
        return $this->container['date_modified_gmt'];
    }

    /**
     * Sets date_modified_gmt
     *
     * @param \DateTime|null $date_modified_gmt date_modified_gmt
     *
     * @return self
     */
    public function setDateModifiedGmt($date_modified_gmt)
    {
        if (is_null($date_modified_gmt)) {
            throw new \InvalidArgumentException('non-nullable date_modified_gmt cannot be null');
        }
        $this->container['date_modified_gmt'] = $date_modified_gmt;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type type
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets featured
     *
     * @return bool|null
     */
    public function getFeatured()
    {
        return $this->container['featured'];
    }

    /**
     * Sets featured
     *
     * @param bool|null $featured featured
     *
     * @return self
     */
    public function setFeatured($featured)
    {
        if (is_null($featured)) {
            throw new \InvalidArgumentException('non-nullable featured cannot be null');
        }
        $this->container['featured'] = $featured;

        return $this;
    }

    /**
     * Gets catalog_visibility
     *
     * @return string|null
     */
    public function getCatalogVisibility()
    {
        return $this->container['catalog_visibility'];
    }

    /**
     * Sets catalog_visibility
     *
     * @param string|null $catalog_visibility catalog_visibility
     *
     * @return self
     */
    public function setCatalogVisibility($catalog_visibility)
    {
        if (is_null($catalog_visibility)) {
            throw new \InvalidArgumentException('non-nullable catalog_visibility cannot be null');
        }
        $this->container['catalog_visibility'] = $catalog_visibility;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description description
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            throw new \InvalidArgumentException('non-nullable description cannot be null');
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets short_description
     *
     * @return string|null
     */
    public function getShortDescription()
    {
        return $this->container['short_description'];
    }

    /**
     * Sets short_description
     *
     * @param string|null $short_description short_description
     *
     * @return self
     */
    public function setShortDescription($short_description)
    {
        if (is_null($short_description)) {
            throw new \InvalidArgumentException('non-nullable short_description cannot be null');
        }
        $this->container['short_description'] = $short_description;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku sku
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            throw new \InvalidArgumentException('non-nullable sku cannot be null');
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets price
     *
     * @return string|null
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param string|null $price price
     *
     * @return self
     */
    public function setPrice($price)
    {
        if (is_null($price)) {
            throw new \InvalidArgumentException('non-nullable price cannot be null');
        }
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets regular_price
     *
     * @return string|null
     */
    public function getRegularPrice()
    {
        return $this->container['regular_price'];
    }

    /**
     * Sets regular_price
     *
     * @param string|null $regular_price regular_price
     *
     * @return self
     */
    public function setRegularPrice($regular_price)
    {
        if (is_null($regular_price)) {
            throw new \InvalidArgumentException('non-nullable regular_price cannot be null');
        }
        $this->container['regular_price'] = $regular_price;

        return $this;
    }

    /**
     * Gets sale_price
     *
     * @return string|null
     */
    public function getSalePrice()
    {
        return $this->container['sale_price'];
    }

    /**
     * Sets sale_price
     *
     * @param string|null $sale_price sale_price
     *
     * @return self
     */
    public function setSalePrice($sale_price)
    {
        if (is_null($sale_price)) {
            throw new \InvalidArgumentException('non-nullable sale_price cannot be null');
        }
        $this->container['sale_price'] = $sale_price;

        return $this;
    }

    /**
     * Gets date_on_sale_from
     *
     * @return \DateTime|null
     */
    public function getDateOnSaleFrom()
    {
        return $this->container['date_on_sale_from'];
    }

    /**
     * Sets date_on_sale_from
     *
     * @param \DateTime|null $date_on_sale_from date_on_sale_from
     *
     * @return self
     */
    public function setDateOnSaleFrom($date_on_sale_from)
    {
        if (is_null($date_on_sale_from)) {
            throw new \InvalidArgumentException('non-nullable date_on_sale_from cannot be null');
        }
        $this->container['date_on_sale_from'] = $date_on_sale_from;

        return $this;
    }

    /**
     * Gets date_on_sale_from_gmt
     *
     * @return \DateTime|null
     */
    public function getDateOnSaleFromGmt()
    {
        return $this->container['date_on_sale_from_gmt'];
    }

    /**
     * Sets date_on_sale_from_gmt
     *
     * @param \DateTime|null $date_on_sale_from_gmt date_on_sale_from_gmt
     *
     * @return self
     */
    public function setDateOnSaleFromGmt($date_on_sale_from_gmt)
    {
        if (is_null($date_on_sale_from_gmt)) {
            throw new \InvalidArgumentException('non-nullable date_on_sale_from_gmt cannot be null');
        }
        $this->container['date_on_sale_from_gmt'] = $date_on_sale_from_gmt;

        return $this;
    }

    /**
     * Gets date_on_sale_to
     *
     * @return \DateTime|null
     */
    public function getDateOnSaleTo()
    {
        return $this->container['date_on_sale_to'];
    }

    /**
     * Sets date_on_sale_to
     *
     * @param \DateTime|null $date_on_sale_to date_on_sale_to
     *
     * @return self
     */
    public function setDateOnSaleTo($date_on_sale_to)
    {
        if (is_null($date_on_sale_to)) {
            throw new \InvalidArgumentException('non-nullable date_on_sale_to cannot be null');
        }
        $this->container['date_on_sale_to'] = $date_on_sale_to;

        return $this;
    }

    /**
     * Gets date_on_sale_to_gmt
     *
     * @return \DateTime|null
     */
    public function getDateOnSaleToGmt()
    {
        return $this->container['date_on_sale_to_gmt'];
    }

    /**
     * Sets date_on_sale_to_gmt
     *
     * @param \DateTime|null $date_on_sale_to_gmt date_on_sale_to_gmt
     *
     * @return self
     */
    public function setDateOnSaleToGmt($date_on_sale_to_gmt)
    {
        if (is_null($date_on_sale_to_gmt)) {
            throw new \InvalidArgumentException('non-nullable date_on_sale_to_gmt cannot be null');
        }
        $this->container['date_on_sale_to_gmt'] = $date_on_sale_to_gmt;

        return $this;
    }

    /**
     * Gets price_html
     *
     * @return string|null
     */
    public function getPriceHtml()
    {
        return $this->container['price_html'];
    }

    /**
     * Sets price_html
     *
     * @param string|null $price_html price_html
     *
     * @return self
     */
    public function setPriceHtml($price_html)
    {
        if (is_null($price_html)) {
            throw new \InvalidArgumentException('non-nullable price_html cannot be null');
        }
        $this->container['price_html'] = $price_html;

        return $this;
    }

    /**
     * Gets on_sale
     *
     * @return bool|null
     */
    public function getOnSale()
    {
        return $this->container['on_sale'];
    }

    /**
     * Sets on_sale
     *
     * @param bool|null $on_sale on_sale
     *
     * @return self
     */
    public function setOnSale($on_sale)
    {
        if (is_null($on_sale)) {
            throw new \InvalidArgumentException('non-nullable on_sale cannot be null');
        }
        $this->container['on_sale'] = $on_sale;

        return $this;
    }

    /**
     * Gets purchasable
     *
     * @return bool|null
     */
    public function getPurchasable()
    {
        return $this->container['purchasable'];
    }

    /**
     * Sets purchasable
     *
     * @param bool|null $purchasable purchasable
     *
     * @return self
     */
    public function setPurchasable($purchasable)
    {
        if (is_null($purchasable)) {
            throw new \InvalidArgumentException('non-nullable purchasable cannot be null');
        }
        $this->container['purchasable'] = $purchasable;

        return $this;
    }

    /**
     * Gets total_sales
     *
     * @return int|null
     */
    public function getTotalSales()
    {
        return $this->container['total_sales'];
    }

    /**
     * Sets total_sales
     *
     * @param int|null $total_sales total_sales
     *
     * @return self
     */
    public function setTotalSales($total_sales)
    {
        if (is_null($total_sales)) {
            throw new \InvalidArgumentException('non-nullable total_sales cannot be null');
        }
        $this->container['total_sales'] = $total_sales;

        return $this;
    }

    /**
     * Gets virtual
     *
     * @return bool|null
     */
    public function getVirtual()
    {
        return $this->container['virtual'];
    }

    /**
     * Sets virtual
     *
     * @param bool|null $virtual virtual
     *
     * @return self
     */
    public function setVirtual($virtual)
    {
        if (is_null($virtual)) {
            throw new \InvalidArgumentException('non-nullable virtual cannot be null');
        }
        $this->container['virtual'] = $virtual;

        return $this;
    }

    /**
     * Gets downloadable
     *
     * @return bool|null
     */
    public function getDownloadable()
    {
        return $this->container['downloadable'];
    }

    /**
     * Sets downloadable
     *
     * @param bool|null $downloadable downloadable
     *
     * @return self
     */
    public function setDownloadable($downloadable)
    {
        if (is_null($downloadable)) {
            throw new \InvalidArgumentException('non-nullable downloadable cannot be null');
        }
        $this->container['downloadable'] = $downloadable;

        return $this;
    }

    /**
     * Gets downloads
     *
     * @return \Woocommerce\Model\Download[]|null
     */
    public function getDownloads()
    {
        return $this->container['downloads'];
    }

    /**
     * Sets downloads
     *
     * @param \Woocommerce\Model\Download[]|null $downloads downloads
     *
     * @return self
     */
    public function setDownloads($downloads)
    {
        if (is_null($downloads)) {
            throw new \InvalidArgumentException('non-nullable downloads cannot be null');
        }
        $this->container['downloads'] = $downloads;

        return $this;
    }

    /**
     * Gets download_limit
     *
     * @return int|null
     */
    public function getDownloadLimit()
    {
        return $this->container['download_limit'];
    }

    /**
     * Sets download_limit
     *
     * @param int|null $download_limit download_limit
     *
     * @return self
     */
    public function setDownloadLimit($download_limit)
    {
        if (is_null($download_limit)) {
            throw new \InvalidArgumentException('non-nullable download_limit cannot be null');
        }
        $this->container['download_limit'] = $download_limit;

        return $this;
    }

    /**
     * Gets download_expiry
     *
     * @return int|null
     */
    public function getDownloadExpiry()
    {
        return $this->container['download_expiry'];
    }

    /**
     * Sets download_expiry
     *
     * @param int|null $download_expiry download_expiry
     *
     * @return self
     */
    public function setDownloadExpiry($download_expiry)
    {
        if (is_null($download_expiry)) {
            throw new \InvalidArgumentException('non-nullable download_expiry cannot be null');
        }
        $this->container['download_expiry'] = $download_expiry;

        return $this;
    }

    /**
     * Gets external_url
     *
     * @return string|null
     */
    public function getExternalUrl()
    {
        return $this->container['external_url'];
    }

    /**
     * Sets external_url
     *
     * @param string|null $external_url external_url
     *
     * @return self
     */
    public function setExternalUrl($external_url)
    {
        if (is_null($external_url)) {
            throw new \InvalidArgumentException('non-nullable external_url cannot be null');
        }
        $this->container['external_url'] = $external_url;

        return $this;
    }

    /**
     * Gets button_text
     *
     * @return string|null
     */
    public function getButtonText()
    {
        return $this->container['button_text'];
    }

    /**
     * Sets button_text
     *
     * @param string|null $button_text button_text
     *
     * @return self
     */
    public function setButtonText($button_text)
    {
        if (is_null($button_text)) {
            throw new \InvalidArgumentException('non-nullable button_text cannot be null');
        }
        $this->container['button_text'] = $button_text;

        return $this;
    }

    /**
     * Gets tax_status
     *
     * @return string|null
     */
    public function getTaxStatus()
    {
        return $this->container['tax_status'];
    }

    /**
     * Sets tax_status
     *
     * @param string|null $tax_status tax_status
     *
     * @return self
     */
    public function setTaxStatus($tax_status)
    {
        if (is_null($tax_status)) {
            throw new \InvalidArgumentException('non-nullable tax_status cannot be null');
        }
        $this->container['tax_status'] = $tax_status;

        return $this;
    }

    /**
     * Gets tax_class
     *
     * @return string|null
     */
    public function getTaxClass()
    {
        return $this->container['tax_class'];
    }

    /**
     * Sets tax_class
     *
     * @param string|null $tax_class tax_class
     *
     * @return self
     */
    public function setTaxClass($tax_class)
    {
        if (is_null($tax_class)) {
            throw new \InvalidArgumentException('non-nullable tax_class cannot be null');
        }
        $this->container['tax_class'] = $tax_class;

        return $this;
    }

    /**
     * Gets manage_stock
     *
     * @return bool|null
     */
    public function getManageStock()
    {
        return $this->container['manage_stock'];
    }

    /**
     * Sets manage_stock
     *
     * @param bool|null $manage_stock manage_stock
     *
     * @return self
     */
    public function setManageStock($manage_stock)
    {
        if (is_null($manage_stock)) {
            throw new \InvalidArgumentException('non-nullable manage_stock cannot be null');
        }
        $this->container['manage_stock'] = $manage_stock;

        return $this;
    }

    /**
     * Gets stock_quantity
     *
     * @return int|null
     */
    public function getStockQuantity()
    {
        return $this->container['stock_quantity'];
    }

    /**
     * Sets stock_quantity
     *
     * @param int|null $stock_quantity stock_quantity
     *
     * @return self
     */
    public function setStockQuantity($stock_quantity)
    {
        if (is_null($stock_quantity)) {
            throw new \InvalidArgumentException('non-nullable stock_quantity cannot be null');
        }
        $this->container['stock_quantity'] = $stock_quantity;

        return $this;
    }

    /**
     * Gets stock_status
     *
     * @return string|null
     */
    public function getStockStatus()
    {
        return $this->container['stock_status'];
    }

    /**
     * Sets stock_status
     *
     * @param string|null $stock_status stock_status
     *
     * @return self
     */
    public function setStockStatus($stock_status)
    {
        if (is_null($stock_status)) {
            throw new \InvalidArgumentException('non-nullable stock_status cannot be null');
        }
        $this->container['stock_status'] = $stock_status;

        return $this;
    }

    /**
     * Gets backorders
     *
     * @return string|null
     */
    public function getBackorders()
    {
        return $this->container['backorders'];
    }

    /**
     * Sets backorders
     *
     * @param string|null $backorders backorders
     *
     * @return self
     */
    public function setBackorders($backorders)
    {
        if (is_null($backorders)) {
            throw new \InvalidArgumentException('non-nullable backorders cannot be null');
        }
        $this->container['backorders'] = $backorders;

        return $this;
    }

    /**
     * Gets backorders_allowed
     *
     * @return bool|null
     */
    public function getBackordersAllowed()
    {
        return $this->container['backorders_allowed'];
    }

    /**
     * Sets backorders_allowed
     *
     * @param bool|null $backorders_allowed backorders_allowed
     *
     * @return self
     */
    public function setBackordersAllowed($backorders_allowed)
    {
        if (is_null($backorders_allowed)) {
            throw new \InvalidArgumentException('non-nullable backorders_allowed cannot be null');
        }
        $this->container['backorders_allowed'] = $backorders_allowed;

        return $this;
    }

    /**
     * Gets backordered
     *
     * @return bool|null
     */
    public function getBackordered()
    {
        return $this->container['backordered'];
    }

    /**
     * Sets backordered
     *
     * @param bool|null $backordered backordered
     *
     * @return self
     */
    public function setBackordered($backordered)
    {
        if (is_null($backordered)) {
            throw new \InvalidArgumentException('non-nullable backordered cannot be null');
        }
        $this->container['backordered'] = $backordered;

        return $this;
    }

    /**
     * Gets sold_individually
     *
     * @return bool|null
     */
    public function getSoldIndividually()
    {
        return $this->container['sold_individually'];
    }

    /**
     * Sets sold_individually
     *
     * @param bool|null $sold_individually sold_individually
     *
     * @return self
     */
    public function setSoldIndividually($sold_individually)
    {
        if (is_null($sold_individually)) {
            throw new \InvalidArgumentException('non-nullable sold_individually cannot be null');
        }
        $this->container['sold_individually'] = $sold_individually;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return string|null
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param string|null $weight weight
     *
     * @return self
     */
    public function setWeight($weight)
    {
        if (is_null($weight)) {
            throw new \InvalidArgumentException('non-nullable weight cannot be null');
        }
        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets dimensions
     *
     * @return \Woocommerce\Model\Dimension|null
     */
    public function getDimensions()
    {
        return $this->container['dimensions'];
    }

    /**
     * Sets dimensions
     *
     * @param \Woocommerce\Model\Dimension|null $dimensions dimensions
     *
     * @return self
     */
    public function setDimensions($dimensions)
    {
        if (is_null($dimensions)) {
            throw new \InvalidArgumentException('non-nullable dimensions cannot be null');
        }
        $this->container['dimensions'] = $dimensions;

        return $this;
    }

    /**
     * Gets shipping_required
     *
     * @return bool|null
     */
    public function getShippingRequired()
    {
        return $this->container['shipping_required'];
    }

    /**
     * Sets shipping_required
     *
     * @param bool|null $shipping_required shipping_required
     *
     * @return self
     */
    public function setShippingRequired($shipping_required)
    {
        if (is_null($shipping_required)) {
            throw new \InvalidArgumentException('non-nullable shipping_required cannot be null');
        }
        $this->container['shipping_required'] = $shipping_required;

        return $this;
    }

    /**
     * Gets shipping_taxable
     *
     * @return bool|null
     */
    public function getShippingTaxable()
    {
        return $this->container['shipping_taxable'];
    }

    /**
     * Sets shipping_taxable
     *
     * @param bool|null $shipping_taxable shipping_taxable
     *
     * @return self
     */
    public function setShippingTaxable($shipping_taxable)
    {
        if (is_null($shipping_taxable)) {
            throw new \InvalidArgumentException('non-nullable shipping_taxable cannot be null');
        }
        $this->container['shipping_taxable'] = $shipping_taxable;

        return $this;
    }

    /**
     * Gets shipping_class
     *
     * @return string|null
     */
    public function getShippingClass()
    {
        return $this->container['shipping_class'];
    }

    /**
     * Sets shipping_class
     *
     * @param string|null $shipping_class shipping_class
     *
     * @return self
     */
    public function setShippingClass($shipping_class)
    {
        if (is_null($shipping_class)) {
            throw new \InvalidArgumentException('non-nullable shipping_class cannot be null');
        }
        $this->container['shipping_class'] = $shipping_class;

        return $this;
    }

    /**
     * Gets shipping_class_id
     *
     * @return int|null
     */
    public function getShippingClassId()
    {
        return $this->container['shipping_class_id'];
    }

    /**
     * Sets shipping_class_id
     *
     * @param int|null $shipping_class_id shipping_class_id
     *
     * @return self
     */
    public function setShippingClassId($shipping_class_id)
    {
        if (is_null($shipping_class_id)) {
            throw new \InvalidArgumentException('non-nullable shipping_class_id cannot be null');
        }
        $this->container['shipping_class_id'] = $shipping_class_id;

        return $this;
    }

    /**
     * Gets reviews_allowed
     *
     * @return bool|null
     */
    public function getReviewsAllowed()
    {
        return $this->container['reviews_allowed'];
    }

    /**
     * Sets reviews_allowed
     *
     * @param bool|null $reviews_allowed reviews_allowed
     *
     * @return self
     */
    public function setReviewsAllowed($reviews_allowed)
    {
        if (is_null($reviews_allowed)) {
            throw new \InvalidArgumentException('non-nullable reviews_allowed cannot be null');
        }
        $this->container['reviews_allowed'] = $reviews_allowed;

        return $this;
    }

    /**
     * Gets average_rating
     *
     * @return string|null
     */
    public function getAverageRating()
    {
        return $this->container['average_rating'];
    }

    /**
     * Sets average_rating
     *
     * @param string|null $average_rating average_rating
     *
     * @return self
     */
    public function setAverageRating($average_rating)
    {
        if (is_null($average_rating)) {
            throw new \InvalidArgumentException('non-nullable average_rating cannot be null');
        }
        $this->container['average_rating'] = $average_rating;

        return $this;
    }

    /**
     * Gets rating_count
     *
     * @return int|null
     */
    public function getRatingCount()
    {
        return $this->container['rating_count'];
    }

    /**
     * Sets rating_count
     *
     * @param int|null $rating_count rating_count
     *
     * @return self
     */
    public function setRatingCount($rating_count)
    {
        if (is_null($rating_count)) {
            throw new \InvalidArgumentException('non-nullable rating_count cannot be null');
        }
        $this->container['rating_count'] = $rating_count;

        return $this;
    }

    /**
     * Gets related_ids
     *
     * @return int[]|null
     */
    public function getRelatedIds()
    {
        return $this->container['related_ids'];
    }

    /**
     * Sets related_ids
     *
     * @param int[]|null $related_ids related_ids
     *
     * @return self
     */
    public function setRelatedIds($related_ids)
    {
        if (is_null($related_ids)) {
            throw new \InvalidArgumentException('non-nullable related_ids cannot be null');
        }
        $this->container['related_ids'] = $related_ids;

        return $this;
    }

    /**
     * Gets upsell_ids
     *
     * @return int[]|null
     */
    public function getUpsellIds()
    {
        return $this->container['upsell_ids'];
    }

    /**
     * Sets upsell_ids
     *
     * @param int[]|null $upsell_ids upsell_ids
     *
     * @return self
     */
    public function setUpsellIds($upsell_ids)
    {
        if (is_null($upsell_ids)) {
            throw new \InvalidArgumentException('non-nullable upsell_ids cannot be null');
        }
        $this->container['upsell_ids'] = $upsell_ids;

        return $this;
    }

    /**
     * Gets cross_sell_ids
     *
     * @return int[]|null
     */
    public function getCrossSellIds()
    {
        return $this->container['cross_sell_ids'];
    }

    /**
     * Sets cross_sell_ids
     *
     * @param int[]|null $cross_sell_ids cross_sell_ids
     *
     * @return self
     */
    public function setCrossSellIds($cross_sell_ids)
    {
        if (is_null($cross_sell_ids)) {
            throw new \InvalidArgumentException('non-nullable cross_sell_ids cannot be null');
        }
        $this->container['cross_sell_ids'] = $cross_sell_ids;

        return $this;
    }

    /**
     * Gets parent_id
     *
     * @return int|null
     */
    public function getParentId()
    {
        return $this->container['parent_id'];
    }

    /**
     * Sets parent_id
     *
     * @param int|null $parent_id parent_id
     *
     * @return self
     */
    public function setParentId($parent_id)
    {
        if (is_null($parent_id)) {
            throw new \InvalidArgumentException('non-nullable parent_id cannot be null');
        }
        $this->container['parent_id'] = $parent_id;

        return $this;
    }

    /**
     * Gets purchase_note
     *
     * @return string|null
     */
    public function getPurchaseNote()
    {
        return $this->container['purchase_note'];
    }

    /**
     * Sets purchase_note
     *
     * @param string|null $purchase_note purchase_note
     *
     * @return self
     */
    public function setPurchaseNote($purchase_note)
    {
        if (is_null($purchase_note)) {
            throw new \InvalidArgumentException('non-nullable purchase_note cannot be null');
        }
        $this->container['purchase_note'] = $purchase_note;

        return $this;
    }

    /**
     * Gets categories
     *
     * @return \Woocommerce\Model\Category[]|null
     */
    public function getCategories()
    {
        return $this->container['categories'];
    }

    /**
     * Sets categories
     *
     * @param \Woocommerce\Model\Category[]|null $categories categories
     *
     * @return self
     */
    public function setCategories($categories)
    {
        if (is_null($categories)) {
            throw new \InvalidArgumentException('non-nullable categories cannot be null');
        }
        $this->container['categories'] = $categories;

        return $this;
    }

    /**
     * Gets tags
     *
     * @return \Woocommerce\Model\Tag[]|null
     */
    public function getTags()
    {
        return $this->container['tags'];
    }

    /**
     * Sets tags
     *
     * @param \Woocommerce\Model\Tag[]|null $tags tags
     *
     * @return self
     */
    public function setTags($tags)
    {
        if (is_null($tags)) {
            throw new \InvalidArgumentException('non-nullable tags cannot be null');
        }
        $this->container['tags'] = $tags;

        return $this;
    }

    /**
     * Gets images
     *
     * @return \Woocommerce\Model\Image[]|null
     */
    public function getImages()
    {
        return $this->container['images'];
    }

    /**
     * Sets images
     *
     * @param \Woocommerce\Model\Image[]|null $images images
     *
     * @return self
     */
    public function setImages($images)
    {
        if (is_null($images)) {
            throw new \InvalidArgumentException('non-nullable images cannot be null');
        }
        $this->container['images'] = $images;

        return $this;
    }

    /**
     * Gets attributes
     *
     * @return \Woocommerce\Model\Attribute[]|null
     */
    public function getAttributes()
    {
        return $this->container['attributes'];
    }

    /**
     * Sets attributes
     *
     * @param \Woocommerce\Model\Attribute[]|null $attributes attributes
     *
     * @return self
     */
    public function setAttributes($attributes)
    {
        if (is_null($attributes)) {
            throw new \InvalidArgumentException('non-nullable attributes cannot be null');
        }
        $this->container['attributes'] = $attributes;

        return $this;
    }

    /**
     * Gets default_attributes
     *
     * @return \Woocommerce\Model\DefaultAttribute[]|null
     */
    public function getDefaultAttributes()
    {
        return $this->container['default_attributes'];
    }

    /**
     * Sets default_attributes
     *
     * @param \Woocommerce\Model\DefaultAttribute[]|null $default_attributes default_attributes
     *
     * @return self
     */
    public function setDefaultAttributes($default_attributes)
    {
        if (is_null($default_attributes)) {
            throw new \InvalidArgumentException('non-nullable default_attributes cannot be null');
        }
        $this->container['default_attributes'] = $default_attributes;

        return $this;
    }

    /**
     * Gets variations
     *
     * @return int[]|null
     */
    public function getVariations()
    {
        return $this->container['variations'];
    }

    /**
     * Sets variations
     *
     * @param int[]|null $variations variations
     *
     * @return self
     */
    public function setVariations($variations)
    {
        if (is_null($variations)) {
            throw new \InvalidArgumentException('non-nullable variations cannot be null');
        }
        $this->container['variations'] = $variations;

        return $this;
    }

    /**
     * Gets grouped_products
     *
     * @return object[]|null
     */
    public function getGroupedProducts()
    {
        return $this->container['grouped_products'];
    }

    /**
     * Sets grouped_products
     *
     * @param object[]|null $grouped_products grouped_products
     *
     * @return self
     */
    public function setGroupedProducts($grouped_products)
    {
        if (is_null($grouped_products)) {
            throw new \InvalidArgumentException('non-nullable grouped_products cannot be null');
        }
        $this->container['grouped_products'] = $grouped_products;

        return $this;
    }

    /**
     * Gets menu_order
     *
     * @return int|null
     */
    public function getMenuOrder()
    {
        return $this->container['menu_order'];
    }

    /**
     * Sets menu_order
     *
     * @param int|null $menu_order menu_order
     *
     * @return self
     */
    public function setMenuOrder($menu_order)
    {
        if (is_null($menu_order)) {
            throw new \InvalidArgumentException('non-nullable menu_order cannot be null');
        }
        $this->container['menu_order'] = $menu_order;

        return $this;
    }

    /**
     * Gets meta_data
     *
     * @return \Woocommerce\Model\Metadata[]|null
     */
    public function getMetaData()
    {
        return $this->container['meta_data'];
    }

    /**
     * Sets meta_data
     *
     * @param \Woocommerce\Model\Metadata[]|null $meta_data meta_data
     *
     * @return self
     */
    public function setMetaData($meta_data)
    {
        if (is_null($meta_data)) {
            throw new \InvalidArgumentException('non-nullable meta_data cannot be null');
        }
        $this->container['meta_data'] = $meta_data;

        return $this;
    }

    /**
     * Gets _links
     *
     * @return \Woocommerce\Model\Links|null
     */
    public function getLinks()
    {
        return $this->container['_links'];
    }

    /**
     * Sets _links
     *
     * @param \Woocommerce\Model\Links|null $_links _links
     *
     * @return self
     */
    public function setLinks($_links)
    {
        if (is_null($_links)) {
            throw new \InvalidArgumentException('non-nullable _links cannot be null');
        }
        $this->container['_links'] = $_links;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


