<?php
/**
 * Page
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Woocommerce
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Woocommerce API
 *
 * Woocommerce v3.0 API See https://woocommerce.github.io/woocommerce-rest-api-docs/#introduction
 *
 * The version of the OpenAPI document: 3.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Woocommerce\Model;

use \ArrayAccess;
use \Woocommerce\ObjectSerializer;

/**
 * Page Class Doc Comment
 *
 * @category Class
 * @package  Woocommerce
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Page implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Page';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'page_name' => 'string',
        'page_id' => 'string',
        'page_set' => 'bool',
        'page_exists' => 'bool',
        'page_visible' => 'bool',
        'shortcode' => 'string',
        'shortcode_required' => 'bool',
        'shortcode_present' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'page_name' => null,
        'page_id' => null,
        'page_set' => null,
        'page_exists' => null,
        'page_visible' => null,
        'shortcode' => null,
        'shortcode_required' => null,
        'shortcode_present' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'page_name' => false,
        'page_id' => false,
        'page_set' => false,
        'page_exists' => false,
        'page_visible' => false,
        'shortcode' => false,
        'shortcode_required' => false,
        'shortcode_present' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'page_name' => 'page_name',
        'page_id' => 'page_id',
        'page_set' => 'page_set',
        'page_exists' => 'page_exists',
        'page_visible' => 'page_visible',
        'shortcode' => 'shortcode',
        'shortcode_required' => 'shortcode_required',
        'shortcode_present' => 'shortcode_present'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'page_name' => 'setPageName',
        'page_id' => 'setPageId',
        'page_set' => 'setPageSet',
        'page_exists' => 'setPageExists',
        'page_visible' => 'setPageVisible',
        'shortcode' => 'setShortcode',
        'shortcode_required' => 'setShortcodeRequired',
        'shortcode_present' => 'setShortcodePresent'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'page_name' => 'getPageName',
        'page_id' => 'getPageId',
        'page_set' => 'getPageSet',
        'page_exists' => 'getPageExists',
        'page_visible' => 'getPageVisible',
        'shortcode' => 'getShortcode',
        'shortcode_required' => 'getShortcodeRequired',
        'shortcode_present' => 'getShortcodePresent'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('page_name', $data ?? [], null);
        $this->setIfExists('page_id', $data ?? [], null);
        $this->setIfExists('page_set', $data ?? [], null);
        $this->setIfExists('page_exists', $data ?? [], null);
        $this->setIfExists('page_visible', $data ?? [], null);
        $this->setIfExists('shortcode', $data ?? [], null);
        $this->setIfExists('shortcode_required', $data ?? [], null);
        $this->setIfExists('shortcode_present', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets page_name
     *
     * @return string|null
     */
    public function getPageName()
    {
        return $this->container['page_name'];
    }

    /**
     * Sets page_name
     *
     * @param string|null $page_name page_name
     *
     * @return self
     */
    public function setPageName($page_name)
    {
        if (is_null($page_name)) {
            throw new \InvalidArgumentException('non-nullable page_name cannot be null');
        }
        $this->container['page_name'] = $page_name;

        return $this;
    }

    /**
     * Gets page_id
     *
     * @return string|null
     */
    public function getPageId()
    {
        return $this->container['page_id'];
    }

    /**
     * Sets page_id
     *
     * @param string|null $page_id page_id
     *
     * @return self
     */
    public function setPageId($page_id)
    {
        if (is_null($page_id)) {
            throw new \InvalidArgumentException('non-nullable page_id cannot be null');
        }
        $this->container['page_id'] = $page_id;

        return $this;
    }

    /**
     * Gets page_set
     *
     * @return bool|null
     */
    public function getPageSet()
    {
        return $this->container['page_set'];
    }

    /**
     * Sets page_set
     *
     * @param bool|null $page_set page_set
     *
     * @return self
     */
    public function setPageSet($page_set)
    {
        if (is_null($page_set)) {
            throw new \InvalidArgumentException('non-nullable page_set cannot be null');
        }
        $this->container['page_set'] = $page_set;

        return $this;
    }

    /**
     * Gets page_exists
     *
     * @return bool|null
     */
    public function getPageExists()
    {
        return $this->container['page_exists'];
    }

    /**
     * Sets page_exists
     *
     * @param bool|null $page_exists page_exists
     *
     * @return self
     */
    public function setPageExists($page_exists)
    {
        if (is_null($page_exists)) {
            throw new \InvalidArgumentException('non-nullable page_exists cannot be null');
        }
        $this->container['page_exists'] = $page_exists;

        return $this;
    }

    /**
     * Gets page_visible
     *
     * @return bool|null
     */
    public function getPageVisible()
    {
        return $this->container['page_visible'];
    }

    /**
     * Sets page_visible
     *
     * @param bool|null $page_visible page_visible
     *
     * @return self
     */
    public function setPageVisible($page_visible)
    {
        if (is_null($page_visible)) {
            throw new \InvalidArgumentException('non-nullable page_visible cannot be null');
        }
        $this->container['page_visible'] = $page_visible;

        return $this;
    }

    /**
     * Gets shortcode
     *
     * @return string|null
     */
    public function getShortcode()
    {
        return $this->container['shortcode'];
    }

    /**
     * Sets shortcode
     *
     * @param string|null $shortcode shortcode
     *
     * @return self
     */
    public function setShortcode($shortcode)
    {
        if (is_null($shortcode)) {
            throw new \InvalidArgumentException('non-nullable shortcode cannot be null');
        }
        $this->container['shortcode'] = $shortcode;

        return $this;
    }

    /**
     * Gets shortcode_required
     *
     * @return bool|null
     */
    public function getShortcodeRequired()
    {
        return $this->container['shortcode_required'];
    }

    /**
     * Sets shortcode_required
     *
     * @param bool|null $shortcode_required shortcode_required
     *
     * @return self
     */
    public function setShortcodeRequired($shortcode_required)
    {
        if (is_null($shortcode_required)) {
            throw new \InvalidArgumentException('non-nullable shortcode_required cannot be null');
        }
        $this->container['shortcode_required'] = $shortcode_required;

        return $this;
    }

    /**
     * Gets shortcode_present
     *
     * @return bool|null
     */
    public function getShortcodePresent()
    {
        return $this->container['shortcode_present'];
    }

    /**
     * Sets shortcode_present
     *
     * @param bool|null $shortcode_present shortcode_present
     *
     * @return self
     */
    public function setShortcodePresent($shortcode_present)
    {
        if (is_null($shortcode_present)) {
            throw new \InvalidArgumentException('non-nullable shortcode_present cannot be null');
        }
        $this->container['shortcode_present'] = $shortcode_present;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


