<?php
/**
 * Order
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Woocommerce
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Woocommerce API
 *
 * Woocommerce v3.0 API See https://woocommerce.github.io/woocommerce-rest-api-docs/#introduction
 *
 * The version of the OpenAPI document: 3.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Woocommerce\Model;

use \ArrayAccess;
use \Woocommerce\ObjectSerializer;

/**
 * Order Class Doc Comment
 *
 * @category Class
 * @package  Woocommerce
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Order implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Order';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'parent_id' => 'int',
        'number' => 'string',
        'order_key' => 'string',
        'created_via' => 'string',
        'version' => 'string',
        'status' => 'string',
        'currency' => 'string',
        'date_created' => '\DateTime',
        'date_created_gmt' => '\DateTime',
        'date_modified' => '\DateTime',
        'date_modified_gmt' => '\DateTime',
        'discount_total' => 'string',
        'discount_tax' => 'string',
        'shipping_total' => 'string',
        'shipping_tax' => 'string',
        'cart_tax' => 'string',
        'total' => 'string',
        'total_tax' => 'string',
        'prices_include_tax' => 'bool',
        'customer_id' => 'int',
        'customer_ip_address' => 'string',
        'customer_user_agent' => 'string',
        'customer_note' => 'string',
        'billing' => '\Woocommerce\Model\Address',
        'shipping' => '\Woocommerce\Model\Address',
        'payment_method' => 'string',
        'payment_method_title' => 'string',
        'transaction_id' => 'string',
        'date_paid' => '\DateTime',
        'date_paid_gmt' => '\DateTime',
        'date_completed' => '\DateTime',
        'date_completed_gmt' => '\DateTime',
        'cart_hash' => 'string',
        'meta_data' => '\Woocommerce\Model\Metadata[]',
        'line_items' => '\Woocommerce\Model\LineItem[]',
        'tax_lines' => '\Woocommerce\Model\TaxLine[]',
        'shipping_lines' => '\Woocommerce\Model\ShippingLine[]',
        'fee_lines' => '\Woocommerce\Model\FeeLine[]',
        'coupon_lines' => '\Woocommerce\Model\CouponLine[]',
        'refunds' => '\Woocommerce\Model\RefundLine[]',
        '_links' => '\Woocommerce\Model\Links'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'parent_id' => null,
        'number' => null,
        'order_key' => null,
        'created_via' => null,
        'version' => null,
        'status' => null,
        'currency' => null,
        'date_created' => 'date-time',
        'date_created_gmt' => 'date-time',
        'date_modified' => 'date-time',
        'date_modified_gmt' => 'date-time',
        'discount_total' => null,
        'discount_tax' => null,
        'shipping_total' => null,
        'shipping_tax' => null,
        'cart_tax' => null,
        'total' => null,
        'total_tax' => null,
        'prices_include_tax' => null,
        'customer_id' => null,
        'customer_ip_address' => null,
        'customer_user_agent' => null,
        'customer_note' => null,
        'billing' => null,
        'shipping' => null,
        'payment_method' => null,
        'payment_method_title' => null,
        'transaction_id' => null,
        'date_paid' => 'date-time',
        'date_paid_gmt' => 'date-time',
        'date_completed' => 'date-time',
        'date_completed_gmt' => 'date-time',
        'cart_hash' => null,
        'meta_data' => null,
        'line_items' => null,
        'tax_lines' => null,
        'shipping_lines' => null,
        'fee_lines' => null,
        'coupon_lines' => null,
        'refunds' => null,
        '_links' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'parent_id' => false,
        'number' => false,
        'order_key' => false,
        'created_via' => false,
        'version' => false,
        'status' => false,
        'currency' => false,
        'date_created' => false,
        'date_created_gmt' => false,
        'date_modified' => false,
        'date_modified_gmt' => false,
        'discount_total' => false,
        'discount_tax' => false,
        'shipping_total' => false,
        'shipping_tax' => false,
        'cart_tax' => false,
        'total' => false,
        'total_tax' => false,
        'prices_include_tax' => false,
        'customer_id' => false,
        'customer_ip_address' => false,
        'customer_user_agent' => false,
        'customer_note' => false,
        'billing' => false,
        'shipping' => false,
        'payment_method' => false,
        'payment_method_title' => false,
        'transaction_id' => false,
        'date_paid' => false,
        'date_paid_gmt' => false,
        'date_completed' => false,
        'date_completed_gmt' => false,
        'cart_hash' => false,
        'meta_data' => false,
        'line_items' => false,
        'tax_lines' => false,
        'shipping_lines' => false,
        'fee_lines' => false,
        'coupon_lines' => false,
        'refunds' => false,
        '_links' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'parent_id' => 'parent_id',
        'number' => 'number',
        'order_key' => 'order_key',
        'created_via' => 'created_via',
        'version' => 'version',
        'status' => 'status',
        'currency' => 'currency',
        'date_created' => 'date_created',
        'date_created_gmt' => 'date_created_gmt',
        'date_modified' => 'date_modified',
        'date_modified_gmt' => 'date_modified_gmt',
        'discount_total' => 'discount_total',
        'discount_tax' => 'discount_tax',
        'shipping_total' => 'shipping_total',
        'shipping_tax' => 'shipping_tax',
        'cart_tax' => 'cart_tax',
        'total' => 'total',
        'total_tax' => 'total_tax',
        'prices_include_tax' => 'prices_include_tax',
        'customer_id' => 'customer_id',
        'customer_ip_address' => 'customer_ip_address',
        'customer_user_agent' => 'customer_user_agent',
        'customer_note' => 'customer_note',
        'billing' => 'billing',
        'shipping' => 'shipping',
        'payment_method' => 'payment_method',
        'payment_method_title' => 'payment_method_title',
        'transaction_id' => 'transaction_id',
        'date_paid' => 'date_paid',
        'date_paid_gmt' => 'date_paid_gmt',
        'date_completed' => 'date_completed',
        'date_completed_gmt' => 'date_completed_gmt',
        'cart_hash' => 'cart_hash',
        'meta_data' => 'meta_data',
        'line_items' => 'line_items',
        'tax_lines' => 'tax_lines',
        'shipping_lines' => 'shipping_lines',
        'fee_lines' => 'fee_lines',
        'coupon_lines' => 'coupon_lines',
        'refunds' => 'refunds',
        '_links' => '_links'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'parent_id' => 'setParentId',
        'number' => 'setNumber',
        'order_key' => 'setOrderKey',
        'created_via' => 'setCreatedVia',
        'version' => 'setVersion',
        'status' => 'setStatus',
        'currency' => 'setCurrency',
        'date_created' => 'setDateCreated',
        'date_created_gmt' => 'setDateCreatedGmt',
        'date_modified' => 'setDateModified',
        'date_modified_gmt' => 'setDateModifiedGmt',
        'discount_total' => 'setDiscountTotal',
        'discount_tax' => 'setDiscountTax',
        'shipping_total' => 'setShippingTotal',
        'shipping_tax' => 'setShippingTax',
        'cart_tax' => 'setCartTax',
        'total' => 'setTotal',
        'total_tax' => 'setTotalTax',
        'prices_include_tax' => 'setPricesIncludeTax',
        'customer_id' => 'setCustomerId',
        'customer_ip_address' => 'setCustomerIpAddress',
        'customer_user_agent' => 'setCustomerUserAgent',
        'customer_note' => 'setCustomerNote',
        'billing' => 'setBilling',
        'shipping' => 'setShipping',
        'payment_method' => 'setPaymentMethod',
        'payment_method_title' => 'setPaymentMethodTitle',
        'transaction_id' => 'setTransactionId',
        'date_paid' => 'setDatePaid',
        'date_paid_gmt' => 'setDatePaidGmt',
        'date_completed' => 'setDateCompleted',
        'date_completed_gmt' => 'setDateCompletedGmt',
        'cart_hash' => 'setCartHash',
        'meta_data' => 'setMetaData',
        'line_items' => 'setLineItems',
        'tax_lines' => 'setTaxLines',
        'shipping_lines' => 'setShippingLines',
        'fee_lines' => 'setFeeLines',
        'coupon_lines' => 'setCouponLines',
        'refunds' => 'setRefunds',
        '_links' => 'setLinks'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'parent_id' => 'getParentId',
        'number' => 'getNumber',
        'order_key' => 'getOrderKey',
        'created_via' => 'getCreatedVia',
        'version' => 'getVersion',
        'status' => 'getStatus',
        'currency' => 'getCurrency',
        'date_created' => 'getDateCreated',
        'date_created_gmt' => 'getDateCreatedGmt',
        'date_modified' => 'getDateModified',
        'date_modified_gmt' => 'getDateModifiedGmt',
        'discount_total' => 'getDiscountTotal',
        'discount_tax' => 'getDiscountTax',
        'shipping_total' => 'getShippingTotal',
        'shipping_tax' => 'getShippingTax',
        'cart_tax' => 'getCartTax',
        'total' => 'getTotal',
        'total_tax' => 'getTotalTax',
        'prices_include_tax' => 'getPricesIncludeTax',
        'customer_id' => 'getCustomerId',
        'customer_ip_address' => 'getCustomerIpAddress',
        'customer_user_agent' => 'getCustomerUserAgent',
        'customer_note' => 'getCustomerNote',
        'billing' => 'getBilling',
        'shipping' => 'getShipping',
        'payment_method' => 'getPaymentMethod',
        'payment_method_title' => 'getPaymentMethodTitle',
        'transaction_id' => 'getTransactionId',
        'date_paid' => 'getDatePaid',
        'date_paid_gmt' => 'getDatePaidGmt',
        'date_completed' => 'getDateCompleted',
        'date_completed_gmt' => 'getDateCompletedGmt',
        'cart_hash' => 'getCartHash',
        'meta_data' => 'getMetaData',
        'line_items' => 'getLineItems',
        'tax_lines' => 'getTaxLines',
        'shipping_lines' => 'getShippingLines',
        'fee_lines' => 'getFeeLines',
        'coupon_lines' => 'getCouponLines',
        'refunds' => 'getRefunds',
        '_links' => 'getLinks'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('parent_id', $data ?? [], null);
        $this->setIfExists('number', $data ?? [], null);
        $this->setIfExists('order_key', $data ?? [], null);
        $this->setIfExists('created_via', $data ?? [], null);
        $this->setIfExists('version', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('currency', $data ?? [], null);
        $this->setIfExists('date_created', $data ?? [], null);
        $this->setIfExists('date_created_gmt', $data ?? [], null);
        $this->setIfExists('date_modified', $data ?? [], null);
        $this->setIfExists('date_modified_gmt', $data ?? [], null);
        $this->setIfExists('discount_total', $data ?? [], null);
        $this->setIfExists('discount_tax', $data ?? [], null);
        $this->setIfExists('shipping_total', $data ?? [], null);
        $this->setIfExists('shipping_tax', $data ?? [], null);
        $this->setIfExists('cart_tax', $data ?? [], null);
        $this->setIfExists('total', $data ?? [], null);
        $this->setIfExists('total_tax', $data ?? [], null);
        $this->setIfExists('prices_include_tax', $data ?? [], null);
        $this->setIfExists('customer_id', $data ?? [], null);
        $this->setIfExists('customer_ip_address', $data ?? [], null);
        $this->setIfExists('customer_user_agent', $data ?? [], null);
        $this->setIfExists('customer_note', $data ?? [], null);
        $this->setIfExists('billing', $data ?? [], null);
        $this->setIfExists('shipping', $data ?? [], null);
        $this->setIfExists('payment_method', $data ?? [], null);
        $this->setIfExists('payment_method_title', $data ?? [], null);
        $this->setIfExists('transaction_id', $data ?? [], null);
        $this->setIfExists('date_paid', $data ?? [], null);
        $this->setIfExists('date_paid_gmt', $data ?? [], null);
        $this->setIfExists('date_completed', $data ?? [], null);
        $this->setIfExists('date_completed_gmt', $data ?? [], null);
        $this->setIfExists('cart_hash', $data ?? [], null);
        $this->setIfExists('meta_data', $data ?? [], null);
        $this->setIfExists('line_items', $data ?? [], null);
        $this->setIfExists('tax_lines', $data ?? [], null);
        $this->setIfExists('shipping_lines', $data ?? [], null);
        $this->setIfExists('fee_lines', $data ?? [], null);
        $this->setIfExists('coupon_lines', $data ?? [], null);
        $this->setIfExists('refunds', $data ?? [], null);
        $this->setIfExists('_links', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets parent_id
     *
     * @return int|null
     */
    public function getParentId()
    {
        return $this->container['parent_id'];
    }

    /**
     * Sets parent_id
     *
     * @param int|null $parent_id parent_id
     *
     * @return self
     */
    public function setParentId($parent_id)
    {
        if (is_null($parent_id)) {
            throw new \InvalidArgumentException('non-nullable parent_id cannot be null');
        }
        $this->container['parent_id'] = $parent_id;

        return $this;
    }

    /**
     * Gets number
     *
     * @return string|null
     */
    public function getNumber()
    {
        return $this->container['number'];
    }

    /**
     * Sets number
     *
     * @param string|null $number number
     *
     * @return self
     */
    public function setNumber($number)
    {
        if (is_null($number)) {
            throw new \InvalidArgumentException('non-nullable number cannot be null');
        }
        $this->container['number'] = $number;

        return $this;
    }

    /**
     * Gets order_key
     *
     * @return string|null
     */
    public function getOrderKey()
    {
        return $this->container['order_key'];
    }

    /**
     * Sets order_key
     *
     * @param string|null $order_key order_key
     *
     * @return self
     */
    public function setOrderKey($order_key)
    {
        if (is_null($order_key)) {
            throw new \InvalidArgumentException('non-nullable order_key cannot be null');
        }
        $this->container['order_key'] = $order_key;

        return $this;
    }

    /**
     * Gets created_via
     *
     * @return string|null
     */
    public function getCreatedVia()
    {
        return $this->container['created_via'];
    }

    /**
     * Sets created_via
     *
     * @param string|null $created_via created_via
     *
     * @return self
     */
    public function setCreatedVia($created_via)
    {
        if (is_null($created_via)) {
            throw new \InvalidArgumentException('non-nullable created_via cannot be null');
        }
        $this->container['created_via'] = $created_via;

        return $this;
    }

    /**
     * Gets version
     *
     * @return string|null
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     *
     * @param string|null $version version
     *
     * @return self
     */
    public function setVersion($version)
    {
        if (is_null($version)) {
            throw new \InvalidArgumentException('non-nullable version cannot be null');
        }
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param string|null $currency currency
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        if (is_null($currency)) {
            throw new \InvalidArgumentException('non-nullable currency cannot be null');
        }
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets date_created
     *
     * @return \DateTime|null
     */
    public function getDateCreated()
    {
        return $this->container['date_created'];
    }

    /**
     * Sets date_created
     *
     * @param \DateTime|null $date_created date_created
     *
     * @return self
     */
    public function setDateCreated($date_created)
    {
        if (is_null($date_created)) {
            throw new \InvalidArgumentException('non-nullable date_created cannot be null');
        }
        $this->container['date_created'] = $date_created;

        return $this;
    }

    /**
     * Gets date_created_gmt
     *
     * @return \DateTime|null
     */
    public function getDateCreatedGmt()
    {
        return $this->container['date_created_gmt'];
    }

    /**
     * Sets date_created_gmt
     *
     * @param \DateTime|null $date_created_gmt date_created_gmt
     *
     * @return self
     */
    public function setDateCreatedGmt($date_created_gmt)
    {
        if (is_null($date_created_gmt)) {
            throw new \InvalidArgumentException('non-nullable date_created_gmt cannot be null');
        }
        $this->container['date_created_gmt'] = $date_created_gmt;

        return $this;
    }

    /**
     * Gets date_modified
     *
     * @return \DateTime|null
     */
    public function getDateModified()
    {
        return $this->container['date_modified'];
    }

    /**
     * Sets date_modified
     *
     * @param \DateTime|null $date_modified date_modified
     *
     * @return self
     */
    public function setDateModified($date_modified)
    {
        if (is_null($date_modified)) {
            throw new \InvalidArgumentException('non-nullable date_modified cannot be null');
        }
        $this->container['date_modified'] = $date_modified;

        return $this;
    }

    /**
     * Gets date_modified_gmt
     *
     * @return \DateTime|null
     */
    public function getDateModifiedGmt()
    {
        return $this->container['date_modified_gmt'];
    }

    /**
     * Sets date_modified_gmt
     *
     * @param \DateTime|null $date_modified_gmt date_modified_gmt
     *
     * @return self
     */
    public function setDateModifiedGmt($date_modified_gmt)
    {
        if (is_null($date_modified_gmt)) {
            throw new \InvalidArgumentException('non-nullable date_modified_gmt cannot be null');
        }
        $this->container['date_modified_gmt'] = $date_modified_gmt;

        return $this;
    }

    /**
     * Gets discount_total
     *
     * @return string|null
     */
    public function getDiscountTotal()
    {
        return $this->container['discount_total'];
    }

    /**
     * Sets discount_total
     *
     * @param string|null $discount_total discount_total
     *
     * @return self
     */
    public function setDiscountTotal($discount_total)
    {
        if (is_null($discount_total)) {
            throw new \InvalidArgumentException('non-nullable discount_total cannot be null');
        }
        $this->container['discount_total'] = $discount_total;

        return $this;
    }

    /**
     * Gets discount_tax
     *
     * @return string|null
     */
    public function getDiscountTax()
    {
        return $this->container['discount_tax'];
    }

    /**
     * Sets discount_tax
     *
     * @param string|null $discount_tax discount_tax
     *
     * @return self
     */
    public function setDiscountTax($discount_tax)
    {
        if (is_null($discount_tax)) {
            throw new \InvalidArgumentException('non-nullable discount_tax cannot be null');
        }
        $this->container['discount_tax'] = $discount_tax;

        return $this;
    }

    /**
     * Gets shipping_total
     *
     * @return string|null
     */
    public function getShippingTotal()
    {
        return $this->container['shipping_total'];
    }

    /**
     * Sets shipping_total
     *
     * @param string|null $shipping_total shipping_total
     *
     * @return self
     */
    public function setShippingTotal($shipping_total)
    {
        if (is_null($shipping_total)) {
            throw new \InvalidArgumentException('non-nullable shipping_total cannot be null');
        }
        $this->container['shipping_total'] = $shipping_total;

        return $this;
    }

    /**
     * Gets shipping_tax
     *
     * @return string|null
     */
    public function getShippingTax()
    {
        return $this->container['shipping_tax'];
    }

    /**
     * Sets shipping_tax
     *
     * @param string|null $shipping_tax shipping_tax
     *
     * @return self
     */
    public function setShippingTax($shipping_tax)
    {
        if (is_null($shipping_tax)) {
            throw new \InvalidArgumentException('non-nullable shipping_tax cannot be null');
        }
        $this->container['shipping_tax'] = $shipping_tax;

        return $this;
    }

    /**
     * Gets cart_tax
     *
     * @return string|null
     */
    public function getCartTax()
    {
        return $this->container['cart_tax'];
    }

    /**
     * Sets cart_tax
     *
     * @param string|null $cart_tax cart_tax
     *
     * @return self
     */
    public function setCartTax($cart_tax)
    {
        if (is_null($cart_tax)) {
            throw new \InvalidArgumentException('non-nullable cart_tax cannot be null');
        }
        $this->container['cart_tax'] = $cart_tax;

        return $this;
    }

    /**
     * Gets total
     *
     * @return string|null
     */
    public function getTotal()
    {
        return $this->container['total'];
    }

    /**
     * Sets total
     *
     * @param string|null $total total
     *
     * @return self
     */
    public function setTotal($total)
    {
        if (is_null($total)) {
            throw new \InvalidArgumentException('non-nullable total cannot be null');
        }
        $this->container['total'] = $total;

        return $this;
    }

    /**
     * Gets total_tax
     *
     * @return string|null
     */
    public function getTotalTax()
    {
        return $this->container['total_tax'];
    }

    /**
     * Sets total_tax
     *
     * @param string|null $total_tax total_tax
     *
     * @return self
     */
    public function setTotalTax($total_tax)
    {
        if (is_null($total_tax)) {
            throw new \InvalidArgumentException('non-nullable total_tax cannot be null');
        }
        $this->container['total_tax'] = $total_tax;

        return $this;
    }

    /**
     * Gets prices_include_tax
     *
     * @return bool|null
     */
    public function getPricesIncludeTax()
    {
        return $this->container['prices_include_tax'];
    }

    /**
     * Sets prices_include_tax
     *
     * @param bool|null $prices_include_tax prices_include_tax
     *
     * @return self
     */
    public function setPricesIncludeTax($prices_include_tax)
    {
        if (is_null($prices_include_tax)) {
            throw new \InvalidArgumentException('non-nullable prices_include_tax cannot be null');
        }
        $this->container['prices_include_tax'] = $prices_include_tax;

        return $this;
    }

    /**
     * Gets customer_id
     *
     * @return int|null
     */
    public function getCustomerId()
    {
        return $this->container['customer_id'];
    }

    /**
     * Sets customer_id
     *
     * @param int|null $customer_id customer_id
     *
     * @return self
     */
    public function setCustomerId($customer_id)
    {
        if (is_null($customer_id)) {
            throw new \InvalidArgumentException('non-nullable customer_id cannot be null');
        }
        $this->container['customer_id'] = $customer_id;

        return $this;
    }

    /**
     * Gets customer_ip_address
     *
     * @return string|null
     */
    public function getCustomerIpAddress()
    {
        return $this->container['customer_ip_address'];
    }

    /**
     * Sets customer_ip_address
     *
     * @param string|null $customer_ip_address customer_ip_address
     *
     * @return self
     */
    public function setCustomerIpAddress($customer_ip_address)
    {
        if (is_null($customer_ip_address)) {
            throw new \InvalidArgumentException('non-nullable customer_ip_address cannot be null');
        }
        $this->container['customer_ip_address'] = $customer_ip_address;

        return $this;
    }

    /**
     * Gets customer_user_agent
     *
     * @return string|null
     */
    public function getCustomerUserAgent()
    {
        return $this->container['customer_user_agent'];
    }

    /**
     * Sets customer_user_agent
     *
     * @param string|null $customer_user_agent customer_user_agent
     *
     * @return self
     */
    public function setCustomerUserAgent($customer_user_agent)
    {
        if (is_null($customer_user_agent)) {
            throw new \InvalidArgumentException('non-nullable customer_user_agent cannot be null');
        }
        $this->container['customer_user_agent'] = $customer_user_agent;

        return $this;
    }

    /**
     * Gets customer_note
     *
     * @return string|null
     */
    public function getCustomerNote()
    {
        return $this->container['customer_note'];
    }

    /**
     * Sets customer_note
     *
     * @param string|null $customer_note customer_note
     *
     * @return self
     */
    public function setCustomerNote($customer_note)
    {
        if (is_null($customer_note)) {
            throw new \InvalidArgumentException('non-nullable customer_note cannot be null');
        }
        $this->container['customer_note'] = $customer_note;

        return $this;
    }

    /**
     * Gets billing
     *
     * @return \Woocommerce\Model\Address|null
     */
    public function getBilling()
    {
        return $this->container['billing'];
    }

    /**
     * Sets billing
     *
     * @param \Woocommerce\Model\Address|null $billing billing
     *
     * @return self
     */
    public function setBilling($billing)
    {
        if (is_null($billing)) {
            throw new \InvalidArgumentException('non-nullable billing cannot be null');
        }
        $this->container['billing'] = $billing;

        return $this;
    }

    /**
     * Gets shipping
     *
     * @return \Woocommerce\Model\Address|null
     */
    public function getShipping()
    {
        return $this->container['shipping'];
    }

    /**
     * Sets shipping
     *
     * @param \Woocommerce\Model\Address|null $shipping shipping
     *
     * @return self
     */
    public function setShipping($shipping)
    {
        if (is_null($shipping)) {
            throw new \InvalidArgumentException('non-nullable shipping cannot be null');
        }
        $this->container['shipping'] = $shipping;

        return $this;
    }

    /**
     * Gets payment_method
     *
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->container['payment_method'];
    }

    /**
     * Sets payment_method
     *
     * @param string|null $payment_method payment_method
     *
     * @return self
     */
    public function setPaymentMethod($payment_method)
    {
        if (is_null($payment_method)) {
            throw new \InvalidArgumentException('non-nullable payment_method cannot be null');
        }
        $this->container['payment_method'] = $payment_method;

        return $this;
    }

    /**
     * Gets payment_method_title
     *
     * @return string|null
     */
    public function getPaymentMethodTitle()
    {
        return $this->container['payment_method_title'];
    }

    /**
     * Sets payment_method_title
     *
     * @param string|null $payment_method_title payment_method_title
     *
     * @return self
     */
    public function setPaymentMethodTitle($payment_method_title)
    {
        if (is_null($payment_method_title)) {
            throw new \InvalidArgumentException('non-nullable payment_method_title cannot be null');
        }
        $this->container['payment_method_title'] = $payment_method_title;

        return $this;
    }

    /**
     * Gets transaction_id
     *
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->container['transaction_id'];
    }

    /**
     * Sets transaction_id
     *
     * @param string|null $transaction_id transaction_id
     *
     * @return self
     */
    public function setTransactionId($transaction_id)
    {
        if (is_null($transaction_id)) {
            throw new \InvalidArgumentException('non-nullable transaction_id cannot be null');
        }
        $this->container['transaction_id'] = $transaction_id;

        return $this;
    }

    /**
     * Gets date_paid
     *
     * @return \DateTime|null
     */
    public function getDatePaid()
    {
        return $this->container['date_paid'];
    }

    /**
     * Sets date_paid
     *
     * @param \DateTime|null $date_paid date_paid
     *
     * @return self
     */
    public function setDatePaid($date_paid)
    {
        if (is_null($date_paid)) {
            throw new \InvalidArgumentException('non-nullable date_paid cannot be null');
        }
        $this->container['date_paid'] = $date_paid;

        return $this;
    }

    /**
     * Gets date_paid_gmt
     *
     * @return \DateTime|null
     */
    public function getDatePaidGmt()
    {
        return $this->container['date_paid_gmt'];
    }

    /**
     * Sets date_paid_gmt
     *
     * @param \DateTime|null $date_paid_gmt date_paid_gmt
     *
     * @return self
     */
    public function setDatePaidGmt($date_paid_gmt)
    {
        if (is_null($date_paid_gmt)) {
            throw new \InvalidArgumentException('non-nullable date_paid_gmt cannot be null');
        }
        $this->container['date_paid_gmt'] = $date_paid_gmt;

        return $this;
    }

    /**
     * Gets date_completed
     *
     * @return \DateTime|null
     */
    public function getDateCompleted()
    {
        return $this->container['date_completed'];
    }

    /**
     * Sets date_completed
     *
     * @param \DateTime|null $date_completed date_completed
     *
     * @return self
     */
    public function setDateCompleted($date_completed)
    {
        if (is_null($date_completed)) {
            throw new \InvalidArgumentException('non-nullable date_completed cannot be null');
        }
        $this->container['date_completed'] = $date_completed;

        return $this;
    }

    /**
     * Gets date_completed_gmt
     *
     * @return \DateTime|null
     */
    public function getDateCompletedGmt()
    {
        return $this->container['date_completed_gmt'];
    }

    /**
     * Sets date_completed_gmt
     *
     * @param \DateTime|null $date_completed_gmt date_completed_gmt
     *
     * @return self
     */
    public function setDateCompletedGmt($date_completed_gmt)
    {
        if (is_null($date_completed_gmt)) {
            throw new \InvalidArgumentException('non-nullable date_completed_gmt cannot be null');
        }
        $this->container['date_completed_gmt'] = $date_completed_gmt;

        return $this;
    }

    /**
     * Gets cart_hash
     *
     * @return string|null
     */
    public function getCartHash()
    {
        return $this->container['cart_hash'];
    }

    /**
     * Sets cart_hash
     *
     * @param string|null $cart_hash cart_hash
     *
     * @return self
     */
    public function setCartHash($cart_hash)
    {
        if (is_null($cart_hash)) {
            throw new \InvalidArgumentException('non-nullable cart_hash cannot be null');
        }
        $this->container['cart_hash'] = $cart_hash;

        return $this;
    }

    /**
     * Gets meta_data
     *
     * @return \Woocommerce\Model\Metadata[]|null
     */
    public function getMetaData()
    {
        return $this->container['meta_data'];
    }

    /**
     * Sets meta_data
     *
     * @param \Woocommerce\Model\Metadata[]|null $meta_data meta_data
     *
     * @return self
     */
    public function setMetaData($meta_data)
    {
        if (is_null($meta_data)) {
            throw new \InvalidArgumentException('non-nullable meta_data cannot be null');
        }
        $this->container['meta_data'] = $meta_data;

        return $this;
    }

    /**
     * Gets line_items
     *
     * @return \Woocommerce\Model\LineItem[]|null
     */
    public function getLineItems()
    {
        return $this->container['line_items'];
    }

    /**
     * Sets line_items
     *
     * @param \Woocommerce\Model\LineItem[]|null $line_items line_items
     *
     * @return self
     */
    public function setLineItems($line_items)
    {
        if (is_null($line_items)) {
            throw new \InvalidArgumentException('non-nullable line_items cannot be null');
        }
        $this->container['line_items'] = $line_items;

        return $this;
    }

    /**
     * Gets tax_lines
     *
     * @return \Woocommerce\Model\TaxLine[]|null
     */
    public function getTaxLines()
    {
        return $this->container['tax_lines'];
    }

    /**
     * Sets tax_lines
     *
     * @param \Woocommerce\Model\TaxLine[]|null $tax_lines tax_lines
     *
     * @return self
     */
    public function setTaxLines($tax_lines)
    {
        if (is_null($tax_lines)) {
            throw new \InvalidArgumentException('non-nullable tax_lines cannot be null');
        }
        $this->container['tax_lines'] = $tax_lines;

        return $this;
    }

    /**
     * Gets shipping_lines
     *
     * @return \Woocommerce\Model\ShippingLine[]|null
     */
    public function getShippingLines()
    {
        return $this->container['shipping_lines'];
    }

    /**
     * Sets shipping_lines
     *
     * @param \Woocommerce\Model\ShippingLine[]|null $shipping_lines shipping_lines
     *
     * @return self
     */
    public function setShippingLines($shipping_lines)
    {
        if (is_null($shipping_lines)) {
            throw new \InvalidArgumentException('non-nullable shipping_lines cannot be null');
        }
        $this->container['shipping_lines'] = $shipping_lines;

        return $this;
    }

    /**
     * Gets fee_lines
     *
     * @return \Woocommerce\Model\FeeLine[]|null
     */
    public function getFeeLines()
    {
        return $this->container['fee_lines'];
    }

    /**
     * Sets fee_lines
     *
     * @param \Woocommerce\Model\FeeLine[]|null $fee_lines fee_lines
     *
     * @return self
     */
    public function setFeeLines($fee_lines)
    {
        if (is_null($fee_lines)) {
            throw new \InvalidArgumentException('non-nullable fee_lines cannot be null');
        }
        $this->container['fee_lines'] = $fee_lines;

        return $this;
    }

    /**
     * Gets coupon_lines
     *
     * @return \Woocommerce\Model\CouponLine[]|null
     */
    public function getCouponLines()
    {
        return $this->container['coupon_lines'];
    }

    /**
     * Sets coupon_lines
     *
     * @param \Woocommerce\Model\CouponLine[]|null $coupon_lines coupon_lines
     *
     * @return self
     */
    public function setCouponLines($coupon_lines)
    {
        if (is_null($coupon_lines)) {
            throw new \InvalidArgumentException('non-nullable coupon_lines cannot be null');
        }
        $this->container['coupon_lines'] = $coupon_lines;

        return $this;
    }

    /**
     * Gets refunds
     *
     * @return \Woocommerce\Model\RefundLine[]|null
     */
    public function getRefunds()
    {
        return $this->container['refunds'];
    }

    /**
     * Sets refunds
     *
     * @param \Woocommerce\Model\RefundLine[]|null $refunds refunds
     *
     * @return self
     */
    public function setRefunds($refunds)
    {
        if (is_null($refunds)) {
            throw new \InvalidArgumentException('non-nullable refunds cannot be null');
        }
        $this->container['refunds'] = $refunds;

        return $this;
    }

    /**
     * Gets _links
     *
     * @return \Woocommerce\Model\Links|null
     */
    public function getLinks()
    {
        return $this->container['_links'];
    }

    /**
     * Sets _links
     *
     * @param \Woocommerce\Model\Links|null $_links _links
     *
     * @return self
     */
    public function setLinks($_links)
    {
        if (is_null($_links)) {
            throw new \InvalidArgumentException('non-nullable _links cannot be null');
        }
        $this->container['_links'] = $_links;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


