<?php
/**
 * LineItem
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Woocommerce
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Woocommerce API
 *
 * Woocommerce v3.0 API See https://woocommerce.github.io/woocommerce-rest-api-docs/#introduction
 *
 * The version of the OpenAPI document: 3.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Woocommerce\Model;

use \ArrayAccess;
use \Woocommerce\ObjectSerializer;

/**
 * LineItem Class Doc Comment
 *
 * @category Class
 * @package  Woocommerce
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class LineItem implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'LineItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'name' => 'string',
        'product_id' => 'int',
        'variation_id' => 'int',
        'quantity' => 'int',
        'tax_class' => 'string',
        'subtotal' => 'string',
        'subtotal_tax' => 'string',
        'total' => 'string',
        'total_tax' => 'string',
        'taxes' => '\Woocommerce\Model\Tax[]',
        'meta_data' => '\Woocommerce\Model\Metadata[]',
        'sku' => 'string',
        'price' => 'float',
        'parent_name' => 'string',
        'bundled_by' => 'int',
        'bundled_item_title' => 'string',
        'bundled_items' => 'int[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'name' => null,
        'product_id' => null,
        'variation_id' => null,
        'quantity' => null,
        'tax_class' => null,
        'subtotal' => null,
        'subtotal_tax' => null,
        'total' => null,
        'total_tax' => null,
        'taxes' => null,
        'meta_data' => null,
        'sku' => null,
        'price' => null,
        'parent_name' => null,
        'bundled_by' => null,
        'bundled_item_title' => null,
        'bundled_items' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'name' => false,
        'product_id' => false,
        'variation_id' => false,
        'quantity' => false,
        'tax_class' => false,
        'subtotal' => false,
        'subtotal_tax' => false,
        'total' => false,
        'total_tax' => false,
        'taxes' => false,
        'meta_data' => false,
        'sku' => false,
        'price' => false,
        'parent_name' => false,
        'bundled_by' => false,
        'bundled_item_title' => false,
        'bundled_items' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'name' => 'name',
        'product_id' => 'product_id',
        'variation_id' => 'variation_id',
        'quantity' => 'quantity',
        'tax_class' => 'tax_class',
        'subtotal' => 'subtotal',
        'subtotal_tax' => 'subtotal_tax',
        'total' => 'total',
        'total_tax' => 'total_tax',
        'taxes' => 'taxes',
        'meta_data' => 'meta_data',
        'sku' => 'sku',
        'price' => 'price',
        'parent_name' => 'parent_name',
        'bundled_by' => 'bundled_by',
        'bundled_item_title' => 'bundled_item_title',
        'bundled_items' => 'bundled_items'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'name' => 'setName',
        'product_id' => 'setProductId',
        'variation_id' => 'setVariationId',
        'quantity' => 'setQuantity',
        'tax_class' => 'setTaxClass',
        'subtotal' => 'setSubtotal',
        'subtotal_tax' => 'setSubtotalTax',
        'total' => 'setTotal',
        'total_tax' => 'setTotalTax',
        'taxes' => 'setTaxes',
        'meta_data' => 'setMetaData',
        'sku' => 'setSku',
        'price' => 'setPrice',
        'parent_name' => 'setParentName',
        'bundled_by' => 'setBundledBy',
        'bundled_item_title' => 'setBundledItemTitle',
        'bundled_items' => 'setBundledItems'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'name' => 'getName',
        'product_id' => 'getProductId',
        'variation_id' => 'getVariationId',
        'quantity' => 'getQuantity',
        'tax_class' => 'getTaxClass',
        'subtotal' => 'getSubtotal',
        'subtotal_tax' => 'getSubtotalTax',
        'total' => 'getTotal',
        'total_tax' => 'getTotalTax',
        'taxes' => 'getTaxes',
        'meta_data' => 'getMetaData',
        'sku' => 'getSku',
        'price' => 'getPrice',
        'parent_name' => 'getParentName',
        'bundled_by' => 'getBundledBy',
        'bundled_item_title' => 'getBundledItemTitle',
        'bundled_items' => 'getBundledItems'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('product_id', $data ?? [], null);
        $this->setIfExists('variation_id', $data ?? [], null);
        $this->setIfExists('quantity', $data ?? [], null);
        $this->setIfExists('tax_class', $data ?? [], null);
        $this->setIfExists('subtotal', $data ?? [], null);
        $this->setIfExists('subtotal_tax', $data ?? [], null);
        $this->setIfExists('total', $data ?? [], null);
        $this->setIfExists('total_tax', $data ?? [], null);
        $this->setIfExists('taxes', $data ?? [], null);
        $this->setIfExists('meta_data', $data ?? [], null);
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('price', $data ?? [], null);
        $this->setIfExists('parent_name', $data ?? [], null);
        $this->setIfExists('bundled_by', $data ?? [], null);
        $this->setIfExists('bundled_item_title', $data ?? [], null);
        $this->setIfExists('bundled_items', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets product_id
     *
     * @return int|null
     */
    public function getProductId()
    {
        return $this->container['product_id'];
    }

    /**
     * Sets product_id
     *
     * @param int|null $product_id product_id
     *
     * @return self
     */
    public function setProductId($product_id)
    {
        if (is_null($product_id)) {
            throw new \InvalidArgumentException('non-nullable product_id cannot be null');
        }
        $this->container['product_id'] = $product_id;

        return $this;
    }

    /**
     * Gets variation_id
     *
     * @return int|null
     */
    public function getVariationId()
    {
        return $this->container['variation_id'];
    }

    /**
     * Sets variation_id
     *
     * @param int|null $variation_id variation_id
     *
     * @return self
     */
    public function setVariationId($variation_id)
    {
        if (is_null($variation_id)) {
            throw new \InvalidArgumentException('non-nullable variation_id cannot be null');
        }
        $this->container['variation_id'] = $variation_id;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param int|null $quantity quantity
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        if (is_null($quantity)) {
            throw new \InvalidArgumentException('non-nullable quantity cannot be null');
        }
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets tax_class
     *
     * @return string|null
     */
    public function getTaxClass()
    {
        return $this->container['tax_class'];
    }

    /**
     * Sets tax_class
     *
     * @param string|null $tax_class tax_class
     *
     * @return self
     */
    public function setTaxClass($tax_class)
    {
        if (is_null($tax_class)) {
            throw new \InvalidArgumentException('non-nullable tax_class cannot be null');
        }
        $this->container['tax_class'] = $tax_class;

        return $this;
    }

    /**
     * Gets subtotal
     *
     * @return string|null
     */
    public function getSubtotal()
    {
        return $this->container['subtotal'];
    }

    /**
     * Sets subtotal
     *
     * @param string|null $subtotal subtotal
     *
     * @return self
     */
    public function setSubtotal($subtotal)
    {
        if (is_null($subtotal)) {
            throw new \InvalidArgumentException('non-nullable subtotal cannot be null');
        }
        $this->container['subtotal'] = $subtotal;

        return $this;
    }

    /**
     * Gets subtotal_tax
     *
     * @return string|null
     */
    public function getSubtotalTax()
    {
        return $this->container['subtotal_tax'];
    }

    /**
     * Sets subtotal_tax
     *
     * @param string|null $subtotal_tax subtotal_tax
     *
     * @return self
     */
    public function setSubtotalTax($subtotal_tax)
    {
        if (is_null($subtotal_tax)) {
            throw new \InvalidArgumentException('non-nullable subtotal_tax cannot be null');
        }
        $this->container['subtotal_tax'] = $subtotal_tax;

        return $this;
    }

    /**
     * Gets total
     *
     * @return string|null
     */
    public function getTotal()
    {
        return $this->container['total'];
    }

    /**
     * Sets total
     *
     * @param string|null $total total
     *
     * @return self
     */
    public function setTotal($total)
    {
        if (is_null($total)) {
            throw new \InvalidArgumentException('non-nullable total cannot be null');
        }
        $this->container['total'] = $total;

        return $this;
    }

    /**
     * Gets total_tax
     *
     * @return string|null
     */
    public function getTotalTax()
    {
        return $this->container['total_tax'];
    }

    /**
     * Sets total_tax
     *
     * @param string|null $total_tax total_tax
     *
     * @return self
     */
    public function setTotalTax($total_tax)
    {
        if (is_null($total_tax)) {
            throw new \InvalidArgumentException('non-nullable total_tax cannot be null');
        }
        $this->container['total_tax'] = $total_tax;

        return $this;
    }

    /**
     * Gets taxes
     *
     * @return \Woocommerce\Model\Tax[]|null
     */
    public function getTaxes()
    {
        return $this->container['taxes'];
    }

    /**
     * Sets taxes
     *
     * @param \Woocommerce\Model\Tax[]|null $taxes taxes
     *
     * @return self
     */
    public function setTaxes($taxes)
    {
        if (is_null($taxes)) {
            throw new \InvalidArgumentException('non-nullable taxes cannot be null');
        }
        $this->container['taxes'] = $taxes;

        return $this;
    }

    /**
     * Gets meta_data
     *
     * @return \Woocommerce\Model\Metadata[]|null
     */
    public function getMetaData()
    {
        return $this->container['meta_data'];
    }

    /**
     * Sets meta_data
     *
     * @param \Woocommerce\Model\Metadata[]|null $meta_data meta_data
     *
     * @return self
     */
    public function setMetaData($meta_data)
    {
        if (is_null($meta_data)) {
            throw new \InvalidArgumentException('non-nullable meta_data cannot be null');
        }
        $this->container['meta_data'] = $meta_data;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku sku
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            throw new \InvalidArgumentException('non-nullable sku cannot be null');
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets price
     *
     * @return float|null
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param float|null $price price
     *
     * @return self
     */
    public function setPrice($price)
    {
        if (is_null($price)) {
            throw new \InvalidArgumentException('non-nullable price cannot be null');
        }
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets parent_name
     *
     * @return string|null
     */
    public function getParentName()
    {
        return $this->container['parent_name'];
    }

    /**
     * Sets parent_name
     *
     * @param string|null $parent_name parent_name
     *
     * @return self
     */
    public function setParentName($parent_name)
    {
        if (is_null($parent_name)) {
            throw new \InvalidArgumentException('non-nullable parent_name cannot be null');
        }
        $this->container['parent_name'] = $parent_name;

        return $this;
    }

    /**
     * Gets bundled_by
     *
     * @return int|null
     */
    public function getBundledBy()
    {
        return $this->container['bundled_by'];
    }

    /**
     * Sets bundled_by
     *
     * @param int|null $bundled_by bundled_by
     *
     * @return self
     */
    public function setBundledBy($bundled_by)
    {
        if (is_null($bundled_by)) {
            throw new \InvalidArgumentException('non-nullable bundled_by cannot be null');
        }
        $this->container['bundled_by'] = $bundled_by;

        return $this;
    }

    /**
     * Gets bundled_item_title
     *
     * @return string|null
     */
    public function getBundledItemTitle()
    {
        return $this->container['bundled_item_title'];
    }

    /**
     * Sets bundled_item_title
     *
     * @param string|null $bundled_item_title bundled_item_title
     *
     * @return self
     */
    public function setBundledItemTitle($bundled_item_title)
    {
        if (is_null($bundled_item_title)) {
            throw new \InvalidArgumentException('non-nullable bundled_item_title cannot be null');
        }
        $this->container['bundled_item_title'] = $bundled_item_title;

        return $this;
    }

    /**
     * Gets bundled_items
     *
     * @return int[]|null
     */
    public function getBundledItems()
    {
        return $this->container['bundled_items'];
    }

    /**
     * Sets bundled_items
     *
     * @param int[]|null $bundled_items bundled_items
     *
     * @return self
     */
    public function setBundledItems($bundled_items)
    {
        if (is_null($bundled_items)) {
            throw new \InvalidArgumentException('non-nullable bundled_items cannot be null');
        }
        $this->container['bundled_items'] = $bundled_items;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


