<?php
/**
 * Environment
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Woocommerce
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Woocommerce API
 *
 * Woocommerce v3.0 API See https://woocommerce.github.io/woocommerce-rest-api-docs/#introduction
 *
 * The version of the OpenAPI document: 3.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Woocommerce\Model;

use \ArrayAccess;
use \Woocommerce\ObjectSerializer;

/**
 * Environment Class Doc Comment
 *
 * @category Class
 * @package  Woocommerce
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Environment implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Environment';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'home_url' => 'string',
        'site_url' => 'string',
        'version' => 'string',
        'log_directory' => 'string',
        'log_directory_writable' => 'bool',
        'wp_version' => 'string',
        'wp_multisite' => 'bool',
        'wp_memory_limit' => 'int',
        'wp_debug_mode' => 'bool',
        'wp_cron' => 'bool',
        'language' => 'string',
        'server_info' => 'string',
        'php_version' => 'string',
        'php_post_max_size' => 'int',
        'php_max_execution_time' => 'int',
        'php_max_input_vars' => 'int',
        'curl_version' => 'string',
        'suhosin_installed' => 'bool',
        'max_upload_size' => 'int',
        'mysql_version' => 'string',
        'default_timezone' => 'string',
        'fsockopen_or_curl_enabled' => 'bool',
        'soapclient_enabled' => 'bool',
        'domdocument_enabled' => 'bool',
        'gzip_enabled' => 'bool',
        'mbstring_enabled' => 'bool',
        'remote_post_successful' => 'bool',
        'remote_post_response' => 'string',
        'remote_get_successful' => 'bool',
        'remote_get_response' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'home_url' => null,
        'site_url' => null,
        'version' => null,
        'log_directory' => null,
        'log_directory_writable' => null,
        'wp_version' => null,
        'wp_multisite' => null,
        'wp_memory_limit' => null,
        'wp_debug_mode' => null,
        'wp_cron' => null,
        'language' => null,
        'server_info' => null,
        'php_version' => null,
        'php_post_max_size' => null,
        'php_max_execution_time' => null,
        'php_max_input_vars' => null,
        'curl_version' => null,
        'suhosin_installed' => null,
        'max_upload_size' => null,
        'mysql_version' => null,
        'default_timezone' => null,
        'fsockopen_or_curl_enabled' => null,
        'soapclient_enabled' => null,
        'domdocument_enabled' => null,
        'gzip_enabled' => null,
        'mbstring_enabled' => null,
        'remote_post_successful' => null,
        'remote_post_response' => null,
        'remote_get_successful' => null,
        'remote_get_response' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'home_url' => false,
        'site_url' => false,
        'version' => false,
        'log_directory' => false,
        'log_directory_writable' => false,
        'wp_version' => false,
        'wp_multisite' => false,
        'wp_memory_limit' => false,
        'wp_debug_mode' => false,
        'wp_cron' => false,
        'language' => false,
        'server_info' => false,
        'php_version' => false,
        'php_post_max_size' => false,
        'php_max_execution_time' => false,
        'php_max_input_vars' => false,
        'curl_version' => false,
        'suhosin_installed' => false,
        'max_upload_size' => false,
        'mysql_version' => false,
        'default_timezone' => false,
        'fsockopen_or_curl_enabled' => false,
        'soapclient_enabled' => false,
        'domdocument_enabled' => false,
        'gzip_enabled' => false,
        'mbstring_enabled' => false,
        'remote_post_successful' => false,
        'remote_post_response' => false,
        'remote_get_successful' => false,
        'remote_get_response' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'home_url' => 'home_url',
        'site_url' => 'site_url',
        'version' => 'version',
        'log_directory' => 'log_directory',
        'log_directory_writable' => 'log_directory_writable',
        'wp_version' => 'wp_version',
        'wp_multisite' => 'wp_multisite',
        'wp_memory_limit' => 'wp_memory_limit',
        'wp_debug_mode' => 'wp_debug_mode',
        'wp_cron' => 'wp_cron',
        'language' => 'language',
        'server_info' => 'server_info',
        'php_version' => 'php_version',
        'php_post_max_size' => 'php_post_max_size',
        'php_max_execution_time' => 'php_max_execution_time',
        'php_max_input_vars' => 'php_max_input_vars',
        'curl_version' => 'curl_version',
        'suhosin_installed' => 'suhosin_installed',
        'max_upload_size' => 'max_upload_size',
        'mysql_version' => 'mysql_version',
        'default_timezone' => 'default_timezone',
        'fsockopen_or_curl_enabled' => 'fsockopen_or_curl_enabled',
        'soapclient_enabled' => 'soapclient_enabled',
        'domdocument_enabled' => 'domdocument_enabled',
        'gzip_enabled' => 'gzip_enabled',
        'mbstring_enabled' => 'mbstring_enabled',
        'remote_post_successful' => 'remote_post_successful',
        'remote_post_response' => 'remote_post_response',
        'remote_get_successful' => 'remote_get_successful',
        'remote_get_response' => 'remote_get_response'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'home_url' => 'setHomeUrl',
        'site_url' => 'setSiteUrl',
        'version' => 'setVersion',
        'log_directory' => 'setLogDirectory',
        'log_directory_writable' => 'setLogDirectoryWritable',
        'wp_version' => 'setWpVersion',
        'wp_multisite' => 'setWpMultisite',
        'wp_memory_limit' => 'setWpMemoryLimit',
        'wp_debug_mode' => 'setWpDebugMode',
        'wp_cron' => 'setWpCron',
        'language' => 'setLanguage',
        'server_info' => 'setServerInfo',
        'php_version' => 'setPhpVersion',
        'php_post_max_size' => 'setPhpPostMaxSize',
        'php_max_execution_time' => 'setPhpMaxExecutionTime',
        'php_max_input_vars' => 'setPhpMaxInputVars',
        'curl_version' => 'setCurlVersion',
        'suhosin_installed' => 'setSuhosinInstalled',
        'max_upload_size' => 'setMaxUploadSize',
        'mysql_version' => 'setMysqlVersion',
        'default_timezone' => 'setDefaultTimezone',
        'fsockopen_or_curl_enabled' => 'setFsockopenOrCurlEnabled',
        'soapclient_enabled' => 'setSoapclientEnabled',
        'domdocument_enabled' => 'setDomdocumentEnabled',
        'gzip_enabled' => 'setGzipEnabled',
        'mbstring_enabled' => 'setMbstringEnabled',
        'remote_post_successful' => 'setRemotePostSuccessful',
        'remote_post_response' => 'setRemotePostResponse',
        'remote_get_successful' => 'setRemoteGetSuccessful',
        'remote_get_response' => 'setRemoteGetResponse'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'home_url' => 'getHomeUrl',
        'site_url' => 'getSiteUrl',
        'version' => 'getVersion',
        'log_directory' => 'getLogDirectory',
        'log_directory_writable' => 'getLogDirectoryWritable',
        'wp_version' => 'getWpVersion',
        'wp_multisite' => 'getWpMultisite',
        'wp_memory_limit' => 'getWpMemoryLimit',
        'wp_debug_mode' => 'getWpDebugMode',
        'wp_cron' => 'getWpCron',
        'language' => 'getLanguage',
        'server_info' => 'getServerInfo',
        'php_version' => 'getPhpVersion',
        'php_post_max_size' => 'getPhpPostMaxSize',
        'php_max_execution_time' => 'getPhpMaxExecutionTime',
        'php_max_input_vars' => 'getPhpMaxInputVars',
        'curl_version' => 'getCurlVersion',
        'suhosin_installed' => 'getSuhosinInstalled',
        'max_upload_size' => 'getMaxUploadSize',
        'mysql_version' => 'getMysqlVersion',
        'default_timezone' => 'getDefaultTimezone',
        'fsockopen_or_curl_enabled' => 'getFsockopenOrCurlEnabled',
        'soapclient_enabled' => 'getSoapclientEnabled',
        'domdocument_enabled' => 'getDomdocumentEnabled',
        'gzip_enabled' => 'getGzipEnabled',
        'mbstring_enabled' => 'getMbstringEnabled',
        'remote_post_successful' => 'getRemotePostSuccessful',
        'remote_post_response' => 'getRemotePostResponse',
        'remote_get_successful' => 'getRemoteGetSuccessful',
        'remote_get_response' => 'getRemoteGetResponse'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('home_url', $data ?? [], null);
        $this->setIfExists('site_url', $data ?? [], null);
        $this->setIfExists('version', $data ?? [], null);
        $this->setIfExists('log_directory', $data ?? [], null);
        $this->setIfExists('log_directory_writable', $data ?? [], null);
        $this->setIfExists('wp_version', $data ?? [], null);
        $this->setIfExists('wp_multisite', $data ?? [], null);
        $this->setIfExists('wp_memory_limit', $data ?? [], null);
        $this->setIfExists('wp_debug_mode', $data ?? [], null);
        $this->setIfExists('wp_cron', $data ?? [], null);
        $this->setIfExists('language', $data ?? [], null);
        $this->setIfExists('server_info', $data ?? [], null);
        $this->setIfExists('php_version', $data ?? [], null);
        $this->setIfExists('php_post_max_size', $data ?? [], null);
        $this->setIfExists('php_max_execution_time', $data ?? [], null);
        $this->setIfExists('php_max_input_vars', $data ?? [], null);
        $this->setIfExists('curl_version', $data ?? [], null);
        $this->setIfExists('suhosin_installed', $data ?? [], null);
        $this->setIfExists('max_upload_size', $data ?? [], null);
        $this->setIfExists('mysql_version', $data ?? [], null);
        $this->setIfExists('default_timezone', $data ?? [], null);
        $this->setIfExists('fsockopen_or_curl_enabled', $data ?? [], null);
        $this->setIfExists('soapclient_enabled', $data ?? [], null);
        $this->setIfExists('domdocument_enabled', $data ?? [], null);
        $this->setIfExists('gzip_enabled', $data ?? [], null);
        $this->setIfExists('mbstring_enabled', $data ?? [], null);
        $this->setIfExists('remote_post_successful', $data ?? [], null);
        $this->setIfExists('remote_post_response', $data ?? [], null);
        $this->setIfExists('remote_get_successful', $data ?? [], null);
        $this->setIfExists('remote_get_response', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets home_url
     *
     * @return string|null
     */
    public function getHomeUrl()
    {
        return $this->container['home_url'];
    }

    /**
     * Sets home_url
     *
     * @param string|null $home_url home_url
     *
     * @return self
     */
    public function setHomeUrl($home_url)
    {
        if (is_null($home_url)) {
            throw new \InvalidArgumentException('non-nullable home_url cannot be null');
        }
        $this->container['home_url'] = $home_url;

        return $this;
    }

    /**
     * Gets site_url
     *
     * @return string|null
     */
    public function getSiteUrl()
    {
        return $this->container['site_url'];
    }

    /**
     * Sets site_url
     *
     * @param string|null $site_url site_url
     *
     * @return self
     */
    public function setSiteUrl($site_url)
    {
        if (is_null($site_url)) {
            throw new \InvalidArgumentException('non-nullable site_url cannot be null');
        }
        $this->container['site_url'] = $site_url;

        return $this;
    }

    /**
     * Gets version
     *
     * @return string|null
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     *
     * @param string|null $version version
     *
     * @return self
     */
    public function setVersion($version)
    {
        if (is_null($version)) {
            throw new \InvalidArgumentException('non-nullable version cannot be null');
        }
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets log_directory
     *
     * @return string|null
     */
    public function getLogDirectory()
    {
        return $this->container['log_directory'];
    }

    /**
     * Sets log_directory
     *
     * @param string|null $log_directory log_directory
     *
     * @return self
     */
    public function setLogDirectory($log_directory)
    {
        if (is_null($log_directory)) {
            throw new \InvalidArgumentException('non-nullable log_directory cannot be null');
        }
        $this->container['log_directory'] = $log_directory;

        return $this;
    }

    /**
     * Gets log_directory_writable
     *
     * @return bool|null
     */
    public function getLogDirectoryWritable()
    {
        return $this->container['log_directory_writable'];
    }

    /**
     * Sets log_directory_writable
     *
     * @param bool|null $log_directory_writable log_directory_writable
     *
     * @return self
     */
    public function setLogDirectoryWritable($log_directory_writable)
    {
        if (is_null($log_directory_writable)) {
            throw new \InvalidArgumentException('non-nullable log_directory_writable cannot be null');
        }
        $this->container['log_directory_writable'] = $log_directory_writable;

        return $this;
    }

    /**
     * Gets wp_version
     *
     * @return string|null
     */
    public function getWpVersion()
    {
        return $this->container['wp_version'];
    }

    /**
     * Sets wp_version
     *
     * @param string|null $wp_version wp_version
     *
     * @return self
     */
    public function setWpVersion($wp_version)
    {
        if (is_null($wp_version)) {
            throw new \InvalidArgumentException('non-nullable wp_version cannot be null');
        }
        $this->container['wp_version'] = $wp_version;

        return $this;
    }

    /**
     * Gets wp_multisite
     *
     * @return bool|null
     */
    public function getWpMultisite()
    {
        return $this->container['wp_multisite'];
    }

    /**
     * Sets wp_multisite
     *
     * @param bool|null $wp_multisite wp_multisite
     *
     * @return self
     */
    public function setWpMultisite($wp_multisite)
    {
        if (is_null($wp_multisite)) {
            throw new \InvalidArgumentException('non-nullable wp_multisite cannot be null');
        }
        $this->container['wp_multisite'] = $wp_multisite;

        return $this;
    }

    /**
     * Gets wp_memory_limit
     *
     * @return int|null
     */
    public function getWpMemoryLimit()
    {
        return $this->container['wp_memory_limit'];
    }

    /**
     * Sets wp_memory_limit
     *
     * @param int|null $wp_memory_limit wp_memory_limit
     *
     * @return self
     */
    public function setWpMemoryLimit($wp_memory_limit)
    {
        if (is_null($wp_memory_limit)) {
            throw new \InvalidArgumentException('non-nullable wp_memory_limit cannot be null');
        }
        $this->container['wp_memory_limit'] = $wp_memory_limit;

        return $this;
    }

    /**
     * Gets wp_debug_mode
     *
     * @return bool|null
     */
    public function getWpDebugMode()
    {
        return $this->container['wp_debug_mode'];
    }

    /**
     * Sets wp_debug_mode
     *
     * @param bool|null $wp_debug_mode wp_debug_mode
     *
     * @return self
     */
    public function setWpDebugMode($wp_debug_mode)
    {
        if (is_null($wp_debug_mode)) {
            throw new \InvalidArgumentException('non-nullable wp_debug_mode cannot be null');
        }
        $this->container['wp_debug_mode'] = $wp_debug_mode;

        return $this;
    }

    /**
     * Gets wp_cron
     *
     * @return bool|null
     */
    public function getWpCron()
    {
        return $this->container['wp_cron'];
    }

    /**
     * Sets wp_cron
     *
     * @param bool|null $wp_cron wp_cron
     *
     * @return self
     */
    public function setWpCron($wp_cron)
    {
        if (is_null($wp_cron)) {
            throw new \InvalidArgumentException('non-nullable wp_cron cannot be null');
        }
        $this->container['wp_cron'] = $wp_cron;

        return $this;
    }

    /**
     * Gets language
     *
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->container['language'];
    }

    /**
     * Sets language
     *
     * @param string|null $language language
     *
     * @return self
     */
    public function setLanguage($language)
    {
        if (is_null($language)) {
            throw new \InvalidArgumentException('non-nullable language cannot be null');
        }
        $this->container['language'] = $language;

        return $this;
    }

    /**
     * Gets server_info
     *
     * @return string|null
     */
    public function getServerInfo()
    {
        return $this->container['server_info'];
    }

    /**
     * Sets server_info
     *
     * @param string|null $server_info server_info
     *
     * @return self
     */
    public function setServerInfo($server_info)
    {
        if (is_null($server_info)) {
            throw new \InvalidArgumentException('non-nullable server_info cannot be null');
        }
        $this->container['server_info'] = $server_info;

        return $this;
    }

    /**
     * Gets php_version
     *
     * @return string|null
     */
    public function getPhpVersion()
    {
        return $this->container['php_version'];
    }

    /**
     * Sets php_version
     *
     * @param string|null $php_version php_version
     *
     * @return self
     */
    public function setPhpVersion($php_version)
    {
        if (is_null($php_version)) {
            throw new \InvalidArgumentException('non-nullable php_version cannot be null');
        }
        $this->container['php_version'] = $php_version;

        return $this;
    }

    /**
     * Gets php_post_max_size
     *
     * @return int|null
     */
    public function getPhpPostMaxSize()
    {
        return $this->container['php_post_max_size'];
    }

    /**
     * Sets php_post_max_size
     *
     * @param int|null $php_post_max_size php_post_max_size
     *
     * @return self
     */
    public function setPhpPostMaxSize($php_post_max_size)
    {
        if (is_null($php_post_max_size)) {
            throw new \InvalidArgumentException('non-nullable php_post_max_size cannot be null');
        }
        $this->container['php_post_max_size'] = $php_post_max_size;

        return $this;
    }

    /**
     * Gets php_max_execution_time
     *
     * @return int|null
     */
    public function getPhpMaxExecutionTime()
    {
        return $this->container['php_max_execution_time'];
    }

    /**
     * Sets php_max_execution_time
     *
     * @param int|null $php_max_execution_time php_max_execution_time
     *
     * @return self
     */
    public function setPhpMaxExecutionTime($php_max_execution_time)
    {
        if (is_null($php_max_execution_time)) {
            throw new \InvalidArgumentException('non-nullable php_max_execution_time cannot be null');
        }
        $this->container['php_max_execution_time'] = $php_max_execution_time;

        return $this;
    }

    /**
     * Gets php_max_input_vars
     *
     * @return int|null
     */
    public function getPhpMaxInputVars()
    {
        return $this->container['php_max_input_vars'];
    }

    /**
     * Sets php_max_input_vars
     *
     * @param int|null $php_max_input_vars php_max_input_vars
     *
     * @return self
     */
    public function setPhpMaxInputVars($php_max_input_vars)
    {
        if (is_null($php_max_input_vars)) {
            throw new \InvalidArgumentException('non-nullable php_max_input_vars cannot be null');
        }
        $this->container['php_max_input_vars'] = $php_max_input_vars;

        return $this;
    }

    /**
     * Gets curl_version
     *
     * @return string|null
     */
    public function getCurlVersion()
    {
        return $this->container['curl_version'];
    }

    /**
     * Sets curl_version
     *
     * @param string|null $curl_version curl_version
     *
     * @return self
     */
    public function setCurlVersion($curl_version)
    {
        if (is_null($curl_version)) {
            throw new \InvalidArgumentException('non-nullable curl_version cannot be null');
        }
        $this->container['curl_version'] = $curl_version;

        return $this;
    }

    /**
     * Gets suhosin_installed
     *
     * @return bool|null
     */
    public function getSuhosinInstalled()
    {
        return $this->container['suhosin_installed'];
    }

    /**
     * Sets suhosin_installed
     *
     * @param bool|null $suhosin_installed suhosin_installed
     *
     * @return self
     */
    public function setSuhosinInstalled($suhosin_installed)
    {
        if (is_null($suhosin_installed)) {
            throw new \InvalidArgumentException('non-nullable suhosin_installed cannot be null');
        }
        $this->container['suhosin_installed'] = $suhosin_installed;

        return $this;
    }

    /**
     * Gets max_upload_size
     *
     * @return int|null
     */
    public function getMaxUploadSize()
    {
        return $this->container['max_upload_size'];
    }

    /**
     * Sets max_upload_size
     *
     * @param int|null $max_upload_size max_upload_size
     *
     * @return self
     */
    public function setMaxUploadSize($max_upload_size)
    {
        if (is_null($max_upload_size)) {
            throw new \InvalidArgumentException('non-nullable max_upload_size cannot be null');
        }
        $this->container['max_upload_size'] = $max_upload_size;

        return $this;
    }

    /**
     * Gets mysql_version
     *
     * @return string|null
     */
    public function getMysqlVersion()
    {
        return $this->container['mysql_version'];
    }

    /**
     * Sets mysql_version
     *
     * @param string|null $mysql_version mysql_version
     *
     * @return self
     */
    public function setMysqlVersion($mysql_version)
    {
        if (is_null($mysql_version)) {
            throw new \InvalidArgumentException('non-nullable mysql_version cannot be null');
        }
        $this->container['mysql_version'] = $mysql_version;

        return $this;
    }

    /**
     * Gets default_timezone
     *
     * @return string|null
     */
    public function getDefaultTimezone()
    {
        return $this->container['default_timezone'];
    }

    /**
     * Sets default_timezone
     *
     * @param string|null $default_timezone default_timezone
     *
     * @return self
     */
    public function setDefaultTimezone($default_timezone)
    {
        if (is_null($default_timezone)) {
            throw new \InvalidArgumentException('non-nullable default_timezone cannot be null');
        }
        $this->container['default_timezone'] = $default_timezone;

        return $this;
    }

    /**
     * Gets fsockopen_or_curl_enabled
     *
     * @return bool|null
     */
    public function getFsockopenOrCurlEnabled()
    {
        return $this->container['fsockopen_or_curl_enabled'];
    }

    /**
     * Sets fsockopen_or_curl_enabled
     *
     * @param bool|null $fsockopen_or_curl_enabled fsockopen_or_curl_enabled
     *
     * @return self
     */
    public function setFsockopenOrCurlEnabled($fsockopen_or_curl_enabled)
    {
        if (is_null($fsockopen_or_curl_enabled)) {
            throw new \InvalidArgumentException('non-nullable fsockopen_or_curl_enabled cannot be null');
        }
        $this->container['fsockopen_or_curl_enabled'] = $fsockopen_or_curl_enabled;

        return $this;
    }

    /**
     * Gets soapclient_enabled
     *
     * @return bool|null
     */
    public function getSoapclientEnabled()
    {
        return $this->container['soapclient_enabled'];
    }

    /**
     * Sets soapclient_enabled
     *
     * @param bool|null $soapclient_enabled soapclient_enabled
     *
     * @return self
     */
    public function setSoapclientEnabled($soapclient_enabled)
    {
        if (is_null($soapclient_enabled)) {
            throw new \InvalidArgumentException('non-nullable soapclient_enabled cannot be null');
        }
        $this->container['soapclient_enabled'] = $soapclient_enabled;

        return $this;
    }

    /**
     * Gets domdocument_enabled
     *
     * @return bool|null
     */
    public function getDomdocumentEnabled()
    {
        return $this->container['domdocument_enabled'];
    }

    /**
     * Sets domdocument_enabled
     *
     * @param bool|null $domdocument_enabled domdocument_enabled
     *
     * @return self
     */
    public function setDomdocumentEnabled($domdocument_enabled)
    {
        if (is_null($domdocument_enabled)) {
            throw new \InvalidArgumentException('non-nullable domdocument_enabled cannot be null');
        }
        $this->container['domdocument_enabled'] = $domdocument_enabled;

        return $this;
    }

    /**
     * Gets gzip_enabled
     *
     * @return bool|null
     */
    public function getGzipEnabled()
    {
        return $this->container['gzip_enabled'];
    }

    /**
     * Sets gzip_enabled
     *
     * @param bool|null $gzip_enabled gzip_enabled
     *
     * @return self
     */
    public function setGzipEnabled($gzip_enabled)
    {
        if (is_null($gzip_enabled)) {
            throw new \InvalidArgumentException('non-nullable gzip_enabled cannot be null');
        }
        $this->container['gzip_enabled'] = $gzip_enabled;

        return $this;
    }

    /**
     * Gets mbstring_enabled
     *
     * @return bool|null
     */
    public function getMbstringEnabled()
    {
        return $this->container['mbstring_enabled'];
    }

    /**
     * Sets mbstring_enabled
     *
     * @param bool|null $mbstring_enabled mbstring_enabled
     *
     * @return self
     */
    public function setMbstringEnabled($mbstring_enabled)
    {
        if (is_null($mbstring_enabled)) {
            throw new \InvalidArgumentException('non-nullable mbstring_enabled cannot be null');
        }
        $this->container['mbstring_enabled'] = $mbstring_enabled;

        return $this;
    }

    /**
     * Gets remote_post_successful
     *
     * @return bool|null
     */
    public function getRemotePostSuccessful()
    {
        return $this->container['remote_post_successful'];
    }

    /**
     * Sets remote_post_successful
     *
     * @param bool|null $remote_post_successful remote_post_successful
     *
     * @return self
     */
    public function setRemotePostSuccessful($remote_post_successful)
    {
        if (is_null($remote_post_successful)) {
            throw new \InvalidArgumentException('non-nullable remote_post_successful cannot be null');
        }
        $this->container['remote_post_successful'] = $remote_post_successful;

        return $this;
    }

    /**
     * Gets remote_post_response
     *
     * @return string|null
     */
    public function getRemotePostResponse()
    {
        return $this->container['remote_post_response'];
    }

    /**
     * Sets remote_post_response
     *
     * @param string|null $remote_post_response remote_post_response
     *
     * @return self
     */
    public function setRemotePostResponse($remote_post_response)
    {
        if (is_null($remote_post_response)) {
            throw new \InvalidArgumentException('non-nullable remote_post_response cannot be null');
        }
        $this->container['remote_post_response'] = $remote_post_response;

        return $this;
    }

    /**
     * Gets remote_get_successful
     *
     * @return bool|null
     */
    public function getRemoteGetSuccessful()
    {
        return $this->container['remote_get_successful'];
    }

    /**
     * Sets remote_get_successful
     *
     * @param bool|null $remote_get_successful remote_get_successful
     *
     * @return self
     */
    public function setRemoteGetSuccessful($remote_get_successful)
    {
        if (is_null($remote_get_successful)) {
            throw new \InvalidArgumentException('non-nullable remote_get_successful cannot be null');
        }
        $this->container['remote_get_successful'] = $remote_get_successful;

        return $this;
    }

    /**
     * Gets remote_get_response
     *
     * @return string|null
     */
    public function getRemoteGetResponse()
    {
        return $this->container['remote_get_response'];
    }

    /**
     * Sets remote_get_response
     *
     * @param string|null $remote_get_response remote_get_response
     *
     * @return self
     */
    public function setRemoteGetResponse($remote_get_response)
    {
        if (is_null($remote_get_response)) {
            throw new \InvalidArgumentException('non-nullable remote_get_response cannot be null');
        }
        $this->container['remote_get_response'] = $remote_get_response;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


