<?php
/**
 * DatabaseDatabaseTables
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Woocommerce
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Woocommerce API
 *
 * Woocommerce v3.0 API See https://woocommerce.github.io/woocommerce-rest-api-docs/#introduction
 *
 * The version of the OpenAPI document: 3.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Woocommerce\Model;

use \ArrayAccess;
use \Woocommerce\ObjectSerializer;

/**
 * DatabaseDatabaseTables Class Doc Comment
 *
 * @category Class
 * @package  Woocommerce
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class DatabaseDatabaseTables implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Database_database_tables';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'woocommerce_sessions' => 'bool',
        'woocommerce_api_keys' => 'bool',
        'woocommerce_attribute_taxonomies' => 'bool',
        'woocommerce_downloadable_product_permissions' => 'bool',
        'woocommerce_order_items' => 'bool',
        'woocommerce_order_itemmeta' => 'bool',
        'woocommerce_tax_rates' => 'bool',
        'woocommerce_tax_rate_locations' => 'bool',
        'woocommerce_shipping_zones' => 'bool',
        'woocommerce_shipping_zone_locations' => 'bool',
        'woocommerce_shipping_zone_methods' => 'bool',
        'woocommerce_payment_tokens' => 'bool',
        'woocommerce_payment_tokenmeta' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'woocommerce_sessions' => null,
        'woocommerce_api_keys' => null,
        'woocommerce_attribute_taxonomies' => null,
        'woocommerce_downloadable_product_permissions' => null,
        'woocommerce_order_items' => null,
        'woocommerce_order_itemmeta' => null,
        'woocommerce_tax_rates' => null,
        'woocommerce_tax_rate_locations' => null,
        'woocommerce_shipping_zones' => null,
        'woocommerce_shipping_zone_locations' => null,
        'woocommerce_shipping_zone_methods' => null,
        'woocommerce_payment_tokens' => null,
        'woocommerce_payment_tokenmeta' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'woocommerce_sessions' => false,
        'woocommerce_api_keys' => false,
        'woocommerce_attribute_taxonomies' => false,
        'woocommerce_downloadable_product_permissions' => false,
        'woocommerce_order_items' => false,
        'woocommerce_order_itemmeta' => false,
        'woocommerce_tax_rates' => false,
        'woocommerce_tax_rate_locations' => false,
        'woocommerce_shipping_zones' => false,
        'woocommerce_shipping_zone_locations' => false,
        'woocommerce_shipping_zone_methods' => false,
        'woocommerce_payment_tokens' => false,
        'woocommerce_payment_tokenmeta' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'woocommerce_sessions' => 'woocommerce_sessions',
        'woocommerce_api_keys' => 'woocommerce_api_keys',
        'woocommerce_attribute_taxonomies' => 'woocommerce_attribute_taxonomies',
        'woocommerce_downloadable_product_permissions' => 'woocommerce_downloadable_product_permissions',
        'woocommerce_order_items' => 'woocommerce_order_items',
        'woocommerce_order_itemmeta' => 'woocommerce_order_itemmeta',
        'woocommerce_tax_rates' => 'woocommerce_tax_rates',
        'woocommerce_tax_rate_locations' => 'woocommerce_tax_rate_locations',
        'woocommerce_shipping_zones' => 'woocommerce_shipping_zones',
        'woocommerce_shipping_zone_locations' => 'woocommerce_shipping_zone_locations',
        'woocommerce_shipping_zone_methods' => 'woocommerce_shipping_zone_methods',
        'woocommerce_payment_tokens' => 'woocommerce_payment_tokens',
        'woocommerce_payment_tokenmeta' => 'woocommerce_payment_tokenmeta'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'woocommerce_sessions' => 'setWoocommerceSessions',
        'woocommerce_api_keys' => 'setWoocommerceApiKeys',
        'woocommerce_attribute_taxonomies' => 'setWoocommerceAttributeTaxonomies',
        'woocommerce_downloadable_product_permissions' => 'setWoocommerceDownloadableProductPermissions',
        'woocommerce_order_items' => 'setWoocommerceOrderItems',
        'woocommerce_order_itemmeta' => 'setWoocommerceOrderItemmeta',
        'woocommerce_tax_rates' => 'setWoocommerceTaxRates',
        'woocommerce_tax_rate_locations' => 'setWoocommerceTaxRateLocations',
        'woocommerce_shipping_zones' => 'setWoocommerceShippingZones',
        'woocommerce_shipping_zone_locations' => 'setWoocommerceShippingZoneLocations',
        'woocommerce_shipping_zone_methods' => 'setWoocommerceShippingZoneMethods',
        'woocommerce_payment_tokens' => 'setWoocommercePaymentTokens',
        'woocommerce_payment_tokenmeta' => 'setWoocommercePaymentTokenmeta'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'woocommerce_sessions' => 'getWoocommerceSessions',
        'woocommerce_api_keys' => 'getWoocommerceApiKeys',
        'woocommerce_attribute_taxonomies' => 'getWoocommerceAttributeTaxonomies',
        'woocommerce_downloadable_product_permissions' => 'getWoocommerceDownloadableProductPermissions',
        'woocommerce_order_items' => 'getWoocommerceOrderItems',
        'woocommerce_order_itemmeta' => 'getWoocommerceOrderItemmeta',
        'woocommerce_tax_rates' => 'getWoocommerceTaxRates',
        'woocommerce_tax_rate_locations' => 'getWoocommerceTaxRateLocations',
        'woocommerce_shipping_zones' => 'getWoocommerceShippingZones',
        'woocommerce_shipping_zone_locations' => 'getWoocommerceShippingZoneLocations',
        'woocommerce_shipping_zone_methods' => 'getWoocommerceShippingZoneMethods',
        'woocommerce_payment_tokens' => 'getWoocommercePaymentTokens',
        'woocommerce_payment_tokenmeta' => 'getWoocommercePaymentTokenmeta'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('woocommerce_sessions', $data ?? [], null);
        $this->setIfExists('woocommerce_api_keys', $data ?? [], null);
        $this->setIfExists('woocommerce_attribute_taxonomies', $data ?? [], null);
        $this->setIfExists('woocommerce_downloadable_product_permissions', $data ?? [], null);
        $this->setIfExists('woocommerce_order_items', $data ?? [], null);
        $this->setIfExists('woocommerce_order_itemmeta', $data ?? [], null);
        $this->setIfExists('woocommerce_tax_rates', $data ?? [], null);
        $this->setIfExists('woocommerce_tax_rate_locations', $data ?? [], null);
        $this->setIfExists('woocommerce_shipping_zones', $data ?? [], null);
        $this->setIfExists('woocommerce_shipping_zone_locations', $data ?? [], null);
        $this->setIfExists('woocommerce_shipping_zone_methods', $data ?? [], null);
        $this->setIfExists('woocommerce_payment_tokens', $data ?? [], null);
        $this->setIfExists('woocommerce_payment_tokenmeta', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets woocommerce_sessions
     *
     * @return bool|null
     */
    public function getWoocommerceSessions()
    {
        return $this->container['woocommerce_sessions'];
    }

    /**
     * Sets woocommerce_sessions
     *
     * @param bool|null $woocommerce_sessions woocommerce_sessions
     *
     * @return self
     */
    public function setWoocommerceSessions($woocommerce_sessions)
    {
        if (is_null($woocommerce_sessions)) {
            throw new \InvalidArgumentException('non-nullable woocommerce_sessions cannot be null');
        }
        $this->container['woocommerce_sessions'] = $woocommerce_sessions;

        return $this;
    }

    /**
     * Gets woocommerce_api_keys
     *
     * @return bool|null
     */
    public function getWoocommerceApiKeys()
    {
        return $this->container['woocommerce_api_keys'];
    }

    /**
     * Sets woocommerce_api_keys
     *
     * @param bool|null $woocommerce_api_keys woocommerce_api_keys
     *
     * @return self
     */
    public function setWoocommerceApiKeys($woocommerce_api_keys)
    {
        if (is_null($woocommerce_api_keys)) {
            throw new \InvalidArgumentException('non-nullable woocommerce_api_keys cannot be null');
        }
        $this->container['woocommerce_api_keys'] = $woocommerce_api_keys;

        return $this;
    }

    /**
     * Gets woocommerce_attribute_taxonomies
     *
     * @return bool|null
     */
    public function getWoocommerceAttributeTaxonomies()
    {
        return $this->container['woocommerce_attribute_taxonomies'];
    }

    /**
     * Sets woocommerce_attribute_taxonomies
     *
     * @param bool|null $woocommerce_attribute_taxonomies woocommerce_attribute_taxonomies
     *
     * @return self
     */
    public function setWoocommerceAttributeTaxonomies($woocommerce_attribute_taxonomies)
    {
        if (is_null($woocommerce_attribute_taxonomies)) {
            throw new \InvalidArgumentException('non-nullable woocommerce_attribute_taxonomies cannot be null');
        }
        $this->container['woocommerce_attribute_taxonomies'] = $woocommerce_attribute_taxonomies;

        return $this;
    }

    /**
     * Gets woocommerce_downloadable_product_permissions
     *
     * @return bool|null
     */
    public function getWoocommerceDownloadableProductPermissions()
    {
        return $this->container['woocommerce_downloadable_product_permissions'];
    }

    /**
     * Sets woocommerce_downloadable_product_permissions
     *
     * @param bool|null $woocommerce_downloadable_product_permissions woocommerce_downloadable_product_permissions
     *
     * @return self
     */
    public function setWoocommerceDownloadableProductPermissions($woocommerce_downloadable_product_permissions)
    {
        if (is_null($woocommerce_downloadable_product_permissions)) {
            throw new \InvalidArgumentException('non-nullable woocommerce_downloadable_product_permissions cannot be null');
        }
        $this->container['woocommerce_downloadable_product_permissions'] = $woocommerce_downloadable_product_permissions;

        return $this;
    }

    /**
     * Gets woocommerce_order_items
     *
     * @return bool|null
     */
    public function getWoocommerceOrderItems()
    {
        return $this->container['woocommerce_order_items'];
    }

    /**
     * Sets woocommerce_order_items
     *
     * @param bool|null $woocommerce_order_items woocommerce_order_items
     *
     * @return self
     */
    public function setWoocommerceOrderItems($woocommerce_order_items)
    {
        if (is_null($woocommerce_order_items)) {
            throw new \InvalidArgumentException('non-nullable woocommerce_order_items cannot be null');
        }
        $this->container['woocommerce_order_items'] = $woocommerce_order_items;

        return $this;
    }

    /**
     * Gets woocommerce_order_itemmeta
     *
     * @return bool|null
     */
    public function getWoocommerceOrderItemmeta()
    {
        return $this->container['woocommerce_order_itemmeta'];
    }

    /**
     * Sets woocommerce_order_itemmeta
     *
     * @param bool|null $woocommerce_order_itemmeta woocommerce_order_itemmeta
     *
     * @return self
     */
    public function setWoocommerceOrderItemmeta($woocommerce_order_itemmeta)
    {
        if (is_null($woocommerce_order_itemmeta)) {
            throw new \InvalidArgumentException('non-nullable woocommerce_order_itemmeta cannot be null');
        }
        $this->container['woocommerce_order_itemmeta'] = $woocommerce_order_itemmeta;

        return $this;
    }

    /**
     * Gets woocommerce_tax_rates
     *
     * @return bool|null
     */
    public function getWoocommerceTaxRates()
    {
        return $this->container['woocommerce_tax_rates'];
    }

    /**
     * Sets woocommerce_tax_rates
     *
     * @param bool|null $woocommerce_tax_rates woocommerce_tax_rates
     *
     * @return self
     */
    public function setWoocommerceTaxRates($woocommerce_tax_rates)
    {
        if (is_null($woocommerce_tax_rates)) {
            throw new \InvalidArgumentException('non-nullable woocommerce_tax_rates cannot be null');
        }
        $this->container['woocommerce_tax_rates'] = $woocommerce_tax_rates;

        return $this;
    }

    /**
     * Gets woocommerce_tax_rate_locations
     *
     * @return bool|null
     */
    public function getWoocommerceTaxRateLocations()
    {
        return $this->container['woocommerce_tax_rate_locations'];
    }

    /**
     * Sets woocommerce_tax_rate_locations
     *
     * @param bool|null $woocommerce_tax_rate_locations woocommerce_tax_rate_locations
     *
     * @return self
     */
    public function setWoocommerceTaxRateLocations($woocommerce_tax_rate_locations)
    {
        if (is_null($woocommerce_tax_rate_locations)) {
            throw new \InvalidArgumentException('non-nullable woocommerce_tax_rate_locations cannot be null');
        }
        $this->container['woocommerce_tax_rate_locations'] = $woocommerce_tax_rate_locations;

        return $this;
    }

    /**
     * Gets woocommerce_shipping_zones
     *
     * @return bool|null
     */
    public function getWoocommerceShippingZones()
    {
        return $this->container['woocommerce_shipping_zones'];
    }

    /**
     * Sets woocommerce_shipping_zones
     *
     * @param bool|null $woocommerce_shipping_zones woocommerce_shipping_zones
     *
     * @return self
     */
    public function setWoocommerceShippingZones($woocommerce_shipping_zones)
    {
        if (is_null($woocommerce_shipping_zones)) {
            throw new \InvalidArgumentException('non-nullable woocommerce_shipping_zones cannot be null');
        }
        $this->container['woocommerce_shipping_zones'] = $woocommerce_shipping_zones;

        return $this;
    }

    /**
     * Gets woocommerce_shipping_zone_locations
     *
     * @return bool|null
     */
    public function getWoocommerceShippingZoneLocations()
    {
        return $this->container['woocommerce_shipping_zone_locations'];
    }

    /**
     * Sets woocommerce_shipping_zone_locations
     *
     * @param bool|null $woocommerce_shipping_zone_locations woocommerce_shipping_zone_locations
     *
     * @return self
     */
    public function setWoocommerceShippingZoneLocations($woocommerce_shipping_zone_locations)
    {
        if (is_null($woocommerce_shipping_zone_locations)) {
            throw new \InvalidArgumentException('non-nullable woocommerce_shipping_zone_locations cannot be null');
        }
        $this->container['woocommerce_shipping_zone_locations'] = $woocommerce_shipping_zone_locations;

        return $this;
    }

    /**
     * Gets woocommerce_shipping_zone_methods
     *
     * @return bool|null
     */
    public function getWoocommerceShippingZoneMethods()
    {
        return $this->container['woocommerce_shipping_zone_methods'];
    }

    /**
     * Sets woocommerce_shipping_zone_methods
     *
     * @param bool|null $woocommerce_shipping_zone_methods woocommerce_shipping_zone_methods
     *
     * @return self
     */
    public function setWoocommerceShippingZoneMethods($woocommerce_shipping_zone_methods)
    {
        if (is_null($woocommerce_shipping_zone_methods)) {
            throw new \InvalidArgumentException('non-nullable woocommerce_shipping_zone_methods cannot be null');
        }
        $this->container['woocommerce_shipping_zone_methods'] = $woocommerce_shipping_zone_methods;

        return $this;
    }

    /**
     * Gets woocommerce_payment_tokens
     *
     * @return bool|null
     */
    public function getWoocommercePaymentTokens()
    {
        return $this->container['woocommerce_payment_tokens'];
    }

    /**
     * Sets woocommerce_payment_tokens
     *
     * @param bool|null $woocommerce_payment_tokens woocommerce_payment_tokens
     *
     * @return self
     */
    public function setWoocommercePaymentTokens($woocommerce_payment_tokens)
    {
        if (is_null($woocommerce_payment_tokens)) {
            throw new \InvalidArgumentException('non-nullable woocommerce_payment_tokens cannot be null');
        }
        $this->container['woocommerce_payment_tokens'] = $woocommerce_payment_tokens;

        return $this;
    }

    /**
     * Gets woocommerce_payment_tokenmeta
     *
     * @return bool|null
     */
    public function getWoocommercePaymentTokenmeta()
    {
        return $this->container['woocommerce_payment_tokenmeta'];
    }

    /**
     * Sets woocommerce_payment_tokenmeta
     *
     * @param bool|null $woocommerce_payment_tokenmeta woocommerce_payment_tokenmeta
     *
     * @return self
     */
    public function setWoocommercePaymentTokenmeta($woocommerce_payment_tokenmeta)
    {
        if (is_null($woocommerce_payment_tokenmeta)) {
            throw new \InvalidArgumentException('non-nullable woocommerce_payment_tokenmeta cannot be null');
        }
        $this->container['woocommerce_payment_tokenmeta'] = $woocommerce_payment_tokenmeta;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


