# Woocommerce\WebhooksApi

All URIs are relative to https://example.com/wp-json/wc/v3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createWebhook()**](WebhooksApi.md#createWebhook) | **POST** /webhooks | Create a webhook |
| [**deleteWebhook()**](WebhooksApi.md#deleteWebhook) | **DELETE** /webhooks/{id} | Delete a webhook |
| [**getWebhook()**](WebhooksApi.md#getWebhook) | **GET** /webhooks/{id} | Retrieve a webhook |
| [**getWebhooks()**](WebhooksApi.md#getWebhooks) | **GET** /webhooks | List all webhooks |
| [**updateWebhook()**](WebhooksApi.md#updateWebhook) | **PUT** /webhooks/{id} | Update a webhook |


## `createWebhook()`

```php
createWebhook($body): \Woocommerce\Model\WebhookDetails
```

Create a webhook

Create a webhook

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\WebhooksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$body = new \Woocommerce\Model\Webhook(); // \Woocommerce\Model\Webhook

try {
    $result = $apiInstance->createWebhook($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WebhooksApi->createWebhook: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **body** | [**\Woocommerce\Model\Webhook**](../Model/Webhook.md)|  | [optional] |

### Return type

[**\Woocommerce\Model\WebhookDetails**](../Model/WebhookDetails.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteWebhook()`

```php
deleteWebhook($id, $force): \Woocommerce\Model\WebhookDetails
```

Delete a webhook

Delete a webhook

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\WebhooksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$force = True; // bool

try {
    $result = $apiInstance->deleteWebhook($id, $force);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WebhooksApi->deleteWebhook: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **force** | **bool**|  | [optional] |

### Return type

[**\Woocommerce\Model\WebhookDetails**](../Model/WebhookDetails.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getWebhook()`

```php
getWebhook($id): \Woocommerce\Model\WebhookDetails
```

Retrieve a webhook

Retrieve a webhook

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\WebhooksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int

try {
    $result = $apiInstance->getWebhook($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WebhooksApi->getWebhook: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |

### Return type

[**\Woocommerce\Model\WebhookDetails**](../Model/WebhookDetails.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getWebhooks()`

```php
getWebhooks($per_page, $page, $offset, $search, $after, $before, $order, $orderby, $status): \Woocommerce\Model\WebhookDetails[]
```

List all webhooks

List all webhooks

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\WebhooksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$per_page = 56; // int
$page = 56; // int
$offset = 56; // int
$search = 'search_example'; // string | Limit results to those matching a string.
$after = 'after_example'; // string | Limit response to resources published after a given ISO8601 compliant date
$before = 'before_example'; // string | Limit response to resources published before a given ISO8601 compliant date.
$order = 'order_example'; // string | Order sort attribute ascending or descending. Options: asc and desc. Default is desc.
$orderby = 'orderby_example'; // string | Sort collection by object attribute. Options: date, id, include, title and slug. Default is date.
$status = 'status_example'; // string | Limit result set to webhooks assigned a specific status. Options: all, active, paused and disabled. Default is all.

try {
    $result = $apiInstance->getWebhooks($per_page, $page, $offset, $search, $after, $before, $order, $orderby, $status);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WebhooksApi->getWebhooks: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **per_page** | **int**|  | [optional] |
| **page** | **int**|  | [optional] |
| **offset** | **int**|  | [optional] |
| **search** | **string**| Limit results to those matching a string. | [optional] |
| **after** | **string**| Limit response to resources published after a given ISO8601 compliant date | [optional] |
| **before** | **string**| Limit response to resources published before a given ISO8601 compliant date. | [optional] |
| **order** | **string**| Order sort attribute ascending or descending. Options: asc and desc. Default is desc. | [optional] |
| **orderby** | **string**| Sort collection by object attribute. Options: date, id, include, title and slug. Default is date. | [optional] |
| **status** | **string**| Limit result set to webhooks assigned a specific status. Options: all, active, paused and disabled. Default is all. | [optional] |

### Return type

[**\Woocommerce\Model\WebhookDetails[]**](../Model/WebhookDetails.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateWebhook()`

```php
updateWebhook($id): \Woocommerce\Model\WebhookDetails
```

Update a webhook

Update a webhook

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\WebhooksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int

try {
    $result = $apiInstance->updateWebhook($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WebhooksApi->updateWebhook: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |

### Return type

[**\Woocommerce\Model\WebhookDetails**](../Model/WebhookDetails.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
