# Woocommerce\TaxRateApi

All URIs are relative to https://example.com/wp-json/wc/v3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createTaxRate()**](TaxRateApi.md#createTaxRate) | **POST** /taxes | Create a tax rate |
| [**deleteTaxRate()**](TaxRateApi.md#deleteTaxRate) | **DELETE** /taxes/{id} | Delete a tax rate |
| [**getTaxRate()**](TaxRateApi.md#getTaxRate) | **GET** /taxes/{id} | Retrieve a tax rate |
| [**getTaxRates()**](TaxRateApi.md#getTaxRates) | **GET** /taxes | List all tax rates |
| [**updateTaxRate()**](TaxRateApi.md#updateTaxRate) | **PUT** /taxes/{id} | Update a tax rate |


## `createTaxRate()`

```php
createTaxRate($body): \Woocommerce\Model\TaxRate
```

Create a tax rate

Create a tax rate

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\TaxRateApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$body = new \Woocommerce\Model\TaxRate(); // \Woocommerce\Model\TaxRate

try {
    $result = $apiInstance->createTaxRate($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxRateApi->createTaxRate: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **body** | [**\Woocommerce\Model\TaxRate**](../Model/TaxRate.md)|  | [optional] |

### Return type

[**\Woocommerce\Model\TaxRate**](../Model/TaxRate.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteTaxRate()`

```php
deleteTaxRate($id): \Woocommerce\Model\TaxRate
```

Delete a tax rate

Delete a tax rate

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\TaxRateApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int

try {
    $result = $apiInstance->deleteTaxRate($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxRateApi->deleteTaxRate: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |

### Return type

[**\Woocommerce\Model\TaxRate**](../Model/TaxRate.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getTaxRate()`

```php
getTaxRate($id): \Woocommerce\Model\TaxRate
```

Retrieve a tax rate

Retrieve a tax rate

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\TaxRateApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int

try {
    $result = $apiInstance->getTaxRate($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxRateApi->getTaxRate: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |

### Return type

[**\Woocommerce\Model\TaxRate**](../Model/TaxRate.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getTaxRates()`

```php
getTaxRates($page, $per_page, $offset): \Woocommerce\Model\TaxRate[]
```

List all tax rates

List all tax rates

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\TaxRateApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page = 56; // int
$per_page = 56; // int
$offset = 56; // int

try {
    $result = $apiInstance->getTaxRates($page, $per_page, $offset);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxRateApi->getTaxRates: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page** | **int**|  | [optional] |
| **per_page** | **int**|  | [optional] |
| **offset** | **int**|  | [optional] |

### Return type

[**\Woocommerce\Model\TaxRate[]**](../Model/TaxRate.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateTaxRate()`

```php
updateTaxRate($id, $body): \Woocommerce\Model\TaxRate
```

Update a tax rate

Update a tax rate

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\TaxRateApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$body = new \Woocommerce\Model\TaxRate(); // \Woocommerce\Model\TaxRate

try {
    $result = $apiInstance->updateTaxRate($id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxRateApi->updateTaxRate: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **body** | [**\Woocommerce\Model\TaxRate**](../Model/TaxRate.md)|  | [optional] |

### Return type

[**\Woocommerce\Model\TaxRate**](../Model/TaxRate.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
