# Woocommerce\TaxClassApi

All URIs are relative to https://example.com/wp-json/wc/v3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createTaxClass()**](TaxClassApi.md#createTaxClass) | **POST** /taxes/classes | Create a tax class |
| [**deleteTaxClass()**](TaxClassApi.md#deleteTaxClass) | **DELETE** /taxes/classes/{slug} | Delete a tax class |
| [**getTaxClasses()**](TaxClassApi.md#getTaxClasses) | **GET** /taxes/classes | List all tax classes |


## `createTaxClass()`

```php
createTaxClass($body): \Woocommerce\Model\TaxClass
```

Create a tax class

Create a tax class

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\TaxClassApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$body = new \Woocommerce\Model\TaxClass(); // \Woocommerce\Model\TaxClass

try {
    $result = $apiInstance->createTaxClass($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxClassApi->createTaxClass: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **body** | [**\Woocommerce\Model\TaxClass**](../Model/TaxClass.md)|  | [optional] |

### Return type

[**\Woocommerce\Model\TaxClass**](../Model/TaxClass.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteTaxClass()`

```php
deleteTaxClass($slug): \Woocommerce\Model\TaxClass
```

Delete a tax class

Delete a tax class

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\TaxClassApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$slug = 'slug_example'; // string

try {
    $result = $apiInstance->deleteTaxClass($slug);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxClassApi->deleteTaxClass: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **slug** | **string**|  | |

### Return type

[**\Woocommerce\Model\TaxClass**](../Model/TaxClass.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getTaxClasses()`

```php
getTaxClasses(): \Woocommerce\Model\TaxClass[]
```

List all tax classes

List all tax classes

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\TaxClassApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->getTaxClasses();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxClassApi->getTaxClasses: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Woocommerce\Model\TaxClass[]**](../Model/TaxClass.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
