# Woocommerce\SettingsApi

All URIs are relative to https://example.com/wp-json/wc/v3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**getSettingOption()**](SettingsApi.md#getSettingOption) | **GET** /settings/{group_id}/{id} | Retrieve a setting option |
| [**getSettingOptions()**](SettingsApi.md#getSettingOptions) | **GET** /settings/{id} | List all setting options |
| [**getSettingsGroups()**](SettingsApi.md#getSettingsGroups) | **GET** /settings | List all settings groups |
| [**updateSettingOption()**](SettingsApi.md#updateSettingOption) | **PUT** /settings/{group_id}/{id} | Update a setting option |


## `getSettingOption()`

```php
getSettingOption($group_id, $id): \Woocommerce\Model\SettingsOption
```

Retrieve a setting option

Retrieve a setting option

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\SettingsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$group_id = 56; // int
$id = 56; // int

try {
    $result = $apiInstance->getSettingOption($group_id, $id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SettingsApi->getSettingOption: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **group_id** | **int**|  | |
| **id** | **int**|  | |

### Return type

[**\Woocommerce\Model\SettingsOption**](../Model/SettingsOption.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSettingOptions()`

```php
getSettingOptions($id): \Woocommerce\Model\SettingsOption[]
```

List all setting options

List all setting options

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\SettingsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int

try {
    $result = $apiInstance->getSettingOptions($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SettingsApi->getSettingOptions: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |

### Return type

[**\Woocommerce\Model\SettingsOption[]**](../Model/SettingsOption.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSettingsGroups()`

```php
getSettingsGroups($per_page, $page, $offset): \Woocommerce\Model\SettingsGroup[]
```

List all settings groups

List all settings groups

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\SettingsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$per_page = 56; // int
$page = 56; // int
$offset = 56; // int

try {
    $result = $apiInstance->getSettingsGroups($per_page, $page, $offset);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SettingsApi->getSettingsGroups: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **per_page** | **int**|  | [optional] |
| **page** | **int**|  | [optional] |
| **offset** | **int**|  | [optional] |

### Return type

[**\Woocommerce\Model\SettingsGroup[]**](../Model/SettingsGroup.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateSettingOption()`

```php
updateSettingOption($group_id, $id, $body): \Woocommerce\Model\SettingsOption
```

Update a setting option

Update a setting option

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\SettingsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$group_id = 56; // int
$id = 56; // int
$body = new \Woocommerce\Model\Value(); // \Woocommerce\Model\Value

try {
    $result = $apiInstance->updateSettingOption($group_id, $id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SettingsApi->updateSettingOption: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **group_id** | **int**|  | |
| **id** | **int**|  | |
| **body** | [**\Woocommerce\Model\Value**](../Model/Value.md)|  | [optional] |

### Return type

[**\Woocommerce\Model\SettingsOption**](../Model/SettingsOption.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
