# Woocommerce\RefundApi

All URIs are relative to https://example.com/wp-json/wc/v3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createRefund()**](RefundApi.md#createRefund) | **POST** /orders/{id}/refunds | Create a refund |
| [**deleteRefund()**](RefundApi.md#deleteRefund) | **DELETE** /orders/{id}/refunds/{refund_id} | Delete a refund |
| [**getRefund()**](RefundApi.md#getRefund) | **GET** /orders/{id}/refunds/{refund_id} | Retrieve a refund |
| [**getRefunds()**](RefundApi.md#getRefunds) | **GET** /orders/{id}/refunds | List all refunds |


## `createRefund()`

```php
createRefund($id, $body): \Woocommerce\Model\Refund
```

Create a refund

Create a refund

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\RefundApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$body = new \Woocommerce\Model\Refund(); // \Woocommerce\Model\Refund

try {
    $result = $apiInstance->createRefund($id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RefundApi->createRefund: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **body** | [**\Woocommerce\Model\Refund**](../Model/Refund.md)|  | [optional] |

### Return type

[**\Woocommerce\Model\Refund**](../Model/Refund.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteRefund()`

```php
deleteRefund($id, $refund_id): \Woocommerce\Model\Refund
```

Delete a refund

Delete a refund

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\RefundApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$refund_id = 56; // int

try {
    $result = $apiInstance->deleteRefund($id, $refund_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RefundApi->deleteRefund: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **refund_id** | **int**|  | |

### Return type

[**\Woocommerce\Model\Refund**](../Model/Refund.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getRefund()`

```php
getRefund($id, $refund_id): \Woocommerce\Model\Refund
```

Retrieve a refund

Retrieve a refund

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\RefundApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$refund_id = 56; // int

try {
    $result = $apiInstance->getRefund($id, $refund_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RefundApi->getRefund: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **refund_id** | **int**|  | |

### Return type

[**\Woocommerce\Model\Refund**](../Model/Refund.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getRefunds()`

```php
getRefunds($id, $page, $per_page, $offset, $context, $search, $after, $before, $exclude, $include, $order, $orderby, $parent, $parent_exclude, $dp): \Woocommerce\Model\Refund[]
```

List all refunds

List all refunds

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\RefundApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$page = 56; // int
$per_page = 56; // int
$offset = 56; // int
$context = 'context_example'; // string
$search = 'search_example'; // string
$after = 'after_example'; // string
$before = 'before_example'; // string
$exclude = array(56); // int[]
$include = array(56); // int[]
$order = 'order_example'; // string
$orderby = 'orderby_example'; // string
$parent = array(56); // int[]
$parent_exclude = array(56); // int[]
$dp = 56; // int

try {
    $result = $apiInstance->getRefunds($id, $page, $per_page, $offset, $context, $search, $after, $before, $exclude, $include, $order, $orderby, $parent, $parent_exclude, $dp);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RefundApi->getRefunds: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **page** | **int**|  | [optional] |
| **per_page** | **int**|  | [optional] |
| **offset** | **int**|  | [optional] |
| **context** | **string**|  | [optional] |
| **search** | **string**|  | [optional] |
| **after** | **string**|  | [optional] |
| **before** | **string**|  | [optional] |
| **exclude** | [**int[]**](../Model/int.md)|  | [optional] |
| **include** | [**int[]**](../Model/int.md)|  | [optional] |
| **order** | **string**|  | [optional] |
| **orderby** | **string**|  | [optional] |
| **parent** | [**int[]**](../Model/int.md)|  | [optional] |
| **parent_exclude** | [**int[]**](../Model/int.md)|  | [optional] |
| **dp** | **int**|  | [optional] |

### Return type

[**\Woocommerce\Model\Refund[]**](../Model/Refund.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
