# Woocommerce\ProductVariationApi

All URIs are relative to https://example.com/wp-json/wc/v3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**batchUpdateProductVariations()**](ProductVariationApi.md#batchUpdateProductVariations) | **POST** /products/{product_id}/variations/batch | Batch update product variations |
| [**createProductVariantion()**](ProductVariationApi.md#createProductVariantion) | **PUT** /products/{id}/variations | Create a product variation |
| [**deleteProductVariation()**](ProductVariationApi.md#deleteProductVariation) | **DELETE** /products/{product_id}/variations/{id} | Delete a product variation |
| [**getProductVariation()**](ProductVariationApi.md#getProductVariation) | **GET** /products/{product_id}/variations/{id} | Retrieve a product variation |
| [**getProductVariations()**](ProductVariationApi.md#getProductVariations) | **GET** /products/{id}/variations | List all product variations |
| [**updateProductVariation()**](ProductVariationApi.md#updateProductVariation) | **PUT** /products/{product_id}/variations/{id} | Update a product variation |


## `batchUpdateProductVariations()`

```php
batchUpdateProductVariations($product_id, $body): \Woocommerce\Model\ProductVariationBatch
```

Batch update product variations

Batch update product variations

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\ProductVariationApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product_id = 56; // int
$body = new \Woocommerce\Model\ProductVariationBatch(); // \Woocommerce\Model\ProductVariationBatch

try {
    $result = $apiInstance->batchUpdateProductVariations($product_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariationApi->batchUpdateProductVariations: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**|  | |
| **body** | [**\Woocommerce\Model\ProductVariationBatch**](../Model/ProductVariationBatch.md)|  | [optional] |

### Return type

[**\Woocommerce\Model\ProductVariationBatch**](../Model/ProductVariationBatch.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createProductVariantion()`

```php
createProductVariantion($id): \Woocommerce\Model\ProductVariation
```

Create a product variation

Create a product variation

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\ProductVariationApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int

try {
    $result = $apiInstance->createProductVariantion($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariationApi->createProductVariantion: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |

### Return type

[**\Woocommerce\Model\ProductVariation**](../Model/ProductVariation.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteProductVariation()`

```php
deleteProductVariation($product_id, $id): \Woocommerce\Model\ProductVariation
```

Delete a product variation

Delete a product variation

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\ProductVariationApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product_id = 56; // int
$id = 56; // int

try {
    $result = $apiInstance->deleteProductVariation($product_id, $id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariationApi->deleteProductVariation: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**|  | |
| **id** | **int**|  | |

### Return type

[**\Woocommerce\Model\ProductVariation**](../Model/ProductVariation.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProductVariation()`

```php
getProductVariation($product_id, $id): \Woocommerce\Model\ProductVariation
```

Retrieve a product variation

Retrieve a product variation

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\ProductVariationApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product_id = 56; // int
$id = 56; // int

try {
    $result = $apiInstance->getProductVariation($product_id, $id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariationApi->getProductVariation: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**|  | |
| **id** | **int**|  | |

### Return type

[**\Woocommerce\Model\ProductVariation**](../Model/ProductVariation.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProductVariations()`

```php
getProductVariations($id, $context, $page, $per_page, $search, $after, $before, $exclude, $include, $offset, $order, $orderby, $parent, $parent_exclude, $slug, $status, $sku, $tax_class, $on_sale, $min_price, $max_price, $stock_status): \Woocommerce\Model\ProductVariation[]
```

List all product variations

List all product variations

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\ProductVariationApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$context = 'context_example'; // string
$page = 56; // int
$per_page = 56; // int
$search = 'search_example'; // string
$after = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime
$before = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime
$exclude = array(56); // int[]
$include = array(56); // int[]
$offset = 56; // int
$order = 'order_example'; // string
$orderby = 'orderby_example'; // string
$parent = array(56); // int[]
$parent_exclude = array(56); // int[]
$slug = 'slug_example'; // string
$status = 'status_example'; // string
$sku = 'sku_example'; // string
$tax_class = 'tax_class_example'; // string
$on_sale = True; // bool
$min_price = 'min_price_example'; // string
$max_price = 'max_price_example'; // string
$stock_status = 'stock_status_example'; // string

try {
    $result = $apiInstance->getProductVariations($id, $context, $page, $per_page, $search, $after, $before, $exclude, $include, $offset, $order, $orderby, $parent, $parent_exclude, $slug, $status, $sku, $tax_class, $on_sale, $min_price, $max_price, $stock_status);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariationApi->getProductVariations: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **context** | **string**|  | [optional] |
| **page** | **int**|  | [optional] |
| **per_page** | **int**|  | [optional] |
| **search** | **string**|  | [optional] |
| **after** | **\DateTime**|  | [optional] |
| **before** | **\DateTime**|  | [optional] |
| **exclude** | [**int[]**](../Model/int.md)|  | [optional] |
| **include** | [**int[]**](../Model/int.md)|  | [optional] |
| **offset** | **int**|  | [optional] |
| **order** | **string**|  | [optional] |
| **orderby** | **string**|  | [optional] |
| **parent** | [**int[]**](../Model/int.md)|  | [optional] |
| **parent_exclude** | [**int[]**](../Model/int.md)|  | [optional] |
| **slug** | **string**|  | [optional] |
| **status** | **string**|  | [optional] |
| **sku** | **string**|  | [optional] |
| **tax_class** | **string**|  | [optional] |
| **on_sale** | **bool**|  | [optional] |
| **min_price** | **string**|  | [optional] |
| **max_price** | **string**|  | [optional] |
| **stock_status** | **string**|  | [optional] |

### Return type

[**\Woocommerce\Model\ProductVariation[]**](../Model/ProductVariation.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateProductVariation()`

```php
updateProductVariation($product_id, $id, $body): \Woocommerce\Model\ProductVariation
```

Update a product variation

Update a product variation

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\ProductVariationApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product_id = 56; // int
$id = 56; // int
$body = new \Woocommerce\Model\ProductVariation(); // \Woocommerce\Model\ProductVariation

try {
    $result = $apiInstance->updateProductVariation($product_id, $id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductVariationApi->updateProductVariation: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **int**|  | |
| **id** | **int**|  | |
| **body** | [**\Woocommerce\Model\ProductVariation**](../Model/ProductVariation.md)|  | [optional] |

### Return type

[**\Woocommerce\Model\ProductVariation**](../Model/ProductVariation.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
