# Woocommerce\ProductTagsApi

All URIs are relative to https://example.com/wp-json/wc/v3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createProductsTag()**](ProductTagsApi.md#createProductsTag) | **POST** /products/tags |  |
| [**deleteProductsTag()**](ProductTagsApi.md#deleteProductsTag) | **DELETE** /products/tags/{id} |  |
| [**getProductsTag()**](ProductTagsApi.md#getProductsTag) | **GET** /products/tags/{id} | Your GET endpoint |
| [**getProductsTags()**](ProductTagsApi.md#getProductsTags) | **GET** /products/tags |  |
| [**updateProductsTag()**](ProductTagsApi.md#updateProductsTag) | **POST** /products/tags/{id} |  |
| [**updateProductsTags()**](ProductTagsApi.md#updateProductsTags) | **POST** /products/tags/batch |  |


## `createProductsTag()`

```php
createProductsTag($product_tag): \Woocommerce\Model\ProductTag
```



Create a product tag

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\ProductTagsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product_tag = new \Woocommerce\Model\ProductTag(); // \Woocommerce\Model\ProductTag

try {
    $result = $apiInstance->createProductsTag($product_tag);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductTagsApi->createProductsTag: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_tag** | [**\Woocommerce\Model\ProductTag**](../Model/ProductTag.md)|  | [optional] |

### Return type

[**\Woocommerce\Model\ProductTag**](../Model/ProductTag.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteProductsTag()`

```php
deleteProductsTag($id): \Woocommerce\Model\ProductTag
```



Delete a product tag

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\ProductTagsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int

try {
    $result = $apiInstance->deleteProductsTag($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductTagsApi->deleteProductsTag: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |

### Return type

[**\Woocommerce\Model\ProductTag**](../Model/ProductTag.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProductsTag()`

```php
getProductsTag($id): \Woocommerce\Model\ProductTag
```

Your GET endpoint

Retrieve a product tag

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\ProductTagsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int

try {
    $result = $apiInstance->getProductsTag($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductTagsApi->getProductsTag: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |

### Return type

[**\Woocommerce\Model\ProductTag**](../Model/ProductTag.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProductsTags()`

```php
getProductsTags($context, $page, $per_page, $search, $exclude, $include, $offset, $order, $orderby, $hide_empty, $product, $slug): \Woocommerce\Model\ProductTag[]
```



List all product tags

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\ProductTagsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$context = 'context_example'; // string
$page = 56; // int
$per_page = 56; // int
$search = 'search_example'; // string
$exclude = array(56); // int[]
$include = array(56); // int[]
$offset = 56; // int
$order = 'order_example'; // string
$orderby = 'orderby_example'; // string
$hide_empty = True; // bool
$product = 56; // int
$slug = 'slug_example'; // string

try {
    $result = $apiInstance->getProductsTags($context, $page, $per_page, $search, $exclude, $include, $offset, $order, $orderby, $hide_empty, $product, $slug);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductTagsApi->getProductsTags: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **context** | **string**|  | [optional] |
| **page** | **int**|  | [optional] |
| **per_page** | **int**|  | [optional] |
| **search** | **string**|  | [optional] |
| **exclude** | [**int[]**](../Model/int.md)|  | [optional] |
| **include** | [**int[]**](../Model/int.md)|  | [optional] |
| **offset** | **int**|  | [optional] |
| **order** | **string**|  | [optional] |
| **orderby** | **string**|  | [optional] |
| **hide_empty** | **bool**|  | [optional] |
| **product** | **int**|  | [optional] |
| **slug** | **string**|  | [optional] |

### Return type

[**\Woocommerce\Model\ProductTag[]**](../Model/ProductTag.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateProductsTag()`

```php
updateProductsTag($id, $product_tag): \Woocommerce\Model\ProductTag
```



Update a product tag

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\ProductTagsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$product_tag = new \Woocommerce\Model\ProductTag(); // \Woocommerce\Model\ProductTag

try {
    $result = $apiInstance->updateProductsTag($id, $product_tag);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductTagsApi->updateProductsTag: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **product_tag** | [**\Woocommerce\Model\ProductTag**](../Model/ProductTag.md)|  | [optional] |

### Return type

[**\Woocommerce\Model\ProductTag**](../Model/ProductTag.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateProductsTags()`

```php
updateProductsTags($product_tags_batch): \Woocommerce\Model\ProductTagsBatch
```



Batch update product tags

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\ProductTagsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product_tags_batch = new \Woocommerce\Model\ProductTagsBatch(); // \Woocommerce\Model\ProductTagsBatch

try {
    $result = $apiInstance->updateProductsTags($product_tags_batch);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductTagsApi->updateProductsTags: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_tags_batch** | [**\Woocommerce\Model\ProductTagsBatch**](../Model/ProductTagsBatch.md)|  | [optional] |

### Return type

[**\Woocommerce\Model\ProductTagsBatch**](../Model/ProductTagsBatch.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
