# Woocommerce\ProductCategoryApi

All URIs are relative to https://example.com/wp-json/wc/v3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createProductCategory()**](ProductCategoryApi.md#createProductCategory) | **POST** /products/categories | Create a product category |
| [**deleteProductCategory()**](ProductCategoryApi.md#deleteProductCategory) | **DELETE** /products/categories/{id} | Delete a product category |
| [**getProductCategories()**](ProductCategoryApi.md#getProductCategories) | **GET** /products/categories | List all product categories |
| [**getProductCategory()**](ProductCategoryApi.md#getProductCategory) | **GET** /products/categories/{id} | Retrieve a product category |
| [**updateProductCategory()**](ProductCategoryApi.md#updateProductCategory) | **PUT** /products/categories/{id} | Update a product category |


## `createProductCategory()`

```php
createProductCategory($body): \Woocommerce\Model\ProductCategory
```

Create a product category

Create a product category

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\ProductCategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$body = new \Woocommerce\Model\ProductCategory(); // \Woocommerce\Model\ProductCategory

try {
    $result = $apiInstance->createProductCategory($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductCategoryApi->createProductCategory: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **body** | [**\Woocommerce\Model\ProductCategory**](../Model/ProductCategory.md)|  | [optional] |

### Return type

[**\Woocommerce\Model\ProductCategory**](../Model/ProductCategory.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteProductCategory()`

```php
deleteProductCategory($id): \Woocommerce\Model\ProductCategory
```

Delete a product category

Delete a product category

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\ProductCategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int

try {
    $result = $apiInstance->deleteProductCategory($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductCategoryApi->deleteProductCategory: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |

### Return type

[**\Woocommerce\Model\ProductCategory**](../Model/ProductCategory.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProductCategories()`

```php
getProductCategories($context, $page, $per_page, $search, $order, $orderby, $hide_empty, $parent, $product, $slug): \Woocommerce\Model\ProductCategory[]
```

List all product categories

List all product categories

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\ProductCategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$context = 'context_example'; // string
$page = 56; // int
$per_page = 56; // int
$search = 'search_example'; // string
$order = 'order_example'; // string
$orderby = 'orderby_example'; // string
$hide_empty = True; // bool
$parent = 56; // int
$product = 56; // int
$slug = 'slug_example'; // string

try {
    $result = $apiInstance->getProductCategories($context, $page, $per_page, $search, $order, $orderby, $hide_empty, $parent, $product, $slug);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductCategoryApi->getProductCategories: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **context** | **string**|  | [optional] |
| **page** | **int**|  | [optional] |
| **per_page** | **int**|  | [optional] |
| **search** | **string**|  | [optional] |
| **order** | **string**|  | [optional] |
| **orderby** | **string**|  | [optional] |
| **hide_empty** | **bool**|  | [optional] |
| **parent** | **int**|  | [optional] |
| **product** | **int**|  | [optional] |
| **slug** | **string**|  | [optional] |

### Return type

[**\Woocommerce\Model\ProductCategory[]**](../Model/ProductCategory.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProductCategory()`

```php
getProductCategory($id): \Woocommerce\Model\ProductCategory
```

Retrieve a product category

Retrieve a product category

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\ProductCategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int

try {
    $result = $apiInstance->getProductCategory($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductCategoryApi->getProductCategory: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |

### Return type

[**\Woocommerce\Model\ProductCategory**](../Model/ProductCategory.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateProductCategory()`

```php
updateProductCategory($id, $body): \Woocommerce\Model\ProductCategory
```

Update a product category

Update a product category

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\ProductCategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$body = new \Woocommerce\Model\ProductCategory(); // \Woocommerce\Model\ProductCategory

try {
    $result = $apiInstance->updateProductCategory($id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductCategoryApi->updateProductCategory: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **body** | [**\Woocommerce\Model\ProductCategory**](../Model/ProductCategory.md)|  | [optional] |

### Return type

[**\Woocommerce\Model\ProductCategory**](../Model/ProductCategory.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
