# Woocommerce\ProductAttributeApi

All URIs are relative to https://example.com/wp-json/wc/v3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createProductAttribute()**](ProductAttributeApi.md#createProductAttribute) | **POST** /products/attributes | Create a product attribute |
| [**deleteProductAttribute()**](ProductAttributeApi.md#deleteProductAttribute) | **DELETE** /products/attributes/{id} | Delete a product attribute |
| [**getProductAttribute()**](ProductAttributeApi.md#getProductAttribute) | **GET** /products/attributes/{id} | Retrieve a product attribute |
| [**getProductAttributes()**](ProductAttributeApi.md#getProductAttributes) | **GET** /products/attributes | List all product attributes |
| [**updateProductAttirbiute()**](ProductAttributeApi.md#updateProductAttirbiute) | **PUT** /products/attributes/{id} | Update a product attribute |


## `createProductAttribute()`

```php
createProductAttribute($body): \Woocommerce\Model\ProductAttribute
```

Create a product attribute

Create a product attribute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\ProductAttributeApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$body = new \Woocommerce\Model\ProductAttribute(); // \Woocommerce\Model\ProductAttribute

try {
    $result = $apiInstance->createProductAttribute($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributeApi->createProductAttribute: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **body** | [**\Woocommerce\Model\ProductAttribute**](../Model/ProductAttribute.md)|  | [optional] |

### Return type

[**\Woocommerce\Model\ProductAttribute**](../Model/ProductAttribute.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteProductAttribute()`

```php
deleteProductAttribute($id): \Woocommerce\Model\ProductAttribute
```

Delete a product attribute

Delete a product attribute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\ProductAttributeApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int

try {
    $result = $apiInstance->deleteProductAttribute($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributeApi->deleteProductAttribute: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |

### Return type

[**\Woocommerce\Model\ProductAttribute**](../Model/ProductAttribute.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProductAttribute()`

```php
getProductAttribute($id): \Woocommerce\Model\ProductAttribute
```

Retrieve a product attribute

Retrieve a product attribute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\ProductAttributeApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int

try {
    $result = $apiInstance->getProductAttribute($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributeApi->getProductAttribute: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |

### Return type

[**\Woocommerce\Model\ProductAttribute**](../Model/ProductAttribute.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProductAttributes()`

```php
getProductAttributes(): \Woocommerce\Model\ProductAttribute[]
```

List all product attributes

List all product attributes

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\ProductAttributeApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->getProductAttributes();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributeApi->getProductAttributes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Woocommerce\Model\ProductAttribute[]**](../Model/ProductAttribute.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateProductAttirbiute()`

```php
updateProductAttirbiute($id, $body): \Woocommerce\Model\ProductAttribute
```

Update a product attribute

Update a product attribute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\ProductAttributeApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$body = new \Woocommerce\Model\ProductAttribute(); // \Woocommerce\Model\ProductAttribute

try {
    $result = $apiInstance->updateProductAttirbiute($id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductAttributeApi->updateProductAttirbiute: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **body** | [**\Woocommerce\Model\ProductAttribute**](../Model/ProductAttribute.md)|  | [optional] |

### Return type

[**\Woocommerce\Model\ProductAttribute**](../Model/ProductAttribute.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
