# Woocommerce\ProductApi

All URIs are relative to https://example.com/wp-json/wc/v3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createProduct()**](ProductApi.md#createProduct) | **POST** /products | Create a product |
| [**deleteProduct()**](ProductApi.md#deleteProduct) | **DELETE** /products/{id} | Delete a product |
| [**getProduct()**](ProductApi.md#getProduct) | **GET** /products/{id} | Retrieve a product |
| [**getProducts()**](ProductApi.md#getProducts) | **GET** /products | List all products |
| [**updateProduct()**](ProductApi.md#updateProduct) | **PUT** /products/{id} | Update a product |


## `createProduct()`

```php
createProduct($body): \Woocommerce\Model\Product
```

Create a product

Create a product

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$body = new \Woocommerce\Model\Product(); // \Woocommerce\Model\Product

try {
    $result = $apiInstance->createProduct($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->createProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **body** | [**\Woocommerce\Model\Product**](../Model/Product.md)|  | [optional] |

### Return type

[**\Woocommerce\Model\Product**](../Model/Product.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteProduct()`

```php
deleteProduct($id): \Woocommerce\Model\Product
```

Delete a product

Delete a product

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int

try {
    $result = $apiInstance->deleteProduct($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->deleteProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |

### Return type

[**\Woocommerce\Model\Product**](../Model/Product.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProduct()`

```php
getProduct($id): \Woocommerce\Model\Product
```

Retrieve a product

Retrieve a product

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int

try {
    $result = $apiInstance->getProduct($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->getProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |

### Return type

[**\Woocommerce\Model\Product**](../Model/Product.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProducts()`

```php
getProducts($context, $page, $per_page, $search, $after, $before, $exclude, $include, $offset, $order, $orderby, $parent, $parent_exclude, $slug, $status, $type, $sku, $featured, $category, $tag, $shipping_class, $attribute, $attribute_term, $tax_class, $on_sale, $min_price, $max_price, $stock_status): \Woocommerce\Model\Product[]
```

List all products

List all products

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$context = 'context_example'; // string
$page = 56; // int
$per_page = 56; // int
$search = 'search_example'; // string
$after = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime
$before = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime
$exclude = array(56); // int[]
$include = array(56); // int[]
$offset = 56; // int
$order = 'order_example'; // string
$orderby = 'orderby_example'; // string
$parent = array(56); // int[]
$parent_exclude = array(56); // int[]
$slug = 'slug_example'; // string
$status = 'status_example'; // string
$type = 'type_example'; // string
$sku = 'sku_example'; // string
$featured = True; // bool
$category = 56; // int
$tag = 56; // int
$shipping_class = 56; // int
$attribute = 56; // int
$attribute_term = 56; // int
$tax_class = 'tax_class_example'; // string
$on_sale = True; // bool
$min_price = 'min_price_example'; // string
$max_price = 'max_price_example'; // string
$stock_status = 'stock_status_example'; // string

try {
    $result = $apiInstance->getProducts($context, $page, $per_page, $search, $after, $before, $exclude, $include, $offset, $order, $orderby, $parent, $parent_exclude, $slug, $status, $type, $sku, $featured, $category, $tag, $shipping_class, $attribute, $attribute_term, $tax_class, $on_sale, $min_price, $max_price, $stock_status);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->getProducts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **context** | **string**|  | [optional] |
| **page** | **int**|  | [optional] |
| **per_page** | **int**|  | [optional] |
| **search** | **string**|  | [optional] |
| **after** | **\DateTime**|  | [optional] |
| **before** | **\DateTime**|  | [optional] |
| **exclude** | [**int[]**](../Model/int.md)|  | [optional] |
| **include** | [**int[]**](../Model/int.md)|  | [optional] |
| **offset** | **int**|  | [optional] |
| **order** | **string**|  | [optional] |
| **orderby** | **string**|  | [optional] |
| **parent** | [**int[]**](../Model/int.md)|  | [optional] |
| **parent_exclude** | [**int[]**](../Model/int.md)|  | [optional] |
| **slug** | **string**|  | [optional] |
| **status** | **string**|  | [optional] |
| **type** | **string**|  | [optional] |
| **sku** | **string**|  | [optional] |
| **featured** | **bool**|  | [optional] |
| **category** | **int**|  | [optional] |
| **tag** | **int**|  | [optional] |
| **shipping_class** | **int**|  | [optional] |
| **attribute** | **int**|  | [optional] |
| **attribute_term** | **int**|  | [optional] |
| **tax_class** | **string**|  | [optional] |
| **on_sale** | **bool**|  | [optional] |
| **min_price** | **string**|  | [optional] |
| **max_price** | **string**|  | [optional] |
| **stock_status** | **string**|  | [optional] |

### Return type

[**\Woocommerce\Model\Product[]**](../Model/Product.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateProduct()`

```php
updateProduct($id, $body): \Woocommerce\Model\Product
```

Update a product

Update a product

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$body = new \Woocommerce\Model\Product(); // \Woocommerce\Model\Product

try {
    $result = $apiInstance->updateProduct($id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->updateProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **body** | [**\Woocommerce\Model\Product**](../Model/Product.md)|  | [optional] |

### Return type

[**\Woocommerce\Model\Product**](../Model/Product.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
