# Woocommerce\OrderNotesApi

All URIs are relative to https://example.com/wp-json/wc/v3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createOrderNote()**](OrderNotesApi.md#createOrderNote) | **POST** /orders/{id}/notes | Create a new note for an order |
| [**deleteOrderNote()**](OrderNotesApi.md#deleteOrderNote) | **DELETE** /orders/{id}/notes/{note_id} | Delete an order note |
| [**getOrderNote()**](OrderNotesApi.md#getOrderNote) | **GET** /orders/{id}/notes/{note_id} | Retrieve and view a specific note from an order |
| [**getOrderNotes()**](OrderNotesApi.md#getOrderNotes) | **GET** /orders/{id}/notes | View all the notes from an order |


## `createOrderNote()`

```php
createOrderNote($id, $body): object
```

Create a new note for an order

Create a new note for an order

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\OrderNotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$body = new \Woocommerce\Model\CreateOrderNoteRequest(); // \Woocommerce\Model\CreateOrderNoteRequest

try {
    $result = $apiInstance->createOrderNote($id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderNotesApi->createOrderNote: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **body** | [**\Woocommerce\Model\CreateOrderNoteRequest**](../Model/CreateOrderNoteRequest.md)|  | [optional] |

### Return type

**object**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteOrderNote()`

```php
deleteOrderNote($id, $note_id): \Woocommerce\Model\OrderNote
```

Delete an order note

Delete an order note

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\OrderNotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$note_id = 56; // int

try {
    $result = $apiInstance->deleteOrderNote($id, $note_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderNotesApi->deleteOrderNote: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **note_id** | **int**|  | |

### Return type

[**\Woocommerce\Model\OrderNote**](../Model/OrderNote.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderNote()`

```php
getOrderNote($id, $note_id): \Woocommerce\Model\OrderNote
```

Retrieve and view a specific note from an order

Retrieve and view a specific note from an order

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\OrderNotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$note_id = 56; // int

try {
    $result = $apiInstance->getOrderNote($id, $note_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderNotesApi->getOrderNote: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **note_id** | **int**|  | |

### Return type

[**\Woocommerce\Model\OrderNote**](../Model/OrderNote.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderNotes()`

```php
getOrderNotes($id, $context, $type): \Woocommerce\Model\OrderNote[]
```

View all the notes from an order

View all the notes from an order

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\OrderNotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$context = 'context_example'; // string
$type = 'type_example'; // string

try {
    $result = $apiInstance->getOrderNotes($id, $context, $type);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderNotesApi->getOrderNotes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **context** | **string**|  | [optional] |
| **type** | **string**|  | [optional] |

### Return type

[**\Woocommerce\Model\OrderNote[]**](../Model/OrderNote.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
