# Woocommerce\OrderApi

All URIs are relative to https://example.com/wp-json/wc/v3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createOrder()**](OrderApi.md#createOrder) | **POST** /orders | Create an order |
| [**deleteOrder()**](OrderApi.md#deleteOrder) | **DELETE** /orders/{id} | Delete an order |
| [**getOrder()**](OrderApi.md#getOrder) | **GET** /orders/{id} | Retrieve an order |
| [**getOrders()**](OrderApi.md#getOrders) | **GET** /orders | List all orders |
| [**updateOrder()**](OrderApi.md#updateOrder) | **PUT** /orders/{id} | Create an order |


## `createOrder()`

```php
createOrder($body): \Woocommerce\Model\Order
```

Create an order

Create an order

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$body = new \Woocommerce\Model\Order(); // \Woocommerce\Model\Order

try {
    $result = $apiInstance->createOrder($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->createOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **body** | [**\Woocommerce\Model\Order**](../Model/Order.md)|  | [optional] |

### Return type

[**\Woocommerce\Model\Order**](../Model/Order.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteOrder()`

```php
deleteOrder($id, $force): \Woocommerce\Model\Order
```

Delete an order

Delete an order

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$force = True; // bool

try {
    $result = $apiInstance->deleteOrder($id, $force);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->deleteOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **force** | **bool**|  | [optional] |

### Return type

[**\Woocommerce\Model\Order**](../Model/Order.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrder()`

```php
getOrder($id): \Woocommerce\Model\Order
```

Retrieve an order

Retrieve an order

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int

try {
    $result = $apiInstance->getOrder($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->getOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |

### Return type

[**\Woocommerce\Model\Order**](../Model/Order.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrders()`

```php
getOrders($context, $page, $per_page, $search, $after, $before, $exclude, $include, $offset, $order, $orderby, $parent, $parent_exclude, $status, $customer, $product, $dp, $modified_after, $modified_before, $dates_are_gmt): \Woocommerce\Model\Order[]
```

List all orders

List all orders

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$context = 'context_example'; // string
$page = 56; // int
$per_page = 56; // int
$search = 'search_example'; // string
$after = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime
$before = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime
$exclude = array(56); // int[]
$include = array(56); // int[]
$offset = 56; // int
$order = 'order_example'; // string
$orderby = 'orderby_example'; // string
$parent = array(56); // int[]
$parent_exclude = array(56); // int[]
$status = array('status_example'); // string[]
$customer = 56; // int
$product = 56; // int
$dp = 56; // int
$modified_after = 'modified_after_example'; // string
$modified_before = 'modified_before_example'; // string
$dates_are_gmt = True; // bool

try {
    $result = $apiInstance->getOrders($context, $page, $per_page, $search, $after, $before, $exclude, $include, $offset, $order, $orderby, $parent, $parent_exclude, $status, $customer, $product, $dp, $modified_after, $modified_before, $dates_are_gmt);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->getOrders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **context** | **string**|  | [optional] |
| **page** | **int**|  | [optional] |
| **per_page** | **int**|  | [optional] |
| **search** | **string**|  | [optional] |
| **after** | **\DateTime**|  | [optional] |
| **before** | **\DateTime**|  | [optional] |
| **exclude** | [**int[]**](../Model/int.md)|  | [optional] |
| **include** | [**int[]**](../Model/int.md)|  | [optional] |
| **offset** | **int**|  | [optional] |
| **order** | **string**|  | [optional] |
| **orderby** | **string**|  | [optional] |
| **parent** | [**int[]**](../Model/int.md)|  | [optional] |
| **parent_exclude** | [**int[]**](../Model/int.md)|  | [optional] |
| **status** | [**string[]**](../Model/string.md)|  | [optional] |
| **customer** | **int**|  | [optional] |
| **product** | **int**|  | [optional] |
| **dp** | **int**|  | [optional] |
| **modified_after** | **string**|  | [optional] |
| **modified_before** | **string**|  | [optional] |
| **dates_are_gmt** | **bool**|  | [optional] |

### Return type

[**\Woocommerce\Model\Order[]**](../Model/Order.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateOrder()`

```php
updateOrder($id, $body): \Woocommerce\Model\Order
```

Create an order

Create an order

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int
$body = new \Woocommerce\Model\Order(); // \Woocommerce\Model\Order

try {
    $result = $apiInstance->updateOrder($id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->updateOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **body** | [**\Woocommerce\Model\Order**](../Model/Order.md)|  | [optional] |

### Return type

[**\Woocommerce\Model\Order**](../Model/Order.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
