# Woocommerce\MultiInventoryApi

All URIs are relative to https://example.com/wp-json/wc/v3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**getInventories()**](MultiInventoryApi.md#getInventories) | **GET** /inventories | Your GET endpoint |
| [**getStock()**](MultiInventoryApi.md#getStock) | **GET** /stock | Your GET endpoint |
| [**postStock()**](MultiInventoryApi.md#postStock) | **POST** /stock |  |


## `getInventories()`

```php
getInventories(): \Woocommerce\Model\Inventories
```

Your GET endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\MultiInventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->getInventories();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling MultiInventoryApi->getInventories: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Woocommerce\Model\Inventories**](../Model/Inventories.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStock()`

```php
getStock($sku, $product_id): object
```

Your GET endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\MultiInventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sku = 'sku_example'; // string
$product_id = 'product_id_example'; // string

try {
    $result = $apiInstance->getStock($sku, $product_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling MultiInventoryApi->getStock: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **sku** | **string**|  | [optional] |
| **product_id** | **string**|  | [optional] |

### Return type

**object**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postStock()`

```php
postStock($stock, $inventory, $sku, $product_id)
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Woocommerce\Api\MultiInventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$stock = 56; // int | New stock level
$inventory = 56; // int | Inventory ID
$sku = 'sku_example'; // string | SKU
$product_id = 'product_id_example'; // string | product ID

try {
    $apiInstance->postStock($stock, $inventory, $sku, $product_id);
} catch (Exception $e) {
    echo 'Exception when calling MultiInventoryApi->postStock: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock** | **int**| New stock level | |
| **inventory** | **int**| Inventory ID | |
| **sku** | **string**| SKU | [optional] |
| **product_id** | **string**| product ID | [optional] |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
