# OpenAPIClient-php

Woocommerce v3.0 API See
https://woocommerce.github.io/woocommerce-rest-api-docs/#introduction


## Installation & Usage

### Requirements

PHP 7.4 and later.
Should also work with PHP 8.0.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/woocommerce.git"
    }
  ],
  "require": {
    "talisman/woocommerce": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');




$apiInstance = new Woocommerce\Api\CustomerApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$body = new \Woocommerce\Model\Customer(); // \Woocommerce\Model\Customer

try {
    $result = $apiInstance->createCustomer($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerApi->createCustomer: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://example.com/wp-json/wc/v3*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CustomerApi* | [**createCustomer**](docs/Api/CustomerApi.md#createcustomer) | **POST** /customers | Create a customer
*CustomerApi* | [**deleteCustomer**](docs/Api/CustomerApi.md#deletecustomer) | **DELETE** /customers/{id} | Delete a customer
*CustomerApi* | [**getCustomer**](docs/Api/CustomerApi.md#getcustomer) | **GET** /customers/{id} | Retrieve a customer
*CustomerApi* | [**getCustomers**](docs/Api/CustomerApi.md#getcustomers) | **GET** /customers | List all customers
*CustomerApi* | [**updateCustomer**](docs/Api/CustomerApi.md#updatecustomer) | **PUT** /customers/{id} | Update a customer
*MultiInventoryApi* | [**getInventories**](docs/Api/MultiInventoryApi.md#getinventories) | **GET** /inventories | Your GET endpoint
*MultiInventoryApi* | [**getStock**](docs/Api/MultiInventoryApi.md#getstock) | **GET** /stock | Your GET endpoint
*MultiInventoryApi* | [**postStock**](docs/Api/MultiInventoryApi.md#poststock) | **POST** /stock | 
*OrderApi* | [**createOrder**](docs/Api/OrderApi.md#createorder) | **POST** /orders | Create an order
*OrderApi* | [**deleteOrder**](docs/Api/OrderApi.md#deleteorder) | **DELETE** /orders/{id} | Delete an order
*OrderApi* | [**getOrder**](docs/Api/OrderApi.md#getorder) | **GET** /orders/{id} | Retrieve an order
*OrderApi* | [**getOrders**](docs/Api/OrderApi.md#getorders) | **GET** /orders | List all orders
*OrderApi* | [**updateOrder**](docs/Api/OrderApi.md#updateorder) | **PUT** /orders/{id} | Create an order
*OrderNotesApi* | [**createOrderNote**](docs/Api/OrderNotesApi.md#createordernote) | **POST** /orders/{id}/notes | Create a new note for an order
*OrderNotesApi* | [**deleteOrderNote**](docs/Api/OrderNotesApi.md#deleteordernote) | **DELETE** /orders/{id}/notes/{note_id} | Delete an order note
*OrderNotesApi* | [**getOrderNote**](docs/Api/OrderNotesApi.md#getordernote) | **GET** /orders/{id}/notes/{note_id} | Retrieve and view a specific note from an order
*OrderNotesApi* | [**getOrderNotes**](docs/Api/OrderNotesApi.md#getordernotes) | **GET** /orders/{id}/notes | View all the notes from an order
*ProductApi* | [**createProduct**](docs/Api/ProductApi.md#createproduct) | **POST** /products | Create a product
*ProductApi* | [**deleteProduct**](docs/Api/ProductApi.md#deleteproduct) | **DELETE** /products/{id} | Delete a product
*ProductApi* | [**getProduct**](docs/Api/ProductApi.md#getproduct) | **GET** /products/{id} | Retrieve a product
*ProductApi* | [**getProducts**](docs/Api/ProductApi.md#getproducts) | **GET** /products | List all products
*ProductApi* | [**updateProduct**](docs/Api/ProductApi.md#updateproduct) | **PUT** /products/{id} | Update a product
*ProductAttributeApi* | [**createProductAttribute**](docs/Api/ProductAttributeApi.md#createproductattribute) | **POST** /products/attributes | Create a product attribute
*ProductAttributeApi* | [**deleteProductAttribute**](docs/Api/ProductAttributeApi.md#deleteproductattribute) | **DELETE** /products/attributes/{id} | Delete a product attribute
*ProductAttributeApi* | [**getProductAttribute**](docs/Api/ProductAttributeApi.md#getproductattribute) | **GET** /products/attributes/{id} | Retrieve a product attribute
*ProductAttributeApi* | [**getProductAttributes**](docs/Api/ProductAttributeApi.md#getproductattributes) | **GET** /products/attributes | List all product attributes
*ProductAttributeApi* | [**updateProductAttirbiute**](docs/Api/ProductAttributeApi.md#updateproductattirbiute) | **PUT** /products/attributes/{id} | Update a product attribute
*ProductCategoryApi* | [**createProductCategory**](docs/Api/ProductCategoryApi.md#createproductcategory) | **POST** /products/categories | Create a product category
*ProductCategoryApi* | [**deleteProductCategory**](docs/Api/ProductCategoryApi.md#deleteproductcategory) | **DELETE** /products/categories/{id} | Delete a product category
*ProductCategoryApi* | [**getProductCategories**](docs/Api/ProductCategoryApi.md#getproductcategories) | **GET** /products/categories | List all product categories
*ProductCategoryApi* | [**getProductCategory**](docs/Api/ProductCategoryApi.md#getproductcategory) | **GET** /products/categories/{id} | Retrieve a product category
*ProductCategoryApi* | [**updateProductCategory**](docs/Api/ProductCategoryApi.md#updateproductcategory) | **PUT** /products/categories/{id} | Update a product category
*ProductTagsApi* | [**createProductsTag**](docs/Api/ProductTagsApi.md#createproductstag) | **POST** /products/tags | 
*ProductTagsApi* | [**deleteProductsTag**](docs/Api/ProductTagsApi.md#deleteproductstag) | **DELETE** /products/tags/{id} | 
*ProductTagsApi* | [**getProductsTag**](docs/Api/ProductTagsApi.md#getproductstag) | **GET** /products/tags/{id} | Your GET endpoint
*ProductTagsApi* | [**getProductsTags**](docs/Api/ProductTagsApi.md#getproductstags) | **GET** /products/tags | 
*ProductTagsApi* | [**updateProductsTag**](docs/Api/ProductTagsApi.md#updateproductstag) | **POST** /products/tags/{id} | 
*ProductTagsApi* | [**updateProductsTags**](docs/Api/ProductTagsApi.md#updateproductstags) | **POST** /products/tags/batch | 
*ProductVariationApi* | [**batchUpdateProductVariations**](docs/Api/ProductVariationApi.md#batchupdateproductvariations) | **POST** /products/{product_id}/variations/batch | Batch update product variations
*ProductVariationApi* | [**createProductVariantion**](docs/Api/ProductVariationApi.md#createproductvariantion) | **PUT** /products/{id}/variations | Create a product variation
*ProductVariationApi* | [**deleteProductVariation**](docs/Api/ProductVariationApi.md#deleteproductvariation) | **DELETE** /products/{product_id}/variations/{id} | Delete a product variation
*ProductVariationApi* | [**getProductVariation**](docs/Api/ProductVariationApi.md#getproductvariation) | **GET** /products/{product_id}/variations/{id} | Retrieve a product variation
*ProductVariationApi* | [**getProductVariations**](docs/Api/ProductVariationApi.md#getproductvariations) | **GET** /products/{id}/variations | List all product variations
*ProductVariationApi* | [**updateProductVariation**](docs/Api/ProductVariationApi.md#updateproductvariation) | **PUT** /products/{product_id}/variations/{id} | Update a product variation
*RefundApi* | [**createRefund**](docs/Api/RefundApi.md#createrefund) | **POST** /orders/{id}/refunds | Create a refund
*RefundApi* | [**deleteRefund**](docs/Api/RefundApi.md#deleterefund) | **DELETE** /orders/{id}/refunds/{refund_id} | Delete a refund
*RefundApi* | [**getRefund**](docs/Api/RefundApi.md#getrefund) | **GET** /orders/{id}/refunds/{refund_id} | Retrieve a refund
*RefundApi* | [**getRefunds**](docs/Api/RefundApi.md#getrefunds) | **GET** /orders/{id}/refunds | List all refunds
*SettingsApi* | [**getSettingOption**](docs/Api/SettingsApi.md#getsettingoption) | **GET** /settings/{group_id}/{id} | Retrieve a setting option
*SettingsApi* | [**getSettingOptions**](docs/Api/SettingsApi.md#getsettingoptions) | **GET** /settings/{id} | List all setting options
*SettingsApi* | [**getSettingsGroups**](docs/Api/SettingsApi.md#getsettingsgroups) | **GET** /settings | List all settings groups
*SettingsApi* | [**updateSettingOption**](docs/Api/SettingsApi.md#updatesettingoption) | **PUT** /settings/{group_id}/{id} | Update a setting option
*ShipmentApi* | [**createShipment**](docs/Api/ShipmentApi.md#createshipment) | **POST** /orders/{id}/shipment-trackings | Create a shipment tracking
*ShipmentApi* | [**deleteShipment**](docs/Api/ShipmentApi.md#deleteshipment) | **DELETE** /orders/{id}/shipment-trackings/{shipment_id} | Delete a shipment tracking
*ShipmentApi* | [**getShipment**](docs/Api/ShipmentApi.md#getshipment) | **GET** /orders/{id}/shipment-trackings/{shipment_id} | Retrieve a shipment tracking
*ShipmentApi* | [**getShipmentProviders**](docs/Api/ShipmentApi.md#getshipmentproviders) | **GET** /shipment-trackings/providers | List all shipment providers
*ShipmentApi* | [**getShipments**](docs/Api/ShipmentApi.md#getshipments) | **GET** /orders/{id}/shipment-trackings | List all shipment trackings
*ShipmentApi* | [**listShipmentProviders**](docs/Api/ShipmentApi.md#listshipmentproviders) | **GET** /orders/shipment-trackings/providers | List all shipment tracking providers
*SystemStatusApi* | [**getSystemStatus**](docs/Api/SystemStatusApi.md#getsystemstatus) | **GET** /system_status | List all system status items
*TaxClassApi* | [**createTaxClass**](docs/Api/TaxClassApi.md#createtaxclass) | **POST** /taxes/classes | Create a tax class
*TaxClassApi* | [**deleteTaxClass**](docs/Api/TaxClassApi.md#deletetaxclass) | **DELETE** /taxes/classes/{slug} | Delete a tax class
*TaxClassApi* | [**getTaxClasses**](docs/Api/TaxClassApi.md#gettaxclasses) | **GET** /taxes/classes | List all tax classes
*TaxRateApi* | [**createTaxRate**](docs/Api/TaxRateApi.md#createtaxrate) | **POST** /taxes | Create a tax rate
*TaxRateApi* | [**deleteTaxRate**](docs/Api/TaxRateApi.md#deletetaxrate) | **DELETE** /taxes/{id} | Delete a tax rate
*TaxRateApi* | [**getTaxRate**](docs/Api/TaxRateApi.md#gettaxrate) | **GET** /taxes/{id} | Retrieve a tax rate
*TaxRateApi* | [**getTaxRates**](docs/Api/TaxRateApi.md#gettaxrates) | **GET** /taxes | List all tax rates
*TaxRateApi* | [**updateTaxRate**](docs/Api/TaxRateApi.md#updatetaxrate) | **PUT** /taxes/{id} | Update a tax rate
*WebhooksApi* | [**createWebhook**](docs/Api/WebhooksApi.md#createwebhook) | **POST** /webhooks | Create a webhook
*WebhooksApi* | [**deleteWebhook**](docs/Api/WebhooksApi.md#deletewebhook) | **DELETE** /webhooks/{id} | Delete a webhook
*WebhooksApi* | [**getWebhook**](docs/Api/WebhooksApi.md#getwebhook) | **GET** /webhooks/{id} | Retrieve a webhook
*WebhooksApi* | [**getWebhooks**](docs/Api/WebhooksApi.md#getwebhooks) | **GET** /webhooks | List all webhooks
*WebhooksApi* | [**updateWebhook**](docs/Api/WebhooksApi.md#updatewebhook) | **PUT** /webhooks/{id} | Update a webhook

## Models

- [Address](docs/Model/Address.md)
- [Attribute](docs/Model/Attribute.md)
- [Category](docs/Model/Category.md)
- [CouponLine](docs/Model/CouponLine.md)
- [CreateOrderNoteRequest](docs/Model/CreateOrderNoteRequest.md)
- [Customer](docs/Model/Customer.md)
- [Database](docs/Model/Database.md)
- [DatabaseDatabaseTables](docs/Model/DatabaseDatabaseTables.md)
- [DefaultAttribute](docs/Model/DefaultAttribute.md)
- [Dimension](docs/Model/Dimension.md)
- [Download](docs/Model/Download.md)
- [Environment](docs/Model/Environment.md)
- [FeeLine](docs/Model/FeeLine.md)
- [Image](docs/Model/Image.md)
- [Inventories](docs/Model/Inventories.md)
- [Inventory](docs/Model/Inventory.md)
- [LineItem](docs/Model/LineItem.md)
- [Links](docs/Model/Links.md)
- [LinksSelfInner](docs/Model/LinksSelfInner.md)
- [Metadata](docs/Model/Metadata.md)
- [Order](docs/Model/Order.md)
- [OrderNote](docs/Model/OrderNote.md)
- [Page](docs/Model/Page.md)
- [Plugin](docs/Model/Plugin.md)
- [Product](docs/Model/Product.md)
- [ProductAttribute](docs/Model/ProductAttribute.md)
- [ProductCategory](docs/Model/ProductCategory.md)
- [ProductTag](docs/Model/ProductTag.md)
- [ProductTagsBatch](docs/Model/ProductTagsBatch.md)
- [ProductVariation](docs/Model/ProductVariation.md)
- [ProductVariationAttributesInner](docs/Model/ProductVariationAttributesInner.md)
- [ProductVariationBatch](docs/Model/ProductVariationBatch.md)
- [ProductVariationDimensions](docs/Model/ProductVariationDimensions.md)
- [Refund](docs/Model/Refund.md)
- [RefundLine](docs/Model/RefundLine.md)
- [Security](docs/Model/Security.md)
- [Settings](docs/Model/Settings.md)
- [SettingsGroup](docs/Model/SettingsGroup.md)
- [SettingsOption](docs/Model/SettingsOption.md)
- [SettingsOptionOptions](docs/Model/SettingsOptionOptions.md)
- [SettingsTaxonomies](docs/Model/SettingsTaxonomies.md)
- [Shipment](docs/Model/Shipment.md)
- [ShippingLine](docs/Model/ShippingLine.md)
- [Stock](docs/Model/Stock.md)
- [SystemStatus](docs/Model/SystemStatus.md)
- [Tag](docs/Model/Tag.md)
- [Tax](docs/Model/Tax.md)
- [TaxClass](docs/Model/TaxClass.md)
- [TaxLine](docs/Model/TaxLine.md)
- [TaxRate](docs/Model/TaxRate.md)
- [Theme](docs/Model/Theme.md)
- [Value](docs/Model/Value.md)
- [Webhook](docs/Model/Webhook.md)
- [WebhookDetails](docs/Model/WebhookDetails.md)

## Authorization
Endpoints do not require authorization.

## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `3.0`
    - Package version: `3.0`
    - Generator version: `7.5.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
