<?php

namespace Visualsoft;

class WebOrderType
{

    /**
     * @var OrderDetailsType $ORDER
     */
    protected $ORDER = null;

    /**
     * @var CustomerType $CUSTOMER
     */
    protected $CUSTOMER = null;

    /**
     * @var OrderProductsContainerType $PRODUCTS
     */
    protected $PRODUCTS = null;

    /**
     * @var PaymentType $PAYMENT
     */
    protected $PAYMENT = null;

    /**
     * @var TransactionBreakdownType $TRANSACTION_BREAKDOWN
     */
    protected $TRANSACTION_BREAKDOWN = null;

    /**
     * @var DiscountsContainerType $DISCOUNTS
     */
    protected $DISCOUNTS = null;

    /**
     * @var CollectPlusType $COLLECTPLUS
     */
    protected $COLLECTPLUS = null;

    /**
     * @var OrderTagsType $ORDER_TAGS
     */
    protected $ORDER_TAGS = null;

    /**
     * @param OrderDetailsType $ORDER
     * @param CustomerType $CUSTOMER
     * @param OrderProductsContainerType $PRODUCTS
     * @param PaymentType $PAYMENT
     * @param TransactionBreakdownType $TRANSACTION_BREAKDOWN
     */
    public function __construct($ORDER, $CUSTOMER, $PRODUCTS, $PAYMENT, $TRANSACTION_BREAKDOWN)
    {
      $this->ORDER = $ORDER;
      $this->CUSTOMER = $CUSTOMER;
      $this->PRODUCTS = $PRODUCTS;
      $this->PAYMENT = $PAYMENT;
      $this->TRANSACTION_BREAKDOWN = $TRANSACTION_BREAKDOWN;
    }

    /**
     * @return OrderDetailsType
     */
    public function getORDER()
    {
      return $this->ORDER;
    }

    /**
     * @param OrderDetailsType $ORDER
     * @return \Visualsoft\WebOrderType
     */
    public function setORDER($ORDER)
    {
      $this->ORDER = $ORDER;
      return $this;
    }

    /**
     * @return CustomerType
     */
    public function getCUSTOMER()
    {
      return $this->CUSTOMER;
    }

    /**
     * @param CustomerType $CUSTOMER
     * @return \Visualsoft\WebOrderType
     */
    public function setCUSTOMER($CUSTOMER)
    {
      $this->CUSTOMER = $CUSTOMER;
      return $this;
    }

    /**
     * @return OrderProductsContainerType
     */
    public function getPRODUCTS()
    {
      return $this->PRODUCTS;
    }

    /**
     * @param OrderProductsContainerType $PRODUCTS
     * @return \Visualsoft\WebOrderType
     */
    public function setPRODUCTS($PRODUCTS)
    {
      $this->PRODUCTS = $PRODUCTS;
      return $this;
    }

    /**
     * @return PaymentType
     */
    public function getPAYMENT()
    {
      return $this->PAYMENT;
    }

    /**
     * @param PaymentType $PAYMENT
     * @return \Visualsoft\WebOrderType
     */
    public function setPAYMENT($PAYMENT)
    {
      $this->PAYMENT = $PAYMENT;
      return $this;
    }

    /**
     * @return TransactionBreakdownType
     */
    public function getTRANSACTION_BREAKDOWN()
    {
      return $this->TRANSACTION_BREAKDOWN;
    }

    /**
     * @param TransactionBreakdownType $TRANSACTION_BREAKDOWN
     * @return \Visualsoft\WebOrderType
     */
    public function setTRANSACTION_BREAKDOWN($TRANSACTION_BREAKDOWN)
    {
      $this->TRANSACTION_BREAKDOWN = $TRANSACTION_BREAKDOWN;
      return $this;
    }

    /**
     * @return DiscountsContainerType
     */
    public function getDISCOUNTS()
    {
      return $this->DISCOUNTS;
    }

    /**
     * @param DiscountsContainerType $DISCOUNTS
     * @return \Visualsoft\WebOrderType
     */
    public function setDISCOUNTS($DISCOUNTS)
    {
      $this->DISCOUNTS = $DISCOUNTS;
      return $this;
    }

    /**
     * @return CollectPlusType
     */
    public function getCOLLECTPLUS()
    {
      return $this->COLLECTPLUS;
    }

    /**
     * @param CollectPlusType $COLLECTPLUS
     * @return \Visualsoft\WebOrderType
     */
    public function setCOLLECTPLUS($COLLECTPLUS)
    {
      $this->COLLECTPLUS = $COLLECTPLUS;
      return $this;
    }

    /**
     * @return OrderTagsType
     */
    public function getORDER_TAGS()
    {
      return $this->ORDER_TAGS;
    }

    /**
     * @param OrderTagsType $ORDER_TAGS
     * @return \Visualsoft\WebOrderType
     */
    public function setORDER_TAGS($ORDER_TAGS)
    {
      $this->ORDER_TAGS = $ORDER_TAGS;
      return $this;
    }

}
