<?php

namespace Visualsoft;

class SubProductType
{

    /**
     * @var int $PRODUCT_ID
     */
    protected $PRODUCT_ID = null;

    /**
     * @var NonEmptyStringType $REFERENCE
     */
    protected $REFERENCE = null;

    /**
     * @var AttributesType $ATTRIBUTES
     */
    protected $ATTRIBUTES = null;

    /**
     * @var string $TITLE
     */
    protected $TITLE = null;

    /**
     * @var boolean $ACTIVE
     */
    protected $ACTIVE = null;

    /**
     * @var boolean $DELETE
     */
    protected $DELETE = null;

    /**
     * @var int $STOCK
     */
    protected $STOCK = null;

    /**
     * @var StockLocationsType $STOCK_LOCATIONS
     */
    protected $STOCK_LOCATIONS = null;

    /**
     * @var string $SUPPLIER
     */
    protected $SUPPLIER = null;

    /**
     * @var string $WEIGHT
     */
    protected $WEIGHT = null;

    /**
     * @var string $MODEL
     */
    protected $MODEL = null;

    /**
     * @var string $EAN
     */
    protected $EAN = null;

    /**
     * @var string $MPN
     */
    protected $MPN = null;

    /**
     * @var string $ISBN
     */
    protected $ISBN = null;

    /**
     * @var string $UNIT_OF_MEASURE
     */
    protected $UNIT_OF_MEASURE = null;

    /**
     * @var string $RELEASE_DATE
     */
    protected $RELEASE_DATE = null;

    /**
     * @var string $DEPOSIT_AVAILABLE_NOW
     */
    protected $DEPOSIT_AVAILABLE_NOW = null;

    /**
     * @var string $UPC
     */
    protected $UPC = null;

    /**
     * @var string $PRICE
     */
    protected $PRICE = null;

    /**
     * @var string $SALE_PRICE
     */
    protected $SALE_PRICE = null;

    /**
     * @var string $DEPOSIT_PRICE
     */
    protected $DEPOSIT_PRICE = null;

    /**
     * @var string $RRP_PRICE
     */
    protected $RRP_PRICE = null;

    /**
     * @var string $BUY_PRICE
     */
    protected $BUY_PRICE = null;

    /**
     * @var string $COST_PRICE
     */
    protected $COST_PRICE = null;

    /**
     * @var string $BUY_LIST_PRICE
     */
    protected $BUY_LIST_PRICE = null;

    /**
     * @var float $VAT_RATE
     */
    protected $VAT_RATE = null;

    /**
     * @var boolean $DISPLAY_ON_SALE_PAGE
     */
    protected $DISPLAY_ON_SALE_PAGE = null;

    /**
     * @var string $MAXIMUM_QUANTITY
     */
    protected $MAXIMUM_QUANTITY = null;

    /**
     * @var string $HIDE_PRICE
     */
    protected $HIDE_PRICE = null;

    /**
     * @var string $VAT_RELIEF
     */
    protected $VAT_RELIEF = null;

    /**
     * @var ImagesType $IMAGES
     */
    protected $IMAGES = null;

    /**
     * @var ProductDimensionsType $PRODUCT_DIMENSIONS
     */
    protected $PRODUCT_DIMENSIONS = null;

    /**
     * @var PackDimensionsType $PACK_DIMENSIONS
     */
    protected $PACK_DIMENSIONS = null;

    /**
     * @var string $PACK_QUANTITY
     */
    protected $PACK_QUANTITY = null;

    /**
     * @var string $SHIPPING_VOLUME
     */
    protected $SHIPPING_VOLUME = null;

    /**
     * @var string $PICK_LOCATION
     */
    protected $PICK_LOCATION = null;

    /**
     * @var string $STOCK_MESSAGE
     */
    protected $STOCK_MESSAGE = null;

    /**
     * @var string $STOCK_STATUS
     */
    protected $STOCK_STATUS = null;

    /**
     * @var string $ZERO_LEVEL_STOCK_MESSAGE
     */
    protected $ZERO_LEVEL_STOCK_MESSAGE = null;

    /**
     * @var string $PRODUCT_OPTION
     */
    protected $PRODUCT_OPTION = null;

    /**
     * @var string $COMMODITY_CODE
     */
    protected $COMMODITY_CODE = null;

    /**
     * @var string $COUNTRY_OF_ORIGIN
     */
    protected $COUNTRY_OF_ORIGIN = null;

    /**
     * @var string $CUSTOMS_DESCRIPTION
     */
    protected $CUSTOMS_DESCRIPTION = null;

    /**
     * @param NonEmptyStringType $REFERENCE
     */
    public function __construct($REFERENCE)
    {
      $this->REFERENCE = $REFERENCE;
    }

    /**
     * @return int
     */
    public function getPRODUCT_ID()
    {
      return $this->PRODUCT_ID;
    }

    /**
     * @param int $PRODUCT_ID
     * @return \Visualsoft\SubProductType
     */
    public function setPRODUCT_ID($PRODUCT_ID)
    {
      $this->PRODUCT_ID = $PRODUCT_ID;
      return $this;
    }

    /**
     * @return NonEmptyStringType
     */
    public function getREFERENCE()
    {
      return $this->REFERENCE;
    }

    /**
     * @param NonEmptyStringType $REFERENCE
     * @return \Visualsoft\SubProductType
     */
    public function setREFERENCE($REFERENCE)
    {
      $this->REFERENCE = $REFERENCE;
      return $this;
    }

    /**
     * @return AttributesType
     */
    public function getATTRIBUTES()
    {
      return $this->ATTRIBUTES;
    }

    /**
     * @param AttributesType $ATTRIBUTES
     * @return \Visualsoft\SubProductType
     */
    public function setATTRIBUTES($ATTRIBUTES)
    {
      $this->ATTRIBUTES = $ATTRIBUTES;
      return $this;
    }

    /**
     * @return string
     */
    public function getTITLE()
    {
      return $this->TITLE;
    }

    /**
     * @param string $TITLE
     * @return \Visualsoft\SubProductType
     */
    public function setTITLE($TITLE)
    {
      $this->TITLE = $TITLE;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getACTIVE()
    {
      return $this->ACTIVE;
    }

    /**
     * @param boolean $ACTIVE
     * @return \Visualsoft\SubProductType
     */
    public function setACTIVE($ACTIVE)
    {
      $this->ACTIVE = $ACTIVE;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getDELETE()
    {
      return $this->DELETE;
    }

    /**
     * @param boolean $DELETE
     * @return \Visualsoft\SubProductType
     */
    public function setDELETE($DELETE)
    {
      $this->DELETE = $DELETE;
      return $this;
    }

    /**
     * @return int
     */
    public function getSTOCK()
    {
      return $this->STOCK;
    }

    /**
     * @param int $STOCK
     * @return \Visualsoft\SubProductType
     */
    public function setSTOCK($STOCK)
    {
      $this->STOCK = $STOCK;
      return $this;
    }

    /**
     * @return StockLocationsType
     */
    public function getSTOCK_LOCATIONS()
    {
      return $this->STOCK_LOCATIONS;
    }

    /**
     * @param StockLocationsType $STOCK_LOCATIONS
     * @return \Visualsoft\SubProductType
     */
    public function setSTOCK_LOCATIONS($STOCK_LOCATIONS)
    {
      $this->STOCK_LOCATIONS = $STOCK_LOCATIONS;
      return $this;
    }

    /**
     * @return string
     */
    public function getSUPPLIER()
    {
      return $this->SUPPLIER;
    }

    /**
     * @param string $SUPPLIER
     * @return \Visualsoft\SubProductType
     */
    public function setSUPPLIER($SUPPLIER)
    {
      $this->SUPPLIER = $SUPPLIER;
      return $this;
    }

    /**
     * @return string
     */
    public function getWEIGHT()
    {
      return $this->WEIGHT;
    }

    /**
     * @param string $WEIGHT
     * @return \Visualsoft\SubProductType
     */
    public function setWEIGHT($WEIGHT)
    {
      $this->WEIGHT = $WEIGHT;
      return $this;
    }

    /**
     * @return string
     */
    public function getMODEL()
    {
      return $this->MODEL;
    }

    /**
     * @param string $MODEL
     * @return \Visualsoft\SubProductType
     */
    public function setMODEL($MODEL)
    {
      $this->MODEL = $MODEL;
      return $this;
    }

    /**
     * @return string
     */
    public function getEAN()
    {
      return $this->EAN;
    }

    /**
     * @param string $EAN
     * @return \Visualsoft\SubProductType
     */
    public function setEAN($EAN)
    {
      $this->EAN = $EAN;
      return $this;
    }

    /**
     * @return string
     */
    public function getMPN()
    {
      return $this->MPN;
    }

    /**
     * @param string $MPN
     * @return \Visualsoft\SubProductType
     */
    public function setMPN($MPN)
    {
      $this->MPN = $MPN;
      return $this;
    }

    /**
     * @return string
     */
    public function getISBN()
    {
      return $this->ISBN;
    }

    /**
     * @param string $ISBN
     * @return \Visualsoft\SubProductType
     */
    public function setISBN($ISBN)
    {
      $this->ISBN = $ISBN;
      return $this;
    }

    /**
     * @return string
     */
    public function getUNIT_OF_MEASURE()
    {
      return $this->UNIT_OF_MEASURE;
    }

    /**
     * @param string $UNIT_OF_MEASURE
     * @return \Visualsoft\SubProductType
     */
    public function setUNIT_OF_MEASURE($UNIT_OF_MEASURE)
    {
      $this->UNIT_OF_MEASURE = $UNIT_OF_MEASURE;
      return $this;
    }

    /**
     * @return string
     */
    public function getRELEASE_DATE()
    {
      return $this->RELEASE_DATE;
    }

    /**
     * @param string $RELEASE_DATE
     * @return \Visualsoft\SubProductType
     */
    public function setRELEASE_DATE($RELEASE_DATE)
    {
      $this->RELEASE_DATE = $RELEASE_DATE;
      return $this;
    }

    /**
     * @return string
     */
    public function getDEPOSIT_AVAILABLE_NOW()
    {
      return $this->DEPOSIT_AVAILABLE_NOW;
    }

    /**
     * @param string $DEPOSIT_AVAILABLE_NOW
     * @return \Visualsoft\SubProductType
     */
    public function setDEPOSIT_AVAILABLE_NOW($DEPOSIT_AVAILABLE_NOW)
    {
      $this->DEPOSIT_AVAILABLE_NOW = $DEPOSIT_AVAILABLE_NOW;
      return $this;
    }

    /**
     * @return string
     */
    public function getUPC()
    {
      return $this->UPC;
    }

    /**
     * @param string $UPC
     * @return \Visualsoft\SubProductType
     */
    public function setUPC($UPC)
    {
      $this->UPC = $UPC;
      return $this;
    }

    /**
     * @return string
     */
    public function getPRICE()
    {
      return $this->PRICE;
    }

    /**
     * @param string $PRICE
     * @return \Visualsoft\SubProductType
     */
    public function setPRICE($PRICE)
    {
      $this->PRICE = $PRICE;
      return $this;
    }

    /**
     * @return string
     */
    public function getSALE_PRICE()
    {
      return $this->SALE_PRICE;
    }

    /**
     * @param string $SALE_PRICE
     * @return \Visualsoft\SubProductType
     */
    public function setSALE_PRICE($SALE_PRICE)
    {
      $this->SALE_PRICE = $SALE_PRICE;
      return $this;
    }

    /**
     * @return string
     */
    public function getDEPOSIT_PRICE()
    {
      return $this->DEPOSIT_PRICE;
    }

    /**
     * @param string $DEPOSIT_PRICE
     * @return \Visualsoft\SubProductType
     */
    public function setDEPOSIT_PRICE($DEPOSIT_PRICE)
    {
      $this->DEPOSIT_PRICE = $DEPOSIT_PRICE;
      return $this;
    }

    /**
     * @return string
     */
    public function getRRP_PRICE()
    {
      return $this->RRP_PRICE;
    }

    /**
     * @param string $RRP_PRICE
     * @return \Visualsoft\SubProductType
     */
    public function setRRP_PRICE($RRP_PRICE)
    {
      $this->RRP_PRICE = $RRP_PRICE;
      return $this;
    }

    /**
     * @return string
     */
    public function getBUY_PRICE()
    {
      return $this->BUY_PRICE;
    }

    /**
     * @param string $BUY_PRICE
     * @return \Visualsoft\SubProductType
     */
    public function setBUY_PRICE($BUY_PRICE)
    {
      $this->BUY_PRICE = $BUY_PRICE;
      return $this;
    }

    /**
     * @return string
     */
    public function getCOST_PRICE()
    {
      return $this->COST_PRICE;
    }

    /**
     * @param string $COST_PRICE
     * @return \Visualsoft\SubProductType
     */
    public function setCOST_PRICE($COST_PRICE)
    {
      $this->COST_PRICE = $COST_PRICE;
      return $this;
    }

    /**
     * @return string
     */
    public function getBUY_LIST_PRICE()
    {
      return $this->BUY_LIST_PRICE;
    }

    /**
     * @param string $BUY_LIST_PRICE
     * @return \Visualsoft\SubProductType
     */
    public function setBUY_LIST_PRICE($BUY_LIST_PRICE)
    {
      $this->BUY_LIST_PRICE = $BUY_LIST_PRICE;
      return $this;
    }

    /**
     * @return float
     */
    public function getVAT_RATE()
    {
      return $this->VAT_RATE;
    }

    /**
     * @param float $VAT_RATE
     * @return \Visualsoft\SubProductType
     */
    public function setVAT_RATE($VAT_RATE)
    {
      $this->VAT_RATE = $VAT_RATE;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getDISPLAY_ON_SALE_PAGE()
    {
      return $this->DISPLAY_ON_SALE_PAGE;
    }

    /**
     * @param boolean $DISPLAY_ON_SALE_PAGE
     * @return \Visualsoft\SubProductType
     */
    public function setDISPLAY_ON_SALE_PAGE($DISPLAY_ON_SALE_PAGE)
    {
      $this->DISPLAY_ON_SALE_PAGE = $DISPLAY_ON_SALE_PAGE;
      return $this;
    }

    /**
     * @return string
     */
    public function getMAXIMUM_QUANTITY()
    {
      return $this->MAXIMUM_QUANTITY;
    }

    /**
     * @param string $MAXIMUM_QUANTITY
     * @return \Visualsoft\SubProductType
     */
    public function setMAXIMUM_QUANTITY($MAXIMUM_QUANTITY)
    {
      $this->MAXIMUM_QUANTITY = $MAXIMUM_QUANTITY;
      return $this;
    }

    /**
     * @return string
     */
    public function getHIDE_PRICE()
    {
      return $this->HIDE_PRICE;
    }

    /**
     * @param string $HIDE_PRICE
     * @return \Visualsoft\SubProductType
     */
    public function setHIDE_PRICE($HIDE_PRICE)
    {
      $this->HIDE_PRICE = $HIDE_PRICE;
      return $this;
    }

    /**
     * @return string
     */
    public function getVAT_RELIEF()
    {
      return $this->VAT_RELIEF;
    }

    /**
     * @param string $VAT_RELIEF
     * @return \Visualsoft\SubProductType
     */
    public function setVAT_RELIEF($VAT_RELIEF)
    {
      $this->VAT_RELIEF = $VAT_RELIEF;
      return $this;
    }

    /**
     * @return ImagesType
     */
    public function getIMAGES()
    {
      return $this->IMAGES;
    }

    /**
     * @param ImagesType $IMAGES
     * @return \Visualsoft\SubProductType
     */
    public function setIMAGES($IMAGES)
    {
      $this->IMAGES = $IMAGES;
      return $this;
    }

    /**
     * @return ProductDimensionsType
     */
    public function getPRODUCT_DIMENSIONS()
    {
      return $this->PRODUCT_DIMENSIONS;
    }

    /**
     * @param ProductDimensionsType $PRODUCT_DIMENSIONS
     * @return \Visualsoft\SubProductType
     */
    public function setPRODUCT_DIMENSIONS($PRODUCT_DIMENSIONS)
    {
      $this->PRODUCT_DIMENSIONS = $PRODUCT_DIMENSIONS;
      return $this;
    }

    /**
     * @return PackDimensionsType
     */
    public function getPACK_DIMENSIONS()
    {
      return $this->PACK_DIMENSIONS;
    }

    /**
     * @param PackDimensionsType $PACK_DIMENSIONS
     * @return \Visualsoft\SubProductType
     */
    public function setPACK_DIMENSIONS($PACK_DIMENSIONS)
    {
      $this->PACK_DIMENSIONS = $PACK_DIMENSIONS;
      return $this;
    }

    /**
     * @return string
     */
    public function getPACK_QUANTITY()
    {
      return $this->PACK_QUANTITY;
    }

    /**
     * @param string $PACK_QUANTITY
     * @return \Visualsoft\SubProductType
     */
    public function setPACK_QUANTITY($PACK_QUANTITY)
    {
      $this->PACK_QUANTITY = $PACK_QUANTITY;
      return $this;
    }

    /**
     * @return string
     */
    public function getSHIPPING_VOLUME()
    {
      return $this->SHIPPING_VOLUME;
    }

    /**
     * @param string $SHIPPING_VOLUME
     * @return \Visualsoft\SubProductType
     */
    public function setSHIPPING_VOLUME($SHIPPING_VOLUME)
    {
      $this->SHIPPING_VOLUME = $SHIPPING_VOLUME;
      return $this;
    }

    /**
     * @return string
     */
    public function getPICK_LOCATION()
    {
      return $this->PICK_LOCATION;
    }

    /**
     * @param string $PICK_LOCATION
     * @return \Visualsoft\SubProductType
     */
    public function setPICK_LOCATION($PICK_LOCATION)
    {
      $this->PICK_LOCATION = $PICK_LOCATION;
      return $this;
    }

    /**
     * @return string
     */
    public function getSTOCK_MESSAGE()
    {
      return $this->STOCK_MESSAGE;
    }

    /**
     * @param string $STOCK_MESSAGE
     * @return \Visualsoft\SubProductType
     */
    public function setSTOCK_MESSAGE($STOCK_MESSAGE)
    {
      $this->STOCK_MESSAGE = $STOCK_MESSAGE;
      return $this;
    }

    /**
     * @return string
     */
    public function getSTOCK_STATUS()
    {
      return $this->STOCK_STATUS;
    }

    /**
     * @param string $STOCK_STATUS
     * @return \Visualsoft\SubProductType
     */
    public function setSTOCK_STATUS($STOCK_STATUS)
    {
      $this->STOCK_STATUS = $STOCK_STATUS;
      return $this;
    }

    /**
     * @return string
     */
    public function getZERO_LEVEL_STOCK_MESSAGE()
    {
      return $this->ZERO_LEVEL_STOCK_MESSAGE;
    }

    /**
     * @param string $ZERO_LEVEL_STOCK_MESSAGE
     * @return \Visualsoft\SubProductType
     */
    public function setZERO_LEVEL_STOCK_MESSAGE($ZERO_LEVEL_STOCK_MESSAGE)
    {
      $this->ZERO_LEVEL_STOCK_MESSAGE = $ZERO_LEVEL_STOCK_MESSAGE;
      return $this;
    }

    /**
     * @return string
     */
    public function getPRODUCT_OPTION()
    {
      return $this->PRODUCT_OPTION;
    }

    /**
     * @param string $PRODUCT_OPTION
     * @return \Visualsoft\SubProductType
     */
    public function setPRODUCT_OPTION($PRODUCT_OPTION)
    {
      $this->PRODUCT_OPTION = $PRODUCT_OPTION;
      return $this;
    }

    /**
     * @return string
     */
    public function getCOMMODITY_CODE()
    {
      return $this->COMMODITY_CODE;
    }

    /**
     * @param string $COMMODITY_CODE
     * @return \Visualsoft\SubProductType
     */
    public function setCOMMODITY_CODE($COMMODITY_CODE)
    {
      $this->COMMODITY_CODE = $COMMODITY_CODE;
      return $this;
    }

    /**
     * @return string
     */
    public function getCOUNTRY_OF_ORIGIN()
    {
      return $this->COUNTRY_OF_ORIGIN;
    }

    /**
     * @param string $COUNTRY_OF_ORIGIN
     * @return \Visualsoft\SubProductType
     */
    public function setCOUNTRY_OF_ORIGIN($COUNTRY_OF_ORIGIN)
    {
      $this->COUNTRY_OF_ORIGIN = $COUNTRY_OF_ORIGIN;
      return $this;
    }

    /**
     * @return string
     */
    public function getCUSTOMS_DESCRIPTION()
    {
      return $this->CUSTOMS_DESCRIPTION;
    }

    /**
     * @param string $CUSTOMS_DESCRIPTION
     * @return \Visualsoft\SubProductType
     */
    public function setCUSTOMS_DESCRIPTION($CUSTOMS_DESCRIPTION)
    {
      $this->CUSTOMS_DESCRIPTION = $CUSTOMS_DESCRIPTION;
      return $this;
    }

}
