<?php

namespace Visualsoft;

class STOCK
{

    /**
     * @var int $STOCK_LEVEL
     */
    protected $STOCK_LEVEL = null;

    /**
     * @var int $OLD_STOCK_LEVEL
     */
    protected $OLD_STOCK_LEVEL = null;

    /**
     * @var int $NEW_STOCK_LEVEL
     */
    protected $NEW_STOCK_LEVEL = null;

    /**
     * @var NonEmptyStringType $LAST_MODIFIED
     */
    protected $LAST_MODIFIED = null;

    /**
     * @var NonEmptyStringType $REFERENCE
     */
    protected $REFERENCE = null;

    /**
     * @param int $STOCK_LEVEL
     * @param int $OLD_STOCK_LEVEL
     * @param int $NEW_STOCK_LEVEL
     * @param NonEmptyStringType $LAST_MODIFIED
     * @param NonEmptyStringType $REFERENCE
     */
    public function __construct($STOCK_LEVEL, $OLD_STOCK_LEVEL, $NEW_STOCK_LEVEL, $LAST_MODIFIED, $REFERENCE)
    {
      $this->STOCK_LEVEL = $STOCK_LEVEL;
      $this->OLD_STOCK_LEVEL = $OLD_STOCK_LEVEL;
      $this->NEW_STOCK_LEVEL = $NEW_STOCK_LEVEL;
      $this->LAST_MODIFIED = $LAST_MODIFIED;
      $this->REFERENCE = $REFERENCE;
    }

    /**
     * @return int
     */
    public function getSTOCK_LEVEL()
    {
      return $this->STOCK_LEVEL;
    }

    /**
     * @param int $STOCK_LEVEL
     * @return \Visualsoft\STOCK
     */
    public function setSTOCK_LEVEL($STOCK_LEVEL)
    {
      $this->STOCK_LEVEL = $STOCK_LEVEL;
      return $this;
    }

    /**
     * @return int
     */
    public function getOLD_STOCK_LEVEL()
    {
      return $this->OLD_STOCK_LEVEL;
    }

    /**
     * @param int $OLD_STOCK_LEVEL
     * @return \Visualsoft\STOCK
     */
    public function setOLD_STOCK_LEVEL($OLD_STOCK_LEVEL)
    {
      $this->OLD_STOCK_LEVEL = $OLD_STOCK_LEVEL;
      return $this;
    }

    /**
     * @return int
     */
    public function getNEW_STOCK_LEVEL()
    {
      return $this->NEW_STOCK_LEVEL;
    }

    /**
     * @param int $NEW_STOCK_LEVEL
     * @return \Visualsoft\STOCK
     */
    public function setNEW_STOCK_LEVEL($NEW_STOCK_LEVEL)
    {
      $this->NEW_STOCK_LEVEL = $NEW_STOCK_LEVEL;
      return $this;
    }

    /**
     * @return NonEmptyStringType
     */
    public function getLAST_MODIFIED()
    {
      return $this->LAST_MODIFIED;
    }

    /**
     * @param NonEmptyStringType $LAST_MODIFIED
     * @return \Visualsoft\STOCK
     */
    public function setLAST_MODIFIED($LAST_MODIFIED)
    {
      $this->LAST_MODIFIED = $LAST_MODIFIED;
      return $this;
    }

    /**
     * @return NonEmptyStringType
     */
    public function getREFERENCE()
    {
      return $this->REFERENCE;
    }

    /**
     * @param NonEmptyStringType $REFERENCE
     * @return \Visualsoft\STOCK
     */
    public function setREFERENCE($REFERENCE)
    {
      $this->REFERENCE = $REFERENCE;
      return $this;
    }

}
