<?php

namespace Visualsoft;

class ResultType
{

    /**
     * @var int $ServiceVersion
     */
    protected $ServiceVersion = null;

    /**
     * @var int $RequestID
     */
    protected $RequestID = null;

    /**
     * @var \DateTime $DateTime
     */
    protected $DateTime = null;

    /**
     * @var ResultErrorsType $Errors
     */
    protected $Errors = null;

    /**
     * @var ResultWarningsType $Warnings
     */
    protected $Warnings = null;

    /**
     * @var Result $Result
     */
    protected $Result = null;

    /**
     * @param int $ServiceVersion
     * @param int $RequestID
     * @param \DateTime $DateTime
     * @param ResultErrorsType $Errors
     * @param ResultWarningsType $Warnings
     * @param Result $Result
     */
    public function __construct($ServiceVersion, $RequestID, \DateTime $DateTime, $Errors, $Warnings, $Result)
    {
      $this->ServiceVersion = $ServiceVersion;
      $this->RequestID = $RequestID;
      $this->DateTime = $DateTime->format(\DateTime::ATOM);
      $this->Errors = $Errors;
      $this->Warnings = $Warnings;
      $this->Result = $Result;
    }

    /**
     * @return int
     */
    public function getServiceVersion()
    {
      return $this->ServiceVersion;
    }

    /**
     * @param int $ServiceVersion
     * @return \Visualsoft\ResultType
     */
    public function setServiceVersion($ServiceVersion)
    {
      $this->ServiceVersion = $ServiceVersion;
      return $this;
    }

    /**
     * @return int
     */
    public function getRequestID()
    {
      return $this->RequestID;
    }

    /**
     * @param int $RequestID
     * @return \Visualsoft\ResultType
     */
    public function setRequestID($RequestID)
    {
      $this->RequestID = $RequestID;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDateTime()
    {
      if ($this->DateTime == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->DateTime);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $DateTime
     * @return \Visualsoft\ResultType
     */
    public function setDateTime(\DateTime $DateTime)
    {
      $this->DateTime = $DateTime->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return ResultErrorsType
     */
    public function getErrors()
    {
      return $this->Errors;
    }

    /**
     * @param ResultErrorsType $Errors
     * @return \Visualsoft\ResultType
     */
    public function setErrors($Errors)
    {
      $this->Errors = $Errors;
      return $this;
    }

    /**
     * @return ResultWarningsType
     */
    public function getWarnings()
    {
      return $this->Warnings;
    }

    /**
     * @param ResultWarningsType $Warnings
     * @return \Visualsoft\ResultType
     */
    public function setWarnings($Warnings)
    {
      $this->Warnings = $Warnings;
      return $this;
    }

    /**
     * @return Result
     */
    public function getResult()
    {
      return $this->Result;
    }

    /**
     * @param Result $Result
     * @return \Visualsoft\ResultType
     */
    public function setResult($Result)
    {
      $this->Result = $Result;
      return $this;
    }

}
