<?php

namespace Visualsoft;

class ProductType
{

    /**
     * @var int $PARENT_PRODUCT_ID
     */
    protected $PARENT_PRODUCT_ID = null;

    /**
     * @var NonEmptyStringType $REFERENCE
     */
    protected $REFERENCE = null;

    /**
     * @var string $TITLE
     */
    protected $TITLE = null;

    /**
     * @var string $BRAND
     */
    protected $BRAND = null;

    /**
     * @var string $MANUFACTURER_ORIGIN
     */
    protected $MANUFACTURER_ORIGIN = null;

    /**
     * @var string $COMMODITY_CODE
     */
    protected $COMMODITY_CODE = null;

    /**
     * @var string $SUBTITLE
     */
    protected $SUBTITLE = null;

    /**
     * @var string $SUMMARY
     */
    protected $SUMMARY = null;

    /**
     * @var string $DESCRIPTION
     */
    protected $DESCRIPTION = null;

    /**
     * @var string $SEO_TITLE
     */
    protected $SEO_TITLE = null;

    /**
     * @var string $SEO_DESCRIPTION
     */
    protected $SEO_DESCRIPTION = null;

    /**
     * @var string $SEO_KEYWORDS
     */
    protected $SEO_KEYWORDS = null;

    /**
     * @var string $SEO_NAME
     */
    protected $SEO_NAME = null;

    /**
     * @var boolean $ACTIVE
     */
    protected $ACTIVE = null;

    /**
     * @var string $LAST_DATE_MADE_ACTIVE
     */
    protected $LAST_DATE_MADE_ACTIVE = null;

    /**
     * @var boolean $DELETE
     */
    protected $DELETE = null;

    /**
     * @var CategoriesType $DEPARTMENTS
     */
    protected $DEPARTMENTS = null;

    /**
     * @var TagsType $TAGS
     */
    protected $TAGS = null;

    /**
     * @var ImagesType $IMAGES
     */
    protected $IMAGES = null;

    /**
     * @var string $PRODUCT_OPTION
     */
    protected $PRODUCT_OPTION = null;

    /**
     * @var string $ALLOW_SAMPLES
     */
    protected $ALLOW_SAMPLES = null;

    /**
     * @var int $SAMPLE_PARENT_ID
     */
    protected $SAMPLE_PARENT_ID = null;

    /**
     * @var SubProductsContainerType $SUBPRODUCTS
     */
    protected $SUBPRODUCTS = null;

    /**
     * @var UpsellingType $UPSELLING
     */
    protected $UPSELLING = null;

    /**
     * @param NonEmptyStringType $REFERENCE
     * @param SubProductsContainerType $SUBPRODUCTS
     */
    public function __construct($REFERENCE, $SUBPRODUCTS)
    {
      $this->REFERENCE = $REFERENCE;
      $this->SUBPRODUCTS = $SUBPRODUCTS;
    }

    /**
     * @return int
     */
    public function getPARENT_PRODUCT_ID()
    {
      return $this->PARENT_PRODUCT_ID;
    }

    /**
     * @param int $PARENT_PRODUCT_ID
     * @return \Visualsoft\ProductType
     */
    public function setPARENT_PRODUCT_ID($PARENT_PRODUCT_ID)
    {
      $this->PARENT_PRODUCT_ID = $PARENT_PRODUCT_ID;
      return $this;
    }

    /**
     * @return NonEmptyStringType
     */
    public function getREFERENCE()
    {
      return $this->REFERENCE;
    }

    /**
     * @param NonEmptyStringType $REFERENCE
     * @return \Visualsoft\ProductType
     */
    public function setREFERENCE($REFERENCE)
    {
      $this->REFERENCE = $REFERENCE;
      return $this;
    }

    /**
     * @return string
     */
    public function getTITLE()
    {
      return $this->TITLE;
    }

    /**
     * @param string $TITLE
     * @return \Visualsoft\ProductType
     */
    public function setTITLE($TITLE)
    {
      $this->TITLE = $TITLE;
      return $this;
    }

    /**
     * @return string
     */
    public function getBRAND()
    {
      return $this->BRAND;
    }

    /**
     * @param string $BRAND
     * @return \Visualsoft\ProductType
     */
    public function setBRAND($BRAND)
    {
      $this->BRAND = $BRAND;
      return $this;
    }

    /**
     * @return string
     */
    public function getMANUFACTURER_ORIGIN()
    {
      return $this->MANUFACTURER_ORIGIN;
    }

    /**
     * @param string $MANUFACTURER_ORIGIN
     * @return \Visualsoft\ProductType
     */
    public function setMANUFACTURER_ORIGIN($MANUFACTURER_ORIGIN)
    {
      $this->MANUFACTURER_ORIGIN = $MANUFACTURER_ORIGIN;
      return $this;
    }

    /**
     * @return string
     */
    public function getCOMMODITY_CODE()
    {
      return $this->COMMODITY_CODE;
    }

    /**
     * @param string $COMMODITY_CODE
     * @return \Visualsoft\ProductType
     */
    public function setCOMMODITY_CODE($COMMODITY_CODE)
    {
      $this->COMMODITY_CODE = $COMMODITY_CODE;
      return $this;
    }

    /**
     * @return string
     */
    public function getSUBTITLE()
    {
      return $this->SUBTITLE;
    }

    /**
     * @param string $SUBTITLE
     * @return \Visualsoft\ProductType
     */
    public function setSUBTITLE($SUBTITLE)
    {
      $this->SUBTITLE = $SUBTITLE;
      return $this;
    }

    /**
     * @return string
     */
    public function getSUMMARY()
    {
      return $this->SUMMARY;
    }

    /**
     * @param string $SUMMARY
     * @return \Visualsoft\ProductType
     */
    public function setSUMMARY($SUMMARY)
    {
      $this->SUMMARY = $SUMMARY;
      return $this;
    }

    /**
     * @return string
     */
    public function getDESCRIPTION()
    {
      return $this->DESCRIPTION;
    }

    /**
     * @param string $DESCRIPTION
     * @return \Visualsoft\ProductType
     */
    public function setDESCRIPTION($DESCRIPTION)
    {
      $this->DESCRIPTION = $DESCRIPTION;
      return $this;
    }

    /**
     * @return string
     */
    public function getSEO_TITLE()
    {
      return $this->SEO_TITLE;
    }

    /**
     * @param string $SEO_TITLE
     * @return \Visualsoft\ProductType
     */
    public function setSEO_TITLE($SEO_TITLE)
    {
      $this->SEO_TITLE = $SEO_TITLE;
      return $this;
    }

    /**
     * @return string
     */
    public function getSEO_DESCRIPTION()
    {
      return $this->SEO_DESCRIPTION;
    }

    /**
     * @param string $SEO_DESCRIPTION
     * @return \Visualsoft\ProductType
     */
    public function setSEO_DESCRIPTION($SEO_DESCRIPTION)
    {
      $this->SEO_DESCRIPTION = $SEO_DESCRIPTION;
      return $this;
    }

    /**
     * @return string
     */
    public function getSEO_KEYWORDS()
    {
      return $this->SEO_KEYWORDS;
    }

    /**
     * @param string $SEO_KEYWORDS
     * @return \Visualsoft\ProductType
     */
    public function setSEO_KEYWORDS($SEO_KEYWORDS)
    {
      $this->SEO_KEYWORDS = $SEO_KEYWORDS;
      return $this;
    }

    /**
     * @return string
     */
    public function getSEO_NAME()
    {
      return $this->SEO_NAME;
    }

    /**
     * @param string $SEO_NAME
     * @return \Visualsoft\ProductType
     */
    public function setSEO_NAME($SEO_NAME)
    {
      $this->SEO_NAME = $SEO_NAME;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getACTIVE()
    {
      return $this->ACTIVE;
    }

    /**
     * @param boolean $ACTIVE
     * @return \Visualsoft\ProductType
     */
    public function setACTIVE($ACTIVE)
    {
      $this->ACTIVE = $ACTIVE;
      return $this;
    }

    /**
     * @return string
     */
    public function getLAST_DATE_MADE_ACTIVE()
    {
      return $this->LAST_DATE_MADE_ACTIVE;
    }

    /**
     * @param string $LAST_DATE_MADE_ACTIVE
     * @return \Visualsoft\ProductType
     */
    public function setLAST_DATE_MADE_ACTIVE($LAST_DATE_MADE_ACTIVE)
    {
      $this->LAST_DATE_MADE_ACTIVE = $LAST_DATE_MADE_ACTIVE;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getDELETE()
    {
      return $this->DELETE;
    }

    /**
     * @param boolean $DELETE
     * @return \Visualsoft\ProductType
     */
    public function setDELETE($DELETE)
    {
      $this->DELETE = $DELETE;
      return $this;
    }

    /**
     * @return CategoriesType
     */
    public function getDEPARTMENTS()
    {
      return $this->DEPARTMENTS;
    }

    /**
     * @param CategoriesType $DEPARTMENTS
     * @return \Visualsoft\ProductType
     */
    public function setDEPARTMENTS($DEPARTMENTS)
    {
      $this->DEPARTMENTS = $DEPARTMENTS;
      return $this;
    }

    /**
     * @return TagsType
     */
    public function getTAGS()
    {
      return $this->TAGS;
    }

    /**
     * @param TagsType $TAGS
     * @return \Visualsoft\ProductType
     */
    public function setTAGS($TAGS)
    {
      $this->TAGS = $TAGS;
      return $this;
    }

    /**
     * @return ImagesType
     */
    public function getIMAGES()
    {
      return $this->IMAGES;
    }

    /**
     * @param ImagesType $IMAGES
     * @return \Visualsoft\ProductType
     */
    public function setIMAGES($IMAGES)
    {
      $this->IMAGES = $IMAGES;
      return $this;
    }

    /**
     * @return string
     */
    public function getPRODUCT_OPTION()
    {
      return $this->PRODUCT_OPTION;
    }

    /**
     * @param string $PRODUCT_OPTION
     * @return \Visualsoft\ProductType
     */
    public function setPRODUCT_OPTION($PRODUCT_OPTION)
    {
      $this->PRODUCT_OPTION = $PRODUCT_OPTION;
      return $this;
    }

    /**
     * @return string
     */
    public function getALLOW_SAMPLES()
    {
      return $this->ALLOW_SAMPLES;
    }

    /**
     * @param string $ALLOW_SAMPLES
     * @return \Visualsoft\ProductType
     */
    public function setALLOW_SAMPLES($ALLOW_SAMPLES)
    {
      $this->ALLOW_SAMPLES = $ALLOW_SAMPLES;
      return $this;
    }

    /**
     * @return int
     */
    public function getSAMPLE_PARENT_ID()
    {
      return $this->SAMPLE_PARENT_ID;
    }

    /**
     * @param int $SAMPLE_PARENT_ID
     * @return \Visualsoft\ProductType
     */
    public function setSAMPLE_PARENT_ID($SAMPLE_PARENT_ID)
    {
      $this->SAMPLE_PARENT_ID = $SAMPLE_PARENT_ID;
      return $this;
    }

    /**
     * @return SubProductsContainerType
     */
    public function getSUBPRODUCTS()
    {
      return $this->SUBPRODUCTS;
    }

    /**
     * @param SubProductsContainerType $SUBPRODUCTS
     * @return \Visualsoft\ProductType
     */
    public function setSUBPRODUCTS($SUBPRODUCTS)
    {
      $this->SUBPRODUCTS = $SUBPRODUCTS;
      return $this;
    }

    /**
     * @return UpsellingType
     */
    public function getUPSELLING()
    {
      return $this->UPSELLING;
    }

    /**
     * @param UpsellingType $UPSELLING
     * @return \Visualsoft\ProductType
     */
    public function setUPSELLING($UPSELLING)
    {
      $this->UPSELLING = $UPSELLING;
      return $this;
    }

}
