<?php

namespace Visualsoft;

class PaymentType
{

    /**
     * @var float $PAYMENT_AMOUNT
     */
    protected $PAYMENT_AMOUNT = null;

    /**
     * @var string $PAYMENT_DATE
     */
    protected $PAYMENT_DATE = null;

    /**
     * @var string $PAYMENT_TYPE
     */
    protected $PAYMENT_TYPE = null;

    /**
     * @var string $CARD_HOLDER
     */
    protected $CARD_HOLDER = null;

    /**
     * @var string $VENDOR_TX_CODE
     */
    protected $VENDOR_TX_CODE = null;

    /**
     * @var string $AUTH_CODE
     */
    protected $AUTH_CODE = null;

    /**
     * @var string $SECURITY_REFERENCE
     */
    protected $SECURITY_REFERENCE = null;

    /**
     * @var string $TRANSACTION_REFERENCE
     */
    protected $TRANSACTION_REFERENCE = null;

    /**
     * @var string $CV2_AVS
     */
    protected $CV2_AVS = null;

    /**
     * @var string $NOTES
     */
    protected $NOTES = null;

    /**
     * @param float $PAYMENT_AMOUNT
     * @param string $PAYMENT_DATE
     * @param string $PAYMENT_TYPE
     * @param string $CARD_HOLDER
     * @param string $AUTH_CODE
     * @param string $SECURITY_REFERENCE
     * @param string $TRANSACTION_REFERENCE
     * @param string $CV2_AVS
     * @param string $NOTES
     */
    public function __construct($PAYMENT_AMOUNT, $PAYMENT_DATE, $PAYMENT_TYPE, $CARD_HOLDER, $AUTH_CODE, $SECURITY_REFERENCE, $TRANSACTION_REFERENCE, $CV2_AVS, $NOTES)
    {
      $this->PAYMENT_AMOUNT = $PAYMENT_AMOUNT;
      $this->PAYMENT_DATE = $PAYMENT_DATE;
      $this->PAYMENT_TYPE = $PAYMENT_TYPE;
      $this->CARD_HOLDER = $CARD_HOLDER;
      $this->AUTH_CODE = $AUTH_CODE;
      $this->SECURITY_REFERENCE = $SECURITY_REFERENCE;
      $this->TRANSACTION_REFERENCE = $TRANSACTION_REFERENCE;
      $this->CV2_AVS = $CV2_AVS;
      $this->NOTES = $NOTES;
    }

    /**
     * @return float
     */
    public function getPAYMENT_AMOUNT()
    {
      return $this->PAYMENT_AMOUNT;
    }

    /**
     * @param float $PAYMENT_AMOUNT
     * @return \Visualsoft\PaymentType
     */
    public function setPAYMENT_AMOUNT($PAYMENT_AMOUNT)
    {
      $this->PAYMENT_AMOUNT = $PAYMENT_AMOUNT;
      return $this;
    }

    /**
     * @return string
     */
    public function getPAYMENT_DATE()
    {
      return $this->PAYMENT_DATE;
    }

    /**
     * @param string $PAYMENT_DATE
     * @return \Visualsoft\PaymentType
     */
    public function setPAYMENT_DATE($PAYMENT_DATE)
    {
      $this->PAYMENT_DATE = $PAYMENT_DATE;
      return $this;
    }

    /**
     * @return string
     */
    public function getPAYMENT_TYPE()
    {
      return $this->PAYMENT_TYPE;
    }

    /**
     * @param string $PAYMENT_TYPE
     * @return \Visualsoft\PaymentType
     */
    public function setPAYMENT_TYPE($PAYMENT_TYPE)
    {
      $this->PAYMENT_TYPE = $PAYMENT_TYPE;
      return $this;
    }

    /**
     * @return string
     */
    public function getCARD_HOLDER()
    {
      return $this->CARD_HOLDER;
    }

    /**
     * @param string $CARD_HOLDER
     * @return \Visualsoft\PaymentType
     */
    public function setCARD_HOLDER($CARD_HOLDER)
    {
      $this->CARD_HOLDER = $CARD_HOLDER;
      return $this;
    }

    /**
     * @return string
     */
    public function getVENDOR_TX_CODE()
    {
      return $this->VENDOR_TX_CODE;
    }

    /**
     * @param string $VENDOR_TX_CODE
     * @return \Visualsoft\PaymentType
     */
    public function setVENDOR_TX_CODE($VENDOR_TX_CODE)
    {
      $this->VENDOR_TX_CODE = $VENDOR_TX_CODE;
      return $this;
    }

    /**
     * @return string
     */
    public function getAUTH_CODE()
    {
      return $this->AUTH_CODE;
    }

    /**
     * @param string $AUTH_CODE
     * @return \Visualsoft\PaymentType
     */
    public function setAUTH_CODE($AUTH_CODE)
    {
      $this->AUTH_CODE = $AUTH_CODE;
      return $this;
    }

    /**
     * @return string
     */
    public function getSECURITY_REFERENCE()
    {
      return $this->SECURITY_REFERENCE;
    }

    /**
     * @param string $SECURITY_REFERENCE
     * @return \Visualsoft\PaymentType
     */
    public function setSECURITY_REFERENCE($SECURITY_REFERENCE)
    {
      $this->SECURITY_REFERENCE = $SECURITY_REFERENCE;
      return $this;
    }

    /**
     * @return string
     */
    public function getTRANSACTION_REFERENCE()
    {
      return $this->TRANSACTION_REFERENCE;
    }

    /**
     * @param string $TRANSACTION_REFERENCE
     * @return \Visualsoft\PaymentType
     */
    public function setTRANSACTION_REFERENCE($TRANSACTION_REFERENCE)
    {
      $this->TRANSACTION_REFERENCE = $TRANSACTION_REFERENCE;
      return $this;
    }

    /**
     * @return string
     */
    public function getCV2_AVS()
    {
      return $this->CV2_AVS;
    }

    /**
     * @param string $CV2_AVS
     * @return \Visualsoft\PaymentType
     */
    public function setCV2_AVS($CV2_AVS)
    {
      $this->CV2_AVS = $CV2_AVS;
      return $this;
    }

    /**
     * @return string
     */
    public function getNOTES()
    {
      return $this->NOTES;
    }

    /**
     * @param string $NOTES
     * @return \Visualsoft\PaymentType
     */
    public function setNOTES($NOTES)
    {
      $this->NOTES = $NOTES;
      return $this;
    }

}
