<?php

namespace Visualsoft;

class OrderFraudUpdateType
{

    /**
     * @var int $ORDER_ID
     */
    protected $ORDER_ID = null;

    /**
     * @var NonEmptyStringType $ORDER_REF
     */
    protected $ORDER_REF = null;

    /**
     * @var NonEmptyStringType $FRAUD_STATUS
     */
    protected $FRAUD_STATUS = null;

    /**
     * @var int $FRAUD_STATE_ID
     */
    protected $FRAUD_STATE_ID = null;

    /**
     * @var anyType $FRAUD_NOTES
     */
    protected $FRAUD_NOTES = null;

    /**
     * @param int $ORDER_ID
     * @param NonEmptyStringType $ORDER_REF
     * @param NonEmptyStringType $FRAUD_STATUS
     * @param int $FRAUD_STATE_ID
     */
    public function __construct($ORDER_ID, $ORDER_REF, $FRAUD_STATUS, $FRAUD_STATE_ID)
    {
      $this->ORDER_ID = $ORDER_ID;
      $this->ORDER_REF = $ORDER_REF;
      $this->FRAUD_STATUS = $FRAUD_STATUS;
      $this->FRAUD_STATE_ID = $FRAUD_STATE_ID;
    }

    /**
     * @return int
     */
    public function getORDER_ID()
    {
      return $this->ORDER_ID;
    }

    /**
     * @param int $ORDER_ID
     * @return \Visualsoft\OrderFraudUpdateType
     */
    public function setORDER_ID($ORDER_ID)
    {
      $this->ORDER_ID = $ORDER_ID;
      return $this;
    }

    /**
     * @return NonEmptyStringType
     */
    public function getORDER_REF()
    {
      return $this->ORDER_REF;
    }

    /**
     * @param NonEmptyStringType $ORDER_REF
     * @return \Visualsoft\OrderFraudUpdateType
     */
    public function setORDER_REF($ORDER_REF)
    {
      $this->ORDER_REF = $ORDER_REF;
      return $this;
    }

    /**
     * @return NonEmptyStringType
     */
    public function getFRAUD_STATUS()
    {
      return $this->FRAUD_STATUS;
    }

    /**
     * @param NonEmptyStringType $FRAUD_STATUS
     * @return \Visualsoft\OrderFraudUpdateType
     */
    public function setFRAUD_STATUS($FRAUD_STATUS)
    {
      $this->FRAUD_STATUS = $FRAUD_STATUS;
      return $this;
    }

    /**
     * @return int
     */
    public function getFRAUD_STATE_ID()
    {
      return $this->FRAUD_STATE_ID;
    }

    /**
     * @param int $FRAUD_STATE_ID
     * @return \Visualsoft\OrderFraudUpdateType
     */
    public function setFRAUD_STATE_ID($FRAUD_STATE_ID)
    {
      $this->FRAUD_STATE_ID = $FRAUD_STATE_ID;
      return $this;
    }

    /**
     * @return anyType
     */
    public function getFRAUD_NOTES()
    {
      return $this->FRAUD_NOTES;
    }

    /**
     * @param anyType $FRAUD_NOTES
     * @return \Visualsoft\OrderFraudUpdateType
     */
    public function setFRAUD_NOTES($FRAUD_NOTES)
    {
      $this->FRAUD_NOTES = $FRAUD_NOTES;
      return $this;
    }

}
