<?php

namespace Visualsoft;

class NewsletterSubscriberType
{

    /**
     * @var NonEmptyStringType $email_address
     */
    protected $email_address = null;

    /**
     * @var subscriber_group_ids $subscriber_group_ids
     */
    protected $subscriber_group_ids = null;

    /**
     * @var string $firstname
     */
    protected $firstname = null;

    /**
     * @var string $lastname
     */
    protected $lastname = null;

    /**
     * @var boolean $send_email
     */
    protected $send_email = null;

    /**
     * @param NonEmptyStringType $email_address
     */
    public function __construct($email_address)
    {
      $this->email_address = $email_address;
    }

    /**
     * @return NonEmptyStringType
     */
    public function getEmail_address()
    {
      return $this->email_address;
    }

    /**
     * @param NonEmptyStringType $email_address
     * @return \Visualsoft\NewsletterSubscriberType
     */
    public function setEmail_address($email_address)
    {
      $this->email_address = $email_address;
      return $this;
    }

    /**
     * @return subscriber_group_ids
     */
    public function getSubscriber_group_ids()
    {
      return $this->subscriber_group_ids;
    }

    /**
     * @param subscriber_group_ids $subscriber_group_ids
     * @return \Visualsoft\NewsletterSubscriberType
     */
    public function setSubscriber_group_ids($subscriber_group_ids)
    {
      $this->subscriber_group_ids = $subscriber_group_ids;
      return $this;
    }

    /**
     * @return string
     */
    public function getFirstname()
    {
      return $this->firstname;
    }

    /**
     * @param string $firstname
     * @return \Visualsoft\NewsletterSubscriberType
     */
    public function setFirstname($firstname)
    {
      $this->firstname = $firstname;
      return $this;
    }

    /**
     * @return string
     */
    public function getLastname()
    {
      return $this->lastname;
    }

    /**
     * @param string $lastname
     * @return \Visualsoft\NewsletterSubscriberType
     */
    public function setLastname($lastname)
    {
      $this->lastname = $lastname;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getSend_email()
    {
      return $this->send_email;
    }

    /**
     * @param boolean $send_email
     * @return \Visualsoft\NewsletterSubscriberType
     */
    public function setSend_email($send_email)
    {
      $this->send_email = $send_email;
      return $this;
    }

}
