<?php

namespace Visualsoft;

class ImportCustomerType
{

    /**
     * @var int $CUSTOMER_ID
     */
    protected $CUSTOMER_ID = null;

    /**
     * @var string $IDENTIFY_USING
     */
    protected $IDENTIFY_USING = null;

    /**
     * @var string $PREVIOUS_IDENTIFIER
     */
    protected $PREVIOUS_IDENTIFIER = null;

    /**
     * @var int $WEBSITE_ID
     */
    protected $WEBSITE_ID = null;

    /**
     * @var string $EMAIL_ADDRESS
     */
    protected $EMAIL_ADDRESS = null;

    /**
     * @var string $SEND_PASSWORD_RECOVERY
     */
    protected $SEND_PASSWORD_RECOVERY = null;

    /**
     * @var string $PASSWORD
     */
    protected $PASSWORD = null;

    /**
     * @var string $CUSTOMER_ACCOUNT_NUMBER
     */
    protected $CUSTOMER_ACCOUNT_NUMBER = null;

    /**
     * @var string $DATE_OF_BIRTH
     */
    protected $DATE_OF_BIRTH = null;

    /**
     * @var string $CUSTOMER_OCCUPATION
     */
    protected $CUSTOMER_OCCUPATION = null;

    /**
     * @var string $HEARD_ABOUT
     */
    protected $HEARD_ABOUT = null;

    /**
     * @var string $CUSTOMER_NOTES
     */
    protected $CUSTOMER_NOTES = null;

    /**
     * @var AddressesType $ADDRESSES
     */
    protected $ADDRESSES = null;

    /**
     * @var OptInsType $OPT_INS
     */
    protected $OPT_INS = null;

    /**
     * @var string $APPROVED
     */
    protected $APPROVED = null;

    /**
     * @var string $CUSTOMER_NIF
     */
    protected $CUSTOMER_NIF = null;

    /**
     * @var string $FREE_DELIVERY
     */
    protected $FREE_DELIVERY = null;

    /**
     * @var int $CUSTOMER_GROUP_ID
     */
    protected $CUSTOMER_GROUP_ID = null;

    /**
     * @var string $CUSTOMER_GROUP_NAME
     */
    protected $CUSTOMER_GROUP_NAME = null;

    /**
     * @var string $LOCK_TO_TRADE_ONLY
     */
    protected $LOCK_TO_TRADE_ONLY = null;

    /**
     * @var float $CURRENT_BALANCE
     */
    protected $CURRENT_BALANCE = null;

    /**
     * @var float $CREDIT_LIMIT
     */
    protected $CREDIT_LIMIT = null;

    /**
     * @var string $VAT_REGISTRATION_NUMBER
     */
    protected $VAT_REGISTRATION_NUMBER = null;

    /**
     * @var string $VAT_EXEMPT
     */
    protected $VAT_EXEMPT = null;

    /**
     * @var string $CUSTOMER_TYPE
     */
    protected $CUSTOMER_TYPE = null;

    /**
     * @var string $EXTERNAL_LOYALTY_PROGRAM_NUMBER
     */
    protected $EXTERNAL_LOYALTY_PROGRAM_NUMBER = null;

    /**
     * @var string $COMPANY_NUMBER
     */
    protected $COMPANY_NUMBER = null;

    /**
     * @var string $COMPANY_DOMAIN
     */
    protected $COMPANY_DOMAIN = null;

    /**
     * @param string $EMAIL_ADDRESS
     * @param AddressesType $ADDRESSES
     */
    public function __construct($EMAIL_ADDRESS, $ADDRESSES)
    {
      $this->EMAIL_ADDRESS = $EMAIL_ADDRESS;
      $this->ADDRESSES = $ADDRESSES;
    }

    /**
     * @return int
     */
    public function getCUSTOMER_ID()
    {
      return $this->CUSTOMER_ID;
    }

    /**
     * @param int $CUSTOMER_ID
     * @return \Visualsoft\ImportCustomerType
     */
    public function setCUSTOMER_ID($CUSTOMER_ID)
    {
      $this->CUSTOMER_ID = $CUSTOMER_ID;
      return $this;
    }

    /**
     * @return string
     */
    public function getIDENTIFY_USING()
    {
      return $this->IDENTIFY_USING;
    }

    /**
     * @param string $IDENTIFY_USING
     * @return \Visualsoft\ImportCustomerType
     */
    public function setIDENTIFY_USING($IDENTIFY_USING)
    {
      $this->IDENTIFY_USING = $IDENTIFY_USING;
      return $this;
    }

    /**
     * @return string
     */
    public function getPREVIOUS_IDENTIFIER()
    {
      return $this->PREVIOUS_IDENTIFIER;
    }

    /**
     * @param string $PREVIOUS_IDENTIFIER
     * @return \Visualsoft\ImportCustomerType
     */
    public function setPREVIOUS_IDENTIFIER($PREVIOUS_IDENTIFIER)
    {
      $this->PREVIOUS_IDENTIFIER = $PREVIOUS_IDENTIFIER;
      return $this;
    }

    /**
     * @return int
     */
    public function getWEBSITE_ID()
    {
      return $this->WEBSITE_ID;
    }

    /**
     * @param int $WEBSITE_ID
     * @return \Visualsoft\ImportCustomerType
     */
    public function setWEBSITE_ID($WEBSITE_ID)
    {
      $this->WEBSITE_ID = $WEBSITE_ID;
      return $this;
    }

    /**
     * @return string
     */
    public function getEMAIL_ADDRESS()
    {
      return $this->EMAIL_ADDRESS;
    }

    /**
     * @param string $EMAIL_ADDRESS
     * @return \Visualsoft\ImportCustomerType
     */
    public function setEMAIL_ADDRESS($EMAIL_ADDRESS)
    {
      $this->EMAIL_ADDRESS = $EMAIL_ADDRESS;
      return $this;
    }

    /**
     * @return string
     */
    public function getSEND_PASSWORD_RECOVERY()
    {
      return $this->SEND_PASSWORD_RECOVERY;
    }

    /**
     * @param string $SEND_PASSWORD_RECOVERY
     * @return \Visualsoft\ImportCustomerType
     */
    public function setSEND_PASSWORD_RECOVERY($SEND_PASSWORD_RECOVERY)
    {
      $this->SEND_PASSWORD_RECOVERY = $SEND_PASSWORD_RECOVERY;
      return $this;
    }

    /**
     * @return string
     */
    public function getPASSWORD()
    {
      return $this->PASSWORD;
    }

    /**
     * @param string $PASSWORD
     * @return \Visualsoft\ImportCustomerType
     */
    public function setPASSWORD($PASSWORD)
    {
      $this->PASSWORD = $PASSWORD;
      return $this;
    }

    /**
     * @return string
     */
    public function getCUSTOMER_ACCOUNT_NUMBER()
    {
      return $this->CUSTOMER_ACCOUNT_NUMBER;
    }

    /**
     * @param string $CUSTOMER_ACCOUNT_NUMBER
     * @return \Visualsoft\ImportCustomerType
     */
    public function setCUSTOMER_ACCOUNT_NUMBER($CUSTOMER_ACCOUNT_NUMBER)
    {
      $this->CUSTOMER_ACCOUNT_NUMBER = $CUSTOMER_ACCOUNT_NUMBER;
      return $this;
    }

    /**
     * @return string
     */
    public function getDATE_OF_BIRTH()
    {
      return $this->DATE_OF_BIRTH;
    }

    /**
     * @param string $DATE_OF_BIRTH
     * @return \Visualsoft\ImportCustomerType
     */
    public function setDATE_OF_BIRTH($DATE_OF_BIRTH)
    {
      $this->DATE_OF_BIRTH = $DATE_OF_BIRTH;
      return $this;
    }

    /**
     * @return string
     */
    public function getCUSTOMER_OCCUPATION()
    {
      return $this->CUSTOMER_OCCUPATION;
    }

    /**
     * @param string $CUSTOMER_OCCUPATION
     * @return \Visualsoft\ImportCustomerType
     */
    public function setCUSTOMER_OCCUPATION($CUSTOMER_OCCUPATION)
    {
      $this->CUSTOMER_OCCUPATION = $CUSTOMER_OCCUPATION;
      return $this;
    }

    /**
     * @return string
     */
    public function getHEARD_ABOUT()
    {
      return $this->HEARD_ABOUT;
    }

    /**
     * @param string $HEARD_ABOUT
     * @return \Visualsoft\ImportCustomerType
     */
    public function setHEARD_ABOUT($HEARD_ABOUT)
    {
      $this->HEARD_ABOUT = $HEARD_ABOUT;
      return $this;
    }

    /**
     * @return string
     */
    public function getCUSTOMER_NOTES()
    {
      return $this->CUSTOMER_NOTES;
    }

    /**
     * @param string $CUSTOMER_NOTES
     * @return \Visualsoft\ImportCustomerType
     */
    public function setCUSTOMER_NOTES($CUSTOMER_NOTES)
    {
      $this->CUSTOMER_NOTES = $CUSTOMER_NOTES;
      return $this;
    }

    /**
     * @return AddressesType
     */
    public function getADDRESSES()
    {
      return $this->ADDRESSES;
    }

    /**
     * @param AddressesType $ADDRESSES
     * @return \Visualsoft\ImportCustomerType
     */
    public function setADDRESSES($ADDRESSES)
    {
      $this->ADDRESSES = $ADDRESSES;
      return $this;
    }

    /**
     * @return OptInsType
     */
    public function getOPT_INS()
    {
      return $this->OPT_INS;
    }

    /**
     * @param OptInsType $OPT_INS
     * @return \Visualsoft\ImportCustomerType
     */
    public function setOPT_INS($OPT_INS)
    {
      $this->OPT_INS = $OPT_INS;
      return $this;
    }

    /**
     * @return string
     */
    public function getAPPROVED()
    {
      return $this->APPROVED;
    }

    /**
     * @param string $APPROVED
     * @return \Visualsoft\ImportCustomerType
     */
    public function setAPPROVED($APPROVED)
    {
      $this->APPROVED = $APPROVED;
      return $this;
    }

    /**
     * @return string
     */
    public function getCUSTOMER_NIF()
    {
      return $this->CUSTOMER_NIF;
    }

    /**
     * @param string $CUSTOMER_NIF
     * @return \Visualsoft\ImportCustomerType
     */
    public function setCUSTOMER_NIF($CUSTOMER_NIF)
    {
      $this->CUSTOMER_NIF = $CUSTOMER_NIF;
      return $this;
    }

    /**
     * @return string
     */
    public function getFREE_DELIVERY()
    {
      return $this->FREE_DELIVERY;
    }

    /**
     * @param string $FREE_DELIVERY
     * @return \Visualsoft\ImportCustomerType
     */
    public function setFREE_DELIVERY($FREE_DELIVERY)
    {
      $this->FREE_DELIVERY = $FREE_DELIVERY;
      return $this;
    }

    /**
     * @return int
     */
    public function getCUSTOMER_GROUP_ID()
    {
      return $this->CUSTOMER_GROUP_ID;
    }

    /**
     * @param int $CUSTOMER_GROUP_ID
     * @return \Visualsoft\ImportCustomerType
     */
    public function setCUSTOMER_GROUP_ID($CUSTOMER_GROUP_ID)
    {
      $this->CUSTOMER_GROUP_ID = $CUSTOMER_GROUP_ID;
      return $this;
    }

    /**
     * @return string
     */
    public function getCUSTOMER_GROUP_NAME()
    {
      return $this->CUSTOMER_GROUP_NAME;
    }

    /**
     * @param string $CUSTOMER_GROUP_NAME
     * @return \Visualsoft\ImportCustomerType
     */
    public function setCUSTOMER_GROUP_NAME($CUSTOMER_GROUP_NAME)
    {
      $this->CUSTOMER_GROUP_NAME = $CUSTOMER_GROUP_NAME;
      return $this;
    }

    /**
     * @return string
     */
    public function getLOCK_TO_TRADE_ONLY()
    {
      return $this->LOCK_TO_TRADE_ONLY;
    }

    /**
     * @param string $LOCK_TO_TRADE_ONLY
     * @return \Visualsoft\ImportCustomerType
     */
    public function setLOCK_TO_TRADE_ONLY($LOCK_TO_TRADE_ONLY)
    {
      $this->LOCK_TO_TRADE_ONLY = $LOCK_TO_TRADE_ONLY;
      return $this;
    }

    /**
     * @return float
     */
    public function getCURRENT_BALANCE()
    {
      return $this->CURRENT_BALANCE;
    }

    /**
     * @param float $CURRENT_BALANCE
     * @return \Visualsoft\ImportCustomerType
     */
    public function setCURRENT_BALANCE($CURRENT_BALANCE)
    {
      $this->CURRENT_BALANCE = $CURRENT_BALANCE;
      return $this;
    }

    /**
     * @return float
     */
    public function getCREDIT_LIMIT()
    {
      return $this->CREDIT_LIMIT;
    }

    /**
     * @param float $CREDIT_LIMIT
     * @return \Visualsoft\ImportCustomerType
     */
    public function setCREDIT_LIMIT($CREDIT_LIMIT)
    {
      $this->CREDIT_LIMIT = $CREDIT_LIMIT;
      return $this;
    }

    /**
     * @return string
     */
    public function getVAT_REGISTRATION_NUMBER()
    {
      return $this->VAT_REGISTRATION_NUMBER;
    }

    /**
     * @param string $VAT_REGISTRATION_NUMBER
     * @return \Visualsoft\ImportCustomerType
     */
    public function setVAT_REGISTRATION_NUMBER($VAT_REGISTRATION_NUMBER)
    {
      $this->VAT_REGISTRATION_NUMBER = $VAT_REGISTRATION_NUMBER;
      return $this;
    }

    /**
     * @return string
     */
    public function getVAT_EXEMPT()
    {
      return $this->VAT_EXEMPT;
    }

    /**
     * @param string $VAT_EXEMPT
     * @return \Visualsoft\ImportCustomerType
     */
    public function setVAT_EXEMPT($VAT_EXEMPT)
    {
      $this->VAT_EXEMPT = $VAT_EXEMPT;
      return $this;
    }

    /**
     * @return string
     */
    public function getCUSTOMER_TYPE()
    {
      return $this->CUSTOMER_TYPE;
    }

    /**
     * @param string $CUSTOMER_TYPE
     * @return \Visualsoft\ImportCustomerType
     */
    public function setCUSTOMER_TYPE($CUSTOMER_TYPE)
    {
      $this->CUSTOMER_TYPE = $CUSTOMER_TYPE;
      return $this;
    }

    /**
     * @return string
     */
    public function getEXTERNAL_LOYALTY_PROGRAM_NUMBER()
    {
      return $this->EXTERNAL_LOYALTY_PROGRAM_NUMBER;
    }

    /**
     * @param string $EXTERNAL_LOYALTY_PROGRAM_NUMBER
     * @return \Visualsoft\ImportCustomerType
     */
    public function setEXTERNAL_LOYALTY_PROGRAM_NUMBER($EXTERNAL_LOYALTY_PROGRAM_NUMBER)
    {
      $this->EXTERNAL_LOYALTY_PROGRAM_NUMBER = $EXTERNAL_LOYALTY_PROGRAM_NUMBER;
      return $this;
    }

    /**
     * @return string
     */
    public function getCOMPANY_NUMBER()
    {
      return $this->COMPANY_NUMBER;
    }

    /**
     * @param string $COMPANY_NUMBER
     * @return \Visualsoft\ImportCustomerType
     */
    public function setCOMPANY_NUMBER($COMPANY_NUMBER)
    {
      $this->COMPANY_NUMBER = $COMPANY_NUMBER;
      return $this;
    }

    /**
     * @return string
     */
    public function getCOMPANY_DOMAIN()
    {
      return $this->COMPANY_DOMAIN;
    }

    /**
     * @param string $COMPANY_DOMAIN
     * @return \Visualsoft\ImportCustomerType
     */
    public function setCOMPANY_DOMAIN($COMPANY_DOMAIN)
    {
      $this->COMPANY_DOMAIN = $COMPANY_DOMAIN;
      return $this;
    }

}
