<?php

namespace Visualsoft;

class DiscountType
{

    /**
     * @var int $ID
     */
    protected $ID = null;

    /**
     * @var string $CODE
     */
    protected $CODE = null;

    /**
     * @var string $NAME
     */
    protected $NAME = null;

    /**
     * @var float $DISCOUNT_EX_VAT
     */
    protected $DISCOUNT_EX_VAT = null;

    /**
     * @var float $DISCOUNT_INC_VAT
     */
    protected $DISCOUNT_INC_VAT = null;

    /**
     * @var float $DISCOUNT_VAT
     */
    protected $DISCOUNT_VAT = null;

    /**
     * @param int $ID
     * @param string $CODE
     * @param string $NAME
     * @param float $DISCOUNT_EX_VAT
     * @param float $DISCOUNT_INC_VAT
     * @param float $DISCOUNT_VAT
     */
    public function __construct($ID, $CODE, $NAME, $DISCOUNT_EX_VAT, $DISCOUNT_INC_VAT, $DISCOUNT_VAT)
    {
      $this->ID = $ID;
      $this->CODE = $CODE;
      $this->NAME = $NAME;
      $this->DISCOUNT_EX_VAT = $DISCOUNT_EX_VAT;
      $this->DISCOUNT_INC_VAT = $DISCOUNT_INC_VAT;
      $this->DISCOUNT_VAT = $DISCOUNT_VAT;
    }

    /**
     * @return int
     */
    public function getID()
    {
      return $this->ID;
    }

    /**
     * @param int $ID
     * @return \Visualsoft\DiscountType
     */
    public function setID($ID)
    {
      $this->ID = $ID;
      return $this;
    }

    /**
     * @return string
     */
    public function getCODE()
    {
      return $this->CODE;
    }

    /**
     * @param string $CODE
     * @return \Visualsoft\DiscountType
     */
    public function setCODE($CODE)
    {
      $this->CODE = $CODE;
      return $this;
    }

    /**
     * @return string
     */
    public function getNAME()
    {
      return $this->NAME;
    }

    /**
     * @param string $NAME
     * @return \Visualsoft\DiscountType
     */
    public function setNAME($NAME)
    {
      $this->NAME = $NAME;
      return $this;
    }

    /**
     * @return float
     */
    public function getDISCOUNT_EX_VAT()
    {
      return $this->DISCOUNT_EX_VAT;
    }

    /**
     * @param float $DISCOUNT_EX_VAT
     * @return \Visualsoft\DiscountType
     */
    public function setDISCOUNT_EX_VAT($DISCOUNT_EX_VAT)
    {
      $this->DISCOUNT_EX_VAT = $DISCOUNT_EX_VAT;
      return $this;
    }

    /**
     * @return float
     */
    public function getDISCOUNT_INC_VAT()
    {
      return $this->DISCOUNT_INC_VAT;
    }

    /**
     * @param float $DISCOUNT_INC_VAT
     * @return \Visualsoft\DiscountType
     */
    public function setDISCOUNT_INC_VAT($DISCOUNT_INC_VAT)
    {
      $this->DISCOUNT_INC_VAT = $DISCOUNT_INC_VAT;
      return $this;
    }

    /**
     * @return float
     */
    public function getDISCOUNT_VAT()
    {
      return $this->DISCOUNT_VAT;
    }

    /**
     * @param float $DISCOUNT_VAT
     * @return \Visualsoft\DiscountType
     */
    public function setDISCOUNT_VAT($DISCOUNT_VAT)
    {
      $this->DISCOUNT_VAT = $DISCOUNT_VAT;
      return $this;
    }

}
