<?php

namespace Visualsoft;

class CollectPlusType
{

    /**
     * @var string $SITE_CODE
     */
    protected $SITE_CODE = null;

    /**
     * @var string $SITE_NUMBER
     */
    protected $SITE_NUMBER = null;

    /**
     * @var string $CONTACT_STRATEGY
     */
    protected $CONTACT_STRATEGY = null;

    /**
     * @var string $SERVICE_CODE
     */
    protected $SERVICE_CODE = null;

    /**
     * @var CollectPlusLabelType $COLLECTPLUS_LABEL
     */
    protected $COLLECTPLUS_LABEL = null;

    /**
     * @param string $SITE_CODE
     * @param string $SITE_NUMBER
     * @param string $CONTACT_STRATEGY
     * @param string $SERVICE_CODE
     */
    public function __construct($SITE_CODE, $SITE_NUMBER, $CONTACT_STRATEGY, $SERVICE_CODE)
    {
      $this->SITE_CODE = $SITE_CODE;
      $this->SITE_NUMBER = $SITE_NUMBER;
      $this->CONTACT_STRATEGY = $CONTACT_STRATEGY;
      $this->SERVICE_CODE = $SERVICE_CODE;
    }

    /**
     * @return string
     */
    public function getSITE_CODE()
    {
      return $this->SITE_CODE;
    }

    /**
     * @param string $SITE_CODE
     * @return \Visualsoft\CollectPlusType
     */
    public function setSITE_CODE($SITE_CODE)
    {
      $this->SITE_CODE = $SITE_CODE;
      return $this;
    }

    /**
     * @return string
     */
    public function getSITE_NUMBER()
    {
      return $this->SITE_NUMBER;
    }

    /**
     * @param string $SITE_NUMBER
     * @return \Visualsoft\CollectPlusType
     */
    public function setSITE_NUMBER($SITE_NUMBER)
    {
      $this->SITE_NUMBER = $SITE_NUMBER;
      return $this;
    }

    /**
     * @return string
     */
    public function getCONTACT_STRATEGY()
    {
      return $this->CONTACT_STRATEGY;
    }

    /**
     * @param string $CONTACT_STRATEGY
     * @return \Visualsoft\CollectPlusType
     */
    public function setCONTACT_STRATEGY($CONTACT_STRATEGY)
    {
      $this->CONTACT_STRATEGY = $CONTACT_STRATEGY;
      return $this;
    }

    /**
     * @return string
     */
    public function getSERVICE_CODE()
    {
      return $this->SERVICE_CODE;
    }

    /**
     * @param string $SERVICE_CODE
     * @return \Visualsoft\CollectPlusType
     */
    public function setSERVICE_CODE($SERVICE_CODE)
    {
      $this->SERVICE_CODE = $SERVICE_CODE;
      return $this;
    }

    /**
     * @return CollectPlusLabelType
     */
    public function getCOLLECTPLUS_LABEL()
    {
      return $this->COLLECTPLUS_LABEL;
    }

    /**
     * @param CollectPlusLabelType $COLLECTPLUS_LABEL
     * @return \Visualsoft\CollectPlusType
     */
    public function setCOLLECTPLUS_LABEL($COLLECTPLUS_LABEL)
    {
      $this->COLLECTPLUS_LABEL = $COLLECTPLUS_LABEL;
      return $this;
    }

}
