<?php

namespace Visualsoft;

class ArrayOfTradeProducts implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var TradeProduct[] $PRODUCT
     */
    protected $PRODUCT = null;

    /**
     * @param TradeProduct[] $PRODUCT
     */
    public function __construct(array $PRODUCT)
    {
      $this->PRODUCT = $PRODUCT;
    }

    /**
     * @return TradeProduct[]
     */
    public function getPRODUCT()
    {
      return $this->PRODUCT;
    }

    /**
     * @param TradeProduct[] $PRODUCT
     * @return \Visualsoft\ArrayOfTradeProducts
     */
    public function setPRODUCT(array $PRODUCT)
    {
      $this->PRODUCT = $PRODUCT;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->PRODUCT[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return TradeProduct
     */
    public function offsetGet($offset)
    {
      return $this->PRODUCT[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param TradeProduct $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->PRODUCT[] = $value;
      } else {
        $this->PRODUCT[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->PRODUCT[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return TradeProduct Return the current element
     */
    public function current()
    {
      return current($this->PRODUCT);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->PRODUCT);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->PRODUCT);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->PRODUCT);
    }

    /**
     * Countable implementation
     *
     * @return TradeProduct Return count of elements
     */
    public function count()
    {
      return count($this->PRODUCT);
    }

}
