<?php

namespace Visualsoft;

class ArrayOfCustomerGroups implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var CustomerGroupType[] $CUSTOMER_GROUP
     */
    protected $CUSTOMER_GROUP = null;

    /**
     * @param CustomerGroupType[] $CUSTOMER_GROUP
     */
    public function __construct(array $CUSTOMER_GROUP)
    {
      $this->CUSTOMER_GROUP = $CUSTOMER_GROUP;
    }

    /**
     * @return CustomerGroupType[]
     */
    public function getCUSTOMER_GROUP()
    {
      return $this->CUSTOMER_GROUP;
    }

    /**
     * @param CustomerGroupType[] $CUSTOMER_GROUP
     * @return \Visualsoft\ArrayOfCustomerGroups
     */
    public function setCUSTOMER_GROUP(array $CUSTOMER_GROUP)
    {
      $this->CUSTOMER_GROUP = $CUSTOMER_GROUP;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->CUSTOMER_GROUP[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return CustomerGroupType
     */
    public function offsetGet($offset)
    {
      return $this->CUSTOMER_GROUP[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param CustomerGroupType $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->CUSTOMER_GROUP[] = $value;
      } else {
        $this->CUSTOMER_GROUP[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->CUSTOMER_GROUP[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return CustomerGroupType Return the current element
     */
    public function current()
    {
      return current($this->CUSTOMER_GROUP);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->CUSTOMER_GROUP);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->CUSTOMER_GROUP);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->CUSTOMER_GROUP);
    }

    /**
     * Countable implementation
     *
     * @return CustomerGroupType Return count of elements
     */
    public function count()
    {
      return count($this->CUSTOMER_GROUP);
    }

}
